import{s as da,o as ca,n as tr}from"../chunks/scheduler.9991993c.js";import{S as ma,i as pa,g as l,s,r as p,A as fa,h as i,f as t,c as o,j as $,u as f,x as d,k as b,y as a,a as n,v as u,d as h,t as g,w as _}from"../chunks/index.7fc9a5e7.js";import{T as lo}from"../chunks/Tip.9de92fc6.js";import{D as M}from"../chunks/Docstring.0d7e3ebb.js";import{C as sr}from"../chunks/CodeBlock.e11cba92.js";import{E as io}from"../chunks/ExampleCodeBlock.46b9776a.js";import{H as pe,E as ua}from"../chunks/EditOnGithub.84ab7f0e.js";function ha(J){let c,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/v4.41.2/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/v4.41.2/zh/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=T},l(v){c=i(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-1u2gxbj"&&(c.innerHTML=T)},m(v,x){n(v,c,x)},p:tr,d(v){v&&t(c)}}}function ga(J){let c,T="Examples:",v,x,C;return x=new sr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,v=s(),p(x.$$.fragment)},l(m){c=i(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=o(m),f(x.$$.fragment,m)},m(m,I){n(m,c,I),n(m,v,I),u(x,m,I),C=!0},p:tr,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function _a(J){let c,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=l("p"),c.textContent=T},l(v){c=i(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-15rpg4"&&(c.textContent=T)},m(v,x){n(v,c,x)},p:tr,d(v){v&&t(c)}}}function va(J){let c,T=`This class method is simply calling <a href="/docs/transformers/v4.41.2/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.41.2/zh/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=l("p"),c.innerHTML=T},l(v){c=i(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-20ix22"&&(c.innerHTML=T)},m(v,x){n(v,c,x)},p:tr,d(v){v&&t(c)}}}function xa(J){let c,T="Examples:",v,x,C;return x=new sr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,v=s(),p(x.$$.fragment)},l(m){c=i(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=o(m),f(x.$$.fragment,m)},m(m,I){n(m,c,I),n(m,v,I),u(x,m,I),C=!0},p:tr,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function $a(J){let c,T="Example:",v,x,C;return x=new sr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=l("p"),c.textContent=T,v=s(),p(x.$$.fragment)},l(m){c=i(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=T),v=o(m),f(x.$$.fragment,m)},m(m,I){n(m,c,I),n(m,v,I),u(x,m,I),C=!0},p:tr,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function ba(J){let c,T,v,x,C,m,I,co="在 Transformers 库中，processors可以有两种不同的含义：",or,fe,mo='<li>为多模态模型，例如<a href="../model_doc/wav2vec2">Wav2Vec2</a>（语音和文本）或<a href="../model_doc/clip">CLIP</a>（文本和视觉）预处理输入的对象</li> <li>在库的旧版本中用于预处理GLUE或SQUAD数据的已弃用对象。</li>',ar,ue,nr,he,po="任何多模态模型都需要一个对象来编码或解码将多个模态（包括文本、视觉和音频）组合在一起的数据。这由称为processors的对象处理，这些processors将两个或多个处理对象组合在一起，例如tokenizers（用于文本模态），image processors（用于视觉）和feature extractors（用于音频）。",lr,ge,fo="这些processors继承自以下实现保存和加载功能的基类：",ir,y,_e,is,Mt,uo="This is a mixin used to provide saving/loading functionality for all processor classes.",ds,D,ve,cs,wt,ho="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",ms,j,xe,ps,Tt,go="Instantiate a processor associated with a pretrained model.",fs,G,us,R,$e,hs,Ct,_o=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,gs,z,be,_s,Pt,vo="Upload the processor files to the 🤗 Model Hub.",vs,W,xs,V,ye,$s,It,xo=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,bs,Q,ys,q,Me,Ms,Xt,$o=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/v4.41.2/zh/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,ws,Y,Ts,A,we,Cs,kt,bo="Serializes this instance to a Python dictionary.",Ps,O,Te,Is,Jt,yo="Save this instance to a JSON file.",Xs,K,Ce,ks,Ut,Mo="Serializes this instance to a JSON string.",dr,Pe,cr,Ie,wo='所有processor都遵循与 <a href="/docs/transformers/v4.41.2/zh/main_classes/processors#transformers.DataProcessor">DataProcessor</a> 相同的架构。processor返回一个 <a href="/docs/transformers/v4.41.2/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。这些 <a href="/docs/transformers/v4.41.2/zh/main_classes/processors#transformers.InputExample">InputExample</a> 可以转换为 <a href="/docs/transformers/v4.41.2/zh/main_classes/processors#transformers.InputFeatures">InputFeatures</a> 以供输送到模型。',mr,P,Xe,Js,Zt,To="Base class for data converters for sequence classification data sets.",Us,ee,ke,Zs,Lt,Co='Gets a collection of <a href="/docs/transformers/v4.41.2/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Ls,te,Je,js,jt,Po="Gets an example from a dict with tensorflow tensors.",zs,re,Ue,Vs,zt,Io="Gets the list of labels for this data set.",qs,se,Ze,Es,Vt,Xo='Gets a collection of <a href="/docs/transformers/v4.41.2/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',Hs,oe,Le,Ns,qt,ko='Gets a collection of <a href="/docs/transformers/v4.41.2/zh/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Bs,ae,je,Fs,Et,Jo=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,pr,U,ze,Ss,Ht,Uo="A single training/test example for simple sequence classification.",Ds,ne,Ve,Gs,Nt,Zo="Serializes this instance to a JSON string.",fr,Z,qe,Rs,Bt,Lo="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",Ws,le,Ee,Qs,Ft,jo="Serializes this instance to a JSON string.",ur,He,hr,Ne,zo='<a href="https://gluebenchmark.com/" rel="nofollow">General Language Understanding Evaluation (GLUE)</a> 是一个基准测试，评估模型在各种现有的自然语言理解任务上的性能。它与论文 <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A multi-task benchmark and analysis platform for natural language understanding</a> 一同发布。',gr,Be,Vo="该库为以下任务提供了总共10个processor：MRPC、MNLI、MNLI（mismatched）、CoLA、SST2、STSB、QQP、QNLI、RTE 和 WNLI。",_r,Fe,qo="这些processor是：",vr,Se,Eo="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",xr,De,Ho='此外，还可以使用以下方法从数据文件加载值并将其转换为 <a href="/docs/transformers/v4.41.2/zh/main_classes/processors#transformers.InputExample">InputExample</a> 列表。',$r,N,Ge,Ys,St,No="Loads a data file into a list of <code>InputFeatures</code>",br,Re,yr,We,Bo='<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">跨语言NLI语料库（XNLI）</a> 是一个评估跨语言文本表示质量的基准测试。XNLI是一个基于<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a>的众包数据集：”文本对“被标记为包含15种不同语言（包括英语等高资源语言和斯瓦希里语等低资源语言）的文本蕴涵注释。',Mr,Qe,Fo='它与论文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> 一同发布。',wr,Ye,So="该库提供了加载XNLI数据的processor：",Tr,Ae,Do="<li><code>~data.processors.utils.XnliProcessor</code></li>",Cr,Oe,Go="请注意，由于测试集上有“gold”标签，因此评估是在测试集上进行的。",Pr,Ke,Ro='使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> 脚本中提供。',Ir,et,Xr,tt,Wo='<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">斯坦福问答数据集（SQuAD）</a> 是一个评估模型在问答上性能的基准测试。有两个版本，v1.1 和 v2.0。第一个版本（v1.1）与论文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ Questions for Machine Comprehension of Text</a> 一同发布。第二个版本（v2.0）与论文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t Know: Unanswerable Questions for SQuAD</a> 一同发布。',kr,rt,Qo="该库为两个版本各自提供了一个processor：",Jr,st,Ur,ot,Yo="这两个processor是：",Zr,at,Ao="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",Lr,nt,Oo="它们都继承自抽象类 <code>~data.processors.utils.SquadProcessor</code>。",jr,k,lt,As,Dt,Ko=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,Os,ie,it,Ks,Gt,ea="Returns the evaluation example from the data directory.",eo,E,dt,to,Rt,ta="Creates a list of <code>SquadExample</code> using a TFDS dataset.",ro,de,so,ce,ct,oo,Wt,ra="Returns the training examples from the data directory.",zr,mt,sa="此外，可以使用以下方法将 SQuAD 示例转换为可用作模型输入的 <code>~data.processors.utils.SquadFeatures</code>。",Vr,L,pt,ao,Qt,oa=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,no,me,qr,ft,aa="这些processor以及前面提到的方法可以与包含数据的文件以及tensorflow_datasets包一起使用。下面给出了示例。",Er,ut,Hr,ht,na="以下是使用processor以及使用数据文件的转换方法的示例：",Nr,gt,Br,_t,la="使用 <em>tensorflow_datasets</em> 就像使用数据文件一样简单：",Fr,vt,Sr,xt,ia='另一个使用这些processor的示例在 <a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> 脚本中提供。',Dr,$t,Gr,rr,Rr;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"多模态processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/processing_utils.py#L56"}}),ve=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/processing_utils.py#L365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),xe=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.41.2/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/v4.41.2/zh/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/processing_utils.py#L406"}}),G=new lo({props:{$$slots:{default:[ha]},$$scope:{ctx:J}}}),$e=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/processing_utils.py#L256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),be=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/utils/hub.py#L770"}}),W=new io({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[ga]},$$scope:{ctx:J}}}),ye=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/processing_utils.py#L470"}}),Q=new lo({props:{warning:!0,$$slots:{default:[_a]},$$scope:{ctx:J}}}),Me=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.41.2/zh/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/processing_utils.py#L167"}}),Y=new lo({props:{$$slots:{default:[va]},$$scope:{ctx:J}}}),we=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/processing_utils.py#L102",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Te=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/processing_utils.py#L151"}}),Ce=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/processing_utils.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Pe=new pe({props:{title:"已弃用的processors",local:"transformers.DataProcessor",headingTag:"h2"}}),Xe=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L80"}}),ke=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L97"}}),Je=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L83"}}),Ue=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L105"}}),Ze=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L101"}}),Le=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L93"}}),je=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L109"}}),ze=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L29"}}),Ve=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L49"}}),qe=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L54"}}),Ee=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/utils.py#L75"}}),He=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Ge=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),Re=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),et=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),st=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),lt=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/squad.py#L541"}}),it=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/squad.py#L629"}}),dt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),de=new io({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[xa]},$$scope:{ctx:J}}}),ct=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/squad.py#L607"}}),pt=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/v4.41.2/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),me=new io({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[$a]},$$scope:{ctx:J}}}),ut=new pe({props:{title:"Example使用",local:"example使用",headingTag:"h3"}}),gt=new sr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),vt=new sr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),$t=new ua({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/zh/main_classes/processors.md"}}),{c(){c=l("meta"),T=s(),v=l("p"),x=s(),p(C.$$.fragment),m=s(),I=l("p"),I.textContent=co,or=s(),fe=l("ul"),fe.innerHTML=mo,ar=s(),p(ue.$$.fragment),nr=s(),he=l("p"),he.textContent=po,lr=s(),ge=l("p"),ge.textContent=fo,ir=s(),y=l("div"),p(_e.$$.fragment),is=s(),Mt=l("p"),Mt.textContent=uo,ds=s(),D=l("div"),p(ve.$$.fragment),cs=s(),wt=l("p"),wt.innerHTML=ho,ms=s(),j=l("div"),p(xe.$$.fragment),ps=s(),Tt=l("p"),Tt.textContent=go,fs=s(),p(G.$$.fragment),us=s(),R=l("div"),p($e.$$.fragment),hs=s(),Ct=l("p"),Ct.innerHTML=_o,gs=s(),z=l("div"),p(be.$$.fragment),_s=s(),Pt=l("p"),Pt.textContent=vo,vs=s(),p(W.$$.fragment),xs=s(),V=l("div"),p(ye.$$.fragment),$s=s(),It=l("p"),It.innerHTML=xo,bs=s(),p(Q.$$.fragment),ys=s(),q=l("div"),p(Me.$$.fragment),Ms=s(),Xt=l("p"),Xt.innerHTML=$o,ws=s(),p(Y.$$.fragment),Ts=s(),A=l("div"),p(we.$$.fragment),Cs=s(),kt=l("p"),kt.textContent=bo,Ps=s(),O=l("div"),p(Te.$$.fragment),Is=s(),Jt=l("p"),Jt.textContent=yo,Xs=s(),K=l("div"),p(Ce.$$.fragment),ks=s(),Ut=l("p"),Ut.textContent=Mo,dr=s(),p(Pe.$$.fragment),cr=s(),Ie=l("p"),Ie.innerHTML=wo,mr=s(),P=l("div"),p(Xe.$$.fragment),Js=s(),Zt=l("p"),Zt.textContent=To,Us=s(),ee=l("div"),p(ke.$$.fragment),Zs=s(),Lt=l("p"),Lt.innerHTML=Co,Ls=s(),te=l("div"),p(Je.$$.fragment),js=s(),jt=l("p"),jt.textContent=Po,zs=s(),re=l("div"),p(Ue.$$.fragment),Vs=s(),zt=l("p"),zt.textContent=Io,qs=s(),se=l("div"),p(Ze.$$.fragment),Es=s(),Vt=l("p"),Vt.innerHTML=Xo,Hs=s(),oe=l("div"),p(Le.$$.fragment),Ns=s(),qt=l("p"),qt.innerHTML=ko,Bs=s(),ae=l("div"),p(je.$$.fragment),Fs=s(),Et=l("p"),Et.textContent=Jo,pr=s(),U=l("div"),p(ze.$$.fragment),Ss=s(),Ht=l("p"),Ht.textContent=Uo,Ds=s(),ne=l("div"),p(Ve.$$.fragment),Gs=s(),Nt=l("p"),Nt.textContent=Zo,fr=s(),Z=l("div"),p(qe.$$.fragment),Rs=s(),Bt=l("p"),Bt.textContent=Lo,Ws=s(),le=l("div"),p(Ee.$$.fragment),Qs=s(),Ft=l("p"),Ft.textContent=jo,ur=s(),p(He.$$.fragment),hr=s(),Ne=l("p"),Ne.innerHTML=zo,gr=s(),Be=l("p"),Be.textContent=Vo,_r=s(),Fe=l("p"),Fe.textContent=qo,vr=s(),Se=l("ul"),Se.innerHTML=Eo,xr=s(),De=l("p"),De.innerHTML=Ho,$r=s(),N=l("div"),p(Ge.$$.fragment),Ys=s(),St=l("p"),St.innerHTML=No,br=s(),p(Re.$$.fragment),yr=s(),We=l("p"),We.innerHTML=Bo,Mr=s(),Qe=l("p"),Qe.innerHTML=Fo,wr=s(),Ye=l("p"),Ye.textContent=So,Tr=s(),Ae=l("ul"),Ae.innerHTML=Do,Cr=s(),Oe=l("p"),Oe.textContent=Go,Pr=s(),Ke=l("p"),Ke.innerHTML=Ro,Ir=s(),p(et.$$.fragment),Xr=s(),tt=l("p"),tt.innerHTML=Wo,kr=s(),rt=l("p"),rt.textContent=Qo,Jr=s(),p(st.$$.fragment),Ur=s(),ot=l("p"),ot.textContent=Yo,Zr=s(),at=l("ul"),at.innerHTML=Ao,Lr=s(),nt=l("p"),nt.innerHTML=Oo,jr=s(),k=l("div"),p(lt.$$.fragment),As=s(),Dt=l("p"),Dt.textContent=Ko,Os=s(),ie=l("div"),p(it.$$.fragment),Ks=s(),Gt=l("p"),Gt.textContent=ea,eo=s(),E=l("div"),p(dt.$$.fragment),to=s(),Rt=l("p"),Rt.innerHTML=ta,ro=s(),p(de.$$.fragment),so=s(),ce=l("div"),p(ct.$$.fragment),oo=s(),Wt=l("p"),Wt.textContent=ra,zr=s(),mt=l("p"),mt.innerHTML=sa,Vr=s(),L=l("div"),p(pt.$$.fragment),ao=s(),Qt=l("p"),Qt.textContent=oa,no=s(),p(me.$$.fragment),qr=s(),ft=l("p"),ft.textContent=aa,Er=s(),p(ut.$$.fragment),Hr=s(),ht=l("p"),ht.textContent=na,Nr=s(),p(gt.$$.fragment),Br=s(),_t=l("p"),_t.innerHTML=la,Fr=s(),p(vt.$$.fragment),Sr=s(),xt=l("p"),xt.innerHTML=ia,Dr=s(),p($t.$$.fragment),Gr=s(),rr=l("p"),this.h()},l(e){const r=fa("svelte-u9bgzb",document.head);c=i(r,"META",{name:!0,content:!0}),r.forEach(t),T=o(e),v=i(e,"P",{}),$(v).forEach(t),x=o(e),f(C.$$.fragment,e),m=o(e),I=i(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1fd9lf0"&&(I.textContent=co),or=o(e),fe=i(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-rmvfpp"&&(fe.innerHTML=mo),ar=o(e),f(ue.$$.fragment,e),nr=o(e),he=i(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-ctzpmo"&&(he.textContent=po),lr=o(e),ge=i(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-9fh2y4"&&(ge.textContent=fo),ir=o(e),y=i(e,"DIV",{class:!0});var w=$(y);f(_e.$$.fragment,w),is=o(w),Mt=i(w,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1s4wckx"&&(Mt.textContent=uo),ds=o(w),D=i(w,"DIV",{class:!0});var bt=$(D);f(ve.$$.fragment,bt),cs=o(bt),wt=i(bt,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1i2d3vx"&&(wt.innerHTML=ho),bt.forEach(t),ms=o(w),j=i(w,"DIV",{class:!0});var B=$(j);f(xe.$$.fragment,B),ps=o(B),Tt=i(B,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-1cj8dcb"&&(Tt.textContent=go),fs=o(B),f(G.$$.fragment,B),B.forEach(t),us=o(w),R=i(w,"DIV",{class:!0});var yt=$(R);f($e.$$.fragment,yt),hs=o(yt),Ct=i(yt,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-hsvutq"&&(Ct.innerHTML=_o),yt.forEach(t),gs=o(w),z=i(w,"DIV",{class:!0});var F=$(z);f(be.$$.fragment,F),_s=o(F),Pt=i(F,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-1cwsjho"&&(Pt.textContent=vo),vs=o(F),f(W.$$.fragment,F),F.forEach(t),xs=o(w),V=i(w,"DIV",{class:!0});var S=$(V);f(ye.$$.fragment,S),$s=o(S),It=i(S,"P",{"data-svelte-h":!0}),d(It)!=="svelte-hhsvto"&&(It.innerHTML=xo),bs=o(S),f(Q.$$.fragment,S),S.forEach(t),ys=o(w),q=i(w,"DIV",{class:!0});var Yt=$(q);f(Me.$$.fragment,Yt),Ms=o(Yt),Xt=i(Yt,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-4ykv9o"&&(Xt.innerHTML=$o),ws=o(Yt),f(Y.$$.fragment,Yt),Yt.forEach(t),Ts=o(w),A=i(w,"DIV",{class:!0});var Wr=$(A);f(we.$$.fragment,Wr),Cs=o(Wr),kt=i(Wr,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1ww3wqq"&&(kt.textContent=bo),Wr.forEach(t),Ps=o(w),O=i(w,"DIV",{class:!0});var Qr=$(O);f(Te.$$.fragment,Qr),Is=o(Qr),Jt=i(Qr,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1g70y32"&&(Jt.textContent=yo),Qr.forEach(t),Xs=o(w),K=i(w,"DIV",{class:!0});var Yr=$(K);f(Ce.$$.fragment,Yr),ks=o(Yr),Ut=i(Yr,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-5ayq1f"&&(Ut.textContent=Mo),Yr.forEach(t),w.forEach(t),dr=o(e),f(Pe.$$.fragment,e),cr=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-th1qdm"&&(Ie.innerHTML=wo),mr=o(e),P=i(e,"DIV",{class:!0});var X=$(P);f(Xe.$$.fragment,X),Js=o(X),Zt=i(X,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-1bsw04k"&&(Zt.textContent=To),Us=o(X),ee=i(X,"DIV",{class:!0});var Ar=$(ee);f(ke.$$.fragment,Ar),Zs=o(Ar),Lt=i(Ar,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1pg1iwb"&&(Lt.innerHTML=Co),Ar.forEach(t),Ls=o(X),te=i(X,"DIV",{class:!0});var Or=$(te);f(Je.$$.fragment,Or),js=o(Or),jt=i(Or,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-pplryq"&&(jt.textContent=Po),Or.forEach(t),zs=o(X),re=i(X,"DIV",{class:!0});var Kr=$(re);f(Ue.$$.fragment,Kr),Vs=o(Kr),zt=i(Kr,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-3oqyjr"&&(zt.textContent=Io),Kr.forEach(t),qs=o(X),se=i(X,"DIV",{class:!0});var es=$(se);f(Ze.$$.fragment,es),Es=o(es),Vt=i(es,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-1d28ubq"&&(Vt.innerHTML=Xo),es.forEach(t),Hs=o(X),oe=i(X,"DIV",{class:!0});var ts=$(oe);f(Le.$$.fragment,ts),Ns=o(ts),qt=i(ts,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-1gbchhw"&&(qt.innerHTML=ko),ts.forEach(t),Bs=o(X),ae=i(X,"DIV",{class:!0});var rs=$(ae);f(je.$$.fragment,rs),Fs=o(rs),Et=i(rs,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-1jevh15"&&(Et.textContent=Jo),rs.forEach(t),X.forEach(t),pr=o(e),U=i(e,"DIV",{class:!0});var At=$(U);f(ze.$$.fragment,At),Ss=o(At),Ht=i(At,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-vkt0pi"&&(Ht.textContent=Uo),Ds=o(At),ne=i(At,"DIV",{class:!0});var ss=$(ne);f(Ve.$$.fragment,ss),Gs=o(ss),Nt=i(ss,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-5ayq1f"&&(Nt.textContent=Zo),ss.forEach(t),At.forEach(t),fr=o(e),Z=i(e,"DIV",{class:!0});var Ot=$(Z);f(qe.$$.fragment,Ot),Rs=o(Ot),Bt=i(Ot,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-168wf64"&&(Bt.textContent=Lo),Ws=o(Ot),le=i(Ot,"DIV",{class:!0});var os=$(le);f(Ee.$$.fragment,os),Qs=o(os),Ft=i(os,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-5ayq1f"&&(Ft.textContent=jo),os.forEach(t),Ot.forEach(t),ur=o(e),f(He.$$.fragment,e),hr=o(e),Ne=i(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-pf4p60"&&(Ne.innerHTML=zo),gr=o(e),Be=i(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-17867sm"&&(Be.textContent=Vo),_r=o(e),Fe=i(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-190jb0p"&&(Fe.textContent=qo),vr=o(e),Se=i(e,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-my8qym"&&(Se.innerHTML=Eo),xr=o(e),De=i(e,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1u8l035"&&(De.innerHTML=Ho),$r=o(e),N=i(e,"DIV",{class:!0});var as=$(N);f(Ge.$$.fragment,as),Ys=o(as),St=i(as,"P",{"data-svelte-h":!0}),d(St)!=="svelte-5lvrve"&&(St.innerHTML=No),as.forEach(t),br=o(e),f(Re.$$.fragment,e),yr=o(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-143feg"&&(We.innerHTML=Bo),Mr=o(e),Qe=i(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1y5f8bi"&&(Qe.innerHTML=Fo),wr=o(e),Ye=i(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1n6xg4v"&&(Ye.textContent=So),Tr=o(e),Ae=i(e,"UL",{"data-svelte-h":!0}),d(Ae)!=="svelte-1e2xq99"&&(Ae.innerHTML=Do),Cr=o(e),Oe=i(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1514ut0"&&(Oe.textContent=Go),Pr=o(e),Ke=i(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-18t4sjl"&&(Ke.innerHTML=Ro),Ir=o(e),f(et.$$.fragment,e),Xr=o(e),tt=i(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1cqsmed"&&(tt.innerHTML=Wo),kr=o(e),rt=i(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1hd0jdd"&&(rt.textContent=Qo),Jr=o(e),f(st.$$.fragment,e),Ur=o(e),ot=i(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-utkcp6"&&(ot.textContent=Yo),Zr=o(e),at=i(e,"UL",{"data-svelte-h":!0}),d(at)!=="svelte-1qiv3qf"&&(at.innerHTML=Ao),Lr=o(e),nt=i(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-165sa1k"&&(nt.innerHTML=Oo),jr=o(e),k=i(e,"DIV",{class:!0});var H=$(k);f(lt.$$.fragment,H),As=o(H),Dt=i(H,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-173gxyd"&&(Dt.textContent=Ko),Os=o(H),ie=i(H,"DIV",{class:!0});var ns=$(ie);f(it.$$.fragment,ns),Ks=o(ns),Gt=i(ns,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-wmaktk"&&(Gt.textContent=ea),ns.forEach(t),eo=o(H),E=i(H,"DIV",{class:!0});var Kt=$(E);f(dt.$$.fragment,Kt),to=o(Kt),Rt=i(Kt,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-11nqnea"&&(Rt.innerHTML=ta),ro=o(Kt),f(de.$$.fragment,Kt),Kt.forEach(t),so=o(H),ce=i(H,"DIV",{class:!0});var ls=$(ce);f(ct.$$.fragment,ls),oo=o(ls),Wt=i(ls,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-d5zv1x"&&(Wt.textContent=ra),ls.forEach(t),H.forEach(t),zr=o(e),mt=i(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-7uap0d"&&(mt.innerHTML=sa),Vr=o(e),L=i(e,"DIV",{class:!0});var er=$(L);f(pt.$$.fragment,er),ao=o(er),Qt=i(er,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-169nh0g"&&(Qt.textContent=oa),no=o(er),f(me.$$.fragment,er),er.forEach(t),qr=o(e),ft=i(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1dp3thd"&&(ft.textContent=aa),Er=o(e),f(ut.$$.fragment,e),Hr=o(e),ht=i(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1tuty7g"&&(ht.textContent=na),Nr=o(e),f(gt.$$.fragment,e),Br=o(e),_t=i(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-1klp1tb"&&(_t.innerHTML=la),Fr=o(e),f(vt.$$.fragment,e),Sr=o(e),xt=i(e,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-1mzejoo"&&(xt.innerHTML=ia),Dr=o(e),f($t.$$.fragment,e),Gr=o(e),rr=i(e,"P",{}),$(rr).forEach(t),this.h()},h(){b(c,"name","hf:doc:metadata"),b(c,"content",ya),b(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){a(document.head,c),n(e,T,r),n(e,v,r),n(e,x,r),u(C,e,r),n(e,m,r),n(e,I,r),n(e,or,r),n(e,fe,r),n(e,ar,r),u(ue,e,r),n(e,nr,r),n(e,he,r),n(e,lr,r),n(e,ge,r),n(e,ir,r),n(e,y,r),u(_e,y,null),a(y,is),a(y,Mt),a(y,ds),a(y,D),u(ve,D,null),a(D,cs),a(D,wt),a(y,ms),a(y,j),u(xe,j,null),a(j,ps),a(j,Tt),a(j,fs),u(G,j,null),a(y,us),a(y,R),u($e,R,null),a(R,hs),a(R,Ct),a(y,gs),a(y,z),u(be,z,null),a(z,_s),a(z,Pt),a(z,vs),u(W,z,null),a(y,xs),a(y,V),u(ye,V,null),a(V,$s),a(V,It),a(V,bs),u(Q,V,null),a(y,ys),a(y,q),u(Me,q,null),a(q,Ms),a(q,Xt),a(q,ws),u(Y,q,null),a(y,Ts),a(y,A),u(we,A,null),a(A,Cs),a(A,kt),a(y,Ps),a(y,O),u(Te,O,null),a(O,Is),a(O,Jt),a(y,Xs),a(y,K),u(Ce,K,null),a(K,ks),a(K,Ut),n(e,dr,r),u(Pe,e,r),n(e,cr,r),n(e,Ie,r),n(e,mr,r),n(e,P,r),u(Xe,P,null),a(P,Js),a(P,Zt),a(P,Us),a(P,ee),u(ke,ee,null),a(ee,Zs),a(ee,Lt),a(P,Ls),a(P,te),u(Je,te,null),a(te,js),a(te,jt),a(P,zs),a(P,re),u(Ue,re,null),a(re,Vs),a(re,zt),a(P,qs),a(P,se),u(Ze,se,null),a(se,Es),a(se,Vt),a(P,Hs),a(P,oe),u(Le,oe,null),a(oe,Ns),a(oe,qt),a(P,Bs),a(P,ae),u(je,ae,null),a(ae,Fs),a(ae,Et),n(e,pr,r),n(e,U,r),u(ze,U,null),a(U,Ss),a(U,Ht),a(U,Ds),a(U,ne),u(Ve,ne,null),a(ne,Gs),a(ne,Nt),n(e,fr,r),n(e,Z,r),u(qe,Z,null),a(Z,Rs),a(Z,Bt),a(Z,Ws),a(Z,le),u(Ee,le,null),a(le,Qs),a(le,Ft),n(e,ur,r),u(He,e,r),n(e,hr,r),n(e,Ne,r),n(e,gr,r),n(e,Be,r),n(e,_r,r),n(e,Fe,r),n(e,vr,r),n(e,Se,r),n(e,xr,r),n(e,De,r),n(e,$r,r),n(e,N,r),u(Ge,N,null),a(N,Ys),a(N,St),n(e,br,r),u(Re,e,r),n(e,yr,r),n(e,We,r),n(e,Mr,r),n(e,Qe,r),n(e,wr,r),n(e,Ye,r),n(e,Tr,r),n(e,Ae,r),n(e,Cr,r),n(e,Oe,r),n(e,Pr,r),n(e,Ke,r),n(e,Ir,r),u(et,e,r),n(e,Xr,r),n(e,tt,r),n(e,kr,r),n(e,rt,r),n(e,Jr,r),u(st,e,r),n(e,Ur,r),n(e,ot,r),n(e,Zr,r),n(e,at,r),n(e,Lr,r),n(e,nt,r),n(e,jr,r),n(e,k,r),u(lt,k,null),a(k,As),a(k,Dt),a(k,Os),a(k,ie),u(it,ie,null),a(ie,Ks),a(ie,Gt),a(k,eo),a(k,E),u(dt,E,null),a(E,to),a(E,Rt),a(E,ro),u(de,E,null),a(k,so),a(k,ce),u(ct,ce,null),a(ce,oo),a(ce,Wt),n(e,zr,r),n(e,mt,r),n(e,Vr,r),n(e,L,r),u(pt,L,null),a(L,ao),a(L,Qt),a(L,no),u(me,L,null),n(e,qr,r),n(e,ft,r),n(e,Er,r),u(ut,e,r),n(e,Hr,r),n(e,ht,r),n(e,Nr,r),u(gt,e,r),n(e,Br,r),n(e,_t,r),n(e,Fr,r),u(vt,e,r),n(e,Sr,r),n(e,xt,r),n(e,Dr,r),u($t,e,r),n(e,Gr,r),n(e,rr,r),Rr=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),G.$set(w);const bt={};r&2&&(bt.$$scope={dirty:r,ctx:e}),W.$set(bt);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),Q.$set(B);const yt={};r&2&&(yt.$$scope={dirty:r,ctx:e}),Y.$set(yt);const F={};r&2&&(F.$$scope={dirty:r,ctx:e}),de.$set(F);const S={};r&2&&(S.$$scope={dirty:r,ctx:e}),me.$set(S)},i(e){Rr||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(G.$$.fragment,e),h($e.$$.fragment,e),h(be.$$.fragment,e),h(W.$$.fragment,e),h(ye.$$.fragment,e),h(Q.$$.fragment,e),h(Me.$$.fragment,e),h(Y.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(Xe.$$.fragment,e),h(ke.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(Ze.$$.fragment,e),h(Le.$$.fragment,e),h(je.$$.fragment,e),h(ze.$$.fragment,e),h(Ve.$$.fragment,e),h(qe.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Ge.$$.fragment,e),h(Re.$$.fragment,e),h(et.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(de.$$.fragment,e),h(ct.$$.fragment,e),h(pt.$$.fragment,e),h(me.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),h($t.$$.fragment,e),Rr=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(G.$$.fragment,e),g($e.$$.fragment,e),g(be.$$.fragment,e),g(W.$$.fragment,e),g(ye.$$.fragment,e),g(Q.$$.fragment,e),g(Me.$$.fragment,e),g(Y.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(Xe.$$.fragment,e),g(ke.$$.fragment,e),g(Je.$$.fragment,e),g(Ue.$$.fragment,e),g(Ze.$$.fragment,e),g(Le.$$.fragment,e),g(je.$$.fragment,e),g(ze.$$.fragment,e),g(Ve.$$.fragment,e),g(qe.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Ge.$$.fragment,e),g(Re.$$.fragment,e),g(et.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(de.$$.fragment,e),g(ct.$$.fragment,e),g(pt.$$.fragment,e),g(me.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(vt.$$.fragment,e),g($t.$$.fragment,e),Rr=!1},d(e){e&&(t(T),t(v),t(x),t(m),t(I),t(or),t(fe),t(ar),t(nr),t(he),t(lr),t(ge),t(ir),t(y),t(dr),t(cr),t(Ie),t(mr),t(P),t(pr),t(U),t(fr),t(Z),t(ur),t(hr),t(Ne),t(gr),t(Be),t(_r),t(Fe),t(vr),t(Se),t(xr),t(De),t($r),t(N),t(br),t(yr),t(We),t(Mr),t(Qe),t(wr),t(Ye),t(Tr),t(Ae),t(Cr),t(Oe),t(Pr),t(Ke),t(Ir),t(Xr),t(tt),t(kr),t(rt),t(Jr),t(Ur),t(ot),t(Zr),t(at),t(Lr),t(nt),t(jr),t(k),t(zr),t(mt),t(Vr),t(L),t(qr),t(ft),t(Er),t(Hr),t(ht),t(Nr),t(Br),t(_t),t(Fr),t(Sr),t(xt),t(Dr),t(Gr),t(rr)),t(c),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_(G),_($e),_(be),_(W),_(ye),_(Q),_(Me),_(Y),_(we),_(Te),_(Ce),_(Pe,e),_(Xe),_(ke),_(Je),_(Ue),_(Ze),_(Le),_(je),_(ze),_(Ve),_(qe),_(Ee),_(He,e),_(Ge),_(Re,e),_(et,e),_(st,e),_(lt),_(it),_(dt),_(de),_(ct),_(pt),_(me),_(ut,e),_(gt,e),_(vt,e),_($t,e)}}}const ya='{"title":"Processors","local":"processors","sections":[{"title":"多模态processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"已弃用的processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example使用","local":"example使用","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ma(J){return ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ja extends ma{constructor(c){super(),pa(this,c,Ma,ba,da,{})}}export{Ja as component};
