import{s as Zt,o as vt}from"../chunks/scheduler.f7e1785c.js";import{S as Gt,i as Wt,g as M,s as n,r as m,A as Ft,h as p,f as e,c as a,j as gt,u as j,x as i,k as Mt,y as Et,a as s,v as y,d as T,t as c,w as U,m as Yt,n as Xt}from"../chunks/index.9f8f0838.js";import{T as St}from"../chunks/Tip.4575d9cf.js";import{C as u}from"../chunks/CodeBlock.b3510e34.js";import{H as at}from"../chunks/Heading.6643a2f7.js";function Ht(yl){let r;return{c(){r=Yt("💡 关于重采样的背景知识：当信号的原始采样率为8千赫兹时，信号每秒钟会包含8000个采样点，并且我们知道该信号不会包含高于4千赫兹的频率成分。奈奎斯特采样定理保证了这一点。也因此，我们可以确保在两个采样点中间的原始连续信号呈一条平滑的曲线。在这样的条件下，上采样所要做的就只是根据对曲线的估计而计算出两个采样点中间的额外数值。与之相反的是，下采样过程需要我们首先过滤掉所有高于奈奎斯特极限的频率成分，之后才能重新计算采样点。也就是说，我们不能通过简单的每隔一个采样点丢弃一个采样点来进行2倍的下采样：这会造成信号的失真，我们称之为混叠失真。重采样过程十分棘手，因此我们推荐使用经过测试的工具库，例如librosa或🤗 Datasets。")},l(J){r=Xt(J,"💡 关于重采样的背景知识：当信号的原始采样率为8千赫兹时，信号每秒钟会包含8000个采样点，并且我们知道该信号不会包含高于4千赫兹的频率成分。奈奎斯特采样定理保证了这一点。也因此，我们可以确保在两个采样点中间的原始连续信号呈一条平滑的曲线。在这样的条件下，上采样所要做的就只是根据对曲线的估计而计算出两个采样点中间的额外数值。与之相反的是，下采样过程需要我们首先过滤掉所有高于奈奎斯特极限的频率成分，之后才能重新计算采样点。也就是说，我们不能通过简单的每隔一个采样点丢弃一个采样点来进行2倍的下采样：这会造成信号的失真，我们称之为混叠失真。重采样过程十分棘手，因此我们推荐使用经过测试的工具库，例如librosa或🤗 Datasets。")},m(J,w){s(J,r,w)},d(J){J&&e(r)}}}function zt(yl){let r,J,w,Tl,C,cl,h,pt="使用🤗 Datasets加载数据集只是乐趣的一半。如果你计划用数据集训练模型或者运行推理，那么你还需要对数据进行预处理（pre-processing）。数据预处理通常包括以下几步：",Ul,d,it="<li>音频重采样</li> <li>对数据集进行过滤</li> <li>将音频数据转换为模型要求的输入形式</li>",rl,A,ul,I,mt="<code>load_dataset()</code>函数在下载数据集时会保留数据集发布时的原始采样率。当你使用其他模型进行训练或推理时，该采样率也许会不符合要求。当采样率不同时，你可以进行重采样来将数据调整到模型所期望的采样率。",Jl,$,jt="目前大多数的预训练模型采用了16千赫兹采样率的数据集进行预训练。在上一张探索MINDS-14数据集时，你可能注意到了该数据集采用了8千赫兹的采样率，这意味着我们需要对其进行上采样。",ol,b,yt="我们可以使用🤗 Datasets的<code>cast_column()</code>方法进行上采样。该方法不会在原位改动数据，而是在数据加载时进行实时的重采样。下面的代码可以将样本重采样到16千赫兹：",fl,V,wl,_,Tt="现在我们重新加载MINDS-14的第一个样本，并检查其是否按照我们提供的<code>sampling_rate</code>参数进行了重采样：",Cl,R,hl,B,ct="<strong>输出</strong>",dl,k,Al,x,Ut="你可能注意到数列的值也有所变化。这是因为我们在重采样后会获得两倍于原来采样点数量的数值。",Il,o,$l,N,bl,Q,rt="我们可能会需要用一些指标来过滤掉数据集中的一些数据。一种常见情况是限制音频文件的时长。举个例子，我们可能需要过滤掉所有长度超过20秒的音频来防止模型训练过程中的内存不足错误。",Vl,g,ut="我们可以使用🤗 Datasets的<code>filter</code>方法并传入过滤逻辑的函数来进行过滤。首先我们需要编写一个函数来指示哪些样本需要保留，哪些样本需要舍弃。这里我们编写了<code>is_audio_length_in_range()</code>函数，在样本长度小于20秒时会返回<code>True</code>，否则返回<code>False</code>。",_l,Z,Rl,v,Jt="该过滤函数可以直接应用在数据集的列上，但我们的数据集并没有一个单独的记录音频长度的列。不过我们可以自己创建一列，然后进行过滤，最后在过滤完成之后删除该列。",Bl,G,kl,W,ot="<strong>输出</strong>",xl,F,Nl,E,ft="我们可以看到数据集的样本数量从654个被过滤到了624个。",Ql,Y,gl,X,wt="在利用音频数据集时，最具挑战的工作之一便是给模型训练提供正确格式的数据。如你所见，原始的音频数据是一个单列的采样点数组。然而，无论是推理还是根据任务进行微调，大部分的预训练模型都需要将音频数据转化成其对应的输入特征。每个模型的输入特征都有不同的要求，往往根据模型的架构和其预训练的数据集所决定。好消息是，🤗 Transformers所支持的所有音频模型都提供了一个特征提取类，负责将原始的音频数据转化为该模型所需的输入特征格式。",Zl,S,Ct='特征提取器具体会对音频文件做些什么呢？我们可以参考<a href="https://cdn.openai.com/papers/whisper.pdf" rel="nofollow">Whisper</a>的特征提取器来理解一些常用的特征提取变换。Whisper是一个自动语音识别（automatic specch recognition, ASR）的预训练模型，由OpenAI的Alec Radford等人于2022年9月发布。',vl,H,ht="首先，Whisper的特征提取器会加长/截短某一批次中的所有音频样本，确保他们均为长30秒的音频。短于30秒的样本会采用末尾补零的方式加长至30秒，因为零在音频信号中代表无信号或静音。长于30秒的音频会被截取至30秒。由于一批次的所有音频都被加长/截短至同一长度，我们不再需要使用attention mask。这是Whisper模型的特性之一，因为大多数其他的音频模型都需要使用attention mask来告诉模型输入的哪些部分进行了补值，来让这些被补值的位置在self-attention过程中被忽略。Whisper模型在训练时就在无需attention mask的情况下运行，并且能直接从输入的音频信号中推理出哪些部分需要被忽略。",Gl,z,dt="Whisper的特征提取器所进行的第二个操作是将定长的音频数组转化为对数梅尔时频谱（log-mel spectrogram）。如前文所述，对数梅尔谱描述了各个频率成分是如何随时间变化的，并且在频率上使用了梅尔标度，在幅值上使用的分贝（对数）标度，使得频率和幅值的关系更接近于人耳的感知。",Wl,q,At="上述的所有变换都可以用简短的几行代码应用到原始的音频数据上。现在，我们从预训练的Whisper模型检查点（checkpoint）加载特征提取器，为音频数据做好准备：",Fl,L,El,D,It="然后，我们编写一个处理单个样本的函数，将该样本中的音频文件输入特征提取器<code>feature_extractor</code>。",Yl,O,Xl,P,$t="我们可以使用🤗 Datasets的<code>map</code>方法将这个数据处理函数应用到数据集中的所有训练样本上：",Sl,K,Hl,ll,bt="<strong>输出：</strong>",zl,tl,ql,el,Vt="简单几步后，我们就获得了对数梅尔谱并存储在数据集的<code>input_features</code>列中。",Ll,sl,_t="我们来试着可视化<code>minds</code>数据集中的一个样本：",Dl,nl,Ol,f,Rt='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/log_mel_whisper.png" alt="Log mel spectrogram plot"/>',Pl,al,Bt="现在你可以看到经过预处理后的Whisper模型的输入了。",Kl,Ml,kt='模型的特征提取器会保证将原始音频转化为模型所需要的输入格式。然而，许多音频相关的任务，比如语音识别，往往也是多模态的任务。🤗 Transformers库提供了针对各种文字模型的分词器（Tokenizer）。请参考我们的<a href="https://huggingface.co/learn/nlp-course/zh-CN/chapter2/4" rel="nofollow">自然语言处理课程</a>中对分词器的详细介绍。',lt,pl,xt="我们可以分别加载Whisper中的特征提取器和其他多模态模型中的分词器，也可以通过processor将他们同时加载。如果想要更加简单的用法，你可以使用<code>AutoProcessor</code>从模型的检查点中直接加载特征提取器和processor：",tt,il,et,ml,Nt="在本小节中，我们介绍了数据准备的基本流程。但要注意的是，您的自定义数据集往往会需要一些更复杂的数据预处理。针对这些情况，你可以扩展<code>prepare_dataset()</code>函数来实现各种自定义的数据转换流程。在🤗 Datasets的帮助下，只要您能将数据处理流程编写为Python函数，就可以将其应用在您的数据集上！",st,jl,nt;return C=new at({props:{title:"音频数据集的预处理",local:"音频数据集的预处理",headingTag:"h1"}}),A=new at({props:{title:"音频重采样",local:"音频重采样",headingTag:"h2"}}),V=new u({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwQXVkaW8lMEElMEFtaW5kcyUyMCUzRCUyMG1pbmRzLmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2XzAwMCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Audio

minds = minds.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16_000</span>))`,wrap:!1}}),R=new u({props:{code:"bWluZHMlNUIwJTVE",highlighted:'minds[<span class="hljs-number">0</span>]',wrap:!1}}),k=new u({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyMiUzQSUyMCUyMiUyRnJvb3QlMkYuY2FjaGUlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGZG93bmxvYWRzJTJGZXh0cmFjdGVkJTJGZjE0OTQ4ZTBlODRiZTYzOGRkNzk0M2FjMzY1MThhNGNmMzMyNGU4YjdhYTMzMWM1YWIxMTU0MTUxOGU5MzY4YyUyRmVuLUFVflBBWV9CSUxMJTJGcmVzcG9uc2VfNC53YXYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhdWRpbyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhdGglMjIlM0ElMjAlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmRvd25sb2FkcyUyRmV4dHJhY3RlZCUyRmYxNDk0OGUwZTg0YmU2MzhkZDc5NDNhYzM2NTE4YTRjZjMzMjRlOGI3YWEzMzFjNWFiMTE1NDE1MThlOTM2OGMlMkZlbi1BVX5QQVlfQklMTCUyRnJlc3BvbnNlXzQud2F2JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYXJyYXklMjIlM0ElMjBhcnJheSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAyLjA2MzQyNDNlLTA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS45NDM3ODM3ZS0wNCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDIuMjQxOTM0MGUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjA5LjM4NTI4NjJlLTA0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMS4xMzAyNDUyZS0wMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMDcuMTUzMTQyOWUtMDQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzRGZsb2F0MzIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2FtcGxpbmdfcmF0ZSUyMiUzQSUyMDE2MDAwJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNjcmlwdGlvbiUyMiUzQSUyMCUyMkklMjB3b3VsZCUyMGxpa2UlMjB0byUyMHBheSUyMG15JTIwZWxlY3RyaWNpdHklMjBiaWxsJTIwdXNpbmclMjBteSUyMGNhcmQlMjBjYW4lMjB5b3UlMjBwbGVhc2UlMjBhc3Npc3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJpbnRlbnRfY2xhc3MlMjIlM0ElMjAxMyUyQyUwQSU3RA==",highlighted:`{
    <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
    <span class="hljs-comment">&quot;audio&quot;</span>: {
        <span class="hljs-comment">&quot;path&quot;</span>: <span class="hljs-comment">&quot;/root/.cache/huggingface/datasets/downloads/extracted/f14948e0e84be638dd7943ac36518a4cf3324e8b7aa331c5ab11541518e9368c/en-AU~PAY_BILL/response_4.wav&quot;</span>,
        <span class="hljs-comment">&quot;array&quot;</span>: array(
            [
                <span class="hljs-number">2.0634243e-05</span>,
                <span class="hljs-number">1.9437837e-04</span>,
                <span class="hljs-number">2.2419340e-04</span>,
                ...,
                <span class="hljs-number">9.3852862e-04</span>,
                <span class="hljs-number">1.1302452e-03</span>,
                <span class="hljs-number">7.1531429e-04</span>,
            ],
            dtype=float32,
        ),
        <span class="hljs-comment">&quot;sampling_rate&quot;</span>: <span class="hljs-number">16000</span>,
    },
    <span class="hljs-comment">&quot;transcription&quot;</span>: <span class="hljs-comment">&quot;I would like to pay my electricity bill using my card can you please assist&quot;</span>,
    <span class="hljs-comment">&quot;intent_class&quot;</span>: <span class="hljs-number">13</span>,
}`,wrap:!1}}),o=new St({props:{$$slots:{default:[Ht]},$$scope:{ctx:yl}}}),N=new at({props:{title:"过滤数据集",local:"过滤数据集",headingTag:"h2"}}),Z=new u({props:{code:"TUFYX0RVUkFUSU9OX0lOX1NFQ09ORFMlMjAlM0QlMjAyMC4wJTBBJTBBJTBBZGVmJTIwaXNfYXVkaW9fbGVuZ3RoX2luX3JhbmdlKGlucHV0X2xlbmd0aCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dF9sZW5ndGglMjAlM0MlMjBNQVhfRFVSQVRJT05fSU5fU0VDT05EUw==",highlighted:`MAX_DURATION_IN_SECONDS = <span class="hljs-number">20.0</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_audio_length_in_range</span>(<span class="hljs-params">input_length</span>):
    <span class="hljs-keyword">return</span> input_length &lt; MAX_DURATION_IN_SECONDS`,wrap:!1}}),G=new u({props:{code:"JTIzJTIwJUU0JUJEJUJGJUU3JTk0JUE4bGlicm9zYSVFNCVCQiU4RSVFOSU5RiVCMyVFOSVBMiU5MSVFNiU5NiU4NyVFNCVCQiVCNiVFOSU4NyU4QyVFOCU4RSVCNyVFNSU4RiU5NiVFOCVBRiVBNSVFOSU5RiVCMyVFOSVBMiU5MSVFNyU5QSU4NCVFOSU5NSVCRiVFNSVCQSVBNiUwQW5ld19jb2x1bW4lMjAlM0QlMjAlNUJsaWJyb3NhLmdldF9kdXJhdGlvbihmaWxlbmFtZSUzRHgpJTIwZm9yJTIweCUyMGluJTIwbWluZHMlNUIlMjJwYXRoJTIyJTVEJTVEJTBBbWluZHMlMjAlM0QlMjBtaW5kcy5hZGRfY29sdW1uKCUyMmR1cmF0aW9uJTIyJTJDJTIwbmV3X2NvbHVtbiklMEElMEElMjMlMjAlRTQlQkQlQkYlRTclOTQlQTglRjAlOUYlQTQlOTclMjBEYXRhc2V0cyVFNyU5QSU4NCU2MGZpbHRlciU2MCVFNiU5NiVCOSVFNiVCMyU5NSVFNiU5RCVBNSVFOCVCRiU5QiVFOCVBMSU4QyVFOCVCRiU4NyVFNiVCQiVBNCUwQW1pbmRzJTIwJTNEJTIwbWluZHMuZmlsdGVyKGlzX2F1ZGlvX2xlbmd0aF9pbl9yYW5nZSUyQyUyMGlucHV0X2NvbHVtbnMlM0QlNUIlMjJkdXJhdGlvbiUyMiU1RCklMEElMEElMjMlMjAlRTclQTclQkIlRTklOTklQTQlRTQlQjglQjQlRTYlOTclQjYlRTUlODglOTclMEFtaW5kcyUyMCUzRCUyMG1pbmRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMmR1cmF0aW9uJTIyJTVEKSUwQW1pbmRz",highlighted:`<span class="hljs-comment"># 使用librosa从音频文件里获取该音频的长度</span>
new_column = [librosa.get_duration(filename=x) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> minds[<span class="hljs-string">&quot;path&quot;</span>]]
minds = minds.add_column(<span class="hljs-string">&quot;duration&quot;</span>, new_column)

<span class="hljs-comment"># 使用🤗 Datasets的\`filter\`方法来进行过滤</span>
minds = minds.<span class="hljs-built_in">filter</span>(is_audio_length_in_range, input_columns=[<span class="hljs-string">&quot;duration&quot;</span>])

<span class="hljs-comment"># 移除临时列</span>
minds = minds.remove_columns([<span class="hljs-string">&quot;duration&quot;</span>])
minds`,wrap:!1}}),F=new u({props:{code:"RGF0YXNldCglN0JmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlNUQlMkMlMjBudW1fcm93cyUzQSUyMDYyNCU3RCk=",highlighted:'<span class="hljs-constructor">Dataset({<span class="hljs-params">features</span>: [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>], <span class="hljs-params">num_rows</span>: 624})</span>',wrap:!1}}),Y=new at({props:{title:"音频数据的预处理",local:"音频数据的预处理",headingTag:"h2"}}),L=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFdoaXNwZXJGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBXaGlzcGVyRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> WhisperFeatureExtractor

feature_extractor = WhisperFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),O=new u({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF1ZGlvJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEYXVkaW8lNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTIwcGFkZGluZyUzRFRydWUlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]
    features = feature_extractor(
        audio[<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>], padding=<span class="hljs-literal">True</span>
    )
    <span class="hljs-keyword">return</span> features`,wrap:!1}}),K=new u({props:{code:"bWluZHMlMjAlM0QlMjBtaW5kcy5tYXAocHJlcGFyZV9kYXRhc2V0KSUwQW1pbmRz",highlighted:`minds = minds.<span class="hljs-built_in">map</span>(prepare_dataset)
minds`,wrap:!1}}),tl=new u({props:{code:"RGF0YXNldCglMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1QiUyMnBhdGglMjIlMkMlMjAlMjJhdWRpbyUyMiUyQyUyMCUyMnRyYW5zY3JpcHRpb24lMjIlMkMlMjAlMjJpbnRlbnRfY2xhc3MlMjIlMkMlMjAlMjJpbnB1dF9mZWF0dXJlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwNjI0JTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`Dataset(
    <span class="hljs-punctuation">{</span>
<span class="hljs-symbol">        features:</span> [<span class="hljs-string">&quot;path&quot;</span>, <span class="hljs-string">&quot;audio&quot;</span>, <span class="hljs-string">&quot;transcription&quot;</span>, <span class="hljs-string">&quot;intent_class&quot;</span>, <span class="hljs-string">&quot;input_features&quot;</span>],
<span class="hljs-symbol">        num_rows:</span> <span class="hljs-number">624</span>,
    <span class="hljs-punctuation">}</span>
)`,wrap:!1}}),nl=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZXhhbXBsZSUyMCUzRCUyMG1pbmRzJTVCMCU1RCUwQWlucHV0X2ZlYXR1cmVzJTIwJTNEJTIwZXhhbXBsZSU1QiUyMmlucHV0X2ZlYXR1cmVzJTIyJTVEJTBBJTBBcGx0LmZpZ3VyZSgpLnNldF9maWd3aWR0aCgxMiklMEFsaWJyb3NhLmRpc3BsYXkuc3BlY3Nob3coJTBBJTIwJTIwJTIwJTIwbnAuYXNhcnJheShpbnB1dF9mZWF0dXJlcyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIweF9heGlzJTNEJTIydGltZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHlfYXhpcyUzRCUyMm1lbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNyJTNEZmVhdHVyZV9leHRyYWN0b3Iuc2FtcGxpbmdfcmF0ZSUyQyUwQSUyMCUyMCUyMCUyMGhvcF9sZW5ndGglM0RmZWF0dXJlX2V4dHJhY3Rvci5ob3BfbGVuZ3RoJTJDJTBBKSUwQXBsdC5jb2xvcmJhcigp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

example = minds[<span class="hljs-number">0</span>]
input_features = example[<span class="hljs-string">&quot;input_features&quot;</span>]

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(
    np.asarray(input_features[<span class="hljs-number">0</span>]),
    x_axis=<span class="hljs-string">&quot;time&quot;</span>,
    y_axis=<span class="hljs-string">&quot;mel&quot;</span>,
    sr=feature_extractor.sampling_rate,
    hop_length=feature_extractor.hop_length,
)
plt.colorbar()`,wrap:!1}}),il=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZ3aGlzcGVyLXNtYWxsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)`,wrap:!1}}),{c(){r=M("meta"),J=n(),w=M("p"),Tl=n(),m(C.$$.fragment),cl=n(),h=M("p"),h.textContent=pt,Ul=n(),d=M("ul"),d.innerHTML=it,rl=n(),m(A.$$.fragment),ul=n(),I=M("p"),I.innerHTML=mt,Jl=n(),$=M("p"),$.textContent=jt,ol=n(),b=M("p"),b.innerHTML=yt,fl=n(),m(V.$$.fragment),wl=n(),_=M("p"),_.innerHTML=Tt,Cl=n(),m(R.$$.fragment),hl=n(),B=M("p"),B.innerHTML=ct,dl=n(),m(k.$$.fragment),Al=n(),x=M("p"),x.textContent=Ut,Il=n(),m(o.$$.fragment),$l=n(),m(N.$$.fragment),bl=n(),Q=M("p"),Q.textContent=rt,Vl=n(),g=M("p"),g.innerHTML=ut,_l=n(),m(Z.$$.fragment),Rl=n(),v=M("p"),v.textContent=Jt,Bl=n(),m(G.$$.fragment),kl=n(),W=M("p"),W.innerHTML=ot,xl=n(),m(F.$$.fragment),Nl=n(),E=M("p"),E.textContent=ft,Ql=n(),m(Y.$$.fragment),gl=n(),X=M("p"),X.textContent=wt,Zl=n(),S=M("p"),S.innerHTML=Ct,vl=n(),H=M("p"),H.textContent=ht,Gl=n(),z=M("p"),z.textContent=dt,Wl=n(),q=M("p"),q.textContent=At,Fl=n(),m(L.$$.fragment),El=n(),D=M("p"),D.innerHTML=It,Yl=n(),m(O.$$.fragment),Xl=n(),P=M("p"),P.innerHTML=$t,Sl=n(),m(K.$$.fragment),Hl=n(),ll=M("p"),ll.innerHTML=bt,zl=n(),m(tl.$$.fragment),ql=n(),el=M("p"),el.innerHTML=Vt,Ll=n(),sl=M("p"),sl.innerHTML=_t,Dl=n(),m(nl.$$.fragment),Ol=n(),f=M("div"),f.innerHTML=Rt,Pl=n(),al=M("p"),al.textContent=Bt,Kl=n(),Ml=M("p"),Ml.innerHTML=kt,lt=n(),pl=M("p"),pl.innerHTML=xt,tt=n(),m(il.$$.fragment),et=n(),ml=M("p"),ml.innerHTML=Nt,st=n(),jl=M("p"),this.h()},l(l){const t=Ft("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(e),J=a(l),w=p(l,"P",{}),gt(w).forEach(e),Tl=a(l),j(C.$$.fragment,l),cl=a(l),h=p(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-p9aqpc"&&(h.textContent=pt),Ul=a(l),d=p(l,"UL",{"data-svelte-h":!0}),i(d)!=="svelte-1iq9zwl"&&(d.innerHTML=it),rl=a(l),j(A.$$.fragment,l),ul=a(l),I=p(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1o19uzp"&&(I.innerHTML=mt),Jl=a(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-xojm7y"&&($.textContent=jt),ol=a(l),b=p(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-mnlczr"&&(b.innerHTML=yt),fl=a(l),j(V.$$.fragment,l),wl=a(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-7rpk6o"&&(_.innerHTML=Tt),Cl=a(l),j(R.$$.fragment,l),hl=a(l),B=p(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1n6w44y"&&(B.innerHTML=ct),dl=a(l),j(k.$$.fragment,l),Al=a(l),x=p(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-1ep07wj"&&(x.textContent=Ut),Il=a(l),j(o.$$.fragment,l),$l=a(l),j(N.$$.fragment,l),bl=a(l),Q=p(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-83neml"&&(Q.textContent=rt),Vl=a(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1x3ihke"&&(g.innerHTML=ut),_l=a(l),j(Z.$$.fragment,l),Rl=a(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-anodkq"&&(v.textContent=Jt),Bl=a(l),j(G.$$.fragment,l),kl=a(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1n6w44y"&&(W.innerHTML=ot),xl=a(l),j(F.$$.fragment,l),Nl=a(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1yjz1i5"&&(E.textContent=ft),Ql=a(l),j(Y.$$.fragment,l),gl=a(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1gv8t2u"&&(X.textContent=wt),Zl=a(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-1744b6z"&&(S.innerHTML=Ct),vl=a(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1g9l8sa"&&(H.textContent=ht),Gl=a(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-harofb"&&(z.textContent=dt),Wl=a(l),q=p(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-1iqdcuc"&&(q.textContent=At),Fl=a(l),j(L.$$.fragment,l),El=a(l),D=p(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1t9qdvj"&&(D.innerHTML=It),Yl=a(l),j(O.$$.fragment,l),Xl=a(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1on3o3i"&&(P.innerHTML=$t),Sl=a(l),j(K.$$.fragment,l),Hl=a(l),ll=p(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-1yevus4"&&(ll.innerHTML=bt),zl=a(l),j(tl.$$.fragment,l),ql=a(l),el=p(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-1f2a62s"&&(el.innerHTML=Vt),Ll=a(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-3bcl2k"&&(sl.innerHTML=_t),Dl=a(l),j(nl.$$.fragment,l),Ol=a(l),f=p(l,"DIV",{class:!0,"data-svelte-h":!0}),i(f)!=="svelte-csckl"&&(f.innerHTML=Rt),Pl=a(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-1qwfs3v"&&(al.textContent=Bt),Kl=a(l),Ml=p(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-9hx30e"&&(Ml.innerHTML=kt),lt=a(l),pl=p(l,"P",{"data-svelte-h":!0}),i(pl)!=="svelte-1tol5hn"&&(pl.innerHTML=xt),tt=a(l),j(il.$$.fragment,l),et=a(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1pitugk"&&(ml.innerHTML=Nt),st=a(l),jl=p(l,"P",{}),gt(jl).forEach(e),this.h()},h(){Mt(r,"name","hf:doc:metadata"),Mt(r,"content",qt),Mt(f,"class","flex justify-center")},m(l,t){Et(document.head,r),s(l,J,t),s(l,w,t),s(l,Tl,t),y(C,l,t),s(l,cl,t),s(l,h,t),s(l,Ul,t),s(l,d,t),s(l,rl,t),y(A,l,t),s(l,ul,t),s(l,I,t),s(l,Jl,t),s(l,$,t),s(l,ol,t),s(l,b,t),s(l,fl,t),y(V,l,t),s(l,wl,t),s(l,_,t),s(l,Cl,t),y(R,l,t),s(l,hl,t),s(l,B,t),s(l,dl,t),y(k,l,t),s(l,Al,t),s(l,x,t),s(l,Il,t),y(o,l,t),s(l,$l,t),y(N,l,t),s(l,bl,t),s(l,Q,t),s(l,Vl,t),s(l,g,t),s(l,_l,t),y(Z,l,t),s(l,Rl,t),s(l,v,t),s(l,Bl,t),y(G,l,t),s(l,kl,t),s(l,W,t),s(l,xl,t),y(F,l,t),s(l,Nl,t),s(l,E,t),s(l,Ql,t),y(Y,l,t),s(l,gl,t),s(l,X,t),s(l,Zl,t),s(l,S,t),s(l,vl,t),s(l,H,t),s(l,Gl,t),s(l,z,t),s(l,Wl,t),s(l,q,t),s(l,Fl,t),y(L,l,t),s(l,El,t),s(l,D,t),s(l,Yl,t),y(O,l,t),s(l,Xl,t),s(l,P,t),s(l,Sl,t),y(K,l,t),s(l,Hl,t),s(l,ll,t),s(l,zl,t),y(tl,l,t),s(l,ql,t),s(l,el,t),s(l,Ll,t),s(l,sl,t),s(l,Dl,t),y(nl,l,t),s(l,Ol,t),s(l,f,t),s(l,Pl,t),s(l,al,t),s(l,Kl,t),s(l,Ml,t),s(l,lt,t),s(l,pl,t),s(l,tt,t),y(il,l,t),s(l,et,t),s(l,ml,t),s(l,st,t),s(l,jl,t),nt=!0},p(l,[t]){const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:l}),o.$set(Qt)},i(l){nt||(T(C.$$.fragment,l),T(A.$$.fragment,l),T(V.$$.fragment,l),T(R.$$.fragment,l),T(k.$$.fragment,l),T(o.$$.fragment,l),T(N.$$.fragment,l),T(Z.$$.fragment,l),T(G.$$.fragment,l),T(F.$$.fragment,l),T(Y.$$.fragment,l),T(L.$$.fragment,l),T(O.$$.fragment,l),T(K.$$.fragment,l),T(tl.$$.fragment,l),T(nl.$$.fragment,l),T(il.$$.fragment,l),nt=!0)},o(l){c(C.$$.fragment,l),c(A.$$.fragment,l),c(V.$$.fragment,l),c(R.$$.fragment,l),c(k.$$.fragment,l),c(o.$$.fragment,l),c(N.$$.fragment,l),c(Z.$$.fragment,l),c(G.$$.fragment,l),c(F.$$.fragment,l),c(Y.$$.fragment,l),c(L.$$.fragment,l),c(O.$$.fragment,l),c(K.$$.fragment,l),c(tl.$$.fragment,l),c(nl.$$.fragment,l),c(il.$$.fragment,l),nt=!1},d(l){l&&(e(J),e(w),e(Tl),e(cl),e(h),e(Ul),e(d),e(rl),e(ul),e(I),e(Jl),e($),e(ol),e(b),e(fl),e(wl),e(_),e(Cl),e(hl),e(B),e(dl),e(Al),e(x),e(Il),e($l),e(bl),e(Q),e(Vl),e(g),e(_l),e(Rl),e(v),e(Bl),e(kl),e(W),e(xl),e(Nl),e(E),e(Ql),e(gl),e(X),e(Zl),e(S),e(vl),e(H),e(Gl),e(z),e(Wl),e(q),e(Fl),e(El),e(D),e(Yl),e(Xl),e(P),e(Sl),e(Hl),e(ll),e(zl),e(ql),e(el),e(Ll),e(sl),e(Dl),e(Ol),e(f),e(Pl),e(al),e(Kl),e(Ml),e(lt),e(pl),e(tt),e(et),e(ml),e(st),e(jl)),e(r),U(C,l),U(A,l),U(V,l),U(R,l),U(k,l),U(o,l),U(N,l),U(Z,l),U(G,l),U(F,l),U(Y,l),U(L,l),U(O,l),U(K,l),U(tl,l),U(nl,l),U(il,l)}}}const qt='{"title":"音频数据集的预处理","local":"音频数据集的预处理","sections":[{"title":"音频重采样","local":"音频重采样","sections":[],"depth":2},{"title":"过滤数据集","local":"过滤数据集","sections":[],"depth":2},{"title":"音频数据的预处理","local":"音频数据的预处理","sections":[],"depth":2}],"depth":1}';function Lt(yl){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class te extends Gt{constructor(r){super(),Wt(this,r,Lt,zt,Zt,{})}}export{te as component};
