import{s as Ul,n as Jl,o as ql}from"../chunks/scheduler.f7e1785c.js";import{S as xl,i as $l,g as i,s as t,r,A as Cl,h as o,f as l,c as a,j as Tl,u as p,x as u,k as xe,y as wl,a as n,v as d,d as c,t as m,w as f}from"../chunks/index.9f8f0838.js";import{C as h}from"../chunks/CodeBlock.b3510e34.js";import{H as y}from"../chunks/Heading.6643a2f7.js";function Nl(ks){let M,we,$e,Ne,T,ze,U,Ys=`Le <em>Hub</em> abrite <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">plusieurs centaines de modèles pré-entraînés pour la classification d’audio</a>. Dans cette section, nous passerons en revue certaines des tâches de classification d’audio les plus courantes et suggérerons des modèles pré-entraînés appropriés pour chacune. En utilisant la classe <code>pipeline()</code>, la commutation entre les modèles et les tâches est simple : une fois que vous savez comment utiliser <code>pipeline()</code> pour un modèle, vous pourrez l’utiliser pour n’importe quel modèle sur le <em>Hub</em>, sans modification du code ! Cela rend l’expérimentation de la classe <code>pipeline()</code> extrêmement rapide, ce qui vous permet de sélectionner rapidement le meilleur modèle pré-entraîné pour vos besoins.
Avant de passer aux différents problèmes de classification d’audio, récapitulons rapidement les architectures de <em>transformers</em> généralement utilisées. L’architecture standard de classification d’audio est motivée par la nature de la tâche. Nous voulons transformer une séquence d’entrées audio (c’est-à-dire notre réseau audio d’entrée) en une prédiction d’étiquette de classe unique. Les modèles d’encodeur associent d’abord la séquence audio d’entrée dans une séquence de représentations à l’état caché en faisant passer les entrées à travers un bloc <em>transformer</em>. La séquence de représentations d’états masqués est ensuite associée à une sortie d’étiquette de classe en prenant la moyenne sur les états masqués et en faisant passer le vecteur résultant à travers une couche de classification linéaire. Par conséquent, il y a une préférence pour les modèles <em>encodeur</em> pour la classification d’audio.
Les modèles de décodeur introduisent une complexité inutile à la tâche car ils supposent que les sorties peuvent également être une <em>séquence</em> de prédictions (plutôt qu’une prédiction d’étiquette de classe unique), et génèrent ainsi plusieurs sorties. Par conséquent, ils ont une vitesse d’inférence plus lente et ont tendance à ne pas être utilisés. Les modèles encodeur-décodeur sont largement omis pour la même raison. Ces choix d’architecture sont analogues à ceux de NLP, où les modèles d’encodeur tels que BERT sont privilégiés pour les tâches de classification de séquences, et les modèles de décodeur tels que GPT réservés aux tâches de génération de séquences.
Maintenant que nous avons récapitulé l’architecture du <em>transformer</em> standard pour la classification d’audio, passons aux différents sous-ensembles de la classification d’audio et couvrons les modèles les plus populaires !`,Ie,J,Le,q,As="Au moment de la rédaction de cette section, les dernières mises à jour requises pour le pipeline de classification d’audio se trouvent uniquement sur la version « principale » du dépôt 🤗 Transformers, plutôt que sur la dernière version de PyPi. Pour nous assurer que nous avons ces mises à jour localement, nous allons installer Transformers à partir de la branche <code>main</code> avec la commande suivante :",Qe,x,He,$,We,C,Gs="Le repérage de mots clés (KWS pour <em>Keyword spotting</em>) est la tâche d’identifier un mot-clé dans un discours. L’ensemble des mots-clés possibles forme l’ensemble des étiquettes de classe prédites. Par conséquent, pour utiliser un modèle de repérage de mots clés pré-entraîné, vous devez vous assurer que vos mots-clés correspondent à ceux sur lesquels le modèle a été pré-entraîné. Ci-dessous, nous présenterons deux jeux de données et modèles pour la détection de mots clés.",Se,w,Ze,N,Es='Commençons en utilisant le même jeu de données <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MINDS-14</a> exploré dans l’unité précédente. Si vous vous souvenez, MINDS-14 contient des enregistrements de personnes posant des questions à un système bancaire électronique dans plusieurs langues et dialectes, et a indique une classe d’intention pour chaque enregistrement. Nous pouvons donc classer les enregistrements par intention de l’appel.',_e,z,ke,I,Rs='Nous allons charger le <em>checkpoint</em> <a href="https://huggingface.co/anton-l/xtreme_s_xlsr_300m_minds14" rel="nofollow"><code>&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</code></a>, qui est un modèle XLS-R <em>finetuné</em> sur MINDS-14 pendant environ 50 époques. Il atteint une précision de 90% sur toutes les langues de MINDS-14 sur l’ensemble d’évaluation.',Ye,L,Ae,Q,Ds="Enfin, nous pouvons passer un échantillon au pipeline de classification pour faire une prédiction :",Ge,H,Ee,W,Vs="<strong>Sortie :</strong>",Re,S,De,Z,Bs="Nous avons identifié que l’intention de l’appel était de payer une facture, avec une probabilité de 96%. Vous pouvez imaginer que ce type de système de repérage de mots-clés soit utilisé comme première étape d’un centre d’appels automatisé, où nous voulons catégoriser les appels entrants des clients en fonction de leur requête et leur offrir un support contextualisé en conséquence.",Ve,_,Be,k,Fs=`Speech Commands est un jeu de données de mots parlés conçu pour évaluer les modèles de classification d’audio sur des mots de commande simples.
Le jeu de données se compose de 15 classes de mots-clés, d’une classe pour le silence et d’une classe inconnue pour inclure le faux positif.
Les 15 mots-clés sont des mots uniques qui seraient généralement utilisés dans les paramètres sur l’appareil pour contrôler les tâches de base ou lancer d’autres processus.
Un modèle similaire fonctionne en continu sur votre téléphone mobile. Ici, au lieu d’avoir des mots de commande uniques, nous avons des mots de réveil spécifiques à votre appareil, tels que « Hey Google » ou « Hey Siri ». Lorsque le modèle de classification d’audio détecte ces mots de réveil, il déclenche votre téléphone pour commencer à écouter le microphone et transcrire votre discours à l’aide d’un modèle de reconnaissance vocale.
Le modèle de classification d’audio est beaucoup plus petit et plus léger que le modèle de reconnaissance vocale, souvent seulement quelques millions de paramètres contre plusieurs centaines de millions pour la reconnaissance vocale. Ainsi, il peut fonctionner en continu sur votre appareil sans vider votre batterie ! Ce n’est que lorsque le mot de réveil est détecté que le modèle de reconnaissance vocale plus large est lancé, puis qu’il est à nouveau arrêté. Nous couvrirons les modèles de <em>transformers</em> pour la reconnaissance vocale dans la prochaine unité, donc à la fin du cours, vous devriez avoir les outils dont vous avez besoin pour construire votre propre assistant à commande vocale !
Comme pour tout jeu de données sur le <em>Hub</em>, nous pouvons avoir une idée de la tête des données sans avoir à les télécharger ou les avoir en mémoire. Après avoir accédé à la <a href="https://huggingface.co/datasets/speech_commands" rel="nofollow">carte du jeu de données Speech Commands</a> sur le <em>Hub</em>, nous pouvons utiliser la visionneuse de données pour faire défiler les 100 premiers échantillons du jeu de données, écouter les fichiers audio et vérifier toute autre information de métadonnées :`,Fe,v,Ps='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/speech_commands.png" alt="Diagram of datasets viewer."/>',Pe,Y,Xs=`L’aperçu du jeu de données est un moyen de découvrir les jeux de données audio avant de s’engager à les utiliser. Vous pouvez choisir n’importe quel jeu de données sur le <em>Hub</em>, faire défiler les échantillons et écouter l’audio pour les différents sous-ensembles et échantillons, en évaluant s’il s’agit du bon jeu de données pour vos besoins. Une fois que vous avez sélectionné un jeu de données, il est trivial de télécharger les données afin de pouvoir commencer à les utiliser.
Faisons cela et chargeons un échantillon du jeu de données Speech Commands en utilisant le mode streaming :`,Xe,A,Oe,G,Os='Nous allons charger un <em>checkpoint</em> d’un <a href="https://huggingface.co/docs/transformers/model_doc/audio-spectrogramme-transformer" rel="nofollow"><em>transformer</em> d’audio sous la forme de spectrogramme</a> <em>finetuné</em> sur le jeu de données Speech Commands :',Ke,E,es,R,Ks="<strong>Sortie :</strong>",ss,D,ls,V,el="On dirait que l’exemple contient le mot <code>backward</code> avec une forte probabilité. Nous pouvons écouter l’échantillon et vérifier qu’il est correct:",ns,B,ts,F,sl=`Vous vous demandez peut-être comment nous avons sélectionné les modèles pré-entraînés montrés dans ces exemples de classification d’audio.
C’est très simple ! La première chose que nous devons faire est de nous diriger sur le <em>Hub</em> et de cliquer sur l’onglet « <em>Models</em> »: <a href="https://huggingface.co/models" rel="nofollow">https://huggingface.co/models</a>
Cela va faire apparaître tous les modèles sur le <em>Hub</em> :`,as,b,ll='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/all_models.png"/>',is,P,nl="Vous remarquerez sur le côté gauche que nous avons plusieurs onglets que nous pouvons sélectionner pour filtrer les modèles par tâche, bibliothèque, jeu de données, etc. Faites défiler vers le bas et sélectionnez la tâche « Classification d’audio » dans la liste des tâches audio:",os,j,tl='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_audio_classification.png"/>',us,X,al="Nous voyons alors le sous-ensemble de modèles de classification d’audio présent sur le <em>Hub</em>. Pour affiner davantage cette sélection, nous pouvons filtrer les modèles par jeu de données. Cliquez sur l’onglet « Jeux de données », et dans la zone de recherche, tapez « speech_commands ». Lorsque vous commencez à taper, vous verrez la sélection pour ‘speech_commands’ apparaître sous l’onglet de recherche. Vous pouvez cliquer sur ce bouton pour filtrer tous les modèles de classification d’audio <em>finetuné</em> sur le jeu de données Speech Commands :",rs,g,il='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/by_speech_commands.png"/>',ps,O,ol="Bien, nous voyons que nous avons 6 modèles pré-entraînés à notre disposition pour ce jeu de données et cette tâche spécifiques. Le premier listé est celui que nous avons utilisé dans l’exemple précédent. Ce processus de filtrage des modèles du <em>Hub</em> est exactement la façon dont nous avons procédé pour choisir ce modèle.",ds,K,cs,ee,ul="L’identification de la langue est la tâche d’identifier la langue parlée dans un échantillon audio à partir d’une liste de langues candidates. Cette tâche peut jouer un rôle important dans de nombreux pipelines de parole. Par exemple, étant donné un échantillon audio dans une langue inconnue, un modèle d’identification de langue peut être utilisé pour catégoriser la ou les langues parlées dans l’échantillon audio, puis sélectionner un modèle de reconnaissance vocale approprié entraîné sur cette langue pour transcrire l’audio.",ms,se,fs,le,rl=`FLEURS (<em>Few-shot Learning Evaluation of Universal Representations of Speech</em>) est un jeu de données permettant d’évaluer les systèmes de reconnaissance vocale dans 102 langues, dont beaucoup sont classées comme à faibles ressources. Jetez un coup d’œil à la carte de FLEURS sur le <em>Hub</em> et explorez les différentes langues présentes : <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.
Pouvez-vous trouver votre langue maternelle ici ? Si ce n’est pas le cas, quelle est la langue la plus proche ?
Chargeons un échantillon à partir de l’échantillon de validation de FLEURS en utilisant le mode streaming :`,hs,ne,Ms,te,pl='Génial ! Nous pouvons maintenant charger notre modèle de classification d’audio. Pour cela, nous utiliserons une version de <a href="https://arxiv.org/pdf/2212.04356.pdf" rel="nofollow">Whisper</a> <em>finetuné</em> sur FLEURS, qui est actuellement le modèle de détection de langue le plus performant sur le Hub:',ys,ae,vs,ie,dl="Nous pouvons ensuite passer l’audio à travers notre classifieur et générer une prédiction :",bs,oe,js,ue,cl="<strong>Sortie :</strong>",gs,re,Ts,pe,ml=`Nous pouvons voir que le modèle a prédit que l’audio était en Afrikaans avec une probabilité extrêmement élevée. FLEURS contient des données audio provenant d’un large éventail de langues : nous pouvons voir que les étiquettes de classe possibles incluent le sotho du Nord, l’islandais, le danois et le cantonais, entre autres. Vous pouvez trouver la liste complète des langues ici : <a href="https://huggingface.co/datasets/google/fleurs" rel="nofollow">google/fleurs</a>.
À vous de jouer ! Quels autres <em>checkpoints</em> pouvez-vous trouver sur le <em>Hub</em>  afin de détecter les langues présentes dans FLEURS ? Quels modèles de <em>transformers</em> utilisent-ils sous le capot ?`,Us,de,Js,ce,fl=`Dans le paradigme traditionnel de la classification d’audio, le modèle prédit une étiquette de classe à partir d’un ensemble de classes prédéfinies possibles. Cela constitue un obstacle à l’utilisation de modèles pré-entraînés pour la classification d’audio, car les étiquettes du modèle pré-entraîné doit correspondre à celui de la tâche en aval. Pour l’exemple précédent de détection de langues, le modèle doit prédire l’une des 102 classes de langue sur lesquelles il a été entraîné. Si la tâche en aval nécessite en fait 110 langues, le modèle ne serait pas en mesure de prédire 8 des 110 langues, et nécessiterait donc un nouvel entraînement pour atteindre une couverture complète. Cela limite l’efficacité de l’apprentissage par transfert pour les tâches de classification d’audio.
La classification d’audio zéro-shot est une méthode permettant de prendre un modèle de classification d’audio pré-entraîné entraîné sur un ensemble d’exemples étiquetés et de lui permettre de classer de nouveaux exemples de classes inédites. Voyons comment nous pouvons y parvenir.
Actuellement, 🤗 <em>Transformers</em> prend en charge un type de modèle pour la classification d’audio en zéro-shot : le <a href="https://huggingface.co/docs/transformers/model_doc/clap" rel="nofollow">modèle CLAP</a>.
CLAP est un modèle basé sur un <em>transformer</em> qui prend à la fois l’audio et le texte comme entrées, et calcule la <em>similitude</em> entre les deux.
Si nous passons une entrée de texte fortement corrélée à une entrée audio, nous obtiendrons un score de similarité élevé. Inversement, passer une entrée de texte qui n’a aucun rapport avec l’entrée audio renverra une faible similitude.
Nous pouvons utiliser cette prédiction de similarité pour la classification d’audio en zéro-shot en passant une entrée audio au modèle et plusieurs étiquettes candidates. Le modèle renverra un score de similarité pour chacune des étiquettes candidates, et nous pouvons choisir celle qui a le score le plus élevé comme prédiction.`,qs,me,hl='Prenons un exemple où nous utilisons une entrée audio du jeu de données <a href="https://huggingface.co/datasets/ashraq/esc50" rel="nofollow">Environmental Speech Challenge (ESC)</a> :',xs,fe,$s,he,Ml="Nous définissons ensuite nos étiquettes candidates, qui forment l’ensemble des étiquettes de classification possibles. Le modèle renverra une probabilité de classification pour chacune des étiquettes que nous définissons. Cela signifie que nous devons connaître <em>a-priori</em> l’ensemble des étiquettes possibles dans notre problème de classification, de sorte que l’étiquette correcte soit contenue dans l’ensemble et se voie donc attribuer un score de probabilité valide. Notez que nous pouvons soit transmettre l’ensemble complet des étiquettes au modèle, soit un sous-ensemble sélectionné à la main qui, selon nous, contient l’étiquette correcte. Passer l’ensemble complet des étiquettes sera plus exhaustif, mais se fait au détriment d’une précision de classification plus faible puisque l’espace de classification est plus grand (à condition que l’étiquette correcte soit notre sous-ensemble d’étiquettes choisi):",Cs,Me,ws,ye,yl="Nous pouvons parcourir les deux modèles pour trouver l’étiquette candidate qui est la plus similaire à l’entrée audio:",Ns,ve,zs,be,vl="<strong>Sortie :</strong>",Is,je,Ls,ge,bl="Le modèle semble assez confiant (probabilité de 99,97%) que nous ayons le son d’un chien .Nous allons donc prendre cela comme notre prédiction. Confirmons si nous avions raison en écoutant l’échantillon audio (n’augmentez pas trop le volume, sinon vous risquez de sursauter !):",Qs,Te,Hs,Ue,jl=`Parfait ! Nous avons le son d’un chien qui aboie 🐕, ce qui correspond à la prédiction du modèle. Jouez avec différents échantillons audio et différentes étiquettes candidates. Pouvez-vous définir un ensemble d’étiquettes qui donnent une bonne généralisation à travers le jeu de données ESC ? Astuce : pensez à l’endroit où vous pourriez trouver des informations sur les sons possibles dans ESC et construisez vos étiquettes en conséquence.
Vous vous demandez peut-être pourquoi nous n’utilisons pas le pipeline de classification d’audio zero-shot pour <strong>toutes</strong> les tâches de classification d’audio ?
Il semble que nous puissions faire des prédictions pour n’importe quel problème de classification d’audio en définissant des étiquettes de classe appropriées <em>à priori</em>, contournant ainsi la contrainte dont notre tâche de classification a besoin pour correspondre aux étiquettes sur lesquelles le modèle a été pré-entraîné.
Cela se résume à la nature du modèle CLAP utilisé dans le pipeline zéro-shot. CLAP est pré-entraîné sur des données de classification d’audio <em>génériques</em>, similaires aux sons environnementaux dans le jeu de données ESC, plutôt que sur des données vocales spécifiques, comme nous l’avions dans la tâche de détection de langue. Si vous lui donnez un discours en anglais et un discours en espagnol, CLAP saurait que les deux exemples étaient des données vocales.  Mais il ne serait pas capable de différencier les langues de la même manière qu’un modèle de détection de langue dédié à cette tâche.`,Ws,Je,Ss,qe,gl=`Nous avons couvert un certain nombre de tâches de classification d’audio, présenté les jeux de données et les modèles les plus pertinents que vous pouvez télécharger à partir du <em>Hub</em> et comment les utiliser en quelques lignes de code à l’aide de la classe <code>pipeline()</code>. Ces tâches comprenent la détection de mots-clés, l’identification de la langue et la classification d’audio en zéro-shot.
Mais que se passe-t-il si nous voulons faire quelque chose de <strong>nouveau</strong> ? Nous avons beaucoup travaillé sur les tâches de traitement de la parole, mais ce n’est qu’un aspect de la classification d’audio. Un autre domaine populaire du traitement d’audio est la <strong>musique</strong>. Bien que la musique ait des caractéristiques intrinsèquement différentes à la parole, bon nombre des mêmes principes que nous avons déjà appris peuvent être appliqués.
Dans la section suivante, nous allons passer en revue un guide étape par étape sur la façon dont vous pouvez <em>finetuner</em> un <em>transformer</em> avec 🤗 <em>Transformers</em> sur la tâche de classification de la musique. À la fin, vous aurez un <em>checkpoint</em> <em>finetuné</em> que vous pourrez brancher dans la classe <code>pipeline()</code>, vous permettant de classer les chansons exactement de la même manière que nous avons classé la parole ici.`,Zs,Ce,_s;return T=new y({props:{title:"Modèles et jeux de données pré-entraînés pour la classification d’audio",local:"modèles-et-jeux-de-données-pré-entraînés-pour-la-classification-daudio",headingTag:"h1"}}),J=new y({props:{title:"🤗 Installation de Transformers",local:"-installation-de-transformers",headingTag:"h2"}}),x=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJz",highlighted:'pip install git+https:<span class="hljs-regexp">//gi</span>thub.com<span class="hljs-regexp">/huggingface/</span>transformers',wrap:!1}}),$=new y({props:{title:"Repérage de mots-clés",local:"repérage-de-mots-clés",headingTag:"h2"}}),w=new y({props:{title:"MINDS-14",local:"minds-14",headingTag:"h3"}}),z=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyUG9seUFJJTJGbWluZHMxNCUyMiUyQyUyMG5hbWUlM0QlMjJlbi1BVSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

minds = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, name=<span class="hljs-string">&quot;en-AU&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),L=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJhbnRvbi1sJTJGeHRyZW1lX3NfeGxzcl8zMDBtX21pbmRzMTQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>,
    model=<span class="hljs-string">&quot;anton-l/xtreme_s_xlsr_300m_minds14&quot;</span>,
)`,wrap:!1}}),H=new h({props:{code:"Y2xhc3NpZmllcihtaW5kcyU1QjAlNUQlNUIlMjJwYXRoJTIyJTVEKQ==",highlighted:'classifier(minds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;path&quot;</span>])',wrap:!1}}),S=new h({props:{code:"JTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjk2MzE1MjUyNzgwOTE0MzElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMnBheV9iaWxsJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAyODE5Njk4MzAzOTM3OTEyJTJDJTIwJTIybGFiZWwlMjIlM0ElMjAlMjJmcmVlemUlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAzMjc4NzQ5Mjk2NDQxNjc0MiUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyY2FyZF9pc3N1ZXMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJzY29yZSUyMiUzQSUyMDAuMDAxOTQxNDQ0NTg1MDk5ODE2MyUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwJTIyYWJyb2FkJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIyc2NvcmUlMjIlM0ElMjAwLjAwMDgzNzg2OTM2MDExMTY1MzglMkMlMjAlMjJsYWJlbCUyMiUzQSUyMCUyMmhpZ2hfdmFsdWVfcGF5bWVudCUyMiU3RCUyQyUwQSU1RA==",highlighted:`[
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.9631525278091431</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;pay_bill&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.02819698303937912</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;freeze&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0032787492964416742</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;card_issues&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0019414445850998163</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;abroad&quot;</span>},
    {<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.0008378693601116538</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;high_value_payment&quot;</span>},
]`,wrap:!1}}),_=new y({props:{title:"Speech Commands",local:"speech-commands",headingTag:"h3"}}),A=new h({props:{code:"c3BlZWNoX2NvbW1hbmRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUwQSUyMCUyMCUyMCUyMCUyMnNwZWVjaF9jb21tYW5kcyUyMiUyQyUyMCUyMnYwLjAyJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUwQSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoc3BlZWNoX2NvbW1hbmRzKSk=",highlighted:`speech_commands = load_dataset(
    <span class="hljs-string">&quot;speech_commands&quot;</span>, <span class="hljs-string">&quot;v0.02&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>
)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(speech_commands))`,wrap:!1}}),E=new h({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJNSVQlMkZhc3QtZmluZXR1bmVkLXNwZWVjaC1jb21tYW5kcy12MiUyMiUwQSklMEFjbGFzc2lmaWVyKHNhbXBsZSU1QiUyMmF1ZGlvJTIyJTVELmNvcHkoKSk=",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;MIT/ast-finetuned-speech-commands-v2&quot;</span>
)
classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>].copy())`,wrap:!1}}),D=new h({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTg5MjcxMTYzOTQwNCUyQyUyMCdsYWJlbCclM0ElMjAnYmFja3dhcmQnJTdEJTJDJTBBJTIwJTdCJ3Njb3JlJyUzQSUyMDEuNzUwNDg4ODc3NDA1NTg3MWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ2hhcHB5JyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA2LjcwMzA0MDE4NTEyOTc5NGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ2ZvbGxvdyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwNS44MDU4ODQ0ODQyODg5ODFlLTA3JTJDJTIwJ2xhYmVsJyUzQSUyMCdzdG9wJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA1LjYxNDU0NjY5NDIzMjU1OGUtMDclMkMlMjAnbGFiZWwnJTNBJTIwJ3VwJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999892711639404</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;backward</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">1.7504888774055871</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;happy</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">6.703040185129794</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;follow</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.805884484288981</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;stop</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">5.614546694232558</span>e-07, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;up</span>&#x27;}]`,wrap:!1}}),B=new h({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc2FtcGxlJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJhdGUlM0RzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQp",highlighted:`from <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">IPython</span>.</span></span>display import Audio

<span class="hljs-constructor">Audio(<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], <span class="hljs-params">rate</span>=<span class="hljs-params">sample</span>[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>])</span>`,wrap:!1}}),K=new y({props:{title:"Identification de la langue",local:"identification-de-la-langue",headingTag:"h2"}}),se=new y({props:{title:"FLEURS",local:"fleurs",headingTag:"h3"}}),ne=new h({props:{code:"ZmxldXJzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmdvb2dsZSUyRmZsZXVycyUyMiUyQyUyMCUyMmFsbCUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBc2FtcGxlJTIwJTNEJTIwbmV4dChpdGVyKGZsZXVycykp",highlighted:`fleurs = load_dataset(<span class="hljs-string">&quot;google/fleurs&quot;</span>, <span class="hljs-string">&quot;all&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, streaming=<span class="hljs-literal">True</span>)
sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(fleurs))`,wrap:!1}}),ae=new h({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmF1ZGlvLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJzYW5jaGl0LWdhbmRoaSUyRndoaXNwZXItbWVkaXVtLWZsZXVycy1sYW5nLWlkJTIyJTBBKQ==",highlighted:`classifier = pipeline(
    <span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;sanchit-gandhi/whisper-medium-fleurs-lang-id&quot;</span>
)`,wrap:!1}}),oe=new h({props:{code:"Y2xhc3NpZmllcihzYW1wbGUlNUIlMjJhdWRpbyUyMiU1RCk=",highlighted:'classifier(sample[<span class="hljs-string">&quot;audio&quot;</span>])',wrap:!1}}),re=new h({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5OTMzMDA0Mzc5MjcyNSUyQyUyMCdsYWJlbCclM0ElMjAnQWZyaWthYW5zJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA3LjA5MzAyMzY2ODg1ODIyM2UtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ05vcnRoZXJuLVNvdGhvJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjA0LjI2OTE0OTQ4NTQ4MDczOWUtMDYlMkMlMjAnbGFiZWwnJTNBJTIwJ0ljZWxhbmRpYyclN0QlMkMlMEElMjAlN0Inc2NvcmUnJTNBJTIwMy4yNjYxMTQxNjMxMjUxNjY3ZS0wNiUyQyUyMCdsYWJlbCclM0ElMjAnRGFuaXNoJyU3RCUyQyUwQSUyMCU3QidzY29yZSclM0ElMjAzLjI1ODA3MjQxMDk3MjA5MDRlLTA2JTJDJTIwJ2xhYmVsJyUzQSUyMCdDYW50b25lc2UlMjBDaGluZXNlJyU3RCU1RA==",highlighted:`[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9999330043792725</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Afrikaans</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">7.093023668858223</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Northern-Sotho</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">4.269149485480739</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Icelandic</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2661141631251667</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Danish</span>&#x27;},
 {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">3.2580724109720904</span>e-06, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Cantonese</span> Chinese&#x27;}]`,wrap:!1}}),de=new y({props:{title:"Classification d’audio en zéro-shot",local:"classification-daudio-en-zéro-shot",headingTag:"h2"}}),fe=new h({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJhc2hyYXElMkZlc2M1MCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWF1ZGlvX3NhbXBsZSUyMCUzRCUyMG5leHQoaXRlcihkYXRhc2V0KSklNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVE",highlighted:`dataset = load_dataset(<span class="hljs-string">&quot;ashraq/esc50&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
audio_sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]`,wrap:!1}}),Me=new h({props:{code:"Y2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMlNvdW5kJTIwb2YlMjBhJTIwZG9nJTIyJTJDJTIwJTIyU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXIlMjIlNUQ=",highlighted:'candidate_labels = [<span class="hljs-string">&quot;Sound of a dog&quot;</span>, <span class="hljs-string">&quot;Sound of vacuum cleaner&quot;</span>]',wrap:!1}}),ve=new h({props:{code:"Y2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ6ZXJvLXNob3QtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmxhaW9uJTJGY2xhcC1odHNhdC11bmZ1c2VkJTIyJTBBKSUwQWNsYXNzaWZpZXIoYXVkaW9fc2FtcGxlJTJDJTIwY2FuZGlkYXRlX2xhYmVscyUzRGNhbmRpZGF0ZV9sYWJlbHMp",highlighted:`classifier = pipeline(
    task=<span class="hljs-string">&quot;zero-shot-audio-classification&quot;</span>, model=<span class="hljs-string">&quot;laion/clap-htsat-unfused&quot;</span>
)
classifier(audio_sample, candidate_labels=candidate_labels)`,wrap:!1}}),je=new h({props:{code:"JTVCJTdCJ3Njb3JlJyUzQSUyMDAuOTk5NzI0MjA5MzA4NjI0MyUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMGElMjBkb2cnJTdEJTJDJTIwJTdCJ3Njb3JlJyUzQSUyMDAuMDAwMjc1ODMyMzk3MTY0Nzc2OSUyQyUyMCdsYWJlbCclM0ElMjAnU291bmQlMjBvZiUyMHZhY3V1bSUyMGNsZWFuZXInJTdEJTVE",highlighted:'[{<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.9997242093086243</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of a dog&#x27;}, {<span class="hljs-symbol">&#x27;score</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-number">0.0002758323971647769</span>, <span class="hljs-symbol">&#x27;label</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Sound</span> of vacuum cleaner&#x27;}]',wrap:!1}}),Te=new h({props:{code:"QXVkaW8oYXVkaW8lMkMlMjByYXRlJTNEMTYwMDAp",highlighted:'Audio(audio, rate=<span class="hljs-number">16000</span>)',wrap:!1}}),Je=new y({props:{title:"Et ensuite ?",local:"et-ensuite-",headingTag:"h2"}}),{c(){M=i("meta"),we=t(),$e=i("p"),Ne=t(),r(T.$$.fragment),ze=t(),U=i("p"),U.innerHTML=Ys,Ie=t(),r(J.$$.fragment),Le=t(),q=i("p"),q.innerHTML=As,Qe=t(),r(x.$$.fragment),He=t(),r($.$$.fragment),We=t(),C=i("p"),C.innerHTML=Gs,Se=t(),r(w.$$.fragment),Ze=t(),N=i("p"),N.innerHTML=Es,_e=t(),r(z.$$.fragment),ke=t(),I=i("p"),I.innerHTML=Rs,Ye=t(),r(L.$$.fragment),Ae=t(),Q=i("p"),Q.textContent=Ds,Ge=t(),r(H.$$.fragment),Ee=t(),W=i("p"),W.innerHTML=Vs,Re=t(),r(S.$$.fragment),De=t(),Z=i("p"),Z.textContent=Bs,Ve=t(),r(_.$$.fragment),Be=t(),k=i("p"),k.innerHTML=Fs,Fe=t(),v=i("div"),v.innerHTML=Ps,Pe=t(),Y=i("p"),Y.innerHTML=Xs,Xe=t(),r(A.$$.fragment),Oe=t(),G=i("p"),G.innerHTML=Os,Ke=t(),r(E.$$.fragment),es=t(),R=i("p"),R.innerHTML=Ks,ss=t(),r(D.$$.fragment),ls=t(),V=i("p"),V.innerHTML=el,ns=t(),r(B.$$.fragment),ts=t(),F=i("p"),F.innerHTML=sl,as=t(),b=i("div"),b.innerHTML=ll,is=t(),P=i("p"),P.textContent=nl,os=t(),j=i("div"),j.innerHTML=tl,us=t(),X=i("p"),X.innerHTML=al,rs=t(),g=i("div"),g.innerHTML=il,ps=t(),O=i("p"),O.innerHTML=ol,ds=t(),r(K.$$.fragment),cs=t(),ee=i("p"),ee.textContent=ul,ms=t(),r(se.$$.fragment),fs=t(),le=i("p"),le.innerHTML=rl,hs=t(),r(ne.$$.fragment),Ms=t(),te=i("p"),te.innerHTML=pl,ys=t(),r(ae.$$.fragment),vs=t(),ie=i("p"),ie.textContent=dl,bs=t(),r(oe.$$.fragment),js=t(),ue=i("p"),ue.innerHTML=cl,gs=t(),r(re.$$.fragment),Ts=t(),pe=i("p"),pe.innerHTML=ml,Us=t(),r(de.$$.fragment),Js=t(),ce=i("p"),ce.innerHTML=fl,qs=t(),me=i("p"),me.innerHTML=hl,xs=t(),r(fe.$$.fragment),$s=t(),he=i("p"),he.innerHTML=Ml,Cs=t(),r(Me.$$.fragment),ws=t(),ye=i("p"),ye.textContent=yl,Ns=t(),r(ve.$$.fragment),zs=t(),be=i("p"),be.innerHTML=vl,Is=t(),r(je.$$.fragment),Ls=t(),ge=i("p"),ge.textContent=bl,Qs=t(),r(Te.$$.fragment),Hs=t(),Ue=i("p"),Ue.innerHTML=jl,Ws=t(),r(Je.$$.fragment),Ss=t(),qe=i("p"),qe.innerHTML=gl,Zs=t(),Ce=i("p"),this.h()},l(e){const s=Cl("svelte-u9bgzb",document.head);M=o(s,"META",{name:!0,content:!0}),s.forEach(l),we=a(e),$e=o(e,"P",{}),Tl($e).forEach(l),Ne=a(e),p(T.$$.fragment,e),ze=a(e),U=o(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-lsxr7h"&&(U.innerHTML=Ys),Ie=a(e),p(J.$$.fragment,e),Le=a(e),q=o(e,"P",{"data-svelte-h":!0}),u(q)!=="svelte-zanaqk"&&(q.innerHTML=As),Qe=a(e),p(x.$$.fragment,e),He=a(e),p($.$$.fragment,e),We=a(e),C=o(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-2mhc4i"&&(C.innerHTML=Gs),Se=a(e),p(w.$$.fragment,e),Ze=a(e),N=o(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-pxcq6"&&(N.innerHTML=Es),_e=a(e),p(z.$$.fragment,e),ke=a(e),I=o(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-14uya4i"&&(I.innerHTML=Rs),Ye=a(e),p(L.$$.fragment,e),Ae=a(e),Q=o(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1ahiviy"&&(Q.textContent=Ds),Ge=a(e),p(H.$$.fragment,e),Ee=a(e),W=o(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-dbzevp"&&(W.innerHTML=Vs),Re=a(e),p(S.$$.fragment,e),De=a(e),Z=o(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-1exq1ul"&&(Z.textContent=Bs),Ve=a(e),p(_.$$.fragment,e),Be=a(e),k=o(e,"P",{"data-svelte-h":!0}),u(k)!=="svelte-1dnncr2"&&(k.innerHTML=Fs),Fe=a(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),u(v)!=="svelte-sk0ezl"&&(v.innerHTML=Ps),Pe=a(e),Y=o(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-7cdmxy"&&(Y.innerHTML=Xs),Xe=a(e),p(A.$$.fragment,e),Oe=a(e),G=o(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-9uwmvh"&&(G.innerHTML=Os),Ke=a(e),p(E.$$.fragment,e),es=a(e),R=o(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-dbzevp"&&(R.innerHTML=Ks),ss=a(e),p(D.$$.fragment,e),ls=a(e),V=o(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1nyizdg"&&(V.innerHTML=el),ns=a(e),p(B.$$.fragment,e),ts=a(e),F=o(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-bjsjj0"&&(F.innerHTML=sl),as=a(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),u(b)!=="svelte-bqfzrn"&&(b.innerHTML=ll),is=a(e),P=o(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-9ifayn"&&(P.textContent=nl),os=a(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),u(j)!=="svelte-1t2za6k"&&(j.innerHTML=tl),us=a(e),X=o(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-1ruh3w6"&&(X.innerHTML=al),rs=a(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),u(g)!=="svelte-1sstogo"&&(g.innerHTML=il),ps=a(e),O=o(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1coiede"&&(O.innerHTML=ol),ds=a(e),p(K.$$.fragment,e),cs=a(e),ee=o(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-1kvumvt"&&(ee.textContent=ul),ms=a(e),p(se.$$.fragment,e),fs=a(e),le=o(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-wss39v"&&(le.innerHTML=rl),hs=a(e),p(ne.$$.fragment,e),Ms=a(e),te=o(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-1xnisix"&&(te.innerHTML=pl),ys=a(e),p(ae.$$.fragment,e),vs=a(e),ie=o(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-mwec1y"&&(ie.textContent=dl),bs=a(e),p(oe.$$.fragment,e),js=a(e),ue=o(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-dbzevp"&&(ue.innerHTML=cl),gs=a(e),p(re.$$.fragment,e),Ts=a(e),pe=o(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1uvuy1n"&&(pe.innerHTML=ml),Us=a(e),p(de.$$.fragment,e),Js=a(e),ce=o(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-abl4ay"&&(ce.innerHTML=fl),qs=a(e),me=o(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1hlgy2h"&&(me.innerHTML=hl),xs=a(e),p(fe.$$.fragment,e),$s=a(e),he=o(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1imgqdy"&&(he.innerHTML=Ml),Cs=a(e),p(Me.$$.fragment,e),ws=a(e),ye=o(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-k1iv44"&&(ye.textContent=yl),Ns=a(e),p(ve.$$.fragment,e),zs=a(e),be=o(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-dbzevp"&&(be.innerHTML=vl),Is=a(e),p(je.$$.fragment,e),Ls=a(e),ge=o(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-2np99t"&&(ge.textContent=bl),Qs=a(e),p(Te.$$.fragment,e),Hs=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1hhsvs9"&&(Ue.innerHTML=jl),Ws=a(e),p(Je.$$.fragment,e),Ss=a(e),qe=o(e,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-12mdb7a"&&(qe.innerHTML=gl),Zs=a(e),Ce=o(e,"P",{}),Tl(Ce).forEach(l),this.h()},h(){xe(M,"name","hf:doc:metadata"),xe(M,"content",zl),xe(v,"class","flex justify-center"),xe(b,"class","flex justify-center"),xe(j,"class","flex justify-center"),xe(g,"class","flex justify-center")},m(e,s){wl(document.head,M),n(e,we,s),n(e,$e,s),n(e,Ne,s),d(T,e,s),n(e,ze,s),n(e,U,s),n(e,Ie,s),d(J,e,s),n(e,Le,s),n(e,q,s),n(e,Qe,s),d(x,e,s),n(e,He,s),d($,e,s),n(e,We,s),n(e,C,s),n(e,Se,s),d(w,e,s),n(e,Ze,s),n(e,N,s),n(e,_e,s),d(z,e,s),n(e,ke,s),n(e,I,s),n(e,Ye,s),d(L,e,s),n(e,Ae,s),n(e,Q,s),n(e,Ge,s),d(H,e,s),n(e,Ee,s),n(e,W,s),n(e,Re,s),d(S,e,s),n(e,De,s),n(e,Z,s),n(e,Ve,s),d(_,e,s),n(e,Be,s),n(e,k,s),n(e,Fe,s),n(e,v,s),n(e,Pe,s),n(e,Y,s),n(e,Xe,s),d(A,e,s),n(e,Oe,s),n(e,G,s),n(e,Ke,s),d(E,e,s),n(e,es,s),n(e,R,s),n(e,ss,s),d(D,e,s),n(e,ls,s),n(e,V,s),n(e,ns,s),d(B,e,s),n(e,ts,s),n(e,F,s),n(e,as,s),n(e,b,s),n(e,is,s),n(e,P,s),n(e,os,s),n(e,j,s),n(e,us,s),n(e,X,s),n(e,rs,s),n(e,g,s),n(e,ps,s),n(e,O,s),n(e,ds,s),d(K,e,s),n(e,cs,s),n(e,ee,s),n(e,ms,s),d(se,e,s),n(e,fs,s),n(e,le,s),n(e,hs,s),d(ne,e,s),n(e,Ms,s),n(e,te,s),n(e,ys,s),d(ae,e,s),n(e,vs,s),n(e,ie,s),n(e,bs,s),d(oe,e,s),n(e,js,s),n(e,ue,s),n(e,gs,s),d(re,e,s),n(e,Ts,s),n(e,pe,s),n(e,Us,s),d(de,e,s),n(e,Js,s),n(e,ce,s),n(e,qs,s),n(e,me,s),n(e,xs,s),d(fe,e,s),n(e,$s,s),n(e,he,s),n(e,Cs,s),d(Me,e,s),n(e,ws,s),n(e,ye,s),n(e,Ns,s),d(ve,e,s),n(e,zs,s),n(e,be,s),n(e,Is,s),d(je,e,s),n(e,Ls,s),n(e,ge,s),n(e,Qs,s),d(Te,e,s),n(e,Hs,s),n(e,Ue,s),n(e,Ws,s),d(Je,e,s),n(e,Ss,s),n(e,qe,s),n(e,Zs,s),n(e,Ce,s),_s=!0},p:Jl,i(e){_s||(c(T.$$.fragment,e),c(J.$$.fragment,e),c(x.$$.fragment,e),c($.$$.fragment,e),c(w.$$.fragment,e),c(z.$$.fragment,e),c(L.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(_.$$.fragment,e),c(A.$$.fragment,e),c(E.$$.fragment,e),c(D.$$.fragment,e),c(B.$$.fragment,e),c(K.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(fe.$$.fragment,e),c(Me.$$.fragment,e),c(ve.$$.fragment,e),c(je.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),_s=!0)},o(e){m(T.$$.fragment,e),m(J.$$.fragment,e),m(x.$$.fragment,e),m($.$$.fragment,e),m(w.$$.fragment,e),m(z.$$.fragment,e),m(L.$$.fragment,e),m(H.$$.fragment,e),m(S.$$.fragment,e),m(_.$$.fragment,e),m(A.$$.fragment,e),m(E.$$.fragment,e),m(D.$$.fragment,e),m(B.$$.fragment,e),m(K.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(fe.$$.fragment,e),m(Me.$$.fragment,e),m(ve.$$.fragment,e),m(je.$$.fragment,e),m(Te.$$.fragment,e),m(Je.$$.fragment,e),_s=!1},d(e){e&&(l(we),l($e),l(Ne),l(ze),l(U),l(Ie),l(Le),l(q),l(Qe),l(He),l(We),l(C),l(Se),l(Ze),l(N),l(_e),l(ke),l(I),l(Ye),l(Ae),l(Q),l(Ge),l(Ee),l(W),l(Re),l(De),l(Z),l(Ve),l(Be),l(k),l(Fe),l(v),l(Pe),l(Y),l(Xe),l(Oe),l(G),l(Ke),l(es),l(R),l(ss),l(ls),l(V),l(ns),l(ts),l(F),l(as),l(b),l(is),l(P),l(os),l(j),l(us),l(X),l(rs),l(g),l(ps),l(O),l(ds),l(cs),l(ee),l(ms),l(fs),l(le),l(hs),l(Ms),l(te),l(ys),l(vs),l(ie),l(bs),l(js),l(ue),l(gs),l(Ts),l(pe),l(Us),l(Js),l(ce),l(qs),l(me),l(xs),l($s),l(he),l(Cs),l(ws),l(ye),l(Ns),l(zs),l(be),l(Is),l(Ls),l(ge),l(Qs),l(Hs),l(Ue),l(Ws),l(Ss),l(qe),l(Zs),l(Ce)),l(M),f(T,e),f(J,e),f(x,e),f($,e),f(w,e),f(z,e),f(L,e),f(H,e),f(S,e),f(_,e),f(A,e),f(E,e),f(D,e),f(B,e),f(K,e),f(se,e),f(ne,e),f(ae,e),f(oe,e),f(re,e),f(de,e),f(fe,e),f(Me,e),f(ve,e),f(je,e),f(Te,e),f(Je,e)}}}const zl='{"title":"Modèles et jeux de données pré-entraînés pour la classification d’audio","local":"modèles-et-jeux-de-données-pré-entraînés-pour-la-classification-daudio","sections":[{"title":"🤗 Installation de Transformers","local":"-installation-de-transformers","sections":[],"depth":2},{"title":"Repérage de mots-clés","local":"repérage-de-mots-clés","sections":[{"title":"MINDS-14","local":"minds-14","sections":[],"depth":3},{"title":"Speech Commands","local":"speech-commands","sections":[],"depth":3}],"depth":2},{"title":"Identification de la langue","local":"identification-de-la-langue","sections":[{"title":"FLEURS","local":"fleurs","sections":[],"depth":3}],"depth":2},{"title":"Classification d’audio en zéro-shot","local":"classification-daudio-en-zéro-shot","sections":[],"depth":2},{"title":"Et ensuite ?","local":"et-ensuite-","sections":[],"depth":2}],"depth":1}';function Il(ks){return ql(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends xl{constructor(M){super(),$l(this,M,Il,Nl,Ul,{})}}export{Sl as component};
