import{s as je,n as be,o as Ue}from"../chunks/scheduler.39a43cde.js";import{S as fe,i as Ze,g as y,s as a,r as p,A as Te,h,f as t,c as n,j as we,u as i,x as c,k as Je,y as $e,a as l,v as m,d as o,t as d,w as r}from"../chunks/index.23ec2204.js";import{D as Ce,C as M}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as se}from"../chunks/Heading.c42e7061.js";function Ie(ee){let g,ms,ps,os,u,ds,w,rs,J,te='<em>Authored by: <a href="https://huggingface.co/merve" rel="nofollow">Merve Noyan</a></em>',Ms,j,le=`Embeddings are semantically meaningful compressions of information. They can be used to do similarity search, zero-shot classification or simply train a new model. Use cases for similarity search include searching for similar products in e-commerce, content search in social media and more.
This notebook walks you through using 🤗transformers, 🤗datasets and FAISS to create and index embeddings from a feature extraction model to later use them for similarity search.
Let’s install necessary libraries.`,ys,b,hs,U,ae='For this tutorial, we will use <a href="https://huggingface.co/openai/clip-vit-base-patch16" rel="nofollow">CLIP model</a> to extract the features. CLIP is a revolutionary model that introduced joint training of a text encoder and an image encoder to connect two modalities.',cs,f,gs,Z,ne='Load the dataset. To keep this notebook light, we will use a small captioning dataset, <a href="https://huggingface.co/datasets/jmhessel/newyorker_caption_contest" rel="nofollow">jmhessel/newyorker_caption_contest</a>.',us,T,ws,$,pe="See an example.",Js,C,js,I,bs,W,ie="We don’t have to write any function to embed examples or create an index. 🤗 datasets library’s FAISS integration abstracts these processes. We can simply use <code>map</code> method of the dataset to create a new column with the embeddings for each example like below. Let’s create one for text features on the prompt column.",Us,k,fs,G,Zs,_,me="We can do the same and get the image embeddings.",Ts,V,$s,X,Cs,R,Is,B,oe="We can now query the dataset with text or image to get similar items from it.",Ws,q,ks,Q,Gs,v,de=`['A man is in the snow. A boy with a huge snow shovel is there too. They are outside a house.']
`,_s,N,Vs,A,re="Image similarity inference is similar, where you just call <code>get_image_features</code>.",Xs,x,Rs,z,Me="Search for the similar image.",Bs,Y,qs,F,ye="Display the most similar image to the beaver image.",Qs,S,vs,E,he=`['Salmon swim upstream but they see a grizzly bear and are in shock. The bear has a smug look on his face when he sees the salmon.']
`,Ns,H,As,L,ce="We can save the dataset with embeddings with <code>save_faiss_index</code>.",xs,K,zs,P,Ys,D,ge=`It’s a good practice to store the embeddings in a dataset repository, so we will create one and push our embeddings there to pull later.
We will login to Hugging Face Hub, create a dataset repository there and push our indexes there and load using <code>snapshot_download</code>.`,Fs,O,Ss,ss,Es,es,Hs,ts,ue="We can load the embeddings to the dataset with no embeddings using <code>load_faiss_index</code>.",Ls,ls,Ks,as,Ps,ns,Ds,is,Os;return u=new Ce({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/faiss_with_hf_datasets_and_clip.ipynb"}]}}),w=new se({props:{title:"Embedding multimodal data for similarity search using 🤗 transformers, 🤗 datasets and FAISS",local:"embedding-multimodal-data-for-similarity-search-using--transformers--datasets-and-faiss",headingTag:"h1"}}),b=new M({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTIwZmFpc3MtZ3B1JTIwdHJhbnNmb3JtZXJzJTIwc2VudGVuY2VwaWVjZQ==",highlighted:"!pip install -q datasets faiss-gpu transformers sentencepiece",wrap:!1}}),f=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTJDJTIwQXV0b01vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMGZhaXNzJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMTYlMjIpLnRvKGRldmljZSklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haSUyRmNsaXAtdml0LWJhc2UtcGF0Y2gxNiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWklMkZjbGlwLXZpdC1iYXNlLXBhdGNoMTYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel, AutoTokenizer
<span class="hljs-keyword">import</span> faiss
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>).to(device)
processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai/clip-vit-base-patch16&quot;</span>)`,wrap:!1}}),T=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyam1oZXNzZWwlMkZuZXd5b3JrZXJfY2FwdGlvbl9jb250ZXN0JTIyJTJDJTIwJTIyZXhwbGFuYXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;jmhessel/newyorker_caption_contest&quot;</span>, <span class="hljs-string">&quot;explanation&quot;</span>)`,wrap:!1}}),C=new M({props:{code:"ZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RA==",highlighted:'ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>]',wrap:!1}}),I=new M({props:{code:"ZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQlNUIlMjJpbWFnZV9kZXNjcmlwdGlvbiUyMiU1RA==",highlighted:'ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image_description&quot;</span>]',wrap:!1}}),k=new M({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRzJTVCJTIydHJhaW4lMjIlNUQlMEFkc193aXRoX2VtYmVkZGluZ3MlMjAlM0QlMjBkYXRhc2V0Lm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBleGFtcGxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW1iZWRkaW5ncyUyMiUzQSUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqdG9rZW5pemVyKCU1QmV4YW1wbGUlNUIlMjJpbWFnZV9kZXNjcmlwdGlvbiUyMiU1RCU1RCUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5kZXRhY2goKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5jcHUoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC5udW1weSgpJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`dataset = ds[<span class="hljs-string">&quot;train&quot;</span>]
ds_with_embeddings = dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> example: {
        <span class="hljs-string">&quot;embeddings&quot;</span>: model.get_text_features(
            **tokenizer([example[<span class="hljs-string">&quot;image_description&quot;</span>]], truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
        )[<span class="hljs-number">0</span>]
        .detach()
        .cpu()
        .numpy()
    }
)`,wrap:!1}}),G=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLmFkZF9mYWlzc19pbmRleChjb2x1bW4lM0QlMjJlbWJlZGRpbmdzJTIyKQ==",highlighted:'ds_with_embeddings.add_faiss_index(column=<span class="hljs-string">&quot;embeddings&quot;</span>)',wrap:!1}}),V=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzJTIwJTNEJTIwZHNfd2l0aF9lbWJlZGRpbmdzLm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjBleGFtcGxlJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUzQSUyMG1vZGVsLmdldF9pbWFnZV9mZWF0dXJlcygqKnByb2Nlc3NvciglNUJleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSklNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLmRldGFjaCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLmNwdSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLm51bXB5KCklMEElMjAlMjAlMjAlMjAlN0QlMEEp",highlighted:`ds_with_embeddings = ds_with_embeddings.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> example: {
        <span class="hljs-string">&quot;image_embeddings&quot;</span>: model.get_image_features(**processor([example[<span class="hljs-string">&quot;image&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[
            <span class="hljs-number">0</span>
        ]
        .detach()
        .cpu()
        .numpy()
    }
)`,wrap:!1}}),X=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLmFkZF9mYWlzc19pbmRleChjb2x1bW4lM0QlMjJpbWFnZV9lbWJlZGRpbmdzJTIyKQ==",highlighted:'ds_with_embeddings.add_faiss_index(column=<span class="hljs-string">&quot;image_embeddings&quot;</span>)',wrap:!1}}),R=new se({props:{title:"Querying the data with text prompts",local:"querying-the-data-with-text-prompts",headingTag:"h2"}}),q=new M({props:{code:"cHJtdCUyMCUzRCUyMCUyMmElMjBzbm93eSUyMGRheSUyMiUwQXBybXRfZW1iZWRkaW5nJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsLmdldF90ZXh0X2ZlYXR1cmVzKCoqdG9rZW5pemVyKCU1QnBybXQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpLnRvKCUyMmN1ZGElMjIpKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAuZGV0YWNoKCklMEElMjAlMjAlMjAlMjAuY3B1KCklMEElMjAlMjAlMjAlMjAubnVtcHkoKSUwQSklMEFzY29yZXMlMkMlMjByZXRyaWV2ZWRfZXhhbXBsZXMlMjAlM0QlMjBkc193aXRoX2VtYmVkZGluZ3MuZ2V0X25lYXJlc3RfZXhhbXBsZXMoJTIyZW1iZWRkaW5ncyUyMiUyQyUyMHBybXRfZW1iZWRkaW5nJTJDJTIwayUzRDEp",highlighted:`prmt = <span class="hljs-string">&quot;a snowy day&quot;</span>
prmt_embedding = (
    model.get_text_features(**tokenizer([prmt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)
scores, retrieved_examples = ds_with_embeddings.get_nearest_examples(<span class="hljs-string">&quot;embeddings&quot;</span>, prmt_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),Q=new M({props:{code:"ZGVmJTIwZG93bnNjYWxlX2ltYWdlcyhpbWFnZSklM0ElMEElMjAlMjAlMjAlMjB3aWR0aCUyMCUzRCUyMDIwMCUwQSUyMCUyMCUyMCUyMHJhdGlvJTIwJTNEJTIwd2lkdGglMjAlMkYlMjBmbG9hdChpbWFnZS5zaXplJTVCMCU1RCklMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBpbnQoKGZsb2F0KGltYWdlLnNpemUlNUIxJTVEKSUyMColMjBmbG9hdChyYXRpbykpKSUwQSUyMCUyMCUyMCUyMGltZyUyMCUzRCUyMGltYWdlLnJlc2l6ZSgod2lkdGglMkMlMjBoZWlnaHQpJTJDJTIwSW1hZ2UuUmVzYW1wbGluZy5MQU5DWk9TKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltZyUwQSUwQSUwQWltYWdlcyUyMCUzRCUyMCU1QmRvd25zY2FsZV9pbWFnZXMoaW1hZ2UpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMHJldHJpZXZlZF9leGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIzJTIwc2VlJTIwdGhlJTIwY2xvc2VzdCUyMHRleHQlMjBhbmQlMjBpbWFnZSUwQXByaW50KHJldHJpZXZlZF9leGFtcGxlcyU1QiUyMmltYWdlX2Rlc2NyaXB0aW9uJTIyJTVEKSUwQWRpc3BsYXkoaW1hZ2VzJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">downscale_images</span>(<span class="hljs-params">image</span>):
<span class="hljs-meta">... </span>    width = <span class="hljs-number">200</span>
<span class="hljs-meta">... </span>    ratio = width / <span class="hljs-built_in">float</span>(image.size[<span class="hljs-number">0</span>])
<span class="hljs-meta">... </span>    height = <span class="hljs-built_in">int</span>((<span class="hljs-built_in">float</span>(image.size[<span class="hljs-number">1</span>]) * <span class="hljs-built_in">float</span>(ratio)))
<span class="hljs-meta">... </span>    img = image.resize((width, height), Image.Resampling.LANCZOS)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img


<span class="hljs-meta">&gt;&gt;&gt; </span>images = [downscale_images(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see the closest text and image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_examples[<span class="hljs-string">&quot;image_description&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(images[<span class="hljs-number">0</span>])`,wrap:!1}}),N=new se({props:{title:"Querying the data with image prompts",local:"querying-the-data-with-image-prompts",headingTag:"h2"}}),x=new M({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBpbWFnZSUyMG9mJTIwYSUyMGJlYXZlciUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRmJlYXZlci5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFkaXNwbGF5KGRvd25zY2FsZV9pbWFnZXMoaW1hZ2UpKQ==",highlighted:`<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># image of a beaver</span>
url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/beaver.png&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
display(downscale_images(image))`,wrap:!1}}),Y=new M({props:{code:"aW1nX2VtYmVkZGluZyUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKipwcm9jZXNzb3IoJTVCaW1hZ2UlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpLnRvKCUyMmN1ZGElMjIpKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAuZGV0YWNoKCklMEElMjAlMjAlMjAlMjAuY3B1KCklMEElMjAlMjAlMjAlMjAubnVtcHkoKSUwQSklMEFzY29yZXMlMkMlMjByZXRyaWV2ZWRfZXhhbXBsZXMlMjAlM0QlMjBkc193aXRoX2VtYmVkZGluZ3MuZ2V0X25lYXJlc3RfZXhhbXBsZXMoJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUyQyUyMGltZ19lbWJlZGRpbmclMkMlMjBrJTNEMSk=",highlighted:`img_embedding = (
    model.get_image_features(**processor([image], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)
scores, retrieved_examples = ds_with_embeddings.get_nearest_examples(<span class="hljs-string">&quot;image_embeddings&quot;</span>, img_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),S=new M({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCZG93bnNjYWxlX2ltYWdlcyhpbWFnZSklMjBmb3IlMjBpbWFnZSUyMGluJTIwcmV0cmlldmVkX2V4YW1wbGVzJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMEElMjMlMjBzZWUlMjB0aGUlMjBjbG9zZXN0JTIwdGV4dCUyMGFuZCUyMGltYWdlJTBBcHJpbnQocmV0cmlldmVkX2V4YW1wbGVzJTVCJTIyaW1hZ2VfZGVzY3JpcHRpb24lMjIlNUQpJTBBZGlzcGxheShpbWFnZXMlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = [downscale_images(image) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see the closest text and image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_examples[<span class="hljs-string">&quot;image_description&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>display(images[<span class="hljs-number">0</span>])`,wrap:!1}}),H=new se({props:{title:"Saving, pushing and loading the embeddings",local:"saving-pushing-and-loading-the-embeddings",headingTag:"h2"}}),K=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLnNhdmVfZmFpc3NfaW5kZXgoJTIyZW1iZWRkaW5ncyUyMiUyQyUyMCUyMmVtYmVkZGluZ3MlMkZlbWJlZGRpbmdzLmZhaXNzJTIyKQ==",highlighted:'ds_with_embeddings.save_faiss_index(<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;embeddings/embeddings.faiss&quot;</span>)',wrap:!1}}),P=new M({props:{code:"ZHNfd2l0aF9lbWJlZGRpbmdzLnNhdmVfZmFpc3NfaW5kZXgoJTIyaW1hZ2VfZW1iZWRkaW5ncyUyMiUyQyUyMCUyMmVtYmVkZGluZ3MlMkZpbWFnZV9lbWJlZGRpbmdzLmZhaXNzJTIyKQ==",highlighted:'ds_with_embeddings.save_faiss_index(<span class="hljs-string">&quot;image_embeddings&quot;</span>, <span class="hljs-string">&quot;embeddings/image_embeddings.faiss&quot;</span>)',wrap:!1}}),O=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTJDJTIwbm90ZWJvb2tfbG9naW4lMkMlMjBzbmFwc2hvdF9kb3dubG9hZCUwQSUwQW5vdGVib29rX2xvZ2luKCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, notebook_login, snapshot_download

notebook_login()`,wrap:!1}}),ss=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmQXBpJTBBJTBBYXBpJTIwJTNEJTIwSGZBcGkoKSUwQWFwaS5jcmVhdGVfcmVwbyglMjJtZXJ2ZSUyRmZhaXNzX2VtYmVkZGluZ3MlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKSUwQWFwaS51cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEJTIyLiUyRmVtYmVkZGluZ3MlMjIlMkMlMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIybWVydmUlMkZmYWlzc19lbWJlZGRpbmdzJTIyJTJDJTBBJTIwJTIwJTIwJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi

api = HfApi()
api.create_repo(<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
api.upload_folder(
    folder_path=<span class="hljs-string">&quot;./embeddings&quot;</span>,
    repo_id=<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>,
    repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
)`,wrap:!1}}),es=new M({props:{code:"c25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMm1lcnZlJTJGZmFpc3NfZW1iZWRkaW5ncyUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMjBsb2NhbF9kaXIlM0QlMjJkb3dubG9hZGVkX2VtYmVkZGluZ3MlMjIp",highlighted:'snapshot_download(repo_id=<span class="hljs-string">&quot;merve/faiss_embeddings&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, local_dir=<span class="hljs-string">&quot;downloaded_embeddings&quot;</span>)',wrap:!1}}),ls=new M({props:{code:"ZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVEJTBBZHMubG9hZF9mYWlzc19pbmRleCglMjJlbWJlZGRpbmdzJTIyJTJDJTIwJTIyLiUyRmRvd25sb2FkZWRfZW1iZWRkaW5ncyUyRmVtYmVkZGluZ3MuZmFpc3MlMjIpJTBBJTIzJTIwaW5mZXIlMjBhZ2FpbiUwQXBybXQlMjAlM0QlMjAlMjJwZW9wbGUlMjB1bmRlciUyMHRoZSUyMHJhaW4lMjI=",highlighted:`ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
ds.load_faiss_index(<span class="hljs-string">&quot;embeddings&quot;</span>, <span class="hljs-string">&quot;./downloaded_embeddings/embeddings.faiss&quot;</span>)
<span class="hljs-comment"># infer again</span>
prmt = <span class="hljs-string">&quot;people under the rain&quot;</span>`,wrap:!1}}),as=new M({props:{code:"cHJtdF9lbWJlZGRpbmclMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwbW9kZWwuZ2V0X3RleHRfZmVhdHVyZXMoKip0b2tlbml6ZXIoJTVCcHJtdCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSkudG8oJTIyY3VkYSUyMikpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMC5kZXRhY2goKSUwQSUyMCUyMCUyMCUyMC5jcHUoKSUwQSUyMCUyMCUyMCUyMC5udW1weSgpJTBBKSUwQSUwQXNjb3JlcyUyQyUyMHJldHJpZXZlZF9leGFtcGxlcyUyMCUzRCUyMGRzLmdldF9uZWFyZXN0X2V4YW1wbGVzKCUyMmVtYmVkZGluZ3MlMjIlMkMlMjBwcm10X2VtYmVkZGluZyUyQyUyMGslM0QxKQ==",highlighted:`prmt_embedding = (
    model.get_text_features(**tokenizer([prmt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, truncation=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>))[<span class="hljs-number">0</span>]
    .detach()
    .cpu()
    .numpy()
)

scores, retrieved_examples = ds.get_nearest_examples(<span class="hljs-string">&quot;embeddings&quot;</span>, prmt_embedding, k=<span class="hljs-number">1</span>)`,wrap:!1}}),ns=new M({props:{code:"ZGlzcGxheShyZXRyaWV2ZWRfZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQp",highlighted:'display(retrieved_examples[<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>])',wrap:!1}}),{c(){g=y("meta"),ms=a(),ps=y("p"),os=a(),p(u.$$.fragment),ds=a(),p(w.$$.fragment),rs=a(),J=y("p"),J.innerHTML=te,Ms=a(),j=y("p"),j.textContent=le,ys=a(),p(b.$$.fragment),hs=a(),U=y("p"),U.innerHTML=ae,cs=a(),p(f.$$.fragment),gs=a(),Z=y("p"),Z.innerHTML=ne,us=a(),p(T.$$.fragment),ws=a(),$=y("p"),$.textContent=pe,Js=a(),p(C.$$.fragment),js=a(),p(I.$$.fragment),bs=a(),W=y("p"),W.innerHTML=ie,Us=a(),p(k.$$.fragment),fs=a(),p(G.$$.fragment),Zs=a(),_=y("p"),_.textContent=me,Ts=a(),p(V.$$.fragment),$s=a(),p(X.$$.fragment),Cs=a(),p(R.$$.fragment),Is=a(),B=y("p"),B.textContent=oe,Ws=a(),p(q.$$.fragment),ks=a(),p(Q.$$.fragment),Gs=a(),v=y("pre"),v.textContent=de,_s=a(),p(N.$$.fragment),Vs=a(),A=y("p"),A.innerHTML=re,Xs=a(),p(x.$$.fragment),Rs=a(),z=y("p"),z.textContent=Me,Bs=a(),p(Y.$$.fragment),qs=a(),F=y("p"),F.textContent=ye,Qs=a(),p(S.$$.fragment),vs=a(),E=y("pre"),E.textContent=he,Ns=a(),p(H.$$.fragment),As=a(),L=y("p"),L.innerHTML=ce,xs=a(),p(K.$$.fragment),zs=a(),p(P.$$.fragment),Ys=a(),D=y("p"),D.innerHTML=ge,Fs=a(),p(O.$$.fragment),Ss=a(),p(ss.$$.fragment),Es=a(),p(es.$$.fragment),Hs=a(),ts=y("p"),ts.innerHTML=ue,Ls=a(),p(ls.$$.fragment),Ks=a(),p(as.$$.fragment),Ps=a(),p(ns.$$.fragment),Ds=a(),is=y("p"),this.h()},l(s){const e=Te("svelte-u9bgzb",document.head);g=h(e,"META",{name:!0,content:!0}),e.forEach(t),ms=n(s),ps=h(s,"P",{}),we(ps).forEach(t),os=n(s),i(u.$$.fragment,s),ds=n(s),i(w.$$.fragment,s),rs=n(s),J=h(s,"P",{"data-svelte-h":!0}),c(J)!=="svelte-1qlbcgs"&&(J.innerHTML=te),Ms=n(s),j=h(s,"P",{"data-svelte-h":!0}),c(j)!=="svelte-zwp9uq"&&(j.textContent=le),ys=n(s),i(b.$$.fragment,s),hs=n(s),U=h(s,"P",{"data-svelte-h":!0}),c(U)!=="svelte-sn5lc0"&&(U.innerHTML=ae),cs=n(s),i(f.$$.fragment,s),gs=n(s),Z=h(s,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-1wmuyvg"&&(Z.innerHTML=ne),us=n(s),i(T.$$.fragment,s),ws=n(s),$=h(s,"P",{"data-svelte-h":!0}),c($)!=="svelte-1gyk1gq"&&($.textContent=pe),Js=n(s),i(C.$$.fragment,s),js=n(s),i(I.$$.fragment,s),bs=n(s),W=h(s,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1t8sl7t"&&(W.innerHTML=ie),Us=n(s),i(k.$$.fragment,s),fs=n(s),i(G.$$.fragment,s),Zs=n(s),_=h(s,"P",{"data-svelte-h":!0}),c(_)!=="svelte-hqeotv"&&(_.textContent=me),Ts=n(s),i(V.$$.fragment,s),$s=n(s),i(X.$$.fragment,s),Cs=n(s),i(R.$$.fragment,s),Is=n(s),B=h(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-1ik94z"&&(B.textContent=oe),Ws=n(s),i(q.$$.fragment,s),ks=n(s),i(Q.$$.fragment,s),Gs=n(s),v=h(s,"PRE",{"data-svelte-h":!0}),c(v)!=="svelte-uwozqd"&&(v.textContent=de),_s=n(s),i(N.$$.fragment,s),Vs=n(s),A=h(s,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1rpqt4z"&&(A.innerHTML=re),Xs=n(s),i(x.$$.fragment,s),Rs=n(s),z=h(s,"P",{"data-svelte-h":!0}),c(z)!=="svelte-dx7tpa"&&(z.textContent=Me),Bs=n(s),i(Y.$$.fragment,s),qs=n(s),F=h(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-l7920"&&(F.textContent=ye),Qs=n(s),i(S.$$.fragment,s),vs=n(s),E=h(s,"PRE",{"data-svelte-h":!0}),c(E)!=="svelte-17oljg4"&&(E.textContent=he),Ns=n(s),i(H.$$.fragment,s),As=n(s),L=h(s,"P",{"data-svelte-h":!0}),c(L)!=="svelte-19kef5w"&&(L.innerHTML=ce),xs=n(s),i(K.$$.fragment,s),zs=n(s),i(P.$$.fragment,s),Ys=n(s),D=h(s,"P",{"data-svelte-h":!0}),c(D)!=="svelte-14p0fu2"&&(D.innerHTML=ge),Fs=n(s),i(O.$$.fragment,s),Ss=n(s),i(ss.$$.fragment,s),Es=n(s),i(es.$$.fragment,s),Hs=n(s),ts=h(s,"P",{"data-svelte-h":!0}),c(ts)!=="svelte-1duibn7"&&(ts.innerHTML=ue),Ls=n(s),i(ls.$$.fragment,s),Ks=n(s),i(as.$$.fragment,s),Ps=n(s),i(ns.$$.fragment,s),Ds=n(s),is=h(s,"P",{}),we(is).forEach(t),this.h()},h(){Je(g,"name","hf:doc:metadata"),Je(g,"content",We)},m(s,e){$e(document.head,g),l(s,ms,e),l(s,ps,e),l(s,os,e),m(u,s,e),l(s,ds,e),m(w,s,e),l(s,rs,e),l(s,J,e),l(s,Ms,e),l(s,j,e),l(s,ys,e),m(b,s,e),l(s,hs,e),l(s,U,e),l(s,cs,e),m(f,s,e),l(s,gs,e),l(s,Z,e),l(s,us,e),m(T,s,e),l(s,ws,e),l(s,$,e),l(s,Js,e),m(C,s,e),l(s,js,e),m(I,s,e),l(s,bs,e),l(s,W,e),l(s,Us,e),m(k,s,e),l(s,fs,e),m(G,s,e),l(s,Zs,e),l(s,_,e),l(s,Ts,e),m(V,s,e),l(s,$s,e),m(X,s,e),l(s,Cs,e),m(R,s,e),l(s,Is,e),l(s,B,e),l(s,Ws,e),m(q,s,e),l(s,ks,e),m(Q,s,e),l(s,Gs,e),l(s,v,e),l(s,_s,e),m(N,s,e),l(s,Vs,e),l(s,A,e),l(s,Xs,e),m(x,s,e),l(s,Rs,e),l(s,z,e),l(s,Bs,e),m(Y,s,e),l(s,qs,e),l(s,F,e),l(s,Qs,e),m(S,s,e),l(s,vs,e),l(s,E,e),l(s,Ns,e),m(H,s,e),l(s,As,e),l(s,L,e),l(s,xs,e),m(K,s,e),l(s,zs,e),m(P,s,e),l(s,Ys,e),l(s,D,e),l(s,Fs,e),m(O,s,e),l(s,Ss,e),m(ss,s,e),l(s,Es,e),m(es,s,e),l(s,Hs,e),l(s,ts,e),l(s,Ls,e),m(ls,s,e),l(s,Ks,e),m(as,s,e),l(s,Ps,e),m(ns,s,e),l(s,Ds,e),l(s,is,e),Os=!0},p:be,i(s){Os||(o(u.$$.fragment,s),o(w.$$.fragment,s),o(b.$$.fragment,s),o(f.$$.fragment,s),o(T.$$.fragment,s),o(C.$$.fragment,s),o(I.$$.fragment,s),o(k.$$.fragment,s),o(G.$$.fragment,s),o(V.$$.fragment,s),o(X.$$.fragment,s),o(R.$$.fragment,s),o(q.$$.fragment,s),o(Q.$$.fragment,s),o(N.$$.fragment,s),o(x.$$.fragment,s),o(Y.$$.fragment,s),o(S.$$.fragment,s),o(H.$$.fragment,s),o(K.$$.fragment,s),o(P.$$.fragment,s),o(O.$$.fragment,s),o(ss.$$.fragment,s),o(es.$$.fragment,s),o(ls.$$.fragment,s),o(as.$$.fragment,s),o(ns.$$.fragment,s),Os=!0)},o(s){d(u.$$.fragment,s),d(w.$$.fragment,s),d(b.$$.fragment,s),d(f.$$.fragment,s),d(T.$$.fragment,s),d(C.$$.fragment,s),d(I.$$.fragment,s),d(k.$$.fragment,s),d(G.$$.fragment,s),d(V.$$.fragment,s),d(X.$$.fragment,s),d(R.$$.fragment,s),d(q.$$.fragment,s),d(Q.$$.fragment,s),d(N.$$.fragment,s),d(x.$$.fragment,s),d(Y.$$.fragment,s),d(S.$$.fragment,s),d(H.$$.fragment,s),d(K.$$.fragment,s),d(P.$$.fragment,s),d(O.$$.fragment,s),d(ss.$$.fragment,s),d(es.$$.fragment,s),d(ls.$$.fragment,s),d(as.$$.fragment,s),d(ns.$$.fragment,s),Os=!1},d(s){s&&(t(ms),t(ps),t(os),t(ds),t(rs),t(J),t(Ms),t(j),t(ys),t(hs),t(U),t(cs),t(gs),t(Z),t(us),t(ws),t($),t(Js),t(js),t(bs),t(W),t(Us),t(fs),t(Zs),t(_),t(Ts),t($s),t(Cs),t(Is),t(B),t(Ws),t(ks),t(Gs),t(v),t(_s),t(Vs),t(A),t(Xs),t(Rs),t(z),t(Bs),t(qs),t(F),t(Qs),t(vs),t(E),t(Ns),t(As),t(L),t(xs),t(zs),t(Ys),t(D),t(Fs),t(Ss),t(Es),t(Hs),t(ts),t(Ls),t(Ks),t(Ps),t(Ds),t(is)),t(g),r(u,s),r(w,s),r(b,s),r(f,s),r(T,s),r(C,s),r(I,s),r(k,s),r(G,s),r(V,s),r(X,s),r(R,s),r(q,s),r(Q,s),r(N,s),r(x,s),r(Y,s),r(S,s),r(H,s),r(K,s),r(P,s),r(O,s),r(ss,s),r(es,s),r(ls,s),r(as,s),r(ns,s)}}}const We='{"title":"Embedding multimodal data for similarity search using 🤗 transformers, 🤗 datasets and FAISS","local":"embedding-multimodal-data-for-similarity-search-using--transformers--datasets-and-faiss","sections":[{"title":"Querying the data with text prompts","local":"querying-the-data-with-text-prompts","sections":[],"depth":2},{"title":"Querying the data with image prompts","local":"querying-the-data-with-image-prompts","sections":[],"depth":2},{"title":"Saving, pushing and loading the embeddings","local":"saving-pushing-and-loading-the-embeddings","sections":[],"depth":2}],"depth":1}';function ke(ee){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Re extends fe{constructor(g){super(),Ze(this,g,ke,Ie,je,{})}}export{Re as component};
