import{s as ot,n as it,o as Mt}from"../chunks/scheduler.39a43cde.js";import{S as pt,i as mt,g as o,s as n,r as p,A as rt,h as i,f as t,c as a,j as nt,u as m,x as M,k as at,y as ct,a as s,v as r,d as c,t as y,w as d}from"../chunks/index.23ec2204.js";import{D as yt,C as w}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as j,E as dt}from"../chunks/EditOnGithub.f2d09226.js";function wt(Ze){let J,gl,Tl,bl,h,Il,u,fl,T,Be='作者: <a href="https://huggingface.co/RichmondMongo" rel="nofollow">Richmond Alake</a>',Cl,U,Zl,g,Ge="这些命令是用来安装一些软件包的，这些软件包可以帮助你使用和操作 LLMs，处理数据，并且和数据库进行交流。这些库简化了RAG系统的开发，将复杂性减少到少量的代码：",Bl,b,ve="<li>PyMongo：一个用于与 MongoDB 交互的 Python 库，它提供了连接到集群和查询存储在集合和文档中的数据的功能。</li> <li>Pandas：提供了一个数据结构，用于使用 Python 进行高效的数据处理和分析。</li> <li>Hugging Face datasets：包含音频、视觉和文本数据集。</li> <li>Hugging Face Accelerate：抽象了编写利用硬件加速器（如GPU）的代码的复杂性。在实现中，利用 Accelerate 在 GPU 资源上利用 Gemma 模型。</li> <li>Hugging Face Transformers：访问大量预训练模型。</li> <li>Hugging Face Sentence Transformers：提供对句子、文本和图像嵌入的访问。</li>",Gl,I,vl,f,Wl,C,We='本教程使用的数据来源于 Hugging Face datasets，具体是 <a href="https://huggingface.co/datasets/AIatMongoDB/embedded_movies" rel="nofollow">AIatMongoDB/embedded_movies 数据集</a>。',Al,Z,$l,B,Ae="以下代码片段中的操作侧重于确保数据的完整性和质量。",Rl,G,$e="<li>第一个过程确保每个数据点的 <code>fullplot</code> 属性不为空，因为这是我们嵌入过程中主要使用的数据。</li> <li>这一步还确保我们移除所有数据点的 <code>plot_embedding</code> 属性，因为这将被一个不同的嵌入模型 <code>gte-large</code> 创建的新嵌入所替换。</li>",kl,v,Vl,W,Re=`Number of missing values in each column after removal:
num_mflix_comments      0
genres                  0
countries               0
directors              12
fullplot                0
writers                13
awards                  0
runtime                14
type                    0
rated                 279
metacritic            893
poster                 78
languages               1
imdb                    0
plot                    0
cast                    1
plot_embedding          1
title                   0
dtype: int64
`,Ql,A,_l,$,ke="<strong>代码片段中的步骤如下：</strong>",Nl,R,Ve="<li>导入 <code>SentenceTransformer</code> 类以访问嵌入模型。</li> <li>使用 <code>SentenceTransformer</code> 构造函数加载嵌入模型，以实例化 <code>gte-large</code> 嵌入模型。</li> <li>定义 <code>get_embedding</code> 函数，该函数接受一个文本字符串作为输入，并返回一个代表嵌入的浮点数列表。该函数首先检查输入文本是否为空（去除空白后）。如果文本为空，则返回一个空列表。否则，它使用加载的模型生成嵌入。</li> <li>通过将 <code>get_embedding</code> 函数应用于 <code>dataset_df</code> DataFrame 的 “fullplot” 列，为每个电影的剧情生成嵌入。生成的嵌入列表被分配到一个名为 embedding 的新列中。</li>",El,k,Qe="<em>注意：由于我们可以确保文本长度保持在可管理的范围内，因此不需要对完整剧情文本进行分块处理。</em>",Xl,V,Sl,Q,ql,_,_e="MongoDB 既是一个操作数据库，也是一个向量数据库。它提供了一个数据库解决方案，有效地存储、查询和检索向量嵌入。其优势在于数据库维护、管理和成本的简单性。",xl,N,Ne="<strong>创建新的 MongoDB 数据库，设置数据库集群：</strong>",Fl,E,Ee='<li><p>前往MongoDB官网，注册一个<a href="https://www.mongodb.com/cloud/atlas/register?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alake" rel="nofollow">免费的 MongoDB Atlas 账户</a>，或者对于现有用户，<a href="https://account.mongodb.com/account/login?utm_campaign=devrel&amp;utm_source=community&amp;utm_medium=cta&amp;utm_content=Partner%20Cookbook&amp;utm_term=richmond.alakee" rel="nofollow">登录 MongoDB Atlas</a>。</p></li> <li><p>在左侧窗格中选择 ‘Database’ 选项，这将导航到数据库部署页面，你可以在其中查看任何现有集群的部署规格。点击 “+Create” 按钮，创建一个新的数据库集群。</p></li> <li><p>选择适用于数据库集群的所有配置。选择所有配置选项后，点击 “Create Cluster” 按钮以部署新创建的集群。MongoDB 还在 “Shared Tab” 上启用了免费集群的创建。</p> <p><em>注意：创建概念证明时，不要忘记将 Python 主机的 IP 列入白名单，或设置 0.0.0.0/0 用于任何IP。</em></p></li> <li><p>成功创建和部署集群后，集群将在 ‘Database Deployment’ 页面中变得可访问。</p></li> <li><p>点击集群的 “Connect” 按钮，查看通过各种语言驱动程序设置与集群的连接的选项。</p></li> <li><p>本教程只需要集群的 URI（唯一资源标识符）。获取 URI 并将其复制到 Google Colabs Secrets 环境中的名为 <code>MONGO_URI</code> 的变量中，或者将其放入 .env 文件或等效文件中。</p></li>',Yl,X,Hl,S,Xe="在继续之前，请确保满足以下先决条件",zl,q,Se="<li>在 MongoDB Atlas 上设置数据库集群</li> <li>获取到你的集群的 URI</li>",Pl,x,qe='有关数据库集群设置和获取 URI 的帮助，请参阅我们的指南：<a href="https://www.mongodb.com/docs/guides/atlas/cluster/" rel="nofollow">设置 MongoDB 集群</a>和<a href="https://www.mongodb.com/docs/guides/atlas/connection-string/" rel="nofollow">获取你的连接字符串</a>',Dl,F,xe="创建集群后，通过在集群概览页面点击+创建数据库，在 MongoDB Atlas 集群中创建数据库和集合。",Ll,Y,Fe=`这里有关于<a href="https://www.mongodb.com/basics/create-database" rel="nofollow">创建数据库和集合</a>的指南
<strong>数据库将被命名为 <code>movies</code>。</strong> <strong>集合将被命名为 <code>movie_collection_2</code>。</strong>`,Kl,H,Ol,z,Ye="在这一点上，请确保你的向量索引是通过 MongoDB Atlas 创建的。",le,P,He="接下来，你必须做一个非常重要的步骤，那就是在 <code>movie_collection_2</code> 这个数据库的文档里，为那些用来表示电影特点的向量建立一个特殊的搜索索引。这个索引就像是图书馆里的图书索引卡，它帮助计算机快速准确地找到与你的搜索最相似的电影向量。没有这个索引，计算机就得一篇一篇地翻找，效率会非常低。所以，建立这个索引是为了让搜索变得又快又准。",ee,D,ze='点击此处了解更多关于<a href="https://www.mongodb.com/docs/atlas/atlas-search/field-types/knn-vector/" rel="nofollow">MongoDB 向量搜索索引</a>的信息。',te,L,se,K,Pe="<code>numDimensions</code> 字段的 <code>1024</code> 值对应于由 gte-large 嵌入模型生成的向量的维度。如果你使用 <code>gte-base</code> 或 <code>gte-small</code> 嵌入模型，向量搜索索引中的 numDimensions 值必须分别设置为 768 和 384。",ne,O,ae,ll,De="下面的代码片段还使用了 PyMongo 来创建一个 MongoDB 客户端对象，该对象代表与集群的连接，并允许访问其数据库和集合。",oe,el,ie,tl,Le=`Connection to MongoDB successful
`,Me,sl,pe,nl,Ke="从 pandas DataFrame 中将数据导入 MongoDB 集合是一个简单的过程，可以通过将 DataFrame 转换为字典，然后在集合上使用 <code>insert_many</code> 方法来传递转换后的数据集记录，从而高效完成。",me,al,re,ol,Oe=`Data ingestion into MongoDB completed
`,ce,il,ye,Ml,lt="下一步实现了一个函数，该函数通过生成查询嵌入并定义一个 MongoDB 聚合流水线来返回一个向量搜索结果。",de,pl,et="该流水线包括 <code>$vectorSearch</code> 和 <code>$project</code> 阶段，它使用生成的向量执行查询，并格式化结果以仅包括所需信息，如剧情、标题和类型，同时为每个结果引入一个搜索分数。",we,ml,je,rl,Je,cl,he,yl,ue,dl,tt=`Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara's uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as "Pearl Harbor."
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship's maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne'er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo & Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.
`,Te,wl,Ue,jl,ge,Jl,st=`<bos>Query: What is the best romantic movie to watch and why?
Continue to answer the query by using the Search Results:
Title: Shut Up and Kiss Me!, Plot: Ryan and Pete are 27-year old best friends in Miami, born on the same day and each searching for the perfect woman. Ryan is a rookie stockbroker living with his psychic Mom. Pete is a slick surfer dude yet to find commitment. Each meets the women of their dreams on the same day. Ryan knocks heads in an elevator with the gorgeous Jessica, passing out before getting her number. Pete falls for the insatiable Tiara, but Tiara&#39;s uncle is mob boss Vincent Bublione, charged with her protection. This high-energy romantic comedy asks to what extent will you go for true love?
Title: Pearl Harbor, Plot: Pearl Harbor is a classic tale of romance set during a war that complicates everything. It all starts when childhood friends Rafe and Danny become Army Air Corps pilots and meet Evelyn, a Navy nurse. Rafe falls head over heels and next thing you know Evelyn and Rafe are hooking up. Then Rafe volunteers to go fight in Britain and Evelyn and Danny get transferred to Pearl Harbor. While Rafe is off fighting everything gets completely whack and next thing you know everybody is in the middle of an air raid we now know as &quot;Pearl Harbor.&quot;
Title: Titanic, Plot: The plot focuses on the romances of two couples upon the doomed ship&#39;s maiden voyage. Isabella Paradine (Catherine Zeta-Jones) is a wealthy woman mourning the loss of her aunt, who reignites a romance with former flame Wynn Park (Peter Gallagher). Meanwhile, a charming ne&#39;er-do-well named Jamie Perse (Mike Doyle) steals a ticket for the ship, and falls for a sweet innocent Irish girl on board. But their romance is threatened by the villainous Simon Doonan (Tim Curry), who has discovered about the ticket and makes Jamie his unwilling accomplice, as well as having sinister plans for the girl.
Title: China Girl, Plot: A modern day Romeo &amp; Juliet story is told in New York when an Italian boy and a Chinese girl become lovers, causing a tragic conflict between ethnic gangs.
.

Based on the search results, the best romantic movie to watch is **Shut Up and Kiss Me!** because it is a romantic comedy that explores the complexities of love and relationships. The movie is funny, heartwarming, and thought-provoking.<eos>
</eos></bos>`,be,hl,Ie,ul,fe,Ul,Ce;return h=new yt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_hugging_face_gemma_mongodb.ipynb"}]}}),u=new j({props:{title:"用 Gemma, MongoDB 和开源模型构建 RAG 系统",local:"用-gemma-mongodb-和开源模型构建-rag-系统",headingTag:"h1"}}),U=new j({props:{title:"第一步：安装库",local:"第一步安装库",headingTag:"h2"}}),I=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMHBhbmRhcyUyMHB5bW9uZ28lMjBzZW50ZW5jZV90cmFuc2Zvcm1lcnMlMEEhcGlwJTIwaW5zdGFsbCUyMC1VJTIwdHJhbnNmb3JtZXJzJTBBJTIzJTIwSW5zdGFsbCUyMGJlbG93JTIwaWYlMjB1c2luZyUyMEdQVSUwQSFwaXAlMjBpbnN0YWxsJTIwYWNjZWxlcmF0ZQ==",highlighted:`!pip install datasets pandas pymongo sentence_transformers
!pip install -U transformers
<span class="hljs-comment"># Install below if using GPU</span>
!pip install accelerate`,wrap:!1}}),f=new j({props:{title:"第二步：数据源选择和准备",local:"第二步数据源选择和准备",headingTag:"h2"}}),Z=new w({props:{code:"JTIzJTIwTG9hZCUyMERhdGFzZXQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGQUlhdE1vbmdvREIlMkZlbWJlZGRlZF9tb3ZpZXMlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMkFJYXRNb25nb0RCJTJGZW1iZWRkZWRfbW92aWVzJTIyKSUwQSUwQSUyMyUyMENvbnZlcnQlMjB0aGUlMjBkYXRhc2V0JTIwdG8lMjBhJTIwcGFuZGFzJTIwZGF0YWZyYW1lJTBBZGF0YXNldF9kZiUyMCUzRCUyMHBkLkRhdGFGcmFtZShkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQpJTBBJTBBZGF0YXNldF9kZi5oZWFkKDUp",highlighted:`<span class="hljs-comment"># Load Dataset</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-comment"># https://huggingface.co/datasets/AIatMongoDB/embedded_movies</span>
dataset = load_dataset(<span class="hljs-string">&quot;AIatMongoDB/embedded_movies&quot;</span>)

<span class="hljs-comment"># Convert the dataset to a pandas dataframe</span>
dataset_df = pd.DataFrame(dataset[<span class="hljs-string">&quot;train&quot;</span>])

dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),v=new w({props:{code:"JTIzJTIwRGF0YSUyMFByZXBhcmF0aW9uJTBBJTBBJTIzJTIwUmVtb3ZlJTIwZGF0YSUyMHBvaW50JTIwd2hlcmUlMjBwbG90JTIwY29sb3VtbiUyMGlzJTIwbWlzc2luZyUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3BuYShzdWJzZXQlM0QlNUIlMjJmdWxscGxvdCUyMiU1RCklMEFwcmludCglMjIlNUNuTnVtYmVyJTIwb2YlMjBtaXNzaW5nJTIwdmFsdWVzJTIwaW4lMjBlYWNoJTIwY29sdW1uJTIwYWZ0ZXIlMjByZW1vdmFsJTNBJTIyKSUwQXByaW50KGRhdGFzZXRfZGYuaXNudWxsKCkuc3VtKCkpJTBBJTBBJTIzJTIwUmVtb3ZlJTIwdGhlJTIwcGxvdF9lbWJlZGRpbmclMjBmcm9tJTIwZWFjaCUyMGRhdGElMjBwb2ludCUyMGluJTIwdGhlJTIwZGF0YXNldCUyMGFzJTIwd2UlMjBhcmUlMjBnb2luZyUyMHRvJTIwY3JlYXRlJTIwbmV3JTIwZW1iZWRkaW5ncyUyMHdpdGglMjBhbiUyMG9wZW4lMjBzb3VyY2UlMjBlbWJlZGRpbmclMjBtb2RlbCUyMGZyb20lMjBIdWdnaW5nJTIwRmFjZSUwQWRhdGFzZXRfZGYlMjAlM0QlMjBkYXRhc2V0X2RmLmRyb3AoY29sdW1ucyUzRCU1QiUyMnBsb3RfZW1iZWRkaW5nJTIyJTVEKSUwQWRhdGFzZXRfZGYuaGVhZCg1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Data Preparation</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove data point where plot coloumn is missing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.dropna(subset=[<span class="hljs-string">&quot;fullplot&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nNumber of missing values in each column after removal:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dataset_df.isnull().<span class="hljs-built_in">sum</span>())

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Remove the plot_embedding from each data point in the dataset as we are going to create new embeddings with an open source embedding model from Hugging Face</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df = dataset_df.drop(columns=[<span class="hljs-string">&quot;plot_embedding&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_df.head(<span class="hljs-number">5</span>)`,wrap:!1}}),A=new j({props:{title:"第三步：生成嵌入",local:"第三步生成嵌入",headingTag:"h2"}}),V=new w({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGdGhlbmxwZXIlMkZndGUtbGFyZ2UlMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKCUyMnRoZW5scGVyJTJGZ3RlLWxhcmdlJTIyKSUwQSUwQSUwQWRlZiUyMGdldF9lbWJlZGRpbmcodGV4dCUzQSUyMHN0ciklMjAtJTNFJTIwbGlzdCU1QmZsb2F0JTVEJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjB0ZXh0LnN0cmlwKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCglMjJBdHRlbXB0ZWQlMjB0byUyMGdldCUyMGVtYmVkZGluZyUyMGZvciUyMGVtcHR5JTIwdGV4dC4lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCJTVEJTBBJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nJTIwJTNEJTIwZW1iZWRkaW5nX21vZGVsLmVuY29kZSh0ZXh0KSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGVtYmVkZGluZy50b2xpc3QoKSUwQSUwQSUwQWRhdGFzZXRfZGYlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjBkYXRhc2V0X2RmJTVCJTIyZnVsbHBsb3QlMjIlNUQuYXBwbHkoZ2V0X2VtYmVkZGluZyklMEElMEFkYXRhc2V0X2RmLmhlYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-comment"># https://huggingface.co/thenlper/gte-large</span>
embedding_model = SentenceTransformer(<span class="hljs-string">&quot;thenlper/gte-large&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_embedding</span>(<span class="hljs-params">text: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">list</span>[<span class="hljs-built_in">float</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> text.strip():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Attempted to get embedding for empty text.&quot;</span>)
        <span class="hljs-keyword">return</span> []

    embedding = embedding_model.encode(text)

    <span class="hljs-keyword">return</span> embedding.tolist()


dataset_df[<span class="hljs-string">&quot;embedding&quot;</span>] = dataset_df[<span class="hljs-string">&quot;fullplot&quot;</span>].apply(get_embedding)

dataset_df.head()`,wrap:!1}}),Q=new j({props:{title:"第4步：数据库设置和连接",local:"第4步数据库设置和连接",headingTag:"h2"}}),X=new j({props:{title:"4.1 数据库和集合设置",local:"41-数据库和集合设置",headingTag:"h3"}}),H=new j({props:{title:"第5步：创建向量搜索索引",local:"第5步创建向量搜索索引",headingTag:"h2"}}),L=new w({props:{code:"JTdCJTBBJTIwJTIyZmllbGRzJTIyJTNBJTIwJTVCJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIybnVtRGltZW5zaW9ucyUyMiUzQSUyMDEwMjQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjJwYXRoJTIyJTNBJTIwJTIyZW1iZWRkaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIyc2ltaWxhcml0eSUyMiUzQSUyMCUyMmNvc2luZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ2ZWN0b3IlMjIlMEElMjAlMjAlMjAlN0QlNUQlMEElN0Q=",highlighted:`{
 <span class="hljs-string">&quot;fields&quot;</span>: [{
     <span class="hljs-string">&quot;numDimensions&quot;</span>: <span class="hljs-number">1024</span>,
     <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
     <span class="hljs-string">&quot;similarity&quot;</span>: <span class="hljs-string">&quot;cosine&quot;</span>,
     <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;vector&quot;</span>
   }]
}`,wrap:!1}}),O=new j({props:{title:"第6步：建立数据连接",local:"第6步建立数据连接",headingTag:"h2"}}),el=new w({props:{code:"aW1wb3J0JTIwcHltb25nbyUwQWZyb20lMjBnb29nbGUuY29sYWIlMjBpbXBvcnQlMjB1c2VyZGF0YSUwQSUwQSUwQWRlZiUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkVzdGFibGlzaCUyMGNvbm5lY3Rpb24lMjB0byUyMHRoZSUyME1vbmdvREIuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2xpZW50JTIwJTNEJTIwcHltb25nby5Nb25nb0NsaWVudChtb25nb191cmkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIyQ29ubmVjdGlvbiUyMHRvJTIwTW9uZ29EQiUyMHN1Y2Nlc3NmdWwlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2xpZW50JTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwcHltb25nby5lcnJvcnMuQ29ubmVjdGlvbkZhaWx1cmUlMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyQ29ubmVjdGlvbiUyMGZhaWxlZCUzQSUyMCU3QmUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwTm9uZSUwQSUwQSUwQW1vbmdvX3VyaSUyMCUzRCUyMHVzZXJkYXRhLmdldCglMjJNT05HT19VUkklMjIpJTBBaWYlMjBub3QlMjBtb25nb191cmklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJNT05HT19VUkklMjBub3QlMjBzZXQlMjBpbiUyMGVudmlyb25tZW50JTIwdmFyaWFibGVzJTIyKSUwQSUwQW1vbmdvX2NsaWVudCUyMCUzRCUyMGdldF9tb25nb19jbGllbnQobW9uZ29fdXJpKSUwQSUwQSUyMyUyMEluZ2VzdCUyMGRhdGElMjBpbnRvJTIwTW9uZ29EQiUwQWRiJTIwJTNEJTIwbW9uZ29fY2xpZW50JTVCJTIybW92aWVzJTIyJTVEJTBBY29sbGVjdGlvbiUyMCUzRCUyMGRiJTVCJTIybW92aWVfY29sbGVjdGlvbl8yJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pymongo
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> google.colab <span class="hljs-keyword">import</span> userdata


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_mongo_client</span>(<span class="hljs-params">mongo_uri</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Establish connection to the MongoDB.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        client = pymongo.MongoClient(mongo_uri)
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Connection to MongoDB successful&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> client
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span> pymongo.errors.ConnectionFailure <span class="hljs-keyword">as</span> e:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Connection failed: <span class="hljs-subst">{e}</span>&quot;</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>


<span class="hljs-meta">... </span>mongo_uri = userdata.get(<span class="hljs-string">&quot;MONGO_URI&quot;</span>)
<span class="hljs-meta">... </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> mongo_uri:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;MONGO_URI not set in environment variables&quot;</span>)

<span class="hljs-meta">... </span>mongo_client = get_mongo_client(mongo_uri)

<span class="hljs-meta">... </span><span class="hljs-comment"># Ingest data into MongoDB</span>
<span class="hljs-meta">... </span>db = mongo_client[<span class="hljs-string">&quot;movies&quot;</span>]
<span class="hljs-meta">... </span>collection = db[<span class="hljs-string">&quot;movie_collection_2&quot;</span>]`,wrap:!1}}),sl=new w({props:{code:"JTIzJTIwRGVsZXRlJTIwYW55JTIwZXhpc3RpbmclMjByZWNvcmRzJTIwaW4lMjB0aGUlMjBjb2xsZWN0aW9uJTBBY29sbGVjdGlvbi5kZWxldGVfbWFueSglN0IlN0Qp",highlighted:`<span class="hljs-comment"># Delete any existing records in the collection</span>
collection.delete_many({})`,wrap:!1}}),al=new w({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldF9kZi50b19kaWN0KCUyMnJlY29yZHMlMjIpJTBBY29sbGVjdGlvbi5pbnNlcnRfbWFueShkb2N1bWVudHMpJTBBJTBBcHJpbnQoJTIyRGF0YSUyMGluZ2VzdGlvbiUyMGludG8lMjBNb25nb0RCJTIwY29tcGxldGVkJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>documents = dataset_df.to_dict(<span class="hljs-string">&quot;records&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>collection.insert_many(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Data ingestion into MongoDB completed&quot;</span>)`,wrap:!1}}),il=new j({props:{title:"第7步：对用户查询执行向量搜索",local:"第7步对用户查询执行向量搜索",headingTag:"h2"}}),ml=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">vector_search</span>(<span class="hljs-params">user_query, collection</span>):
    <span class="hljs-string">&quot;&quot;&quot;
    Perform a vector search in the MongoDB collection based on the user query.

    Args:
    user_query (str): The user&#x27;s query string.
    collection (MongoCollection): The MongoDB collection to search.

    Returns:
    list: A list of matching documents.
    &quot;&quot;&quot;</span>

    <span class="hljs-comment"># Generate embedding for the user query</span>
    query_embedding = get_embedding(user_query)

    <span class="hljs-keyword">if</span> query_embedding <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Invalid query or embedding generation failed.&quot;</span>

    <span class="hljs-comment"># Define the vector search pipeline</span>
    pipeline = [
        {
            <span class="hljs-string">&quot;$vectorSearch&quot;</span>: {
                <span class="hljs-string">&quot;index&quot;</span>: <span class="hljs-string">&quot;vector_index&quot;</span>,
                <span class="hljs-string">&quot;queryVector&quot;</span>: query_embedding,
                <span class="hljs-string">&quot;path&quot;</span>: <span class="hljs-string">&quot;embedding&quot;</span>,
                <span class="hljs-string">&quot;numCandidates&quot;</span>: <span class="hljs-number">150</span>,  <span class="hljs-comment"># Number of candidate matches to consider</span>
                <span class="hljs-string">&quot;limit&quot;</span>: <span class="hljs-number">4</span>,  <span class="hljs-comment"># Return top 4 matches</span>
            }
        },
        {
            <span class="hljs-string">&quot;$project&quot;</span>: {
                <span class="hljs-string">&quot;_id&quot;</span>: <span class="hljs-number">0</span>,  <span class="hljs-comment"># Exclude the _id field</span>
                <span class="hljs-string">&quot;fullplot&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the plot field</span>
                <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the title field</span>
                <span class="hljs-string">&quot;genres&quot;</span>: <span class="hljs-number">1</span>,  <span class="hljs-comment"># Include the genres field</span>
                <span class="hljs-string">&quot;score&quot;</span>: {<span class="hljs-string">&quot;$meta&quot;</span>: <span class="hljs-string">&quot;vectorSearchScore&quot;</span>},  <span class="hljs-comment"># Include the search score</span>
            }
        },
    ]

    <span class="hljs-comment"># Execute the search</span>
    results = collection.aggregate(pipeline)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(results)`,wrap:!1}}),rl=new j({props:{title:"第 8 步：处理用户查询和加载 Gemma",local:"第-8-步处理用户查询和加载-gemma",headingTag:"h2"}}),cl=new w({props:{code:"ZGVmJTIwZ2V0X3NlYXJjaF9yZXN1bHQocXVlcnklMkMlMjBjb2xsZWN0aW9uKSUzQSUwQSUwQSUyMCUyMCUyMCUyMGdldF9rbm93bGVkZ2UlMjAlM0QlMjB2ZWN0b3Jfc2VhcmNoKHF1ZXJ5JTJDJTIwY29sbGVjdGlvbiklMEElMEElMjAlMjAlMjAlMjBzZWFyY2hfcmVzdWx0JTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwZm9yJTIwcmVzdWx0JTIwaW4lMjBnZXRfa25vd2xlZGdlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VhcmNoX3Jlc3VsdCUyMCUyQiUzRCUyMGYlMjJUaXRsZSUzQSUyMCU3QnJlc3VsdC5nZXQoJ3RpdGxlJyUyQyUyMCdOJTJGQScpJTdEJTJDJTIwUGxvdCUzQSUyMCU3QnJlc3VsdC5nZXQoJ2Z1bGxwbG90JyUyQyUyMCdOJTJGQScpJTdEJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlYXJjaF9yZXN1bHQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_search_result</span>(<span class="hljs-params">query, collection</span>):

    get_knowledge = vector_search(query, collection)

    search_result = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> result <span class="hljs-keyword">in</span> get_knowledge:
        search_result += <span class="hljs-string">f&quot;Title: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>, Plot: <span class="hljs-subst">{result.get(<span class="hljs-string">&#x27;fullplot&#x27;</span>, <span class="hljs-string">&#x27;N/A&#x27;</span>)}</span>\\n&quot;</span>

    <span class="hljs-keyword">return</span> search_result`,wrap:!1}}),yl=new w({props:{code:"JTIzJTIwQ29uZHVjdCUyMHF1ZXJ5JTIwd2l0aCUyMHJldHJpdmFsJTIwb2YlMjBzb3VyY2VzJTBBcXVlcnklMjAlM0QlMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBiZXN0JTIwcm9tYW50aWMlMjBtb3ZpZSUyMHRvJTIwd2F0Y2glMjBhbmQlMjB3aHklM0YlMjIlMEFzb3VyY2VfaW5mb3JtYXRpb24lMjAlM0QlMjBnZXRfc2VhcmNoX3Jlc3VsdChxdWVyeSUyQyUyMGNvbGxlY3Rpb24pJTBBY29tYmluZWRfaW5mb3JtYXRpb24lMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwZiUyMlF1ZXJ5JTNBJTIwJTdCcXVlcnklN0QlNUNuQ29udGludWUlMjB0byUyMGFuc3dlciUyMHRoZSUyMHF1ZXJ5JTIwYnklMjB1c2luZyUyMHRoZSUyMFNlYXJjaCUyMFJlc3VsdHMlM0ElNUNuJTdCc291cmNlX2luZm9ybWF0aW9uJTdELiUyMiUwQSklMEElMEFwcmludChjb21iaW5lZF9pbmZvcm1hdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Conduct query with retrival of sources</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;What is the best romantic movie to watch and why?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source_information = get_search_result(query, collection)
<span class="hljs-meta">&gt;&gt;&gt; </span>combined_information = (
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;Query: <span class="hljs-subst">{query}</span>\\nContinue to answer the query by using the Search Results:\\n<span class="hljs-subst">{source_information}</span>.&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(combined_information)`,wrap:!1}}),wl=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMENQVSUyMEVuYWJsZWQlMjB1bmNvbW1lbnQlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQSUyMyUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyKSUwQSUyMyUyMEdQVSUyMEVuYWJsZWQlMjB1c2UlMjBiZWxvdyUyMCVGMCU5RiU5MSU4NyVGMCU5RiU4RiVCRCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRmdlbW1hLTJiLWl0JTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>)
<span class="hljs-comment"># CPU Enabled uncomment below 👇🏽</span>
<span class="hljs-comment"># model = AutoModelForCausalLM.from_pretrained(&quot;google/gemma-2b-it&quot;)</span>
<span class="hljs-comment"># GPU Enabled use below 👇🏽</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),jl=new w({props:{code:"JTIzJTIwTW92aW5nJTIwdGVuc29ycyUyMHRvJTIwR1BVJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGNvbWJpbmVkX2luZm9ybWF0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEFyZXNwb25zZSUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MDApJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShyZXNwb25zZSU1QjAlNUQpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Moving tensors to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(combined_information, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">500</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(response[<span class="hljs-number">0</span>]))`,wrap:!1}}),hl=new w({props:{code:"",highlighted:"",wrap:!1}}),ul=new dt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_hugging_face_gemma_mongodb.md"}}),{c(){J=o("meta"),gl=n(),Tl=o("p"),bl=n(),p(h.$$.fragment),Il=n(),p(u.$$.fragment),fl=n(),T=o("p"),T.innerHTML=Be,Cl=n(),p(U.$$.fragment),Zl=n(),g=o("p"),g.textContent=Ge,Bl=n(),b=o("ul"),b.innerHTML=ve,Gl=n(),p(I.$$.fragment),vl=n(),p(f.$$.fragment),Wl=n(),C=o("p"),C.innerHTML=We,Al=n(),p(Z.$$.fragment),$l=n(),B=o("p"),B.textContent=Ae,Rl=n(),G=o("ol"),G.innerHTML=$e,kl=n(),p(v.$$.fragment),Vl=n(),W=o("pre"),W.textContent=Re,Ql=n(),p(A.$$.fragment),_l=n(),$=o("p"),$.innerHTML=ke,Nl=n(),R=o("ol"),R.innerHTML=Ve,El=n(),k=o("p"),k.innerHTML=Qe,Xl=n(),p(V.$$.fragment),Sl=n(),p(Q.$$.fragment),ql=n(),_=o("p"),_.textContent=_e,xl=n(),N=o("p"),N.innerHTML=Ne,Fl=n(),E=o("ol"),E.innerHTML=Ee,Yl=n(),p(X.$$.fragment),Hl=n(),S=o("p"),S.textContent=Xe,zl=n(),q=o("ul"),q.innerHTML=Se,Pl=n(),x=o("p"),x.innerHTML=qe,Dl=n(),F=o("p"),F.textContent=xe,Ll=n(),Y=o("p"),Y.innerHTML=Fe,Kl=n(),p(H.$$.fragment),Ol=n(),z=o("p"),z.textContent=Ye,le=n(),P=o("p"),P.innerHTML=He,ee=n(),D=o("p"),D.innerHTML=ze,te=n(),p(L.$$.fragment),se=n(),K=o("p"),K.innerHTML=Pe,ne=n(),p(O.$$.fragment),ae=n(),ll=o("p"),ll.textContent=De,oe=n(),p(el.$$.fragment),ie=n(),tl=o("pre"),tl.textContent=Le,Me=n(),p(sl.$$.fragment),pe=n(),nl=o("p"),nl.innerHTML=Ke,me=n(),p(al.$$.fragment),re=n(),ol=o("pre"),ol.textContent=Oe,ce=n(),p(il.$$.fragment),ye=n(),Ml=o("p"),Ml.textContent=lt,de=n(),pl=o("p"),pl.innerHTML=et,we=n(),p(ml.$$.fragment),je=n(),p(rl.$$.fragment),Je=n(),p(cl.$$.fragment),he=n(),p(yl.$$.fragment),ue=n(),dl=o("pre"),dl.textContent=tt,Te=n(),p(wl.$$.fragment),Ue=n(),p(jl.$$.fragment),ge=n(),Jl=o("pre"),Jl.innerHTML=st,be=n(),p(hl.$$.fragment),Ie=n(),p(ul.$$.fragment),fe=n(),Ul=o("p"),this.h()},l(l){const e=rt("svelte-u9bgzb",document.head);J=i(e,"META",{name:!0,content:!0}),e.forEach(t),gl=a(l),Tl=i(l,"P",{}),nt(Tl).forEach(t),bl=a(l),m(h.$$.fragment,l),Il=a(l),m(u.$$.fragment,l),fl=a(l),T=i(l,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1vszw9g"&&(T.innerHTML=Be),Cl=a(l),m(U.$$.fragment,l),Zl=a(l),g=i(l,"P",{"data-svelte-h":!0}),M(g)!=="svelte-u6la52"&&(g.textContent=Ge),Bl=a(l),b=i(l,"UL",{"data-svelte-h":!0}),M(b)!=="svelte-iqfcsi"&&(b.innerHTML=ve),Gl=a(l),m(I.$$.fragment,l),vl=a(l),m(f.$$.fragment,l),Wl=a(l),C=i(l,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1gfpttb"&&(C.innerHTML=We),Al=a(l),m(Z.$$.fragment,l),$l=a(l),B=i(l,"P",{"data-svelte-h":!0}),M(B)!=="svelte-ngtyyl"&&(B.textContent=Ae),Rl=a(l),G=i(l,"OL",{"data-svelte-h":!0}),M(G)!=="svelte-10co0v6"&&(G.innerHTML=$e),kl=a(l),m(v.$$.fragment,l),Vl=a(l),W=i(l,"PRE",{"data-svelte-h":!0}),M(W)!=="svelte-kp0u3c"&&(W.textContent=Re),Ql=a(l),m(A.$$.fragment,l),_l=a(l),$=i(l,"P",{"data-svelte-h":!0}),M($)!=="svelte-12iz6l2"&&($.innerHTML=ke),Nl=a(l),R=i(l,"OL",{"data-svelte-h":!0}),M(R)!=="svelte-1faddxl"&&(R.innerHTML=Ve),El=a(l),k=i(l,"P",{"data-svelte-h":!0}),M(k)!=="svelte-uxqg8f"&&(k.innerHTML=Qe),Xl=a(l),m(V.$$.fragment,l),Sl=a(l),m(Q.$$.fragment,l),ql=a(l),_=i(l,"P",{"data-svelte-h":!0}),M(_)!=="svelte-8l9pnm"&&(_.textContent=_e),xl=a(l),N=i(l,"P",{"data-svelte-h":!0}),M(N)!=="svelte-6ptxn4"&&(N.innerHTML=Ne),Fl=a(l),E=i(l,"OL",{"data-svelte-h":!0}),M(E)!=="svelte-1mveug4"&&(E.innerHTML=Ee),Yl=a(l),m(X.$$.fragment,l),Hl=a(l),S=i(l,"P",{"data-svelte-h":!0}),M(S)!=="svelte-gtitnq"&&(S.textContent=Xe),zl=a(l),q=i(l,"UL",{"data-svelte-h":!0}),M(q)!=="svelte-1ppslbn"&&(q.innerHTML=Se),Pl=a(l),x=i(l,"P",{"data-svelte-h":!0}),M(x)!=="svelte-2mkqud"&&(x.innerHTML=qe),Dl=a(l),F=i(l,"P",{"data-svelte-h":!0}),M(F)!=="svelte-u5d956"&&(F.textContent=xe),Ll=a(l),Y=i(l,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-otqthu"&&(Y.innerHTML=Fe),Kl=a(l),m(H.$$.fragment,l),Ol=a(l),z=i(l,"P",{"data-svelte-h":!0}),M(z)!=="svelte-uj2n3d"&&(z.textContent=Ye),le=a(l),P=i(l,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1cjc449"&&(P.innerHTML=He),ee=a(l),D=i(l,"P",{"data-svelte-h":!0}),M(D)!=="svelte-1h6byj8"&&(D.innerHTML=ze),te=a(l),m(L.$$.fragment,l),se=a(l),K=i(l,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1wb5wve"&&(K.innerHTML=Pe),ne=a(l),m(O.$$.fragment,l),ae=a(l),ll=i(l,"P",{"data-svelte-h":!0}),M(ll)!=="svelte-450yot"&&(ll.textContent=De),oe=a(l),m(el.$$.fragment,l),ie=a(l),tl=i(l,"PRE",{"data-svelte-h":!0}),M(tl)!=="svelte-1im4pel"&&(tl.textContent=Le),Me=a(l),m(sl.$$.fragment,l),pe=a(l),nl=i(l,"P",{"data-svelte-h":!0}),M(nl)!=="svelte-18w6gf8"&&(nl.innerHTML=Ke),me=a(l),m(al.$$.fragment,l),re=a(l),ol=i(l,"PRE",{"data-svelte-h":!0}),M(ol)!=="svelte-48vgel"&&(ol.textContent=Oe),ce=a(l),m(il.$$.fragment,l),ye=a(l),Ml=i(l,"P",{"data-svelte-h":!0}),M(Ml)!=="svelte-1aayevm"&&(Ml.textContent=lt),de=a(l),pl=i(l,"P",{"data-svelte-h":!0}),M(pl)!=="svelte-eogwiv"&&(pl.innerHTML=et),we=a(l),m(ml.$$.fragment,l),je=a(l),m(rl.$$.fragment,l),Je=a(l),m(cl.$$.fragment,l),he=a(l),m(yl.$$.fragment,l),ue=a(l),dl=i(l,"PRE",{"data-svelte-h":!0}),M(dl)!=="svelte-kam1j9"&&(dl.textContent=tt),Te=a(l),m(wl.$$.fragment,l),Ue=a(l),m(jl.$$.fragment,l),ge=a(l),Jl=i(l,"PRE",{"data-svelte-h":!0}),M(Jl)!=="svelte-146jypo"&&(Jl.innerHTML=st),be=a(l),m(hl.$$.fragment,l),Ie=a(l),m(ul.$$.fragment,l),fe=a(l),Ul=i(l,"P",{}),nt(Ul).forEach(t),this.h()},h(){at(J,"name","hf:doc:metadata"),at(J,"content",jt)},m(l,e){ct(document.head,J),s(l,gl,e),s(l,Tl,e),s(l,bl,e),r(h,l,e),s(l,Il,e),r(u,l,e),s(l,fl,e),s(l,T,e),s(l,Cl,e),r(U,l,e),s(l,Zl,e),s(l,g,e),s(l,Bl,e),s(l,b,e),s(l,Gl,e),r(I,l,e),s(l,vl,e),r(f,l,e),s(l,Wl,e),s(l,C,e),s(l,Al,e),r(Z,l,e),s(l,$l,e),s(l,B,e),s(l,Rl,e),s(l,G,e),s(l,kl,e),r(v,l,e),s(l,Vl,e),s(l,W,e),s(l,Ql,e),r(A,l,e),s(l,_l,e),s(l,$,e),s(l,Nl,e),s(l,R,e),s(l,El,e),s(l,k,e),s(l,Xl,e),r(V,l,e),s(l,Sl,e),r(Q,l,e),s(l,ql,e),s(l,_,e),s(l,xl,e),s(l,N,e),s(l,Fl,e),s(l,E,e),s(l,Yl,e),r(X,l,e),s(l,Hl,e),s(l,S,e),s(l,zl,e),s(l,q,e),s(l,Pl,e),s(l,x,e),s(l,Dl,e),s(l,F,e),s(l,Ll,e),s(l,Y,e),s(l,Kl,e),r(H,l,e),s(l,Ol,e),s(l,z,e),s(l,le,e),s(l,P,e),s(l,ee,e),s(l,D,e),s(l,te,e),r(L,l,e),s(l,se,e),s(l,K,e),s(l,ne,e),r(O,l,e),s(l,ae,e),s(l,ll,e),s(l,oe,e),r(el,l,e),s(l,ie,e),s(l,tl,e),s(l,Me,e),r(sl,l,e),s(l,pe,e),s(l,nl,e),s(l,me,e),r(al,l,e),s(l,re,e),s(l,ol,e),s(l,ce,e),r(il,l,e),s(l,ye,e),s(l,Ml,e),s(l,de,e),s(l,pl,e),s(l,we,e),r(ml,l,e),s(l,je,e),r(rl,l,e),s(l,Je,e),r(cl,l,e),s(l,he,e),r(yl,l,e),s(l,ue,e),s(l,dl,e),s(l,Te,e),r(wl,l,e),s(l,Ue,e),r(jl,l,e),s(l,ge,e),s(l,Jl,e),s(l,be,e),r(hl,l,e),s(l,Ie,e),r(ul,l,e),s(l,fe,e),s(l,Ul,e),Ce=!0},p:it,i(l){Ce||(c(h.$$.fragment,l),c(u.$$.fragment,l),c(U.$$.fragment,l),c(I.$$.fragment,l),c(f.$$.fragment,l),c(Z.$$.fragment,l),c(v.$$.fragment,l),c(A.$$.fragment,l),c(V.$$.fragment,l),c(Q.$$.fragment,l),c(X.$$.fragment,l),c(H.$$.fragment,l),c(L.$$.fragment,l),c(O.$$.fragment,l),c(el.$$.fragment,l),c(sl.$$.fragment,l),c(al.$$.fragment,l),c(il.$$.fragment,l),c(ml.$$.fragment,l),c(rl.$$.fragment,l),c(cl.$$.fragment,l),c(yl.$$.fragment,l),c(wl.$$.fragment,l),c(jl.$$.fragment,l),c(hl.$$.fragment,l),c(ul.$$.fragment,l),Ce=!0)},o(l){y(h.$$.fragment,l),y(u.$$.fragment,l),y(U.$$.fragment,l),y(I.$$.fragment,l),y(f.$$.fragment,l),y(Z.$$.fragment,l),y(v.$$.fragment,l),y(A.$$.fragment,l),y(V.$$.fragment,l),y(Q.$$.fragment,l),y(X.$$.fragment,l),y(H.$$.fragment,l),y(L.$$.fragment,l),y(O.$$.fragment,l),y(el.$$.fragment,l),y(sl.$$.fragment,l),y(al.$$.fragment,l),y(il.$$.fragment,l),y(ml.$$.fragment,l),y(rl.$$.fragment,l),y(cl.$$.fragment,l),y(yl.$$.fragment,l),y(wl.$$.fragment,l),y(jl.$$.fragment,l),y(hl.$$.fragment,l),y(ul.$$.fragment,l),Ce=!1},d(l){l&&(t(gl),t(Tl),t(bl),t(Il),t(fl),t(T),t(Cl),t(Zl),t(g),t(Bl),t(b),t(Gl),t(vl),t(Wl),t(C),t(Al),t($l),t(B),t(Rl),t(G),t(kl),t(Vl),t(W),t(Ql),t(_l),t($),t(Nl),t(R),t(El),t(k),t(Xl),t(Sl),t(ql),t(_),t(xl),t(N),t(Fl),t(E),t(Yl),t(Hl),t(S),t(zl),t(q),t(Pl),t(x),t(Dl),t(F),t(Ll),t(Y),t(Kl),t(Ol),t(z),t(le),t(P),t(ee),t(D),t(te),t(se),t(K),t(ne),t(ae),t(ll),t(oe),t(ie),t(tl),t(Me),t(pe),t(nl),t(me),t(re),t(ol),t(ce),t(ye),t(Ml),t(de),t(pl),t(we),t(je),t(Je),t(he),t(ue),t(dl),t(Te),t(Ue),t(ge),t(Jl),t(be),t(Ie),t(fe),t(Ul)),t(J),d(h,l),d(u,l),d(U,l),d(I,l),d(f,l),d(Z,l),d(v,l),d(A,l),d(V,l),d(Q,l),d(X,l),d(H,l),d(L,l),d(O,l),d(el,l),d(sl,l),d(al,l),d(il,l),d(ml,l),d(rl,l),d(cl,l),d(yl,l),d(wl,l),d(jl,l),d(hl,l),d(ul,l)}}}const jt='{"title":"用 Gemma, MongoDB 和开源模型构建 RAG 系统","local":"用-gemma-mongodb-和开源模型构建-rag-系统","sections":[{"title":"第一步：安装库","local":"第一步安装库","sections":[],"depth":2},{"title":"第二步：数据源选择和准备","local":"第二步数据源选择和准备","sections":[],"depth":2},{"title":"第三步：生成嵌入","local":"第三步生成嵌入","sections":[],"depth":2},{"title":"第4步：数据库设置和连接","local":"第4步数据库设置和连接","sections":[{"title":"4.1 数据库和集合设置","local":"41-数据库和集合设置","sections":[],"depth":3}],"depth":2},{"title":"第5步：创建向量搜索索引","local":"第5步创建向量搜索索引","sections":[],"depth":2},{"title":"第6步：建立数据连接","local":"第6步建立数据连接","sections":[],"depth":2},{"title":"第7步：对用户查询执行向量搜索","local":"第7步对用户查询执行向量搜索","sections":[],"depth":2},{"title":"第 8 步：处理用户查询和加载 Gemma","local":"第-8-步处理用户查询和加载-gemma","sections":[],"depth":2}],"depth":1}';function Jt(Ze){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gt extends pt{constructor(J){super(),mt(this,J,Jt,wt,ot,{})}}export{gt as component};
