import{s as ft,n as vt,o as kt}from"../chunks/scheduler.65852ee5.js";import{S as Bt,i as At,g as M,s as n,r as o,A as $t,h as i,f as l,c as a,j as bt,u as y,x as w,k as gt,y as Zt,a as s,v as J,d as T,t as U,w as p}from"../chunks/index.65a1b999.js";import{D as _t,C as r}from"../chunks/DocNotebookDropdown.25e0a31d.js";import{H as Pe,E as St}from"../chunks/EditOnGithub.885169e7.js";function Gt(De){let C,Me,ne,ie,I,we,c,oe,m,Oe='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',ye,d,Ke='<p>This tutorial is advanced. You should have notions from <a href="agents">this other cookbook</a> first!</p>',Je,u,et="In this notebook we will make a <strong>multi-agent web browser: an agentic system with several agents collaborating to solve problems using the web!</strong>",Te,h,tt="It will be a simple hierarchy, using a <code>ManagedAgent</code> object to wrap the managed web search agent:",Ue,j,pe,b,lt="Let’s set up this system.",re,g,st="Run the line below to install the required dependencies:",Ce,f,Ie,v,nt="Let’s login in order to call the HF Inference API:",ce,k,me,B,at='⚡️ Our agent will be powered by <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a> using <code>HfApiEngine</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',de,A,Mt='<em>Note:</em> The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.',ue,$,he,Z,je,_,it='For web browsing, we can already use our pre-existing <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/agents/search.py" rel="nofollow"><code>DuckDuckGoSearchTool</code></a> tool to provide a Google search equivalent.',be,S,wt=`But then we will also need to be able to peak into the page found by the <code>DuckDuckGoSearchTool</code>.
To do so, we could import the library’s built-in <code>VisitWebpageTool</code>, but we will build it again to see how it’s done.`,ge,G,ot="So let’s create our <code>VisitWebpageTool</code> tool from scratch using <code>markdownify</code>.",fe,W,ve,Q,yt="Ok, now let’s initialize and test our tool!",ke,L,Be,R,Jt=`Hugging Face - Wikipedia

[Jump to content](#bodyContent)

Main menu

Main menu
move to sidebar
hide

Navigation

* [Main page](/wiki/Main_Page "Visit the main page [z]")
* [Contents](/wiki/Wikipedia:Contents "Guides to browsing Wikipedia")
* [Current events](/wiki/Portal:Current_events "Articles related to current events")
* [Random article](/wiki/Special:Random "Visit a randomly selected article [x]")
* [About Wikipedia](/wiki/Wikipedia:About "Learn about Wikipedia and how it works")
* [Contac
`,Ae,V,$e,x,Tt="Now that we have all the tools <code>search</code> and <code>visit_webpage</code>, we can use them to create the web agent.",Ze,H,Ut="Which configuration to choose for this agent?",_e,X,pt="<li>Web browsing is a single-timeline task that does not require parallel tool calls, so JSON tool calling works well for that. We thus choose a <code>ReactJsonAgent</code>.</li> <li>Also, since sometimes web search requires exploring many pages before finding the correct answer, we prefer to increase the number of <code>max_iterations</code> to 10.</li>",Se,N,Ge,E,rt="We then wrap this agent into a <code>ManagedAgent</code> that will make it callable by its manager agent.",We,q,Qe,F,Ct="Finally we create a manager agent, and upon initialization we pass our managed agent to it in its <code>managed_agents</code> argument.",Le,Y,It="Since this agent is the one tasked with the planning and thinking, advanced reasoning will be beneficial, so a <code>ReactCodeAgent</code> will be the best choice.",Re,z,ct="Also, we want to ask a question that involves the current year: so let us add <code>additional_authorized_imports=[&quot;time&quot;, &quot;datetime&quot;]</code>",Ve,P,xe,D,mt="That’s all! Now let’s run our system! We select a question that requires some calculation and",He,O,Xe,K,dt="Our agents managed to efficiently collaborate towards solving the task! ✅",Ne,ee,ut="💡 You can easily extend this to more agents: one does the code execution, one the web search, one handles file loadings…",Ee,te,ht="🤔💭 One could even think of doing more complex, tree-like hierarchies, with one CEO agent handling multiple middle managers, each with several reports.",qe,le,jt="We could even add more intermediate layers of management, each with multiple daily meetings, lots of agile stuff with scrum masters, and each new component adds enough friction to ensure the tasks never get done… Ehm wait, no, let’s stick with our simple structure.",Fe,se,Ye,ae,ze;return I=new _t({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/multiagent_web_assistant.ipynb"}]}}),c=new Pe({props:{title:"Have several agents collaborate in a multi-agent hierarchy 🤖🤝🤖",local:"have-several-agents-collaborate-in-a-multi-agent-hierarchy-",headingTag:"h1"}}),j=new r({props:{code:"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",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
  Code interpreter   +--------------------------------+
       tool          |<span class="hljs-string">         Managed agent          </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">      </span>|<span class="hljs-string"> Web Search agent </span>|<span class="hljs-string">      </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">         </span>|<span class="hljs-string">            </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">  Web Search tool     </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">             Visit webpage tool </span>|
                     +--------------------------------+`,wrap:!1}}),f=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjBtYXJrZG93bmlmeSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwc21vbGFnZW50cyUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install markdownify duckduckgo-search smolagents --upgrade -q",wrap:!1}}),k=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),$=new r({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjI=",highlighted:'model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>',wrap:!1}}),Z=new Pe({props:{title:"🔍 Create a web search tool",local:"-create-a-web-search-tool",headingTag:"h3"}}),W=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify <span class="hljs-keyword">as</span> md
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = md(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),L=new r({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),V=new Pe({props:{title:"Build our multi-agent system 🤖🤝🤖",local:"build-our-multi-agent-system-",headingTag:"h2"}}),N=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBUb29sQ2FsbGluZ0FnZW50JTJDJTIwSGZBcGlNb2RlbCUyQyUyME1hbmFnZWRBZ2VudCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBJTBBbW9kZWwlMjAlM0QlMjBIZkFwaU1vZGVsKG1vZGVsX2lkKSUwQSUwQXdlYl9hZ2VudCUyMCUzRCUyMFRvb2xDYWxsaW5nQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJEdWNrRHVja0dvU2VhcmNoVG9vbCgpJTJDJTIwdmlzaXRfd2VicGFnZSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYXhfaXRlcmF0aW9ucyUzRDEwJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, ToolCallingAgent, HfApiModel, ManagedAgent, DuckDuckGoSearchTool

model = HfApiModel(model_id)

web_agent = ToolCallingAgent(
    tools=[DuckDuckGoSearchTool(), visit_webpage],
    model=model,
    max_iterations=<span class="hljs-number">10</span>,
)`,wrap:!1}}),q=new r({props:{code:"bWFuYWdlZF93ZWJfYWdlbnQlMjAlM0QlMjBNYW5hZ2VkQWdlbnQoJTBBJTIwJTIwJTIwJTIwYWdlbnQlM0R3ZWJfYWdlbnQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VhcmNoX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJSdW5zJTIwd2ViJTIwc2VhcmNoZXMlMjBmb3IlMjB5b3UuJTIwR2l2ZSUyMGl0JTIweW91ciUyMHF1ZXJ5JTIwYXMlMjBhbiUyMGFyZ3VtZW50LiUyMiUyQyUwQSk=",highlighted:`managed_web_agent = ManagedAgent(
    agent=web_agent,
    name=<span class="hljs-string">&quot;search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>,
)`,wrap:!1}}),P=new r({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1Qm1hbmFnZWRfd2ViX2FnZW50JTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJ0aW1lJTIyJTJDJTIwJTIyZGF0ZXRpbWUlMjIlNUQlMkMlMEEp",highlighted:`manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[managed_web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;datetime&quot;</span>],
)`,wrap:!1}}),O=new r({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIySG93JTIwbWFueSUyMHllYXJzJTIwYWdvJTIwd2FzJTIwU3RyaXBlJTIwZm91bmRlZCUzRiUyMik=",highlighted:'manager_agent.run(<span class="hljs-string">&quot;How many years ago was Stripe founded?&quot;</span>)',wrap:!1}}),se=new St({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/multiagent_web_assistant.md"}}),{c(){C=M("meta"),Me=n(),ne=M("p"),ie=n(),o(I.$$.fragment),we=n(),o(c.$$.fragment),oe=n(),m=M("p"),m.innerHTML=Oe,ye=n(),d=M("blockquote"),d.innerHTML=Ke,Je=n(),u=M("p"),u.innerHTML=et,Te=n(),h=M("p"),h.innerHTML=tt,Ue=n(),o(j.$$.fragment),pe=n(),b=M("p"),b.textContent=lt,re=n(),g=M("p"),g.textContent=st,Ce=n(),o(f.$$.fragment),Ie=n(),v=M("p"),v.textContent=nt,ce=n(),o(k.$$.fragment),me=n(),B=M("p"),B.innerHTML=at,de=n(),A=M("p"),A.innerHTML=Mt,ue=n(),o($.$$.fragment),he=n(),o(Z.$$.fragment),je=n(),_=M("p"),_.innerHTML=it,be=n(),S=M("p"),S.innerHTML=wt,ge=n(),G=M("p"),G.innerHTML=ot,fe=n(),o(W.$$.fragment),ve=n(),Q=M("p"),Q.textContent=yt,ke=n(),o(L.$$.fragment),Be=n(),R=M("pre"),R.textContent=Jt,Ae=n(),o(V.$$.fragment),$e=n(),x=M("p"),x.innerHTML=Tt,Ze=n(),H=M("p"),H.textContent=Ut,_e=n(),X=M("ul"),X.innerHTML=pt,Se=n(),o(N.$$.fragment),Ge=n(),E=M("p"),E.innerHTML=rt,We=n(),o(q.$$.fragment),Qe=n(),F=M("p"),F.innerHTML=Ct,Le=n(),Y=M("p"),Y.innerHTML=It,Re=n(),z=M("p"),z.innerHTML=ct,Ve=n(),o(P.$$.fragment),xe=n(),D=M("p"),D.textContent=mt,He=n(),o(O.$$.fragment),Xe=n(),K=M("p"),K.textContent=dt,Ne=n(),ee=M("p"),ee.textContent=ut,Ee=n(),te=M("p"),te.textContent=ht,qe=n(),le=M("p"),le.textContent=jt,Fe=n(),o(se.$$.fragment),Ye=n(),ae=M("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);C=i(t,"META",{name:!0,content:!0}),t.forEach(l),Me=a(e),ne=i(e,"P",{}),bt(ne).forEach(l),ie=a(e),y(I.$$.fragment,e),we=a(e),y(c.$$.fragment,e),oe=a(e),m=i(e,"P",{"data-svelte-h":!0}),w(m)!=="svelte-1xlqnsv"&&(m.innerHTML=Oe),ye=a(e),d=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),w(d)!=="svelte-uy67xy"&&(d.innerHTML=Ke),Je=a(e),u=i(e,"P",{"data-svelte-h":!0}),w(u)!=="svelte-45abwn"&&(u.innerHTML=et),Te=a(e),h=i(e,"P",{"data-svelte-h":!0}),w(h)!=="svelte-1se9mth"&&(h.innerHTML=tt),Ue=a(e),y(j.$$.fragment,e),pe=a(e),b=i(e,"P",{"data-svelte-h":!0}),w(b)!=="svelte-1occiln"&&(b.textContent=lt),re=a(e),g=i(e,"P",{"data-svelte-h":!0}),w(g)!=="svelte-ofrdjq"&&(g.textContent=st),Ce=a(e),y(f.$$.fragment,e),Ie=a(e),v=i(e,"P",{"data-svelte-h":!0}),w(v)!=="svelte-64fox6"&&(v.textContent=nt),ce=a(e),y(k.$$.fragment,e),me=a(e),B=i(e,"P",{"data-svelte-h":!0}),w(B)!=="svelte-prbpzw"&&(B.innerHTML=at),de=a(e),A=i(e,"P",{"data-svelte-h":!0}),w(A)!=="svelte-1faawbb"&&(A.innerHTML=Mt),ue=a(e),y($.$$.fragment,e),he=a(e),y(Z.$$.fragment,e),je=a(e),_=i(e,"P",{"data-svelte-h":!0}),w(_)!=="svelte-1ya2chk"&&(_.innerHTML=it),be=a(e),S=i(e,"P",{"data-svelte-h":!0}),w(S)!=="svelte-n7spa8"&&(S.innerHTML=wt),ge=a(e),G=i(e,"P",{"data-svelte-h":!0}),w(G)!=="svelte-1ms2uj2"&&(G.innerHTML=ot),fe=a(e),y(W.$$.fragment,e),ve=a(e),Q=i(e,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-hbvg5t"&&(Q.textContent=yt),ke=a(e),y(L.$$.fragment,e),Be=a(e),R=i(e,"PRE",{"data-svelte-h":!0}),w(R)!=="svelte-28re01"&&(R.textContent=Jt),Ae=a(e),y(V.$$.fragment,e),$e=a(e),x=i(e,"P",{"data-svelte-h":!0}),w(x)!=="svelte-5768lo"&&(x.innerHTML=Tt),Ze=a(e),H=i(e,"P",{"data-svelte-h":!0}),w(H)!=="svelte-noa5rw"&&(H.textContent=Ut),_e=a(e),X=i(e,"UL",{"data-svelte-h":!0}),w(X)!=="svelte-4uouvt"&&(X.innerHTML=pt),Se=a(e),y(N.$$.fragment,e),Ge=a(e),E=i(e,"P",{"data-svelte-h":!0}),w(E)!=="svelte-1by3x3d"&&(E.innerHTML=rt),We=a(e),y(q.$$.fragment,e),Qe=a(e),F=i(e,"P",{"data-svelte-h":!0}),w(F)!=="svelte-12kldg5"&&(F.innerHTML=Ct),Le=a(e),Y=i(e,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-julrcm"&&(Y.innerHTML=It),Re=a(e),z=i(e,"P",{"data-svelte-h":!0}),w(z)!=="svelte-hvhtn0"&&(z.innerHTML=ct),Ve=a(e),y(P.$$.fragment,e),xe=a(e),D=i(e,"P",{"data-svelte-h":!0}),w(D)!=="svelte-1gu46sl"&&(D.textContent=mt),He=a(e),y(O.$$.fragment,e),Xe=a(e),K=i(e,"P",{"data-svelte-h":!0}),w(K)!=="svelte-ollz3q"&&(K.textContent=dt),Ne=a(e),ee=i(e,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-1v517hq"&&(ee.textContent=ut),Ee=a(e),te=i(e,"P",{"data-svelte-h":!0}),w(te)!=="svelte-58qi1z"&&(te.textContent=ht),qe=a(e),le=i(e,"P",{"data-svelte-h":!0}),w(le)!=="svelte-9myor3"&&(le.textContent=jt),Fe=a(e),y(se.$$.fragment,e),Ye=a(e),ae=i(e,"P",{}),bt(ae).forEach(l),this.h()},h(){gt(C,"name","hf:doc:metadata"),gt(C,"content",Wt)},m(e,t){Zt(document.head,C),s(e,Me,t),s(e,ne,t),s(e,ie,t),J(I,e,t),s(e,we,t),J(c,e,t),s(e,oe,t),s(e,m,t),s(e,ye,t),s(e,d,t),s(e,Je,t),s(e,u,t),s(e,Te,t),s(e,h,t),s(e,Ue,t),J(j,e,t),s(e,pe,t),s(e,b,t),s(e,re,t),s(e,g,t),s(e,Ce,t),J(f,e,t),s(e,Ie,t),s(e,v,t),s(e,ce,t),J(k,e,t),s(e,me,t),s(e,B,t),s(e,de,t),s(e,A,t),s(e,ue,t),J($,e,t),s(e,he,t),J(Z,e,t),s(e,je,t),s(e,_,t),s(e,be,t),s(e,S,t),s(e,ge,t),s(e,G,t),s(e,fe,t),J(W,e,t),s(e,ve,t),s(e,Q,t),s(e,ke,t),J(L,e,t),s(e,Be,t),s(e,R,t),s(e,Ae,t),J(V,e,t),s(e,$e,t),s(e,x,t),s(e,Ze,t),s(e,H,t),s(e,_e,t),s(e,X,t),s(e,Se,t),J(N,e,t),s(e,Ge,t),s(e,E,t),s(e,We,t),J(q,e,t),s(e,Qe,t),s(e,F,t),s(e,Le,t),s(e,Y,t),s(e,Re,t),s(e,z,t),s(e,Ve,t),J(P,e,t),s(e,xe,t),s(e,D,t),s(e,He,t),J(O,e,t),s(e,Xe,t),s(e,K,t),s(e,Ne,t),s(e,ee,t),s(e,Ee,t),s(e,te,t),s(e,qe,t),s(e,le,t),s(e,Fe,t),J(se,e,t),s(e,Ye,t),s(e,ae,t),ze=!0},p:vt,i(e){ze||(T(I.$$.fragment,e),T(c.$$.fragment,e),T(j.$$.fragment,e),T(f.$$.fragment,e),T(k.$$.fragment,e),T($.$$.fragment,e),T(Z.$$.fragment,e),T(W.$$.fragment,e),T(L.$$.fragment,e),T(V.$$.fragment,e),T(N.$$.fragment,e),T(q.$$.fragment,e),T(P.$$.fragment,e),T(O.$$.fragment,e),T(se.$$.fragment,e),ze=!0)},o(e){U(I.$$.fragment,e),U(c.$$.fragment,e),U(j.$$.fragment,e),U(f.$$.fragment,e),U(k.$$.fragment,e),U($.$$.fragment,e),U(Z.$$.fragment,e),U(W.$$.fragment,e),U(L.$$.fragment,e),U(V.$$.fragment,e),U(N.$$.fragment,e),U(q.$$.fragment,e),U(P.$$.fragment,e),U(O.$$.fragment,e),U(se.$$.fragment,e),ze=!1},d(e){e&&(l(Me),l(ne),l(ie),l(we),l(oe),l(m),l(ye),l(d),l(Je),l(u),l(Te),l(h),l(Ue),l(pe),l(b),l(re),l(g),l(Ce),l(Ie),l(v),l(ce),l(me),l(B),l(de),l(A),l(ue),l(he),l(je),l(_),l(be),l(S),l(ge),l(G),l(fe),l(ve),l(Q),l(ke),l(Be),l(R),l(Ae),l($e),l(x),l(Ze),l(H),l(_e),l(X),l(Se),l(Ge),l(E),l(We),l(Qe),l(F),l(Le),l(Y),l(Re),l(z),l(Ve),l(xe),l(D),l(He),l(Xe),l(K),l(Ne),l(ee),l(Ee),l(te),l(qe),l(le),l(Fe),l(Ye),l(ae)),l(C),p(I,e),p(c,e),p(j,e),p(f,e),p(k,e),p($,e),p(Z,e),p(W,e),p(L,e),p(V,e),p(N,e),p(q,e),p(P,e),p(O,e),p(se,e)}}}const Wt='{"title":"Have several agents collaborate in a multi-agent hierarchy 🤖🤝🤖","local":"have-several-agents-collaborate-in-a-multi-agent-hierarchy-","sections":[{"title":"🔍 Create a web search tool","local":"-create-a-web-search-tool","sections":[],"depth":3},{"title":"Build our multi-agent system 🤖🤝🤖","local":"build-our-multi-agent-system-","sections":[],"depth":2}],"depth":1}';function Qt(De){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ht extends Bt{constructor(C){super(),At(this,C,Qt,Gt,ft,{})}}export{Ht as component};
