import{s as Ut,n as gt,o as bt}from"../chunks/scheduler.85c25b89.js";import{S as At,i as ft,g as e,s as o,u as h,A as Ct,h as n,f as t,c as p,j as r,v as J,y as w,k as i,o as M,a,w as m,d as T,t as c,x as j}from"../chunks/index.9633332f.js";import{I as wl}from"../chunks/IconCopyLink.a4acffac.js";import{C as al}from"../chunks/CodeBlock.00597c71.js";function vt(Ll){let y,hl,el,Jl,d,b,nl,k,Vl,K,Pl="Adversarial Inception v3",ml,B,Dl='<strong>Inception v3</strong> is a convolutional neural network architecture from the Inception family that makes several improvements including using <a href="https://paperswithcode.com/method/label-smoothing" rel="nofollow">Label Smoothing</a>, Factorized 7 x 7 convolutions, and the use of an <a href="https://paperswithcode.com/method/auxiliary-classifier" rel="nofollow">auxiliary classifer</a> to propagate label information lower down the network (along with the use of batch normalization for layers in the sidehead). The key building block is an <a href="https://paperswithcode.com/method/inception-v3-module" rel="nofollow">Inception Module</a>.',Tl,W,ql="This particular model was trained for study of adversarial examples (adversarial training).",cl,x,Kl='The weights from this model were ported from <a href="https://github.com/tensorflow/models" rel="nofollow">Tensorflow/Models</a>.',jl,I,A,ol,E,Xl,O,Ol="How do I use this model on an image?",yl,Z,lt="To load a pretrained model:",dl,N,Il,G,tt="To load and preprocess the image:",ul,$,Ul,Q,st="To get the model predictions:",gl,Y,bl,_,at="To get the top-5 predictions class names:",Al,R,fl,S,et="Replace the model name with the variant you want to use, e.g. <code>adv_inception_v3</code>. You can find the IDs in the model summaries at the top of this page.",Cl,V,nt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vl,u,f,pl,X,Fl,ll,ot="How do I finetune this model?",kl,F,pt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Bl,H,Wl,z,it=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,xl,U,C,il,L,Hl,tl,Mt="How do I train this model?",El,P,rt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Zl,g,v,Ml,D,zl,sl,wt="Citation",Nl,q,Gl,rl,$l;return k=new wl({}),E=new wl({}),N=new al({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2Fkdl9pbmNlcHRpb25fdjMnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;adv_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),$=new al({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),Y=new al({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),R=new al({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),X=new wl({}),H=new al({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnYWR2X2luY2VwdGlvbl92MyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;adv_inception_v3&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),L=new wl({}),D=new wl({}),q=new al({props:{code:"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",highlighted:`<span class="hljs-comment">@article{DBLP:journals/corr/abs-1804-00097,</span>
  author    = {Alexey Kurakin <span class="hljs-keyword">and</span>
               Ian J. Goodfellow <span class="hljs-keyword">and</span>
               Samy Bengio <span class="hljs-keyword">and</span>
               Yinpeng Dong <span class="hljs-keyword">and</span>
               Fangzhou Liao <span class="hljs-keyword">and</span>
               Ming Liang <span class="hljs-keyword">and</span>
               Tianyu Pang <span class="hljs-keyword">and</span>
               Jun Zhu <span class="hljs-keyword">and</span>
               Xiaolin Hu <span class="hljs-keyword">and</span>
               Cihang Xie <span class="hljs-keyword">and</span>
               Jianyu Wang <span class="hljs-keyword">and</span>
               Zhishuai Zhang <span class="hljs-keyword">and</span>
               Zhou Ren <span class="hljs-keyword">and</span>
               Alan L. Yuille <span class="hljs-keyword">and</span>
               Sangxia Huang <span class="hljs-keyword">and</span>
               Yao Zhao <span class="hljs-keyword">and</span>
               Yuzhe Zhao <span class="hljs-keyword">and</span>
               Zhonglin Han <span class="hljs-keyword">and</span>
               Junjiajia Long <span class="hljs-keyword">and</span>
               Yerkebulan Berdibekov <span class="hljs-keyword">and</span>
               Takuya Akiba <span class="hljs-keyword">and</span>
               Seiya Tokui <span class="hljs-keyword">and</span>
               Motoki Abe},
  title     = {Adversarial Attacks <span class="hljs-keyword">and</span> Defences Competition},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1804</span>.<span class="hljs-number">00097</span>},
  year      = {<span class="hljs-number">2018</span>},
  url       = {http:<span class="hljs-comment">//arxiv.org/abs/1804.00097},</span>
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1804</span>.<span class="hljs-number">00097</span>},
  timestamp = {Thu, <span class="hljs-number">31</span> Oct <span class="hljs-number">2019</span> <span class="hljs-number">16</span>:<span class="hljs-number">31</span>:<span class="hljs-number">22</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-comment">//dblp.org/rec/journals/corr/abs-1804-00097.bib},</span>
  bibsource = {dblp computer science bibliography, https:<span class="hljs-comment">//dblp.org}</span>
}`}}),{c(){y=e("meta"),hl=o(),el=e("p"),Jl=o(),d=e("h1"),b=e("a"),nl=e("span"),h(k.$$.fragment),Vl=o(),K=e("span"),K.textContent=Pl,ml=o(),B=e("p"),B.innerHTML=Dl,Tl=o(),W=e("p"),W.textContent=ql,cl=o(),x=e("p"),x.innerHTML=Kl,jl=o(),I=e("h2"),A=e("a"),ol=e("span"),h(E.$$.fragment),Xl=o(),O=e("span"),O.textContent=Ol,yl=o(),Z=e("p"),Z.textContent=lt,dl=o(),h(N.$$.fragment),Il=o(),G=e("p"),G.textContent=tt,ul=o(),h($.$$.fragment),Ul=o(),Q=e("p"),Q.textContent=st,gl=o(),h(Y.$$.fragment),bl=o(),_=e("p"),_.textContent=at,Al=o(),h(R.$$.fragment),fl=o(),S=e("p"),S.innerHTML=et,Cl=o(),V=e("p"),V.innerHTML=nt,vl=o(),u=e("h2"),f=e("a"),pl=e("span"),h(X.$$.fragment),Fl=o(),ll=e("span"),ll.textContent=ot,kl=o(),F=e("p"),F.textContent=pt,Bl=o(),h(H.$$.fragment),Wl=o(),z=e("p"),z.innerHTML=it,xl=o(),U=e("h2"),C=e("a"),il=e("span"),h(L.$$.fragment),Hl=o(),tl=e("span"),tl.textContent=Mt,El=o(),P=e("p"),P.innerHTML=rt,Zl=o(),g=e("h2"),v=e("a"),Ml=e("span"),h(D.$$.fragment),zl=o(),sl=e("span"),sl.textContent=wt,Nl=o(),h(q.$$.fragment),Gl=o(),rl=e("p"),this.h()},l(l){const s=Ct("svelte-1phssyn",document.head);y=n(s,"META",{name:!0,content:!0}),s.forEach(t),hl=p(l),el=n(l,"P",{}),r(el).forEach(t),Jl=p(l),d=n(l,"H1",{class:!0});var Ql=r(d);b=n(Ql,"A",{id:!0,class:!0,href:!0});var ht=r(b);nl=n(ht,"SPAN",{});var Jt=r(nl);J(k.$$.fragment,Jt),Jt.forEach(t),ht.forEach(t),Vl=p(Ql),K=n(Ql,"SPAN",{"data-svelte-h":!0}),w(K)!=="svelte-289msd"&&(K.textContent=Pl),Ql.forEach(t),ml=p(l),B=n(l,"P",{"data-svelte-h":!0}),w(B)!=="svelte-1q7bbkg"&&(B.innerHTML=Dl),Tl=p(l),W=n(l,"P",{"data-svelte-h":!0}),w(W)!=="svelte-1fjxi1n"&&(W.textContent=ql),cl=p(l),x=n(l,"P",{"data-svelte-h":!0}),w(x)!=="svelte-1nh6o5x"&&(x.innerHTML=Kl),jl=p(l),I=n(l,"H2",{class:!0});var Yl=r(I);A=n(Yl,"A",{id:!0,class:!0,href:!0});var mt=r(A);ol=n(mt,"SPAN",{});var Tt=r(ol);J(E.$$.fragment,Tt),Tt.forEach(t),mt.forEach(t),Xl=p(Yl),O=n(Yl,"SPAN",{"data-svelte-h":!0}),w(O)!=="svelte-1c1hspn"&&(O.textContent=Ol),Yl.forEach(t),yl=p(l),Z=n(l,"P",{"data-svelte-h":!0}),w(Z)!=="svelte-18ywhxh"&&(Z.textContent=lt),dl=p(l),J(N.$$.fragment,l),Il=p(l),G=n(l,"P",{"data-svelte-h":!0}),w(G)!=="svelte-1c2ipa8"&&(G.textContent=tt),ul=p(l),J($.$$.fragment,l),Ul=p(l),Q=n(l,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-1n9qsq1"&&(Q.textContent=st),gl=p(l),J(Y.$$.fragment,l),bl=p(l),_=n(l,"P",{"data-svelte-h":!0}),w(_)!=="svelte-19cnvx1"&&(_.textContent=at),Al=p(l),J(R.$$.fragment,l),fl=p(l),S=n(l,"P",{"data-svelte-h":!0}),w(S)!=="svelte-1wl9nov"&&(S.innerHTML=et),Cl=p(l),V=n(l,"P",{"data-svelte-h":!0}),w(V)!=="svelte-1wmi3ea"&&(V.innerHTML=nt),vl=p(l),u=n(l,"H2",{class:!0});var _l=r(u);f=n(_l,"A",{id:!0,class:!0,href:!0});var ct=r(f);pl=n(ct,"SPAN",{});var jt=r(pl);J(X.$$.fragment,jt),jt.forEach(t),ct.forEach(t),Fl=p(_l),ll=n(_l,"SPAN",{"data-svelte-h":!0}),w(ll)!=="svelte-1viv4qv"&&(ll.textContent=ot),_l.forEach(t),kl=p(l),F=n(l,"P",{"data-svelte-h":!0}),w(F)!=="svelte-9sr7nh"&&(F.textContent=pt),Bl=p(l),J(H.$$.fragment,l),Wl=p(l),z=n(l,"P",{"data-svelte-h":!0}),w(z)!=="svelte-1kguc51"&&(z.innerHTML=it),xl=p(l),U=n(l,"H2",{class:!0});var Rl=r(U);C=n(Rl,"A",{id:!0,class:!0,href:!0});var yt=r(C);il=n(yt,"SPAN",{});var dt=r(il);J(L.$$.fragment,dt),dt.forEach(t),yt.forEach(t),Hl=p(Rl),tl=n(Rl,"SPAN",{"data-svelte-h":!0}),w(tl)!=="svelte-1ce591d"&&(tl.textContent=Mt),Rl.forEach(t),El=p(l),P=n(l,"P",{"data-svelte-h":!0}),w(P)!=="svelte-1n0coha"&&(P.innerHTML=rt),Zl=p(l),g=n(l,"H2",{class:!0});var Sl=r(g);v=n(Sl,"A",{id:!0,class:!0,href:!0});var It=r(v);Ml=n(It,"SPAN",{});var ut=r(Ml);J(D.$$.fragment,ut),ut.forEach(t),It.forEach(t),zl=p(Sl),sl=n(Sl,"SPAN",{"data-svelte-h":!0}),w(sl)!=="svelte-15mb3gy"&&(sl.textContent=wt),Sl.forEach(t),Nl=p(l),J(q.$$.fragment,l),Gl=p(l),rl=n(l,"P",{}),r(rl).forEach(t),this.h()},h(){i(y,"name","hf:doc:metadata"),i(y,"content",JSON.stringify(kt)),i(b,"id","adversarial-inception-v3"),i(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(b,"href","#adversarial-inception-v3"),i(d,"class","relative group"),i(A,"id","how-do-i-use-this-model-on-an-image"),i(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(A,"href","#how-do-i-use-this-model-on-an-image"),i(I,"class","relative group"),i(f,"id","how-do-i-finetune-this-model"),i(f,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(f,"href","#how-do-i-finetune-this-model"),i(u,"class","relative group"),i(C,"id","how-do-i-train-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-train-this-model"),i(U,"class","relative group"),i(v,"id","citation"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#citation"),i(g,"class","relative group")},m(l,s){M(document.head,y),a(l,hl,s),a(l,el,s),a(l,Jl,s),a(l,d,s),M(d,b),M(b,nl),m(k,nl,null),M(d,Vl),M(d,K),a(l,ml,s),a(l,B,s),a(l,Tl,s),a(l,W,s),a(l,cl,s),a(l,x,s),a(l,jl,s),a(l,I,s),M(I,A),M(A,ol),m(E,ol,null),M(I,Xl),M(I,O),a(l,yl,s),a(l,Z,s),a(l,dl,s),m(N,l,s),a(l,Il,s),a(l,G,s),a(l,ul,s),m($,l,s),a(l,Ul,s),a(l,Q,s),a(l,gl,s),m(Y,l,s),a(l,bl,s),a(l,_,s),a(l,Al,s),m(R,l,s),a(l,fl,s),a(l,S,s),a(l,Cl,s),a(l,V,s),a(l,vl,s),a(l,u,s),M(u,f),M(f,pl),m(X,pl,null),M(u,Fl),M(u,ll),a(l,kl,s),a(l,F,s),a(l,Bl,s),m(H,l,s),a(l,Wl,s),a(l,z,s),a(l,xl,s),a(l,U,s),M(U,C),M(C,il),m(L,il,null),M(U,Hl),M(U,tl),a(l,El,s),a(l,P,s),a(l,Zl,s),a(l,g,s),M(g,v),M(v,Ml),m(D,Ml,null),M(g,zl),M(g,sl),a(l,Nl,s),m(q,l,s),a(l,Gl,s),a(l,rl,s),$l=!0},p:gt,i(l){$l||(T(k.$$.fragment,l),T(E.$$.fragment,l),T(N.$$.fragment,l),T($.$$.fragment,l),T(Y.$$.fragment,l),T(R.$$.fragment,l),T(X.$$.fragment,l),T(H.$$.fragment,l),T(L.$$.fragment,l),T(D.$$.fragment,l),T(q.$$.fragment,l),$l=!0)},o(l){c(k.$$.fragment,l),c(E.$$.fragment,l),c(N.$$.fragment,l),c($.$$.fragment,l),c(Y.$$.fragment,l),c(R.$$.fragment,l),c(X.$$.fragment,l),c(H.$$.fragment,l),c(L.$$.fragment,l),c(D.$$.fragment,l),c(q.$$.fragment,l),$l=!1},d(l){l&&(t(hl),t(el),t(Jl),t(d),t(ml),t(B),t(Tl),t(W),t(cl),t(x),t(jl),t(I),t(yl),t(Z),t(dl),t(Il),t(G),t(ul),t(Ul),t(Q),t(gl),t(bl),t(_),t(Al),t(fl),t(S),t(Cl),t(V),t(vl),t(u),t(kl),t(F),t(Bl),t(Wl),t(z),t(xl),t(U),t(El),t(P),t(Zl),t(g),t(Nl),t(Gl),t(rl)),t(y),j(k),j(E),j(N,l),j($,l),j(Y,l),j(R,l),j(X),j(H,l),j(L),j(D),j(q,l)}}}const kt={local:"adversarial-inception-v3",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"Adversarial Inception v3"};function Bt(Ll){return bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends At{constructor(y){super(),ft(this,y,Bt,vt,Ut,{})}}export{Nt as component};
