import{s as je,n as fe,o as Je}from"../chunks/scheduler.85c25b89.js";import{S as be,i as Te,g as a,s as o,u as c,A as ve,h as n,f as e,c as p,j as h,v as d,y as m,k as i,o as r,a as l,w as M,d as u,t as y,x as w}from"../chunks/index.9633332f.js";import{I as ht}from"../chunks/IconCopyLink.a4acffac.js";import{C as st}from"../chunks/CodeBlock.00597c71.js";function Ue(Ft){let g,mt,lt,ct,j,v,at,N,St,q,Pt="Dual Path Network (DPN)",dt,$,zt='A <strong>Dual Path Network (DPN)</strong> is a convolutional neural network which presents a new topology of connection paths internally. The intuition is that <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNets</a> enables feature re-usage while DenseNet enables new feature exploration, and both are important for learning good representations. To enjoy the benefits from both path topologies, Dual Path Networks share common features while maintaining the flexibility to explore new features through dual path architectures.',Mt,Z,Dt='The principal building block is an <a href="https://paperswithcode.com/method/dpn-block" rel="nofollow">DPN Block</a>.',ut,f,U,nt,E,Xt,K,Lt="How do I use this model on an image?",yt,I,qt="To load a pretrained model:",wt,_,gt,B,Kt="To load and preprocess the image:",jt,W,ft,G,Ot="To get the model predictions:",Jt,A,bt,Q,te="To get the top-5 predictions class names:",Tt,R,vt,S,ee="Replace the model name with the variant you want to use, e.g. <code>dpn107</code>. You can find the IDs in the model summaries at the top of this page.",Ut,X,se='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',kt,J,k,ot,V,Vt,O,le="How do I finetune this model?",Ct,Y,ae="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",xt,H,Nt,F,ne=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,$t,b,C,pt,P,Yt,tt,oe="How do I train this model?",Zt,z,pe='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Et,T,x,it,D,Ht,et,ie="Citation",It,L,_t,rt,Bt;return N=new ht({}),E=new ht({}),_=new st({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RwbjEwNyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),W=new st({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),A=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),R=new st({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),V=new ht({}),H=new st({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZHBuMTA3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),P=new ht({}),D=new ht({}),L=new st({props:{code:"JTQwbWlzYyU3QmNoZW4yMDE3ZHVhbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRHVhbCUyMFBhdGglMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qll1bnBlbmclMjBDaGVuJTIwYW5kJTIwSmlhbmFuJTIwTGklMjBhbmQlMjBIdWF4aW4lMjBYaWFvJTIwYW5kJTIwWGlhb2ppZSUyMEppbiUyMGFuZCUyMFNodWljaGVuZyUyMFlhbiUyMGFuZCUyMEppYXNoaSUyMEZlbmclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDE2MjklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{chen2017dual,
      title={Dual Path Networks}, 
      author={Yunpeng Chen <span class="hljs-keyword">and </span><span class="hljs-keyword">Jianan </span>Li <span class="hljs-keyword">and </span>Huaxin Xiao <span class="hljs-keyword">and </span>Xiaojie <span class="hljs-keyword">Jin </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Shuicheng </span>Yan <span class="hljs-keyword">and </span><span class="hljs-keyword">Jiashi </span>Feng},
      year={<span class="hljs-number">2017</span>},
      eprint={<span class="hljs-number">1707</span>.<span class="hljs-number">01629</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){g=a("meta"),mt=o(),lt=a("p"),ct=o(),j=a("h1"),v=a("a"),at=a("span"),c(N.$$.fragment),St=o(),q=a("span"),q.textContent=Pt,dt=o(),$=a("p"),$.innerHTML=zt,Mt=o(),Z=a("p"),Z.innerHTML=Dt,ut=o(),f=a("h2"),U=a("a"),nt=a("span"),c(E.$$.fragment),Xt=o(),K=a("span"),K.textContent=Lt,yt=o(),I=a("p"),I.textContent=qt,wt=o(),c(_.$$.fragment),gt=o(),B=a("p"),B.textContent=Kt,jt=o(),c(W.$$.fragment),ft=o(),G=a("p"),G.textContent=Ot,Jt=o(),c(A.$$.fragment),bt=o(),Q=a("p"),Q.textContent=te,Tt=o(),c(R.$$.fragment),vt=o(),S=a("p"),S.innerHTML=ee,Ut=o(),X=a("p"),X.innerHTML=se,kt=o(),J=a("h2"),k=a("a"),ot=a("span"),c(V.$$.fragment),Vt=o(),O=a("span"),O.textContent=le,Ct=o(),Y=a("p"),Y.textContent=ae,xt=o(),c(H.$$.fragment),Nt=o(),F=a("p"),F.innerHTML=ne,$t=o(),b=a("h2"),C=a("a"),pt=a("span"),c(P.$$.fragment),Yt=o(),tt=a("span"),tt.textContent=oe,Zt=o(),z=a("p"),z.innerHTML=pe,Et=o(),T=a("h2"),x=a("a"),it=a("span"),c(D.$$.fragment),Ht=o(),et=a("span"),et.textContent=ie,It=o(),c(L.$$.fragment),_t=o(),rt=a("p"),this.h()},l(t){const s=ve("svelte-1phssyn",document.head);g=n(s,"META",{name:!0,content:!0}),s.forEach(e),mt=p(t),lt=n(t,"P",{}),h(lt).forEach(e),ct=p(t),j=n(t,"H1",{class:!0});var Wt=h(j);v=n(Wt,"A",{id:!0,class:!0,href:!0});var re=h(v);at=n(re,"SPAN",{});var he=h(at);d(N.$$.fragment,he),he.forEach(e),re.forEach(e),St=p(Wt),q=n(Wt,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1ry7t"&&(q.textContent=Pt),Wt.forEach(e),dt=p(t),$=n(t,"P",{"data-svelte-h":!0}),m($)!=="svelte-1vp7kec"&&($.innerHTML=zt),Mt=p(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-34uoom"&&(Z.innerHTML=Dt),ut=p(t),f=n(t,"H2",{class:!0});var Gt=h(f);U=n(Gt,"A",{id:!0,class:!0,href:!0});var me=h(U);nt=n(me,"SPAN",{});var ce=h(nt);d(E.$$.fragment,ce),ce.forEach(e),me.forEach(e),Xt=p(Gt),K=n(Gt,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1c1hspn"&&(K.textContent=Lt),Gt.forEach(e),yt=p(t),I=n(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-18ywhxh"&&(I.textContent=qt),wt=p(t),d(_.$$.fragment,t),gt=p(t),B=n(t,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1c2ipa8"&&(B.textContent=Kt),jt=p(t),d(W.$$.fragment,t),ft=p(t),G=n(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1n9qsq1"&&(G.textContent=Ot),Jt=p(t),d(A.$$.fragment,t),bt=p(t),Q=n(t,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-19cnvx1"&&(Q.textContent=te),Tt=p(t),d(R.$$.fragment,t),vt=p(t),S=n(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1lx1824"&&(S.innerHTML=ee),Ut=p(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1wmi3ea"&&(X.innerHTML=se),kt=p(t),J=n(t,"H2",{class:!0});var At=h(J);k=n(At,"A",{id:!0,class:!0,href:!0});var de=h(k);ot=n(de,"SPAN",{});var Me=h(ot);d(V.$$.fragment,Me),Me.forEach(e),de.forEach(e),Vt=p(At),O=n(At,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1viv4qv"&&(O.textContent=le),At.forEach(e),Ct=p(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ae),xt=p(t),d(H.$$.fragment,t),Nt=p(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1kguc51"&&(F.innerHTML=ne),$t=p(t),b=n(t,"H2",{class:!0});var Qt=h(b);C=n(Qt,"A",{id:!0,class:!0,href:!0});var ue=h(C);pt=n(ue,"SPAN",{});var ye=h(pt);d(P.$$.fragment,ye),ye.forEach(e),ue.forEach(e),Yt=p(Qt),tt=n(Qt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-1ce591d"&&(tt.textContent=oe),Qt.forEach(e),Zt=p(t),z=n(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1n0coha"&&(z.innerHTML=pe),Et=p(t),T=n(t,"H2",{class:!0});var Rt=h(T);x=n(Rt,"A",{id:!0,class:!0,href:!0});var we=h(x);it=n(we,"SPAN",{});var ge=h(it);d(D.$$.fragment,ge),ge.forEach(e),we.forEach(e),Ht=p(Rt),et=n(Rt,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-15mb3gy"&&(et.textContent=ie),Rt.forEach(e),It=p(t),d(L.$$.fragment,t),_t=p(t),rt=n(t,"P",{}),h(rt).forEach(e),this.h()},h(){i(g,"name","hf:doc:metadata"),i(g,"content",JSON.stringify(ke)),i(v,"id","dual-path-network-dpn"),i(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(v,"href","#dual-path-network-dpn"),i(j,"class","relative group"),i(U,"id","how-do-i-use-this-model-on-an-image"),i(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(U,"href","#how-do-i-use-this-model-on-an-image"),i(f,"class","relative group"),i(k,"id","how-do-i-finetune-this-model"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#how-do-i-finetune-this-model"),i(J,"class","relative group"),i(C,"id","how-do-i-train-this-model"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#how-do-i-train-this-model"),i(b,"class","relative group"),i(x,"id","citation"),i(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(x,"href","#citation"),i(T,"class","relative group")},m(t,s){r(document.head,g),l(t,mt,s),l(t,lt,s),l(t,ct,s),l(t,j,s),r(j,v),r(v,at),M(N,at,null),r(j,St),r(j,q),l(t,dt,s),l(t,$,s),l(t,Mt,s),l(t,Z,s),l(t,ut,s),l(t,f,s),r(f,U),r(U,nt),M(E,nt,null),r(f,Xt),r(f,K),l(t,yt,s),l(t,I,s),l(t,wt,s),M(_,t,s),l(t,gt,s),l(t,B,s),l(t,jt,s),M(W,t,s),l(t,ft,s),l(t,G,s),l(t,Jt,s),M(A,t,s),l(t,bt,s),l(t,Q,s),l(t,Tt,s),M(R,t,s),l(t,vt,s),l(t,S,s),l(t,Ut,s),l(t,X,s),l(t,kt,s),l(t,J,s),r(J,k),r(k,ot),M(V,ot,null),r(J,Vt),r(J,O),l(t,Ct,s),l(t,Y,s),l(t,xt,s),M(H,t,s),l(t,Nt,s),l(t,F,s),l(t,$t,s),l(t,b,s),r(b,C),r(C,pt),M(P,pt,null),r(b,Yt),r(b,tt),l(t,Zt,s),l(t,z,s),l(t,Et,s),l(t,T,s),r(T,x),r(x,it),M(D,it,null),r(T,Ht),r(T,et),l(t,It,s),M(L,t,s),l(t,_t,s),l(t,rt,s),Bt=!0},p:fe,i(t){Bt||(u(N.$$.fragment,t),u(E.$$.fragment,t),u(_.$$.fragment,t),u(W.$$.fragment,t),u(A.$$.fragment,t),u(R.$$.fragment,t),u(V.$$.fragment,t),u(H.$$.fragment,t),u(P.$$.fragment,t),u(D.$$.fragment,t),u(L.$$.fragment,t),Bt=!0)},o(t){y(N.$$.fragment,t),y(E.$$.fragment,t),y(_.$$.fragment,t),y(W.$$.fragment,t),y(A.$$.fragment,t),y(R.$$.fragment,t),y(V.$$.fragment,t),y(H.$$.fragment,t),y(P.$$.fragment,t),y(D.$$.fragment,t),y(L.$$.fragment,t),Bt=!1},d(t){t&&(e(mt),e(lt),e(ct),e(j),e(dt),e($),e(Mt),e(Z),e(ut),e(f),e(yt),e(I),e(wt),e(gt),e(B),e(jt),e(ft),e(G),e(Jt),e(bt),e(Q),e(Tt),e(vt),e(S),e(Ut),e(X),e(kt),e(J),e(Ct),e(Y),e(xt),e(Nt),e(F),e($t),e(b),e(Zt),e(z),e(Et),e(T),e(It),e(_t),e(rt)),e(g),w(N),w(E),w(_,t),w(W,t),w(A,t),w(R,t),w(V),w(H,t),w(P),w(D),w(L,t)}}}const ke={local:"dual-path-network-dpn",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"Dual Path Network (DPN)"};function Ce(Ft){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ee extends be{constructor(g){super(),Te(this,g,Ce,Ue,je,{})}}export{Ee as component};
