import{s as Ka,o as Oa,n as V}from"../chunks/scheduler.182ea377.js";import{S as el,i as tl,g as m,s as n,r as M,A as al,h as d,f as t,c as p,j as ra,u as y,x as c,k as R,y as ll,a as l,v as h,d as Z,t as J,w as U}from"../chunks/index.abf12888.js";import{T as qe}from"../chunks/Tip.230e2334.js";import{C as $}from"../chunks/CodeBlock.57fe6e13.js";import{H as x}from"../chunks/Heading.16916d63.js";import{H as sl,a as oa}from"../chunks/HfOption.fc88c804.js";function il(X){let i,b='Learn how to load an IP-Adapter in the <a href="../using-diffusers/loading_adapters#ip-adapter">Load adapters</a> guide, and make sure you check out the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section which requires manually loading the image encoder.';return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1lc7m22"&&(i.innerHTML=b)},m(o,f){l(o,i,f)},p:V,d(o){o&&t(i)}}}function nl(X){let i,b='In the examples below, try adding <code>low_cpu_mem_usage=True</code> to the <a href="/docs/diffusers/v0.27.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method to speed up the loading time.';return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1wsuqu4"&&(i.innerHTML=b)},m(o,f){l(o,i,f)},p:V,d(o){o&&t(i)}}}function pl(X){let i,b="Crafting the precise text prompt to generate the image you want can be difficult because it may not always capture what you’d like to express. Adding an image alongside the text prompt helps the model better understand what it should generate and can lead to more accurate results.",o,f,T='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/v0.27.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',G,g,v,r,j="Create a text prompt and load an image prompt before passing them to the pipeline to generate an image.",I,W,k,_,C='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return g=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),W=new $({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZGluZXIucG5nJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMHBvbGFyJTIwYmVhciUyMHNpdHRpbmclMjBpbiUyMGElMjBjaGFpciUyMGRyaW5raW5nJTIwYSUyMG1pbGtzaGFrZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=m("p"),i.textContent=b,o=n(),f=m("p"),f.innerHTML=T,G=n(),M(g.$$.fragment),v=n(),r=m("p"),r.textContent=j,I=n(),M(W.$$.fragment),k=n(),_=m("div"),_.innerHTML=C,this.h()},l(s){i=d(s,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1kuilfu"&&(i.textContent=b),o=p(s),f=d(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-ff2mvs"&&(f.innerHTML=T),G=p(s),y(g.$$.fragment,s),v=p(s),r=d(s,"P",{"data-svelte-h":!0}),c(r)!=="svelte-yvbljp"&&(r.textContent=j),I=p(s),y(W.$$.fragment,s),k=p(s),_=d(s,"DIV",{class:!0,"data-svelte-h":!0}),c(_)!=="svelte-4jgjc0"&&(_.innerHTML=C),this.h()},h(){R(_,"class","flex flex-row gap-4")},m(s,w){l(s,i,w),l(s,o,w),l(s,f,w),l(s,G,w),h(g,s,w),l(s,v,w),l(s,r,w),l(s,I,w),h(W,s,w),l(s,k,w),l(s,_,w),u=!0},p:V,i(s){u||(Z(g.$$.fragment,s),Z(W.$$.fragment,s),u=!0)},o(s){J(g.$$.fragment,s),J(W.$$.fragment,s),u=!1},d(s){s&&(t(i),t(o),t(f),t(G),t(v),t(r),t(I),t(k),t(_)),U(g,s),U(W,s)}}}function ol(X){let i,b="IP-Adapter can also help with image-to-image by guiding the model to generate an image that resembles the original image and the image prompt.",o,f,T='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/v0.27.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',G,g,v,r,j="Pass the original image and the IP-Adapter image prompt to the pipeline to generate an image. Providing a text prompt to the pipeline is optional, but in this example, a text prompt is used to increase image quality.",I,W,k,_,C='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_3.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return g=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForImage2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),W=new $({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfYmVhcl8xLnBuZyUyMiklMEFpcF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzIucG5nJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDQpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNiUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_2.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=image,
    ip_adapter_image=ip_image,
    generator=generator,
    strength=<span class="hljs-number">0.6</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=m("p"),i.textContent=b,o=n(),f=m("p"),f.innerHTML=T,G=n(),M(g.$$.fragment),v=n(),r=m("p"),r.textContent=j,I=n(),M(W.$$.fragment),k=n(),_=m("div"),_.innerHTML=C,this.h()},l(s){i=d(s,"P",{"data-svelte-h":!0}),c(i)!=="svelte-avn1rr"&&(i.textContent=b),o=p(s),f=d(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-ff2mvs"&&(f.innerHTML=T),G=p(s),y(g.$$.fragment,s),v=p(s),r=d(s,"P",{"data-svelte-h":!0}),c(r)!=="svelte-10sbd9g"&&(r.textContent=j),I=p(s),y(W.$$.fragment,s),k=p(s),_=d(s,"DIV",{class:!0,"data-svelte-h":!0}),c(_)!=="svelte-8bse9r"&&(_.innerHTML=C),this.h()},h(){R(_,"class","flex gap-4")},m(s,w){l(s,i,w),l(s,o,w),l(s,f,w),l(s,G,w),h(g,s,w),l(s,v,w),l(s,r,w),l(s,I,w),h(W,s,w),l(s,k,w),l(s,_,w),u=!0},p:V,i(s){u||(Z(g.$$.fragment,s),Z(W.$$.fragment,s),u=!0)},o(s){J(g.$$.fragment,s),J(W.$$.fragment,s),u=!1},d(s){s&&(t(i),t(o),t(f),t(G),t(v),t(r),t(I),t(k),t(_)),U(g,s),U(W,s)}}}function rl(X){let i,b="IP-Adapter is also useful for inpainting because the image prompt allows you to be much more specific about what you’d like to generate.",o,f,T='Load a Stable Diffusion XL (SDXL) model and insert an IP-Adapter into the model with the <a href="/docs/diffusers/v0.27.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method. Use the <code>subfolder</code> parameter to load the SDXL model weights.',G,g,v,r,j="Pass a prompt, the original image, mask image, and the IP-Adapter image prompt to the pipeline to generate an image.",I,W,k,_,C='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',u;return g=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbnBhaW50aW5nLmZyb21fcHJldHJhaW5lZCglMjJkaWZmdXNlcnMlMkZzdGFibGUtZGlmZnVzaW9uLXhsLTEuMC1pbnBhaW50aW5nLTAuMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForInpainting.from_pretrained(<span class="hljs-string">&quot;diffusers/stable-diffusion-xl-1.0-inpainting-0.1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)`,wrap:!1}}),W=new $({props:{code:"bWFza19pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9tYXNrLnBuZyUyMiklMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzEucG5nJTIyKSUwQWlwX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX2d1bW15LnBuZyUyMiklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCg0KSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjdXRlJTIwZ3VtbXklMjBiZWFyJTIwd2F2aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_mask.png&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">4</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a cute gummy bear waving&quot;</span>,
    image=image,
    mask_image=mask_image,
    ip_adapter_image=ip_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">100</span>,
).images
images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=m("p"),i.textContent=b,o=n(),f=m("p"),f.innerHTML=T,G=n(),M(g.$$.fragment),v=n(),r=m("p"),r.textContent=j,I=n(),M(W.$$.fragment),k=n(),_=m("div"),_.innerHTML=C,this.h()},l(s){i=d(s,"P",{"data-svelte-h":!0}),c(i)!=="svelte-11wjoqr"&&(i.textContent=b),o=p(s),f=d(s,"P",{"data-svelte-h":!0}),c(f)!=="svelte-ff2mvs"&&(f.innerHTML=T),G=p(s),y(g.$$.fragment,s),v=p(s),r=d(s,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1wfeic0"&&(r.textContent=j),I=p(s),y(W.$$.fragment,s),k=p(s),_=d(s,"DIV",{class:!0,"data-svelte-h":!0}),c(_)!=="svelte-5iola2"&&(_.innerHTML=C),this.h()},h(){R(_,"class","flex gap-4")},m(s,w){l(s,i,w),l(s,o,w),l(s,f,w),l(s,G,w),h(g,s,w),l(s,v,w),l(s,r,w),l(s,I,w),h(W,s,w),l(s,k,w),l(s,_,w),u=!0},p:V,i(s){u||(Z(g.$$.fragment,s),Z(W.$$.fragment,s),u=!0)},o(s){J(g.$$.fragment,s),J(W.$$.fragment,s),u=!1},d(s){s&&(t(i),t(o),t(f),t(G),t(v),t(r),t(I),t(k),t(_)),U(g,s),U(W,s)}}}function ml(X){let i,b='If you’re planning on offloading the model to the CPU, make sure you run it after you’ve loaded the IP-Adapter. When you call <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> before loading the IP-Adapter, it offloads the image encoder module to the CPU and it’ll return an error when you try to run the pipeline.';return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-qu4mzl"&&(i.innerHTML=b)},m(o,f){l(o,i,f)},p:V,d(o){o&&t(i)}}}function dl(X){let i,b='IP-Adapter can also help you generate videos that are more aligned with your text prompt. For example, let’s load <a href="../api/pipelines/animatediff">AnimateDiff</a> with its motion adapter and insert an IP-Adapter into the model with the <a href="/docs/diffusers/v0.27.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> method.',o,f,T,G,g,v,r="Pass a prompt and an image prompt to the pipeline to generate a short video.",j,I,W,k,_='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gummy_bear.gif"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated video</figcaption></div>',C;return f=new qe({props:{warning:!0,$$slots:{default:[ml]},$$scope:{ctx:X}}}),G=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQW5pbWF0ZURpZmZQaXBlbGluZSUyQyUyMERESU1TY2hlZHVsZXIlMkMlMjBNb3Rpb25BZGFwdGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZWxpbmUlMjAlM0QlMjBBbmltYXRlRGlmZlBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJlbWlsaWFuSlIlMkZlcGlDUmVhbGlzbSUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIybGluc3BhY2UlMjIlMkMlMEElMjAlMjAlMjAlMjBiZXRhX3NjaGVkdWxlJTNEJTIybGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RlcHNfb2Zmc2V0JTNEMSUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBzY2hlZHVsZXIlMEFwaXBlbGluZS5lbmFibGVfdmFlX3NsaWNpbmcoKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)
pipeline = AnimateDiffPipeline.from_pretrained(<span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>, motion_adapter=adapter, torch_dtype=torch.float16)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler
pipeline.enable_vae_slicing()

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),I=new $({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9pbnBhaW50LnBuZyUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJBJTIwY3V0ZSUyMGd1bW15JTIwYmVhciUyMHdhdmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmJhZCUyMHF1YWxpdHklMkMlMjB3b3JzZSUyMHF1YWxpdHklMkMlMjBsb3clMjByZXNvbHV0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTJDJTBBKSUwQWZyYW1lcyUyMCUzRCUyMG91dHB1dC5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihmcmFtZXMlMkMlMjAlMjJndW1teV9iZWFyLmdpZiUyMik=",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png&quot;</span>)

output = pipeline(
    prompt=<span class="hljs-string">&quot;A cute gummy bear waving&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    ip_adapter_image=ip_adapter_image,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
)
frames = output.frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;gummy_bear.gif&quot;</span>)`,wrap:!1}}),{c(){i=m("p"),i.innerHTML=b,o=n(),M(f.$$.fragment),T=n(),M(G.$$.fragment),g=n(),v=m("p"),v.textContent=r,j=n(),M(I.$$.fragment),W=n(),k=m("div"),k.innerHTML=_,this.h()},l(u){i=d(u,"P",{"data-svelte-h":!0}),c(i)!=="svelte-j7biga"&&(i.innerHTML=b),o=p(u),y(f.$$.fragment,u),T=p(u),y(G.$$.fragment,u),g=p(u),v=d(u,"P",{"data-svelte-h":!0}),c(v)!=="svelte-a6opnh"&&(v.textContent=r),j=p(u),y(I.$$.fragment,u),W=p(u),k=d(u,"DIV",{class:!0,"data-svelte-h":!0}),c(k)!=="svelte-ihoum9"&&(k.innerHTML=_),this.h()},h(){R(k,"class","flex flex-row gap-4")},m(u,s){l(u,i,s),l(u,o,s),h(f,u,s),l(u,T,s),h(G,u,s),l(u,g,s),l(u,v,s),l(u,j,s),h(I,u,s),l(u,W,s),l(u,k,s),C=!0},p(u,s){const w={};s&2&&(w.$$scope={dirty:s,ctx:u}),f.$set(w)},i(u){C||(Z(f.$$.fragment,u),Z(G.$$.fragment,u),Z(I.$$.fragment,u),C=!0)},o(u){J(f.$$.fragment,u),J(G.$$.fragment,u),J(I.$$.fragment,u),C=!1},d(u){u&&(t(i),t(o),t(T),t(g),t(v),t(j),t(W),t(k)),U(f,u),U(G,u),U(I,u)}}}function cl(X){let i,b,o,f,T,G,g,v;return i=new oa({props:{id:"tasks",option:"Text-to-image",$$slots:{default:[pl]},$$scope:{ctx:X}}}),o=new oa({props:{id:"tasks",option:"Image-to-image",$$slots:{default:[ol]},$$scope:{ctx:X}}}),T=new oa({props:{id:"tasks",option:"Inpainting",$$slots:{default:[rl]},$$scope:{ctx:X}}}),g=new oa({props:{id:"tasks",option:"Video",$$slots:{default:[dl]},$$scope:{ctx:X}}}),{c(){M(i.$$.fragment),b=n(),M(o.$$.fragment),f=n(),M(T.$$.fragment),G=n(),M(g.$$.fragment)},l(r){y(i.$$.fragment,r),b=p(r),y(o.$$.fragment,r),f=p(r),y(T.$$.fragment,r),G=p(r),y(g.$$.fragment,r)},m(r,j){h(i,r,j),l(r,b,j),h(o,r,j),l(r,f,j),h(T,r,j),l(r,G,j),h(g,r,j),v=!0},p(r,j){const I={};j&2&&(I.$$scope={dirty:j,ctx:r}),i.$set(I);const W={};j&2&&(W.$$scope={dirty:j,ctx:r}),o.$set(W);const k={};j&2&&(k.$$scope={dirty:j,ctx:r}),T.$set(k);const _={};j&2&&(_.$$scope={dirty:j,ctx:r}),g.$set(_)},i(r){v||(Z(i.$$.fragment,r),Z(o.$$.fragment,r),Z(T.$$.fragment,r),Z(g.$$.fragment,r),v=!0)},o(r){J(i.$$.fragment,r),J(o.$$.fragment,r),J(T.$$.fragment,r),J(g.$$.fragment,r),v=!1},d(r){r&&(t(b),t(f),t(G)),U(i,r),U(o,r),U(T,r),U(g,r)}}}function ul(X){let i,b="This parameter also gives you the flexibility to load embeddings from other sources. For example, ComfyUI image embeddings for IP-Adapters are compatible with Diffusers and should work ouf-of-the-box!";return{c(){i=m("p"),i.textContent=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-1rk1t7q"&&(i.textContent=b)},m(o,f){l(o,i,f)},p:V,d(o){o&&t(i)}}}function fl(X){let i,b="If you’re using IP-Adapter with <code>ip_adapter_image_embedding</code> instead of <code>ip_adapter_image</code>’, you can set <code>load_ip_adapter(image_encoder_folder=None,...)</code> because you don’t need to load an encoder to generate the image embeddings.";return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-h0lw9v"&&(i.innerHTML=b)},m(o,f){l(o,i,f)},p:V,d(o){o&&t(i)}}}function gl(X){let i,b,o,f='<a href="https://huggingface.co/h94/IP-Adapter-FaceID" rel="nofollow">IP-Adapter-FaceID</a> is a face-specific IP-Adapter trained with face ID embeddings instead of CLIP image embeddings, allowing you to generate more consistent faces in different contexts and styles. Try out this popular <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#ip-adapter-face-id" rel="nofollow">community pipeline</a> and see how it compares to the other face IP-Adapters.';return{c(){i=m("p"),b=n(),o=m("p"),o.innerHTML=f},l(T){i=d(T,"P",{}),ra(i).forEach(t),b=p(T),o=d(T,"P",{"data-svelte-h":!0}),c(o)!=="svelte-wlm69t"&&(o.innerHTML=f)},m(T,G){l(T,i,G),l(T,b,G),l(T,o,G)},p:V,d(T){T&&(t(i),t(b),t(o))}}}function Ml(X){let i,b='Read the <a href="../using-diffusers/loading_adapters#ip-adapter-plus">IP-Adapter Plus</a> section to learn why you need to manually load the image encoder.';return{c(){i=m("p"),i.innerHTML=b},l(o){i=d(o,"P",{"data-svelte-h":!0}),c(i)!=="svelte-apa7ha"&&(i.innerHTML=b)},m(o,f){l(o,i,f)},p:V,d(o){o&&t(i)}}}function yl(X){let i,b,o,f,T,G,g,v='<a href="https://hf.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is an image prompt adapter that can be plugged into diffusion models to enable image prompting without any changes to the underlying model. Furthermore, this adapter can be reused with other models finetuned from the same base model and it can be combined with other adapters like <a href="../using-diffusers/controlnet">ControlNet</a>. The key idea behind IP-Adapter is the <em>decoupled cross-attention</em> mechanism which adds a separate cross-attention layer just for image features instead of using the same cross-attention layer for both text and image features. This allows the model to learn more image-specific features.',r,j,I,W,k="This guide will walk you through using IP-Adapter for various tasks and use cases.",_,C,u,s,w='Let’s take a look at how to use IP-Adapter’s image prompting capabilities with the <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a> for tasks like text-to-image, image-to-image, and inpainting. We also encourage you to try out other pipelines such as Stable Diffusion, LCM-LoRA, ControlNet, T2I-Adapter, or AnimateDiff!',Pe,O,ma='In all the following examples, you’ll see the <a href="/docs/diffusers/v0.27.0/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method. This method controls the amount of text or image conditioning to apply to the model. A value of <code>1.0</code> means the model is only conditioned on the image prompt. Lowering this value encourages the model to produce more diverse images, but they may not be as aligned with the image prompt. Typically, a value of <code>0.5</code> achieves a good balance between the two prompt types and produces good results.',De,Y,Ke,B,Oe,ee,et,te,da="There are a couple of IP-Adapter parameters that are useful to know about and can help you with your image generation tasks. These parameters can make your workflow more efficient or give you more control over image generation.",tt,ae,at,le,ca='IP-Adapter enabled pipelines provide the <code>ip_adapter_image_embeds</code> parameter to accept precomputed image embeddings. This is particularly useful in scenarios where you need to run the IP-Adapter pipeline multiple times because you have more than one image. For example, <a href="#multi-ip-adapter">multi IP-Adapter</a> is a specific use case where you provide multiple styling images to generate a specific image in a specific style. Loading and encoding multiple images each time you use the pipeline would be inefficient. Instead, you can precompute and save the image embeddings to disk (which can save a lot of space if you’re using high-quality images) and load them when you need them.',lt,F,st,se,ua="Call the <code>prepare_ip_adapter_image_embeds()</code> method to encode and generate the image embeddings. Then you can save them to disk with <code>torch.save</code>.",it,H,nt,ie,pt,ne,fa="Now load the image embeddings by passing them to the <code>ip_adapter_image_embeds</code> parameter.",ot,pe,rt,oe,mt,re,ga="Binary masks specify which portion of the output image should be assigned to an IP-Adapter. This is useful for composing more than one IP-Adapter image. For each input IP-Adapter image, you must provide a binary mask an an IP-Adapter.",dt,me,Ma="To start, preprocess the input IP-Adapter images with the <code>~image_processor.IPAdapterMaskProcessor.preprocess()</code> to generate their masks. For optimal results, provide the output height and width to <code>~image_processor.IPAdapterMaskProcessor.preprocess()</code>. This ensures masks with different aspect ratios are appropriately stretched. If the input masks already match the aspect ratio of the generated image, you don’t have to set the <code>height</code> and <code>width</code>.",ct,de,ut,N,ya='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask two</figcaption></div>',ft,ce,ha="When there is more than one input IP-Adapter image, load them as a list to ensure each image is assigned to a different IP-Adapter. Each of the input IP-Adapter images here correspond to the masks generated above.",gt,ue,Mt,Q,Za='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl1.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image one</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image two</figcaption></div>',yt,fe,Ja="Now pass the preprocessed masks to <code>cross_attention_kwargs</code> in the pipeline call.",ht,ge,Zt,A,Ua='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter masking applied</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_no_attention_mask_result_seed_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">no IP-Adapter masking applied</figcaption></div>',Jt,Me,Ut,ye,ba="IP-Adapter’s image prompting and compatibility with other adapters and models makes it a versatile tool for a variety of use cases. This section covers some of the more popular applications of IP-Adapter, and we can’t wait to see what you come up with!",bt,he,wt,Ze,wa="Generating accurate faces is challenging because they are complex and nuanced. Diffusers supports two IP-Adapter checkpoints specifically trained to generate faces:",Tt,Je,Ta='<li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-full-face_sd15.safetensors" rel="nofollow">ip-adapter-full-face_sd15.safetensors</a> is conditioned with images of cropped faces and removed backgrounds</li> <li><a href="https://huggingface.co/h94/IP-Adapter/blob/main/models/ip-adapter-plus-face_sd15.safetensors" rel="nofollow">ip-adapter-plus-face_sd15.safetensors</a> uses patch embeddings and is conditioned with images of cropped faces</li>',jt,S,Wt,Ue,ja='For face models, use the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> checkpoint. It is also recommended to use <a href="/docs/diffusers/v0.27.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> or <a href="/docs/diffusers/v0.27.0/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> for face models.',_t,be,Gt,z,Wa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',vt,we,It,Te,_a="More than one IP-Adapter can be used at the same time to generate specific images in more diverse styles. For example, you can use IP-Adapter-Face to generate consistent faces and characters, and IP-Adapter Plus to generate those faces in a specific style.",kt,E,Xt,je,Ga='Load the image encoder with <a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>.',$t,We,Ct,_e,va="Next, you’ll load a base model, scheduler, and the IP-Adapters. The IP-Adapters to use are passed as a list to the <code>weight_name</code> parameter:",Rt,Ge,Ia='<li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus_sdxl_vit-h</a> uses patch embeddings and a ViT-H image encoder</li> <li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus-face_sdxl_vit-h</a> has the same architecture but it is conditioned with images of cropped faces</li>',xt,ve,Vt,Ie,ka="Load an image prompt and a folder containing images of a certain style you want to use.",Yt,ke,Bt,q,Xa='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image of face</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_style_grid.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter style images</figcaption></div>',Ft,Xe,$a="Pass the image prompt and style images as a list to the <code>ip_adapter_image</code> parameter, and run the pipeline!",Ht,$e,Nt,L,Ca='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_multi_out.png"/>',Qt,Ce,At,Re,Ra='<a href="../using-diffusers/inference_with_lcm_lora">Latent Consistency Models (LCM)</a> are diffusion models that can generate images in as little as 4 steps compared to other diffusion models like SDXL that typically require way more steps. This is why image generation with an LCM feels “instantaneous”. IP-Adapters can be plugged into an LCM-LoRA model to instantly generate images with an image prompt.',St,xe,xa='The IP-Adapter weights need to be loaded first, then you can use <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> to load the LoRA style and weight you want to apply to your image.',zt,Ve,Et,Ye,Va='Try using with a lower IP-Adapter scale to condition image generation more on the <a href="https://huggingface.co/sd-dreambooth-library/herge-style" rel="nofollow">herge_style</a> checkpoint, and remember to use the special token <code>herge_style</code> in your prompt to trigger and apply the style.',qt,Be,Lt,P,Ya='    <img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_herge.png"/>',Pt,Fe,Dt,He,Ba='To control image generation to an even greater degree, you can combine IP-Adapter with a model like <a href="../using-diffusers/controlnet">ControlNet</a>. A ControlNet is also an adapter that can be inserted into a diffusion model to allow for conditioning on an additional control image. The control image can be depth maps, edge maps, pose estimations, and more.',Kt,Ne,Fa='Load a <a href="/docs/diffusers/v0.27.0/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> checkpoint conditioned on depth maps, insert it into a diffusion model, and load the IP-Adapter.',Ot,Qe,ea,Ae,Ha="Now load the IP-Adapter image and depth map.",ta,Se,aa,D,Na='<div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">IP-Adapter image</figcaption></div> <div class="flex-1"><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">depth map</figcaption></div>',la,ze,Qa="Pass the depth map and IP-Adapter image to the pipeline to generate an image.",sa,Ee,ia,K,Aa='    <img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ipa-controlnet-out.png"/>',na,Le,pa;return T=new x({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h1"}}),j=new qe({props:{warning:!1,$$slots:{default:[il]},$$scope:{ctx:X}}}),C=new x({props:{title:"General tasks",local:"general-tasks",headingTag:"h2"}}),Y=new qe({props:{warning:!1,$$slots:{default:[nl]},$$scope:{ctx:X}}}),B=new sl({props:{id:"tasks",options:["Text-to-image","Image-to-image","Inpainting","Video"],$$slots:{default:[cl]},$$scope:{ctx:X}}}),ee=new x({props:{title:"Configure parameters",local:"configure-parameters",headingTag:"h2"}}),ae=new x({props:{title:"Image embeddings",local:"image-embeddings",headingTag:"h3"}}),F=new qe({props:{warning:!1,$$slots:{default:[ul]},$$scope:{ctx:X}}}),H=new qe({props:{warning:!1,$$slots:{default:[fl]},$$scope:{ctx:X}}}),ie=new $({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwcGlwZWxpbmUucHJlcGFyZV9pcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyglMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGRvX2NsYXNzaWZpZXJfZnJlZV9ndWlkYW5jZSUzRFRydWUlMkMlMEEpJTBBJTBBdG9yY2guc2F2ZShpbWFnZV9lbWJlZHMlMkMlMjAlMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKQ==",highlighted:`image_embeds = pipeline.prepare_ip_adapter_image_embeds(
    ip_adapter_image=image,
    ip_adapter_image_embeds=<span class="hljs-literal">None</span>,
    device=<span class="hljs-string">&quot;cuda&quot;</span>,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
)

torch.save(image_embeds, <span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)`,wrap:!1}}),pe=new $({props:{code:"aW1hZ2VfZW1iZWRzJTIwJTNEJTIwdG9yY2gubG9hZCglMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwb2xhciUyMGJlYXIlMjBzaXR0aW5nJTIwaW4lMjBhJTIwY2hhaXIlMjBkcmlua2luZyUyMGElMjBtaWxrc2hha2UlMjIlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRGltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2Vz",highlighted:`image_embeds = torch.load(<span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)
images = pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image_embeds=image_embeds,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images`,wrap:!1}}),oe=new x({props:{title:"IP-Adapter masking",local:"ip-adapter-masking",headingTag:"h3"}}),de=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5pbWFnZV9wcm9jZXNzb3IlMjBpbXBvcnQlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yJTBBJTBBbWFzazElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX21hc2tfbWFzazEucG5nJTIyKSUwQW1hc2syJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9tYXNrX21hc2syLnBuZyUyMiklMEElMEFvdXRwdXRfaGVpZ2h0JTIwJTNEJTIwMTAyNCUwQW91dHB1dF93aWR0aCUyMCUzRCUyMDEwMjQlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBJUEFkYXB0ZXJNYXNrUHJvY2Vzc29yKCklMEFtYXNrcyUyMCUzRCUyMHByb2Nlc3Nvci5wcmVwcm9jZXNzKCU1Qm1hc2sxJTJDJTIwbWFzazIlNUQlMkMlMjBoZWlnaHQlM0RvdXRwdXRfaGVpZ2h0JTJDJTIwd2lkdGglM0RvdXRwdXRfd2lkdGgp",highlighted:`<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> IPAdapterMaskProcessor

mask1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask1.png&quot;</span>)
mask2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask2.png&quot;</span>)

output_height = <span class="hljs-number">1024</span>
output_width = <span class="hljs-number">1024</span>

processor = IPAdapterMaskProcessor()
masks = processor.preprocess([mask1, mask2], height=output_height, width=output_width)`,wrap:!1}}),ue=new $({props:{code:"ZmFjZV9pbWFnZTElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX21hc2tfZ2lybDEucG5nJTIyKSUwQWZhY2VfaW1hZ2UyJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9tYXNrX2dpcmwyLnBuZyUyMiklMEElMEFpcF9pbWFnZXMlMjAlM0QlMjAlNUIlNUJmYWNlX2ltYWdlMSU1RCUyQyUyMCU1QmZhY2VfaW1hZ2UyJTVEJTVE",highlighted:`face_image1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl1.png&quot;</span>)
face_image2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl2.png&quot;</span>)

ip_images = [[face_image1], [face_image2]]`,wrap:!1}}),ge=new $({props:{code:"cGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzLWZhY2Vfc2R4bF92aXQtaC5zYWZldGVuc29ycyUyMiU1RCUyMColMjAyKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyU1RCUyMColMjAyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBbnVtX2ltYWdlcyUyMCUzRCUyMDElMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMjIlMjBnaXJscyUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9pbWFnZXMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY3Jvc3NfYXR0ZW50aW9uX2t3YXJncyUzRCU3QiUyMmlwX2FkYXB0ZXJfbWFza3MlMjIlM0ElMjBtYXNrcyU3RCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>, weight_name=[<span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>] * <span class="hljs-number">2</span>)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>] * <span class="hljs-number">2</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
num_images = <span class="hljs-number">1</span>

image = pipeline(
    prompt=<span class="hljs-string">&quot;2 girls&quot;</span>,
    ip_adapter_image=ip_images,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    num_images_per_prompt=num_images,
    generator=generator,
    cross_attention_kwargs={<span class="hljs-string">&quot;ip_adapter_masks&quot;</span>: masks}
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Me=new x({props:{title:"Specific use cases",local:"specific-use-cases",headingTag:"h2"}}),he=new x({props:{title:"Face model",local:"face-model",headingTag:"h3"}}),S=new qe({props:{warning:!1,$$slots:{default:[gl]},$$scope:{ctx:X}}}),be=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXItZnVsbC1mYWNlX3NkMTUuYmluJTIyKSUwQSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9laW5zdGVpbl9iYXNlLnBuZyUyMiklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgyNiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMkElMjBwaG90byUyMG9mJTIwRWluc3RlaW4lMjBhcyUyMGElMjBjaGVmJTJDJTIwd2VhcmluZyUyMGFuJTIwYXByb24lMkMlMjBjb29raW5nJTIwaW4lMjBhJTIwRnJlbmNoJTIwcmVzdGF1cmFudCUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmxvd3JlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter-full-face_sd15.bin&quot;</span>)

pipeline.set_ip_adapter_scale(<span class="hljs-number">0.5</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png&quot;</span>)
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">26</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;A photo of Einstein as a chef, wearing an apron, cooking in a French restaurant&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),we=new x({props:{title:"Multi IP-Adapter",local:"multi-ip-adapter",headingTag:"h3"}}),E=new qe({props:{warning:!1,$$slots:{default:[Ml]},$$scope:{ctx:X}}}),We=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMERESU1TY2hlZHVsZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMm1vZGVscyUyRmltYWdlX2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, DDIMScheduler
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),ve=new $({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyJTNEaW1hZ2VfZW5jb2RlciUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzX3NkeGxfdml0LWguc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJpcC1hZGFwdGVyLXBsdXMtZmFjZV9zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTVEJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyUyQyUyMDAuMyU1RCklMEFwaXBlbGluZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    image_encoder=image_encoder,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=[<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.safetensors&quot;</span>, <span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>]
)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>])
pipeline.enable_model_cpu_offload()`,wrap:!1}}),ke=new $({props:{code:"ZmFjZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRndvbWVuX2lucHV0LnBuZyUyMiklMEFzdHlsZV9mb2xkZXIlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3R5bGVfemlnZ3klMjIlMEFzdHlsZV9pbWFnZXMlMjAlM0QlMjAlNUJsb2FkX2ltYWdlKGYlMjIlN0JzdHlsZV9mb2xkZXIlN0QlMkZpbWclN0JpJTdELnBuZyUyMiklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQ=",highlighted:`face_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png&quot;</span>)
style_folder = <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy&quot;</span>
style_images = [load_image(<span class="hljs-string">f&quot;<span class="hljs-subst">{style_folder}</span>/img<span class="hljs-subst">{i}</span>.png&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]`,wrap:!1}}),$e=new $({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMndvbmRlcndvbWFuJTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRCU1QnN0eWxlX2ltYWdlcyUyQyUyMGZhY2VfaW1hZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = pipeline(
    prompt=<span class="hljs-string">&quot;wonderwoman&quot;</span>,
    ip_adapter_image=[style_images, face_image],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>, num_images_per_prompt=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Ce=new x({props:{title:"Instant generation",local:"instant-generation",headingTag:"h3"}}),Ve=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwTENNU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyc2QtZHJlYW1ib290aC1saWJyYXJ5JTJGaGVyZ2Utc3R5bGUlMjIlMEFsY21fbG9yYV9pZCUyMCUzRCUyMCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKGxjbV9sb3JhX2lkKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;sd-dreambooth-library/herge-style&quot;</span>
lcm_lora_id = <span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16)

pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.load_lora_weights(lcm_lora_id)
pipeline.scheduler = LCMScheduler.from_config(pipeline.scheduler.config)
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Be=new $({props:{code:"cGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMC40KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmhlcmdlX3N0eWxlJTIwd29tYW4lMjBpbiUyMGFybW9yJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBaXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZ1c2VyLWltYWdlcy5naXRodWJ1c2VyY29udGVudC5jb20lMkYyNDczNDE0MiUyRjI2NjQ5Mjg3NS0yZDUwZDIyMy04NDc1LTQ0ZjAtYTdjNi0wOGI1MWNiNTM1NzIucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline.set_ip_adapter_scale(<span class="hljs-number">0.4</span>)

prompt = <span class="hljs-string">&quot;herge_style woman in armor, best quality, high quality&quot;</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/24734142/266492875-2d50d223-8475-44f0-a7c6-08b51cb53572.png&quot;</span>)
image = pipeline(
    prompt=prompt,
    ip_adapter_image=ip_adapter_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Fe=new x({props:{title:"Structural control",local:"structural-control",headingTag:"h3"}}),Qe=new $({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFjb250cm9sbmV0X21vZGVsX3BhdGglMjAlM0QlMjAlMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNvbnRyb2xuZXRfbW9kZWxfcGF0aCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

controlnet_model_path = <span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>
controlnet = ControlNetModel.from_pretrained(controlnet_model_path, torch_dtype=torch.float16)

pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)`,wrap:!1}}),Se=new $({props:{code:"aXBfYWRhcHRlcl9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0YXR1ZS5wbmclMjIpJTBBZGVwdGhfbWFwJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGVwdGgucG5nJTIyKQ==",highlighted:`ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png&quot;</span>)
depth_map = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png&quot;</span>)`,wrap:!1}}),Ee=new $({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMzMpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RkZXB0aF9tYXAlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfYWRhcHRlcl9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMm1vbm9jaHJvbWUlMkMlMjBsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
image = pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=depth_map,
    ip_adapter_image=ip_adapter_image,
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){i=m("meta"),b=n(),o=m("p"),f=n(),M(T.$$.fragment),G=n(),g=m("p"),g.innerHTML=v,r=n(),M(j.$$.fragment),I=n(),W=m("p"),W.textContent=k,_=n(),M(C.$$.fragment),u=n(),s=m("p"),s.innerHTML=w,Pe=n(),O=m("p"),O.innerHTML=ma,De=n(),M(Y.$$.fragment),Ke=n(),M(B.$$.fragment),Oe=n(),M(ee.$$.fragment),et=n(),te=m("p"),te.textContent=da,tt=n(),M(ae.$$.fragment),at=n(),le=m("p"),le.innerHTML=ca,lt=n(),M(F.$$.fragment),st=n(),se=m("p"),se.innerHTML=ua,it=n(),M(H.$$.fragment),nt=n(),M(ie.$$.fragment),pt=n(),ne=m("p"),ne.innerHTML=fa,ot=n(),M(pe.$$.fragment),rt=n(),M(oe.$$.fragment),mt=n(),re=m("p"),re.textContent=ga,dt=n(),me=m("p"),me.innerHTML=Ma,ct=n(),M(de.$$.fragment),ut=n(),N=m("div"),N.innerHTML=ya,ft=n(),ce=m("p"),ce.textContent=ha,gt=n(),M(ue.$$.fragment),Mt=n(),Q=m("div"),Q.innerHTML=Za,yt=n(),fe=m("p"),fe.innerHTML=Ja,ht=n(),M(ge.$$.fragment),Zt=n(),A=m("div"),A.innerHTML=Ua,Jt=n(),M(Me.$$.fragment),Ut=n(),ye=m("p"),ye.textContent=ba,bt=n(),M(he.$$.fragment),wt=n(),Ze=m("p"),Ze.textContent=wa,Tt=n(),Je=m("ul"),Je.innerHTML=Ta,jt=n(),M(S.$$.fragment),Wt=n(),Ue=m("p"),Ue.innerHTML=ja,_t=n(),M(be.$$.fragment),Gt=n(),z=m("div"),z.innerHTML=Wa,vt=n(),M(we.$$.fragment),It=n(),Te=m("p"),Te.textContent=_a,kt=n(),M(E.$$.fragment),Xt=n(),je=m("p"),je.innerHTML=Ga,$t=n(),M(We.$$.fragment),Ct=n(),_e=m("p"),_e.innerHTML=va,Rt=n(),Ge=m("ul"),Ge.innerHTML=Ia,xt=n(),M(ve.$$.fragment),Vt=n(),Ie=m("p"),Ie.textContent=ka,Yt=n(),M(ke.$$.fragment),Bt=n(),q=m("div"),q.innerHTML=Xa,Ft=n(),Xe=m("p"),Xe.innerHTML=$a,Ht=n(),M($e.$$.fragment),Nt=n(),L=m("div"),L.innerHTML=Ca,Qt=n(),M(Ce.$$.fragment),At=n(),Re=m("p"),Re.innerHTML=Ra,St=n(),xe=m("p"),xe.innerHTML=xa,zt=n(),M(Ve.$$.fragment),Et=n(),Ye=m("p"),Ye.innerHTML=Va,qt=n(),M(Be.$$.fragment),Lt=n(),P=m("div"),P.innerHTML=Ya,Pt=n(),M(Fe.$$.fragment),Dt=n(),He=m("p"),He.innerHTML=Ba,Kt=n(),Ne=m("p"),Ne.innerHTML=Fa,Ot=n(),M(Qe.$$.fragment),ea=n(),Ae=m("p"),Ae.textContent=Ha,ta=n(),M(Se.$$.fragment),aa=n(),D=m("div"),D.innerHTML=Na,la=n(),ze=m("p"),ze.textContent=Qa,sa=n(),M(Ee.$$.fragment),ia=n(),K=m("div"),K.innerHTML=Aa,na=n(),Le=m("p"),this.h()},l(e){const a=al("svelte-u9bgzb",document.head);i=d(a,"META",{name:!0,content:!0}),a.forEach(t),b=p(e),o=d(e,"P",{}),ra(o).forEach(t),f=p(e),y(T.$$.fragment,e),G=p(e),g=d(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-rd9njz"&&(g.innerHTML=v),r=p(e),y(j.$$.fragment,e),I=p(e),W=d(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1211s0v"&&(W.textContent=k),_=p(e),y(C.$$.fragment,e),u=p(e),s=d(e,"P",{"data-svelte-h":!0}),c(s)!=="svelte-nh8dt6"&&(s.innerHTML=w),Pe=p(e),O=d(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-13xtfkj"&&(O.innerHTML=ma),De=p(e),y(Y.$$.fragment,e),Ke=p(e),y(B.$$.fragment,e),Oe=p(e),y(ee.$$.fragment,e),et=p(e),te=d(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-1ytpuar"&&(te.textContent=da),tt=p(e),y(ae.$$.fragment,e),at=p(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-csxost"&&(le.innerHTML=ca),lt=p(e),y(F.$$.fragment,e),st=p(e),se=d(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1h2tzec"&&(se.innerHTML=ua),it=p(e),y(H.$$.fragment,e),nt=p(e),y(ie.$$.fragment,e),pt=p(e),ne=d(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1nluq5y"&&(ne.innerHTML=fa),ot=p(e),y(pe.$$.fragment,e),rt=p(e),y(oe.$$.fragment,e),mt=p(e),re=d(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-18t8qca"&&(re.textContent=ga),dt=p(e),me=d(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-ci17qi"&&(me.innerHTML=Ma),ct=p(e),y(de.$$.fragment,e),ut=p(e),N=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(N)!=="svelte-eifaa"&&(N.innerHTML=ya),ft=p(e),ce=d(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-uxfn1w"&&(ce.textContent=ha),gt=p(e),y(ue.$$.fragment,e),Mt=p(e),Q=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(Q)!=="svelte-m35a5e"&&(Q.innerHTML=Za),yt=p(e),fe=d(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1oy5psd"&&(fe.innerHTML=Ja),ht=p(e),y(ge.$$.fragment,e),Zt=p(e),A=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(A)!=="svelte-1rjzzk0"&&(A.innerHTML=Ua),Jt=p(e),y(Me.$$.fragment,e),Ut=p(e),ye=d(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-3uurtn"&&(ye.textContent=ba),bt=p(e),y(he.$$.fragment,e),wt=p(e),Ze=d(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-1md71yv"&&(Ze.textContent=wa),Tt=p(e),Je=d(e,"UL",{"data-svelte-h":!0}),c(Je)!=="svelte-1a56pqx"&&(Je.innerHTML=Ta),jt=p(e),y(S.$$.fragment,e),Wt=p(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-net1z6"&&(Ue.innerHTML=ja),_t=p(e),y(be.$$.fragment,e),Gt=p(e),z=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(z)!=="svelte-lbwedl"&&(z.innerHTML=Wa),vt=p(e),y(we.$$.fragment,e),It=p(e),Te=d(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-1tk2m7v"&&(Te.textContent=_a),kt=p(e),y(E.$$.fragment,e),Xt=p(e),je=d(e,"P",{"data-svelte-h":!0}),c(je)!=="svelte-q28q24"&&(je.innerHTML=Ga),$t=p(e),y(We.$$.fragment,e),Ct=p(e),_e=d(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-1vw2kqb"&&(_e.innerHTML=va),Rt=p(e),Ge=d(e,"UL",{"data-svelte-h":!0}),c(Ge)!=="svelte-tpz2u9"&&(Ge.innerHTML=Ia),xt=p(e),y(ve.$$.fragment,e),Vt=p(e),Ie=d(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-1p6lwr0"&&(Ie.textContent=ka),Yt=p(e),y(ke.$$.fragment,e),Bt=p(e),q=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(q)!=="svelte-im3du6"&&(q.innerHTML=Xa),Ft=p(e),Xe=d(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-1kkzavx"&&(Xe.innerHTML=$a),Ht=p(e),y($e.$$.fragment,e),Nt=p(e),L=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(L)!=="svelte-1t1eqqe"&&(L.innerHTML=Ca),Qt=p(e),y(Ce.$$.fragment,e),At=p(e),Re=d(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-1am74qu"&&(Re.innerHTML=Ra),St=p(e),xe=d(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-pbwcwu"&&(xe.innerHTML=xa),zt=p(e),y(Ve.$$.fragment,e),Et=p(e),Ye=d(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-13u2z8i"&&(Ye.innerHTML=Va),qt=p(e),y(Be.$$.fragment,e),Lt=p(e),P=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(P)!=="svelte-1cw2b12"&&(P.innerHTML=Ya),Pt=p(e),y(Fe.$$.fragment,e),Dt=p(e),He=d(e,"P",{"data-svelte-h":!0}),c(He)!=="svelte-sz8jif"&&(He.innerHTML=Ba),Kt=p(e),Ne=d(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-l27604"&&(Ne.innerHTML=Fa),Ot=p(e),y(Qe.$$.fragment,e),ea=p(e),Ae=d(e,"P",{"data-svelte-h":!0}),c(Ae)!=="svelte-77tfin"&&(Ae.textContent=Ha),ta=p(e),y(Se.$$.fragment,e),aa=p(e),D=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(D)!=="svelte-mjuwpp"&&(D.innerHTML=Na),la=p(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-12fzw16"&&(ze.textContent=Qa),sa=p(e),y(Ee.$$.fragment,e),ia=p(e),K=d(e,"DIV",{class:!0,"data-svelte-h":!0}),c(K)!=="svelte-kc4794"&&(K.innerHTML=Aa),na=p(e),Le=d(e,"P",{}),ra(Le).forEach(t),this.h()},h(){R(i,"name","hf:doc:metadata"),R(i,"content",hl),R(N,"class","flex flex-row gap-4"),R(Q,"class","flex flex-row gap-4"),R(A,"class","flex flex-row gap-4"),R(z,"class","flex flex-row gap-4"),R(q,"class","flex flex-row gap-4"),R(L,"class","flex justify-center"),R(P,"class","flex justify-center"),R(D,"class","flex flex-row gap-4"),R(K,"class","flex justify-center")},m(e,a){ll(document.head,i),l(e,b,a),l(e,o,a),l(e,f,a),h(T,e,a),l(e,G,a),l(e,g,a),l(e,r,a),h(j,e,a),l(e,I,a),l(e,W,a),l(e,_,a),h(C,e,a),l(e,u,a),l(e,s,a),l(e,Pe,a),l(e,O,a),l(e,De,a),h(Y,e,a),l(e,Ke,a),h(B,e,a),l(e,Oe,a),h(ee,e,a),l(e,et,a),l(e,te,a),l(e,tt,a),h(ae,e,a),l(e,at,a),l(e,le,a),l(e,lt,a),h(F,e,a),l(e,st,a),l(e,se,a),l(e,it,a),h(H,e,a),l(e,nt,a),h(ie,e,a),l(e,pt,a),l(e,ne,a),l(e,ot,a),h(pe,e,a),l(e,rt,a),h(oe,e,a),l(e,mt,a),l(e,re,a),l(e,dt,a),l(e,me,a),l(e,ct,a),h(de,e,a),l(e,ut,a),l(e,N,a),l(e,ft,a),l(e,ce,a),l(e,gt,a),h(ue,e,a),l(e,Mt,a),l(e,Q,a),l(e,yt,a),l(e,fe,a),l(e,ht,a),h(ge,e,a),l(e,Zt,a),l(e,A,a),l(e,Jt,a),h(Me,e,a),l(e,Ut,a),l(e,ye,a),l(e,bt,a),h(he,e,a),l(e,wt,a),l(e,Ze,a),l(e,Tt,a),l(e,Je,a),l(e,jt,a),h(S,e,a),l(e,Wt,a),l(e,Ue,a),l(e,_t,a),h(be,e,a),l(e,Gt,a),l(e,z,a),l(e,vt,a),h(we,e,a),l(e,It,a),l(e,Te,a),l(e,kt,a),h(E,e,a),l(e,Xt,a),l(e,je,a),l(e,$t,a),h(We,e,a),l(e,Ct,a),l(e,_e,a),l(e,Rt,a),l(e,Ge,a),l(e,xt,a),h(ve,e,a),l(e,Vt,a),l(e,Ie,a),l(e,Yt,a),h(ke,e,a),l(e,Bt,a),l(e,q,a),l(e,Ft,a),l(e,Xe,a),l(e,Ht,a),h($e,e,a),l(e,Nt,a),l(e,L,a),l(e,Qt,a),h(Ce,e,a),l(e,At,a),l(e,Re,a),l(e,St,a),l(e,xe,a),l(e,zt,a),h(Ve,e,a),l(e,Et,a),l(e,Ye,a),l(e,qt,a),h(Be,e,a),l(e,Lt,a),l(e,P,a),l(e,Pt,a),h(Fe,e,a),l(e,Dt,a),l(e,He,a),l(e,Kt,a),l(e,Ne,a),l(e,Ot,a),h(Qe,e,a),l(e,ea,a),l(e,Ae,a),l(e,ta,a),h(Se,e,a),l(e,aa,a),l(e,D,a),l(e,la,a),l(e,ze,a),l(e,sa,a),h(Ee,e,a),l(e,ia,a),l(e,K,a),l(e,na,a),l(e,Le,a),pa=!0},p(e,[a]){const Sa={};a&2&&(Sa.$$scope={dirty:a,ctx:e}),j.$set(Sa);const za={};a&2&&(za.$$scope={dirty:a,ctx:e}),Y.$set(za);const Ea={};a&2&&(Ea.$$scope={dirty:a,ctx:e}),B.$set(Ea);const qa={};a&2&&(qa.$$scope={dirty:a,ctx:e}),F.$set(qa);const La={};a&2&&(La.$$scope={dirty:a,ctx:e}),H.$set(La);const Pa={};a&2&&(Pa.$$scope={dirty:a,ctx:e}),S.$set(Pa);const Da={};a&2&&(Da.$$scope={dirty:a,ctx:e}),E.$set(Da)},i(e){pa||(Z(T.$$.fragment,e),Z(j.$$.fragment,e),Z(C.$$.fragment,e),Z(Y.$$.fragment,e),Z(B.$$.fragment,e),Z(ee.$$.fragment,e),Z(ae.$$.fragment,e),Z(F.$$.fragment,e),Z(H.$$.fragment,e),Z(ie.$$.fragment,e),Z(pe.$$.fragment,e),Z(oe.$$.fragment,e),Z(de.$$.fragment,e),Z(ue.$$.fragment,e),Z(ge.$$.fragment,e),Z(Me.$$.fragment,e),Z(he.$$.fragment,e),Z(S.$$.fragment,e),Z(be.$$.fragment,e),Z(we.$$.fragment,e),Z(E.$$.fragment,e),Z(We.$$.fragment,e),Z(ve.$$.fragment,e),Z(ke.$$.fragment,e),Z($e.$$.fragment,e),Z(Ce.$$.fragment,e),Z(Ve.$$.fragment,e),Z(Be.$$.fragment,e),Z(Fe.$$.fragment,e),Z(Qe.$$.fragment,e),Z(Se.$$.fragment,e),Z(Ee.$$.fragment,e),pa=!0)},o(e){J(T.$$.fragment,e),J(j.$$.fragment,e),J(C.$$.fragment,e),J(Y.$$.fragment,e),J(B.$$.fragment,e),J(ee.$$.fragment,e),J(ae.$$.fragment,e),J(F.$$.fragment,e),J(H.$$.fragment,e),J(ie.$$.fragment,e),J(pe.$$.fragment,e),J(oe.$$.fragment,e),J(de.$$.fragment,e),J(ue.$$.fragment,e),J(ge.$$.fragment,e),J(Me.$$.fragment,e),J(he.$$.fragment,e),J(S.$$.fragment,e),J(be.$$.fragment,e),J(we.$$.fragment,e),J(E.$$.fragment,e),J(We.$$.fragment,e),J(ve.$$.fragment,e),J(ke.$$.fragment,e),J($e.$$.fragment,e),J(Ce.$$.fragment,e),J(Ve.$$.fragment,e),J(Be.$$.fragment,e),J(Fe.$$.fragment,e),J(Qe.$$.fragment,e),J(Se.$$.fragment,e),J(Ee.$$.fragment,e),pa=!1},d(e){e&&(t(b),t(o),t(f),t(G),t(g),t(r),t(I),t(W),t(_),t(u),t(s),t(Pe),t(O),t(De),t(Ke),t(Oe),t(et),t(te),t(tt),t(at),t(le),t(lt),t(st),t(se),t(it),t(nt),t(pt),t(ne),t(ot),t(rt),t(mt),t(re),t(dt),t(me),t(ct),t(ut),t(N),t(ft),t(ce),t(gt),t(Mt),t(Q),t(yt),t(fe),t(ht),t(Zt),t(A),t(Jt),t(Ut),t(ye),t(bt),t(wt),t(Ze),t(Tt),t(Je),t(jt),t(Wt),t(Ue),t(_t),t(Gt),t(z),t(vt),t(It),t(Te),t(kt),t(Xt),t(je),t($t),t(Ct),t(_e),t(Rt),t(Ge),t(xt),t(Vt),t(Ie),t(Yt),t(Bt),t(q),t(Ft),t(Xe),t(Ht),t(Nt),t(L),t(Qt),t(At),t(Re),t(St),t(xe),t(zt),t(Et),t(Ye),t(qt),t(Lt),t(P),t(Pt),t(Dt),t(He),t(Kt),t(Ne),t(Ot),t(ea),t(Ae),t(ta),t(aa),t(D),t(la),t(ze),t(sa),t(ia),t(K),t(na),t(Le)),t(i),U(T,e),U(j,e),U(C,e),U(Y,e),U(B,e),U(ee,e),U(ae,e),U(F,e),U(H,e),U(ie,e),U(pe,e),U(oe,e),U(de,e),U(ue,e),U(ge,e),U(Me,e),U(he,e),U(S,e),U(be,e),U(we,e),U(E,e),U(We,e),U(ve,e),U(ke,e),U($e,e),U(Ce,e),U(Ve,e),U(Be,e),U(Fe,e),U(Qe,e),U(Se,e),U(Ee,e)}}}const hl='{"title":"IP-Adapter","local":"ip-adapter","sections":[{"title":"General tasks","local":"general-tasks","sections":[],"depth":2},{"title":"Configure parameters","local":"configure-parameters","sections":[{"title":"Image embeddings","local":"image-embeddings","sections":[],"depth":3},{"title":"IP-Adapter masking","local":"ip-adapter-masking","sections":[],"depth":3}],"depth":2},{"title":"Specific use cases","local":"specific-use-cases","sections":[{"title":"Face model","local":"face-model","sections":[],"depth":3},{"title":"Multi IP-Adapter","local":"multi-ip-adapter","sections":[],"depth":3},{"title":"Instant generation","local":"instant-generation","sections":[],"depth":3},{"title":"Structural control","local":"structural-control","sections":[],"depth":3}],"depth":2}],"depth":1}';function Zl(X){return Oa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wl extends el{constructor(i){super(),tl(this,i,Zl,yl,Ka,{})}}export{Wl as component};
