import{s as ts,n as ns,o as os}from"../chunks/scheduler.182ea377.js";import{S as as,i as is,g as a,s as n,r as p,A as ps,h as i,f as l,c as o,j as ss,u,x as r,k as ls,y as us,a as t,v as M,d as h,t as b,w as c}from"../chunks/index.abf12888.js";import{C as T}from"../chunks/CodeBlock.57fe6e13.js";import{D as rs}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as O}from"../chunks/Heading.16916d63.js";function Ms(Ne){let m,ee,L,se,J,le,f,te,d,Ee='🤗 Diffusers provides a <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> for uploading your model, scheduler, or pipeline to the Hub. It is an easy way to store your files on the Hub, and also allows you to share your work with others. Under the hood, the <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a>:',ne,y,We="<li>creates a repository on the Hub</li> <li>saves your model, scheduler, or pipeline files so they can be reloaded later</li> <li>uploads folder containing these files to the Hub</li>",oe,w,Re='This guide will show you how to use the <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin">PushToHubMixin</a> to upload your files to the Hub.',ae,j,He='You’ll need to log in to your Hub account with your access <a href="https://huggingface.co/settings/tokens" rel="nofollow">token</a> first:',ie,I,pe,_,ue,U,xe='To push a model to the Hub, call <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the model to be stored on the Hub:',re,v,Me,k,Ye='For models, you can also specify the <a href="loading#checkpoint-variants"><em>variant</em></a> of the weights to push to the Hub. For example, to push <code>fp16</code> weights:',he,Z,be,$,Qe='The <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the model’s <code>config.json</code> file and the weights are automatically saved in the <code>safetensors</code> format.',ce,B,ze="Now you can reload the model from your repository on the Hub:",Te,g,me,C,Je,G,Se='To push a scheduler to the Hub, call <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> and specify the repository id of the scheduler to be stored on the Hub:',fe,V,de,D,qe='The <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves the scheduler’s <code>scheduler_config.json</code> file to the specified repository.',ye,X,Ae="Now you can reload the scheduler from your repository on the Hub:",we,N,je,E,Ie,W,Fe='You can also push an entire pipeline with all it’s components to the Hub. For example, initialize the components of a <a href="/docs/diffusers/v0.22.3/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with the parameters you want:',_e,R,Ue,H,Pe='Pass all of the components to the <a href="/docs/diffusers/v0.22.3/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and call <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to push the pipeline to the Hub:',ve,x,ke,Y,Le='The <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function saves each component to a subfolder in the repository. Now you can reload the pipeline from your repository on the Hub:',Ze,Q,$e,z,Be,S,Ke='Set <code>private=True</code> in the <a href="/docs/diffusers/v0.22.3/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> function to keep your model, scheduler, or pipeline files private:',ge,q,Ce,A,Oe="Private repositories are only visible to you, and other users won’t be able to clone the repository and your repository won’t appear in search results. Even if a user has the URL to your private repository, they’ll receive a <code>404 - Sorry, we can&#39;t find the page you are looking for.</code>",Ge,F,es="To load a model, scheduler, or pipeline from private or gated repositories, set <code>use_auth_token=True</code>:",Ve,P,De,K,Xe;return J=new O({props:{title:"Push files to the Hub",local:"push-files-to-the-hub",headingTag:"h1"}}),f=new rs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/push_to_hub.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/push_to_hub.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/push_to_hub.ipynb"}]}}),I=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),_=new O({props:{title:"Models",local:"models",headingTag:"h2"}}),v=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwoJTBBJTIwJTIwJTIwJTIwYmxvY2tfb3V0X2NoYW5uZWxzJTNEKDMyJTJDJTIwNjQpJTJDJTBBJTIwJTIwJTIwJTIwbGF5ZXJzX3Blcl9ibG9jayUzRDIlMkMlMEElMjAlMjAlMjAlMjBpbl9jaGFubmVscyUzRDQlMkMlMEElMjAlMjAlMjAlMjBkb3duX2Jsb2NrX3R5cGVzJTNEKCUyMkRvd25CbG9jazJEJTIyJTJDJTIwJTIyQ3Jvc3NBdHRuRG93bkJsb2NrMkQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwY3Jvc3NfYXR0ZW50aW9uX2RpbSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwY29uZGl0aW9uaW5nX2VtYmVkZGluZ19vdXRfY2hhbm5lbHMlM0QoMTYlMkMlMjAzMiklMkMlMEEpJTBBY29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel

controlnet = ControlNetModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    in_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
    conditioning_embedding_out_channels=(<span class="hljs-number">16</span>, <span class="hljs-number">32</span>),
)
controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>)`,wrap:!1}}),Z=new T({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsJTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIp",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)',wrap:!1}}),g=new T({props:{code:"bW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnlvdXItbmFtZXNwYWNlJTJGbXktY29udHJvbG5ldC1tb2RlbCUyMik=",highlighted:'model = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-controlnet-model&quot;</span>)',wrap:!1}}),C=new O({props:{title:"Scheduler",local:"scheduler",headingTag:"h2"}}),V=new T({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMGJldGFfc3RhcnQlM0QwLjAwMDg1JTJDJTBBJTIwJTIwJTIwJTIwYmV0YV9lbmQlM0QwLjAxMiUyQyUwQSUyMCUyMCUyMCUyMGJldGFfc2NoZWR1bGUlM0QlMjJzY2FsZWRfbGluZWFyJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHNldF9hbHBoYV90b19vbmUlM0RGYWxzZSUyQyUwQSklMEFzY2hlZHVsZXIucHVzaF90b19odWIoJTIybXktY29udHJvbG5ldC1zY2hlZHVsZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)
scheduler.push_to_hub(<span class="hljs-string">&quot;my-controlnet-scheduler&quot;</span>)`,wrap:!1}}),N=new T({props:{code:"c2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lcHNhY2UlMkZteS1jb250cm9sbmV0LXNjaGVkdWxlciUyMik=",highlighted:'scheduler = DDIMScheduler.from_pretrained(<span class="hljs-string">&quot;your-namepsace/my-controlnet-scheduler&quot;</span>)',wrap:!1}}),E=new O({props:{title:"Pipeline",local:"pipeline",headingTag:"h2"}}),R=new T({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    UNet2DConditionModel,
    AutoencoderKL,
    DDIMScheduler,
    StableDiffusionPipeline,
)
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel, CLIPTextConfig, CLIPTokenizer

unet = UNet2DConditionModel(
    block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>),
    layers_per_block=<span class="hljs-number">2</span>,
    sample_size=<span class="hljs-number">32</span>,
    in_channels=<span class="hljs-number">4</span>,
    out_channels=<span class="hljs-number">4</span>,
    down_block_types=(<span class="hljs-string">&quot;DownBlock2D&quot;</span>, <span class="hljs-string">&quot;CrossAttnDownBlock2D&quot;</span>),
    up_block_types=(<span class="hljs-string">&quot;CrossAttnUpBlock2D&quot;</span>, <span class="hljs-string">&quot;UpBlock2D&quot;</span>),
    cross_attention_dim=<span class="hljs-number">32</span>,
)

scheduler = DDIMScheduler(
    beta_start=<span class="hljs-number">0.00085</span>,
    beta_end=<span class="hljs-number">0.012</span>,
    beta_schedule=<span class="hljs-string">&quot;scaled_linear&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    set_alpha_to_one=<span class="hljs-literal">False</span>,
)

vae = AutoencoderKL(
    block_out_channels=[<span class="hljs-number">32</span>, <span class="hljs-number">64</span>],
    in_channels=<span class="hljs-number">3</span>,
    out_channels=<span class="hljs-number">3</span>,
    down_block_types=[<span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>, <span class="hljs-string">&quot;DownEncoderBlock2D&quot;</span>],
    up_block_types=[<span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>, <span class="hljs-string">&quot;UpDecoderBlock2D&quot;</span>],
    latent_channels=<span class="hljs-number">4</span>,
)

text_encoder_config = CLIPTextConfig(
    bos_token_id=<span class="hljs-number">0</span>,
    eos_token_id=<span class="hljs-number">2</span>,
    hidden_size=<span class="hljs-number">32</span>,
    intermediate_size=<span class="hljs-number">37</span>,
    layer_norm_eps=<span class="hljs-number">1e-05</span>,
    num_attention_heads=<span class="hljs-number">4</span>,
    num_hidden_layers=<span class="hljs-number">5</span>,
    pad_token_id=<span class="hljs-number">1</span>,
    vocab_size=<span class="hljs-number">1000</span>,
)
text_encoder = CLIPTextModel(text_encoder_config)
tokenizer = CLIPTokenizer.from_pretrained(<span class="hljs-string">&quot;hf-internal-testing/tiny-random-clip&quot;</span>)`,wrap:!1}}),x=new T({props:{code:"Y29tcG9uZW50cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnVuZXQlMjIlM0ElMjB1bmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwc2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydmFlJTIyJTNBJTIwdmFlJTJDJTBBJTIwJTIwJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwdGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIydG9rZW5pemVyJTIyJTNBJTIwdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIyc2FmZXR5X2NoZWNrZXIlMjIlM0ElMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjBOb25lJTJDJTBBJTdEJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSgqKmNvbXBvbmVudHMpJTBBcGlwZWxpbmUucHVzaF90b19odWIoJTIybXktcGlwZWxpbmUlMjIp",highlighted:`components = {
    <span class="hljs-string">&quot;unet&quot;</span>: unet,
    <span class="hljs-string">&quot;scheduler&quot;</span>: scheduler,
    <span class="hljs-string">&quot;vae&quot;</span>: vae,
    <span class="hljs-string">&quot;text_encoder&quot;</span>: text_encoder,
    <span class="hljs-string">&quot;tokenizer&quot;</span>: tokenizer,
    <span class="hljs-string">&quot;safety_checker&quot;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&quot;feature_extractor&quot;</span>: <span class="hljs-literal">None</span>,
}

pipeline = StableDiffusionPipeline(**components)
pipeline.push_to_hub(<span class="hljs-string">&quot;my-pipeline&quot;</span>)`,wrap:!1}}),Q=new T({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci1uYW1lc3BhY2UlMkZteS1waXBlbGluZSUyMik=",highlighted:'pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-pipeline&quot;</span>)',wrap:!1}}),z=new O({props:{title:"Privacy",local:"privacy",headingTag:"h2"}}),q=new T({props:{code:"Y29udHJvbG5ldC5wdXNoX3RvX2h1YiglMjJteS1jb250cm9sbmV0LW1vZGVsLXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:'controlnet.push_to_hub(<span class="hljs-string">&quot;my-controlnet-model-private&quot;</span>, private=<span class="hljs-literal">True</span>)',wrap:!1}}),P=new T({props:{code:"bW9kZWwlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnlvdXItbmFtZXNwYWNlJTJGbXktY29udHJvbG5ldC1tb2RlbC1wcml2YXRlJTIyJTJDJTIwdXNlX2F1dGhfdG9rZW4lM0RUcnVlKQ==",highlighted:'model = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;your-namespace/my-controlnet-model-private&quot;</span>, use_auth_token=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){m=a("meta"),ee=n(),L=a("p"),se=n(),p(J.$$.fragment),le=n(),p(f.$$.fragment),te=n(),d=a("p"),d.innerHTML=Ee,ne=n(),y=a("ol"),y.innerHTML=We,oe=n(),w=a("p"),w.innerHTML=Re,ae=n(),j=a("p"),j.innerHTML=He,ie=n(),p(I.$$.fragment),pe=n(),p(_.$$.fragment),ue=n(),U=a("p"),U.innerHTML=xe,re=n(),p(v.$$.fragment),Me=n(),k=a("p"),k.innerHTML=Ye,he=n(),p(Z.$$.fragment),be=n(),$=a("p"),$.innerHTML=Qe,ce=n(),B=a("p"),B.textContent=ze,Te=n(),p(g.$$.fragment),me=n(),p(C.$$.fragment),Je=n(),G=a("p"),G.innerHTML=Se,fe=n(),p(V.$$.fragment),de=n(),D=a("p"),D.innerHTML=qe,ye=n(),X=a("p"),X.textContent=Ae,we=n(),p(N.$$.fragment),je=n(),p(E.$$.fragment),Ie=n(),W=a("p"),W.innerHTML=Fe,_e=n(),p(R.$$.fragment),Ue=n(),H=a("p"),H.innerHTML=Pe,ve=n(),p(x.$$.fragment),ke=n(),Y=a("p"),Y.innerHTML=Le,Ze=n(),p(Q.$$.fragment),$e=n(),p(z.$$.fragment),Be=n(),S=a("p"),S.innerHTML=Ke,ge=n(),p(q.$$.fragment),Ce=n(),A=a("p"),A.innerHTML=Oe,Ge=n(),F=a("p"),F.innerHTML=es,Ve=n(),p(P.$$.fragment),De=n(),K=a("p"),this.h()},l(e){const s=ps("svelte-u9bgzb",document.head);m=i(s,"META",{name:!0,content:!0}),s.forEach(l),ee=o(e),L=i(e,"P",{}),ss(L).forEach(l),se=o(e),u(J.$$.fragment,e),le=o(e),u(f.$$.fragment,e),te=o(e),d=i(e,"P",{"data-svelte-h":!0}),r(d)!=="svelte-19dlo2k"&&(d.innerHTML=Ee),ne=o(e),y=i(e,"OL",{"data-svelte-h":!0}),r(y)!=="svelte-11ocvlf"&&(y.innerHTML=We),oe=o(e),w=i(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-rqrt0b"&&(w.innerHTML=Re),ae=o(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1bojsgz"&&(j.innerHTML=He),ie=o(e),u(I.$$.fragment,e),pe=o(e),u(_.$$.fragment,e),ue=o(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1nkqlcs"&&(U.innerHTML=xe),re=o(e),u(v.$$.fragment,e),Me=o(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1eiubrc"&&(k.innerHTML=Ye),he=o(e),u(Z.$$.fragment,e),be=o(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1lw8k2b"&&($.innerHTML=Qe),ce=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1bcc50k"&&(B.textContent=ze),Te=o(e),u(g.$$.fragment,e),me=o(e),u(C.$$.fragment,e),Je=o(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-136ycxg"&&(G.innerHTML=Se),fe=o(e),u(V.$$.fragment,e),de=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-pf4pvj"&&(D.innerHTML=qe),ye=o(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-rpu5q4"&&(X.textContent=Ae),we=o(e),u(N.$$.fragment,e),je=o(e),u(E.$$.fragment,e),Ie=o(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-14z1x36"&&(W.innerHTML=Fe),_e=o(e),u(R.$$.fragment,e),Ue=o(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1ve2ci8"&&(H.innerHTML=Pe),ve=o(e),u(x.$$.fragment,e),ke=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1b88lej"&&(Y.innerHTML=Le),Ze=o(e),u(Q.$$.fragment,e),$e=o(e),u(z.$$.fragment,e),Be=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-r3guhm"&&(S.innerHTML=Ke),ge=o(e),u(q.$$.fragment,e),Ce=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1xaf5nd"&&(A.innerHTML=Oe),Ge=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1fm5zde"&&(F.innerHTML=es),Ve=o(e),u(P.$$.fragment,e),De=o(e),K=i(e,"P",{}),ss(K).forEach(l),this.h()},h(){ls(m,"name","hf:doc:metadata"),ls(m,"content",hs)},m(e,s){us(document.head,m),t(e,ee,s),t(e,L,s),t(e,se,s),M(J,e,s),t(e,le,s),M(f,e,s),t(e,te,s),t(e,d,s),t(e,ne,s),t(e,y,s),t(e,oe,s),t(e,w,s),t(e,ae,s),t(e,j,s),t(e,ie,s),M(I,e,s),t(e,pe,s),M(_,e,s),t(e,ue,s),t(e,U,s),t(e,re,s),M(v,e,s),t(e,Me,s),t(e,k,s),t(e,he,s),M(Z,e,s),t(e,be,s),t(e,$,s),t(e,ce,s),t(e,B,s),t(e,Te,s),M(g,e,s),t(e,me,s),M(C,e,s),t(e,Je,s),t(e,G,s),t(e,fe,s),M(V,e,s),t(e,de,s),t(e,D,s),t(e,ye,s),t(e,X,s),t(e,we,s),M(N,e,s),t(e,je,s),M(E,e,s),t(e,Ie,s),t(e,W,s),t(e,_e,s),M(R,e,s),t(e,Ue,s),t(e,H,s),t(e,ve,s),M(x,e,s),t(e,ke,s),t(e,Y,s),t(e,Ze,s),M(Q,e,s),t(e,$e,s),M(z,e,s),t(e,Be,s),t(e,S,s),t(e,ge,s),M(q,e,s),t(e,Ce,s),t(e,A,s),t(e,Ge,s),t(e,F,s),t(e,Ve,s),M(P,e,s),t(e,De,s),t(e,K,s),Xe=!0},p:ns,i(e){Xe||(h(J.$$.fragment,e),h(f.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(v.$$.fragment,e),h(Z.$$.fragment,e),h(g.$$.fragment,e),h(C.$$.fragment,e),h(V.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),h(R.$$.fragment,e),h(x.$$.fragment,e),h(Q.$$.fragment,e),h(z.$$.fragment,e),h(q.$$.fragment,e),h(P.$$.fragment,e),Xe=!0)},o(e){b(J.$$.fragment,e),b(f.$$.fragment,e),b(I.$$.fragment,e),b(_.$$.fragment,e),b(v.$$.fragment,e),b(Z.$$.fragment,e),b(g.$$.fragment,e),b(C.$$.fragment,e),b(V.$$.fragment,e),b(N.$$.fragment,e),b(E.$$.fragment,e),b(R.$$.fragment,e),b(x.$$.fragment,e),b(Q.$$.fragment,e),b(z.$$.fragment,e),b(q.$$.fragment,e),b(P.$$.fragment,e),Xe=!1},d(e){e&&(l(ee),l(L),l(se),l(le),l(te),l(d),l(ne),l(y),l(oe),l(w),l(ae),l(j),l(ie),l(pe),l(ue),l(U),l(re),l(Me),l(k),l(he),l(be),l($),l(ce),l(B),l(Te),l(me),l(Je),l(G),l(fe),l(de),l(D),l(ye),l(X),l(we),l(je),l(Ie),l(W),l(_e),l(Ue),l(H),l(ve),l(ke),l(Y),l(Ze),l($e),l(Be),l(S),l(ge),l(Ce),l(A),l(Ge),l(F),l(Ve),l(De),l(K)),l(m),c(J,e),c(f,e),c(I,e),c(_,e),c(v,e),c(Z,e),c(g,e),c(C,e),c(V,e),c(N,e),c(E,e),c(R,e),c(x,e),c(Q,e),c(z,e),c(q,e),c(P,e)}}}const hs='{"title":"Push files to the Hub","local":"push-files-to-the-hub","sections":[{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Scheduler","local":"scheduler","sections":[],"depth":2},{"title":"Pipeline","local":"pipeline","sections":[],"depth":2},{"title":"Privacy","local":"privacy","sections":[],"depth":2}],"depth":1}';function bs(Ne){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends as{constructor(m){super(),is(this,m,bs,Ms,ts,{})}}export{ds as component};
