import{s as Zl,n as jl,o as Ul}from"../chunks/scheduler.9039eef2.js";import{S as Wl,i as Bl,g as d,s as a,r as i,A as $l,h as f,f as t,c as n,j as Tl,u as p,x as M,k as gl,l as Xl,y as _l,a as s,v as r,d as o,t as m,w as c}from"../chunks/index.ded8f90d.js";import{C as y}from"../chunks/CodeBlock.8580f3e8.js";import{H as h}from"../chunks/Heading.f027f30d.js";function kl(ll){let b,oe,pe,me,w,ce,J,tl="TRL is designed with modularity in mind so that users to be able to efficiently customize the training loop for their needs. Below are some examples on how you can apply and test different techniques.",de,T,fe,g,sl="The trainers in TRL use 🤗 Accelerate to enable distributed training across multiple GPUs or nodes. To do so, first create an 🤗 Accelerate config file by running",Me,Z,ye,j,al="and answering the questions according to your multi-gpu / multi-node setup. You can then launch distributed training by running:",he,U,be,W,nl='We also provide config files in the <a href="https://github.com/huggingface/trl/tree/main/examples/accelerate_configs" rel="nofollow">examples folder</a> that can be used as templates. To use these templates, simply pass the path to the config file when launching a job, e.g.:',ue,B,we,$,il='Refer to the <a href="https://github.com/huggingface/trl/tree/main/examples" rel="nofollow">examples page</a> for more details.',Je,X,Te,_,pl="All of the trainers in TRL can be run on multiple GPUs together with DeepSpeed ZeRO-{1,2,3} for efficient sharding of the optimizer states, gradients, and model weights. To do so, run:",ge,k,Ze,V,rl='Note that for ZeRO-3, a small tweak is needed to initialize your reward model on the correct device via the <code>zero3_init_context_manager()</code> context manager. In particular, this is needed to avoid DeepSpeed hanging after a fixed number of training steps. Here is a snippet of what is involved from the <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/ppo.py" rel="nofollow"><code>sentiment_tuning</code></a> example:',je,G,Ue,v,ol='Consult the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/usage_guides/deepspeed" rel="nofollow">documentation</a> for more information about the DeepSpeed plugin.',We,C,Be,z,ml="By default, the <code>PPOTrainer</code> creates a <code>torch.optim.Adam</code> optimizer. You can create and define a different optimizer and pass it to <code>PPOTrainer</code>:",$e,I,Xe,R,cl="For memory efficient fine-tuning, you can also pass <code>Adam8bit</code> optimizer from <code>bitsandbytes</code>:",_e,x,ke,F,Ve,Q,dl='You can use the new <a href="https://arxiv.org/abs/2302.06675" rel="nofollow">LION optimizer from Google</a> as well, first take the source code of the optimizer definition <a href="https://github.com/lucidrains/lion-pytorch/blob/main/lion_pytorch/lion_pytorch.py" rel="nofollow">here</a>, and copy it so that you can import the optimizer. Make sure to initialize the optimizer by considering the trainable parameters only for a more memory efficient training:',Ge,Y,ve,H,fl='We advise you to use the learning rate that you would use for <code>Adam</code> divided by 3 as pointed out <a href="https://github.com/lucidrains/lion-pytorch#lion---pytorch" rel="nofollow">here</a>. We observed an improvement when using this optimizer compared to classic Adam (check the full logs <a href="https://wandb.ai/distill-bloom/trl/runs/lj4bheke?workspace=user-younesbelkada" rel="nofollow">here</a>):',Ce,u,Ml='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-lion.png"/>',ze,N,Ie,E,yl="You can also play with your training by adding learning rate schedulers!",Re,P,xe,S,Fe,L,hl="Another tool you can use for more memory efficient fine-tuning is to share layers between the reference model and the model you want to train.",Qe,A,Ye,D,He,O,bl='<p>Since <code>trl</code> supports all key word arguments when loading a model from <code>transformers</code> using <code>from_pretrained</code>, you can also leverage <code>load_in_8bit</code> from <code>transformers</code> for more memory efficient fine-tuning.</p> <p>Read more about 8-bit model loading in <code>transformers</code> <a href="https://huggingface.co/docs/transformers/perf_infer_gpu_one#bitsandbytes-integration-for-int8-mixedprecision-matrix-decomposition" rel="nofollow">here</a>.</p>',Ne,K,Ee,q,Pe,ee,ul="When training large models, you should better handle the CUDA cache by iteratively clearing it. Do do so, simply pass <code>optimize_cuda_cache=True</code> to <code>PPOConfig</code>:",Se,le,Le,te,Ae,se,wl='As suggested by <a href="https://arxiv.org/abs/2307.04964" rel="nofollow">Secrets of RLHF in Large Language Models Part I: PPO</a>, we support score (aka reward) scaling/normalization/clipping to improve training stability via <code>PPOConfig</code>:',De,ae,Oe,ne,Jl="To run <code>ppo.py</code>, you can use the following command:",Ke,ie,qe,re,el;return w=new h({props:{title:"Training customization",local:"training-customization",headingTag:"h1"}}),T=new h({props:{title:"Train on multiple GPUs / nodes",local:"train-on-multiple-gpus--nodes",headingTag:"h2"}}),Z=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),U=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHlvdXJfc2NyaXB0LnB5",highlighted:"accelerate launch your_script.py",wrap:!1}}),B=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlM0RleGFtcGxlcyUyRmFjY2VsZXJhdGVfY29uZmlncyUyRm11bHRpX2dwdS55YW1sJTIwLS1udW1fcHJvY2Vzc2VzJTIwJTdCTlVNX0dQVVMlN0QlMjBwYXRoX3RvX3NjcmlwdC5weSUyMC0tYWxsX2FyZ3VtZW50c19vZl90aGVfc2NyaXB0",highlighted:"accelerate launch --config_file=examples/accelerate_configs/multi_gpu.yaml --num_processes {NUM_GPUS} path_to_script.py --all_arguments_of_the_script",wrap:!1}}),X=new h({props:{title:"Distributed training with DeepSpeed",local:"distributed-training-with-deepspeed",headingTag:"h3"}}),k=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlM0RleGFtcGxlcyUyRmFjY2VsZXJhdGVfY29uZmlncyUyRmRlZXBzcGVlZF96ZXJvJTdCMSUyQzIlMkMzJTdELnlhbWwlMjAtLW51bV9wcm9jZXNzZXMlMjAlN0JOVU1fR1BVUyU3RCUyMHBhdGhfdG9feW91cl9zY3JpcHQucHklMjAtLWFsbF9hcmd1bWVudHNfb2ZfdGhlX3NjcmlwdA==",highlighted:"accelerate launch --config_file=examples/accelerate_configs/deepspeed_zero{1,2,3}.yaml --num_processes {NUM_GPUS} path_to_your_script.py --all_arguments_of_the_script",wrap:!1}}),G=new y({props:{code:"ZHNfcGx1Z2luJTIwJTNEJTIwcHBvX3RyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZGVlcHNwZWVkX3BsdWdpbiUwQWlmJTIwZHNfcGx1Z2luJTIwaXMlMjBub3QlMjBOb25lJTIwYW5kJTIwZHNfcGx1Z2luLmlzX3plcm8zX2luaXRfZW5hYmxlZCgpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGRzX3BsdWdpbi56ZXJvM19pbml0X2NvbnRleHRfbWFuYWdlcihlbmFibGUlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZW50aW1lbnRfcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnNlbnRpbWVudC1hbmFseXNpcyUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMiUyQyUyMGRldmljZSUzRGRldmljZSklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwc2VudGltZW50X3BpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIlMkMlMjBtb2RlbCUzRCUyMmx2d2VycmElMkZkaXN0aWxiZXJ0LWltZGIlMjIlMkMlMjBkZXZpY2UlM0RkZXZpY2Up",highlighted:`ds_plugin = ppo_trainer.accelerator.state.deepspeed_plugin
<span class="hljs-keyword">if</span> ds_plugin <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> ds_plugin.is_zero3_init_enabled():
    <span class="hljs-keyword">with</span> ds_plugin.zero3_init_context_manager(enable=<span class="hljs-literal">False</span>):
        sentiment_pipe = pipeline(<span class="hljs-string">&quot;sentiment-analysis&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>, device=device)
<span class="hljs-keyword">else</span>:
    sentiment_pipe = pipeline(<span class="hljs-string">&quot;sentiment-analysis&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>, device=device)`,wrap:!1}}),C=new h({props:{title:"Use different optimizers",local:"use-different-optimizers",headingTag:"h2"}}),I=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwR1BUMlRva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBQUE9UcmFpbmVyJTJDJTIwUFBPQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTBBJTBBJTIzJTIwMS4lMjBsb2FkJTIwYSUyMHByZXRyYWluZWQlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBbW9kZWxfcmVmJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dwdDInKSUwQSUwQSUyMyUyMDIuJTIwZGVmaW5lJTIwY29uZmlnJTBBcHBvX2NvbmZpZyUyMCUzRCUyMCU3QidiYXRjaF9zaXplJyUzQSUyMDElMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ExZS01JTdEJTBBY29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCoqcHBvX2NvbmZpZyklMEElMEElMEElMjMlMjAyLiUyMENyZWF0ZSUyMG9wdGltaXplciUwQW9wdGltaXplciUyMCUzRCUyMHRvcmNoLm9wdGltLlNHRChtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGNvbmZpZy5sZWFybmluZ19yYXRlKSUwQSUwQSUwQSUyMyUyMDMuJTIwaW5pdGlhbGl6ZSUyMHRyYWluZXIlMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBtb2RlbF9yZWYlMkMlMjB0b2tlbml6ZXIlMkMlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-comment"># 2. define config</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>:<span class="hljs-number">1e-5</span>}
config = PPOConfig(**ppo_config)


<span class="hljs-comment"># 2. Create optimizer</span>
optimizer = torch.optim.SGD(model.parameters(), lr=config.learning_rate)


<span class="hljs-comment"># 3. initialize trainer</span>
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer, optimizer=optimizer)`,wrap:!1}}),x=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBiaXRzYW5kYnl0ZXMlMjBhcyUyMGJuYiUwQSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBHUFQyVG9rZW5pemVyJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT1RyYWluZXIlMkMlMjBQUE9Db25maWclMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQlMEElMEElMjMlMjAxLiUyMGxvYWQlMjBhJTIwcHJldHJhaW5lZCUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQuZnJvbV9wcmV0cmFpbmVkKCdncHQyJyklMEFtb2RlbF9yZWYlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQuZnJvbV9wcmV0cmFpbmVkKCdncHQyJyklMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBJTBBJTIzJTIwMi4lMjBkZWZpbmUlMjBjb25maWclMEFwcG9fY29uZmlnJTIwJTNEJTIwJTdCJ2JhdGNoX3NpemUnJTNBJTIwMSUyQyUyMCdsZWFybmluZ19yYXRlJyUzQTFlLTUlN0QlMEFjb25maWclMjAlM0QlMjBQUE9Db25maWcoKipwcG9fY29uZmlnKSUwQSUwQSUwQSUyMyUyMDIuJTIwQ3JlYXRlJTIwb3B0aW1pemVyJTBBb3B0aW1pemVyJTIwJTNEJTIwYm5iLm9wdGltLkFkYW04Yml0KG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEY29uZmlnLmxlYXJuaW5nX3JhdGUpJTBBJTBBJTIzJTIwMy4lMjBpbml0aWFsaXplJTIwdHJhaW5lciUwQXBwb190cmFpbmVyJTIwJTNEJTIwUFBPVHJhaW5lcihjb25maWclMkMlMjBtb2RlbCUyQyUyMG1vZGVsX3JlZiUyQyUyMHRva2VuaXplciUyQyUyMG9wdGltaXplciUzRG9wdGltaXplcik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-comment"># 2. define config</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>:<span class="hljs-number">1e-5</span>}
config = PPOConfig(**ppo_config)


<span class="hljs-comment"># 2. Create optimizer</span>
optimizer = bnb.optim.Adam8bit(model.parameters(), lr=config.learning_rate)

<span class="hljs-comment"># 3. initialize trainer</span>
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer, optimizer=optimizer)`,wrap:!1}}),F=new h({props:{title:"Use LION optimizer",local:"use-lion-optimizer",headingTag:"h3"}}),Y=new y({props:{code:"",highlighted:`optimizer = Lion(<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> p: p.requires_grad, self.model.parameters()), lr=self.config.learning_rate)

...
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer, optimizer=optimizer)`,wrap:!1}}),N=new h({props:{title:"Add a learning rate scheduler",local:"add-a-learning-rate-scheduler",headingTag:"h2"}}),P=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwR1BUMlRva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBQUE9UcmFpbmVyJTJDJTIwUFBPQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTBBJTBBJTIzJTIwMS4lMjBsb2FkJTIwYSUyMHByZXRyYWluZWQlMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBbW9kZWxfcmVmJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkLmZyb21fcHJldHJhaW5lZCgnZ3B0MicpJTBBdG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2dwdDInKSUwQSUwQSUyMyUyMDIuJTIwZGVmaW5lJTIwY29uZmlnJTBBcHBvX2NvbmZpZyUyMCUzRCUyMCU3QidiYXRjaF9zaXplJyUzQSUyMDElMkMlMjAnbGVhcm5pbmdfcmF0ZSclM0ExZS01JTdEJTBBY29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCoqcHBvX2NvbmZpZyklMEElMEElMEElMjMlMjAyLiUyMENyZWF0ZSUyMG9wdGltaXplciUwQW9wdGltaXplciUyMCUzRCUyMHRvcmNoLm9wdGltLlNHRChtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRGNvbmZpZy5sZWFybmluZ19yYXRlKSUwQWxyX3NjaGVkdWxlciUyMCUzRCUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlci5FeHBvbmVudGlhbExSKG9wdGltaXplciUyQyUyMGdhbW1hJTNEMC45KSUwQSUwQSUyMyUyMDMuJTIwaW5pdGlhbGl6ZSUyMHRyYWluZXIlMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBtb2RlbF9yZWYlMkMlMjB0b2tlbml6ZXIlMkMlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIlM0Rscl9zY2hlZHVsZXIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)
tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&#x27;gpt2&#x27;</span>)

<span class="hljs-comment"># 2. define config</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;learning_rate&#x27;</span>:<span class="hljs-number">1e-5</span>}
config = PPOConfig(**ppo_config)


<span class="hljs-comment"># 2. Create optimizer</span>
optimizer = torch.optim.SGD(model.parameters(), lr=config.learning_rate)
lr_scheduler = torch.optim.lr_scheduler.ExponentialLR(optimizer, gamma=<span class="hljs-number">0.9</span>)

<span class="hljs-comment"># 3. initialize trainer</span>
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer, optimizer=optimizer, lr_scheduler=lr_scheduler)`,wrap:!1}}),S=new h({props:{title:"Memory efficient fine-tuning by sharing layers",local:"memory-efficient-fine-tuning-by-sharing-layers",headingTag:"h2"}}),A=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBQUE9UcmFpbmVyJTJDJTIwUFBPQ29uZmlnJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE1XaXRoVmFsdWVIZWFkJTJDJTIwY3JlYXRlX3JlZmVyZW5jZV9tb2RlbCUwQSUwQSUyMyUyMDEuJTIwbG9hZCUyMGElMjBwcmV0cmFpbmVkJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJ2JpZ3NjaWVuY2UlMkZibG9vbS01NjBtJyklMEFtb2RlbF9yZWYlMjAlM0QlMjBjcmVhdGVfcmVmZXJlbmNlX21vZGVsKG1vZGVsJTJDJTIwbnVtX3NoYXJlZF9sYXllcnMlM0Q2KSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCdiaWdzY2llbmNlJTJGYmxvb20tNTYwbScpJTBBJTBBJTIzJTIwMi4lMjBpbml0aWFsaXplJTIwdHJhaW5lciUwQXBwb19jb25maWclMjAlM0QlMjAlN0InYmF0Y2hfc2l6ZSclM0ElMjAxJTdEJTBBY29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCoqcHBvX2NvbmZpZyklMEFwcG9fdHJhaW5lciUyMCUzRCUyMFBQT1RyYWluZXIoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBtb2RlbF9yZWYlMkMlMjB0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead, create_reference_model

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>)
model_ref = create_reference_model(model, num_shared_layers=<span class="hljs-number">6</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>)

<span class="hljs-comment"># 2. initialize trainer</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>}
config = PPOConfig(**ppo_config)
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer)`,wrap:!1}}),D=new h({props:{title:"Pass 8-bit reference models",local:"pass-8-bit-reference-models",headingTag:"h2"}}),K=new y({props:{code:"JTIzJTIwMC4lMjBpbXBvcnRzJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcyUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwUFBPVHJhaW5lciUyQyUyMFBQT0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZCUwQSUwQSUyMyUyMDEuJTIwbG9hZCUyMGElMjBwcmV0cmFpbmVkJTIwbW9kZWwlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNV2l0aFZhbHVlSGVhZC5mcm9tX3ByZXRyYWluZWQoJ2JpZ3NjaWVuY2UlMkZibG9vbS01NjBtJyklMEFtb2RlbF9yZWYlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTVdpdGhWYWx1ZUhlYWQuZnJvbV9wcmV0cmFpbmVkKCdiaWdzY2llbmNlJTJGYmxvb20tNTYwbSclMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2JpZ3NjaWVuY2UlMkZibG9vbS01NjBtJyklMEElMEElMjMlMjAyLiUyMGluaXRpYWxpemUlMjB0cmFpbmVyJTBBcHBvX2NvbmZpZyUyMCUzRCUyMCU3QidiYXRjaF9zaXplJyUzQSUyMDElN0QlMEFjb25maWclMjAlM0QlMjBQUE9Db25maWcoKipwcG9fY29uZmlnKSUwQXBwb190cmFpbmVyJTIwJTNEJTIwUFBPVHJhaW5lcihjb25maWclMkMlMjBtb2RlbCUyQyUyMG1vZGVsX3JlZiUyQyUyMHRva2VuaXplcik=",highlighted:`<span class="hljs-comment"># 0. imports</span>
<span class="hljs-comment"># pip install bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOTrainer, PPOConfig, AutoModelForCausalLMWithValueHead

<span class="hljs-comment"># 1. load a pretrained model</span>
model = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>)
model_ref = AutoModelForCausalLMWithValueHead.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;bigscience/bloom-560m&#x27;</span>)

<span class="hljs-comment"># 2. initialize trainer</span>
ppo_config = {<span class="hljs-string">&#x27;batch_size&#x27;</span>: <span class="hljs-number">1</span>}
config = PPOConfig(**ppo_config)
ppo_trainer = PPOTrainer(config, model, model_ref, tokenizer)`,wrap:!1}}),q=new h({props:{title:"Use the CUDA cache optimizer",local:"use-the-cuda-cache-optimizer",headingTag:"h2"}}),le=new y({props:{code:"Y29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKC4uLiUyQyUyMG9wdGltaXplX2N1ZGFfY2FjaGUlM0RUcnVlKQ==",highlighted:'config = PPOConfig(..., optimize_cuda_cache=<span class="hljs-literal">True</span>)',wrap:!1}}),te=new h({props:{title:"Use score scaling/normalization/clipping",local:"use-score-scalingnormalizationclipping",headingTag:"h2"}}),ae=new y({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFBQT0NvbmZpZyUwQSUwQXBwb19jb25maWclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjB1c2Vfc2NvcmVfc2NhbGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2NvcmVfbm9ybSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzY29yZV9jbGlwJTNEMC41JTJDJTBBJTdEJTBBY29uZmlnJTIwJTNEJTIwUFBPQ29uZmlnKCoqcHBvX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> PPOConfig

ppo_config = {
    use_score_scaling=<span class="hljs-literal">True</span>,
    use_score_norm=<span class="hljs-literal">True</span>,
    score_clip=<span class="hljs-number">0.5</span>,
}
config = PPOConfig(**ppo_config)`,wrap:!1}}),ie=new y({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGcHBvLnB5JTIwLS1sb2dfd2l0aCUyMHdhbmRiJTIwLS11c2Vfc2NvcmVfc2NhbGluZyUyMC0tdXNlX3Njb3JlX25vcm0lMjAtLXNjb3JlX2NsaXAlMjAwLjU=",highlighted:'python examples/scripts/ppo<span class="hljs-selector-class">.py</span> <span class="hljs-attr">--log_with</span> wandb <span class="hljs-attr">--use_score_scaling</span> <span class="hljs-attr">--use_score_norm</span> <span class="hljs-attr">--score_clip</span> <span class="hljs-number">0.5</span>',wrap:!1}}),{c(){b=d("meta"),oe=a(),pe=d("p"),me=a(),i(w.$$.fragment),ce=a(),J=d("p"),J.textContent=tl,de=a(),i(T.$$.fragment),fe=a(),g=d("p"),g.textContent=sl,Me=a(),i(Z.$$.fragment),ye=a(),j=d("p"),j.textContent=al,he=a(),i(U.$$.fragment),be=a(),W=d("p"),W.innerHTML=nl,ue=a(),i(B.$$.fragment),we=a(),$=d("p"),$.innerHTML=il,Je=a(),i(X.$$.fragment),Te=a(),_=d("p"),_.textContent=pl,ge=a(),i(k.$$.fragment),Ze=a(),V=d("p"),V.innerHTML=rl,je=a(),i(G.$$.fragment),Ue=a(),v=d("p"),v.innerHTML=ol,We=a(),i(C.$$.fragment),Be=a(),z=d("p"),z.innerHTML=ml,$e=a(),i(I.$$.fragment),Xe=a(),R=d("p"),R.innerHTML=cl,_e=a(),i(x.$$.fragment),ke=a(),i(F.$$.fragment),Ve=a(),Q=d("p"),Q.innerHTML=dl,Ge=a(),i(Y.$$.fragment),ve=a(),H=d("p"),H.innerHTML=fl,Ce=a(),u=d("div"),u.innerHTML=Ml,ze=a(),i(N.$$.fragment),Ie=a(),E=d("p"),E.textContent=yl,Re=a(),i(P.$$.fragment),xe=a(),i(S.$$.fragment),Fe=a(),L=d("p"),L.textContent=hl,Qe=a(),i(A.$$.fragment),Ye=a(),i(D.$$.fragment),He=a(),O=d("div"),O.innerHTML=bl,Ne=a(),i(K.$$.fragment),Ee=a(),i(q.$$.fragment),Pe=a(),ee=d("p"),ee.innerHTML=ul,Se=a(),i(le.$$.fragment),Le=a(),i(te.$$.fragment),Ae=a(),se=d("p"),se.innerHTML=wl,De=a(),i(ae.$$.fragment),Oe=a(),ne=d("p"),ne.innerHTML=Jl,Ke=a(),i(ie.$$.fragment),qe=a(),re=d("p"),this.h()},l(e){const l=$l("svelte-u9bgzb",document.head);b=f(l,"META",{name:!0,content:!0}),l.forEach(t),oe=n(e),pe=f(e,"P",{}),Tl(pe).forEach(t),me=n(e),p(w.$$.fragment,e),ce=n(e),J=f(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1fi3h7b"&&(J.textContent=tl),de=n(e),p(T.$$.fragment,e),fe=n(e),g=f(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-ctt0hb"&&(g.textContent=sl),Me=n(e),p(Z.$$.fragment,e),ye=n(e),j=f(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1ln7prb"&&(j.textContent=al),he=n(e),p(U.$$.fragment,e),be=n(e),W=f(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-15pg0q3"&&(W.innerHTML=nl),ue=n(e),p(B.$$.fragment,e),we=n(e),$=f(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-la5c3h"&&($.innerHTML=il),Je=n(e),p(X.$$.fragment,e),Te=n(e),_=f(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-190jsut"&&(_.textContent=pl),ge=n(e),p(k.$$.fragment,e),Ze=n(e),V=f(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-e8r4tv"&&(V.innerHTML=rl),je=n(e),p(G.$$.fragment,e),Ue=n(e),v=f(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-hhlpqt"&&(v.innerHTML=ol),We=n(e),p(C.$$.fragment,e),Be=n(e),z=f(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-lmd9ef"&&(z.innerHTML=ml),$e=n(e),p(I.$$.fragment,e),Xe=n(e),R=f(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-jl9zz3"&&(R.innerHTML=cl),_e=n(e),p(x.$$.fragment,e),ke=n(e),p(F.$$.fragment,e),Ve=n(e),Q=f(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-15h4933"&&(Q.innerHTML=dl),Ge=n(e),p(Y.$$.fragment,e),ve=n(e),H=f(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1wncfxf"&&(H.innerHTML=fl),Ce=n(e),u=f(e,"DIV",{style:!0,"data-svelte-h":!0}),M(u)!=="svelte-knha24"&&(u.innerHTML=Ml),ze=n(e),p(N.$$.fragment,e),Ie=n(e),E=f(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1tamlje"&&(E.textContent=yl),Re=n(e),p(P.$$.fragment,e),xe=n(e),p(S.$$.fragment,e),Fe=n(e),L=f(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-hswwhh"&&(L.textContent=hl),Qe=n(e),p(A.$$.fragment,e),Ye=n(e),p(D.$$.fragment,e),He=n(e),O=f(e,"DIV",{"data-svelte-h":!0}),M(O)!=="svelte-n87ems"&&(O.innerHTML=bl),Ne=n(e),p(K.$$.fragment,e),Ee=n(e),p(q.$$.fragment,e),Pe=n(e),ee=f(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-kivsgi"&&(ee.innerHTML=ul),Se=n(e),p(le.$$.fragment,e),Le=n(e),p(te.$$.fragment,e),Ae=n(e),se=f(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-12rnelm"&&(se.innerHTML=wl),De=n(e),p(ae.$$.fragment,e),Oe=n(e),ne=f(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1hdjzdk"&&(ne.innerHTML=Jl),Ke=n(e),p(ie.$$.fragment,e),qe=n(e),re=f(e,"P",{}),Tl(re).forEach(t),this.h()},h(){gl(b,"name","hf:doc:metadata"),gl(b,"content",Vl),Xl(u,"text-align","center")},m(e,l){_l(document.head,b),s(e,oe,l),s(e,pe,l),s(e,me,l),r(w,e,l),s(e,ce,l),s(e,J,l),s(e,de,l),r(T,e,l),s(e,fe,l),s(e,g,l),s(e,Me,l),r(Z,e,l),s(e,ye,l),s(e,j,l),s(e,he,l),r(U,e,l),s(e,be,l),s(e,W,l),s(e,ue,l),r(B,e,l),s(e,we,l),s(e,$,l),s(e,Je,l),r(X,e,l),s(e,Te,l),s(e,_,l),s(e,ge,l),r(k,e,l),s(e,Ze,l),s(e,V,l),s(e,je,l),r(G,e,l),s(e,Ue,l),s(e,v,l),s(e,We,l),r(C,e,l),s(e,Be,l),s(e,z,l),s(e,$e,l),r(I,e,l),s(e,Xe,l),s(e,R,l),s(e,_e,l),r(x,e,l),s(e,ke,l),r(F,e,l),s(e,Ve,l),s(e,Q,l),s(e,Ge,l),r(Y,e,l),s(e,ve,l),s(e,H,l),s(e,Ce,l),s(e,u,l),s(e,ze,l),r(N,e,l),s(e,Ie,l),s(e,E,l),s(e,Re,l),r(P,e,l),s(e,xe,l),r(S,e,l),s(e,Fe,l),s(e,L,l),s(e,Qe,l),r(A,e,l),s(e,Ye,l),r(D,e,l),s(e,He,l),s(e,O,l),s(e,Ne,l),r(K,e,l),s(e,Ee,l),r(q,e,l),s(e,Pe,l),s(e,ee,l),s(e,Se,l),r(le,e,l),s(e,Le,l),r(te,e,l),s(e,Ae,l),s(e,se,l),s(e,De,l),r(ae,e,l),s(e,Oe,l),s(e,ne,l),s(e,Ke,l),r(ie,e,l),s(e,qe,l),s(e,re,l),el=!0},p:jl,i(e){el||(o(w.$$.fragment,e),o(T.$$.fragment,e),o(Z.$$.fragment,e),o(U.$$.fragment,e),o(B.$$.fragment,e),o(X.$$.fragment,e),o(k.$$.fragment,e),o(G.$$.fragment,e),o(C.$$.fragment,e),o(I.$$.fragment,e),o(x.$$.fragment,e),o(F.$$.fragment,e),o(Y.$$.fragment,e),o(N.$$.fragment,e),o(P.$$.fragment,e),o(S.$$.fragment,e),o(A.$$.fragment,e),o(D.$$.fragment,e),o(K.$$.fragment,e),o(q.$$.fragment,e),o(le.$$.fragment,e),o(te.$$.fragment,e),o(ae.$$.fragment,e),o(ie.$$.fragment,e),el=!0)},o(e){m(w.$$.fragment,e),m(T.$$.fragment,e),m(Z.$$.fragment,e),m(U.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(k.$$.fragment,e),m(G.$$.fragment,e),m(C.$$.fragment,e),m(I.$$.fragment,e),m(x.$$.fragment,e),m(F.$$.fragment,e),m(Y.$$.fragment,e),m(N.$$.fragment,e),m(P.$$.fragment,e),m(S.$$.fragment,e),m(A.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),m(le.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),el=!1},d(e){e&&(t(oe),t(pe),t(me),t(ce),t(J),t(de),t(fe),t(g),t(Me),t(ye),t(j),t(he),t(be),t(W),t(ue),t(we),t($),t(Je),t(Te),t(_),t(ge),t(Ze),t(V),t(je),t(Ue),t(v),t(We),t(Be),t(z),t($e),t(Xe),t(R),t(_e),t(ke),t(Ve),t(Q),t(Ge),t(ve),t(H),t(Ce),t(u),t(ze),t(Ie),t(E),t(Re),t(xe),t(Fe),t(L),t(Qe),t(Ye),t(He),t(O),t(Ne),t(Ee),t(Pe),t(ee),t(Se),t(Le),t(Ae),t(se),t(De),t(Oe),t(ne),t(Ke),t(qe),t(re)),t(b),c(w,e),c(T,e),c(Z,e),c(U,e),c(B,e),c(X,e),c(k,e),c(G,e),c(C,e),c(I,e),c(x,e),c(F,e),c(Y,e),c(N,e),c(P,e),c(S,e),c(A,e),c(D,e),c(K,e),c(q,e),c(le,e),c(te,e),c(ae,e),c(ie,e)}}}const Vl='{"title":"Training customization","local":"training-customization","sections":[{"title":"Train on multiple GPUs / nodes","local":"train-on-multiple-gpus--nodes","sections":[{"title":"Distributed training with DeepSpeed","local":"distributed-training-with-deepspeed","sections":[],"depth":3}],"depth":2},{"title":"Use different optimizers","local":"use-different-optimizers","sections":[{"title":"Use LION optimizer","local":"use-lion-optimizer","sections":[],"depth":3}],"depth":2},{"title":"Add a learning rate scheduler","local":"add-a-learning-rate-scheduler","sections":[],"depth":2},{"title":"Memory efficient fine-tuning by sharing layers","local":"memory-efficient-fine-tuning-by-sharing-layers","sections":[],"depth":2},{"title":"Pass 8-bit reference models","local":"pass-8-bit-reference-models","sections":[],"depth":2},{"title":"Use the CUDA cache optimizer","local":"use-the-cuda-cache-optimizer","sections":[],"depth":2},{"title":"Use score scaling/normalization/clipping","local":"use-score-scalingnormalizationclipping","sections":[],"depth":2}],"depth":1}';function Gl(ll){return Ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends Wl{constructor(b){super(),Bl(this,b,Gl,kl,Zl,{})}}export{Rl as component};
