import{s as Hn,n as Ln,o as Yn}from"../chunks/scheduler.9039eef2.js";import{S as Dn,i as Pn,g as o,s as n,r as p,A as On,h as i,f as a,c as l,j as $s,u as c,x as r,k as Gs,l as Wn,y as ke,a as s,v as d,d as u,t as m,w as h}from"../chunks/index.ded8f90d.js";import{D as An}from"../chunks/Docstring.a2ba2b54.js";import{C as M}from"../chunks/CodeBlock.8580f3e8.js";import{H as y}from"../chunks/Heading.f027f30d.js";function Kn(qs){let f,_e,Je,Ce,w,Ie,J,Bs="Supervised fine-tuning (or SFT for short) is a crucial step in RLHF. In TRL we provide an easy-to-use API to create your SFT models and train them with few lines of code on your dataset.",ve,b,zs='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft.py" rel="nofollow"><code>examples/scripts/sft.py</code></a>.',xe,k,Fe,_,Qs=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,$e,C,Ge,I,Xs="Make sure to pass a correct value for <code>max_seq_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",Ze,v,Es="You can also construct a model outside of the trainer and pass it as follows:",Re,x,qe,F,Ss='The above snippets will use the default training arguments from the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow"><code>transformers.TrainingArguments</code></a> class. If you want to modify that, make sure to create your own <code>TrainingArguments</code> object and pass it to the <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor as it is done on the <a href="https://github.com/huggingface/trl/blob/main/examples/stack_llama/scripts/supervised_finetuning.py" rel="nofollow"><code>supervised_finetuning.py</code> script</a> on the stack-llama example.',Be,$,ze,G,Qe,Z,Ns=`You can use the <code>DataCollatorForCompletionOnlyLM</code> to train your model on the generated prompts only. Note that this works only in the case when <code>packing=False</code>.
To instantiate that collator for instruction data, pass a response template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on completions only on the CodeAlpaca dataset:`,Xe,R,Ee,q,Vs="To instantiate that collator for assistant style conversation data, pass a response template, an instruction template and the tokenizer. Here is an example of how it would work to fine-tune <code>opt-350m</code> on assistant completions only on the Open Assistant Guanaco dataset:",Se,B,Ne,z,Ws="Make sure to have a <code>pad_token_id</code> which is different from <code>eos_token_id</code> which can result in the model not properly predicting EOS (End of Sentence) tokens during generation.",Ve,Q,We,X,As="Some tokenizers like Llama 2 (<code>meta-llama/Llama-2-XXb-hf</code>) tokenize sequences differently depending whether they have context or not. For example:",Ae,E,He,S,Hs="In this case, and due to lack of context in <code>response_template</code>, the same string (”### Assistant:”) is tokenized differently:",Le,N,Ls="<li>Text (with context): <code>[2277, 29937, 4007, 22137, 29901]</code></li> <li><code>response_template</code> (without context): <code>[835, 4007, 22137, 29901]</code></li>",Ye,V,Ys="This will lead to an error when the <code>DataCollatorForCompletionOnlyLM</code> does not find the <code>response_template</code> in the dataset example text:",De,W,Pe,A,Ds="To solve this, you can tokenize the <code>response_template</code> with the same context than in the dataset, truncate it as needed and pass the <code>token_ids</code> directly to the <code>response_template</code> argument of the <code>DataCollatorForCompletionOnlyLM</code> class. For example:",Oe,H,Ke,L,ta,Y,Ps=`Adding special tokens to a language model is crucial for training chat models. These tokens are added between the different roles in a conversation, such as the user, assistant, and system and help the model recognize the structure and flow of a conversation. This setup is essential for enabling the model to generate coherent and contextually appropriate responses in a chat environment.
The <code>setup_chat_format()</code> function in <code>trl</code> easily sets up a model and tokenizer for conversational AI tasks. This function:`,ea,D,Os='<li>Adds special tokens to the tokenizer, e.g. <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>, to indicate the start and end of a conversation.</li> <li>Resizes the model’s embedding layer to accommodate the new tokens.</li> <li>Sets the <code>chat_template</code> of the tokenizer, which is used to format the input data into a chat-like format. The default is <code>chatml</code> from OpenAI.</li> <li><em>optionally</em> you can pass <code>resize_to_multiple_of</code> to resize the embedding layer to a multiple of the <code>resize_to_multiple_of</code> argument, e.g. 64. If you want to see more formats being supported in the future, please open a GitHub issue on <a href="https://github.com/huggingface/trl" rel="nofollow">trl</a></li>',aa,P,sa,O,Ks="With our model and tokenizer set up, we can now fine-tune our model on a conversational dataset. Below is an example of how a dataset can be formatted for fine-tuning.",na,K,la,tt,tn='The <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',oa,et,en="<li>conversational format</li>",ia,at,ra,st,an="<li>instruction format</li>",pa,nt,ca,lt,sn='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',da,ot,ua,it,nn="If the dataset is not in one those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",ma,rt,ha,pt,ln=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,Ma,ct,ya,dt,on="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",fa,ut,Ta,mt,rn='To preperly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example on how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',ga,ht,Ua,Mt,pn='<a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. This is done with the <code>ConstantLengthDataset</code> utility class that returns constant length chunks of tokens from a stream of examples. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor.',ja,yt,wa,ft,cn="Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.",Ja,Tt,ba,gt,dn="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",ka,Ut,_a,jt,un='You can also customize the <code>ConstantLengthDataset</code> much more by directly passing the arguments to the <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a> constructor. Please refer to that class’ signature for more information.',Ca,wt,Ia,Jt,mn='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a>. For example, if you want to load a model in a different precision, analogous to',va,bt,xa,kt,Fa,_t,hn="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",$a,Ct,Ga,It,Mn="We also support a tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model",Za,vt,Ra,xt,yn="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",qa,Ft,Ba,$t,fn="For that you need to first load your 8bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",za,Gt,Qa,Zt,Xa,Rt,Tn=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,Ea,qt,Sa,Bt,gn=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Na,zt,Va,Qt,Un="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",Wa,Xt,Aa,Et,jn="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",Ha,St,La,Nt,wn="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",Ya,Vt,Jn="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",Da,Wt,bn="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>x</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",Pa,At,Oa,Ht,kn="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",Ka,Lt,ts,Yt,_n="And add <code>use_flash_attention_2=True</code> when calling <code>from_pretrained</code>:",es,Dt,as,Pt,Cn=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,ss,Ot,In="In contrary to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",ns,Kt,ls,te,vn='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',os,ee,xn="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",is,U,Fn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',rs,ae,$n="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTTrainer</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",ps,se,cs,ne,Gn='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',ds,j,Zn='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/trl-neftune-mistral-7b.png"/>',us,le,Rn='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',ms,oe,hs,ie,qn='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',Ms,re,Bn="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",ys,pe,zn='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',fs,ce,Ts,de,Qn='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',gs,ue,Us,me,Xn="Pay attention to the following best practices when training a model with that trainer:",js,he,En='<li><a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a> always pads by default the sequences to the <code>max_seq_length</code> argument of the <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide default value, so there is a check to retrieve the minimum between 2048 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/v0.7.10/en/trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',ws,Me,Js,ye,Sn="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",bs,fe,ks,T,Te,Zs,je,Nn=`Class definition of the Supervised Finetuning Trainer (SFT Trainer).
This class is a wrapper around the <code>transformers.Trainer</code> class and inherits all of its attributes and methods.
The trainer takes care of properly initializing the PeftModel in case a user passes a <code>PeftConfig</code> object.`,_s,ge,Cs,g,Ue,Rs,we,Vn=`Iterable dataset that returns constant length chunks of tokens from stream of text files.
The dataset also formats the text before tokenization with a specific format that is provided
by the user.`,Is,be,vs;return w=new y({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),k=new y({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),C=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)
trainer.train()`,wrap:!1}}),x=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
)

trainer.train()`,wrap:!1}}),$=new y({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),G=new y({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),R=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybHVjYXNtY2NhYmUtbG1pJTJGQ29kZUFscGFjYS0yMGslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFkZWYlMjBmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyhleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dF90ZXh0cyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGxlbihleGFtcGxlJTVCJ2luc3RydWN0aW9uJyU1RCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUInaW5zdHJ1Y3Rpb24nJTVEJTVCaSU1RCU3RCU1Q24lMjAlMjMlMjMlMjMlMjBBbnN3ZXIlM0ElMjAlN0JleGFtcGxlJTVCJ291dHB1dCclNUQlNUJpJTVEJTdEJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RleHRzLmFwcGVuZCh0ZXh0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZXh0cyUwQSUwQXJlc3BvbnNlX3RlbXBsYXRlJTIwJTNEJTIwJTIyJTIwJTIzJTIzJTIzJTIwQW5zd2VyJTNBJTIyJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JDb21wbGV0aW9uT25seUxNKHJlc3BvbnNlX3RlbXBsYXRlJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBmb3JtYXR0aW5nX2Z1bmMlM0Rmb3JtYXR0aW5nX3Byb21wdHNfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;lucasmccabe-lmi/CodeAlpaca-20k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;instruction&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;instruction&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;output&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

response_template = <span class="hljs-string">&quot; ### Answer:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(response_template, tokenizer=tokenizer)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),B=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBTRlRUcmFpbmVyJTJDJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydGltZGV0dG1lcnMlMkZvcGVuYXNzaXN0YW50LWd1YW5hY28lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEFpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEh1bWFuJTNBJTIyJTBBcmVzcG9uc2VfdGVtcGxhdGUlMjAlM0QlMjAlMjIlMjMlMjMlMjMlMjBBc3Npc3RhbnQlM0ElMjIlMEFjb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvckNvbXBsZXRpb25Pbmx5TE0oaW5zdHJ1Y3Rpb25fdGVtcGxhdGUlM0RpbnN0cnVjdGlvbl90ZW1wbGF0ZSUyQyUyMHJlc3BvbnNlX3RlbXBsYXRlJTNEcmVzcG9uc2VfdGVtcGxhdGUlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSklMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, DataCollatorForCompletionOnlyLM

dataset = load_dataset(<span class="hljs-string">&quot;timdettmers/openassistant-guanaco&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

instruction_template = <span class="hljs-string">&quot;### Human:&quot;</span>
response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
collator = DataCollatorForCompletionOnlyLM(instruction_template=instruction_template, response_template=response_template, tokenizer=tokenizer, mlm=<span class="hljs-literal">False</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    data_collator=collator,
)

trainer.train()`,wrap:!1}}),Q=new y({props:{title:"Using token_ids directly for response_template",local:"using-tokenids-directly-for-responsetemplate",headingTag:"h4"}}),E=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1oZiUyMiklMEElMEFkZWYlMjBwcmludF90b2tlbnNfd2l0aF9pZHModHh0KSUzQSUwQSUyMCUyMCUyMCUyMHRva2VucyUyMCUzRCUyMHRva2VuaXplci50b2tlbml6ZSh0eHQlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSklMEElMjAlMjAlMjAlMjB0b2tlbl9pZHMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKHR4dCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMHByaW50KGxpc3QoemlwKHRva2VucyUyQyUyMHRva2VuX2lkcykpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUyMyUyMyUyMyUyMFVzZXIlM0ElMjBIZWxsbyU1Q24lNUNuJTIzJTIzJTIzJTIwQXNzaXN0YW50JTNBJTIwSGklMkMlMjBob3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUzRiUyMiUyMiUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhwcm9tcHQpJTIwJTIwJTIzJTIwJTVCLi4uJTJDJTIwKCclRTIlOTYlODFIZWxsbyclMkMlMjAxNTA0MyklMkMlMjAoJyUzQzB4MEElM0UnJTJDJTIwMTMpJTJDJTIwKCclM0MweDBBJTNFJyUyQyUyMDEzKSUyQyUyMCgnJTIzJTIzJyUyQyUyMDIyNzcpJTJDJTIwKCclMjMnJTJDJTIwMjk5MzcpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklMkMlMjAuLi4lNUQlMEElMEFyZXNwb25zZV90ZW1wbGF0ZSUyMCUzRCUyMCUyMiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUwQXByaW50X3Rva2Vuc193aXRoX2lkcyhyZXNwb25zZV90ZW1wbGF0ZSklMjAlMjAlMjMlMjAlNUIoJyVFMiU5NiU4MSUyMyUyMyUyMyclMkMlMjA4MzUpJTJDJTIwKCclRTIlOTYlODFBc3MnJTJDJTIwNDAwNyklMkMlMjAoJ2lzdGFudCclMkMlMjAyMjEzNyklMkMlMjAoJyUzQSclMkMlMjAyOTkwMSklNUQ=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-hf&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_tokens_with_ids</span>(<span class="hljs-params">txt</span>):
    tokens = tokenizer.tokenize(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    token_ids = tokenizer.encode(txt, add_special_tokens=<span class="hljs-literal">False</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(<span class="hljs-built_in">zip</span>(tokens, token_ids)))

prompt = <span class="hljs-string">&quot;&quot;&quot;### User: Hello\\n\\n### Assistant: Hi, how can I help you?&quot;&quot;&quot;</span>
print_tokens_with_ids(prompt)  <span class="hljs-comment"># [..., (&#x27;▁Hello&#x27;, 15043), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;&lt;0x0A&gt;&#x27;, 13), (&#x27;##&#x27;, 2277), (&#x27;#&#x27;, 29937), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901), ...]</span>

response_template = <span class="hljs-string">&quot;### Assistant:&quot;</span>
print_tokens_with_ids(response_template)  <span class="hljs-comment"># [(&#x27;▁###&#x27;, 835), (&#x27;▁Ass&#x27;, 4007), (&#x27;istant&#x27;, 22137), (&#x27;:&#x27;, 29901)]</span>`,wrap:!1}}),W=new M({props:{code:"UnVudGltZUVycm9yJTNBJTIwQ291bGQlMjBub3QlMjBmaW5kJTIwcmVzcG9uc2UlMjBrZXklMjAlNUI4MzUlMkMlMjA0MDA3JTJDJTIwMjIxMzclMkMlMjAyOTkwMSU1RCUyMGluJTIwdG9rZW4lMjBJRHMlMjB0ZW5zb3IoJTVCJTIwJTIwJTIwJTIwMSUyQyUyMCUyMCUyMDgzNSUyQyUyMCUyMC4uLiU1RCk=",highlighted:'RuntimeError: Could not find response key <span class="hljs-selector-attr">[835, 4007, 22137, 29901]</span> <span class="hljs-keyword">in</span> token IDs <span class="hljs-built_in">tensor</span>(<span class="hljs-selector-attr">[    1,   835,  ...]</span>)',wrap:!1}}),H=new M({props:{code:"cmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTIwJTNEJTIwJTIyJTVDbiUyMyUyMyUyMyUyMEFzc2lzdGFudCUzQSUyMiUyMCUyMCUyMyUyMFdlJTIwYWRkZWQlMjBjb250ZXh0JTIwaGVyZSUzQSUyMCUyMiU1Q24lMjIuJTIwVGhpcyUyMGlzJTIwZW5vdWdoJTIwZm9yJTIwdGhpcyUyMHRva2VuaXplciUwQXJlc3BvbnNlX3RlbXBsYXRlX2lkcyUyMCUzRCUyMHRva2VuaXplci5lbmNvZGUocmVzcG9uc2VfdGVtcGxhdGVfd2l0aF9jb250ZXh0JTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpJTVCMiUzQSU1RCUyMCUyMCUyMyUyME5vdyUyMHdlJTIwaGF2ZSUyMGl0JTIwbGlrZSUyMGluJTIwdGhlJTIwZGF0YXNldCUyMHRleHRzJTNBJTIwJTYwJTVCMjI3NyUyQyUyMDI5OTM3JTJDJTIwNDAwNyUyQyUyMDIyMTM3JTJDJTIwMjk5MDElNUQlNjAlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGF0YUNvbGxhdG9yRm9yQ29tcGxldGlvbk9ubHlMTShyZXNwb25zZV90ZW1wbGF0ZV9pZHMlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`response_template_with_context = <span class="hljs-string">&quot;\\n### Assistant:&quot;</span>  <span class="hljs-comment"># We added context here: &quot;\\n&quot;. This is enough for this tokenizer</span>
response_template_ids = tokenizer.encode(response_template_with_context, add_special_tokens=<span class="hljs-literal">False</span>)[<span class="hljs-number">2</span>:]  <span class="hljs-comment"># Now we have it like in the dataset texts: \`[2277, 29937, 4007, 22137, 29901]\`</span>

data_collator = DataCollatorForCompletionOnlyLM(response_template_ids, tokenizer=tokenizer)`,wrap:!1}}),L=new y({props:{title:"Add Special Tokens for Chat Format",local:"add-special-tokens-for-chat-format",headingTag:"h3"}}),P=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMjB3aXRoJTIwZGVmYXVsdCUyMCdjaGF0bWwnJTIwZm9ybWF0JTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUyQyUyMHRva2VuaXplciklMEE=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-comment"># Set up the chat format with default &#x27;chatml&#x27; format</span>
model, tokenizer = setup_chat_format(model, tokenizer)
`,wrap:!1}}),K=new y({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),at=new M({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),nt=new M({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),ot=new M({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=training_args,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),rt=new y({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),ct=new M({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),ut=new M({props:{code:"JTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    output_texts = []
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(example[<span class="hljs-string">&#x27;question&#x27;</span>])):
        text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>][i]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>][i]}</span>&quot;</span>
        output_texts.append(text)
    <span class="hljs-keyword">return</span> output_texts

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    formatting_func=formatting_prompts_func,
)

trainer.train()`,wrap:!1}}),ht=new y({props:{title:"Packing dataset ( ConstantLengthDataset )",local:"packing-dataset--constantlengthdataset-",headingTag:"h3"}}),yt=new M({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    packing=<span class="hljs-literal">True</span>
)

trainer.train()`,wrap:!1}}),Tt=new y({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),Ut=new M({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwYWNraW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGZvcm1hdHRpbmdfZnVuYyUzRGZvcm1hdHRpbmdfZnVuYyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    packing=<span class="hljs-literal">True</span>,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),wt=new y({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),bt=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYp",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)',wrap:!1}}),kt=new M({props:{code:"JTBB",highlighted:`...

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: torch.bfloat16,
    },
)

trainer.train()`,wrap:!1}}),Ct=new y({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),vt=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjA1JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyRWxldXRoZXJBSSUyRmdwdC1uZW8tMTI1bSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZGF0YXNldF90ZXh0X2ZpZWxkJTNEJTIydGV4dCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlZnRfY29uZmlnJTNEcGVmdF9jb25maWclMEEpJTBBJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),Ft=new y({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),Gt=new M({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Zt=new y({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),qt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),zt=new y({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Xt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),St=new M({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),At=new y({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Lt=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),Dt=new M({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2ZsYXNoX2F0dGVudGlvbl8yJTNEVHJ1ZSUwQSk=",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Kt=new y({props:{title:"Enhance model’s performances using NEFTune",local:"enhance-models-performances-using-neftune",headingTag:"h3"}}),se=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmltZGIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFzZXRfdGV4dF9maWVsZCUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMG5lZnR1bmVfbm9pc2VfYWxwaGElM0Q1JTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    dataset_text_field=<span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length=<span class="hljs-number">512</span>,
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer.train()`,wrap:!1}}),oe=new y({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),ce=new M({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_seq_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name = <span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length = max_seq_length,
    dtype = <span class="hljs-literal">None</span>, <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit = <span class="hljs-literal">True</span>, <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r = <span class="hljs-number">16</span>,
    target_modules = [<span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;k_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>, <span class="hljs-string">&quot;o_proj&quot;</span>,
                      <span class="hljs-string">&quot;gate_proj&quot;</span>, <span class="hljs-string">&quot;up_proj&quot;</span>, <span class="hljs-string">&quot;down_proj&quot;</span>,],
    lora_alpha = <span class="hljs-number">16</span>,
    lora_dropout = <span class="hljs-number">0</span>, <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias = <span class="hljs-string">&quot;none&quot;</span>,    <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing = <span class="hljs-literal">True</span>,
    random_state = <span class="hljs-number">3407</span>,
)

args = TrainingArguments(output_dir = <span class="hljs-string">&quot;./output&quot;</span>)

trainer = SFTTrainer(
    model = model,
    args = args,
    train_dataset = dataset,
    dataset_text_field = <span class="hljs-string">&quot;text&quot;</span>,
    max_seq_length = max_seq_length,
)
trainer.train()`,wrap:!1}}),ue=new y({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),Me=new y({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),fe=new y({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),Te=new An({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": TrainingArguments = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"dataset_text_field",val:": Optional = None"},{name:"packing",val:": Optional = False"},{name:"formatting_func",val:": Optional = None"},{name:"max_seq_length",val:": Optional = None"},{name:"infinite",val:": Optional = None"},{name:"num_of_sequences",val:": Optional = 1024"},{name:"chars_per_token",val:": Optional = 3.6"},{name:"dataset_num_proc",val:": Optional = None"},{name:"dataset_batch_size",val:": int = 1000"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (Union[<code>transformers.PreTrainedModel</code>, <code>nn.Module</code>, <code>str</code>]) &#x2014;
The model to train, can be a <code>PreTrainedModel</code>, a <code>torch.nn.Module</code> or a string with the model name to
load from cache or download. The model can be also converted to a <code>PeftModel</code> if a <code>PeftConfig</code> object is
passed to the <code>peft_config</code> argument.`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (Optional<a href="https://huggingface.co/docs/transformers/v4.36.2/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">transformers.TrainingArguments</a>) &#x2014;
The arguments to tweak for training. Please refer to the official documentation of <code>transformers.TrainingArguments</code>
for more information.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (Optional<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (Optional<a href="https://huggingface.co/docs/datasets/v2.16.1/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">datasets.Dataset</a>) &#x2014;
The dataset to use for training. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (Optional[Union[<code>datasets.Dataset</code>, Dict[<code>str</code>, <code>datasets.Dataset</code>]]]) &#x2014;
The dataset to use for evaluation. We recommend users to use <code>trl.trainer.ConstantLengthDataset</code> to create their dataset.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.tokenizer",description:`<strong>tokenizer</strong> (Optional<a href="https://huggingface.co/docs/transformers/v4.36.2/en/main_classes/tokenizer#transformers.PreTrainedTokenizer" rel="nofollow">transformers.PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for training. If not specified, the tokenizer associated to the model will be used.`,name:"tokenizer"},{anchor:"trl.SFTTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.SFTTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[transformers.EvalPrediction], Dict]</code>, <em>optional</em> defaults to None) &#x2014;
The function used to compute metrics during evaluation. It should return a dictionary mapping metric names to metric values.
If not specified, only the loss will be computed during evaluation.`,name:"compute_metrics"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Optional[PeftConfig]</code>) &#x2014;
The PeftConfig object to use to initialize the PeftModel.`,name:"peft_config"},{anchor:"trl.SFTTrainer.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>Optional[str]</code>) &#x2014;
The name of the text field of the dataset, in case this is passed by a user, the trainer will automatically create a
<code>ConstantLengthDataset</code> based on the <code>dataset_text_field</code> argument.`,name:"dataset_text_field"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
The formatting function to be used for creating the <code>ConstantLengthDataset</code>.`,name:"formatting_func"},{anchor:"trl.SFTTrainer.max_seq_length",description:`<strong>max_seq_length</strong> (<code>Optional[int]</code>) &#x2014;
The maximum sequence length to use for the <code>ConstantLengthDataset</code> and for automatically creating the Dataset. Defaults to <code>512</code>.`,name:"max_seq_length"},{anchor:"trl.SFTTrainer.infinite",description:`<strong>infinite</strong> (<code>Optional[bool]</code>) &#x2014;
Whether to use an infinite dataset or not. Defaults to <code>False</code>.`,name:"infinite"},{anchor:"trl.SFTTrainer.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>Optional[int]</code>) &#x2014;
The number of sequences to use for the <code>ConstantLengthDataset</code>. Defaults to <code>1024</code>.`,name:"num_of_sequences"},{anchor:"trl.SFTTrainer.chars_per_token",description:`<strong>chars_per_token</strong> (<code>Optional[float]</code>) &#x2014;
The number of characters per token to use for the <code>ConstantLengthDataset</code>. Defaults to <code>3.6</code>. You can check how this is computed in the
stack-llama example: <a href="https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53" rel="nofollow">https://github.com/huggingface/trl/blob/08f550674c553c36c51d1027613c29f14f3676a5/examples/stack_llama/scripts/supervised_finetuning.py#L53</a>.`,name:"chars_per_token"},{anchor:"trl.SFTTrainer.packing",description:`<strong>packing</strong> (<code>Optional[bool]</code>) &#x2014;
Used only in case <code>dataset_text_field</code> is passed. This argument is used by the <code>ConstantLengthDataset</code> to pack the sequences
of the dataset.`,name:"packing"},{anchor:"trl.SFTTrainer.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>) &#x2014;
The number of workers to use to tokenize the data. Only used when <code>packing=False</code>. Defaults to None.`,name:"dataset_num_proc"},{anchor:"trl.SFTTrainer.dataset_batch_size",description:`<strong>dataset_batch_size</strong> (<code>int</code>) &#x2014;
The number of examples to tokenize per batch. If batch_size &lt;= 0 or batch_size == None,
tokenize the full dataset as a single batch. Defaults to 1000.`,name:"dataset_batch_size"},{anchor:"trl.SFTTrainer.neftune_noise_alpha",description:`<strong>neftune_noise_alpha</strong> (<code>Optional[float]</code>) &#x2014;
If not <code>None</code>, this will activate NEFTune noise embeddings. This has been proven to drastically improve model performances for instruction
fine-tuning. Check out the original paper here: <a href="https://arxiv.org/abs/2310.05914" rel="nofollow">https://arxiv.org/abs/2310.05914</a> and the original code here: <a href="https://github.com/neelsjain/NEFTune" rel="nofollow">https://github.com/neelsjain/NEFTune</a>
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string
dataset_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when creating packed or non-packed datasets`,name:"neftune_noise_alpha"}],source:"https://github.com/huggingface/trl/blob/v0.7.10/trl/trainer/sft_trainer.py#L54"}}),ge=new y({props:{title:"ConstantLengthDataset",local:"trl.trainer.ConstantLengthDataset",headingTag:"h2"}}),Ue=new An({props:{name:"class trl.trainer.ConstantLengthDataset",anchor:"trl.trainer.ConstantLengthDataset",parameters:[{name:"tokenizer",val:""},{name:"dataset",val:""},{name:"dataset_text_field",val:" = None"},{name:"formatting_func",val:" = None"},{name:"infinite",val:" = False"},{name:"seq_length",val:" = 1024"},{name:"num_of_sequences",val:" = 1024"},{name:"chars_per_token",val:" = 3.6"},{name:"eos_token_id",val:" = 0"},{name:"shuffle",val:" = True"},{name:"append_concat_token",val:" = True"},{name:"add_special_tokens",val:" = True"}],parametersDescription:[{anchor:"trl.trainer.ConstantLengthDataset.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizer</code>) &#x2014;
The processor used for processing the data.`,name:"tokenizer"},{anchor:"trl.trainer.ConstantLengthDataset.dataset",description:`<strong>dataset</strong> (<code>dataset.Dataset</code>) &#x2014;
Dataset with text files.`,name:"dataset"},{anchor:"trl.trainer.ConstantLengthDataset.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <strong>optional</strong>) &#x2014;
Name of the field in the dataset that contains the text. Used only if <code>formatting_func</code> is <code>None</code>.`,name:"dataset_text_field"},{anchor:"trl.trainer.ConstantLengthDataset.formatting_func",description:`<strong>formatting_func</strong> (<code>Callable</code>, <strong>optional</strong>) &#x2014;
Function that formats the text before tokenization. Usually it is recommended to have follows a certain
pattern such as <code>&quot;### Question: {question} ### Answer: {answer}&quot;</code>`,name:"formatting_func"},{anchor:"trl.trainer.ConstantLengthDataset.infinite",description:`<strong>infinite</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True the iterator is reset after dataset reaches end else stops.`,name:"infinite"},{anchor:"trl.trainer.ConstantLengthDataset.seq_length",description:`<strong>seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Length of token sequences to return.`,name:"seq_length"},{anchor:"trl.trainer.ConstantLengthDataset.num_of_sequences",description:`<strong>num_of_sequences</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of token sequences to keep in buffer.`,name:"num_of_sequences"},{anchor:"trl.trainer.ConstantLengthDataset.chars_per_token",description:`<strong>chars_per_token</strong> (<code>int</code>, <em>optional</em>, defaults to <code>3.6</code>) &#x2014;
Number of characters per token used to estimate number of tokens in text buffer.`,name:"chars_per_token"},{anchor:"trl.trainer.ConstantLengthDataset.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>0</code>) &#x2014;
Id of the end of sequence token if the passed tokenizer does not have an EOS token.`,name:"eos_token_id"},{anchor:"trl.trainer.ConstantLengthDataset.shuffle",description:`<strong>shuffle</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
Shuffle the examples before they are returned`,name:"shuffle"},{anchor:"trl.trainer.ConstantLengthDataset.append_concat_token",description:`<strong>append_concat_token</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, appends <code>eos_token_id</code> at the end of each sample being packed.`,name:"append_concat_token"},{anchor:"trl.trainer.ConstantLengthDataset.add_special_tokens",description:`<strong>add_special_tokens</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to True) &#x2014;
If true, tokenizers adds special tokens to each sample being packed.`,name:"add_special_tokens"}],source:"https://github.com/huggingface/trl/blob/v0.7.10/trl/trainer/utils.py#L355"}}),{c(){f=o("meta"),_e=n(),Je=o("p"),Ce=n(),p(w.$$.fragment),Ie=n(),J=o("p"),J.textContent=Bs,ve=n(),b=o("p"),b.innerHTML=zs,xe=n(),p(k.$$.fragment),Fe=n(),_=o("p"),_.innerHTML=Qs,$e=n(),p(C.$$.fragment),Ge=n(),I=o("p"),I.innerHTML=Xs,Ze=n(),v=o("p"),v.textContent=Es,Re=n(),p(x.$$.fragment),qe=n(),F=o("p"),F.innerHTML=Ss,Be=n(),p($.$$.fragment),ze=n(),p(G.$$.fragment),Qe=n(),Z=o("p"),Z.innerHTML=Ns,Xe=n(),p(R.$$.fragment),Ee=n(),q=o("p"),q.innerHTML=Vs,Se=n(),p(B.$$.fragment),Ne=n(),z=o("p"),z.innerHTML=Ws,Ve=n(),p(Q.$$.fragment),We=n(),X=o("p"),X.innerHTML=As,Ae=n(),p(E.$$.fragment),He=n(),S=o("p"),S.innerHTML=Hs,Le=n(),N=o("ul"),N.innerHTML=Ls,Ye=n(),V=o("p"),V.innerHTML=Ys,De=n(),p(W.$$.fragment),Pe=n(),A=o("p"),A.innerHTML=Ds,Oe=n(),p(H.$$.fragment),Ke=n(),p(L.$$.fragment),ta=n(),Y=o("p"),Y.innerHTML=Ps,ea=n(),D=o("ul"),D.innerHTML=Os,aa=n(),p(P.$$.fragment),sa=n(),O=o("p"),O.textContent=Ks,na=n(),p(K.$$.fragment),la=n(),tt=o("p"),tt.innerHTML=tn,oa=n(),et=o("ul"),et.innerHTML=en,ia=n(),p(at.$$.fragment),ra=n(),st=o("ul"),st.innerHTML=an,pa=n(),p(nt.$$.fragment),ca=n(),lt=o("p"),lt.innerHTML=sn,da=n(),p(ot.$$.fragment),ua=n(),it=o("p"),it.textContent=nn,ma=n(),p(rt.$$.fragment),ha=n(),pt=o("p"),pt.innerHTML=ln,Ma=n(),p(ct.$$.fragment),ya=n(),dt=o("p"),dt.innerHTML=on,fa=n(),p(ut.$$.fragment),Ta=n(),mt=o("p"),mt.innerHTML=rn,ga=n(),p(ht.$$.fragment),Ua=n(),Mt=o("p"),Mt.innerHTML=pn,ja=n(),p(yt.$$.fragment),wa=n(),ft=o("p"),ft.innerHTML=cn,Ja=n(),p(Tt.$$.fragment),ba=n(),gt=o("p"),gt.innerHTML=dn,ka=n(),p(Ut.$$.fragment),_a=n(),jt=o("p"),jt.innerHTML=un,Ca=n(),p(wt.$$.fragment),Ia=n(),Jt=o("p"),Jt.innerHTML=mn,va=n(),p(bt.$$.fragment),xa=n(),p(kt.$$.fragment),Fa=n(),_t=o("p"),_t.innerHTML=hn,$a=n(),p(Ct.$$.fragment),Ga=n(),It=o("p"),It.textContent=Mn,Za=n(),p(vt.$$.fragment),Ra=n(),xt=o("p"),xt.innerHTML=yn,qa=n(),p(Ft.$$.fragment),Ba=n(),$t=o("p"),$t.innerHTML=fn,za=n(),p(Gt.$$.fragment),Qa=n(),p(Zt.$$.fragment),Xa=n(),Rt=o("p"),Rt.textContent=Tn,Ea=n(),p(qt.$$.fragment),Sa=n(),Bt=o("p"),Bt.textContent=gn,Na=n(),p(zt.$$.fragment),Va=n(),Qt=o("p"),Qt.innerHTML=Un,Wa=n(),p(Xt.$$.fragment),Aa=n(),Et=o("p"),Et.innerHTML=jn,Ha=n(),p(St.$$.fragment),La=n(),Nt=o("p"),Nt.innerHTML=wn,Ya=n(),Vt=o("p"),Vt.textContent=Jn,Da=n(),Wt=o("table"),Wt.innerHTML=bn,Pa=n(),p(At.$$.fragment),Oa=n(),Ht=o("p"),Ht.innerHTML=kn,Ka=n(),p(Lt.$$.fragment),ts=n(),Yt=o("p"),Yt.innerHTML=_n,es=n(),p(Dt.$$.fragment),as=n(),Pt=o("p"),Pt.textContent=Cn,ss=n(),Ot=o("p"),Ot.textContent=In,ns=n(),p(Kt.$$.fragment),ls=n(),te=o("p"),te.innerHTML=vn,os=n(),ee=o("blockquote"),ee.innerHTML=xn,is=n(),U=o("div"),U.innerHTML=Fn,rs=n(),ae=o("p"),ae.innerHTML=$n,ps=n(),p(se.$$.fragment),cs=n(),ne=o("p"),ne.innerHTML=Gn,ds=n(),j=o("div"),j.innerHTML=Zn,us=n(),le=o("p"),le.innerHTML=Rn,ms=n(),p(oe.$$.fragment),hs=n(),ie=o("p"),ie.innerHTML=qn,Ms=n(),re=o("table"),re.innerHTML=Bn,ys=n(),pe=o("p"),pe.innerHTML=zn,fs=n(),p(ce.$$.fragment),Ts=n(),de=o("p"),de.innerHTML=Qn,gs=n(),p(ue.$$.fragment),Us=n(),me=o("p"),me.textContent=Xn,js=n(),he=o("ul"),he.innerHTML=En,ws=n(),p(Me.$$.fragment),Js=n(),ye=o("p"),ye.innerHTML=Sn,bs=n(),p(fe.$$.fragment),ks=n(),T=o("div"),p(Te.$$.fragment),Zs=n(),je=o("p"),je.innerHTML=Nn,_s=n(),p(ge.$$.fragment),Cs=n(),g=o("div"),p(Ue.$$.fragment),Rs=n(),we=o("p"),we.textContent=Vn,Is=n(),be=o("p"),this.h()},l(t){const e=On("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(a),_e=l(t),Je=i(t,"P",{}),$s(Je).forEach(a),Ce=l(t),c(w.$$.fragment,t),Ie=l(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-o839x3"&&(J.textContent=Bs),ve=l(t),b=i(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-exgkch"&&(b.innerHTML=zs),xe=l(t),c(k.$$.fragment,t),Fe=l(t),_=i(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-17ht9rx"&&(_.innerHTML=Qs),$e=l(t),c(C.$$.fragment,t),Ge=l(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1gbidw"&&(I.innerHTML=Xs),Ze=l(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-ulikv8"&&(v.textContent=Es),Re=l(t),c(x.$$.fragment,t),qe=l(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1qb4jgm"&&(F.innerHTML=Ss),Be=l(t),c($.$$.fragment,t),ze=l(t),c(G.$$.fragment,t),Qe=l(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-13sbeoj"&&(Z.innerHTML=Ns),Xe=l(t),c(R.$$.fragment,t),Ee=l(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1a743rp"&&(q.innerHTML=Vs),Se=l(t),c(B.$$.fragment,t),Ne=l(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-rjhq4r"&&(z.innerHTML=Ws),Ve=l(t),c(Q.$$.fragment,t),We=l(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-dfggk8"&&(X.innerHTML=As),Ae=l(t),c(E.$$.fragment,t),He=l(t),S=i(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-xlwe87"&&(S.innerHTML=Hs),Le=l(t),N=i(t,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1enki0k"&&(N.innerHTML=Ls),Ye=l(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-14yxh0m"&&(V.innerHTML=Ys),De=l(t),c(W.$$.fragment,t),Pe=l(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-13h81gp"&&(A.innerHTML=Ds),Oe=l(t),c(H.$$.fragment,t),Ke=l(t),c(L.$$.fragment,t),ta=l(t),Y=i(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ccg0zx"&&(Y.innerHTML=Ps),ea=l(t),D=i(t,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-ebt5re"&&(D.innerHTML=Os),aa=l(t),c(P.$$.fragment,t),sa=l(t),O=i(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1hmfl2q"&&(O.textContent=Ks),na=l(t),c(K.$$.fragment,t),la=l(t),tt=i(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-2icw30"&&(tt.innerHTML=tn),oa=l(t),et=i(t,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-5iwuvk"&&(et.innerHTML=en),ia=l(t),c(at.$$.fragment,t),ra=l(t),st=i(t,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-23l1e6"&&(st.innerHTML=an),pa=l(t),c(nt.$$.fragment,t),ca=l(t),lt=i(t,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-gj9dkk"&&(lt.innerHTML=sn),da=l(t),c(ot.$$.fragment,t),ua=l(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1da8xo3"&&(it.textContent=nn),ma=l(t),c(rt.$$.fragment,t),ha=l(t),pt=i(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-cqsf2h"&&(pt.innerHTML=ln),Ma=l(t),c(ct.$$.fragment,t),ya=l(t),dt=i(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-l25vq0"&&(dt.innerHTML=on),fa=l(t),c(ut.$$.fragment,t),Ta=l(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1iqmdsd"&&(mt.innerHTML=rn),ga=l(t),c(ht.$$.fragment,t),Ua=l(t),Mt=i(t,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1c7k4ik"&&(Mt.innerHTML=pn),ja=l(t),c(yt.$$.fragment,t),wa=l(t),ft=i(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-5wxaqa"&&(ft.innerHTML=cn),Ja=l(t),c(Tt.$$.fragment,t),ba=l(t),gt=i(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-iejqw3"&&(gt.innerHTML=dn),ka=l(t),c(Ut.$$.fragment,t),_a=l(t),jt=i(t,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1227n6h"&&(jt.innerHTML=un),Ca=l(t),c(wt.$$.fragment,t),Ia=l(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-qg7sh7"&&(Jt.innerHTML=mn),va=l(t),c(bt.$$.fragment,t),xa=l(t),c(kt.$$.fragment,t),Fa=l(t),_t=i(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1su7aih"&&(_t.innerHTML=hn),$a=l(t),c(Ct.$$.fragment,t),Ga=l(t),It=i(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-11jfbzz"&&(It.textContent=Mn),Za=l(t),c(vt.$$.fragment,t),Ra=l(t),xt=i(t,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-pwdaav"&&(xt.innerHTML=yn),qa=l(t),c(Ft.$$.fragment,t),Ba=l(t),$t=i(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-zbh7v5"&&($t.innerHTML=fn),za=l(t),c(Gt.$$.fragment,t),Qa=l(t),c(Zt.$$.fragment,t),Xa=l(t),Rt=i(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-fyvvsj"&&(Rt.textContent=Tn),Ea=l(t),c(qt.$$.fragment,t),Sa=l(t),Bt=i(t,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-yypgof"&&(Bt.textContent=gn),Na=l(t),c(zt.$$.fragment,t),Va=l(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-yugu96"&&(Qt.innerHTML=Un),Wa=l(t),c(Xt.$$.fragment,t),Aa=l(t),Et=i(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-1qms4cl"&&(Et.innerHTML=jn),Ha=l(t),c(St.$$.fragment,t),La=l(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-qe5zfz"&&(Nt.innerHTML=wn),Ya=l(t),Vt=i(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-69u1rz"&&(Vt.textContent=Jn),Da=l(t),Wt=i(t,"TABLE",{"data-svelte-h":!0}),r(Wt)!=="svelte-8fq96j"&&(Wt.innerHTML=bn),Pa=l(t),c(At.$$.fragment,t),Oa=l(t),Ht=i(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1rqlm78"&&(Ht.innerHTML=kn),Ka=l(t),c(Lt.$$.fragment,t),ts=l(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-sqoxna"&&(Yt.innerHTML=_n),es=l(t),c(Dt.$$.fragment,t),as=l(t),Pt=i(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-vfpk19"&&(Pt.textContent=Cn),ss=l(t),Ot=i(t,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-zatc00"&&(Ot.textContent=In),ns=l(t),c(Kt.$$.fragment,t),ls=l(t),te=i(t,"P",{"data-svelte-h":!0}),r(te)!=="svelte-6trhkk"&&(te.innerHTML=vn),os=l(t),ee=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(ee)!=="svelte-1ejl1pl"&&(ee.innerHTML=xn),is=l(t),U=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(U)!=="svelte-1wkjgyb"&&(U.innerHTML=Fn),rs=l(t),ae=i(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-7jwpzy"&&(ae.innerHTML=$n),ps=l(t),c(se.$$.fragment,t),cs=l(t),ne=i(t,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-sqj12"&&(ne.innerHTML=Gn),ds=l(t),j=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(j)!=="svelte-a1m5gi"&&(j.innerHTML=Zn),us=l(t),le=i(t,"P",{"data-svelte-h":!0}),r(le)!=="svelte-rwofnh"&&(le.innerHTML=Rn),ms=l(t),c(oe.$$.fragment,t),hs=l(t),ie=i(t,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1q1m1nw"&&(ie.innerHTML=qn),Ms=l(t),re=i(t,"TABLE",{"data-svelte-h":!0}),r(re)!=="svelte-lj2wpp"&&(re.innerHTML=Bn),ys=l(t),pe=i(t,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1p74c9x"&&(pe.innerHTML=zn),fs=l(t),c(ce.$$.fragment,t),Ts=l(t),de=i(t,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1o18rwj"&&(de.innerHTML=Qn),gs=l(t),c(ue.$$.fragment,t),Us=l(t),me=i(t,"P",{"data-svelte-h":!0}),r(me)!=="svelte-g801h1"&&(me.textContent=Xn),js=l(t),he=i(t,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-1bnc35u"&&(he.innerHTML=En),ws=l(t),c(Me.$$.fragment,t),Js=l(t),ye=i(t,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-xofzi2"&&(ye.innerHTML=Sn),bs=l(t),c(fe.$$.fragment,t),ks=l(t),T=i(t,"DIV",{class:!0});var xs=$s(T);c(Te.$$.fragment,xs),Zs=l(xs),je=i(xs,"P",{"data-svelte-h":!0}),r(je)!=="svelte-14oyph8"&&(je.innerHTML=Nn),xs.forEach(a),_s=l(t),c(ge.$$.fragment,t),Cs=l(t),g=i(t,"DIV",{class:!0});var Fs=$s(g);c(Ue.$$.fragment,Fs),Rs=l(Fs),we=i(Fs,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1dlriq1"&&(we.textContent=Vn),Fs.forEach(a),Is=l(t),be=i(t,"P",{}),$s(be).forEach(a),this.h()},h(){Gs(f,"name","hf:doc:metadata"),Gs(f,"content",tl),Wn(U,"text-align","center"),Wn(j,"text-align","center"),Gs(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Gs(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){ke(document.head,f),s(t,_e,e),s(t,Je,e),s(t,Ce,e),d(w,t,e),s(t,Ie,e),s(t,J,e),s(t,ve,e),s(t,b,e),s(t,xe,e),d(k,t,e),s(t,Fe,e),s(t,_,e),s(t,$e,e),d(C,t,e),s(t,Ge,e),s(t,I,e),s(t,Ze,e),s(t,v,e),s(t,Re,e),d(x,t,e),s(t,qe,e),s(t,F,e),s(t,Be,e),d($,t,e),s(t,ze,e),d(G,t,e),s(t,Qe,e),s(t,Z,e),s(t,Xe,e),d(R,t,e),s(t,Ee,e),s(t,q,e),s(t,Se,e),d(B,t,e),s(t,Ne,e),s(t,z,e),s(t,Ve,e),d(Q,t,e),s(t,We,e),s(t,X,e),s(t,Ae,e),d(E,t,e),s(t,He,e),s(t,S,e),s(t,Le,e),s(t,N,e),s(t,Ye,e),s(t,V,e),s(t,De,e),d(W,t,e),s(t,Pe,e),s(t,A,e),s(t,Oe,e),d(H,t,e),s(t,Ke,e),d(L,t,e),s(t,ta,e),s(t,Y,e),s(t,ea,e),s(t,D,e),s(t,aa,e),d(P,t,e),s(t,sa,e),s(t,O,e),s(t,na,e),d(K,t,e),s(t,la,e),s(t,tt,e),s(t,oa,e),s(t,et,e),s(t,ia,e),d(at,t,e),s(t,ra,e),s(t,st,e),s(t,pa,e),d(nt,t,e),s(t,ca,e),s(t,lt,e),s(t,da,e),d(ot,t,e),s(t,ua,e),s(t,it,e),s(t,ma,e),d(rt,t,e),s(t,ha,e),s(t,pt,e),s(t,Ma,e),d(ct,t,e),s(t,ya,e),s(t,dt,e),s(t,fa,e),d(ut,t,e),s(t,Ta,e),s(t,mt,e),s(t,ga,e),d(ht,t,e),s(t,Ua,e),s(t,Mt,e),s(t,ja,e),d(yt,t,e),s(t,wa,e),s(t,ft,e),s(t,Ja,e),d(Tt,t,e),s(t,ba,e),s(t,gt,e),s(t,ka,e),d(Ut,t,e),s(t,_a,e),s(t,jt,e),s(t,Ca,e),d(wt,t,e),s(t,Ia,e),s(t,Jt,e),s(t,va,e),d(bt,t,e),s(t,xa,e),d(kt,t,e),s(t,Fa,e),s(t,_t,e),s(t,$a,e),d(Ct,t,e),s(t,Ga,e),s(t,It,e),s(t,Za,e),d(vt,t,e),s(t,Ra,e),s(t,xt,e),s(t,qa,e),d(Ft,t,e),s(t,Ba,e),s(t,$t,e),s(t,za,e),d(Gt,t,e),s(t,Qa,e),d(Zt,t,e),s(t,Xa,e),s(t,Rt,e),s(t,Ea,e),d(qt,t,e),s(t,Sa,e),s(t,Bt,e),s(t,Na,e),d(zt,t,e),s(t,Va,e),s(t,Qt,e),s(t,Wa,e),d(Xt,t,e),s(t,Aa,e),s(t,Et,e),s(t,Ha,e),d(St,t,e),s(t,La,e),s(t,Nt,e),s(t,Ya,e),s(t,Vt,e),s(t,Da,e),s(t,Wt,e),s(t,Pa,e),d(At,t,e),s(t,Oa,e),s(t,Ht,e),s(t,Ka,e),d(Lt,t,e),s(t,ts,e),s(t,Yt,e),s(t,es,e),d(Dt,t,e),s(t,as,e),s(t,Pt,e),s(t,ss,e),s(t,Ot,e),s(t,ns,e),d(Kt,t,e),s(t,ls,e),s(t,te,e),s(t,os,e),s(t,ee,e),s(t,is,e),s(t,U,e),s(t,rs,e),s(t,ae,e),s(t,ps,e),d(se,t,e),s(t,cs,e),s(t,ne,e),s(t,ds,e),s(t,j,e),s(t,us,e),s(t,le,e),s(t,ms,e),d(oe,t,e),s(t,hs,e),s(t,ie,e),s(t,Ms,e),s(t,re,e),s(t,ys,e),s(t,pe,e),s(t,fs,e),d(ce,t,e),s(t,Ts,e),s(t,de,e),s(t,gs,e),d(ue,t,e),s(t,Us,e),s(t,me,e),s(t,js,e),s(t,he,e),s(t,ws,e),d(Me,t,e),s(t,Js,e),s(t,ye,e),s(t,bs,e),d(fe,t,e),s(t,ks,e),s(t,T,e),d(Te,T,null),ke(T,Zs),ke(T,je),s(t,_s,e),d(ge,t,e),s(t,Cs,e),s(t,g,e),d(Ue,g,null),ke(g,Rs),ke(g,we),s(t,Is,e),s(t,be,e),vs=!0},p:Ln,i(t){vs||(u(w.$$.fragment,t),u(k.$$.fragment,t),u(C.$$.fragment,t),u(x.$$.fragment,t),u($.$$.fragment,t),u(G.$$.fragment,t),u(R.$$.fragment,t),u(B.$$.fragment,t),u(Q.$$.fragment,t),u(E.$$.fragment,t),u(W.$$.fragment,t),u(H.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),u(at.$$.fragment,t),u(nt.$$.fragment,t),u(ot.$$.fragment,t),u(rt.$$.fragment,t),u(ct.$$.fragment,t),u(ut.$$.fragment,t),u(ht.$$.fragment,t),u(yt.$$.fragment,t),u(Tt.$$.fragment,t),u(Ut.$$.fragment,t),u(wt.$$.fragment,t),u(bt.$$.fragment,t),u(kt.$$.fragment,t),u(Ct.$$.fragment,t),u(vt.$$.fragment,t),u(Ft.$$.fragment,t),u(Gt.$$.fragment,t),u(Zt.$$.fragment,t),u(qt.$$.fragment,t),u(zt.$$.fragment,t),u(Xt.$$.fragment,t),u(St.$$.fragment,t),u(At.$$.fragment,t),u(Lt.$$.fragment,t),u(Dt.$$.fragment,t),u(Kt.$$.fragment,t),u(se.$$.fragment,t),u(oe.$$.fragment,t),u(ce.$$.fragment,t),u(ue.$$.fragment,t),u(Me.$$.fragment,t),u(fe.$$.fragment,t),u(Te.$$.fragment,t),u(ge.$$.fragment,t),u(Ue.$$.fragment,t),vs=!0)},o(t){m(w.$$.fragment,t),m(k.$$.fragment,t),m(C.$$.fragment,t),m(x.$$.fragment,t),m($.$$.fragment,t),m(G.$$.fragment,t),m(R.$$.fragment,t),m(B.$$.fragment,t),m(Q.$$.fragment,t),m(E.$$.fragment,t),m(W.$$.fragment,t),m(H.$$.fragment,t),m(L.$$.fragment,t),m(P.$$.fragment,t),m(K.$$.fragment,t),m(at.$$.fragment,t),m(nt.$$.fragment,t),m(ot.$$.fragment,t),m(rt.$$.fragment,t),m(ct.$$.fragment,t),m(ut.$$.fragment,t),m(ht.$$.fragment,t),m(yt.$$.fragment,t),m(Tt.$$.fragment,t),m(Ut.$$.fragment,t),m(wt.$$.fragment,t),m(bt.$$.fragment,t),m(kt.$$.fragment,t),m(Ct.$$.fragment,t),m(vt.$$.fragment,t),m(Ft.$$.fragment,t),m(Gt.$$.fragment,t),m(Zt.$$.fragment,t),m(qt.$$.fragment,t),m(zt.$$.fragment,t),m(Xt.$$.fragment,t),m(St.$$.fragment,t),m(At.$$.fragment,t),m(Lt.$$.fragment,t),m(Dt.$$.fragment,t),m(Kt.$$.fragment,t),m(se.$$.fragment,t),m(oe.$$.fragment,t),m(ce.$$.fragment,t),m(ue.$$.fragment,t),m(Me.$$.fragment,t),m(fe.$$.fragment,t),m(Te.$$.fragment,t),m(ge.$$.fragment,t),m(Ue.$$.fragment,t),vs=!1},d(t){t&&(a(_e),a(Je),a(Ce),a(Ie),a(J),a(ve),a(b),a(xe),a(Fe),a(_),a($e),a(Ge),a(I),a(Ze),a(v),a(Re),a(qe),a(F),a(Be),a(ze),a(Qe),a(Z),a(Xe),a(Ee),a(q),a(Se),a(Ne),a(z),a(Ve),a(We),a(X),a(Ae),a(He),a(S),a(Le),a(N),a(Ye),a(V),a(De),a(Pe),a(A),a(Oe),a(Ke),a(ta),a(Y),a(ea),a(D),a(aa),a(sa),a(O),a(na),a(la),a(tt),a(oa),a(et),a(ia),a(ra),a(st),a(pa),a(ca),a(lt),a(da),a(ua),a(it),a(ma),a(ha),a(pt),a(Ma),a(ya),a(dt),a(fa),a(Ta),a(mt),a(ga),a(Ua),a(Mt),a(ja),a(wa),a(ft),a(Ja),a(ba),a(gt),a(ka),a(_a),a(jt),a(Ca),a(Ia),a(Jt),a(va),a(xa),a(Fa),a(_t),a($a),a(Ga),a(It),a(Za),a(Ra),a(xt),a(qa),a(Ba),a($t),a(za),a(Qa),a(Xa),a(Rt),a(Ea),a(Sa),a(Bt),a(Na),a(Va),a(Qt),a(Wa),a(Aa),a(Et),a(Ha),a(La),a(Nt),a(Ya),a(Vt),a(Da),a(Wt),a(Pa),a(Oa),a(Ht),a(Ka),a(ts),a(Yt),a(es),a(as),a(Pt),a(ss),a(Ot),a(ns),a(ls),a(te),a(os),a(ee),a(is),a(U),a(rs),a(ae),a(ps),a(cs),a(ne),a(ds),a(j),a(us),a(le),a(ms),a(hs),a(ie),a(Ms),a(re),a(ys),a(pe),a(fs),a(Ts),a(de),a(gs),a(Us),a(me),a(js),a(he),a(ws),a(Js),a(ye),a(bs),a(ks),a(T),a(_s),a(Cs),a(g),a(Is),a(be)),a(f),h(w,t),h(k,t),h(C,t),h(x,t),h($,t),h(G,t),h(R,t),h(B,t),h(Q,t),h(E,t),h(W,t),h(H,t),h(L,t),h(P,t),h(K,t),h(at,t),h(nt,t),h(ot,t),h(rt,t),h(ct,t),h(ut,t),h(ht,t),h(yt,t),h(Tt,t),h(Ut,t),h(wt,t),h(bt,t),h(kt,t),h(Ct,t),h(vt,t),h(Ft,t),h(Gt,t),h(Zt,t),h(qt,t),h(zt,t),h(Xt,t),h(St,t),h(At,t),h(Lt,t),h(Dt,t),h(Kt,t),h(se,t),h(oe,t),h(ce,t),h(ue,t),h(Me,t),h(fe,t),h(Te),h(ge,t),h(Ue)}}}const tl='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[{"title":"Using token_ids directly for response_template","local":"using-tokenids-directly-for-responsetemplate","sections":[],"depth":4}],"depth":3},{"title":"Add Special Tokens for Chat Format","local":"add-special-tokens-for-chat-format","sections":[],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset ( ConstantLengthDataset )","local":"packing-dataset--constantlengthdataset-","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Enhance model’s performances using NEFTune","local":"enhance-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"ConstantLengthDataset","local":"trl.trainer.ConstantLengthDataset","sections":[],"depth":2}],"depth":1}';function el(qs){return Yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Dn{constructor(f){super(),Pn(this,f,el,Kn,Hn,{})}}export{il as component};
