import{s as Tl,f as vl,n as Jl,o as jl}from"../chunks/scheduler.85c25b89.js";import{S as Cl,i as Zl,g as o,s as n,r as p,A as kl,h as i,f as l,c as s,j as Ie,u as m,x as r,k as w,y as g,a,v as c,d,t as h,w as u}from"../chunks/index.c142fe32.js";import{D as Ft}from"../chunks/Docstring.e6639b56.js";import{C as U}from"../chunks/CodeBlock.a5e95a57.js";import{H as M,E as Il}from"../chunks/EditOnGithub.a592e7aa.js";function xl(Qt){let _,Oe,xe,Ge,v,Be,J,Xe,j,Ht='Online DPO was proposed in <a href="https://huggingface.co/papers/2402.04792" rel="nofollow">Direct Language Model Alignment from Online AI Feedback</a> by Shangmin Guo, Biao Zhang, Tianlin Liu, Tianqi Liu, Misha Khalman, Felipe Llinares, Alexandre Rame, Thomas Mesnard, Yao Zhao, Bilal Piot, Johan Ferret, and Mathieu Blondel.',Ne,C,Vt="The abstract from the paper is the following:",$e,Z,St="<p>Direct alignment from preferences (DAP) methods, such as DPO, have recently emerged as efficient alternatives to reinforcement learning from human feedback (RLHF), that do not require a separate reward model. However, the preference datasets used in DAP methods are usually collected ahead of training and never updated, thus the feedback is purely offline. Moreover, responses in these datasets are often sampled from a language model distinct from the one being aligned, and since the model evolves over training, the alignment phase is inevitably off-policy. In this study, we posit that online feedback is key and improves DAP methods. Our method, online AI feedback (OAIF), uses an LLM as annotator: on each training iteration, we sample two responses from the current model and prompt the LLM annotator to choose which one is preferred, thus providing online feedback. Despite its simplicity, we demonstrate via human evaluation in several tasks that OAIF outperforms both offline DAP and RLHF methods. We further show that the feedback leveraged in OAIF is easily controllable, via instruction prompts to the LLM annotator.</p>",Re,k,Yt='The current implementation uses reward models for scoring completions — see <a href="https://huggingface.co/spaces/allenai/reward-bench" rel="nofollow">Reward Bench</a> for a leaderboard of public models you can use.',Le,I,At='This post-training method was contributed by <a href="https://huggingface.co/mnoukhov" rel="nofollow">Michael Noukhovitch</a>, <a href="https://huggingface.co/vwxyzjn" rel="nofollow">Shengyi Costa Huang</a>, <a href="https://huggingface.co/qgallouedec" rel="nofollow">Quentin Gallouédec</a>, and <a href="https://huggingface.co/edbeeching" rel="nofollow">Edward Beeching</a>.',De,x,Fe,W,Pt='This example demonstrates how to train a model using the online DPO method. We use the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen 0.5B model</a> as the base model and the <a href="https://huggingface.co/trl-lib/Qwen2-0.5B-Reward" rel="nofollow">Qwen 0.5B reward model</a> as the reward model. We use the prompts from the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a>. You can view the prompts in the dataset here:',Qe,b,zt,He,O,Et="Below is the script to train the model:",Ve,G,Se,B,qt="Execute the script using the following command:",Ye,X,Ae,N,Kt="Distributed across 8 GPUs, the training takes approximately 1 hour. You can verify the training progress by checking the reward graph. An increasing trend in both the reward for rejected and chosen completions indicates that the model is improving and generating better responses over time.",Pe,$,el='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/online-dpo-qwen2-reward.png"/>',ze,R,tl="To see how the trained model performs, use the following code to generate completions:",Ee,L,qe,D,Ke,F,ll='Online DPO only requires a <a href="dataset_format#preference">prompt-only dataset</a> (unlike offline DPO, that expects <a href="dataset_format#preference">preference dataset</a>). The <a href="/docs/trl/v0.11.4/en/online_dpo_trainer#trl.OnlineDPOTrainer">OnlineDPOTrainer</a> supports both <a href="dataset_format#conversational-dataset-format">conversational</a> and <a href="dataset_format#standard-dataset-format">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.',et,Q,tt,H,lt,V,al="Make sure that the SFT model and reward model use the <em>same</em> chat template. Otherwise, you may find the model completions are scored incorrectly during training.",at,S,nt,Y,nl='We can want the model to generate completion within a given length. During the learning, the model will generate completion up to the maximum completion length specified in the <code>max_new_tokens</code> argument of <a href="/docs/trl/v0.11.4/en/online_dpo_trainer#trl.OnlineDPOConfig">OnlineDPOConfig</a>. I you want to penalize for not generating an EOS token before the maximum completion length, you can use the <code>missing_eos_penalty</code> argument of <a href="/docs/trl/v0.11.4/en/online_dpo_trainer#trl.OnlineDPOConfig">OnlineDPOConfig</a>:',st,A,ot,P,it,z,sl='To better understand your model’s behavior during training, you can log sample completions periodically using the <a href="/docs/trl/v0.11.4/en/callbacks#trl.LogCompletionsCallback">LogCompletionsCallback</a>.',rt,E,pt,q,ol="This callback logs the model’s generated completions directly to Weights & Biases.",mt,K,il='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/wandb_completions.png" alt="Logged Completions"/>',ct,ee,dt,te,rl='We provide an example script to train a model using the online DPO method. The script is available in <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/dpo_online.py" rel="nofollow"><code>examples/scripts/dpo_online.py</code></a>',ht,le,pl='To test the online DPO script with the <a href="https://huggingface.co/trl-lib/pythia-1b-deduped-tldr-sft" rel="nofollow">Pythia 1B model</a> on the TL;DR summarization task, run the following command:',ut,ae,Mt,ne,yt,se,ml='The logged metrics are as follows. Here is an example <a href="https://wandb.ai/huggingface/trl/runs/dd2o3g35" rel="nofollow">tracked run at Weights and Biases</a>',ft,oe,cl='<li><code>objective/kl</code>: The mean Kullback-Leibler (KL) divergence between the current model and reference model.</li> <li><code>objective/entropy</code>: The mean entropy of the model, indicating the randomness of the actions chosen by the model.</li> <li><code>objective/non_score_reward</code>: The mean reward from non-score-related sources, basically <code>beta * kl.sum(1)</code>, where <code>beta</code> is the KL penalty coefficient and <code>kl</code> is the per-token KL divergence.</li> <li><code>objective/rlhf_reward</code>: The mean RLHF reward, which is <code>scores - non_score_reward</code>. The <code>rlhf_reward</code> is the ultimate objective of online DPO training. If training works as intended, this metric should keep going up.</li> <li><code>objective/scores</code>: The mean scores returned by the reward mode.</li> <li><code>objective/scores_margin</code>: The mean score margin (according to the external reward model) between the chosen and rejected completions.</li> <li><code>rewards/chosen</code>: The mean reward (according to online DPO’s implicit reward model)of the chosen completions.</li> <li><code>rewards/rejected</code>: The mean reward (according to online DPO’s implicit reward model) of the rejected completions.</li> <li><code>rewards/accuracies</code>: The accuracies of the online DPO’s implicit reward model.</li> <li><code>rewards/margins</code>: The mean reward margin (according to online DPO’s implicit reward model) between the chosen and rejected completions.</li> <li><code>logps/chosen</code>: The mean log probabilities of the chosen completions.</li> <li><code>logps/rejected</code>: The mean log probabilities of the rejected completions.</li> <li><code>val/contain_eos_token</code>: The fraction of completions which contain an EOS token.</li> <li><code>beta</code>: The parameter that controls the weight of the loss term representing the deviation from the reference model. Typically fixed, but can be made dynamic by passing a list to <a href="/docs/trl/v0.11.4/en/online_dpo_trainer#trl.OnlineDPOConfig">OnlineDPOConfig</a>.</li>',gt,ie,bt,re,dl='To validate the online DPO implementation works, we ran experiments with the Pythia 1B, 2.8B, and 6.9B models on a single node of 8 x H100s. Here are the commands we used to run the experiments. We take the SFT / RM models directly from <a href="https://huggingface.co/papers/2403.17031" rel="nofollow">The N+ Implementation Details of RLHF with PPO: A Case Study on TL;DR Summarization</a>.',_t,pe,wt,me,hl="Checkpoints and experiment tracking are available at:",Ut,ce,ul='<li><a href="https://huggingface.co/collections/trl-lib/online-dpo-66acd3fa38a331a9cd457b07" rel="nofollow">🤗 Model checkpoints</a></li> <li><a href="https://wandb.ai/huggingface/trl/reports/Online-DPO-experiments-for-TL-DR-summarisation--Vmlldzo5MTczMDU0" rel="nofollow">🐝 Tracked experiment</a></li>',Tt,de,Ml=`To evaluate, we use <a href="https://github.com/vllm-project/vllm" rel="nofollow">vLLM</a> to load the checkpoints and GPT-4o mini as a judge model to evaluate the generated TL;DR against the reference TL;DR.
For more information on how to use judges, see <a href="judges">Judges</a>.`,vt,he,Jt,ue,yl="We can then plot the RLHF scaling chart.",jt,Me,Ct,ye,fl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/online_dpo_scaling.png"/>',Zt,fe,gl="The online DPO checkpoint gets increasingly more win rate as we scale up the model sizes. This is a good sign that the online DPO implementation is working as intended.",kt,ge,It,y,be,Nt,ve,bl="Initialize OnlineDPOTrainer.",$t,T,_e,Rt,Je,_l="Tokenize a single row from a DPO specific dataset.",xt,we,Wt,f,Ue,Lt,je,wl='Configuration class for the <a href="/docs/trl/v0.11.4/en/online_dpo_trainer#trl.OnlineDPOTrainer">OnlineDPOTrainer</a>.',Dt,Ce,Ul=`Using <a href="https://huggingface.co/docs/transformers/v4.45.2/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Ot,Te,Gt,We,Bt;return v=new M({props:{title:"Online DPO Trainer",local:"online-dpo-trainer",headingTag:"h1"}}),J=new M({props:{title:"Overview",local:"overview",headingTag:"h2"}}),x=new M({props:{title:"Quick start",local:"quick-start",headingTag:"h2"}}),G=new U({props:{code:"JTIzJTIwdHJhaW5fb25saW5lX2Rwby5weSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBPbmxpbmVEUE9Db25maWclMkMlMjBPbmxpbmVEUE9UcmFpbmVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMEF1dG9Ub2tlbml6ZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjItMC41Qi1JbnN0cnVjdCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjItMC41Qi1JbnN0cnVjdCUyMiklMEFyZXdhcmRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJ0cmwtbGliJTJGUXdlbjItMC41Qi1SZXdhcmQlMjIlMkMlMjBudW1fbGFiZWxzJTNEMSklMEF0cmFpbl9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnRybC1saWIlMkZ1bHRyYWZlZWRiYWNrLXByb21wdCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBYXJncyUyMCUzRCUyME9ubGluZURQT0NvbmZpZyhvdXRwdXRfZGlyJTNEJTIyb25saW5lLWRwby1xd2VuMiUyMiUyQyUyMGxvZ2dpbmdfc3RlcHMlM0QxMCklMEF0cmFpbmVyJTIwJTNEJTIwT25saW5lRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwcmV3YXJkX21vZGVsJTNEcmV3YXJkX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRGFyZ3MlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># train_online_dpo.py</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> OnlineDPOConfig, OnlineDPOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoModelForSequenceClassification, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
reward_model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;trl-lib/Qwen2-0.5B-Reward&quot;</span>, num_labels=<span class="hljs-number">1</span>)
train_dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback-prompt&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

args = OnlineDPOConfig(output_dir=<span class="hljs-string">&quot;online-dpo-qwen2&quot;</span>, logging_steps=<span class="hljs-number">10</span>)
trainer = OnlineDPOTrainer(
    model=model,
    reward_model=reward_model,
    args=args,
    tokenizer=tokenizer,
    train_dataset=train_dataset,
)
trainer.train()`,wrap:!1}}),X=new U({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX29ubGluZV9kcG8ucHk=",highlighted:"accelerate launch train_online_dpo.py",wrap:!1}}),L=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJvbmxpbmUtZHBvLXF3ZW4yJTJGY2hlY2twb2ludC0xNzczJTIyJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUyMiklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoeSUyMGlzJTIwdGhlJTIwcHJvYmxlbSUyMGFsd2F5cyUyMEROUyUzRiUyMiUwQW91dHB1dCUyMCUzRCUyMGdlbmVyYXRvciglNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBxdWVzdGlvbiU3RCU1RCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAwJTJDJTIwcmV0dXJuX2Z1bGxfdGV4dCUzREZhbHNlKSU1QjAlNUQlMEFwcmludChvdXRwdXQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=<span class="hljs-string">&quot;online-dpo-qwen2/checkpoint-1773&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;Why is the problem always DNS?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = generator([{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: question}], max_new_tokens=<span class="hljs-number">200</span>, return_full_text=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output[<span class="hljs-string">&quot;generated_text&quot;</span>])
The reason why the problem of DNS (Domain Name System) can always be encountered <span class="hljs-keyword">is</span> that it <span class="hljs-keyword">is</span> designed to provide reliable <span class="hljs-keyword">and</span> accurate information about the availability, ownership, <span class="hljs-keyword">or</span> expiration of domain names. However, there may be some circumstances where the system fails to resolve an IP address correctly, leading to the problem of DNS.
For example, <span class="hljs-keyword">if</span> the server hosting the domain name does <span class="hljs-keyword">not</span> have the correct IP address associated <span class="hljs-keyword">with</span> it, <span class="hljs-keyword">or</span> <span class="hljs-keyword">if</span> the IP address <span class="hljs-keyword">is</span> incorrectly formatted, then the DNS system will fail to resolve the domain name correctly. Additionally, <span class="hljs-keyword">if</span> the server hosting the domain name has been compromised, then the DNS system may also fail to resolve the domain name correctly.
It<span class="hljs-string">&#x27;s worth noting that the exact cause of DNS failure can vary depending on the specific situation, so it&#x27;</span>s important to carefully check <span class="hljs-built_in">all</span> relevant factors before attempting to resolve the issue. If you suspect that your DNS problem may be caused by a bug <span class="hljs-keyword">in</span> the system, you should report it to the DNS provider directly <span class="hljs-keyword">for</span> further investigation.`,wrap:!1}}),D=new M({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),Q=new M({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),H=new M({props:{title:"⚠️ Use the same chat template",local:"-use-the-same-chat-template",headingTag:"h3"}}),S=new M({props:{title:"Encourage EOS token generation",local:"encourage-eos-token-generation",headingTag:"h3"}}),A=new U({props:{code:"YXJncyUyMCUzRCUyME9ubGluZURQT0NvbmZpZyguLi4lMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCUyQyUyMG1pc3NpbmdfZW9zX3BlbmFsdHklM0QxLjAp",highlighted:'args = OnlineDPOConfig(..., max_new_tokens=<span class="hljs-number">128</span>, missing_eos_penalty=<span class="hljs-number">1.0</span>)',wrap:!1}}),P=new M({props:{title:"Logging Completions",local:"logging-completions",headingTag:"h3"}}),E=new U({props:{code:"dHJhaW5lciUyMCUzRCUyME9ubGluZURQT1RyYWluZXIoLi4uJTJDJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0KSUwQWNvbXBsZXRpb25zX2NhbGxiYWNrJTIwJTNEJTIwTG9nQ29tcGxldGlvbnNDYWxsYmFjayh0cmFpbmVyJTJDJTIwbnVtX3Byb21wdHMlM0Q4KSUwQXRyYWluZXIuYWRkX2NhbGxiYWNrKGNvbXBsZXRpb25zX2NhbGxiYWNrKQ==",highlighted:`trainer = OnlineDPOTrainer(..., eval_dataset=eval_dataset)
completions_callback = LogCompletionsCallback(trainer, num_prompts=<span class="hljs-number">8</span>)
trainer.add_callback(completions_callback)`,wrap:!1}}),ee=new M({props:{title:"Example script",local:"example-script",headingTag:"h2"}}),ae=new U({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGZHBvX29ubGluZS5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwdHJsLWxpYiUyRnB5dGhpYS0xYi1kZWR1cGVkLXRsZHItc2Z0JTIwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXdhcmRfbW9kZWxfcGF0aCUyMHRybC1saWIlMkZweXRoaWEtMWItZGVkdXBlZC10bGRyLXJtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjB0cmwtbGliJTJGdGxkciUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUyMDUuMGUtNyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMHB5dGhpYS0xYi10bGRyLW9ubGluZS1kcG8lMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMDMyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4X25ld190b2tlbnMlMjA1MyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0td2FybXVwX3JhdGlvJTIwMC4xJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1taXNzaW5nX2Vvc19wZW5hbHR5JTIwMS4wJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`python examples/scripts/dpo_online.py \\
    --model_name_or_path trl-lib/pythia-1b-deduped-tldr-sft  \\
    --reward_model_path trl-lib/pythia-1b-deduped-tldr-rm \\
    --dataset_name trl-lib/tldr \\
    --learning_rate 5.0e-7 \\
    --output_dir pythia-1b-tldr-online-dpo \\
    --per_device_train_batch_size 4 \\
    --gradient_accumulation_steps 32 \\
    --num_train_epochs 3 \\
    --max_new_tokens 53 \\
    --warmup_ratio 0.1 \\
    --missing_eos_penalty 1.0 \\
    --push_to_hub`,wrap:!1}}),ne=new M({props:{title:"Logged metrics",local:"logged-metrics",headingTag:"h2"}}),ie=new M({props:{title:"Benchmark experiments",local:"benchmark-experiments",headingTag:"h2"}}),pe=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># 1B Online DPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/multi_gpu.yaml \\</span>
    examples/scripts/dpo_online.py \\
    <span class="hljs-comment">--model_name_or_path trl-lib/pythia-1b-deduped-tldr-sft  \\</span>
    <span class="hljs-comment">--reward_model_path trl-lib/pythia-1b-deduped-tldr-rm \\</span>
    <span class="hljs-comment">--dataset_name trl-lib/tldr \\</span>
    <span class="hljs-comment">--learning_rate 5.0e-7 \\</span>
    <span class="hljs-comment">--output_dir pythia-1b-deduped-tldr-online-dpo \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 8 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 2 \\</span>
    <span class="hljs-comment">--num_train_epochs 3 \\</span>
    <span class="hljs-comment">--max_new_tokens 53 \\</span>
    <span class="hljs-comment">--warmup_ratio 0.1 \\</span>
    <span class="hljs-comment">--missing_eos_penalty 1.0 \\</span>
    <span class="hljs-comment">--logging_steps 20 \\</span>
    <span class="hljs-comment">--save_steps 0.1 \\</span>
    <span class="hljs-comment">--push_to_hub</span>

<span class="hljs-comment"># 2.8B Online DPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/deepspeed_zero2.yaml \\</span>
    examples/scripts/dpo_online.py \\
    <span class="hljs-comment">--model_name_or_path trl-lib/pythia-2.8b-deduped-tldr-sft  \\</span>
    <span class="hljs-comment">--reward_model_path trl-lib/pythia-2.8b-deduped-tldr-rm \\</span>
    <span class="hljs-comment">--dataset_name trl-lib/tldr \\</span>
    <span class="hljs-comment">--learning_rate 5.0e-7 \\</span>
    <span class="hljs-comment">--output_dir pythia-2.8b-deduped-tldr-online-dpo \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 8 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 2 \\</span>
    <span class="hljs-comment">--num_train_epochs 3 \\</span>
    <span class="hljs-comment">--max_new_tokens 53 \\</span>
    <span class="hljs-comment">--warmup_ratio 0.1 \\</span>
    <span class="hljs-comment">--missing_eos_penalty 1.0 \\</span>
    <span class="hljs-comment">--bf16 \\</span>
    <span class="hljs-comment">--logging_steps 20 \\</span>
    <span class="hljs-comment">--save_steps 0.1 \\</span>
    <span class="hljs-comment">--push_to_hub</span>

<span class="hljs-comment"># 6.9B Online DPO experiment</span>
accelerate <span class="hljs-built_in">launch</span> <span class="hljs-comment">--config_file examples/accelerate_configs/deepspeed_zero2.yaml \\</span>
    examples/scripts/dpo_online.py \\
    <span class="hljs-comment">--model_name_or_path trl-lib/pythia-6.9b-deduped-tldr-sft  \\</span>
    <span class="hljs-comment">--reward_model_path trl-lib/pythia-6.9b-deduped-tldr-rm \\</span>
    <span class="hljs-comment">--dataset_name trl-lib/tldr \\</span>
    <span class="hljs-comment">--learning_rate 5.0e-7 \\</span>
    <span class="hljs-comment">--output_dir pythia-6.9b-deduped-tldr-online-dpo \\</span>
    <span class="hljs-comment">--beta 0.1 \\</span>
    <span class="hljs-comment">--per_device_train_batch_size 4 \\</span>
    <span class="hljs-comment">--gradient_accumulation_steps 4 \\</span>
    <span class="hljs-comment">--num_train_epochs 3 \\</span>
    <span class="hljs-comment">--max_new_tokens 53 \\</span>
    <span class="hljs-comment">--warmup_ratio 0.1 \\</span>
    <span class="hljs-comment">--missing_eos_penalty 1.0 \\</span>
    <span class="hljs-comment">--bf16 \\</span>
    <span class="hljs-comment">--gradient_checkpointing \\</span>
    <span class="hljs-comment">--logging_steps 20 \\</span>
    <span class="hljs-comment">--save_steps 0.1 \\</span>
    <span class="hljs-comment">--push_to_hub</span>`,wrap:!1}}),he=new U({props:{code:"JTI0JTIwcHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGZXZhbHMlMkZqdWRnZV90bGRyLnB5JTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjB0cmwtbGliJTJGcHl0aGlhLTFiLWRlZHVwZWQtdGxkci1zZnQlMjAtLWp1ZGdlX21vZGVsJTIwZ3B0LTRvLW1pbmklMjAtLW51bV9leGFtcGxlcyUyMDEwMDAlMEFNb2RlbCUyMHdpbiUyMHJhdGUlM0ElMjAzMy4wMCUyNSUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGc2NyaXB0cyUyRmV2YWxzJTJGanVkZ2VfdGxkci5weSUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwdHJsLWxpYiUyRnB5dGhpYS02LjliLWRlZHVwZWQtdGxkci1zZnQlMjAtLWp1ZGdlX21vZGVsJTIwZ3B0LTRvLW1pbmklMjAtLW51bV9leGFtcGxlcyUyMDEwMDAlMEFNb2RlbCUyMHdpbiUyMHJhdGUlM0ElMjA0MS41MCUyNSUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGc2NyaXB0cyUyRmV2YWxzJTJGanVkZ2VfdGxkci5weSUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwdHJsLWxpYiUyRnB5dGhpYS0xYi1kZWR1cGVkLXRsZHItb25saW5lLWRwbyUyMC0tanVkZ2VfbW9kZWwlMjBncHQtNG8tbWluaSUyMC0tbnVtX2V4YW1wbGVzJTIwMTAwMCUwQU1vZGVsJTIwd2luJTIwcmF0ZSUzQSUyMDYyLjYwJTI1JTBBcHl0aG9uJTIwZXhhbXBsZXMlMkZzY3JpcHRzJTJGZXZhbHMlMkZqdWRnZV90bGRyLnB5JTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjB0cmwtbGliJTJGcHl0aGlhLTYuOWItZGVkdXBlZC10bGRyLW9ubGluZS1kcG8lMjAtLWp1ZGdlX21vZGVsJTIwZ3B0LTRvLW1pbmklMjAtLW51bV9leGFtcGxlcyUyMDEwMDAlMEFNb2RlbCUyMHdpbiUyMHJhdGUlM0ElMjA3NC4yMCUyNQ==",highlighted:`$ python examples/scripts/evals/judge_tldr.py --model_name_or_path trl-lib/pythia-1b-deduped-tldr-sft --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 33.00%
python examples/scripts/evals/judge_tldr.py --model_name_or_path trl-lib/pythia-6.9b-deduped-tldr-sft --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 41.50%
python examples/scripts/evals/judge_tldr.py --model_name_or_path trl-lib/pythia-1b-deduped-tldr-online-dpo --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 62.60%
python examples/scripts/evals/judge_tldr.py --model_name_or_path trl-lib/pythia-6.9b-deduped-tldr-online-dpo --judge_model gpt-4o-mini --num_examples 1000
Model win rate: 74.20%`,wrap:!1}}),Me=new U({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXJlc3VsdHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJTRlQlMjIlM0ElMjAlN0IxLjBlOSUzQSUyMDAuMjElMkMlMjAyLjhlOSUzQSUyMDAuMjclMkMlMjA2LjllOSUzQSUyMDAuMzE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIyb25saW5lLWRwbyUyMiUzQSUyMCU3QjEuMGU5JTNBJTIwMC41NDIlMkMlMjAyLjhlOSUzQSUyMDAuNzQ2JTJDJTIwNi45ZTklM0ElMjAwLjc5NiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMm9mZmxpbmUtZHBvJTIyJTNBJTIwJTdCMS4wZTklM0ElMjAwLjQyMiUyQyUyMDIuOGU5JTNBJTIwMC41MTclMkMlMjA2LjllOSUzQSUyMDAuNzAxJTdEJTJDJTBBJTdEJTBBJTBBJTBBcGx0LnBsb3QocmVzdWx0cyU1QiUyMlNGVCUyMiU1RC5rZXlzKCklMkMlMjByZXN1bHRzJTVCJTIyU0ZUJTIyJTVELnZhbHVlcygpJTJDJTIwbGFiZWwlM0QlMjJTRlQlMjIlMkMlMjBtYXJrZXIlM0QlMjJvJTIyKSUwQXBsdC5wbG90KHJlc3VsdHMlNUIlMjJvbmxpbmUtZHBvJTIyJTVELmtleXMoKSUyQyUyMHJlc3VsdHMlNUIlMjJvbmxpbmUtZHBvJTIyJTVELnZhbHVlcygpJTJDJTIwbGFiZWwlM0QlMjJPbmxpbmUtZHBvJTIwd2l0aCUyMFJNJTIwanVkZ2UlMjIlMkMlMjBtYXJrZXIlM0QlMjJvJTIyKSUwQXBsdC5wbG90KHJlc3VsdHMlNUIlMjJvZmZsaW5lLWRwbyUyMiU1RC5rZXlzKCklMkMlMjByZXN1bHRzJTVCJTIyb2ZmbGluZS1kcG8lMjIlNUQudmFsdWVzKCklMkMlMjBsYWJlbCUzRCUyMk9mZmxpbmUtZHBvJTIyJTJDJTIwbWFya2VyJTNEJTIybyUyMiklMEFwbHQuYXhobGluZSh5JTNEMC41JTJDJTIwY29sb3IlM0QlMjJibGFjayUyMiUyQyUyMGxpbmVzdHlsZSUzRCUyMi0uJTIyJTJDJTIwbGFiZWwlM0QlMjJIdW1hbiUyMHJlZmVyZW5jZSUyMHN1bW1hcnklMjIpJTBBcGx0LnhzY2FsZSglMjJsb2clMjIpJTBBcGx0LnhsYWJlbCglMjJNb2RlbCUyMHNpemUlMjIpJTBBcGx0LnlsYWJlbCglMjJXaW4lMjByYXRlJTIwYWdhaW5zdCUyMHJlZmVyZW5jZSUyMHN1bW1hcmllcyU1Q24oYWNjb3JkaW5nJTIwdG8lMjBHUFQtNC0wNjEzKSUyMiklMEFwbHQudGl0bGUoJTIyRFBPJTIwc2NhbGluZyUyMGJ5JTIwbW9kZWwlMjBzaXplJTIyKSUwQXBsdC5sZWdlbmQoKSUwQXBsdC54bGltKDVlOCUyQyUyMDEuMmUxMCklMEFwbHQueHRpY2tzKCU1QjFlOSUyQyUyMDNlOSUyQyUyMDFlMTAlNUQlMkMlMjAlNUIlMjIxQiUyMiUyQyUyMCUyMjNCJTIyJTJDJTIwJTIyMTBCJTIyJTVEKSUwQXBsdC5ncmlkKFRydWUlMkMlMjB3aGljaCUzRCUyMmJvdGglMjIlMkMlMjBscyUzRCUyMi0tJTIyJTJDJTIwYyUzRCUyMjAuNyUyMiklMEFwbHQudGlnaHRfbGF5b3V0KCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

results = {
    <span class="hljs-string">&quot;SFT&quot;</span>: {<span class="hljs-number">1.0e9</span>: <span class="hljs-number">0.21</span>, <span class="hljs-number">2.8e9</span>: <span class="hljs-number">0.27</span>, <span class="hljs-number">6.9e9</span>: <span class="hljs-number">0.316</span>},
    <span class="hljs-string">&quot;online-dpo&quot;</span>: {<span class="hljs-number">1.0e9</span>: <span class="hljs-number">0.542</span>, <span class="hljs-number">2.8e9</span>: <span class="hljs-number">0.746</span>, <span class="hljs-number">6.9e9</span>: <span class="hljs-number">0.796</span>},
    <span class="hljs-string">&quot;offline-dpo&quot;</span>: {<span class="hljs-number">1.0e9</span>: <span class="hljs-number">0.422</span>, <span class="hljs-number">2.8e9</span>: <span class="hljs-number">0.517</span>, <span class="hljs-number">6.9e9</span>: <span class="hljs-number">0.701</span>},
}


plt.plot(results[<span class="hljs-string">&quot;SFT&quot;</span>].keys(), results[<span class="hljs-string">&quot;SFT&quot;</span>].values(), label=<span class="hljs-string">&quot;SFT&quot;</span>, marker=<span class="hljs-string">&quot;o&quot;</span>)
plt.plot(results[<span class="hljs-string">&quot;online-dpo&quot;</span>].keys(), results[<span class="hljs-string">&quot;online-dpo&quot;</span>].values(), label=<span class="hljs-string">&quot;Online-dpo with RM judge&quot;</span>, marker=<span class="hljs-string">&quot;o&quot;</span>)
plt.plot(results[<span class="hljs-string">&quot;offline-dpo&quot;</span>].keys(), results[<span class="hljs-string">&quot;offline-dpo&quot;</span>].values(), label=<span class="hljs-string">&quot;Offline-dpo&quot;</span>, marker=<span class="hljs-string">&quot;o&quot;</span>)
plt.axhline(y=<span class="hljs-number">0.5</span>, color=<span class="hljs-string">&quot;black&quot;</span>, linestyle=<span class="hljs-string">&quot;-.&quot;</span>, label=<span class="hljs-string">&quot;Human reference summary&quot;</span>)
plt.xscale(<span class="hljs-string">&quot;log&quot;</span>)
plt.xlabel(<span class="hljs-string">&quot;Model size&quot;</span>)
plt.ylabel(<span class="hljs-string">&quot;Win rate against reference summaries\\n(according to GPT-4-0613)&quot;</span>)
plt.title(<span class="hljs-string">&quot;DPO scaling by model size&quot;</span>)
plt.legend()
plt.xlim(<span class="hljs-number">5e8</span>, <span class="hljs-number">1.2e10</span>)
plt.xticks([<span class="hljs-number">1e9</span>, <span class="hljs-number">3e9</span>, <span class="hljs-number">1e10</span>], [<span class="hljs-string">&quot;1B&quot;</span>, <span class="hljs-string">&quot;3B&quot;</span>, <span class="hljs-string">&quot;10B&quot;</span>])
plt.grid(<span class="hljs-literal">True</span>, which=<span class="hljs-string">&quot;both&quot;</span>, ls=<span class="hljs-string">&quot;--&quot;</span>, c=<span class="hljs-string">&quot;0.7&quot;</span>)
plt.tight_layout()
plt.show()`,wrap:!1}}),ge=new M({props:{title:"OnlineDPOTrainer",local:"trl.OnlineDPOTrainer",headingTag:"h2"}}),be=new Ft({props:{name:"class trl.OnlineDPOTrainer",anchor:"trl.OnlineDPOTrainer",parameters:[{name:"model",val:": Union"},{name:"ref_model",val:": Union = None"},{name:"reward_model",val:": Union = None"},{name:"judge",val:": Optional = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Union = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.OnlineDPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code> or <code>torch.nn.Module</code>) &#x2014;
The model to train, preferably an <code>AutoModelForCausalLM</code>.`,name:"model"},{anchor:"trl.OnlineDPOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>transformers.PreTrainedModel</code> or <code>torch.nn.Module</code> or <code>None</code>) &#x2014;
The reference model to use for training. If None is specified, the reference model will be created from
the model.`,name:"ref_model"},{anchor:"trl.OnlineDPOTrainer.reward_model",description:`<strong>reward_model</strong> (<code>transformers.PreTrainedModel</code> or <code>torch.nn.Module</code> or <code>None</code>) &#x2014;
The reward model to score completions with, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"reward_model"},{anchor:"trl.OnlineDPOTrainer.judge",description:`<strong>judge</strong> (<code>BasePairwiseJudge</code>) &#x2014;
The judge to use for pairwise comparison of model completions.`,name:"judge"},{anchor:"trl.OnlineDPOTrainer.args",description:`<strong>args</strong> (<code>OnlineDPOConfig</code>) &#x2014;
The online DPO config arguments to use for training.`,name:"args"},{anchor:"trl.OnlineDPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.OnlineDPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.OnlineDPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.OnlineDPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.OnlineDPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>) &#x2014;
The peft config to use for training.`,name:"peft_config"},{anchor:"trl.OnlineDPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.OnlineDPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.OnlineDPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.OnlineDPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.11.4/trl/trainer/online_dpo_trainer.py#L75"}}),_e=new Ft({props:{name:"tokenize_row",anchor:"trl.OnlineDPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"is_encoder_decoder",val:": bool"},{name:"tokenizer",val:": PreTrainedTokenizerBase"}],source:"https://github.com/huggingface/trl/blob/v0.11.4/trl/trainer/online_dpo_trainer.py#L282"}}),we=new M({props:{title:"OnlineDPOConfig",local:"trl.OnlineDPOConfig",headingTag:"h2"}}),Ue=new Ft({props:{name:"class trl.OnlineDPOConfig",anchor:"trl.OnlineDPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"torch_empty_cache_steps",val:": Optional = None"},{name:"learning_rate",val:": float = 5e-07"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": List = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": Optional = False"},{name:"eval_use_gather_object",val:": Optional = False"},{name:"reward_model_path",val:": Optional = None"},{name:"max_new_tokens",val:": int = 64"},{name:"temperature",val:": float = 0.9"},{name:"missing_eos_penalty",val:": Optional = None"},{name:"beta",val:": List = <factory>"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"dataset_num_proc",val:": Optional = None"},{name:"disable_dropout",val:": bool = True"}],parametersDescription:[{anchor:"trl.OnlineDPOConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>5e-7</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of
<a href="https://huggingface.co/docs/transformers/v4.45.2/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.OnlineDPOConfig.reward_model_path",description:`<strong>reward_model_path</strong> (<code>Optional[str]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Path to the reward model.`,name:"reward_model_path"},{anchor:"trl.OnlineDPOConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to <code>64</code>) &#x2014;
Maximum number of tokens to generate per completion.`,name:"max_new_tokens"},{anchor:"trl.OnlineDPOConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.9</code>) &#x2014;
Temperature for sampling. The higher the temperature, the more random the completions.`,name:"temperature"},{anchor:"trl.OnlineDPOConfig.missing_eos_penalty",description:`<strong>missing_eos_penalty</strong> (<code>Optional[float]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Penalty applied to the score when the model fails to generate an EOS token. This is useful to encourage
to generate completions shorter than the maximum length (<code>max_new_tokens</code>). The penalty must be a positive
value.`,name:"missing_eos_penalty"},{anchor:"trl.OnlineDPOConfig.beta",description:`<strong>beta</strong> (<code>float</code> or <code>list[float]</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model. For the IPO loss (<code>loss_type=&quot;ipo&quot;</code>), &#x3B2; is the regularization parameter denoted by &#x3C4; in
the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">paper</a>. If a list of floats is provided then the &#x3B2; is
selected for each new epoch and the last &#x3B2; is used for the rest of the epochs.`,name:"beta"},{anchor:"trl.OnlineDPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.OnlineDPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.OnlineDPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model.`,name:"disable_dropout"}],source:"https://github.com/huggingface/trl/blob/v0.11.4/trl/trainer/online_dpo_config.py#L21"}}),Te=new Il({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/online_dpo_trainer.md"}}),{c(){_=o("meta"),Oe=n(),xe=o("p"),Ge=n(),p(v.$$.fragment),Be=n(),p(J.$$.fragment),Xe=n(),j=o("p"),j.innerHTML=Ht,Ne=n(),C=o("p"),C.textContent=Vt,$e=n(),Z=o("blockquote"),Z.innerHTML=St,Re=n(),k=o("p"),k.innerHTML=Yt,Le=n(),I=o("p"),I.innerHTML=At,De=n(),p(x.$$.fragment),Fe=n(),W=o("p"),W.innerHTML=Pt,Qe=n(),b=o("iframe"),He=n(),O=o("p"),O.textContent=Et,Ve=n(),p(G.$$.fragment),Se=n(),B=o("p"),B.textContent=qt,Ye=n(),p(X.$$.fragment),Ae=n(),N=o("p"),N.textContent=Kt,Pe=n(),$=o("p"),$.innerHTML=el,ze=n(),R=o("p"),R.textContent=tl,Ee=n(),p(L.$$.fragment),qe=n(),p(D.$$.fragment),Ke=n(),F=o("p"),F.innerHTML=ll,et=n(),p(Q.$$.fragment),tt=n(),p(H.$$.fragment),lt=n(),V=o("p"),V.innerHTML=al,at=n(),p(S.$$.fragment),nt=n(),Y=o("p"),Y.innerHTML=nl,st=n(),p(A.$$.fragment),ot=n(),p(P.$$.fragment),it=n(),z=o("p"),z.innerHTML=sl,rt=n(),p(E.$$.fragment),pt=n(),q=o("p"),q.textContent=ol,mt=n(),K=o("p"),K.innerHTML=il,ct=n(),p(ee.$$.fragment),dt=n(),te=o("p"),te.innerHTML=rl,ht=n(),le=o("p"),le.innerHTML=pl,ut=n(),p(ae.$$.fragment),Mt=n(),p(ne.$$.fragment),yt=n(),se=o("p"),se.innerHTML=ml,ft=n(),oe=o("ul"),oe.innerHTML=cl,gt=n(),p(ie.$$.fragment),bt=n(),re=o("p"),re.innerHTML=dl,_t=n(),p(pe.$$.fragment),wt=n(),me=o("p"),me.textContent=hl,Ut=n(),ce=o("ul"),ce.innerHTML=ul,Tt=n(),de=o("p"),de.innerHTML=Ml,vt=n(),p(he.$$.fragment),Jt=n(),ue=o("p"),ue.textContent=yl,jt=n(),p(Me.$$.fragment),Ct=n(),ye=o("p"),ye.innerHTML=fl,Zt=n(),fe=o("p"),fe.textContent=gl,kt=n(),p(ge.$$.fragment),It=n(),y=o("div"),p(be.$$.fragment),Nt=n(),ve=o("p"),ve.textContent=bl,$t=n(),T=o("div"),p(_e.$$.fragment),Rt=n(),Je=o("p"),Je.textContent=_l,xt=n(),p(we.$$.fragment),Wt=n(),f=o("div"),p(Ue.$$.fragment),Lt=n(),je=o("p"),je.innerHTML=wl,Dt=n(),Ce=o("p"),Ce.innerHTML=Ul,Ot=n(),p(Te.$$.fragment),Gt=n(),We=o("p"),this.h()},l(e){const t=kl("svelte-u9bgzb",document.head);_=i(t,"META",{name:!0,content:!0}),t.forEach(l),Oe=s(e),xe=i(e,"P",{}),Ie(xe).forEach(l),Ge=s(e),m(v.$$.fragment,e),Be=s(e),m(J.$$.fragment,e),Xe=s(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-f1ddr0"&&(j.innerHTML=Ht),Ne=s(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-vfdo9a"&&(C.textContent=Vt),$e=s(e),Z=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Z)!=="svelte-djifwf"&&(Z.innerHTML=St),Re=s(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1kscccl"&&(k.innerHTML=Yt),Le=s(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1vcnqml"&&(I.innerHTML=At),De=s(e),m(x.$$.fragment,e),Fe=s(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1q7p98i"&&(W.innerHTML=Pt),Qe=s(e),b=i(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),Ie(b).forEach(l),He=s(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-uqytq6"&&(O.textContent=Et),Ve=s(e),m(G.$$.fragment,e),Se=s(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-15hino8"&&(B.textContent=qt),Ye=s(e),m(X.$$.fragment,e),Ae=s(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-c89cht"&&(N.textContent=Kt),Pe=s(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1f3l9ve"&&($.innerHTML=el),ze=s(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-54l4o4"&&(R.textContent=tl),Ee=s(e),m(L.$$.fragment,e),qe=s(e),m(D.$$.fragment,e),Ke=s(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1trvvuh"&&(F.innerHTML=ll),et=s(e),m(Q.$$.fragment,e),tt=s(e),m(H.$$.fragment,e),lt=s(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1kgiyxw"&&(V.innerHTML=al),at=s(e),m(S.$$.fragment,e),nt=s(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1luwdg8"&&(Y.innerHTML=nl),st=s(e),m(A.$$.fragment,e),ot=s(e),m(P.$$.fragment,e),it=s(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-6qkmdp"&&(z.innerHTML=sl),rt=s(e),m(E.$$.fragment,e),pt=s(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1hvqa3l"&&(q.textContent=ol),mt=s(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-azj40q"&&(K.innerHTML=il),ct=s(e),m(ee.$$.fragment,e),dt=s(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-18xtjxg"&&(te.innerHTML=rl),ht=s(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1r5swgg"&&(le.innerHTML=pl),ut=s(e),m(ae.$$.fragment,e),Mt=s(e),m(ne.$$.fragment,e),yt=s(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1i6oul1"&&(se.innerHTML=ml),ft=s(e),oe=i(e,"UL",{"data-svelte-h":!0}),r(oe)!=="svelte-kbmuhy"&&(oe.innerHTML=cl),gt=s(e),m(ie.$$.fragment,e),bt=s(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-k5qvzm"&&(re.innerHTML=dl),_t=s(e),m(pe.$$.fragment,e),wt=s(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-yl0uf2"&&(me.textContent=hl),Ut=s(e),ce=i(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-12icmte"&&(ce.innerHTML=ul),Tt=s(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-19n72p9"&&(de.innerHTML=Ml),vt=s(e),m(he.$$.fragment,e),Jt=s(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-unx6we"&&(ue.textContent=yl),jt=s(e),m(Me.$$.fragment,e),Ct=s(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1suobbe"&&(ye.innerHTML=fl),Zt=s(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1fufp5p"&&(fe.textContent=gl),kt=s(e),m(ge.$$.fragment,e),It=s(e),y=i(e,"DIV",{class:!0});var Ze=Ie(y);m(be.$$.fragment,Ze),Nt=s(Ze),ve=i(Ze,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-v6j7a9"&&(ve.textContent=bl),$t=s(Ze),T=i(Ze,"DIV",{class:!0});var Xt=Ie(T);m(_e.$$.fragment,Xt),Rt=s(Xt),Je=i(Xt,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1861yti"&&(Je.textContent=_l),Xt.forEach(l),Ze.forEach(l),xt=s(e),m(we.$$.fragment,e),Wt=s(e),f=i(e,"DIV",{class:!0});var ke=Ie(f);m(Ue.$$.fragment,ke),Lt=s(ke),je=i(ke,"P",{"data-svelte-h":!0}),r(je)!=="svelte-fot7te"&&(je.innerHTML=wl),Dt=s(ke),Ce=i(ke,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1iitlg5"&&(Ce.innerHTML=Ul),ke.forEach(l),Ot=s(e),m(Te.$$.fragment,e),Gt=s(e),We=i(e,"P",{}),Ie(We).forEach(l),this.h()},h(){w(_,"name","hf:doc:metadata"),w(_,"content",Wl),vl(b.src,zt="https://huggingface.co/datasets/trl-lib/ultrafeedback-prompt/embed/viewer/default/train?row=0")||w(b,"src",zt),w(b,"frameborder","0"),w(b,"width","100%"),w(b,"height","560px"),w(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){g(document.head,_),a(e,Oe,t),a(e,xe,t),a(e,Ge,t),c(v,e,t),a(e,Be,t),c(J,e,t),a(e,Xe,t),a(e,j,t),a(e,Ne,t),a(e,C,t),a(e,$e,t),a(e,Z,t),a(e,Re,t),a(e,k,t),a(e,Le,t),a(e,I,t),a(e,De,t),c(x,e,t),a(e,Fe,t),a(e,W,t),a(e,Qe,t),a(e,b,t),a(e,He,t),a(e,O,t),a(e,Ve,t),c(G,e,t),a(e,Se,t),a(e,B,t),a(e,Ye,t),c(X,e,t),a(e,Ae,t),a(e,N,t),a(e,Pe,t),a(e,$,t),a(e,ze,t),a(e,R,t),a(e,Ee,t),c(L,e,t),a(e,qe,t),c(D,e,t),a(e,Ke,t),a(e,F,t),a(e,et,t),c(Q,e,t),a(e,tt,t),c(H,e,t),a(e,lt,t),a(e,V,t),a(e,at,t),c(S,e,t),a(e,nt,t),a(e,Y,t),a(e,st,t),c(A,e,t),a(e,ot,t),c(P,e,t),a(e,it,t),a(e,z,t),a(e,rt,t),c(E,e,t),a(e,pt,t),a(e,q,t),a(e,mt,t),a(e,K,t),a(e,ct,t),c(ee,e,t),a(e,dt,t),a(e,te,t),a(e,ht,t),a(e,le,t),a(e,ut,t),c(ae,e,t),a(e,Mt,t),c(ne,e,t),a(e,yt,t),a(e,se,t),a(e,ft,t),a(e,oe,t),a(e,gt,t),c(ie,e,t),a(e,bt,t),a(e,re,t),a(e,_t,t),c(pe,e,t),a(e,wt,t),a(e,me,t),a(e,Ut,t),a(e,ce,t),a(e,Tt,t),a(e,de,t),a(e,vt,t),c(he,e,t),a(e,Jt,t),a(e,ue,t),a(e,jt,t),c(Me,e,t),a(e,Ct,t),a(e,ye,t),a(e,Zt,t),a(e,fe,t),a(e,kt,t),c(ge,e,t),a(e,It,t),a(e,y,t),c(be,y,null),g(y,Nt),g(y,ve),g(y,$t),g(y,T),c(_e,T,null),g(T,Rt),g(T,Je),a(e,xt,t),c(we,e,t),a(e,Wt,t),a(e,f,t),c(Ue,f,null),g(f,Lt),g(f,je),g(f,Dt),g(f,Ce),a(e,Ot,t),c(Te,e,t),a(e,Gt,t),a(e,We,t),Bt=!0},p:Jl,i(e){Bt||(d(v.$$.fragment,e),d(J.$$.fragment,e),d(x.$$.fragment,e),d(G.$$.fragment,e),d(X.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(Q.$$.fragment,e),d(H.$$.fragment,e),d(S.$$.fragment,e),d(A.$$.fragment,e),d(P.$$.fragment,e),d(E.$$.fragment,e),d(ee.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(he.$$.fragment,e),d(Me.$$.fragment,e),d(ge.$$.fragment,e),d(be.$$.fragment,e),d(_e.$$.fragment,e),d(we.$$.fragment,e),d(Ue.$$.fragment,e),d(Te.$$.fragment,e),Bt=!0)},o(e){h(v.$$.fragment,e),h(J.$$.fragment,e),h(x.$$.fragment,e),h(G.$$.fragment,e),h(X.$$.fragment,e),h(L.$$.fragment,e),h(D.$$.fragment,e),h(Q.$$.fragment,e),h(H.$$.fragment,e),h(S.$$.fragment,e),h(A.$$.fragment,e),h(P.$$.fragment,e),h(E.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(Me.$$.fragment,e),h(ge.$$.fragment,e),h(be.$$.fragment,e),h(_e.$$.fragment,e),h(we.$$.fragment,e),h(Ue.$$.fragment,e),h(Te.$$.fragment,e),Bt=!1},d(e){e&&(l(Oe),l(xe),l(Ge),l(Be),l(Xe),l(j),l(Ne),l(C),l($e),l(Z),l(Re),l(k),l(Le),l(I),l(De),l(Fe),l(W),l(Qe),l(b),l(He),l(O),l(Ve),l(Se),l(B),l(Ye),l(Ae),l(N),l(Pe),l($),l(ze),l(R),l(Ee),l(qe),l(Ke),l(F),l(et),l(tt),l(lt),l(V),l(at),l(nt),l(Y),l(st),l(ot),l(it),l(z),l(rt),l(pt),l(q),l(mt),l(K),l(ct),l(dt),l(te),l(ht),l(le),l(ut),l(Mt),l(yt),l(se),l(ft),l(oe),l(gt),l(bt),l(re),l(_t),l(wt),l(me),l(Ut),l(ce),l(Tt),l(de),l(vt),l(Jt),l(ue),l(jt),l(Ct),l(ye),l(Zt),l(fe),l(kt),l(It),l(y),l(xt),l(Wt),l(f),l(Ot),l(Gt),l(We)),l(_),u(v,e),u(J,e),u(x,e),u(G,e),u(X,e),u(L,e),u(D,e),u(Q,e),u(H,e),u(S,e),u(A,e),u(P,e),u(E,e),u(ee,e),u(ae,e),u(ne,e),u(ie,e),u(pe,e),u(he,e),u(Me,e),u(ge,e),u(be),u(_e),u(we,e),u(Ue),u(Te,e)}}}const Wl='{"title":"Online DPO Trainer","local":"online-dpo-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Quick start","local":"quick-start","sections":[],"depth":2},{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"⚠️ Use the same chat template","local":"-use-the-same-chat-template","sections":[],"depth":3},{"title":"Encourage EOS token generation","local":"encourage-eos-token-generation","sections":[],"depth":3},{"title":"Logging Completions","local":"logging-completions","sections":[],"depth":3}],"depth":2},{"title":"Example script","local":"example-script","sections":[],"depth":2},{"title":"Logged metrics","local":"logged-metrics","sections":[],"depth":2},{"title":"Benchmark experiments","local":"benchmark-experiments","sections":[],"depth":2},{"title":"OnlineDPOTrainer","local":"trl.OnlineDPOTrainer","sections":[],"depth":2},{"title":"OnlineDPOConfig","local":"trl.OnlineDPOConfig","sections":[],"depth":2}],"depth":1}';function Ol(Qt){return jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends Cl{constructor(_){super(),Zl(this,_,Ol,xl,Tl,{})}}export{Rl as component};
