import{s as en,f as sn,o as ln,n as aa}from"../chunks/scheduler.85c25b89.js";import{S as an,i as nn,g as u,s as a,r as p,A as pn,h as y,f as e,c as n,j as ea,u as o,x as j,k as N,y as on,a as l,v as r,d as i,t as M,w as c}from"../chunks/index.c142fe32.js";import{T as la}from"../chunks/Tip.993c623e.js";import{C as h}from"../chunks/CodeBlock.a5e95a57.js";import{H as d,E as rn}from"../chunks/EditOnGithub.a592e7aa.js";function Mn(C){let J,w="While both the prompt-only and language modeling formats are similar, they differ in how the input is handled. In the prompt-only format, the prompt represents a partial input that expects the model to complete or continue, while in the language modeling format, the input is treated as a complete sentence or sequence. These two formats are processed differently by TRL. Below is an example showing the difference in the output of the <code>apply_chat_template</code> function for each format:",U,T,g,q,f="<li>The prompt-only output includes a <code>&#39;&lt;|assistant|&gt;\\n&#39;</code>, indicating the beginning of the assistant’s turn and expecting the model to generate a completion.</li> <li>In contrast, the language modeling output treats the input as a complete sequence and terminates it with <code>&#39;&lt;|endoftext|&gt;&#39;</code>, signaling the end of the text and not expecting any additional content.</li>",b;return T=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwYXBwbHlfY2hhdF90ZW1wbGF0ZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktMTI4ay1pbnN0cnVjdCUyMiklMEElMEElMjMlMjBFeGFtcGxlJTIwZm9yJTIwcHJvbXB0LW9ubHklMjBmb3JtYXQlMEFwcm9tcHRfb25seV9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlN0QlMEFhcHBseV9jaGF0X3RlbXBsYXRlKHByb21wdF9vbmx5X2V4YW1wbGUlMkMlMjB0b2tlbml6ZXIpJTBBJTIzJTIwT3V0cHV0JTNBJTIwJTdCJ3Byb21wdCclM0ElMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0Nhc3Npc3RhbnQlN0MlM0UlNUNuJyU3RCUwQSUwQSUyMyUyMEV4YW1wbGUlMjBmb3IlMjBsYW5ndWFnZSUyMG1vZGVsaW5nJTIwZm9ybWF0JTBBbG1fZXhhbXBsZSUyMCUzRCUyMCU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlN0QlMEFhcHBseV9jaGF0X3RlbXBsYXRlKGxtX2V4YW1wbGUlMkMlMjB0b2tlbml6ZXIpJTBBJTIzJTIwT3V0cHV0JTNBJTIwJTdCJ3RleHQnJTNBJTIwJyUzQyU3Q3VzZXIlN0MlM0UlNUNuV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJyU3RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-128k-instruct&quot;</span>)

<span class="hljs-comment"># Example for prompt-only format</span>
prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}
apply_chat_template(prompt_only_example, tokenizer)
<span class="hljs-comment"># Output: {&#x27;prompt&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;}</span>

<span class="hljs-comment"># Example for language modeling format</span>
lm_example = {<span class="hljs-string">&quot;messages&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}]}
apply_chat_template(lm_example, tokenizer)
<span class="hljs-comment"># Output: {&#x27;text&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;}</span>`,wrap:!1}}),{c(){J=u("p"),J.innerHTML=w,U=a(),p(T.$$.fragment),g=a(),q=u("ul"),q.innerHTML=f},l(m){J=y(m,"P",{"data-svelte-h":!0}),j(J)!=="svelte-1ksq0ic"&&(J.innerHTML=w),U=n(m),o(T.$$.fragment,m),g=n(m),q=y(m,"UL",{"data-svelte-h":!0}),j(q)!=="svelte-17mqw6t"&&(q.innerHTML=f)},m(m,I){l(m,J,I),l(m,U,I),r(T,m,I),l(m,g,I),l(m,q,I),b=!0},p:aa,i(m){b||(i(T.$$.fragment,m),b=!0)},o(m){M(T.$$.fragment,m),b=!1},d(m){m&&(e(J),e(U),e(g),e(q)),c(T,m)}}}function cn(C){let J,w=`TRL trainers only support standard dataset formats, <a href="https://github.com/huggingface/trl/issues/2071" rel="nofollow">for now</a>. If you have a conversational dataset, you must first convert it into a standard format.
For more information on how to work with conversational datasets, refer to the <a href="#working-with-conversational-datasets-in-trl">Working with conversational datasets in TRL</a> section.`;return{c(){J=u("p"),J.innerHTML=w},l(U){J=y(U,"P",{"data-svelte-h":!0}),j(J)!=="svelte-38co2n"&&(J.innerHTML=w)},m(U,T){l(U,J,T)},p:aa,d(U){U&&e(J)}}}function un(C){let J,w='We recommend using the <a href="/docs/trl/v0.11.3/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> function rather than directly calling <code>tokenizer.apply_chat_template</code>. Handling chat templates nonlanguage modeling datasets can be tricky and may lead to issues, such as inserting a system prompt in the middle of a conversation. For additional examples, see <a href="https://github.com/huggingface/trl/pull/1930#issuecomment-2292908614" rel="nofollow">#1930 (comment)</a>. The <a href="/docs/trl/v0.11.3/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> is designed to handle these intricacies and ensure the correct application of chat templates for various tasks.';return{c(){J=u("p"),J.innerHTML=w},l(U){J=y(U,"P",{"data-svelte-h":!0}),j(J)!=="svelte-zhn0yu"&&(J.innerHTML=w)},m(U,T){l(U,J,T)},p:aa,d(U){U&&e(J)}}}function yn(C){let J,w='It’s important to note that chat templates are model-specific. For example, if you use the chat template from <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-8B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3.1-8B-Instruct</a> with the above example, you get a different output:',U,T,g,q,f="Always use the chat template associated with the model you’re working with. Using the wrong template can lead to inaccurate or unexpected results.",b;return T=new h({props:{code:"YXBwbHlfY2hhdF90ZW1wbGF0ZShleGFtcGxlJTJDJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSklMEElMjMlMjBPdXRwdXQlM0ElMEElMjMlMjAlN0IncHJvbXB0JyUzQSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRXN5c3RlbSU1Q25Zb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lM0MlN0NpbV9lbmQlN0MlM0UlNUNuJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTVDbldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiclMkMlMEElMjMlMjAlMjAnY29tcGxldGlvbiclM0ElMjAnSXQlMjBpcyUyMGJsdWUuJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiclN0Q=",highlighted:`apply_chat_template(example, AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-8B-Instruct&quot;</span>))
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: &#x27;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\nWhat color is the sky?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&#x27;,</span>
<span class="hljs-comment">#  &#x27;completion&#x27;: &#x27;It is blue.&lt;|im_end|&gt;\\n&#x27;}</span>`,wrap:!1}}),{c(){J=u("p"),J.innerHTML=w,U=a(),p(T.$$.fragment),g=a(),q=u("p"),q.textContent=f},l(m){J=y(m,"P",{"data-svelte-h":!0}),j(J)!=="svelte-6bgf58"&&(J.innerHTML=w),U=n(m),o(T.$$.fragment,m),g=n(m),q=y(m,"P",{"data-svelte-h":!0}),j(q)!=="svelte-ien9e7"&&(q.textContent=f)},m(m,I){l(m,J,I),l(m,U,I),r(T,m,I),l(m,g,I),l(m,q,I),b=!0},p:aa,i(m){b||(i(T.$$.fragment,m),b=!0)},o(m){M(T.$$.fragment,m),b=!1},d(m){m&&(e(J),e(U),e(g),e(q)),c(T,m)}}}function jn(C){let J,w,U,T,g,q,f,b="This guide provides an overview of the dataset formats supported by each trainer in TRL. Since conversational datasets are very common, we also provide a guide on how to use them, and how to convert them into a standard dataset format for TRL trainers.",m,I,Ws,k,na="The <em>format</em> of a dataset refers to how the data is structured, typically categorized as either <em>standard</em> or <em>conversational</em>. The <em>type</em> is associated with the specific task the dataset is designed for, such as <em>prompt-only</em> or <em>preference</em>. Each type is characterized by its columns, which vary according to the task, as shown in the table.",zs,v,pa=`<tbody><tr><th>Type \\ Format</th> <th>Standard</th> <th>Conversational</th></tr> <tr><td>Language modeling</td> <td><pre><code>{&quot;text&quot;: &quot;The sky is blue.&quot;}</code></pre></td> <td><pre><code>{&quot;messages&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
              {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}]}</code></pre></td></tr> <tr><td>Prompt-only</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}]}</code></pre></td></tr> <tr><td>Prompt-completion</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;completion&quot;: &quot; blue.&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;completion&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}]}</code></pre></td></tr> <tr><td>Preference</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;chosen&quot;: &quot; blue.&quot;,
 &quot;rejected&quot;: &quot; green.&quot;}</code></pre>
      or, with implicit prompt:
      <pre><code>{&quot;chosen&quot;: &quot;The sky is blue.&quot;,
 &quot;rejected&quot;: &quot;The sky is green.&quot;}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;chosen&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}],
 &quot;rejected&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}]}</code></pre>
      or, with implicit prompt:
      <pre><code>{&quot;chosen&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
              {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is blue.&quot;}],
  &quot;rejected&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;},
                {&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}]}</code></pre></td></tr> <tr><td>Unpaired preference</td> <td><pre><code>{&quot;prompt&quot;: &quot;The sky is&quot;,
 &quot;completion&quot;: &quot; blue.&quot;,
 &quot;label&quot;: True}</code></pre></td> <td><pre><code>{&quot;prompt&quot;: [{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;What color is the sky?&quot;}],
 &quot;completion&quot;: [{&quot;role&quot;: &quot;assistant&quot;, &quot;content&quot;: &quot;It is green.&quot;}],
 &quot;label&quot;: False}</code></pre></td></tr></tbody>`,Ss,A,_s,R,oa="The standard dataset format typically consists of plain text strings. The columns in the dataset vary depending on the task. This is the format expected by TRL trainers. Below are examples of standard dataset formats for different tasks:",Fs,X,Ys,V,Hs,E,ra="Conversational datasets are used for tasks involving dialogues or chat interactions between users and assistants. Unlike standard dataset formats, these contain sequences of messages where each message has a <code>role</code> (e.g., <code>&quot;user&quot;</code> or <code>&quot;assistant&quot;</code>) and <code>content</code> (the message text).",Ls,W,Ds,z,ia="Just like standard datasets, the columns in conversational datasets vary depending on the task. For instance, a preference dataset would include columns like <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> to compare responses:",Ps,S,Ks,_,Ma='Conversational datasets are useful for training chat models, but must be converted into a standard format before being used with TRL trainers. This is typically done using chat templates specific to the model being used. For more information, refer to the <a href="#working-with-conversational-datasets-in-trl">Working with conversational datasets in TRL</a> section.',Os,F,te,Y,ca="A language modeling dataset consists of a column <code>&quot;text&quot;</code> (or <code>&quot;messages&quot;</code> for conversational datasets) containing a full sequence of text.",se,H,ee,L,le,D,ua="In a prompt-only dataset, only the initial prompt (the question or partial sentence) is provided under the key <code>&quot;prompt&quot;</code>. The training typically involves generating the completion based on this prompt, where the model learns to continue or complete the given input.",ae,P,ne,x,pe,K,oe,O,ya="A prompt-completion dataset includes a <code>&quot;prompt&quot;</code> and a <code>&quot;completion&quot;</code>.",re,tt,ie,st,Me,et,ja=`A preference dataset is used for tasks where the model is trained to choose between two or more possible completions to the same prompt. This dataset includes a <code>&quot;prompt&quot;</code>, a <code>&quot;chosen&quot;</code> completion, and a <code>&quot;rejected&quot;</code> completion. The model is trained to select the <code>&quot;chosen&quot;</code> response over the <code>&quot;rejected&quot;</code> response.
Some dataset may not include the <code>&quot;prompt&quot;</code> column, in which case the prompt is implicit and directly included in the <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions. We recommend using explicit prompts whenever possible.`,ce,lt,ue,at,ye,nt,ha="An unpaired preference dataset is similar to a preference dataset but instead of having <code>&quot;chosen&quot;</code> and <code>&quot;rejected&quot;</code> completions for the same prompt, it includes a single <code>&quot;completion&quot;</code> and a <code>&quot;label&quot;</code> indicating whether the completion is preferred or not.",je,pt,he,ot,me,rt,ma="Choosing the right dataset format depends on the task you are working on and the specific requirements of the TRL trainer you are using. Below is a brief overview of the dataset formats supported by each TRL trainer.",Je,it,Ja='<thead><tr><th>Trainer</th> <th>Expected dataset format</th></tr></thead> <tbody><tr><td><a href="/docs/trl/v0.11.3/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a></td> <td>Unpaired preference</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a></td> <td>Preference (explicit prompt)</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/dpo_trainer#trl.DPOTrainer">DPOTrainer</a></td> <td>Preference (explicit prompt)</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/iterative_sft_trainer#trl.IterativeSFTTrainer">IterativeSFTTrainer</a></td> <td>Unpaired preference</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a></td> <td>Unpaired preference</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/nash_md_trainer#trl.NashMDTrainer">NashMDTrainer</a></td> <td>Prompt-only</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/online_dpo_trainer#trl.OnlineDPOTrainer">OnlineDPOTrainer</a></td> <td>Prompt-only</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/orpo_trainer#trl.ORPOTrainer">ORPOTrainer</a></td> <td>Preference (explicit prompt)</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/ppov2_trainer#trl.PPOv2Trainer">PPOv2Trainer</a></td> <td>Tokenized language modeling</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/reward_trainer#trl.RewardTrainer">RewardTrainer</a></td> <td>Preference (implicit prompt)</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a></td> <td>Language modeling</td></tr> <tr><td><a href="/docs/trl/v0.11.3/en/xpo_trainer#trl.XPOTrainer">XPOTrainer</a></td> <td>Prompt-only</td></tr></tbody>',de,G,Ue,Mt,Te,ct,da=`Conversational datasets are increasingly common, especially for training chat models. However, TRL trainers (except <a href="/docs/trl/v0.11.3/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>) don’t support conversational datasets in their raw format. These datasets must first be converted into a standard format.
Fortunately, TRL offers tools to easily handle this conversion, which are detailed below.`,qe,ut,Ie,yt,Ua="TRL trainers do not support conversational datasets in their raw format. To use them, you need to convert them into a standard dataset format using a chat template. This template is provided by the tokenizer of the model you use.",ge,jt,Ta='For detailed instructions on using chat templating, refer to the <a href="https://huggingface.co/docs/transformers/en/chat_templating" rel="nofollow">Chat templating section in the <code>transformers</code> documentation</a>.',we,ht,qa='In TRL, the method you apply to convert the dataset will vary depending on the task. Fortunately, TRL provides a helper function called <a href="/docs/trl/v0.11.3/en/data_utils#trl.apply_chat_template">apply_chat_template()</a> to simplify this process. Here’s an example of how to use it:',fe,mt,be,Jt,Ia='Alternatively, you can use the <a href="https://huggingface.co/docs/datasets/v3.0.1/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> method to apply the template across an entire dataset:',Ce,dt,$e,B,Qe,Z,Ne,Ut,xe,Tt,ga="Many datasets come in formats tailored to specific tasks, which might not be directly compatible with TRL. To use such datasets with TRL, you may need to preprocess and convert them into the required format.",Ge,qt,wa='To make this easier, we provide a set of <a href="https://github.com/huggingface/trl/tree/main/examples/datasets" rel="nofollow">example scripts</a> that cover common dataset conversions.',Be,It,Ze,gt,fa='Let’s take the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a> as an example. Here’s a preview of the dataset:',ke,$,ba,ve,wt,Ca="As shown above, the dataset format does not match the expected structure. It’s not in a conversational format, the column names differ, and the results pertain to different models (e.g., Bard, GPT-4) and aspects (e.g., “helpfulness”, “honesty”).",Ae,ft,$a='By using the provided conversion script <a href="https://github.com/huggingface/trl/tree/main/examples/datasets/ultrafeedback.py" rel="nofollow"><code>examples/datasets/ultrafeedback.py</code></a>, you can transform this dataset into an unpaired preference format, and push it to the Hub:',Re,bt,Xe,Ct,Qa="Once converted, the dataset will look like this:",Ve,Q,Na,Ee,$t,xa="Now, you can use this dataset with TRL!",We,Qt,Ga="By adapting the provided scripts or creating your own, you can convert any dataset into a format compatible with TRL.",ze,Nt,Se,xt,Ba="This section provides example code to help you convert between different dataset types. While some conversions can be performed after applying the chat template (i.e., in the standard format), we recommend performing the conversion before applying the chat template to ensure it works consistently.",_e,Gt,Za="For simplicity, some of the examples below do not follow this recommendation and use the standard format. However, the conversions can be applied directly to the conversational format without modification.",Fe,Bt,ka='<thead><tr><th>From \\ To</th> <th>Language modeling</th> <th>Prompt-completion</th> <th>Prompt-only</th> <th>Preference with implicit prompt</th> <th>Preference</th> <th>Unpaired preference</th></tr></thead> <tbody><tr><td>Language modeling</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Prompt-completion</td> <td><a href="#from-prompt-completion-to-language-modeling-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-prompt-completion-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Prompt-only</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr> <tr><td>Preference with implicit prompt</td> <td><a href="#from-preference-with-implicit-prompt-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-implicit-to-explicit-prompt-preference-dataset">🔗</a></td> <td><a href="#from-preference-with-implicit-prompt-to-unpaired-preference-dataset">🔗</a></td></tr> <tr><td>Preference</td> <td><a href="#from-preference-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-preference-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-preference-to-prompt-only-dataset">🔗</a></td> <td><a href="#from-explicit-to-implicit-prompt-preference-dataset">🔗</a></td> <td>N/A</td> <td><a href="#from-preference-to-unpaired-preference-dataset">🔗</a></td></tr> <tr><td>Unpaired preference</td> <td><a href="#from-unpaired-preference-to-language-modeling-dataset">🔗</a></td> <td><a href="#from-unpaired-preference-to-prompt-completion-dataset">🔗</a></td> <td><a href="#from-unpaired-preference-to-prompt-only-dataset">🔗</a></td> <td>N/A</td> <td>N/A</td> <td>N/A</td></tr></tbody>',Ye,Zt,He,kt,va="To convert a prompt-completion dataset into a language modeling dataset, concatenate the prompt and the completion.",Le,vt,De,At,Pe,Rt,Ke,Xt,Aa="To convert a prompt-completion dataset into a prompt-only dataset, remove the completion.",Oe,Vt,tl,Et,sl,Wt,el,zt,Ra="To convert a preference with implicit prompt dataset into a language modeling dataset, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;text&quot;</code>.",ll,St,al,_t,nl,Ft,pl,Yt,Xa='To convert a preference dataset with implicit prompt into a prompt-completion dataset, extract the prompt with <a href="/docs/trl/v0.11.3/en/data_utils#trl.extract_prompt">extract_prompt()</a>, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;completion&quot;</code>.',ol,Ht,rl,Lt,il,Dt,Ml,Pt,Va='To convert a preference dataset with implicit prompt into a prompt-only dataset, extract the prompt with <a href="/docs/trl/v0.11.3/en/data_utils#trl.extract_prompt">extract_prompt()</a>, and remove the rejected and the chosen.',cl,Kt,ul,Ot,yl,ts,jl,ss,Ea='To convert a preference dataset with implicit prompt into a preference dataset with explicit prompt, extract the prompt with <a href="/docs/trl/v0.11.3/en/data_utils#trl.extract_prompt">extract_prompt()</a>.',hl,es,ml,ls,Jl,as,dl,ns,Wa='To convert a preference dataset with implicit prompt into an unpaired preference dataset, extract the prompt with <a href="/docs/trl/v0.11.3/en/data_utils#trl.extract_prompt">extract_prompt()</a>, and unpair the dataset with <a href="/docs/trl/v0.11.3/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>.',Ul,ps,Tl,os,ql,rs,Il,is,za="To convert a preference dataset into a language modeling dataset, remove the rejected, concatenate the prompt and the chosen into the <code>&quot;text&quot;</code> column.",gl,Ms,wl,cs,fl,us,bl,ys,Sa="To convert a preference dataset into a prompt-completion dataset, remove the rejected, and rename the column <code>&quot;chosen&quot;</code> to <code>&quot;completion&quot;</code>.",Cl,js,$l,hs,Ql,ms,Nl,Js,_a="To convert a preference dataset into a prompt-only dataset, remove the rejected and the chosen.",xl,ds,Gl,Us,Bl,Ts,Zl,qs,Fa="To convert a preference dataset with implicit prompt into a preference dataset with explicit prompt, concatenate the prompt to both chosen and rejected, and remove the prompt.",kl,Is,vl,gs,Al,ws,Rl,fs,Ya='To convert dataset into an unpaired preference dataset, unpair the dataset with <a href="/docs/trl/v0.11.3/en/data_utils#trl.unpair_preference_dataset">unpair_preference_dataset()</a>.',Xl,bs,Vl,Cs,El,$s,Wl,Qs,Ha="To convert an unpaired preference dataset into a language modeling dataset, concatenate the prompt and the completion into the <code>&quot;text&quot;</code> column, and remove the prompt, completion and label columns.",zl,Ns,Sl,xs,_l,Gs,Fl,Bs,La="To convert an unpaired preference dataset into a prompt-completion dataset, remove the label columns.",Yl,Zs,Hl,ks,Ll,vs,Dl,As,Da="To convert an unpaired preference dataset into a prompt-only dataset, remove the completion and the label columns.",Pl,Rs,Kl,Xs,Ol,Vs,ta,Es,sa;return g=new d({props:{title:"Dataset formats",local:"dataset-formats",headingTag:"h1"}}),I=new d({props:{title:"Overview of the dataset formats and types",local:"overview-of-the-dataset-formats-and-types",headingTag:"h2"}}),A=new d({props:{title:"Standard dataset format",local:"standard-dataset-format",headingTag:"h3"}}),X=new h({props:{code:"JTIzJTIwTGFuZ3VhZ2UlMjBtb2RlbGluZyUwQWV4YW1wbGUlMjAlM0QlMjAlN0IlMjJ0ZXh0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBibHVlLiUyMiU3RCUwQSUyMyUyMFByZWZlcmVuY2UlMEFleGFtcGxlJTIwJTNEJTIwJTdCJTIyY2hvc2VuJTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBibHVlLiUyMiUyQyUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjBncmVlbi4lMjIlN0Q=",highlighted:`<span class="hljs-comment"># Language modeling</span>
example = {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>}
<span class="hljs-comment"># Preference</span>
example = {<span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;The sky is green.&quot;</span>}`,wrap:!1}}),V=new d({props:{title:"Conversational dataset format",local:"conversational-dataset-format",headingTag:"h3"}}),W=new h({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
]`,wrap:!1}}),S=new h({props:{code:"ZXhhbXBsZSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwZ3JlZW4uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTdE",highlighted:`example = {
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>},
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>},
    ],
}`,wrap:!1}}),F=new d({props:{title:"Language modeling",local:"language-modeling",headingTag:"h3"}}),H=new h({props:{code:"bGFuZ3VhZ2VfbW9kZWxpbmdfZXhhbXBsZSUyMCUzRCUyMCU3QiUyMnRleHQlMjIlM0ElMjAlMjJUaGUlMjBza3klMjBpcyUyMGJsdWUuJTIyJTdE",highlighted:'language_modeling_example = {<span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>}',wrap:!1}}),L=new d({props:{title:"Prompt-only",local:"prompt-only",headingTag:"h3"}}),P=new h({props:{code:"cHJvbXB0X29ubHlfZXhhbXBsZSUyMCUzRCUyMCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHNreSUyMGlzJTIyJTdE",highlighted:'prompt_only_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>}',wrap:!1}}),x=new la({props:{$$slots:{default:[Mn]},$$scope:{ctx:C}}}),K=new d({props:{title:"Prompt-completion",local:"prompt-completion",headingTag:"h3"}}),tt=new h({props:{code:"cHJvbXB0X2NvbXBsZXRpb25fZXhhbXBsZSUyMCUzRCUyMCU3QiUyMnByb21wdCUyMiUzQSUyMCUyMlRoZSUyMHNreSUyMGlzJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUyMGJsdWUuJTIyJTdE",highlighted:'prompt_completion_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>}',wrap:!1}}),st=new d({props:{title:"Preference",local:"preference",headingTag:"h3"}}),lt=new h({props:{code:"cHJlZmVyZW5jZV9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJjaG9zZW4lMjIlM0ElMjAlMjIlMjBibHVlLiUyMiUyQyUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTIyJTIwZ3JlZW4uJTIyJTdEJTIwJTIwJTIzJTIwcmVjb21tZW5kZWQlMEElMjMlMjBvciUyQyUwQXByZWZlcmVuY2VfZXhhbXBsZSUyMCUzRCUyMCU3QiUyMmNob3NlbiUyMiUzQSUyMCUyMlRoZSUyMHNreSUyMGlzJTIwYmx1ZS4lMjIlMkMlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCUyMlRoZSUyMHNreSUyMGlzJTIwZ3JlZW4uJTIyJTdE",highlighted:`preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot; green.&quot;</span>}  <span class="hljs-comment"># recommended</span>
<span class="hljs-comment"># or,</span>
preference_example = {<span class="hljs-string">&quot;chosen&quot;</span>: <span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>: <span class="hljs-string">&quot;The sky is green.&quot;</span>}`,wrap:!1}}),at=new d({props:{title:"Unpaired preference",local:"unpaired-preference",headingTag:"h3"}}),pt=new h({props:{code:"dW5wYWlyZWRfcHJlZmVyZW5jZV9leGFtcGxlJTIwJTNEJTIwJTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjJsYWJlbCUyMiUzQSUyMFRydWUlN0Q=",highlighted:'unpaired_preference_example = {<span class="hljs-string">&quot;prompt&quot;</span>: <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>: <span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">True</span>}',wrap:!1}}),ot=new d({props:{title:"Which dataset format to use?",local:"which-dataset-format-to-use",headingTag:"h2"}}),G=new la({props:{$$slots:{default:[cn]},$$scope:{ctx:C}}}),Mt=new d({props:{title:"Working with conversational datasets in TRL",local:"working-with-conversational-datasets-in-trl",headingTag:"h2"}}),ut=new d({props:{title:"Converting a conversational dataset into a standard dataset",local:"converting-a-conversational-dataset-into-a-standard-dataset",headingTag:"h3"}}),mt=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJsJTIwaW1wb3J0JTIwYXBwbHlfY2hhdF90ZW1wbGF0ZSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRlBoaS0zLW1pbmktMTI4ay1pbnN0cnVjdCUyMiklMEElMEFleGFtcGxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJdCUyMGlzJTIwYmx1ZS4lMjIlN0QlNUQlMEElN0QlMEElMEFhcHBseV9jaGF0X3RlbXBsYXRlKGV4YW1wbGUlMkMlMjB0b2tlbml6ZXIpJTBBJTIzJTIwT3V0cHV0JTNBJTBBJTIzJTIwJTdCJ3Byb21wdCclM0ElMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0Nhc3Npc3RhbnQlN0MlM0UlNUNuJyUyQyUyMCdjb21wbGV0aW9uJyUzQSUyMCdJdCUyMGlzJTIwYmx1ZS4lM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJyU3RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-128k-instruct&quot;</span>)

example = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
    <span class="hljs-string">&quot;completion&quot;</span>: [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}]
}

apply_chat_template(example, tokenizer)
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: &#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;, &#x27;completion&#x27;: &#x27;It is blue.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;}</span>`,wrap:!1}}),dt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBhcHBseV9jaGF0X3RlbXBsYXRlJTBBJTBBZGF0YXNldF9kaWN0JTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIycHJvbXB0JTIyJTNBJTIwJTVCJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTIyJTdEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNreS4lMjIlN0QlNUQlNUQlMEElN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoZGF0YXNldF9kaWN0KSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChhcHBseV9jaGF0X3RlbXBsYXRlJTJDJTIwZm5fa3dhcmdzJTNEJTdCJTIydG9rZW5pemVyJTIyJTNBJTIwdG9rZW5pemVyJTdEKSUwQSUyMyUyME91dHB1dCUzQSUwQSUyMyUyMCU3Qidwcm9tcHQnJTNBJTIwJTVCJyUzQyU3Q3VzZXIlN0MlM0UlNUNuV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlM0MlN0NlbmQlN0MlM0UlNUNuJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclMkMlMEElMjMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAnJTNDJTdDdXNlciU3QyUzRSU1Q25XaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTNDJTdDZW5kJTdDJTNFJTVDbiUzQyU3Q2Fzc2lzdGFudCU3QyUzRSU1Q24nJTVEJTJDJTBBJTIzJTIwJTIwJ2NvbXBsZXRpb24nJTNBJTIwJTVCJ0l0JTIwaXMlMjBibHVlLiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTJDJTIwJ0luJTIwdGhlJTIwc2t5LiUzQyU3Q2VuZCU3QyUzRSU1Q24lM0MlN0NlbmRvZnRleHQlN0MlM0UnJTVEJTdE",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> apply_chat_template

dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
               [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}]],
    <span class="hljs-string">&quot;completion&quot;</span>: [[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
                   [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}]]
}

dataset = Dataset.from_dict(dataset_dict)
dataset = dataset.<span class="hljs-built_in">map</span>(apply_chat_template, fn_kwargs={<span class="hljs-string">&quot;tokenizer&quot;</span>: tokenizer})
<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># {&#x27;prompt&#x27;: [&#x27;&lt;|user|&gt;\\nWhat color is the sky?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;,</span>
<span class="hljs-comment">#             &#x27;&lt;|user|&gt;\\nWhere is the sun?&lt;|end|&gt;\\n&lt;|assistant|&gt;\\n&#x27;],</span>
<span class="hljs-comment">#  &#x27;completion&#x27;: [&#x27;It is blue.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;, &#x27;In the sky.&lt;|end|&gt;\\n&lt;|endoftext|&gt;&#x27;]}</span>`,wrap:!1}}),B=new la({props:{warning:!0,$$slots:{default:[un]},$$scope:{ctx:C}}}),Z=new la({props:{warning:!0,$$slots:{default:[yn]},$$scope:{ctx:C}}}),Ut=new d({props:{title:"Using any dataset with TRL: preprocessing and conversion",local:"using-any-dataset-with-trl-preprocessing-and-conversion",headingTag:"h2"}}),It=new d({props:{title:"Example: UltraFeedback dataset",local:"example-ultrafeedback-dataset",headingTag:"h3"}}),bt=new h({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZkYXRhc2V0cyUyRnVsdHJhZmVlZGJhY2sucHklMjAtLXB1c2hfdG9faHViJTIwLS1yZXBvX2lkJTIwdHJsLWxpYiUyRnVsdHJhZmVlZGJhY2stZ3B0LTMuNS10dXJiby1oZWxwZnVsbmVzcw==",highlighted:"python examples/datasets/ultrafeedback.py --push_to_hub --repo_id trl-lib/ultrafeedback-gpt-3.5-turbo-helpfulness",wrap:!1}}),Nt=new d({props:{title:"Utilities for converting dataset types",local:"utilities-for-converting-dataset-types",headingTag:"h2"}}),Zt=new d({props:{title:"From prompt-completion to language modeling dataset",local:"from-prompt-completion-to-language-modeling-dataset",headingTag:"h3"}}),vt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiUyMiUyMGJsdWUuJTIyJTJDJTIwJTIyJTIwaW4lMjB0aGUlMjBza3kuJTIyJTVEJTJDJTBBJTdEKSUwQSUwQWRlZiUyMGNvbmNhdF9wcm9tcHRfY29tcGxldGlvbihleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwZXhhbXBsZSU1QiUyMmNvbXBsZXRpb24lMjIlNUQlN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY29uY2F0X3Byb21wdF9jb21wbGV0aW9uJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIlMjJwcm9tcHQlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_completion</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;completion&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_completion, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>])`,wrap:!1}}),At=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Rt=new d({props:{title:"From prompt-completion to prompt-only dataset",local:"from-prompt-completion-to-prompt-only-dataset",headingTag:"h3"}}),Vt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCU1QiUyMiUyMGJsdWUuJTIyJTJDJTIwJTIyJTIwaW4lMjB0aGUlMjBza3kuJTIyJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCUyMmNvbXBsZXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
})

dataset = dataset.remove_columns(<span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),Et=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),Wt=new d({props:{title:"From preference with implicit prompt to language modeling dataset",local:"from-preference-with-implicit-prompt-to-language-modeling-dataset",headingTag:"h3"}}),St=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMGJsdWUuJTIyJTJDJTIwJTIyVGhlJTIwc3VuJTIwaXMlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMlRoZSUyMHNreSUyMGlzJTIwZ3JlZW4uJTIyJTJDJTIwJTIyVGhlJTIwc3VuJTIwaXMlMjBpbiUyMHRoZSUyMHNlYS4lMjIlNUQlMkMlMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJjaG9zZW4lMjIlMkMlMjAlMjJ0ZXh0JTIyKS5yZW1vdmVfY29sdW1ucyglMjJyZWplY3RlZCUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot;The sky is blue.&quot;</span>, <span class="hljs-string">&quot;The sun is in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot;The sky is green.&quot;</span>, <span class="hljs-string">&quot;The sun is in the sea.&quot;</span>],
})

dataset = dataset.rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>).remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>)`,wrap:!1}}),_t=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Ft=new d({props:{title:"From preference with implicit prompt to prompt-completion dataset",local:"from-preference-with-implicit-prompt-to-prompt-completion-dataset",headingTag:"h3"}}),Ht=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQpLnJlbW92ZV9jb2x1bW5zKCUyMnJlamVjdGVkJTIyKS5yZW5hbWVfY29sdW1uKCUyMmNob3NlbiUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})
dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt).remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>).rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),Lt=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}], <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}]}`,wrap:!1}}),Dt=new d({props:{title:"From preference with implicit prompt to prompt-only dataset",local:"from-preference-with-implicit-prompt-to-prompt-only-dataset",headingTag:"h3"}}),Kt=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQpLnJlbW92ZV9jb2x1bW5zKCU1QiUyMmNob3NlbiUyMiUyQyUyMCUyMnJlamVjdGVkJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})
dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt).remove_columns([<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),Ot=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}]}`,wrap:!1}}),ts=new d({props:{title:"From implicit to explicit prompt preference dataset",local:"from-implicit-to-explicit-prompt-preference-dataset",headingTag:"h3"}}),es=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoZXh0cmFjdF9wcm9tcHQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt)`,wrap:!1}}),ls=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;chosen&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;rejected&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is green.&#x27;</span>}]}`,wrap:!1}}),as=new d({props:{title:"From preference with implicit prompt to unpaired preference dataset",local:"from-preference-with-implicit-prompt-to-unpaired-preference-dataset",headingTag:"h3"}}),ps=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBleHRyYWN0X3Byb21wdCUyQyUyMHVucGFpcl9wcmVmZXJlbmNlX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2t5LiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlamVjdGVkJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGNvbG9yJTIwaXMlMjB0aGUlMjBza3klM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBncmVlbi4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGVyZSUyMGlzJTIwdGhlJTIwc3VuJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNlYS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0QpJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGV4dHJhY3RfcHJvbXB0KSUwQWRhdGFzZXQlMjAlM0QlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0KGRhdGFzZXQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> extract_prompt, unpair_preference_dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}, {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = dataset.<span class="hljs-built_in">map</span>(extract_prompt)
dataset = unpair_preference_dataset(dataset)`,wrap:!1}}),os=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),rs=new d({props:{title:"From preference to language modeling dataset",local:"from-preference-to-language-modeling-dataset",headingTag:"h3"}}),Ms=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRfcHJvbXB0X2Nob3NlbihleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnRleHQlMjIlM0ElMjBleGFtcGxlJTVCJTIycHJvbXB0JTIyJTVEJTIwJTJCJTIwZXhhbXBsZSU1QiUyMmNob3NlbiUyMiU1RCU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChjb25jYXRfcHJvbXB0X2Nob3NlbiUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIycHJvbXB0JTIyJTJDJTIwJTIyY2hvc2VuJTIyJTJDJTIwJTIycmVqZWN0ZWQlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_chosen</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;chosen&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_chosen, remove_columns=[<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),cs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),us=new d({props:{title:"From preference to prompt-completion dataset",local:"from-preference-to-prompt-completion-dataset",headingTag:"h3"}}),js=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglMjJyZWplY3RlZCUyMikucmVuYW1lX2NvbHVtbiglMjJjaG9zZW4lMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

dataset = dataset.remove_columns(<span class="hljs-string">&quot;rejected&quot;</span>).rename_column(<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>)`,wrap:!1}}),hs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; blue.&#x27;</span>}`,wrap:!1}}),ms=new d({props:{title:"From preference to prompt-only dataset",local:"from-preference-to-prompt-only-dataset",headingTag:"h3"}}),ds=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hvc2VuJTIyJTNBJTIwJTVCJTIyJTIwYmx1ZS4lMjIlMkMlMjAlMjIlMjBpbiUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSU3RCklMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5yZW1vdmVfY29sdW1ucyglNUIlMjJjaG9zZW4lMjIlMkMlMjAlMjJyZWplY3RlZCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;chosen&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>],
    <span class="hljs-string">&quot;rejected&quot;</span>: [<span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;chosen&quot;</span>, <span class="hljs-string">&quot;rejected&quot;</span>])`,wrap:!1}}),Us=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),Ts=new d({props:{title:"From explicit to implicit prompt preference dataset",local:"from-explicit-to-implicit-prompt-preference-dataset",headingTag:"h3"}}),Is=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwY29sb3IlMjBpcyUyMHRoZSUyMHNreSUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoZXJlJTIwaXMlMjB0aGUlMjBzdW4lM0YlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaG9zZW4lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBibHVlLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBza3kuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkl0JTIwaXMlMjBncmVlbi4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkluJTIwdGhlJTIwc2VhLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSU3RCklMEElMEFkZWYlMjBjb25jYXRfcHJvbXB0X3RvX2NvbXBsZXRpb25zKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyY2hvc2VuJTIyJTNBJTIwZXhhbXBsZSU1QiUyMnByb21wdCUyMiU1RCUyMCUyQiUyMGV4YW1wbGUlNUIlMjJjaG9zZW4lMjIlNUQlMkMlMjAlMjJyZWplY3RlZCUyMiUzQSUyMGV4YW1wbGUlNUIlMjJwcm9tcHQlMjIlNUQlMjAlMkIlMjBleGFtcGxlJTVCJTIycmVqZWN0ZWQlMjIlNUQlN0QlMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY29uY2F0X3Byb21wdF90b19jb21wbGV0aW9ucyUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTIycHJvbXB0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}],
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concat_prompt_to_completions</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;chosen&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;chosen&quot;</span>], <span class="hljs-string">&quot;rejected&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;rejected&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concat_prompt_to_completions, remove_columns=<span class="hljs-string">&quot;prompt&quot;</span>)`,wrap:!1}}),gs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;chosen&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;rejected&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}, {<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is green.&#x27;</span>}]}`,wrap:!1}}),ws=new d({props:{title:"From preference to unpaired preference dataset",local:"from-preference-to-unpaired-preference-dataset",headingTag:"h3"}}),bs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBjb2xvciUyMGlzJTIwdGhlJTIwc2t5JTNGJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hlcmUlMjBpcyUyMHRoZSUyMHN1biUzRiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGJsdWUuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJbiUyMHRoZSUyMHNreS4lMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJyZWplY3RlZCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySXQlMjBpcyUyMGdyZWVuLiUyMiU3RCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySW4lMjB0aGUlMjBzZWEuJTIyJTdEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjB1bnBhaXJfcHJlZmVyZW5jZV9kYXRhc2V0KGRhdGFzZXQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> unpair_preference_dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What color is the sky?&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Where is the sun?&quot;</span>}],
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is blue.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sky.&quot;</span>}],
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;It is green.&quot;</span>}],
        [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;In the sea.&quot;</span>}],
    ],
})

dataset = unpair_preference_dataset(dataset)`,wrap:!1}}),Cs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;What color is the sky?&#x27;</span>}],
 <span class="hljs-string">&#x27;completion&#x27;</span>: [{<span class="hljs-string">&#x27;role&#x27;</span>: <span class="hljs-string">&#x27;assistant&#x27;</span>, <span class="hljs-string">&#x27;content&#x27;</span>: <span class="hljs-string">&#x27;It is blue.&#x27;</span>}],
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-literal">True</span>}`,wrap:!1}}),$s=new d({props:{title:"From unpaired preference to language modeling dataset",local:"from-unpaired-preference-to-language-modeling-dataset",headingTag:"h3"}}),Ns=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRlZiUyMGNvbmNhdGVuYXRlX3Byb21wdF9jb21wbGV0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIydGV4dCUyMiUzQSUyMGV4YW1wbGUlNUIlMjJwcm9tcHQlMjIlNUQlMjAlMkIlMjBleGFtcGxlJTVCJTIyY29tcGxldGlvbiUyMiU1RCU3RCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChjb25jYXRlbmF0ZV9wcm9tcHRfY29tcGxldGlvbikucmVtb3ZlX2NvbHVtbnMoJTVCJTIycHJvbXB0JTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUyQyUyMCUyMmxhYmVsJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

<span class="hljs-keyword">def</span> <span class="hljs-title function_">concatenate_prompt_completion</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;text&quot;</span>: example[<span class="hljs-string">&quot;prompt&quot;</span>] + example[<span class="hljs-string">&quot;completion&quot;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(concatenate_prompt_completion).remove_columns([<span class="hljs-string">&quot;prompt&quot;</span>, <span class="hljs-string">&quot;completion&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),xs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;The sky is blue.&#x27;</span>}`,wrap:!1}}),Gs=new d({props:{title:"From unpaired preference to prompt-completion dataset",local:"from-unpaired-preference-to-prompt-completion-dataset",headingTag:"h3"}}),Zs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMmxhYmVsJTIyJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),ks=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>, <span class="hljs-string">&#x27;completion&#x27;</span>: <span class="hljs-string">&#x27; blue.&#x27;</span>}`,wrap:!1}}),vs=new d({props:{title:"From unpaired preference to prompt-only dataset",local:"from-unpaired-preference-to-prompt-only-dataset",headingTag:"h3"}}),Rs=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMEElMjAlMjAlMjAlMjAlMjJwcm9tcHQlMjIlM0ElMjAlNUIlMjJUaGUlMjBza3klMjBpcyUyMiUyQyUyMCUyMlRoZSUyMHN1biUyMGlzJTIyJTJDJTIwJTIyVGhlJTIwc2t5JTIwaXMlMjIlMkMlMjAlMjJUaGUlMjBzdW4lMjBpcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMjIlMjBibHVlLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2t5LiUyMiUyQyUyMCUyMiUyMGdyZWVuLiUyMiUyQyUyMCUyMiUyMGluJTIwdGhlJTIwc2VhLiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCVHJ1ZSUyQyUyMFRydWUlMkMlMjBGYWxzZSUyQyUyMEZhbHNlJTVEJTJDJTBBJTdEKSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCU1QiUyMmNvbXBsZXRpb24lMjIlMkMlMjAlMjJsYWJlbCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

dataset = Dataset.from_dict({
    <span class="hljs-string">&quot;prompt&quot;</span>: [<span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>, <span class="hljs-string">&quot;The sky is&quot;</span>, <span class="hljs-string">&quot;The sun is&quot;</span>],
    <span class="hljs-string">&quot;completion&quot;</span>: [<span class="hljs-string">&quot; blue.&quot;</span>, <span class="hljs-string">&quot; in the sky.&quot;</span>, <span class="hljs-string">&quot; green.&quot;</span>, <span class="hljs-string">&quot; in the sea.&quot;</span>],
    <span class="hljs-string">&quot;label&quot;</span>: [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>],
})

dataset = dataset.remove_columns([<span class="hljs-string">&quot;completion&quot;</span>, <span class="hljs-string">&quot;label&quot;</span>])`,wrap:!1}}),Xs=new h({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;prompt&#x27;</span>: <span class="hljs-string">&#x27;The sky is&#x27;</span>}`,wrap:!1}}),Vs=new rn({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/dataset_formats.mdx"}}),{c(){J=u("meta"),w=a(),U=u("p"),T=a(),p(g.$$.fragment),q=a(),f=u("p"),f.textContent=b,m=a(),p(I.$$.fragment),Ws=a(),k=u("p"),k.innerHTML=na,zs=a(),v=u("table"),v.innerHTML=pa,Ss=a(),p(A.$$.fragment),_s=a(),R=u("p"),R.textContent=oa,Fs=a(),p(X.$$.fragment),Ys=a(),p(V.$$.fragment),Hs=a(),E=u("p"),E.innerHTML=ra,Ls=a(),p(W.$$.fragment),Ds=a(),z=u("p"),z.innerHTML=ia,Ps=a(),p(S.$$.fragment),Ks=a(),_=u("p"),_.innerHTML=Ma,Os=a(),p(F.$$.fragment),te=a(),Y=u("p"),Y.innerHTML=ca,se=a(),p(H.$$.fragment),ee=a(),p(L.$$.fragment),le=a(),D=u("p"),D.innerHTML=ua,ae=a(),p(P.$$.fragment),ne=a(),p(x.$$.fragment),pe=a(),p(K.$$.fragment),oe=a(),O=u("p"),O.innerHTML=ya,re=a(),p(tt.$$.fragment),ie=a(),p(st.$$.fragment),Me=a(),et=u("p"),et.innerHTML=ja,ce=a(),p(lt.$$.fragment),ue=a(),p(at.$$.fragment),ye=a(),nt=u("p"),nt.innerHTML=ha,je=a(),p(pt.$$.fragment),he=a(),p(ot.$$.fragment),me=a(),rt=u("p"),rt.textContent=ma,Je=a(),it=u("table"),it.innerHTML=Ja,de=a(),p(G.$$.fragment),Ue=a(),p(Mt.$$.fragment),Te=a(),ct=u("p"),ct.innerHTML=da,qe=a(),p(ut.$$.fragment),Ie=a(),yt=u("p"),yt.textContent=Ua,ge=a(),jt=u("p"),jt.innerHTML=Ta,we=a(),ht=u("p"),ht.innerHTML=qa,fe=a(),p(mt.$$.fragment),be=a(),Jt=u("p"),Jt.innerHTML=Ia,Ce=a(),p(dt.$$.fragment),$e=a(),p(B.$$.fragment),Qe=a(),p(Z.$$.fragment),Ne=a(),p(Ut.$$.fragment),xe=a(),Tt=u("p"),Tt.textContent=ga,Ge=a(),qt=u("p"),qt.innerHTML=wa,Be=a(),p(It.$$.fragment),Ze=a(),gt=u("p"),gt.innerHTML=fa,ke=a(),$=u("iframe"),ve=a(),wt=u("p"),wt.textContent=Ca,Ae=a(),ft=u("p"),ft.innerHTML=$a,Re=a(),p(bt.$$.fragment),Xe=a(),Ct=u("p"),Ct.textContent=Qa,Ve=a(),Q=u("iframe"),Ee=a(),$t=u("p"),$t.textContent=xa,We=a(),Qt=u("p"),Qt.textContent=Ga,ze=a(),p(Nt.$$.fragment),Se=a(),xt=u("p"),xt.textContent=Ba,_e=a(),Gt=u("p"),Gt.textContent=Za,Fe=a(),Bt=u("table"),Bt.innerHTML=ka,Ye=a(),p(Zt.$$.fragment),He=a(),kt=u("p"),kt.textContent=va,Le=a(),p(vt.$$.fragment),De=a(),p(At.$$.fragment),Pe=a(),p(Rt.$$.fragment),Ke=a(),Xt=u("p"),Xt.textContent=Aa,Oe=a(),p(Vt.$$.fragment),tl=a(),p(Et.$$.fragment),sl=a(),p(Wt.$$.fragment),el=a(),zt=u("p"),zt.innerHTML=Ra,ll=a(),p(St.$$.fragment),al=a(),p(_t.$$.fragment),nl=a(),p(Ft.$$.fragment),pl=a(),Yt=u("p"),Yt.innerHTML=Xa,ol=a(),p(Ht.$$.fragment),rl=a(),p(Lt.$$.fragment),il=a(),p(Dt.$$.fragment),Ml=a(),Pt=u("p"),Pt.innerHTML=Va,cl=a(),p(Kt.$$.fragment),ul=a(),p(Ot.$$.fragment),yl=a(),p(ts.$$.fragment),jl=a(),ss=u("p"),ss.innerHTML=Ea,hl=a(),p(es.$$.fragment),ml=a(),p(ls.$$.fragment),Jl=a(),p(as.$$.fragment),dl=a(),ns=u("p"),ns.innerHTML=Wa,Ul=a(),p(ps.$$.fragment),Tl=a(),p(os.$$.fragment),ql=a(),p(rs.$$.fragment),Il=a(),is=u("p"),is.innerHTML=za,gl=a(),p(Ms.$$.fragment),wl=a(),p(cs.$$.fragment),fl=a(),p(us.$$.fragment),bl=a(),ys=u("p"),ys.innerHTML=Sa,Cl=a(),p(js.$$.fragment),$l=a(),p(hs.$$.fragment),Ql=a(),p(ms.$$.fragment),Nl=a(),Js=u("p"),Js.textContent=_a,xl=a(),p(ds.$$.fragment),Gl=a(),p(Us.$$.fragment),Bl=a(),p(Ts.$$.fragment),Zl=a(),qs=u("p"),qs.textContent=Fa,kl=a(),p(Is.$$.fragment),vl=a(),p(gs.$$.fragment),Al=a(),p(ws.$$.fragment),Rl=a(),fs=u("p"),fs.innerHTML=Ya,Xl=a(),p(bs.$$.fragment),Vl=a(),p(Cs.$$.fragment),El=a(),p($s.$$.fragment),Wl=a(),Qs=u("p"),Qs.innerHTML=Ha,zl=a(),p(Ns.$$.fragment),Sl=a(),p(xs.$$.fragment),_l=a(),p(Gs.$$.fragment),Fl=a(),Bs=u("p"),Bs.textContent=La,Yl=a(),p(Zs.$$.fragment),Hl=a(),p(ks.$$.fragment),Ll=a(),p(vs.$$.fragment),Dl=a(),As=u("p"),As.textContent=Da,Pl=a(),p(Rs.$$.fragment),Kl=a(),p(Xs.$$.fragment),Ol=a(),p(Vs.$$.fragment),ta=a(),Es=u("p"),this.h()},l(t){const s=pn("svelte-u9bgzb",document.head);J=y(s,"META",{name:!0,content:!0}),s.forEach(e),w=n(t),U=y(t,"P",{}),ea(U).forEach(e),T=n(t),o(g.$$.fragment,t),q=n(t),f=y(t,"P",{"data-svelte-h":!0}),j(f)!=="svelte-1cdvhur"&&(f.textContent=b),m=n(t),o(I.$$.fragment,t),Ws=n(t),k=y(t,"P",{"data-svelte-h":!0}),j(k)!=="svelte-qkvrpa"&&(k.innerHTML=na),zs=n(t),v=y(t,"TABLE",{"data-svelte-h":!0}),j(v)!=="svelte-1fmpsgr"&&(v.innerHTML=pa),Ss=n(t),o(A.$$.fragment,t),_s=n(t),R=y(t,"P",{"data-svelte-h":!0}),j(R)!=="svelte-n22pbc"&&(R.textContent=oa),Fs=n(t),o(X.$$.fragment,t),Ys=n(t),o(V.$$.fragment,t),Hs=n(t),E=y(t,"P",{"data-svelte-h":!0}),j(E)!=="svelte-ftn6so"&&(E.innerHTML=ra),Ls=n(t),o(W.$$.fragment,t),Ds=n(t),z=y(t,"P",{"data-svelte-h":!0}),j(z)!=="svelte-49qzt0"&&(z.innerHTML=ia),Ps=n(t),o(S.$$.fragment,t),Ks=n(t),_=y(t,"P",{"data-svelte-h":!0}),j(_)!=="svelte-1de5sg2"&&(_.innerHTML=Ma),Os=n(t),o(F.$$.fragment,t),te=n(t),Y=y(t,"P",{"data-svelte-h":!0}),j(Y)!=="svelte-zfzona"&&(Y.innerHTML=ca),se=n(t),o(H.$$.fragment,t),ee=n(t),o(L.$$.fragment,t),le=n(t),D=y(t,"P",{"data-svelte-h":!0}),j(D)!=="svelte-1fi7big"&&(D.innerHTML=ua),ae=n(t),o(P.$$.fragment,t),ne=n(t),o(x.$$.fragment,t),pe=n(t),o(K.$$.fragment,t),oe=n(t),O=y(t,"P",{"data-svelte-h":!0}),j(O)!=="svelte-1qh8h3u"&&(O.innerHTML=ya),re=n(t),o(tt.$$.fragment,t),ie=n(t),o(st.$$.fragment,t),Me=n(t),et=y(t,"P",{"data-svelte-h":!0}),j(et)!=="svelte-fpgtkb"&&(et.innerHTML=ja),ce=n(t),o(lt.$$.fragment,t),ue=n(t),o(at.$$.fragment,t),ye=n(t),nt=y(t,"P",{"data-svelte-h":!0}),j(nt)!=="svelte-ds3631"&&(nt.innerHTML=ha),je=n(t),o(pt.$$.fragment,t),he=n(t),o(ot.$$.fragment,t),me=n(t),rt=y(t,"P",{"data-svelte-h":!0}),j(rt)!=="svelte-v9e841"&&(rt.textContent=ma),Je=n(t),it=y(t,"TABLE",{"data-svelte-h":!0}),j(it)!=="svelte-1dyz5ye"&&(it.innerHTML=Ja),de=n(t),o(G.$$.fragment,t),Ue=n(t),o(Mt.$$.fragment,t),Te=n(t),ct=y(t,"P",{"data-svelte-h":!0}),j(ct)!=="svelte-90pnhf"&&(ct.innerHTML=da),qe=n(t),o(ut.$$.fragment,t),Ie=n(t),yt=y(t,"P",{"data-svelte-h":!0}),j(yt)!=="svelte-1gfjzu"&&(yt.textContent=Ua),ge=n(t),jt=y(t,"P",{"data-svelte-h":!0}),j(jt)!=="svelte-19t1v1h"&&(jt.innerHTML=Ta),we=n(t),ht=y(t,"P",{"data-svelte-h":!0}),j(ht)!=="svelte-1hxwl6y"&&(ht.innerHTML=qa),fe=n(t),o(mt.$$.fragment,t),be=n(t),Jt=y(t,"P",{"data-svelte-h":!0}),j(Jt)!=="svelte-2l88cs"&&(Jt.innerHTML=Ia),Ce=n(t),o(dt.$$.fragment,t),$e=n(t),o(B.$$.fragment,t),Qe=n(t),o(Z.$$.fragment,t),Ne=n(t),o(Ut.$$.fragment,t),xe=n(t),Tt=y(t,"P",{"data-svelte-h":!0}),j(Tt)!=="svelte-n0cp2u"&&(Tt.textContent=ga),Ge=n(t),qt=y(t,"P",{"data-svelte-h":!0}),j(qt)!=="svelte-wbjjp8"&&(qt.innerHTML=wa),Be=n(t),o(It.$$.fragment,t),Ze=n(t),gt=y(t,"P",{"data-svelte-h":!0}),j(gt)!=="svelte-dr0jz6"&&(gt.innerHTML=fa),ke=n(t),$=y(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),ea($).forEach(e),ve=n(t),wt=y(t,"P",{"data-svelte-h":!0}),j(wt)!=="svelte-1f6n8q4"&&(wt.textContent=Ca),Ae=n(t),ft=y(t,"P",{"data-svelte-h":!0}),j(ft)!=="svelte-1ark4sy"&&(ft.innerHTML=$a),Re=n(t),o(bt.$$.fragment,t),Xe=n(t),Ct=y(t,"P",{"data-svelte-h":!0}),j(Ct)!=="svelte-hplhuu"&&(Ct.textContent=Qa),Ve=n(t),Q=y(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),ea(Q).forEach(e),Ee=n(t),$t=y(t,"P",{"data-svelte-h":!0}),j($t)!=="svelte-jt9cd3"&&($t.textContent=xa),We=n(t),Qt=y(t,"P",{"data-svelte-h":!0}),j(Qt)!=="svelte-1rvlfj0"&&(Qt.textContent=Ga),ze=n(t),o(Nt.$$.fragment,t),Se=n(t),xt=y(t,"P",{"data-svelte-h":!0}),j(xt)!=="svelte-1ttdd1s"&&(xt.textContent=Ba),_e=n(t),Gt=y(t,"P",{"data-svelte-h":!0}),j(Gt)!=="svelte-17l70ga"&&(Gt.textContent=Za),Fe=n(t),Bt=y(t,"TABLE",{"data-svelte-h":!0}),j(Bt)!=="svelte-1a5ldcp"&&(Bt.innerHTML=ka),Ye=n(t),o(Zt.$$.fragment,t),He=n(t),kt=y(t,"P",{"data-svelte-h":!0}),j(kt)!=="svelte-q88m1s"&&(kt.textContent=va),Le=n(t),o(vt.$$.fragment,t),De=n(t),o(At.$$.fragment,t),Pe=n(t),o(Rt.$$.fragment,t),Ke=n(t),Xt=y(t,"P",{"data-svelte-h":!0}),j(Xt)!=="svelte-dplhkb"&&(Xt.textContent=Aa),Oe=n(t),o(Vt.$$.fragment,t),tl=n(t),o(Et.$$.fragment,t),sl=n(t),o(Wt.$$.fragment,t),el=n(t),zt=y(t,"P",{"data-svelte-h":!0}),j(zt)!=="svelte-u8pmva"&&(zt.innerHTML=Ra),ll=n(t),o(St.$$.fragment,t),al=n(t),o(_t.$$.fragment,t),nl=n(t),o(Ft.$$.fragment,t),pl=n(t),Yt=y(t,"P",{"data-svelte-h":!0}),j(Yt)!=="svelte-rycq14"&&(Yt.innerHTML=Xa),ol=n(t),o(Ht.$$.fragment,t),rl=n(t),o(Lt.$$.fragment,t),il=n(t),o(Dt.$$.fragment,t),Ml=n(t),Pt=y(t,"P",{"data-svelte-h":!0}),j(Pt)!=="svelte-1l1iyb6"&&(Pt.innerHTML=Va),cl=n(t),o(Kt.$$.fragment,t),ul=n(t),o(Ot.$$.fragment,t),yl=n(t),o(ts.$$.fragment,t),jl=n(t),ss=y(t,"P",{"data-svelte-h":!0}),j(ss)!=="svelte-108kzl6"&&(ss.innerHTML=Ea),hl=n(t),o(es.$$.fragment,t),ml=n(t),o(ls.$$.fragment,t),Jl=n(t),o(as.$$.fragment,t),dl=n(t),ns=y(t,"P",{"data-svelte-h":!0}),j(ns)!=="svelte-14j7q72"&&(ns.innerHTML=Wa),Ul=n(t),o(ps.$$.fragment,t),Tl=n(t),o(os.$$.fragment,t),ql=n(t),o(rs.$$.fragment,t),Il=n(t),is=y(t,"P",{"data-svelte-h":!0}),j(is)!=="svelte-1azgh8u"&&(is.innerHTML=za),gl=n(t),o(Ms.$$.fragment,t),wl=n(t),o(cs.$$.fragment,t),fl=n(t),o(us.$$.fragment,t),bl=n(t),ys=y(t,"P",{"data-svelte-h":!0}),j(ys)!=="svelte-thhn9e"&&(ys.innerHTML=Sa),Cl=n(t),o(js.$$.fragment,t),$l=n(t),o(hs.$$.fragment,t),Ql=n(t),o(ms.$$.fragment,t),Nl=n(t),Js=y(t,"P",{"data-svelte-h":!0}),j(Js)!=="svelte-yu2uu5"&&(Js.textContent=_a),xl=n(t),o(ds.$$.fragment,t),Gl=n(t),o(Us.$$.fragment,t),Bl=n(t),o(Ts.$$.fragment,t),Zl=n(t),qs=y(t,"P",{"data-svelte-h":!0}),j(qs)!=="svelte-1nt2p6s"&&(qs.textContent=Fa),kl=n(t),o(Is.$$.fragment,t),vl=n(t),o(gs.$$.fragment,t),Al=n(t),o(ws.$$.fragment,t),Rl=n(t),fs=y(t,"P",{"data-svelte-h":!0}),j(fs)!=="svelte-1nm5ln"&&(fs.innerHTML=Ya),Xl=n(t),o(bs.$$.fragment,t),Vl=n(t),o(Cs.$$.fragment,t),El=n(t),o($s.$$.fragment,t),Wl=n(t),Qs=y(t,"P",{"data-svelte-h":!0}),j(Qs)!=="svelte-jxvlnn"&&(Qs.innerHTML=Ha),zl=n(t),o(Ns.$$.fragment,t),Sl=n(t),o(xs.$$.fragment,t),_l=n(t),o(Gs.$$.fragment,t),Fl=n(t),Bs=y(t,"P",{"data-svelte-h":!0}),j(Bs)!=="svelte-1gh6vos"&&(Bs.textContent=La),Yl=n(t),o(Zs.$$.fragment,t),Hl=n(t),o(ks.$$.fragment,t),Ll=n(t),o(vs.$$.fragment,t),Dl=n(t),As=y(t,"P",{"data-svelte-h":!0}),j(As)!=="svelte-1x58tju"&&(As.textContent=Da),Pl=n(t),o(Rs.$$.fragment,t),Kl=n(t),o(Xs.$$.fragment,t),Ol=n(t),o(Vs.$$.fragment,t),ta=n(t),Es=y(t,"P",{}),ea(Es).forEach(e),this.h()},h(){N(J,"name","hf:doc:metadata"),N(J,"content",hn),sn($.src,ba="https://huggingface.co/datasets/openbmb/UltraFeedback/embed/viewer/default/train")||N($,"src",ba),N($,"frameborder","0"),N($,"width","100%"),N($,"height","560px"),sn(Q.src,Na="https://huggingface.co/datasets/trl-lib/ultrafeedback-gpt-3.5-turbo-helpfulness/embed/viewer/default/train?row=0")||N(Q,"src",Na),N(Q,"frameborder","0"),N(Q,"width","100%"),N(Q,"height","560px")},m(t,s){on(document.head,J),l(t,w,s),l(t,U,s),l(t,T,s),r(g,t,s),l(t,q,s),l(t,f,s),l(t,m,s),r(I,t,s),l(t,Ws,s),l(t,k,s),l(t,zs,s),l(t,v,s),l(t,Ss,s),r(A,t,s),l(t,_s,s),l(t,R,s),l(t,Fs,s),r(X,t,s),l(t,Ys,s),r(V,t,s),l(t,Hs,s),l(t,E,s),l(t,Ls,s),r(W,t,s),l(t,Ds,s),l(t,z,s),l(t,Ps,s),r(S,t,s),l(t,Ks,s),l(t,_,s),l(t,Os,s),r(F,t,s),l(t,te,s),l(t,Y,s),l(t,se,s),r(H,t,s),l(t,ee,s),r(L,t,s),l(t,le,s),l(t,D,s),l(t,ae,s),r(P,t,s),l(t,ne,s),r(x,t,s),l(t,pe,s),r(K,t,s),l(t,oe,s),l(t,O,s),l(t,re,s),r(tt,t,s),l(t,ie,s),r(st,t,s),l(t,Me,s),l(t,et,s),l(t,ce,s),r(lt,t,s),l(t,ue,s),r(at,t,s),l(t,ye,s),l(t,nt,s),l(t,je,s),r(pt,t,s),l(t,he,s),r(ot,t,s),l(t,me,s),l(t,rt,s),l(t,Je,s),l(t,it,s),l(t,de,s),r(G,t,s),l(t,Ue,s),r(Mt,t,s),l(t,Te,s),l(t,ct,s),l(t,qe,s),r(ut,t,s),l(t,Ie,s),l(t,yt,s),l(t,ge,s),l(t,jt,s),l(t,we,s),l(t,ht,s),l(t,fe,s),r(mt,t,s),l(t,be,s),l(t,Jt,s),l(t,Ce,s),r(dt,t,s),l(t,$e,s),r(B,t,s),l(t,Qe,s),r(Z,t,s),l(t,Ne,s),r(Ut,t,s),l(t,xe,s),l(t,Tt,s),l(t,Ge,s),l(t,qt,s),l(t,Be,s),r(It,t,s),l(t,Ze,s),l(t,gt,s),l(t,ke,s),l(t,$,s),l(t,ve,s),l(t,wt,s),l(t,Ae,s),l(t,ft,s),l(t,Re,s),r(bt,t,s),l(t,Xe,s),l(t,Ct,s),l(t,Ve,s),l(t,Q,s),l(t,Ee,s),l(t,$t,s),l(t,We,s),l(t,Qt,s),l(t,ze,s),r(Nt,t,s),l(t,Se,s),l(t,xt,s),l(t,_e,s),l(t,Gt,s),l(t,Fe,s),l(t,Bt,s),l(t,Ye,s),r(Zt,t,s),l(t,He,s),l(t,kt,s),l(t,Le,s),r(vt,t,s),l(t,De,s),r(At,t,s),l(t,Pe,s),r(Rt,t,s),l(t,Ke,s),l(t,Xt,s),l(t,Oe,s),r(Vt,t,s),l(t,tl,s),r(Et,t,s),l(t,sl,s),r(Wt,t,s),l(t,el,s),l(t,zt,s),l(t,ll,s),r(St,t,s),l(t,al,s),r(_t,t,s),l(t,nl,s),r(Ft,t,s),l(t,pl,s),l(t,Yt,s),l(t,ol,s),r(Ht,t,s),l(t,rl,s),r(Lt,t,s),l(t,il,s),r(Dt,t,s),l(t,Ml,s),l(t,Pt,s),l(t,cl,s),r(Kt,t,s),l(t,ul,s),r(Ot,t,s),l(t,yl,s),r(ts,t,s),l(t,jl,s),l(t,ss,s),l(t,hl,s),r(es,t,s),l(t,ml,s),r(ls,t,s),l(t,Jl,s),r(as,t,s),l(t,dl,s),l(t,ns,s),l(t,Ul,s),r(ps,t,s),l(t,Tl,s),r(os,t,s),l(t,ql,s),r(rs,t,s),l(t,Il,s),l(t,is,s),l(t,gl,s),r(Ms,t,s),l(t,wl,s),r(cs,t,s),l(t,fl,s),r(us,t,s),l(t,bl,s),l(t,ys,s),l(t,Cl,s),r(js,t,s),l(t,$l,s),r(hs,t,s),l(t,Ql,s),r(ms,t,s),l(t,Nl,s),l(t,Js,s),l(t,xl,s),r(ds,t,s),l(t,Gl,s),r(Us,t,s),l(t,Bl,s),r(Ts,t,s),l(t,Zl,s),l(t,qs,s),l(t,kl,s),r(Is,t,s),l(t,vl,s),r(gs,t,s),l(t,Al,s),r(ws,t,s),l(t,Rl,s),l(t,fs,s),l(t,Xl,s),r(bs,t,s),l(t,Vl,s),r(Cs,t,s),l(t,El,s),r($s,t,s),l(t,Wl,s),l(t,Qs,s),l(t,zl,s),r(Ns,t,s),l(t,Sl,s),r(xs,t,s),l(t,_l,s),r(Gs,t,s),l(t,Fl,s),l(t,Bs,s),l(t,Yl,s),r(Zs,t,s),l(t,Hl,s),r(ks,t,s),l(t,Ll,s),r(vs,t,s),l(t,Dl,s),l(t,As,s),l(t,Pl,s),r(Rs,t,s),l(t,Kl,s),r(Xs,t,s),l(t,Ol,s),r(Vs,t,s),l(t,ta,s),l(t,Es,s),sa=!0},p(t,[s]){const Pa={};s&2&&(Pa.$$scope={dirty:s,ctx:t}),x.$set(Pa);const Ka={};s&2&&(Ka.$$scope={dirty:s,ctx:t}),G.$set(Ka);const Oa={};s&2&&(Oa.$$scope={dirty:s,ctx:t}),B.$set(Oa);const tn={};s&2&&(tn.$$scope={dirty:s,ctx:t}),Z.$set(tn)},i(t){sa||(i(g.$$.fragment,t),i(I.$$.fragment,t),i(A.$$.fragment,t),i(X.$$.fragment,t),i(V.$$.fragment,t),i(W.$$.fragment,t),i(S.$$.fragment,t),i(F.$$.fragment,t),i(H.$$.fragment,t),i(L.$$.fragment,t),i(P.$$.fragment,t),i(x.$$.fragment,t),i(K.$$.fragment,t),i(tt.$$.fragment,t),i(st.$$.fragment,t),i(lt.$$.fragment,t),i(at.$$.fragment,t),i(pt.$$.fragment,t),i(ot.$$.fragment,t),i(G.$$.fragment,t),i(Mt.$$.fragment,t),i(ut.$$.fragment,t),i(mt.$$.fragment,t),i(dt.$$.fragment,t),i(B.$$.fragment,t),i(Z.$$.fragment,t),i(Ut.$$.fragment,t),i(It.$$.fragment,t),i(bt.$$.fragment,t),i(Nt.$$.fragment,t),i(Zt.$$.fragment,t),i(vt.$$.fragment,t),i(At.$$.fragment,t),i(Rt.$$.fragment,t),i(Vt.$$.fragment,t),i(Et.$$.fragment,t),i(Wt.$$.fragment,t),i(St.$$.fragment,t),i(_t.$$.fragment,t),i(Ft.$$.fragment,t),i(Ht.$$.fragment,t),i(Lt.$$.fragment,t),i(Dt.$$.fragment,t),i(Kt.$$.fragment,t),i(Ot.$$.fragment,t),i(ts.$$.fragment,t),i(es.$$.fragment,t),i(ls.$$.fragment,t),i(as.$$.fragment,t),i(ps.$$.fragment,t),i(os.$$.fragment,t),i(rs.$$.fragment,t),i(Ms.$$.fragment,t),i(cs.$$.fragment,t),i(us.$$.fragment,t),i(js.$$.fragment,t),i(hs.$$.fragment,t),i(ms.$$.fragment,t),i(ds.$$.fragment,t),i(Us.$$.fragment,t),i(Ts.$$.fragment,t),i(Is.$$.fragment,t),i(gs.$$.fragment,t),i(ws.$$.fragment,t),i(bs.$$.fragment,t),i(Cs.$$.fragment,t),i($s.$$.fragment,t),i(Ns.$$.fragment,t),i(xs.$$.fragment,t),i(Gs.$$.fragment,t),i(Zs.$$.fragment,t),i(ks.$$.fragment,t),i(vs.$$.fragment,t),i(Rs.$$.fragment,t),i(Xs.$$.fragment,t),i(Vs.$$.fragment,t),sa=!0)},o(t){M(g.$$.fragment,t),M(I.$$.fragment,t),M(A.$$.fragment,t),M(X.$$.fragment,t),M(V.$$.fragment,t),M(W.$$.fragment,t),M(S.$$.fragment,t),M(F.$$.fragment,t),M(H.$$.fragment,t),M(L.$$.fragment,t),M(P.$$.fragment,t),M(x.$$.fragment,t),M(K.$$.fragment,t),M(tt.$$.fragment,t),M(st.$$.fragment,t),M(lt.$$.fragment,t),M(at.$$.fragment,t),M(pt.$$.fragment,t),M(ot.$$.fragment,t),M(G.$$.fragment,t),M(Mt.$$.fragment,t),M(ut.$$.fragment,t),M(mt.$$.fragment,t),M(dt.$$.fragment,t),M(B.$$.fragment,t),M(Z.$$.fragment,t),M(Ut.$$.fragment,t),M(It.$$.fragment,t),M(bt.$$.fragment,t),M(Nt.$$.fragment,t),M(Zt.$$.fragment,t),M(vt.$$.fragment,t),M(At.$$.fragment,t),M(Rt.$$.fragment,t),M(Vt.$$.fragment,t),M(Et.$$.fragment,t),M(Wt.$$.fragment,t),M(St.$$.fragment,t),M(_t.$$.fragment,t),M(Ft.$$.fragment,t),M(Ht.$$.fragment,t),M(Lt.$$.fragment,t),M(Dt.$$.fragment,t),M(Kt.$$.fragment,t),M(Ot.$$.fragment,t),M(ts.$$.fragment,t),M(es.$$.fragment,t),M(ls.$$.fragment,t),M(as.$$.fragment,t),M(ps.$$.fragment,t),M(os.$$.fragment,t),M(rs.$$.fragment,t),M(Ms.$$.fragment,t),M(cs.$$.fragment,t),M(us.$$.fragment,t),M(js.$$.fragment,t),M(hs.$$.fragment,t),M(ms.$$.fragment,t),M(ds.$$.fragment,t),M(Us.$$.fragment,t),M(Ts.$$.fragment,t),M(Is.$$.fragment,t),M(gs.$$.fragment,t),M(ws.$$.fragment,t),M(bs.$$.fragment,t),M(Cs.$$.fragment,t),M($s.$$.fragment,t),M(Ns.$$.fragment,t),M(xs.$$.fragment,t),M(Gs.$$.fragment,t),M(Zs.$$.fragment,t),M(ks.$$.fragment,t),M(vs.$$.fragment,t),M(Rs.$$.fragment,t),M(Xs.$$.fragment,t),M(Vs.$$.fragment,t),sa=!1},d(t){t&&(e(w),e(U),e(T),e(q),e(f),e(m),e(Ws),e(k),e(zs),e(v),e(Ss),e(_s),e(R),e(Fs),e(Ys),e(Hs),e(E),e(Ls),e(Ds),e(z),e(Ps),e(Ks),e(_),e(Os),e(te),e(Y),e(se),e(ee),e(le),e(D),e(ae),e(ne),e(pe),e(oe),e(O),e(re),e(ie),e(Me),e(et),e(ce),e(ue),e(ye),e(nt),e(je),e(he),e(me),e(rt),e(Je),e(it),e(de),e(Ue),e(Te),e(ct),e(qe),e(Ie),e(yt),e(ge),e(jt),e(we),e(ht),e(fe),e(be),e(Jt),e(Ce),e($e),e(Qe),e(Ne),e(xe),e(Tt),e(Ge),e(qt),e(Be),e(Ze),e(gt),e(ke),e($),e(ve),e(wt),e(Ae),e(ft),e(Re),e(Xe),e(Ct),e(Ve),e(Q),e(Ee),e($t),e(We),e(Qt),e(ze),e(Se),e(xt),e(_e),e(Gt),e(Fe),e(Bt),e(Ye),e(He),e(kt),e(Le),e(De),e(Pe),e(Ke),e(Xt),e(Oe),e(tl),e(sl),e(el),e(zt),e(ll),e(al),e(nl),e(pl),e(Yt),e(ol),e(rl),e(il),e(Ml),e(Pt),e(cl),e(ul),e(yl),e(jl),e(ss),e(hl),e(ml),e(Jl),e(dl),e(ns),e(Ul),e(Tl),e(ql),e(Il),e(is),e(gl),e(wl),e(fl),e(bl),e(ys),e(Cl),e($l),e(Ql),e(Nl),e(Js),e(xl),e(Gl),e(Bl),e(Zl),e(qs),e(kl),e(vl),e(Al),e(Rl),e(fs),e(Xl),e(Vl),e(El),e(Wl),e(Qs),e(zl),e(Sl),e(_l),e(Fl),e(Bs),e(Yl),e(Hl),e(Ll),e(Dl),e(As),e(Pl),e(Kl),e(Ol),e(ta),e(Es)),e(J),c(g,t),c(I,t),c(A,t),c(X,t),c(V,t),c(W,t),c(S,t),c(F,t),c(H,t),c(L,t),c(P,t),c(x,t),c(K,t),c(tt,t),c(st,t),c(lt,t),c(at,t),c(pt,t),c(ot,t),c(G,t),c(Mt,t),c(ut,t),c(mt,t),c(dt,t),c(B,t),c(Z,t),c(Ut,t),c(It,t),c(bt,t),c(Nt,t),c(Zt,t),c(vt,t),c(At,t),c(Rt,t),c(Vt,t),c(Et,t),c(Wt,t),c(St,t),c(_t,t),c(Ft,t),c(Ht,t),c(Lt,t),c(Dt,t),c(Kt,t),c(Ot,t),c(ts,t),c(es,t),c(ls,t),c(as,t),c(ps,t),c(os,t),c(rs,t),c(Ms,t),c(cs,t),c(us,t),c(js,t),c(hs,t),c(ms,t),c(ds,t),c(Us,t),c(Ts,t),c(Is,t),c(gs,t),c(ws,t),c(bs,t),c(Cs,t),c($s,t),c(Ns,t),c(xs,t),c(Gs,t),c(Zs,t),c(ks,t),c(vs,t),c(Rs,t),c(Xs,t),c(Vs,t)}}}const hn='{"title":"Dataset formats","local":"dataset-formats","sections":[{"title":"Overview of the dataset formats and types","local":"overview-of-the-dataset-formats-and-types","sections":[{"title":"Standard dataset format","local":"standard-dataset-format","sections":[],"depth":3},{"title":"Conversational dataset format","local":"conversational-dataset-format","sections":[],"depth":3},{"title":"Language modeling","local":"language-modeling","sections":[],"depth":3},{"title":"Prompt-only","local":"prompt-only","sections":[],"depth":3},{"title":"Prompt-completion","local":"prompt-completion","sections":[],"depth":3},{"title":"Preference","local":"preference","sections":[],"depth":3},{"title":"Unpaired preference","local":"unpaired-preference","sections":[],"depth":3}],"depth":2},{"title":"Which dataset format to use?","local":"which-dataset-format-to-use","sections":[],"depth":2},{"title":"Working with conversational datasets in TRL","local":"working-with-conversational-datasets-in-trl","sections":[{"title":"Converting a conversational dataset into a standard dataset","local":"converting-a-conversational-dataset-into-a-standard-dataset","sections":[],"depth":3}],"depth":2},{"title":"Using any dataset with TRL: preprocessing and conversion","local":"using-any-dataset-with-trl-preprocessing-and-conversion","sections":[{"title":"Example: UltraFeedback dataset","local":"example-ultrafeedback-dataset","sections":[],"depth":3}],"depth":2},{"title":"Utilities for converting dataset types","local":"utilities-for-converting-dataset-types","sections":[{"title":"From prompt-completion to language modeling dataset","local":"from-prompt-completion-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From prompt-completion to prompt-only dataset","local":"from-prompt-completion-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to language modeling dataset","local":"from-preference-with-implicit-prompt-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to prompt-completion dataset","local":"from-preference-with-implicit-prompt-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to prompt-only dataset","local":"from-preference-with-implicit-prompt-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From implicit to explicit prompt preference dataset","local":"from-implicit-to-explicit-prompt-preference-dataset","sections":[],"depth":3},{"title":"From preference with implicit prompt to unpaired preference dataset","local":"from-preference-with-implicit-prompt-to-unpaired-preference-dataset","sections":[],"depth":3},{"title":"From preference to language modeling dataset","local":"from-preference-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From preference to prompt-completion dataset","local":"from-preference-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From preference to prompt-only dataset","local":"from-preference-to-prompt-only-dataset","sections":[],"depth":3},{"title":"From explicit to implicit prompt preference dataset","local":"from-explicit-to-implicit-prompt-preference-dataset","sections":[],"depth":3},{"title":"From preference to unpaired preference dataset","local":"from-preference-to-unpaired-preference-dataset","sections":[],"depth":3},{"title":"From unpaired preference to language modeling dataset","local":"from-unpaired-preference-to-language-modeling-dataset","sections":[],"depth":3},{"title":"From unpaired preference to prompt-completion dataset","local":"from-unpaired-preference-to-prompt-completion-dataset","sections":[],"depth":3},{"title":"From unpaired preference to prompt-only dataset","local":"from-unpaired-preference-to-prompt-only-dataset","sections":[],"depth":3}],"depth":2}],"depth":1}';function mn(C){return ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class In extends an{constructor(J){super(),nn(this,J,mn,jn,en,{})}}export{In as component};
