import{s as gi,o as ui,n as V}from"../chunks/scheduler.8c3d61f6.js";import{S as fi,i as hi,g as i,s as o,r as c,A as _i,h as p,f as n,c as s,j as J,u as m,x as b,k as T,y as a,a as l,v as g,d as u,t as f,w as h,m as bi,n as yi}from"../chunks/index.da70eac4.js";import{T as wa}from"../chunks/Tip.1d9b8c37.js";import{D as I}from"../chunks/Docstring.567bc132.js";import{C as U}from"../chunks/CodeBlock.a9c4becf.js";import{E as le}from"../chunks/ExampleCodeBlock.15b54358.js";import{H as j,E as Mi}from"../chunks/index.5d4ab994.js";function xi(v){let d,x='Flux can be quite expensive to run on consumer hardware devices. However, you can perform a suite of optimizations to run it faster and in a more memory-friendly manner. Check out <a href="https://huggingface.co/blog/sd3#memory-optimizations-for-sd3" rel="nofollow">this section</a> for more details. Additionally, Flux can benefit from quantization for memory efficiency with a trade-off in inference latency. Refer to <a href="https://huggingface.co/blog/quanto-diffusers" rel="nofollow">this blog post</a> to learn more.  For an exhaustive list of resources, check out <a href="https://gist.github.com/sayakpaul/b664605caf0aa3bf8585ab109dd5ac9c" rel="nofollow">this gist</a>.';return{c(){d=i("p"),d.innerHTML=x},l(y){d=p(y,"P",{"data-svelte-h":!0}),b(d)!=="svelte-1nl2vrj"&&(d.innerHTML=x)},m(y,_){l(y,d,_)},p:V,d(y){y&&n(d)}}}function wi(v){let d,x='Check out <a href="../../../using-diffusers/ip_adapter">IP-Adapter</a> to learn more about how IP-Adapters work.';return{c(){d=i("p"),d.innerHTML=x},l(y){d=p(y,"P",{"data-svelte-h":!0}),b(d)!=="svelte-1xq17cf"&&(d.innerHTML=x)},m(y,_){l(y,d,_)},p:V,d(y){y&&n(d)}}}function Ti(v){let d,x="It is possible to mix block and leaf-level offloading for different components in a pipeline.";return{c(){d=i("p"),d.textContent=x},l(y){d=p(y,"P",{"data-svelte-h":!0}),b(d)!=="svelte-5ifmld"&&(d.textContent=x)},m(y,_){l(y,d,_)},p:V,d(y){y&&n(d)}}}function Ji(v){let d;return{c(){d=bi("`FP8` inference can be brittle depending on the GPU type, CUDA version, and `torch` version that you are using. It is recommended that you use the `optimum-quanto` library in order to run FP8 inference on your machine.")},l(x){d=yi(x,"`FP8` inference can be brittle depending on the GPU type, CUDA version, and `torch` version that you are using. It is recommended that you use the `optimum-quanto` library in order to run FP8 inference on your machine.")},m(x,y){l(x,d,y)},d(x){x&&n(d)}}}function Ii(v){let d,x="Examples:",y,_,M;return _=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEElMjMlMjBEZXBlbmRpbmclMjBvbiUyMHRoZSUyMHZhcmlhbnQlMjBiZWluZyUyMHVzZWQlMkMlMjB0aGUlMjBwaXBlbGluZSUyMGNhbGwlMjB3aWxsJTIwc2xpZ2h0bHklMjB2YXJ5LiUwQSUyMyUyMFJlZmVyJTIwdG8lMjB0aGUlMjBwaXBlbGluZSUyMGRvY3VtZW50YXRpb24lMjBmb3IlMjBtb3JlJTIwZGV0YWlscy4lMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyZmx1eC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Depending on the variant being used, the pipeline call will slightly vary.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Refer to the pipeline documentation for more details.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">0.0</span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(r){d=p(r,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(r),m(_.$$.fragment,r)},m(r,w){l(r,d,w),l(r,y,w),g(_,r,w),M=!0},p:V,i(r){M||(u(_.$$.fragment,r),M=!0)},o(r){f(_.$$.fragment,r),M=!1},d(r){r&&(n(d),n(y)),h(_,r)}}}function vi(v){let d,x="Examples:",y,_,M;return _=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eEltZzJJbWdQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQXBpcGUlMjAlM0QlMjBGbHV4SW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byhkZXZpY2UpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSh1cmwpLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMHdpemFyZCUyQyUyMGdhbmRhbGYlMkMlMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGRldGFpbGVkJTJDJTIwZmFudGFzeSUyQyUyMGN1dGUlMkMlMjBhZG9yYWJsZSUyQyUyMFBpeGFyJTJDJTIwRGlzbmV5JTJDJTIwOGslMjIlMEElMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwc3RyZW5ndGglM0QwLjk1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjAlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(url).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt, image=init_image, num_inference_steps=<span class="hljs-number">4</span>, strength=<span class="hljs-number">0.95</span>, guidance_scale=<span class="hljs-number">0.0</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(r){d=p(r,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(r),m(_.$$.fragment,r)},m(r,w){l(r,d,w),l(r,y,w),g(_,r,w),M=!0},p:V,i(r){M||(u(_.$$.fragment,r),M=!0)},o(r){f(_.$$.fragment,r),M=!1},d(r){r&&(n(d),n(y)),h(_,r)}}}function ji(v){let d,x="Examples:",y,_,M;return _=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eElucGFpbnRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhJbnBhaW50UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLXNjaG5lbGwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJGYWNlJTIwb2YlMjBhJTIweWVsbG93JTIwY2F0JTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBzaXR0aW5nJTIwb24lMjBhJTIwcGFyayUyMGJlbmNoJTIyJTBBaW1nX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZsYXRlbnQtZGlmZnVzaW9uJTJGbWFpbiUyRmRhdGElMkZpbnBhaW50aW5nX2V4YW1wbGVzJTJGb3ZlcnR1cmUtY3JlYXRpb25zLTVzSTZmUWdZSXVvLnBuZyUyMiUwQW1hc2tfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRmxhdGVudC1kaWZmdXNpb24lMkZtYWluJTJGZGF0YSUyRmlucGFpbnRpbmdfZXhhbXBsZXMlMkZvdmVydHVyZS1jcmVhdGlvbnMtNXNJNmZRZ1lJdW9fbWFzay5wbmclMjIlMEFzb3VyY2UlMjAlM0QlMjBsb2FkX2ltYWdlKGltZ191cmwpJTBBbWFzayUyMCUzRCUyMGxvYWRfaW1hZ2UobWFza191cmwpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCUyQyUyMGltYWdlJTNEc291cmNlJTJDJTIwbWFza19pbWFnZSUzRG1hc2spLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmZsdXhfaW5wYWludGluZy5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxInpaintPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Face of a yellow cat, high resolution, sitting on a park bench&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>source = load_image(img_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(mask_url)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=source, mask_image=mask).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux_inpainting.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(r){d=p(r,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(r),m(_.$$.fragment,r)},m(r,w){l(r,d,w),l(r,y,w),g(_,r,w),M=!0},p:V,i(r){M||(u(_.$$.fragment,r),M=!0)},o(r){f(_.$$.fragment,r),M=!1},d(r){r&&(n(d),n(y)),h(_,r)}}}function Ui(v){let d,x="Examples:",y,_,M;return _=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlNetInpaintPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> FluxControlNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = FluxControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;InstantX/FLUX.1-dev-controlnet-canny&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxControlNetInpaintPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/InstantX/FLUX.1-dev-Controlnet-Canny-alpha/resolve/main/canny.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/latent-diffusion/main/data/inpainting_examples/overture-creations-5sI6fQgYIuo_mask.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A girl holding a sign that says InstantX&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    mask_image=mask_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    control_guidance_start=<span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>    control_guidance_end=<span class="hljs-number">0.8</span>,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=<span class="hljs-number">0.7</span>,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.7</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">28</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">3.5</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux_controlnet_inpaint.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(r){d=p(r,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(r),m(_.$$.fragment,r)},m(r,w){l(r,d,w),l(r,y,w),g(_,r,w),M=!0},p:V,i(r){M||(u(_.$$.fragment,r),M=!0)},o(r){f(_.$$.fragment,r),M=!1},d(r){r&&(n(d),n(y)),h(_,r)}}}function Fi(v){let d,x="Examples:",y,_,M;return _=new U({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlNetImg2ImgPipeline, FluxControlNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = FluxControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;InstantX/FLUX.1-dev-Controlnet-Canny-alpha&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxControlNetImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.text_encoder.to(torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.controlnet.to(torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/InstantX/SD3-Controlnet-Canny/resolve/main/canny.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A girl in city, 25 years old, cool, futuristic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    image=init_image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    control_guidance_start=<span class="hljs-number">0.2</span>,
<span class="hljs-meta">... </span>    control_guidance_end=<span class="hljs-number">0.8</span>,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=<span class="hljs-number">1.0</span>,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.7</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">3.5</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux_controlnet_img2img.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(r){d=p(r,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(r),m(_.$$.fragment,r)},m(r,w){l(r,d,w),l(r,y,w),g(_,r,w),M=!0},p:V,i(r){M||(u(_.$$.fragment,r),M=!0)},o(r){f(_.$$.fragment,r),M=!1},d(r){r&&(n(d),n(y)),h(_,r)}}}function Zi(v){let d,x="Examples:",y,_,M;return _=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwY29udHJvbG5ldF9hdXglMjBpbXBvcnQlMjBDYW5ueURldGVjdG9yJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhDb250cm9sUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1DYW5ueS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjByb2JvdCUyMG1hZGUlMjBvZiUyMGV4b3RpYyUyMGNhbmRpZXMlMjBhbmQlMjBjaG9jb2xhdGVzJTIwb2YlMjBkaWZmZXJlbnQlMjBraW5kcy4lMjBUaGUlMjBiYWNrZ3JvdW5kJTIwaXMlMjBmaWxsZWQlMjB3aXRoJTIwY29uZmV0dGklMjBhbmQlMjBjZWxlYnJhdG9yeSUyMGdpZnRzLiUyMiUwQWNvbnRyb2xfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJvYm90LnBuZyUyMiUwQSklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBDYW5ueURldGVjdG9yKCklMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlMkMlMjBsb3dfdGhyZXNob2xkJTNENTAlMkMlMjBoaWdoX3RocmVzaG9sZCUzRDIwMCUyQyUyMGRldGVjdF9yZXNvbHV0aW9uJTNEMTAyNCUyQyUyMGltYWdlX3Jlc29sdXRpb24lM0QxMDI0JTBBKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMwLjAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> CannyDetector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxControlPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = CannyDetector()
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = processor(
<span class="hljs-meta">... </span>    control_image, low_threshold=<span class="hljs-number">50</span>, high_threshold=<span class="hljs-number">200</span>, detect_resolution=<span class="hljs-number">1024</span>, image_resolution=<span class="hljs-number">1024</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">30.0</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(r){d=p(r,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(r),m(_.$$.fragment,r)},m(r,w){l(r,d,w),l(r,y,w),g(_,r,w),M=!0},p:V,i(r){M||(u(_.$$.fragment,r),M=!0)},o(r){f(_.$$.fragment,r),M=!1},d(r){r&&(n(d),n(y)),h(_,r)}}}function ki(v){let d,x="Examples:",y,_,M;return _=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwY29udHJvbG5ldF9hdXglMjBpbXBvcnQlMjBDYW5ueURldGVjdG9yJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhDb250cm9sSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwRmx1eENvbnRyb2xJbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLUNhbm55LWRldiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHJvYm90JTIwbWFkZSUyMG9mJTIwZXhvdGljJTIwY2FuZGllcyUyMGFuZCUyMGNob2NvbGF0ZXMlMjBvZiUyMGRpZmZlcmVudCUyMGtpbmRzLiUyMEFic3RyYWN0JTIwYmFja2dyb3VuZCUyMiUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZ3YXRlcmNvbG9yLXBhaW50aW5nLmpwZyUyMiUwQSklMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZyb2JvdC5wbmclMjIlMEEpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQ2FubnlEZXRlY3RvcigpJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUzRDUwJTJDJTIwaGlnaF90aHJlc2hvbGQlM0QyMDAlMkMlMjBkZXRlY3RfcmVzb2x1dGlvbiUzRDEwMjQlMkMlMjBpbWFnZV9yZXNvbHV0aW9uJTNEMTAyNCUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzMC4wJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> CannyDetector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlImg2ImgPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxControlImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. Abstract background&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/watercolor-painting.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = CannyDetector()
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = processor(
<span class="hljs-meta">... </span>    control_image, low_threshold=<span class="hljs-number">50</span>, high_threshold=<span class="hljs-number">200</span>, detect_resolution=<span class="hljs-number">1024</span>, image_resolution=<span class="hljs-number">1024</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    control_image=control_image,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.8</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">1024</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">30.0</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(r){d=p(r,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(r),m(_.$$.fragment,r)},m(r,w){l(r,d,w),l(r,y,w),g(_,r,w),M=!0},p:V,i(r){M||(u(_.$$.fragment,r),M=!0)},o(r){f(_.$$.fragment,r),M=!1},d(r){r&&(n(d),n(y)),h(_,r)}}}function Ci(v){let d,x="Examples:",y,_,M;return _=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFByaW9yUmVkdXhQaXBlbGluZSUyQyUyMEZsdXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQWR0eXBlJTIwJTNEJTIwdG9yY2guYmZsb2F0MTYlMEElMEFyZXBvX3JlZHV4JTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtUmVkdXgtZGV2JTIyJTBBcmVwb19iYXNlJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTBBcGlwZV9wcmlvcl9yZWR1eCUyMCUzRCUyMEZsdXhQcmlvclJlZHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9fcmVkdXglMkMlMjB0b3JjaF9kdHlwZSUzRGR0eXBlKS50byhkZXZpY2UpJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwcmVwb19iYXNlJTJDJTIwdGV4dF9lbmNvZGVyJTNETm9uZSUyQyUyMHRleHRfZW5jb2Rlcl8yJTNETm9uZSUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKGRldmljZSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0eWxlX3ppZ2d5JTJGaW1nNS5wbmclMjIlMEEpJTBBcGlwZV9wcmlvcl9vdXRwdXQlMjAlM0QlMjBwaXBlX3ByaW9yX3JlZHV4KGltYWdlKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyLjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUyQyUwQSUyMCUyMCUyMCUyMCoqcGlwZV9wcmlvcl9vdXRwdXQlMkMlMEEpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJmbHV4LXJlZHV4LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPriorReduxPipeline, FluxPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dtype = torch.bfloat16

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_redux = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Redux-dev&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>repo_base = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior_redux = FluxPriorReduxPipeline.from_pretrained(repo_redux, torch_dtype=dtype).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxPipeline.from_pretrained(
<span class="hljs-meta">... </span>    repo_base, text_encoder=<span class="hljs-literal">None</span>, text_encoder_2=<span class="hljs-literal">None</span>, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy/img5.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior_output = pipe_prior_redux(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">2.5</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
<span class="hljs-meta">... </span>    **pipe_prior_output,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;flux-redux.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(r){d=p(r,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(r),m(_.$$.fragment,r)},m(r,w){l(r,d,w),l(r,y,w),g(_,r,w),M=!0},p:V,i(r){M||(u(_.$$.fragment,r),M=!0)},o(r){f(_.$$.fragment,r),M=!1},d(r){r&&(n(d),n(y)),h(_,r)}}}function Wi(v){let d,x="Examples:",y,_,M;return _=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eEZpbGxQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZjdXAucG5nJTIyKSUwQW1hc2slMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZjdXBfbWFzay5wbmclMjIpJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhGaWxsUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLUZpbGwtZGV2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTIwJTIwJTIzJTIwc2F2ZSUyMHNvbWUlMjBWUkFNJTIwYnklMjBvZmZsb2FkaW5nJTIwdGhlJTIwbW9kZWwlMjB0byUyMENQVSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJhJTIwd2hpdGUlMjBwYXBlciUyMGN1cCUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFzayUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDE2MzIlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEyMzIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvciglMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJmbHV4X2ZpbGwucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxFillPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/cup.png&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/cup_mask.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = FluxFillPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Fill-dev&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()  <span class="hljs-comment"># save some VRAM by offloading the model to CPU</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;a white paper cup&quot;</span>,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    mask_image=mask,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">1632</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">1232</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    max_sequence_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;flux_fill.png&quot;</span>)`,wrap:!1}}),{c(){d=i("p"),d.textContent=x,y=o(),c(_.$$.fragment)},l(r){d=p(r,"P",{"data-svelte-h":!0}),b(d)!=="svelte-kvfsh7"&&(d.textContent=x),y=s(r),m(_.$$.fragment,r)},m(r,w){l(r,d,w),l(r,y,w),g(_,r,w),M=!0},p:V,i(r){M||(u(_.$$.fragment,r),M=!0)},o(r){f(_.$$.fragment,r),M=!1},d(r){r&&(n(d),n(y)),h(_,r)}}}function Gi(v){let d,x,y,_,M,r,w,Al='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Ro,We,Hl='Flux is a series of text-to-image generation models based on diffusion transformers. To know more about Flux, check out the original <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">blog post</a> by the creators of Flux, Black Forest Labs.',Xo,Ge,Sl='Original model checkpoints for Flux can be found <a href="https://huggingface.co/black-forest-labs" rel="nofollow">here</a>. Original inference code can be found <a href="https://github.com/black-forest-labs/flux" rel="nofollow">here</a>.',Eo,re,Vo,Be,ql="Flux comes in the following variants:",Yo,Ne,Dl='<thead><tr><th align="center">model type</th> <th align="center">model id</th></tr></thead> <tbody><tr><td align="center">Timestep-distilled</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-schnell" rel="nofollow"><code>black-forest-labs/FLUX.1-schnell</code></a></td></tr> <tr><td align="center">Guidance-distilled</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-dev</code></a></td></tr> <tr><td align="center">Fill Inpainting/Outpainting (Guidance-distilled)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Fill-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-Fill-dev</code></a></td></tr> <tr><td align="center">Canny Control (Guidance-distilled)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Canny-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-Canny-dev</code></a></td></tr> <tr><td align="center">Depth Control (Guidance-distilled)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Depth-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-Depth-dev</code></a></td></tr> <tr><td align="center">Canny Control (LoRA)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Canny-dev-lora" rel="nofollow"><code>black-forest-labs/FLUX.1-Canny-dev-lora</code></a></td></tr> <tr><td align="center">Depth Control (LoRA)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Depth-dev-lora" rel="nofollow"><code>black-forest-labs/FLUX.1-Depth-dev-lora</code></a></td></tr> <tr><td align="center">Redux (Adapter)</td> <td align="center"><a href="https://huggingface.co/black-forest-labs/FLUX.1-Redux-dev" rel="nofollow"><code>black-forest-labs/FLUX.1-Redux-dev</code></a></td></tr></tbody>',zo,Pe,Ol="All checkpoints have different usage which we detail below.",Qo,$e,Ao,Le,Kl="<li><code>max_sequence_length</code> cannot be more than 256.</li> <li><code>guidance_scale</code> needs to be 0.</li> <li>As this is a timestep-distilled model, it benefits from fewer sampling steps.</li>",Ho,Re,So,Xe,qo,Ee,er="<li>The guidance-distilled variant takes about 50 sampling steps for good-quality generation.</li> <li>It doesn’t have any limitations around the <code>max_sequence_length</code>.</li>",Do,Ve,Oo,Ye,Ko,ze,tr="<li>Flux Fill pipeline does not require <code>strength</code> as an input like regular inpainting pipelines.</li> <li>It supports both inpainting and outpainting.</li>",es,Qe,ts,Ae,ns,He,nr='<strong>Note:</strong> <code>black-forest-labs/Flux.1-Canny-dev</code> is <em>not</em> a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> model. ControlNet models are a separate component from the UNet/Transformer whose residuals are added to the actual underlying model. Canny Control is an alternate architecture that achieves effectively the same results as a ControlNet model would, by using channel-wise concatenation with input control condition and ensuring the transformer learns structure control by following the condition as closely as possible.',os,Se,ss,qe,or="Canny Control is also possible with a LoRA variant of this condition. The usage is as follows:",as,De,ls,Oe,rs,Ke,sr='<strong>Note:</strong> <code>black-forest-labs/Flux.1-Depth-dev</code> is <em>not</em> a ControlNet model. <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> models are a separate component from the UNet/Transformer whose residuals are added to the actual underlying model. Depth Control is an alternate architecture that achieves effectively the same results as a ControlNet model would, by using channel-wise concatenation with input control condition and ensuring the transformer learns structure control by following the condition as closely as possible.',is,et,ps,tt,ar="Depth Control is also possible with a LoRA variant of this condition. The usage is as follows:",ds,nt,cs,ot,ms,st,lr="<li>Flux Redux pipeline is an adapter for FLUX.1 base models. It can be used with both flux-dev and flux-schnell, for image-to-image generation.</li> <li>You can first use the <code>FluxPriorReduxPipeline</code> to get the <code>prompt_embeds</code> and <code>pooled_prompt_embeds</code>, and then feed them into the <code>FluxPipeline</code> for image-to-image generation.</li> <li>When use <code>FluxPriorReduxPipeline</code> with a base pipeline, you can set <code>text_encoder=None</code> and <code>text_encoder_2=None</code> in the base pipeline, in order to save VRAM.</li>",gs,at,us,lt,fs,rt,rr='We can combine Flux Turbo LoRAs with Flux Control and other pipelines like Fill and Redux to enable few-steps’ inference. The example below shows how to do that for Flux Control LoRA for depth and turbo LoRA from <a href="https://hf.co/ByteDance/Hyper-SD" rel="nofollow"><code>ByteDance/Hyper-SD</code></a>.',hs,it,_s,pt,bs,dt,ir='When unloading the Control LoRA weights, call <code>pipe.unload_lora_weights(reset_to_overwritten_params=True)</code> to reset the <code>pipe.transformer</code> completely back to its original form. The resultant pipeline can then be used with methods like <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">DiffusionPipeline.from_pipe()</a>. More details about this argument are available in <a href="https://github.com/huggingface/diffusers/pull/10397" rel="nofollow">this PR</a>.',ys,ct,Ms,ie,xs,mt,pr="An IP-Adapter lets you prompt Flux with images, in addition to the text prompt. This is especially useful when describing complex concepts that are difficult to articulate through text alone and you have reference images.",ws,gt,Ts,pe,dr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/flux_ip_adapter_output.jpg"/> <figcaption class="mt-2 text-sm text-center text-gray-500">IP-Adapter examples with prompt &quot;wearing sunglasses&quot;</figcaption>',Js,ut,Is,ft,cr="Flux is a very large model and requires ~50GB of RAM/VRAM to load all the modeling components. Enable some of the optimizations below to lower the memory requirements.",vs,ht,js,_t,mr='<a href="../../optimization/memory#group-offloading">Group offloading</a> lowers VRAM usage by offloading groups of internal layers rather than the whole model or weights. You need to use <a href="/docs/diffusers/main/en/api/utilities#diffusers.hooks.apply_group_offloading">apply_group_offloading()</a> on all the model components of a pipeline. The <code>offload_type</code> parameter allows you to toggle between block and leaf-level offloading. Setting it to <code>leaf_level</code> offloads the lowest leaf-level parameters to the CPU instead of offloading at the module-level.',Us,bt,gr="On CUDA devices that support asynchronous data streaming, set <code>use_stream=True</code> to overlap data transfer and computation to accelerate inference.",Fs,de,Zs,yt,ks,Mt,Cs,xt,ur='Flux can generate high-quality images with FP16 (i.e. to accelerate inference on Turing/Volta GPUs) but produces different outputs compared to FP32/BF16. The issue is that some activations in the text encoders have to be clipped when running in FP16, which affects the overall image. Forcing text encoders to run with FP32 inference thus removes this output difference. See <a href="https://github.com/huggingface/diffusers/pull/9097#issuecomment-2272292516" rel="nofollow">here</a> for details.',Ws,wt,fr="FP16 inference code:",Gs,Tt,Bs,Jt,Ns,It,hr="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",Ps,vt,_r='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> for inference with bitsandbytes.',$s,jt,Ls,Ut,Rs,Ft,br="The <code>FluxTransformer2DModel</code> supports loading checkpoints in the original format shipped by Black Forest Labs. This is also useful when trying to load finetunes or quantized versions of the models that have been published by the community.",Xs,ce,Es,Zt,yr="The following example demonstrates how to run Flux with less than 16GB of VRAM.",Vs,kt,Mr="First install <code>optimum-quanto</code>",Ys,Ct,zs,Wt,xr="Then run the following example",Qs,Gt,As,Bt,Hs,F,Nt,Ta,Bn,wr="The Flux pipeline for text-to-image generation.",Ja,Nn,Tr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',Ia,Y,Pt,va,Pn,Jr="Function invoked when calling the pipeline for generation.",ja,me,Ua,ge,$t,Fa,$n,Ir=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Za,ue,Lt,ka,Ln,vr=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Ca,fe,Rt,Wa,Rn,jr=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Ga,he,Xt,Ba,Xn,Ur=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Na,En,Et,Ss,Vt,qs,B,Yt,Pa,Vn,Fr="The Flux pipeline for image inpainting.",$a,Yn,Zr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',La,z,zt,Ra,zn,kr="Function invoked when calling the pipeline for generation.",Xa,_e,Ea,Qn,Qt,Ds,At,Os,N,Ht,Va,An,Cr="The Flux pipeline for image inpainting.",Ya,Hn,Wr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',za,Q,St,Qa,Sn,Gr="Function invoked when calling the pipeline for generation.",Aa,be,Ha,qn,qt,Ks,Dt,ea,P,Ot,Sa,Dn,Br="The Flux controlnet pipeline for inpainting.",qa,On,Nr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',Da,A,Kt,Oa,Kn,Pr="Function invoked when calling the pipeline for generation.",Ka,ye,el,eo,en,ta,tn,na,$,nn,tl,to,$r="The Flux controlnet pipeline for image-to-image generation.",nl,no,Lr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',ol,H,on,sl,oo,Rr="Function invoked when calling the pipeline for generation.",al,Me,ll,so,sn,oa,an,sa,Z,ln,rl,ao,Xr="The Flux pipeline for controllable text-to-image generation.",il,lo,Er='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',pl,S,rn,dl,ro,Vr="Function invoked when calling the pipeline for generation.",cl,xe,ml,we,pn,gl,io,Yr=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ul,Te,dn,fl,po,zr=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,hl,Je,cn,_l,co,Qr=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,bl,Ie,mn,yl,mo,Ar=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Ml,go,gn,aa,un,la,L,fn,xl,uo,Hr="The Flux pipeline for image inpainting.",wl,fo,Sr='Reference: <a href="https://blackforestlabs.ai/announcing-black-forest-labs/" rel="nofollow">https://blackforestlabs.ai/announcing-black-forest-labs/</a>',Tl,q,hn,Jl,ho,qr="Function invoked when calling the pipeline for generation.",Il,ve,vl,_o,_n,ra,bn,ia,R,yn,jl,bo,Dr="The Flux Redux pipeline for image-to-image generation.",Ul,yo,Or='Reference: <a href="https://blackforestlabs.ai/flux-1-tools/" rel="nofollow">https://blackforestlabs.ai/flux-1-tools/</a>',Fl,D,Mn,Zl,Mo,Kr="Function invoked when calling the pipeline for generation.",kl,je,Cl,xo,xn,pa,wn,da,k,Tn,Wl,wo,ei="The Flux Fill pipeline for image inpainting/outpainting.",Gl,To,ti='Reference: <a href="https://blackforestlabs.ai/flux-1-tools/" rel="nofollow">https://blackforestlabs.ai/flux-1-tools/</a>',Bl,O,Jn,Nl,Jo,ni="Function invoked when calling the pipeline for generation.",Pl,Ue,$l,Fe,In,Ll,Io,oi=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Rl,Ze,vn,Xl,vo,si=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,El,ke,jn,Vl,jo,ai=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Yl,Ce,Un,zl,Uo,li=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Ql,Fo,Fn,ca,Zn,ma,No,ga;return M=new j({props:{title:"Flux",local:"flux",headingTag:"h1"}}),re=new wa({props:{$$slots:{default:[xi]},$$scope:{ctx:v}}}),$e=new j({props:{title:"Timestep-distilled",local:"timestep-distilled",headingTag:"h3"}}),Re=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjYXQlMjBob2xkaW5nJTIwYSUyMHNpZ24lMjB0aGF0JTIwc2F5cyUyMGhlbGxvJTIwd29ybGQlMjIlMEFvdXQlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMC4lMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEzNjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXF1ZW5jZV9sZW5ndGglM0QyNTYlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFvdXQuc2F2ZSglMjJpbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
out = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
out.save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),Xe=new j({props:{title:"Guidance-distilled",local:"guidance-distilled",headingTag:"h3"}}),Ve=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHRpbnklMjBhc3Ryb25hdXQlMjBoYXRjaGluZyUyMGZyb20lMjBhbiUyMGVnZyUyMG9uJTIwdGhlJTIwbW9vbiUyMiUwQW91dCUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjUlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEzNjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFvdXQuc2F2ZSglMjJpbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon&quot;</span>
out = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">3.5</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).images[<span class="hljs-number">0</span>]
out.save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),Ye=new j({props:{title:"Fill Inpainting/Outpainting",local:"fill-inpaintingoutpainting",headingTag:"h3"}}),Qe=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eEZpbGxQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZjdXAucG5nJTIyKSUwQW1hc2slMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRllpWWlYdSUyRnRlc3RpbmctaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZjdXBfbWFzay5wbmclMjIpJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLUZpbGwtZGV2JTIyJTBBcGlwZSUyMCUzRCUyMEZsdXhGaWxsUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJhJTIwd2hpdGUlMjBwYXBlciUyMGN1cCUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFzayUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDE2MzIlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEyMzIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKGYlMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxFillPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/cup.png&quot;</span>)
mask = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/cup_mask.png&quot;</span>)

repo_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Fill-dev&quot;</span>
pipe = FluxFillPipeline.from_pretrained(repo_id, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(
    prompt=<span class="hljs-string">&quot;a white paper cup&quot;</span>,
    image=image,
    mask_image=mask,
    height=<span class="hljs-number">1632</span>,
    width=<span class="hljs-number">1232</span>,
    max_sequence_length=<span class="hljs-number">512</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">f&quot;output.png&quot;</span>)`,wrap:!1}}),Ae=new j({props:{title:"Canny Control",local:"canny-control",headingTag:"h3"}}),Se=new U({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjAtVSUyMGNvbnRyb2xuZXQtYXV4JTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwY29udHJvbG5ldF9hdXglMjBpbXBvcnQlMjBDYW5ueURldGVjdG9yJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhDb250cm9sUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1DYW5ueS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjByb2JvdCUyMG1hZGUlMjBvZiUyMGV4b3RpYyUyMGNhbmRpZXMlMjBhbmQlMjBjaG9jb2xhdGVzJTIwb2YlMjBkaWZmZXJlbnQlMjBraW5kcy4lMjBUaGUlMjBiYWNrZ3JvdW5kJTIwaXMlMjBmaWxsZWQlMjB3aXRoJTIwY29uZmV0dGklMjBhbmQlMjBjZWxlYnJhdG9yeSUyMGdpZnRzLiUyMiUwQWNvbnRyb2xfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJvYm90LnBuZyUyMiklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBDYW5ueURldGVjdG9yKCklMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwcHJvY2Vzc29yKGNvbnRyb2xfaW1hZ2UlMkMlMjBsb3dfdGhyZXNob2xkJTNENTAlMkMlMjBoaWdoX3RocmVzaG9sZCUzRDIwMCUyQyUyMGRldGVjdF9yZXNvbHV0aW9uJTNEMTAyNCUyQyUyMGltYWdlX3Jlc29sdXRpb24lM0QxMDI0KSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMwLjAlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMm91dHB1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># !pip install -U controlnet-aux</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> CannyDetector
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = CannyDetector()
control_image = processor(control_image, low_threshold=<span class="hljs-number">50</span>, high_threshold=<span class="hljs-number">200</span>, detect_resolution=<span class="hljs-number">1024</span>, image_resolution=<span class="hljs-number">1024</span>)

image = pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=<span class="hljs-number">30.0</span>,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),De=new U({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjAtVSUyMGNvbnRyb2xuZXQtYXV4JTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwY29udHJvbG5ldF9hdXglMjBpbXBvcnQlMjBDYW5ueURldGVjdG9yJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhDb250cm9sUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtQ2FubnktZGV2LWxvcmElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHJvYm90JTIwbWFkZSUyMG9mJTIwZXhvdGljJTIwY2FuZGllcyUyMGFuZCUyMGNob2NvbGF0ZXMlMjBvZiUyMGRpZmZlcmVudCUyMGtpbmRzLiUyMFRoZSUyMGJhY2tncm91bmQlMjBpcyUyMGZpbGxlZCUyMHdpdGglMjBjb25mZXR0aSUyMGFuZCUyMGNlbGVicmF0b3J5JTIwZ2lmdHMuJTIyJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcm9ib3QucG5nJTIyKSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMENhbm55RGV0ZWN0b3IoKSUwQWNvbnRyb2xfaW1hZ2UlMjAlM0QlMjBwcm9jZXNzb3IoY29udHJvbF9pbWFnZSUyQyUyMGxvd190aHJlc2hvbGQlM0Q1MCUyQyUyMGhpZ2hfdGhyZXNob2xkJTNEMjAwJTJDJTIwZGV0ZWN0X3Jlc29sdXRpb24lM0QxMDI0JTJDJTIwaW1hZ2VfcmVzb2x1dGlvbiUzRDEwMjQpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMzAuMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-comment"># !pip install -U controlnet-aux</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> CannyDetector
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Canny-dev-lora&quot;</span>)

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = CannyDetector()
control_image = processor(control_image, low_threshold=<span class="hljs-number">50</span>, high_threshold=<span class="hljs-number">200</span>, detect_resolution=<span class="hljs-number">1024</span>, image_resolution=<span class="hljs-number">1024</span>)

image = pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=<span class="hljs-number">30.0</span>,
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),Oe=new j({props:{title:"Depth Control",local:"depth-control",headingTag:"h3"}}),et=new U({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmltYWdlX2dlbl9hdXglMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4Q29udHJvbFBpcGVsaW5lJTJDJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBZnJvbSUyMGltYWdlX2dlbl9hdXglMjBpbXBvcnQlMjBEZXB0aFByZXByb2Nlc3NvciUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1EZXB0aC1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjByb2JvdCUyMG1hZGUlMjBvZiUyMGV4b3RpYyUyMGNhbmRpZXMlMjBhbmQlMjBjaG9jb2xhdGVzJTIwb2YlMjBkaWZmZXJlbnQlMjBraW5kcy4lMjBUaGUlMjBiYWNrZ3JvdW5kJTIwaXMlMjBmaWxsZWQlMjB3aXRoJTIwY29uZmV0dGklMjBhbmQlMjBjZWxlYnJhdG9yeSUyMGdpZnRzLiUyMiUwQWNvbnRyb2xfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnJvYm90LnBuZyUyMiklMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBEZXB0aFByZXByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTGloZVlvdW5nJTJGZGVwdGgtYW55dGhpbmctbGFyZ2UtaGYlMjIpJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMHByb2Nlc3Nvcihjb250cm9sX2ltYWdlKSU1QjAlNUQuY29udmVydCglMjJSR0IlMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0Rjb250cm9sX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEMTAyNCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMTAuMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcigpLm1hbnVhbF9zZWVkKDQyKSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-comment"># !pip install git+https://github.com/huggingface/image_gen_aux</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline, FluxTransformer2DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> image_gen_aux <span class="hljs-keyword">import</span> DepthPreprocessor

pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = DepthPreprocessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-large-hf&quot;</span>)
control_image = processor(control_image)[<span class="hljs-number">0</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)

image = pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    guidance_scale=<span class="hljs-number">10.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),nt=new U({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmltYWdlX2dlbl9hdXglMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4Q29udHJvbFBpcGVsaW5lJTJDJTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBZnJvbSUyMGltYWdlX2dlbl9hdXglMjBpbXBvcnQlMjBEZXB0aFByZXByb2Nlc3NvciUwQSUwQXBpcGUlMjAlM0QlMjBGbHV4Q29udHJvbFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtRGVwdGgtZGV2LWxvcmElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHJvYm90JTIwbWFkZSUyMG9mJTIwZXhvdGljJTIwY2FuZGllcyUyMGFuZCUyMGNob2NvbGF0ZXMlMjBvZiUyMGRpZmZlcmVudCUyMGtpbmRzLiUyMFRoZSUyMGJhY2tncm91bmQlMjBpcyUyMGZpbGxlZCUyMHdpdGglMjBjb25mZXR0aSUyMGFuZCUyMGNlbGVicmF0b3J5JTIwZ2lmdHMuJTIyJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcm9ib3QucG5nJTIyKSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMERlcHRoUHJlcHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJMaWhlWW91bmclMkZkZXB0aC1hbnl0aGluZy1sYXJnZS1oZiUyMiklMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwcHJvY2Vzc29yKGNvbnRyb2xfaW1hZ2UpJTVCMCU1RC5jb252ZXJ0KCUyMlJHQiUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxMC4wJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEdG9yY2guR2VuZXJhdG9yKCkubWFudWFsX3NlZWQoNDIpJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-comment"># !pip install git+https://github.com/huggingface/image_gen_aux</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline, FluxTransformer2DModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> image_gen_aux <span class="hljs-keyword">import</span> DepthPreprocessor

pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Depth-dev-lora&quot;</span>)

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = DepthPreprocessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-large-hf&quot;</span>)
control_image = processor(control_image)[<span class="hljs-number">0</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)

image = pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    guidance_scale=<span class="hljs-number">10.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),ot=new j({props:{title:"Redux",local:"redux",headingTag:"h3"}}),at=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFByaW9yUmVkdXhQaXBlbGluZSUyQyUyMEZsdXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQWR0eXBlJTIwJTNEJTIwdG9yY2guYmZsb2F0MTYlMEElMEElMEFyZXBvX3JlZHV4JTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtUmVkdXgtZGV2JTIyJTBBcmVwb19iYXNlJTIwJTNEJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTIwJTBBcGlwZV9wcmlvcl9yZWR1eCUyMCUzRCUyMEZsdXhQcmlvclJlZHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9fcmVkdXglMkMlMjB0b3JjaF9kdHlwZSUzRGR0eXBlKS50byhkZXZpY2UpJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwcmVwb19iYXNlJTJDJTIwJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl8yJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKGRldmljZSklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnN0eWxlX3ppZ2d5JTJGaW1nNS5wbmclMjIpJTBBcGlwZV9wcmlvcl9vdXRwdXQlMjAlM0QlMjBwaXBlX3ByaW9yX3JlZHV4KGltYWdlKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QyLjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUyQyUwQSUyMCUyMCUyMCUyMCoqcGlwZV9wcmlvcl9vdXRwdXQlMkMlMEEpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQuc2F2ZSglMjJmbHV4LXJlZHV4LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPriorReduxPipeline, FluxPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
device = <span class="hljs-string">&quot;cuda&quot;</span>
dtype = torch.bfloat16


repo_redux = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-Redux-dev&quot;</span>
repo_base = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span> 
pipe_prior_redux = FluxPriorReduxPipeline.from_pretrained(repo_redux, torch_dtype=dtype).to(device)
pipe = FluxPipeline.from_pretrained(
    repo_base, 
    text_encoder=<span class="hljs-literal">None</span>,
    text_encoder_2=<span class="hljs-literal">None</span>,
    torch_dtype=torch.bfloat16
).to(device)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy/img5.png&quot;</span>)
pipe_prior_output = pipe_prior_redux(image)
images = pipe(
    guidance_scale=<span class="hljs-number">2.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>),
    **pipe_prior_output,
).images
images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;flux-redux.png&quot;</span>)`,wrap:!1}}),lt=new j({props:{title:"Combining Flux Turbo LoRAs with Flux Control, Fill, and Redux",local:"combining-flux-turbo-loras-with-flux-control-fill-and-redux",headingTag:"h2"}}),it=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlPipeline
<span class="hljs-keyword">from</span> image_gen_aux <span class="hljs-keyword">import</span> DepthPreprocessor
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">import</span> torch

control_pipe = FluxControlPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16)
control_pipe.load_lora_weights(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-Depth-dev-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;depth&quot;</span>)
control_pipe.load_lora_weights(
    hf_hub_download(<span class="hljs-string">&quot;ByteDance/Hyper-SD&quot;</span>, <span class="hljs-string">&quot;Hyper-FLUX.1-dev-8steps-lora.safetensors&quot;</span>), adapter_name=<span class="hljs-string">&quot;hyper-sd&quot;</span>
)
control_pipe.set_adapters([<span class="hljs-string">&quot;depth&quot;</span>, <span class="hljs-string">&quot;hyper-sd&quot;</span>], adapter_weights=[<span class="hljs-number">0.85</span>, <span class="hljs-number">0.125</span>])
control_pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A robot made of exotic candies and chocolates of different kinds. The background is filled with confetti and celebratory gifts.&quot;</span>
control_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robot.png&quot;</span>)

processor = DepthPreprocessor.from_pretrained(<span class="hljs-string">&quot;LiheYoung/depth-anything-large-hf&quot;</span>)
control_image = processor(control_image)[<span class="hljs-number">0</span>].convert(<span class="hljs-string">&quot;RGB&quot;</span>)

image = control_pipe(
    prompt=prompt,
    control_image=control_image,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">8</span>,
    guidance_scale=<span class="hljs-number">10.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">42</span>),
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),pt=new j({props:{title:"Note about unload_lora_weights() when using Flux LoRAs",local:"note-about-unloadloraweights-when-using-flux-loras",headingTag:"h2"}}),ct=new j({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h2"}}),ie=new wa({props:{$$slots:{default:[wi]},$$scope:{ctx:v}}}),gt=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlJTIwJTNEJTIwRmx1eFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZmbHV4X2lwX2FkYXB0ZXJfaW5wdXQuanBnJTIyKS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSklMEElMEFwaXBlLmxvYWRfaXBfYWRhcHRlciglMEElMjAlMjAlMjAlMjAlMjJYTGFicy1BSSUyRmZsdXgtaXAtYWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9uYW1lJTNEJTIyaXBfYWRhcHRlci5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VuY29kZXJfcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjJvcGVuYWklMkZjbGlwLXZpdC1sYXJnZS1wYXRjaDE0JTIyJTBBKSUwQXBpcGUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMS4wKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyd2VhcmluZyUyMHN1bmdsYXNzZXMlMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVlX2NmZyUzRDQuMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvcigpLm1hbnVhbF9zZWVkKDQ0NDQpJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSgnZmx1eF9pcF9hZGFwdGVyX291dHB1dC5qcGcnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipe = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/flux_ip_adapter_input.jpg&quot;</span>).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

pipe.load_ip_adapter(
    <span class="hljs-string">&quot;XLabs-AI/flux-ip-adapter&quot;</span>,
    weight_name=<span class="hljs-string">&quot;ip_adapter.safetensors&quot;</span>,
    image_encoder_pretrained_model_name_or_path=<span class="hljs-string">&quot;openai/clip-vit-large-patch14&quot;</span>
)
pipe.set_ip_adapter_scale(<span class="hljs-number">1.0</span>)

image = pipe(
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1024</span>,
    prompt=<span class="hljs-string">&quot;wearing sunglasses&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    true_cfg=<span class="hljs-number">4.0</span>,
    generator=torch.Generator().manual_seed(<span class="hljs-number">4444</span>),
    ip_adapter_image=image,
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&#x27;flux_ip_adapter_output.jpg&#x27;</span>)`,wrap:!1}}),ut=new j({props:{title:"Optimize",local:"optimize",headingTag:"h2"}}),ht=new j({props:{title:"Group offloading",local:"group-offloading",headingTag:"h3"}}),de=new wa({props:{warning:!1,$$slots:{default:[Ti]},$$scope:{ctx:v}}}),yt=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading

model_id = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
dtype = torch.bfloat16
pipe = FluxPipeline.from_pretrained(
	model_id,
	torch_dtype=dtype,
)

apply_group_offloading(
    pipe.transformer,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    offload_device=torch.device(<span class="hljs-string">&quot;cpu&quot;</span>),
    onload_device=torch.device(<span class="hljs-string">&quot;cuda&quot;</span>),
    use_stream=<span class="hljs-literal">True</span>,
)
apply_group_offloading(
    pipe.text_encoder, 
    offload_device=torch.device(<span class="hljs-string">&quot;cpu&quot;</span>),
    onload_device=torch.device(<span class="hljs-string">&quot;cuda&quot;</span>),
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
)
apply_group_offloading(
    pipe.text_encoder_2, 
    offload_device=torch.device(<span class="hljs-string">&quot;cpu&quot;</span>),
    onload_device=torch.device(<span class="hljs-string">&quot;cuda&quot;</span>),
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
)
apply_group_offloading(
    pipe.vae, 
    offload_device=torch.device(<span class="hljs-string">&quot;cpu&quot;</span>),
    onload_device=torch.device(<span class="hljs-string">&quot;cuda&quot;</span>),
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
)

prompt=<span class="hljs-string">&quot;A cat wearing sunglasses and working as a lifeguard at pool.&quot;</span>

generator = torch.Generator().manual_seed(<span class="hljs-number">181201</span>)
image = pipe(
    prompt,
    width=<span class="hljs-number">576</span>,
    height=<span class="hljs-number">1024</span>,
    num_inference_steps=<span class="hljs-number">30</span>,
    generator=generator
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Mt=new j({props:{title:"Running FP16 inference",local:"running-fp16-inference",headingTag:"h3"}}),Tt=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTIwJTIzJTIwY2FuJTIwcmVwbGFjZSUyMHNjaG5lbGwlMjB3aXRoJTIwZGV2JTBBJTIzJTIwdG8lMjBydW4lMjBvbiUyMGxvdyUyMHZyYW0lMjBHUFVzJTIwKGkuZS4lMjBiZXR3ZWVuJTIwNCUyMGFuZCUyMDMyJTIwR0IlMjBWUkFNKSUwQXBpcGUuZW5hYmxlX3NlcXVlbnRpYWxfY3B1X29mZmxvYWQoKSUwQXBpcGUudmFlLmVuYWJsZV9zbGljaW5nKCklMEFwaXBlLnZhZS5lbmFibGVfdGlsaW5nKCklMEElMEFwaXBlLnRvKHRvcmNoLmZsb2F0MTYpJTIwJTIzJTIwY2FzdGluZyUyMGhlcmUlMjBpbnN0ZWFkJTIwb2YlMjBpbiUyMHRoZSUyMHBpcGVsaW5lJTIwY29uc3RydWN0b3IlMjBiZWNhdXNlJTIwZG9pbmclMjBzbyUyMGluJTIwdGhlJTIwY29uc3RydWN0b3IlMjBsb2FkcyUyMGFsbCUyMG1vZGVscyUyMGludG8lMjBDUFUlMjBtZW1vcnklMjBhdCUyMG9uY2UlMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBb3V0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAuJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMzYwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxdWVuY2VfbGVuZ3RoJTNEMjU2JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBb3V0LnNhdmUoJTIyaW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline

pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>, torch_dtype=torch.bfloat16) <span class="hljs-comment"># can replace schnell with dev</span>
<span class="hljs-comment"># to run on low vram GPUs (i.e. between 4 and 32 GB VRAM)</span>
pipe.enable_sequential_cpu_offload()
pipe.vae.enable_slicing()
pipe.vae.enable_tiling()

pipe.to(torch.float16) <span class="hljs-comment"># casting here instead of in the pipeline constructor because doing so in the constructor loads all models into CPU memory at once</span>

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
out = pipe(
    prompt=prompt,
    guidance_scale=<span class="hljs-number">0.</span>,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">1360</span>,
    num_inference_steps=<span class="hljs-number">4</span>,
    max_sequence_length=<span class="hljs-number">256</span>,
).images[<span class="hljs-number">0</span>]
out.save(<span class="hljs-string">&quot;image.png&quot;</span>)`,wrap:!1}}),Jt=new j({props:{title:"Quantization",local:"quantization",headingTag:"h3"}}),jt=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMkMlMjBGbHV4VHJhbnNmb3JtZXIyRE1vZGVsJTJDJTIwRmx1eFBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFxdWFudF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobG9hZF9pbl84Yml0JTNEVHJ1ZSklMEF0ZXh0X2VuY29kZXJfOGJpdCUyMCUzRCUyMFQ1RW5jb2Rlck1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwRGlmZnVzZXJzQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBdHJhbnNmb3JtZXJfOGJpdCUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdGV4dF9lbmNvZGVyXzIlM0R0ZXh0X2VuY29kZXJfOGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXJfOGJpdCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwdGlueSUyMGFzdHJvbmF1dCUyMGhhdGNoaW5nJTIwZnJvbSUyMGFuJTIwZWdnJTIwb24lMjB0aGUlMjBtb29uJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMuNSUyQyUyMGhlaWdodCUzRDc2OCUyQyUyMHdpZHRoJTNEMTM2MCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyZmx1eC5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, FluxTransformer2DModel, FluxPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = FluxTransformer2DModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    text_encoder_2=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;a tiny astronaut hatching from an egg on the moon&quot;</span>
image = pipeline(prompt, guidance_scale=<span class="hljs-number">3.5</span>, height=<span class="hljs-number">768</span>, width=<span class="hljs-number">1360</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;flux.png&quot;</span>)`,wrap:!1}}),Ut=new j({props:{title:"Single File Loading for the FluxTransformer2DModel",local:"single-file-loading-for-the-fluxtransformer2dmodel",headingTag:"h2"}}),ce=new wa({props:{$$slots:{default:[Ji]},$$scope:{ctx:v}}}),Ct=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0tcXVhbnRv",highlighted:"pip install optimum-quanto",wrap:!1}}),Gt=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFRyYW5zZm9ybWVyMkRNb2RlbCUyQyUyMEZsdXhQaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUNUVuY29kZXJNb2RlbCUyQyUyMENMSVBUZXh0TW9kZWwlMEFmcm9tJTIwb3B0aW11bS5xdWFudG8lMjBpbXBvcnQlMjBmcmVlemUlMkMlMjBxZmxvYXQ4JTJDJTIwcXVhbnRpemUlMEElMEFiZmxfcmVwbyUyMCUzRCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUwQWR0eXBlJTIwJTNEJTIwdG9yY2guYmZsb2F0MTYlMEElMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEZsdXhUcmFuc2Zvcm1lcjJETW9kZWwuZnJvbV9zaW5nbGVfZmlsZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGS2lqYWklMkZmbHV4LWZwOCUyRmJsb2IlMkZtYWluJTJGZmx1eDEtZGV2LWZwOC5zYWZldGVuc29ycyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUpJTBBcXVhbnRpemUodHJhbnNmb3JtZXIlMkMlMjB3ZWlnaHRzJTNEcWZsb2F0OCklMEFmcmVlemUodHJhbnNmb3JtZXIpJTBBJTBBdGV4dF9lbmNvZGVyXzIlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmZsX3JlcG8lMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXJfMiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUpJTBBcXVhbnRpemUodGV4dF9lbmNvZGVyXzIlMkMlMjB3ZWlnaHRzJTNEcWZsb2F0OCklMEFmcmVlemUodGV4dF9lbmNvZGVyXzIpJTBBJTBBcGlwZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoYmZsX3JlcG8lMkMlMjB0cmFuc2Zvcm1lciUzRE5vbmUlMkMlMjB0ZXh0X2VuY29kZXJfMiUzRE5vbmUlMkMlMjB0b3JjaF9kdHlwZSUzRGR0eXBlKSUwQXBpcGUudHJhbnNmb3JtZXIlMjAlM0QlMjB0cmFuc2Zvcm1lciUwQXBpcGUudGV4dF9lbmNvZGVyXzIlMjAlM0QlMjB0ZXh0X2VuY29kZXJfMiUwQSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMy41JTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgwKSUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyZmx1eC1mcDgtZGV2LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxTransformer2DModel, FluxPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, CLIPTextModel
<span class="hljs-keyword">from</span> optimum.quanto <span class="hljs-keyword">import</span> freeze, qfloat8, quantize

bfl_repo = <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>
dtype = torch.bfloat16

transformer = FluxTransformer2DModel.from_single_file(<span class="hljs-string">&quot;https://huggingface.co/Kijai/flux-fp8/blob/main/flux1-dev-fp8.safetensors&quot;</span>, torch_dtype=dtype)
quantize(transformer, weights=qfloat8)
freeze(transformer)

text_encoder_2 = T5EncoderModel.from_pretrained(bfl_repo, subfolder=<span class="hljs-string">&quot;text_encoder_2&quot;</span>, torch_dtype=dtype)
quantize(text_encoder_2, weights=qfloat8)
freeze(text_encoder_2)

pipe = FluxPipeline.from_pretrained(bfl_repo, transformer=<span class="hljs-literal">None</span>, text_encoder_2=<span class="hljs-literal">None</span>, torch_dtype=dtype)
pipe.transformer = transformer
pipe.text_encoder_2 = text_encoder_2

pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt,
    guidance_scale=<span class="hljs-number">3.5</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
).images[<span class="hljs-number">0</span>]

image.save(<span class="hljs-string">&quot;flux-fp8-dev.png&quot;</span>)`,wrap:!1}}),Bt=new j({props:{title:"FluxPipeline",local:"diffusers.FluxPipeline",headingTag:"h2"}}),Nt=new I({props:{name:"class diffusers.FluxPipeline",anchor:"diffusers.FluxPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"}],parametersDescription:[{anchor:"diffusers.FluxPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L146"}}),Pt=new I({props:{name:"__call__",anchor:"diffusers.FluxPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"true_cfg_scale",val:": float = 1.0"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 3.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"negative_ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead.`,name:"prompt_2"},{anchor:"diffusers.FluxPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>true_cfg_scale</code> is
not greater than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.FluxPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.FluxPipeline.__call__.true_cfg_scale",description:`<strong>true_cfg_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
When &gt; 1.0 and a provided <code>negative_prompt</code>, enables true classifier-free guidance.`,name:"true_cfg_scale"},{anchor:"diffusers.FluxPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"diffusers.FluxPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.FluxPipeline.__call__.negative_ip_adapter_image",description:`<strong>negative_ip_adapter_image</strong> &#x2014;
(<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_ip_adapter_image"},{anchor:"diffusers.FluxPipeline.__call__.negative_ip_adapter_image_embeds",description:`<strong>negative_ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"negative_ip_adapter_image_embeds"},{anchor:"diffusers.FluxPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.FluxPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L635",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),me=new le({props:{anchor:"diffusers.FluxPipeline.__call__.example",$$slots:{default:[Ii]},$$scope:{ctx:v}}}),$t=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.FluxPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L558"}}),Lt=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.FluxPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L573"}}),Rt=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.FluxPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L551"}}),Xt=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.FluxPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L565"}}),Et=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux.py#L310"}}),Vt=new j({props:{title:"FluxImg2ImgPipeline",local:"diffusers.FluxImg2ImgPipeline",headingTag:"h2"}}),Yt=new I({props:{name:"class diffusers.FluxImg2ImgPipeline",anchor:"diffusers.FluxImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"}],parametersDescription:[{anchor:"diffusers.FluxImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_img2img.py#L169"}}),zt=new I({props:{name:"__call__",anchor:"diffusers.FluxImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"true_cfg_scale",val:": float = 1.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"negative_ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.negative_ip_adapter_image",description:`<strong>negative_ip_adapter_image</strong> &#x2014;
(<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_ip_adapter_image"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.negative_ip_adapter_image_embeds",description:`<strong>negative_ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"negative_ip_adapter_image_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxImg2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_img2img.py#L676",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),_e=new le({props:{anchor:"diffusers.FluxImg2ImgPipeline.__call__.example",$$slots:{default:[vi]},$$scope:{ctx:v}}}),Qt=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_img2img.py#L333"}}),At=new j({props:{title:"FluxInpaintPipeline",local:"diffusers.FluxInpaintPipeline",headingTag:"h2"}}),Ht=new I({props:{name:"class diffusers.FluxInpaintPipeline",anchor:"diffusers.FluxInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"}],parametersDescription:[{anchor:"diffusers.FluxInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxInpaintPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxInpaintPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_inpaint.py#L166"}}),St=new I({props:{name:"__call__",anchor:"diffusers.FluxInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"true_cfg_scale",val:": float = 1.0"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"negative_ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.FluxInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.FluxInpaintPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.FluxInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The size of margin in the crop to be applied to the image and masking. If <code>None</code>, no crop is applied to
image and mask_image. If <code>padding_mask_crop</code> is not <code>None</code>, it will first find a rectangular region
with the same aspect ration of the image and contains all masked area, and then expand that area based
on <code>padding_mask_crop</code>. The image and mask_image will then be cropped based on the expanded area before
resizing to the original image size for inpainting. This is useful when the masked area is small while
the image is large and contain information irrelevant for inpainting, such as background.`,name:"padding_mask_crop"},{anchor:"diffusers.FluxInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FluxInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxInpaintPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"diffusers.FluxInpaintPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.FluxInpaintPipeline.__call__.negative_ip_adapter_image",description:`<strong>negative_ip_adapter_image</strong> &#x2014;
(<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_ip_adapter_image"},{anchor:"diffusers.FluxInpaintPipeline.__call__.negative_ip_adapter_image_embeds",description:`<strong>negative_ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"negative_ip_adapter_image_embeds"},{anchor:"diffusers.FluxInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxInpaintPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxInpaintPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_inpaint.py#L775",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),be=new le({props:{anchor:"diffusers.FluxInpaintPipeline.__call__.example",$$slots:{default:[ji]},$$scope:{ctx:v}}}),qt=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_inpaint.py#L337"}}),Dt=new j({props:{title:"FluxControlNetInpaintPipeline",local:"diffusers.FluxControlNetInpaintPipeline",headingTag:"h2"}}),Ot=new I({props:{name:"class diffusers.FluxControlNetInpaintPipeline",anchor:"diffusers.FluxControlNetInpaintPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel, typing.List[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel], typing.Tuple[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel], diffusers.models.controlnets.controlnet_flux.FluxMultiControlNetModel]"}],parametersDescription:[{anchor:"diffusers.FluxControlNetInpaintPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxControlNetInpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxControlNetInpaintPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxControlNetInpaintPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxControlNetInpaintPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxControlNetInpaintPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxControlNetInpaintPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_inpainting.py#L174"}}),Kt=new I({props:{name:"__call__",anchor:"diffusers.FluxControlNetInpaintPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"mask_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"masked_image_latents",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"padding_mask_crop",val:": typing.Optional[int] = None"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"guidance_scale",val:": float = 7.0"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_mode",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>.`,name:"prompt_2"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The image(s) to inpaint.`,name:"image"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The mask image(s) to use for inpainting. White pixels in the mask will be repainted, while black pixels
will be preserved.`,name:"mask_image"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.masked_image_latents",description:`<strong>masked_image_latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated masked image latents.`,name:"masked_image_latents"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The ControlNet input condition. Image to control the generation.`,name:"control_image"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.default_sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.default_sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.6) &#x2014;
Conceptually, indicates how much to inpaint the masked area. Must be between 0 and 1.`,name:"strength"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.padding_mask_crop",description:`<strong>padding_mask_crop</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The size of the padding to use when cropping the mask.`,name:"padding_mask_crop"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 28) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.`,name:"guidance_scale"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.control_mode",description:`<strong>control_mode</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
The mode for the ControlNet. If multiple ControlNets are used, this should be a list.`,name:"control_mode"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original transformer.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or more <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a> to
make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts.`,name:"latents"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to be passed to the joint attention mechanism.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising step during the inference.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_inpainting.py#L738",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),ye=new le({props:{anchor:"diffusers.FluxControlNetInpaintPipeline.__call__.example",$$slots:{default:[Ui]},$$scope:{ctx:v}}}),en=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlNetInpaintPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_inpainting.py#L346"}}),tn=new j({props:{title:"FluxControlNetImg2ImgPipeline",local:"diffusers.FluxControlNetImg2ImgPipeline",headingTag:"h2"}}),nn=new I({props:{name:"class diffusers.FluxControlNetImg2ImgPipeline",anchor:"diffusers.FluxControlNetImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel, typing.List[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel], typing.Tuple[diffusers.models.controlnets.controlnet_flux.FluxControlNetModel], diffusers.models.controlnets.controlnet_flux.FluxMultiControlNetModel]"}],parametersDescription:[{anchor:"diffusers.FluxControlNetImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_image_to_image.py#L172"}}),on=new I({props:{name:"__call__",anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_mode",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>.`,name:"prompt_2"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>PIL.Image.Image</code> or <code>List[PIL.Image.Image]</code> or <code>torch.FloatTensor</code>) &#x2014;
The ControlNet input condition. Image to control the generation.`,name:"control_image"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.default_sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.default_sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.6) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1.`,name:"strength"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 28) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.`,name:"guidance_scale"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.control_mode",description:`<strong>control_mode</strong> (<code>int</code> or <code>List[int]</code>, <em>optional</em>) &#x2014;
The mode for the ControlNet. If multiple ControlNets are used, this should be a list.`,name:"control_mode"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original transformer.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or more <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a> to
make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts.`,name:"latents"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to be passed to the joint attention mechanism.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising step during the inference.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_image_to_image.py#L634",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),Me=new le({props:{anchor:"diffusers.FluxControlNetImg2ImgPipeline.__call__.example",$$slots:{default:[Fi]},$$scope:{ctx:v}}}),sn=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlNetImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_controlnet_image_to_image.py#L335"}}),an=new j({props:{title:"FluxControlPipeline",local:"diffusers.FluxControlPipeline",headingTag:"h2"}}),ln=new I({props:{name:"class diffusers.FluxControlPipeline",anchor:"diffusers.FluxControlPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxControlPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxControlPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxControlPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxControlPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxControlPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxControlPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxControlPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L159"}}),rn=new I({props:{name:"__call__",anchor:"diffusers.FluxControlPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 3.5"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxControlPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxControlPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxControlPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.FluxControlPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxControlPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxControlPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxControlPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxControlPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxControlPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxControlPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxControlPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxControlPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxControlPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxControlPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxControlPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxControlPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L610",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),xe=new le({props:{anchor:"diffusers.FluxControlPipeline.__call__.example",$$slots:{default:[Zi]},$$scope:{ctx:v}}}),pn=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.FluxControlPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L501"}}),dn=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.FluxControlPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L516"}}),cn=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.FluxControlPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L494"}}),mn=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.FluxControlPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L508"}}),gn=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxControlPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxControlPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control.py#L324"}}),un=new j({props:{title:"FluxControlImg2ImgPipeline",local:"diffusers.FluxControlImg2ImgPipeline",headingTag:"h2"}}),fn=new I({props:{name:"class diffusers.FluxControlImg2ImgPipeline",anchor:"diffusers.FluxControlImg2ImgPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxControlImg2ImgPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxControlImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxControlImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxControlImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxControlImg2ImgPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxControlImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxControlImg2ImgPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_img2img.py#L178"}}),hn=new I({props:{name:"__call__",anchor:"diffusers.FluxControlImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 0.6"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_img2img.py#L634",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),ve=new le({props:{anchor:"diffusers.FluxControlImg2ImgPipeline.__call__.example",$$slots:{default:[ki]},$$scope:{ctx:v}}}),_n=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxControlImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_control_img2img.py#L335"}}),bn=new j({props:{title:"FluxPriorReduxPipeline",local:"diffusers.FluxPriorReduxPipeline",headingTag:"h2"}}),yn=new I({props:{name:"class diffusers.FluxPriorReduxPipeline",anchor:"diffusers.FluxPriorReduxPipeline",parameters:[{name:"image_encoder",val:": SiglipVisionModel"},{name:"feature_extractor",val:": SiglipImageProcessor"},{name:"image_embedder",val:": ReduxImageEncoder"},{name:"text_encoder",val:": CLIPTextModel = None"},{name:"tokenizer",val:": CLIPTokenizer = None"},{name:"text_encoder_2",val:": T5EncoderModel = None"},{name:"tokenizer_2",val:": T5TokenizerFast = None"}],parametersDescription:[{anchor:"diffusers.FluxPriorReduxPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>SiglipVisionModel</code>) &#x2014;
SIGLIP vision model to encode the input image.`,name:"image_encoder"},{anchor:"diffusers.FluxPriorReduxPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>SiglipImageProcessor</code>) &#x2014;
Image processor for preprocessing images for the SIGLIP model.`,name:"feature_extractor"},{anchor:"diffusers.FluxPriorReduxPipeline.image_embedder",description:`<strong>image_embedder</strong> (<code>ReduxImageEncoder</code>) &#x2014;
Redux image encoder to process the SIGLIP embeddings.`,name:"image_embedder"},{anchor:"diffusers.FluxPriorReduxPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>, <em>optional</em>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxPriorReduxPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>, <em>optional</em>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxPriorReduxPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>, <em>optional</em>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxPriorReduxPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>, <em>optional</em>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_prior_redux.py#L84"}}),Mn=new I({props:{name:"__call__",anchor:"diffusers.FluxPriorReduxPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds_scale",val:": typing.Union[float, typing.List[float], NoneType] = 1.0"},{name:"pooled_prompt_embeds_scale",val:": typing.Union[float, typing.List[float], NoneType] = 1.0"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.FluxPriorReduxPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code>`,name:"image"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. <strong>experimental feature</strong>: to use this feature,
make sure to explicitly load text encoders to the pipeline. Prompts will be ignored if text encoders
are not loaded.`,name:"prompt"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>.`,name:"prompt_2"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPriorReduxPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPriorReduxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_prior_redux.py#L371",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPriorReduxPipelineOutput</code> if <code>return_dict</code> is True, otherwise a <code>tuple</code>. When
returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPriorReduxPipelineOutput</code> or <code>tuple</code></p>
`}}),je=new le({props:{anchor:"diffusers.FluxPriorReduxPipeline.__call__.example",$$slots:{default:[Ci]},$$scope:{ctx:v}}}),xn=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxPriorReduxPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_prior_redux.py#L292"}}),wn=new j({props:{title:"FluxFillPipeline",local:"diffusers.FluxFillPipeline",headingTag:"h2"}}),Tn=new I({props:{name:"class diffusers.FluxFillPipeline",anchor:"diffusers.FluxFillPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"tokenizer_2",val:": T5TokenizerFast"},{name:"transformer",val:": FluxTransformer2DModel"}],parametersDescription:[{anchor:"diffusers.FluxFillPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/flux_transformer#diffusers.FluxTransformer2DModel">FluxTransformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.FluxFillPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.FluxFillPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FluxFillPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.FluxFillPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.FluxFillPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.FluxFillPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer_2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L167"}}),Jn=new I({props:{name:"__call__",anchor:"diffusers.FluxFillPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Optional[torch.FloatTensor] = None"},{name:"mask_image",val:": typing.Optional[torch.FloatTensor] = None"},{name:"masked_image_latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"strength",val:": float = 1.0"},{name:"num_inference_steps",val:": int = 50"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 30.0"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.FluxFillPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.FluxFillPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.FluxFillPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code>.`,name:"image"},{anchor:"diffusers.FluxFillPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>, <code>(B, H, W)</code>, <code>(1, H, W)</code>, <code>(H, W)</code>. And for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"mask_image"},{anchor:"diffusers.FluxFillPipeline.__call__.mask_image_latent",description:`<strong>mask_image_latent</strong> (<code>torch.Tensor</code>, <code>List[torch.Tensor]</code>) &#x2014;
<code>Tensor</code> representing an image batch to mask <code>image</code> generated by VAE. If not provided, the mask
latents tensor will ge generated by <code>mask_image</code>.`,name:"mask_image_latent"},{anchor:"diffusers.FluxFillPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.FluxFillPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.FluxFillPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FluxFillPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FluxFillPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.FluxFillPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 30.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.FluxFillPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxFillPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.FluxFillPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FluxFillPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxFillPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxFillPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.FluxFillPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.flux.FluxPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FluxFillPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.FluxFillPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.FluxFillPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.FluxFillPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 512) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L727",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> if <code>return_dict</code>
is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated
images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.flux.FluxPipelineOutput</code> or <code>tuple</code></p>
`}}),Ue=new le({props:{anchor:"diffusers.FluxFillPipeline.__call__.example",$$slots:{default:[Wi]},$$scope:{ctx:v}}}),In=new I({props:{name:"disable_vae_slicing",anchor:"diffusers.FluxFillPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L638"}}),vn=new I({props:{name:"disable_vae_tiling",anchor:"diffusers.FluxFillPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L653"}}),jn=new I({props:{name:"enable_vae_slicing",anchor:"diffusers.FluxFillPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L631"}}),Un=new I({props:{name:"enable_vae_tiling",anchor:"diffusers.FluxFillPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L645"}}),Fn=new I({props:{name:"encode_prompt",anchor:"diffusers.FluxFillPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"max_sequence_length",val:": int = 512"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.FluxFillPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.FluxFillPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/flux/pipeline_flux_fill.py#L419"}}),Zn=new Mi({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/flux.md"}}),{c(){d=i("meta"),x=o(),y=i("p"),_=o(),c(M.$$.fragment),r=o(),w=i("div"),w.innerHTML=Al,Ro=o(),We=i("p"),We.innerHTML=Hl,Xo=o(),Ge=i("p"),Ge.innerHTML=Sl,Eo=o(),c(re.$$.fragment),Vo=o(),Be=i("p"),Be.textContent=ql,Yo=o(),Ne=i("table"),Ne.innerHTML=Dl,zo=o(),Pe=i("p"),Pe.textContent=Ol,Qo=o(),c($e.$$.fragment),Ao=o(),Le=i("ul"),Le.innerHTML=Kl,Ho=o(),c(Re.$$.fragment),So=o(),c(Xe.$$.fragment),qo=o(),Ee=i("ul"),Ee.innerHTML=er,Do=o(),c(Ve.$$.fragment),Oo=o(),c(Ye.$$.fragment),Ko=o(),ze=i("ul"),ze.innerHTML=tr,es=o(),c(Qe.$$.fragment),ts=o(),c(Ae.$$.fragment),ns=o(),He=i("p"),He.innerHTML=nr,os=o(),c(Se.$$.fragment),ss=o(),qe=i("p"),qe.textContent=or,as=o(),c(De.$$.fragment),ls=o(),c(Oe.$$.fragment),rs=o(),Ke=i("p"),Ke.innerHTML=sr,is=o(),c(et.$$.fragment),ps=o(),tt=i("p"),tt.textContent=ar,ds=o(),c(nt.$$.fragment),cs=o(),c(ot.$$.fragment),ms=o(),st=i("ul"),st.innerHTML=lr,gs=o(),c(at.$$.fragment),us=o(),c(lt.$$.fragment),fs=o(),rt=i("p"),rt.innerHTML=rr,hs=o(),c(it.$$.fragment),_s=o(),c(pt.$$.fragment),bs=o(),dt=i("p"),dt.innerHTML=ir,ys=o(),c(ct.$$.fragment),Ms=o(),c(ie.$$.fragment),xs=o(),mt=i("p"),mt.textContent=pr,ws=o(),c(gt.$$.fragment),Ts=o(),pe=i("div"),pe.innerHTML=dr,Js=o(),c(ut.$$.fragment),Is=o(),ft=i("p"),ft.textContent=cr,vs=o(),c(ht.$$.fragment),js=o(),_t=i("p"),_t.innerHTML=mr,Us=o(),bt=i("p"),bt.innerHTML=gr,Fs=o(),c(de.$$.fragment),Zs=o(),c(yt.$$.fragment),ks=o(),c(Mt.$$.fragment),Cs=o(),xt=i("p"),xt.innerHTML=ur,Ws=o(),wt=i("p"),wt.textContent=fr,Gs=o(),c(Tt.$$.fragment),Bs=o(),c(Jt.$$.fragment),Ns=o(),It=i("p"),It.textContent=hr,Ps=o(),vt=i("p"),vt.innerHTML=_r,$s=o(),c(jt.$$.fragment),Ls=o(),c(Ut.$$.fragment),Rs=o(),Ft=i("p"),Ft.innerHTML=br,Xs=o(),c(ce.$$.fragment),Es=o(),Zt=i("p"),Zt.textContent=yr,Vs=o(),kt=i("p"),kt.innerHTML=Mr,Ys=o(),c(Ct.$$.fragment),zs=o(),Wt=i("p"),Wt.textContent=xr,Qs=o(),c(Gt.$$.fragment),As=o(),c(Bt.$$.fragment),Hs=o(),F=i("div"),c(Nt.$$.fragment),Ta=o(),Bn=i("p"),Bn.textContent=wr,Ja=o(),Nn=i("p"),Nn.innerHTML=Tr,Ia=o(),Y=i("div"),c(Pt.$$.fragment),va=o(),Pn=i("p"),Pn.textContent=Jr,ja=o(),c(me.$$.fragment),Ua=o(),ge=i("div"),c($t.$$.fragment),Fa=o(),$n=i("p"),$n.innerHTML=Ir,Za=o(),ue=i("div"),c(Lt.$$.fragment),ka=o(),Ln=i("p"),Ln.innerHTML=vr,Ca=o(),fe=i("div"),c(Rt.$$.fragment),Wa=o(),Rn=i("p"),Rn.textContent=jr,Ga=o(),he=i("div"),c(Xt.$$.fragment),Ba=o(),Xn=i("p"),Xn.textContent=Ur,Na=o(),En=i("div"),c(Et.$$.fragment),Ss=o(),c(Vt.$$.fragment),qs=o(),B=i("div"),c(Yt.$$.fragment),Pa=o(),Vn=i("p"),Vn.textContent=Fr,$a=o(),Yn=i("p"),Yn.innerHTML=Zr,La=o(),z=i("div"),c(zt.$$.fragment),Ra=o(),zn=i("p"),zn.textContent=kr,Xa=o(),c(_e.$$.fragment),Ea=o(),Qn=i("div"),c(Qt.$$.fragment),Ds=o(),c(At.$$.fragment),Os=o(),N=i("div"),c(Ht.$$.fragment),Va=o(),An=i("p"),An.textContent=Cr,Ya=o(),Hn=i("p"),Hn.innerHTML=Wr,za=o(),Q=i("div"),c(St.$$.fragment),Qa=o(),Sn=i("p"),Sn.textContent=Gr,Aa=o(),c(be.$$.fragment),Ha=o(),qn=i("div"),c(qt.$$.fragment),Ks=o(),c(Dt.$$.fragment),ea=o(),P=i("div"),c(Ot.$$.fragment),Sa=o(),Dn=i("p"),Dn.textContent=Br,qa=o(),On=i("p"),On.innerHTML=Nr,Da=o(),A=i("div"),c(Kt.$$.fragment),Oa=o(),Kn=i("p"),Kn.textContent=Pr,Ka=o(),c(ye.$$.fragment),el=o(),eo=i("div"),c(en.$$.fragment),ta=o(),c(tn.$$.fragment),na=o(),$=i("div"),c(nn.$$.fragment),tl=o(),to=i("p"),to.textContent=$r,nl=o(),no=i("p"),no.innerHTML=Lr,ol=o(),H=i("div"),c(on.$$.fragment),sl=o(),oo=i("p"),oo.textContent=Rr,al=o(),c(Me.$$.fragment),ll=o(),so=i("div"),c(sn.$$.fragment),oa=o(),c(an.$$.fragment),sa=o(),Z=i("div"),c(ln.$$.fragment),rl=o(),ao=i("p"),ao.textContent=Xr,il=o(),lo=i("p"),lo.innerHTML=Er,pl=o(),S=i("div"),c(rn.$$.fragment),dl=o(),ro=i("p"),ro.textContent=Vr,cl=o(),c(xe.$$.fragment),ml=o(),we=i("div"),c(pn.$$.fragment),gl=o(),io=i("p"),io.innerHTML=Yr,ul=o(),Te=i("div"),c(dn.$$.fragment),fl=o(),po=i("p"),po.innerHTML=zr,hl=o(),Je=i("div"),c(cn.$$.fragment),_l=o(),co=i("p"),co.textContent=Qr,bl=o(),Ie=i("div"),c(mn.$$.fragment),yl=o(),mo=i("p"),mo.textContent=Ar,Ml=o(),go=i("div"),c(gn.$$.fragment),aa=o(),c(un.$$.fragment),la=o(),L=i("div"),c(fn.$$.fragment),xl=o(),uo=i("p"),uo.textContent=Hr,wl=o(),fo=i("p"),fo.innerHTML=Sr,Tl=o(),q=i("div"),c(hn.$$.fragment),Jl=o(),ho=i("p"),ho.textContent=qr,Il=o(),c(ve.$$.fragment),vl=o(),_o=i("div"),c(_n.$$.fragment),ra=o(),c(bn.$$.fragment),ia=o(),R=i("div"),c(yn.$$.fragment),jl=o(),bo=i("p"),bo.textContent=Dr,Ul=o(),yo=i("p"),yo.innerHTML=Or,Fl=o(),D=i("div"),c(Mn.$$.fragment),Zl=o(),Mo=i("p"),Mo.textContent=Kr,kl=o(),c(je.$$.fragment),Cl=o(),xo=i("div"),c(xn.$$.fragment),pa=o(),c(wn.$$.fragment),da=o(),k=i("div"),c(Tn.$$.fragment),Wl=o(),wo=i("p"),wo.textContent=ei,Gl=o(),To=i("p"),To.innerHTML=ti,Bl=o(),O=i("div"),c(Jn.$$.fragment),Nl=o(),Jo=i("p"),Jo.textContent=ni,Pl=o(),c(Ue.$$.fragment),$l=o(),Fe=i("div"),c(In.$$.fragment),Ll=o(),Io=i("p"),Io.innerHTML=oi,Rl=o(),Ze=i("div"),c(vn.$$.fragment),Xl=o(),vo=i("p"),vo.innerHTML=si,El=o(),ke=i("div"),c(jn.$$.fragment),Vl=o(),jo=i("p"),jo.textContent=ai,Yl=o(),Ce=i("div"),c(Un.$$.fragment),zl=o(),Uo=i("p"),Uo.textContent=li,Ql=o(),Fo=i("div"),c(Fn.$$.fragment),ca=o(),c(Zn.$$.fragment),ma=o(),No=i("p"),this.h()},l(e){const t=_i("svelte-u9bgzb",document.head);d=p(t,"META",{name:!0,content:!0}),t.forEach(n),x=s(e),y=p(e,"P",{}),J(y).forEach(n),_=s(e),m(M.$$.fragment,e),r=s(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),b(w)!=="svelte-si9ct8"&&(w.innerHTML=Al),Ro=s(e),We=p(e,"P",{"data-svelte-h":!0}),b(We)!=="svelte-mlg237"&&(We.innerHTML=Hl),Xo=s(e),Ge=p(e,"P",{"data-svelte-h":!0}),b(Ge)!=="svelte-pdc76o"&&(Ge.innerHTML=Sl),Eo=s(e),m(re.$$.fragment,e),Vo=s(e),Be=p(e,"P",{"data-svelte-h":!0}),b(Be)!=="svelte-193hkal"&&(Be.textContent=ql),Yo=s(e),Ne=p(e,"TABLE",{"data-svelte-h":!0}),b(Ne)!=="svelte-1od5eh6"&&(Ne.innerHTML=Dl),zo=s(e),Pe=p(e,"P",{"data-svelte-h":!0}),b(Pe)!=="svelte-1gsjsi1"&&(Pe.textContent=Ol),Qo=s(e),m($e.$$.fragment,e),Ao=s(e),Le=p(e,"UL",{"data-svelte-h":!0}),b(Le)!=="svelte-459kcz"&&(Le.innerHTML=Kl),Ho=s(e),m(Re.$$.fragment,e),So=s(e),m(Xe.$$.fragment,e),qo=s(e),Ee=p(e,"UL",{"data-svelte-h":!0}),b(Ee)!=="svelte-k8komj"&&(Ee.innerHTML=er),Do=s(e),m(Ve.$$.fragment,e),Oo=s(e),m(Ye.$$.fragment,e),Ko=s(e),ze=p(e,"UL",{"data-svelte-h":!0}),b(ze)!=="svelte-gprzfd"&&(ze.innerHTML=tr),es=s(e),m(Qe.$$.fragment,e),ts=s(e),m(Ae.$$.fragment,e),ns=s(e),He=p(e,"P",{"data-svelte-h":!0}),b(He)!=="svelte-1yhkuyk"&&(He.innerHTML=nr),os=s(e),m(Se.$$.fragment,e),ss=s(e),qe=p(e,"P",{"data-svelte-h":!0}),b(qe)!=="svelte-vqyb98"&&(qe.textContent=or),as=s(e),m(De.$$.fragment,e),ls=s(e),m(Oe.$$.fragment,e),rs=s(e),Ke=p(e,"P",{"data-svelte-h":!0}),b(Ke)!=="svelte-1rzvjcc"&&(Ke.innerHTML=sr),is=s(e),m(et.$$.fragment,e),ps=s(e),tt=p(e,"P",{"data-svelte-h":!0}),b(tt)!=="svelte-1833u4m"&&(tt.textContent=ar),ds=s(e),m(nt.$$.fragment,e),cs=s(e),m(ot.$$.fragment,e),ms=s(e),st=p(e,"UL",{"data-svelte-h":!0}),b(st)!=="svelte-44b2lm"&&(st.innerHTML=lr),gs=s(e),m(at.$$.fragment,e),us=s(e),m(lt.$$.fragment,e),fs=s(e),rt=p(e,"P",{"data-svelte-h":!0}),b(rt)!=="svelte-d7sbsl"&&(rt.innerHTML=rr),hs=s(e),m(it.$$.fragment,e),_s=s(e),m(pt.$$.fragment,e),bs=s(e),dt=p(e,"P",{"data-svelte-h":!0}),b(dt)!=="svelte-107xhla"&&(dt.innerHTML=ir),ys=s(e),m(ct.$$.fragment,e),Ms=s(e),m(ie.$$.fragment,e),xs=s(e),mt=p(e,"P",{"data-svelte-h":!0}),b(mt)!=="svelte-rmmcs6"&&(mt.textContent=pr),ws=s(e),m(gt.$$.fragment,e),Ts=s(e),pe=p(e,"DIV",{class:!0,"data-svelte-h":!0}),b(pe)!=="svelte-1utwd2g"&&(pe.innerHTML=dr),Js=s(e),m(ut.$$.fragment,e),Is=s(e),ft=p(e,"P",{"data-svelte-h":!0}),b(ft)!=="svelte-sphzvr"&&(ft.textContent=cr),vs=s(e),m(ht.$$.fragment,e),js=s(e),_t=p(e,"P",{"data-svelte-h":!0}),b(_t)!=="svelte-yid1se"&&(_t.innerHTML=mr),Us=s(e),bt=p(e,"P",{"data-svelte-h":!0}),b(bt)!=="svelte-1ujwu7j"&&(bt.innerHTML=gr),Fs=s(e),m(de.$$.fragment,e),Zs=s(e),m(yt.$$.fragment,e),ks=s(e),m(Mt.$$.fragment,e),Cs=s(e),xt=p(e,"P",{"data-svelte-h":!0}),b(xt)!=="svelte-17mig8z"&&(xt.innerHTML=ur),Ws=s(e),wt=p(e,"P",{"data-svelte-h":!0}),b(wt)!=="svelte-1gjlc3h"&&(wt.textContent=fr),Gs=s(e),m(Tt.$$.fragment,e),Bs=s(e),m(Jt.$$.fragment,e),Ns=s(e),It=p(e,"P",{"data-svelte-h":!0}),b(It)!=="svelte-1ou2pxc"&&(It.textContent=hr),Ps=s(e),vt=p(e,"P",{"data-svelte-h":!0}),b(vt)!=="svelte-nyi6ih"&&(vt.innerHTML=_r),$s=s(e),m(jt.$$.fragment,e),Ls=s(e),m(Ut.$$.fragment,e),Rs=s(e),Ft=p(e,"P",{"data-svelte-h":!0}),b(Ft)!=="svelte-hittsd"&&(Ft.innerHTML=br),Xs=s(e),m(ce.$$.fragment,e),Es=s(e),Zt=p(e,"P",{"data-svelte-h":!0}),b(Zt)!=="svelte-1pyamwr"&&(Zt.textContent=yr),Vs=s(e),kt=p(e,"P",{"data-svelte-h":!0}),b(kt)!=="svelte-1ljbc3s"&&(kt.innerHTML=Mr),Ys=s(e),m(Ct.$$.fragment,e),zs=s(e),Wt=p(e,"P",{"data-svelte-h":!0}),b(Wt)!=="svelte-15rpvn4"&&(Wt.textContent=xr),Qs=s(e),m(Gt.$$.fragment,e),As=s(e),m(Bt.$$.fragment,e),Hs=s(e),F=p(e,"DIV",{class:!0});var C=J(F);m(Nt.$$.fragment,C),Ta=s(C),Bn=p(C,"P",{"data-svelte-h":!0}),b(Bn)!=="svelte-77uxl4"&&(Bn.textContent=wr),Ja=s(C),Nn=p(C,"P",{"data-svelte-h":!0}),b(Nn)!=="svelte-mxgguy"&&(Nn.innerHTML=Tr),Ia=s(C),Y=p(C,"DIV",{class:!0});var oe=J(Y);m(Pt.$$.fragment,oe),va=s(oe),Pn=p(oe,"P",{"data-svelte-h":!0}),b(Pn)!=="svelte-v78lg8"&&(Pn.textContent=Jr),ja=s(oe),m(me.$$.fragment,oe),oe.forEach(n),Ua=s(C),ge=p(C,"DIV",{class:!0});var kn=J(ge);m($t.$$.fragment,kn),Fa=s(kn),$n=p(kn,"P",{"data-svelte-h":!0}),b($n)!=="svelte-1s3c06i"&&($n.innerHTML=Ir),kn.forEach(n),Za=s(C),ue=p(C,"DIV",{class:!0});var Cn=J(ue);m(Lt.$$.fragment,Cn),ka=s(Cn),Ln=p(Cn,"P",{"data-svelte-h":!0}),b(Ln)!=="svelte-pkn4ui"&&(Ln.innerHTML=vr),Cn.forEach(n),Ca=s(C),fe=p(C,"DIV",{class:!0});var Wn=J(fe);m(Rt.$$.fragment,Wn),Wa=s(Wn),Rn=p(Wn,"P",{"data-svelte-h":!0}),b(Rn)!=="svelte-14bnrb6"&&(Rn.textContent=jr),Wn.forEach(n),Ga=s(C),he=p(C,"DIV",{class:!0});var Gn=J(he);m(Xt.$$.fragment,Gn),Ba=s(Gn),Xn=p(Gn,"P",{"data-svelte-h":!0}),b(Xn)!=="svelte-1xwrf7t"&&(Xn.textContent=Ur),Gn.forEach(n),Na=s(C),En=p(C,"DIV",{class:!0});var Po=J(En);m(Et.$$.fragment,Po),Po.forEach(n),C.forEach(n),Ss=s(e),m(Vt.$$.fragment,e),qs=s(e),B=p(e,"DIV",{class:!0});var X=J(B);m(Yt.$$.fragment,X),Pa=s(X),Vn=p(X,"P",{"data-svelte-h":!0}),b(Vn)!=="svelte-9yovg9"&&(Vn.textContent=Fr),$a=s(X),Yn=p(X,"P",{"data-svelte-h":!0}),b(Yn)!=="svelte-mxgguy"&&(Yn.innerHTML=Zr),La=s(X),z=p(X,"DIV",{class:!0});var se=J(z);m(zt.$$.fragment,se),Ra=s(se),zn=p(se,"P",{"data-svelte-h":!0}),b(zn)!=="svelte-v78lg8"&&(zn.textContent=kr),Xa=s(se),m(_e.$$.fragment,se),se.forEach(n),Ea=s(X),Qn=p(X,"DIV",{class:!0});var $o=J(Qn);m(Qt.$$.fragment,$o),$o.forEach(n),X.forEach(n),Ds=s(e),m(At.$$.fragment,e),Os=s(e),N=p(e,"DIV",{class:!0});var E=J(N);m(Ht.$$.fragment,E),Va=s(E),An=p(E,"P",{"data-svelte-h":!0}),b(An)!=="svelte-9yovg9"&&(An.textContent=Cr),Ya=s(E),Hn=p(E,"P",{"data-svelte-h":!0}),b(Hn)!=="svelte-mxgguy"&&(Hn.innerHTML=Wr),za=s(E),Q=p(E,"DIV",{class:!0});var ae=J(Q);m(St.$$.fragment,ae),Qa=s(ae),Sn=p(ae,"P",{"data-svelte-h":!0}),b(Sn)!=="svelte-v78lg8"&&(Sn.textContent=Gr),Aa=s(ae),m(be.$$.fragment,ae),ae.forEach(n),Ha=s(E),qn=p(E,"DIV",{class:!0});var Lo=J(qn);m(qt.$$.fragment,Lo),Lo.forEach(n),E.forEach(n),Ks=s(e),m(Dt.$$.fragment,e),ea=s(e),P=p(e,"DIV",{class:!0});var K=J(P);m(Ot.$$.fragment,K),Sa=s(K),Dn=p(K,"P",{"data-svelte-h":!0}),b(Dn)!=="svelte-1q2iwpg"&&(Dn.textContent=Br),qa=s(K),On=p(K,"P",{"data-svelte-h":!0}),b(On)!=="svelte-mxgguy"&&(On.innerHTML=Nr),Da=s(K),A=p(K,"DIV",{class:!0});var Zo=J(A);m(Kt.$$.fragment,Zo),Oa=s(Zo),Kn=p(Zo,"P",{"data-svelte-h":!0}),b(Kn)!=="svelte-v78lg8"&&(Kn.textContent=Pr),Ka=s(Zo),m(ye.$$.fragment,Zo),Zo.forEach(n),el=s(K),eo=p(K,"DIV",{class:!0});var ri=J(eo);m(en.$$.fragment,ri),ri.forEach(n),K.forEach(n),ta=s(e),m(tn.$$.fragment,e),na=s(e),$=p(e,"DIV",{class:!0});var ee=J($);m(nn.$$.fragment,ee),tl=s(ee),to=p(ee,"P",{"data-svelte-h":!0}),b(to)!=="svelte-1luolc8"&&(to.textContent=$r),nl=s(ee),no=p(ee,"P",{"data-svelte-h":!0}),b(no)!=="svelte-mxgguy"&&(no.innerHTML=Lr),ol=s(ee),H=p(ee,"DIV",{class:!0});var ko=J(H);m(on.$$.fragment,ko),sl=s(ko),oo=p(ko,"P",{"data-svelte-h":!0}),b(oo)!=="svelte-v78lg8"&&(oo.textContent=Rr),al=s(ko),m(Me.$$.fragment,ko),ko.forEach(n),ll=s(ee),so=p(ee,"DIV",{class:!0});var ii=J(so);m(sn.$$.fragment,ii),ii.forEach(n),ee.forEach(n),oa=s(e),m(an.$$.fragment,e),sa=s(e),Z=p(e,"DIV",{class:!0});var W=J(Z);m(ln.$$.fragment,W),rl=s(W),ao=p(W,"P",{"data-svelte-h":!0}),b(ao)!=="svelte-zx53af"&&(ao.textContent=Xr),il=s(W),lo=p(W,"P",{"data-svelte-h":!0}),b(lo)!=="svelte-mxgguy"&&(lo.innerHTML=Er),pl=s(W),S=p(W,"DIV",{class:!0});var Co=J(S);m(rn.$$.fragment,Co),dl=s(Co),ro=p(Co,"P",{"data-svelte-h":!0}),b(ro)!=="svelte-v78lg8"&&(ro.textContent=Vr),cl=s(Co),m(xe.$$.fragment,Co),Co.forEach(n),ml=s(W),we=p(W,"DIV",{class:!0});var ua=J(we);m(pn.$$.fragment,ua),gl=s(ua),io=p(ua,"P",{"data-svelte-h":!0}),b(io)!=="svelte-1s3c06i"&&(io.innerHTML=Yr),ua.forEach(n),ul=s(W),Te=p(W,"DIV",{class:!0});var fa=J(Te);m(dn.$$.fragment,fa),fl=s(fa),po=p(fa,"P",{"data-svelte-h":!0}),b(po)!=="svelte-pkn4ui"&&(po.innerHTML=zr),fa.forEach(n),hl=s(W),Je=p(W,"DIV",{class:!0});var ha=J(Je);m(cn.$$.fragment,ha),_l=s(ha),co=p(ha,"P",{"data-svelte-h":!0}),b(co)!=="svelte-14bnrb6"&&(co.textContent=Qr),ha.forEach(n),bl=s(W),Ie=p(W,"DIV",{class:!0});var _a=J(Ie);m(mn.$$.fragment,_a),yl=s(_a),mo=p(_a,"P",{"data-svelte-h":!0}),b(mo)!=="svelte-1xwrf7t"&&(mo.textContent=Ar),_a.forEach(n),Ml=s(W),go=p(W,"DIV",{class:!0});var pi=J(go);m(gn.$$.fragment,pi),pi.forEach(n),W.forEach(n),aa=s(e),m(un.$$.fragment,e),la=s(e),L=p(e,"DIV",{class:!0});var te=J(L);m(fn.$$.fragment,te),xl=s(te),uo=p(te,"P",{"data-svelte-h":!0}),b(uo)!=="svelte-9yovg9"&&(uo.textContent=Hr),wl=s(te),fo=p(te,"P",{"data-svelte-h":!0}),b(fo)!=="svelte-mxgguy"&&(fo.innerHTML=Sr),Tl=s(te),q=p(te,"DIV",{class:!0});var Wo=J(q);m(hn.$$.fragment,Wo),Jl=s(Wo),ho=p(Wo,"P",{"data-svelte-h":!0}),b(ho)!=="svelte-v78lg8"&&(ho.textContent=qr),Il=s(Wo),m(ve.$$.fragment,Wo),Wo.forEach(n),vl=s(te),_o=p(te,"DIV",{class:!0});var di=J(_o);m(_n.$$.fragment,di),di.forEach(n),te.forEach(n),ra=s(e),m(bn.$$.fragment,e),ia=s(e),R=p(e,"DIV",{class:!0});var ne=J(R);m(yn.$$.fragment,ne),jl=s(ne),bo=p(ne,"P",{"data-svelte-h":!0}),b(bo)!=="svelte-p02kn2"&&(bo.textContent=Dr),Ul=s(ne),yo=p(ne,"P",{"data-svelte-h":!0}),b(yo)!=="svelte-12zhw7u"&&(yo.innerHTML=Or),Fl=s(ne),D=p(ne,"DIV",{class:!0});var Go=J(D);m(Mn.$$.fragment,Go),Zl=s(Go),Mo=p(Go,"P",{"data-svelte-h":!0}),b(Mo)!=="svelte-v78lg8"&&(Mo.textContent=Kr),kl=s(Go),m(je.$$.fragment,Go),Go.forEach(n),Cl=s(ne),xo=p(ne,"DIV",{class:!0});var ci=J(xo);m(xn.$$.fragment,ci),ci.forEach(n),ne.forEach(n),pa=s(e),m(wn.$$.fragment,e),da=s(e),k=p(e,"DIV",{class:!0});var G=J(k);m(Tn.$$.fragment,G),Wl=s(G),wo=p(G,"P",{"data-svelte-h":!0}),b(wo)!=="svelte-1d13as9"&&(wo.textContent=ei),Gl=s(G),To=p(G,"P",{"data-svelte-h":!0}),b(To)!=="svelte-12zhw7u"&&(To.innerHTML=ti),Bl=s(G),O=p(G,"DIV",{class:!0});var Bo=J(O);m(Jn.$$.fragment,Bo),Nl=s(Bo),Jo=p(Bo,"P",{"data-svelte-h":!0}),b(Jo)!=="svelte-v78lg8"&&(Jo.textContent=ni),Pl=s(Bo),m(Ue.$$.fragment,Bo),Bo.forEach(n),$l=s(G),Fe=p(G,"DIV",{class:!0});var ba=J(Fe);m(In.$$.fragment,ba),Ll=s(ba),Io=p(ba,"P",{"data-svelte-h":!0}),b(Io)!=="svelte-1s3c06i"&&(Io.innerHTML=oi),ba.forEach(n),Rl=s(G),Ze=p(G,"DIV",{class:!0});var ya=J(Ze);m(vn.$$.fragment,ya),Xl=s(ya),vo=p(ya,"P",{"data-svelte-h":!0}),b(vo)!=="svelte-pkn4ui"&&(vo.innerHTML=si),ya.forEach(n),El=s(G),ke=p(G,"DIV",{class:!0});var Ma=J(ke);m(jn.$$.fragment,Ma),Vl=s(Ma),jo=p(Ma,"P",{"data-svelte-h":!0}),b(jo)!=="svelte-14bnrb6"&&(jo.textContent=ai),Ma.forEach(n),Yl=s(G),Ce=p(G,"DIV",{class:!0});var xa=J(Ce);m(Un.$$.fragment,xa),zl=s(xa),Uo=p(xa,"P",{"data-svelte-h":!0}),b(Uo)!=="svelte-1xwrf7t"&&(Uo.textContent=li),xa.forEach(n),Ql=s(G),Fo=p(G,"DIV",{class:!0});var mi=J(Fo);m(Fn.$$.fragment,mi),mi.forEach(n),G.forEach(n),ca=s(e),m(Zn.$$.fragment,e),ma=s(e),No=p(e,"P",{}),J(No).forEach(n),this.h()},h(){T(d,"name","hf:doc:metadata"),T(d,"content",Bi),T(w,"class","flex flex-wrap space-x-1"),T(pe,"class","justify-center"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(En,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(qn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(eo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(so,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(go,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Fo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){a(document.head,d),l(e,x,t),l(e,y,t),l(e,_,t),g(M,e,t),l(e,r,t),l(e,w,t),l(e,Ro,t),l(e,We,t),l(e,Xo,t),l(e,Ge,t),l(e,Eo,t),g(re,e,t),l(e,Vo,t),l(e,Be,t),l(e,Yo,t),l(e,Ne,t),l(e,zo,t),l(e,Pe,t),l(e,Qo,t),g($e,e,t),l(e,Ao,t),l(e,Le,t),l(e,Ho,t),g(Re,e,t),l(e,So,t),g(Xe,e,t),l(e,qo,t),l(e,Ee,t),l(e,Do,t),g(Ve,e,t),l(e,Oo,t),g(Ye,e,t),l(e,Ko,t),l(e,ze,t),l(e,es,t),g(Qe,e,t),l(e,ts,t),g(Ae,e,t),l(e,ns,t),l(e,He,t),l(e,os,t),g(Se,e,t),l(e,ss,t),l(e,qe,t),l(e,as,t),g(De,e,t),l(e,ls,t),g(Oe,e,t),l(e,rs,t),l(e,Ke,t),l(e,is,t),g(et,e,t),l(e,ps,t),l(e,tt,t),l(e,ds,t),g(nt,e,t),l(e,cs,t),g(ot,e,t),l(e,ms,t),l(e,st,t),l(e,gs,t),g(at,e,t),l(e,us,t),g(lt,e,t),l(e,fs,t),l(e,rt,t),l(e,hs,t),g(it,e,t),l(e,_s,t),g(pt,e,t),l(e,bs,t),l(e,dt,t),l(e,ys,t),g(ct,e,t),l(e,Ms,t),g(ie,e,t),l(e,xs,t),l(e,mt,t),l(e,ws,t),g(gt,e,t),l(e,Ts,t),l(e,pe,t),l(e,Js,t),g(ut,e,t),l(e,Is,t),l(e,ft,t),l(e,vs,t),g(ht,e,t),l(e,js,t),l(e,_t,t),l(e,Us,t),l(e,bt,t),l(e,Fs,t),g(de,e,t),l(e,Zs,t),g(yt,e,t),l(e,ks,t),g(Mt,e,t),l(e,Cs,t),l(e,xt,t),l(e,Ws,t),l(e,wt,t),l(e,Gs,t),g(Tt,e,t),l(e,Bs,t),g(Jt,e,t),l(e,Ns,t),l(e,It,t),l(e,Ps,t),l(e,vt,t),l(e,$s,t),g(jt,e,t),l(e,Ls,t),g(Ut,e,t),l(e,Rs,t),l(e,Ft,t),l(e,Xs,t),g(ce,e,t),l(e,Es,t),l(e,Zt,t),l(e,Vs,t),l(e,kt,t),l(e,Ys,t),g(Ct,e,t),l(e,zs,t),l(e,Wt,t),l(e,Qs,t),g(Gt,e,t),l(e,As,t),g(Bt,e,t),l(e,Hs,t),l(e,F,t),g(Nt,F,null),a(F,Ta),a(F,Bn),a(F,Ja),a(F,Nn),a(F,Ia),a(F,Y),g(Pt,Y,null),a(Y,va),a(Y,Pn),a(Y,ja),g(me,Y,null),a(F,Ua),a(F,ge),g($t,ge,null),a(ge,Fa),a(ge,$n),a(F,Za),a(F,ue),g(Lt,ue,null),a(ue,ka),a(ue,Ln),a(F,Ca),a(F,fe),g(Rt,fe,null),a(fe,Wa),a(fe,Rn),a(F,Ga),a(F,he),g(Xt,he,null),a(he,Ba),a(he,Xn),a(F,Na),a(F,En),g(Et,En,null),l(e,Ss,t),g(Vt,e,t),l(e,qs,t),l(e,B,t),g(Yt,B,null),a(B,Pa),a(B,Vn),a(B,$a),a(B,Yn),a(B,La),a(B,z),g(zt,z,null),a(z,Ra),a(z,zn),a(z,Xa),g(_e,z,null),a(B,Ea),a(B,Qn),g(Qt,Qn,null),l(e,Ds,t),g(At,e,t),l(e,Os,t),l(e,N,t),g(Ht,N,null),a(N,Va),a(N,An),a(N,Ya),a(N,Hn),a(N,za),a(N,Q),g(St,Q,null),a(Q,Qa),a(Q,Sn),a(Q,Aa),g(be,Q,null),a(N,Ha),a(N,qn),g(qt,qn,null),l(e,Ks,t),g(Dt,e,t),l(e,ea,t),l(e,P,t),g(Ot,P,null),a(P,Sa),a(P,Dn),a(P,qa),a(P,On),a(P,Da),a(P,A),g(Kt,A,null),a(A,Oa),a(A,Kn),a(A,Ka),g(ye,A,null),a(P,el),a(P,eo),g(en,eo,null),l(e,ta,t),g(tn,e,t),l(e,na,t),l(e,$,t),g(nn,$,null),a($,tl),a($,to),a($,nl),a($,no),a($,ol),a($,H),g(on,H,null),a(H,sl),a(H,oo),a(H,al),g(Me,H,null),a($,ll),a($,so),g(sn,so,null),l(e,oa,t),g(an,e,t),l(e,sa,t),l(e,Z,t),g(ln,Z,null),a(Z,rl),a(Z,ao),a(Z,il),a(Z,lo),a(Z,pl),a(Z,S),g(rn,S,null),a(S,dl),a(S,ro),a(S,cl),g(xe,S,null),a(Z,ml),a(Z,we),g(pn,we,null),a(we,gl),a(we,io),a(Z,ul),a(Z,Te),g(dn,Te,null),a(Te,fl),a(Te,po),a(Z,hl),a(Z,Je),g(cn,Je,null),a(Je,_l),a(Je,co),a(Z,bl),a(Z,Ie),g(mn,Ie,null),a(Ie,yl),a(Ie,mo),a(Z,Ml),a(Z,go),g(gn,go,null),l(e,aa,t),g(un,e,t),l(e,la,t),l(e,L,t),g(fn,L,null),a(L,xl),a(L,uo),a(L,wl),a(L,fo),a(L,Tl),a(L,q),g(hn,q,null),a(q,Jl),a(q,ho),a(q,Il),g(ve,q,null),a(L,vl),a(L,_o),g(_n,_o,null),l(e,ra,t),g(bn,e,t),l(e,ia,t),l(e,R,t),g(yn,R,null),a(R,jl),a(R,bo),a(R,Ul),a(R,yo),a(R,Fl),a(R,D),g(Mn,D,null),a(D,Zl),a(D,Mo),a(D,kl),g(je,D,null),a(R,Cl),a(R,xo),g(xn,xo,null),l(e,pa,t),g(wn,e,t),l(e,da,t),l(e,k,t),g(Tn,k,null),a(k,Wl),a(k,wo),a(k,Gl),a(k,To),a(k,Bl),a(k,O),g(Jn,O,null),a(O,Nl),a(O,Jo),a(O,Pl),g(Ue,O,null),a(k,$l),a(k,Fe),g(In,Fe,null),a(Fe,Ll),a(Fe,Io),a(k,Rl),a(k,Ze),g(vn,Ze,null),a(Ze,Xl),a(Ze,vo),a(k,El),a(k,ke),g(jn,ke,null),a(ke,Vl),a(ke,jo),a(k,Yl),a(k,Ce),g(Un,Ce,null),a(Ce,zl),a(Ce,Uo),a(k,Ql),a(k,Fo),g(Fn,Fo,null),l(e,ca,t),g(Zn,e,t),l(e,ma,t),l(e,No,t),ga=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),re.$set(C);const oe={};t&2&&(oe.$$scope={dirty:t,ctx:e}),ie.$set(oe);const kn={};t&2&&(kn.$$scope={dirty:t,ctx:e}),de.$set(kn);const Cn={};t&2&&(Cn.$$scope={dirty:t,ctx:e}),ce.$set(Cn);const Wn={};t&2&&(Wn.$$scope={dirty:t,ctx:e}),me.$set(Wn);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),_e.$set(Gn);const Po={};t&2&&(Po.$$scope={dirty:t,ctx:e}),be.$set(Po);const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),ye.$set(X);const se={};t&2&&(se.$$scope={dirty:t,ctx:e}),Me.$set(se);const $o={};t&2&&($o.$$scope={dirty:t,ctx:e}),xe.$set($o);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),ve.$set(E);const ae={};t&2&&(ae.$$scope={dirty:t,ctx:e}),je.$set(ae);const Lo={};t&2&&(Lo.$$scope={dirty:t,ctx:e}),Ue.$set(Lo)},i(e){ga||(u(M.$$.fragment,e),u(re.$$.fragment,e),u($e.$$.fragment,e),u(Re.$$.fragment,e),u(Xe.$$.fragment,e),u(Ve.$$.fragment,e),u(Ye.$$.fragment,e),u(Qe.$$.fragment,e),u(Ae.$$.fragment,e),u(Se.$$.fragment,e),u(De.$$.fragment,e),u(Oe.$$.fragment,e),u(et.$$.fragment,e),u(nt.$$.fragment,e),u(ot.$$.fragment,e),u(at.$$.fragment,e),u(lt.$$.fragment,e),u(it.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(ie.$$.fragment,e),u(gt.$$.fragment,e),u(ut.$$.fragment,e),u(ht.$$.fragment,e),u(de.$$.fragment,e),u(yt.$$.fragment,e),u(Mt.$$.fragment,e),u(Tt.$$.fragment,e),u(Jt.$$.fragment,e),u(jt.$$.fragment,e),u(Ut.$$.fragment,e),u(ce.$$.fragment,e),u(Ct.$$.fragment,e),u(Gt.$$.fragment,e),u(Bt.$$.fragment,e),u(Nt.$$.fragment,e),u(Pt.$$.fragment,e),u(me.$$.fragment,e),u($t.$$.fragment,e),u(Lt.$$.fragment,e),u(Rt.$$.fragment,e),u(Xt.$$.fragment,e),u(Et.$$.fragment,e),u(Vt.$$.fragment,e),u(Yt.$$.fragment,e),u(zt.$$.fragment,e),u(_e.$$.fragment,e),u(Qt.$$.fragment,e),u(At.$$.fragment,e),u(Ht.$$.fragment,e),u(St.$$.fragment,e),u(be.$$.fragment,e),u(qt.$$.fragment,e),u(Dt.$$.fragment,e),u(Ot.$$.fragment,e),u(Kt.$$.fragment,e),u(ye.$$.fragment,e),u(en.$$.fragment,e),u(tn.$$.fragment,e),u(nn.$$.fragment,e),u(on.$$.fragment,e),u(Me.$$.fragment,e),u(sn.$$.fragment,e),u(an.$$.fragment,e),u(ln.$$.fragment,e),u(rn.$$.fragment,e),u(xe.$$.fragment,e),u(pn.$$.fragment,e),u(dn.$$.fragment,e),u(cn.$$.fragment,e),u(mn.$$.fragment,e),u(gn.$$.fragment,e),u(un.$$.fragment,e),u(fn.$$.fragment,e),u(hn.$$.fragment,e),u(ve.$$.fragment,e),u(_n.$$.fragment,e),u(bn.$$.fragment,e),u(yn.$$.fragment,e),u(Mn.$$.fragment,e),u(je.$$.fragment,e),u(xn.$$.fragment,e),u(wn.$$.fragment,e),u(Tn.$$.fragment,e),u(Jn.$$.fragment,e),u(Ue.$$.fragment,e),u(In.$$.fragment,e),u(vn.$$.fragment,e),u(jn.$$.fragment,e),u(Un.$$.fragment,e),u(Fn.$$.fragment,e),u(Zn.$$.fragment,e),ga=!0)},o(e){f(M.$$.fragment,e),f(re.$$.fragment,e),f($e.$$.fragment,e),f(Re.$$.fragment,e),f(Xe.$$.fragment,e),f(Ve.$$.fragment,e),f(Ye.$$.fragment,e),f(Qe.$$.fragment,e),f(Ae.$$.fragment,e),f(Se.$$.fragment,e),f(De.$$.fragment,e),f(Oe.$$.fragment,e),f(et.$$.fragment,e),f(nt.$$.fragment,e),f(ot.$$.fragment,e),f(at.$$.fragment,e),f(lt.$$.fragment,e),f(it.$$.fragment,e),f(pt.$$.fragment,e),f(ct.$$.fragment,e),f(ie.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ht.$$.fragment,e),f(de.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(Tt.$$.fragment,e),f(Jt.$$.fragment,e),f(jt.$$.fragment,e),f(Ut.$$.fragment,e),f(ce.$$.fragment,e),f(Ct.$$.fragment,e),f(Gt.$$.fragment,e),f(Bt.$$.fragment,e),f(Nt.$$.fragment,e),f(Pt.$$.fragment,e),f(me.$$.fragment,e),f($t.$$.fragment,e),f(Lt.$$.fragment,e),f(Rt.$$.fragment,e),f(Xt.$$.fragment,e),f(Et.$$.fragment,e),f(Vt.$$.fragment,e),f(Yt.$$.fragment,e),f(zt.$$.fragment,e),f(_e.$$.fragment,e),f(Qt.$$.fragment,e),f(At.$$.fragment,e),f(Ht.$$.fragment,e),f(St.$$.fragment,e),f(be.$$.fragment,e),f(qt.$$.fragment,e),f(Dt.$$.fragment,e),f(Ot.$$.fragment,e),f(Kt.$$.fragment,e),f(ye.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(on.$$.fragment,e),f(Me.$$.fragment,e),f(sn.$$.fragment,e),f(an.$$.fragment,e),f(ln.$$.fragment,e),f(rn.$$.fragment,e),f(xe.$$.fragment,e),f(pn.$$.fragment,e),f(dn.$$.fragment,e),f(cn.$$.fragment,e),f(mn.$$.fragment,e),f(gn.$$.fragment,e),f(un.$$.fragment,e),f(fn.$$.fragment,e),f(hn.$$.fragment,e),f(ve.$$.fragment,e),f(_n.$$.fragment,e),f(bn.$$.fragment,e),f(yn.$$.fragment,e),f(Mn.$$.fragment,e),f(je.$$.fragment,e),f(xn.$$.fragment,e),f(wn.$$.fragment,e),f(Tn.$$.fragment,e),f(Jn.$$.fragment,e),f(Ue.$$.fragment,e),f(In.$$.fragment,e),f(vn.$$.fragment,e),f(jn.$$.fragment,e),f(Un.$$.fragment,e),f(Fn.$$.fragment,e),f(Zn.$$.fragment,e),ga=!1},d(e){e&&(n(x),n(y),n(_),n(r),n(w),n(Ro),n(We),n(Xo),n(Ge),n(Eo),n(Vo),n(Be),n(Yo),n(Ne),n(zo),n(Pe),n(Qo),n(Ao),n(Le),n(Ho),n(So),n(qo),n(Ee),n(Do),n(Oo),n(Ko),n(ze),n(es),n(ts),n(ns),n(He),n(os),n(ss),n(qe),n(as),n(ls),n(rs),n(Ke),n(is),n(ps),n(tt),n(ds),n(cs),n(ms),n(st),n(gs),n(us),n(fs),n(rt),n(hs),n(_s),n(bs),n(dt),n(ys),n(Ms),n(xs),n(mt),n(ws),n(Ts),n(pe),n(Js),n(Is),n(ft),n(vs),n(js),n(_t),n(Us),n(bt),n(Fs),n(Zs),n(ks),n(Cs),n(xt),n(Ws),n(wt),n(Gs),n(Bs),n(Ns),n(It),n(Ps),n(vt),n($s),n(Ls),n(Rs),n(Ft),n(Xs),n(Es),n(Zt),n(Vs),n(kt),n(Ys),n(zs),n(Wt),n(Qs),n(As),n(Hs),n(F),n(Ss),n(qs),n(B),n(Ds),n(Os),n(N),n(Ks),n(ea),n(P),n(ta),n(na),n($),n(oa),n(sa),n(Z),n(aa),n(la),n(L),n(ra),n(ia),n(R),n(pa),n(da),n(k),n(ca),n(ma),n(No)),n(d),h(M,e),h(re,e),h($e,e),h(Re,e),h(Xe,e),h(Ve,e),h(Ye,e),h(Qe,e),h(Ae,e),h(Se,e),h(De,e),h(Oe,e),h(et,e),h(nt,e),h(ot,e),h(at,e),h(lt,e),h(it,e),h(pt,e),h(ct,e),h(ie,e),h(gt,e),h(ut,e),h(ht,e),h(de,e),h(yt,e),h(Mt,e),h(Tt,e),h(Jt,e),h(jt,e),h(Ut,e),h(ce,e),h(Ct,e),h(Gt,e),h(Bt,e),h(Nt),h(Pt),h(me),h($t),h(Lt),h(Rt),h(Xt),h(Et),h(Vt,e),h(Yt),h(zt),h(_e),h(Qt),h(At,e),h(Ht),h(St),h(be),h(qt),h(Dt,e),h(Ot),h(Kt),h(ye),h(en),h(tn,e),h(nn),h(on),h(Me),h(sn),h(an,e),h(ln),h(rn),h(xe),h(pn),h(dn),h(cn),h(mn),h(gn),h(un,e),h(fn),h(hn),h(ve),h(_n),h(bn,e),h(yn),h(Mn),h(je),h(xn),h(wn,e),h(Tn),h(Jn),h(Ue),h(In),h(vn),h(jn),h(Un),h(Fn),h(Zn,e)}}}const Bi='{"title":"Flux","local":"flux","sections":[{"title":"Timestep-distilled","local":"timestep-distilled","sections":[],"depth":3},{"title":"Guidance-distilled","local":"guidance-distilled","sections":[],"depth":3},{"title":"Fill Inpainting/Outpainting","local":"fill-inpaintingoutpainting","sections":[],"depth":3},{"title":"Canny Control","local":"canny-control","sections":[],"depth":3},{"title":"Depth Control","local":"depth-control","sections":[],"depth":3},{"title":"Redux","local":"redux","sections":[],"depth":3},{"title":"Combining Flux Turbo LoRAs with Flux Control, Fill, and Redux","local":"combining-flux-turbo-loras-with-flux-control-fill-and-redux","sections":[],"depth":2},{"title":"Note about unload_lora_weights() when using Flux LoRAs","local":"note-about-unloadloraweights-when-using-flux-loras","sections":[],"depth":2},{"title":"IP-Adapter","local":"ip-adapter","sections":[],"depth":2},{"title":"Optimize","local":"optimize","sections":[{"title":"Group offloading","local":"group-offloading","sections":[],"depth":3},{"title":"Running FP16 inference","local":"running-fp16-inference","sections":[],"depth":3},{"title":"Quantization","local":"quantization","sections":[],"depth":3}],"depth":2},{"title":"Single File Loading for the FluxTransformer2DModel","local":"single-file-loading-for-the-fluxtransformer2dmodel","sections":[],"depth":2},{"title":"FluxPipeline","local":"diffusers.FluxPipeline","sections":[],"depth":2},{"title":"FluxImg2ImgPipeline","local":"diffusers.FluxImg2ImgPipeline","sections":[],"depth":2},{"title":"FluxInpaintPipeline","local":"diffusers.FluxInpaintPipeline","sections":[],"depth":2},{"title":"FluxControlNetInpaintPipeline","local":"diffusers.FluxControlNetInpaintPipeline","sections":[],"depth":2},{"title":"FluxControlNetImg2ImgPipeline","local":"diffusers.FluxControlNetImg2ImgPipeline","sections":[],"depth":2},{"title":"FluxControlPipeline","local":"diffusers.FluxControlPipeline","sections":[],"depth":2},{"title":"FluxControlImg2ImgPipeline","local":"diffusers.FluxControlImg2ImgPipeline","sections":[],"depth":2},{"title":"FluxPriorReduxPipeline","local":"diffusers.FluxPriorReduxPipeline","sections":[],"depth":2},{"title":"FluxFillPipeline","local":"diffusers.FluxFillPipeline","sections":[],"depth":2}],"depth":1}';function Ni(v){return ui(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yi extends fi{constructor(d){super(),hi(this,d,Ni,Gi,gi,{})}}export{Yi as component};
