import{s as zn,f as xs,n as Nn,o as Dn}from"../chunks/scheduler.048ce5c2.js";import{S as En,i as Fn,g as A,s as a,r as i,A as On,h as p,f as t,c as n,j as Sn,u as r,x as o,k as m,y as Qn,a as l,v as M,d as j,t as c,w as y}from"../chunks/index.2633050f.js";import{C as w}from"../chunks/CodeBlock.b34ffc90.js";import{D as qn}from"../chunks/DocNotebookDropdown.2a84b269.js";import{H as u,E as Ln}from"../chunks/EditOnGithub.336973dd.js";function Yn(Ma){let d,zs,Ks,Ns,U,Ds,f,Es,g,ja="In this notebook, we’re going to cover two main approaches for adapting existing diffusion models:",Fs,I,ca="<li>With <strong>fine-tuning</strong>, we’ll re-train existing models on new data to change the type of output they produce</li> <li>With <strong>guidance</strong>, we’ll take an existing model and steer the generation process at inference time for additional control</li>",Os,J,Qs,b,ya="By the end of this notebook, you will know how to:",qs,T,wa='<li>Create a sampling loop and generate samples faster using a new scheduler</li> <li>Fine-tune an existing diffusion model on new data, including:<ul><li>Using gradient accumulation to get around some of the issues with small batches</li> <li>Logging samples to <a href="https://wandb.ai/site" rel="nofollow">Weights and Biases</a> during training to monitor progress (via the accompanying example script)</li> <li>Saving the resulting pipeline and uploading it to the hub</li></ul></li> <li>Guide the sampling process with additional loss functions to add control over existing models, including:<ul><li>Exploring different guidance approaches with a simple color-based loss</li> <li>Using CLIP to guide generation using a text prompt</li> <li>Sharing a custom sampling loop using Gradio and 🤗 Spaces</li></ul></li>',Ls,R,ua='❓If you have any questions, please post them on the <code>#diffusion-models-class</code> channel on the Hugging Face Discord server. If you haven’t signed up yet, you can do so here: <a href="https://huggingface.co/join/discord" rel="nofollow">https://huggingface.co/join/discord</a>',Ys,h,_s,B,da="To save your fine-tuned models to the Hugging Face Hub, you’ll need to login with a <strong>token that has write access</strong>. The code below will prompt you for this and link to the relevant tokens page of your account. You’ll also need a Weights and Biases account if you’d like to use the training script to log samples as the model trains - again, the code should prompt you to sign in where needed.",$s,H,ma="Apart from that, the only set-up is installing a few dependencies, importing everything we’ll need and specifying which device we’ll use:",et,k,st,v,tt,C,Ua=`Token is valid.
Your token has been saved in your configured git credential helpers (store).
Your token has been saved to /root/.huggingface/token
Login successful
`,lt,G,at,P,nt,X,At,Z,fa="To begin this notebook, let’s load an existing pipeline and see what we can do with it:",pt,W,ot,V,ga='Generating images is as simple as running the <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ddpm/pipeline_ddpm.py#L42" rel="nofollow"><code>__call__</code></a> method of the pipeline by calling it like a function:',it,x,rt,Gs,Ia,Mt,K,Ja="Neat, but SLOW! So, before we get to the main topics of today, let’s take a peek at the actual sampling loop and see how we can use a fancier sampler to speed this up:",jt,S,ct,z,ba="At every step, the model is fed a noisy input and asked to predict the noise (and thus an estimate of what the fully denoised image might look like). Initially these predictions are not very good, which is why we break the process down into many steps. However, using 1000+ steps has been found to be unnecessary, and a flurry of recent research has explored how to achieve good samples with as few steps as possible.",yt,N,Ta="In the 🤗 Diffusers library, these <strong>sampling methods are handled by a scheduler</strong>, which must perform each update via the <code>step()</code> function. To generate an image, we begin with random noise $x$. Then, for every timestep in the scheduler’s noise schedule, we feed the noisy input $x$ to the model and pass the resulting prediction to the <code>step()</code> function. This returns an output with a <code>prev_sample</code> attribute - previous because we’re going “backwards” in time from high noise to low noise (the opposite of the forward diffusion process).",wt,D,Ra='Let’s see this in action! First, we load a scheduler, here a DDIMScheduler based on the paper <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">Denoising Diffusion Implicit Models</a> which can give decent samples in much fewer steps than the original DDPM implementation:',ut,E,dt,F,ha="You can see that this model does 40 steps total, each jumping the equivalent of 25 steps of the original 1000-step schedule:",mt,O,Ut,Q,Ba="Let’s create 4 random images and run through the sampling loop, viewing both the current $x$ and the predicted denoised version as the process progresses:",ft,q,gt,Ps,Ha,It,L,ka="As you can see, the initial predictions are not great but as the process goes on the predicted outputs get more and more refined. If you’re curious what maths is happening inside that <code>step()</code> function, inspect the (well-commented) code with:",Jt,Y,bt,_,va="You can also drop in this new scheduler in place of the original one that came with the pipeline, and sample like so:",Tt,$,Rt,Xs,Ca,ht,ee,Ga="Alright - we can get samples in a reasonable time now! This should speed things up as we move through the rest of this notebook :)",Bt,se,Ht,te,Pa="Now for the fun bit! Given this pre-trained pipeline, how might we re-train the model to generate images based on new training data?",kt,le,Xa='It turns out that this looks nearly identical to training a model from scratch (as we saw in <a href="https://github.com/huggingface/diffusion-models-class/tree/main/unit1" rel="nofollow">Unit 1</a>) except that we begin with the existing model. Let’s see this in action and talk about a few additional considerations as we go.',vt,ae,Za='First, the dataset: you could try <a href="https://huggingface.co/datasets/Norod78/Vintage-Faces-FFHQAligned" rel="nofollow">this vintage faces dataset</a> or <a href="https://huggingface.co/datasets/huggan/anime-faces" rel="nofollow">these anime faces</a> for something closer to the original training data of this faces model, but just for fun let’s instead use the same small butterflies dataset we used to train from scratch in Unit 1. Run the code below to download the butterflies dataset and create a dataloader we can sample a batch of images from:',Ct,ne,Gt,Ae,Wa=`Previewing batch:
`,Pt,pe,Va="<strong>Consideration 1:</strong> our batch size here (4) is pretty small, since we’re training at large image size (256px) using a fairly large model and we’ll run out of GPU RAM if we push the batch size too high. You can reduce the image size to speed things up and allow for larger batches, but these models were designed and originally trained for 256px generation.",Xt,oe,xa="Now for the training loop. We’ll update the weights of the pre-trained model by setting the optimization target to <code>image_pipe.unet.parameters()</code>. The rest is nearly identical to the example training loop from Unit 1. This takes about 10 minutes to run on Colab, so now is a good time to grab a coffee of tea while you wait:",Zt,ie,Wt,re,Ka=`Epoch 0 average loss: 0.013324214214226231
`,Vt,Me,Sa="<strong>Consideration 2:</strong> Our loss signal is extremely noisy, since we’re only working with four examples at random noise levels for each step. This is not ideal for training. One fix is to use an extremely low learning rate to limit the size of the update each step. It would be even better if we could find some way to get the same benefit we would get from using a larger batch size <em>without</em> the memory requirements skyrocketing…",xt,je,za='Enter <a href="https://kozodoi.me/python/deep%20learning/pytorch/tutorial/2021/02/19/gradient-accumulation.html#:~:text=Simply%20speaking%2C%20gradient%20accumulation%20means,might%20find%20this%20tutorial%20useful." rel="nofollow">gradient accumulation</a>. If we call <code>loss.backward()</code> multiple times before running <code>optimizer.step()</code> and <code>optimizer.zero_grad()</code>, then PyTorch accumulates (sums) the gradients, effectively merging the signal from several batches to give a single (better) estimate which is then used to update the parameters. This results in fewer total updates being made, just like we’d see if we used a larger batch size. This is something many frameworks will handle for you (for example, <a href="https://huggingface.co/docs/accelerate/usage_guides/gradient_accumulation" rel="nofollow">🤗 Accelerate makes this easy</a>) but it is nice to see it implemented from scratch since this is a useful technique for dealing with training under GPU memory constraints! As you can see from the code above (after the <code># Gradient accumulation</code> comment) there really isn’t much code needed.',Kt,ce,St,ye,Na="<strong>Consideration 3:</strong> This still takes a lot of time, and printing out a one-line update every epoch is not enough feedback to give us a good idea of what is going on. We should probably:",zt,we,Da="<li>Generate some samples occasionally to visually examine the performance qualitatively as the model trains</li> <li>Log things like the loss and sample generations during training, perhaps using something like Weights and Biases or tensorboard.</li>",Nt,ue,Ea='I created a quick script (<a href="https://github.com/huggingface/diffusion-models-class/blob/main/unit2/finetune_model.py" rel="nofollow"><code>finetune_model.py</code></a>) that takes the training code above and adds minimal logging functionality. You can see the <a href="https://wandb.ai/johnowhitaker/dm_finetune/runs/2upaa341" rel="nofollow">logs from one training run here</a> below:',Dt,de,Et,me,Fa="It’s fun to see how the generated samples change as training progresses - even though the loss doesn’t appear to be improving much, we can see a progression away from the original domain (images of bedrooms) towards the new training data (wikiart). At the end of this notebook is commented-out code for fine-tuning a model using this script as an alternative to running the cell above.",Ft,Ue,Ot,fe,Oa="Generating some images with this model, we can see that these faces are already looking mighty strange!",Qt,ge,qt,Zs,Qa,Lt,Ie,qa="<strong>Consideration 4:</strong> Fine-tuning can be quite unpredictable! If we trained for a lot longer, we might see some perfect butterflies. But the intermediate steps can be extremely interesting in their own right, especially if your interests are more towards the artistic side! Explore training for very short or very long periods of time, and varying the learning rate to see how this affects the kinds of output the final model produces.",Yt,Je,_t,be,La="If you’d like to train a similar model to the one I made on WikiArt, you can uncomment and run the cells below. Since this takes a while and may exhaust your GPU memory, I recommend doing this <em>after</em> working through the rest of this notebook.",$t,Te,el,Re,sl,he,tl,Be,Ya="Now that we’ve fine-tuned the U-Net in our diffusion model, let’s save it to a local folder by running:",ll,He,al,ke,_a="As we saw in Unit 1, this will save the config, model, scheduler:",nl,ve,Al,Ce,$a=`model_index.json  scheduler  unet
`,pl,Ge,en='Next, you can follow the same steps outlined in Unit 1’s <a href="https://github.com/huggingface/diffusion-models-class/blob/main/unit1/01_introduction_to_diffusers.ipynb" rel="nofollow">Introduction to Diffusers</a> to push the model to the Hub for later use:',ol,Pe,il,Xe,sn='"""',rl,Ze,tn=`card = ModelCard(content)
card.push_to_hub(hub_model_id)`,Ml,We,jl,Ws,ln,cl,Ve,an='<strong>Consideration 5:</strong> It is often hard to tell how well fine-tuning is working, and what ‘good performance’ means may vary by use-case. For example, if you’re fine-tuning a text-conditioned model like stable diffusion on a small dataset you probably want it to <strong>retain</strong> most of its original training so that it can understand arbitrary prompts not covered by your new dataset, while <strong>adapting</strong> to better match the style of your new training data. This could mean using a low learning rate alongside something like exponential model averaging, as demonstrated <a href="https://lambdalabs.com/blog/how-to-fine-tune-stable-diffusion-how-we-made-the-text-to-pokemon-model-at-lambda" rel="nofollow">in this great blog post about creating a pokemon version of stable diffusion</a>. In a different situation, you may want to completely re-train a model on new data (such as our bedroom -&gt; wikiart example) in which case a larger learning rate and more training makes sense. Even though the <a href="https://wandb.ai/johnowhitaker/dm_finetune/runs/2upaa341" rel="nofollow">loss plot</a> is not showing much improvement, the samples clearly show a move away from the original data and towards more ‘artsy’ outputs, although they remain mostly incoherent.',yl,xe,nn="Which leads us to a the next section, as we examine how we might add additional guidance to such a model for better control over the outputs…",wl,Ke,ul,Se,An="What do we do if we want some control over the samples generated? For example, say we wanted to bias the generated images to be a specific color. How would we go about that? Enter <strong>guidance</strong>, a technique for adding additional control to the sampling process.",dl,ze,pn="Step one is to create our conditioning function: some measure (loss) which we’d like to minimize. Here’s one for the color example, which compares the pixels of an image to a target color (by default a sort of light teal) and returns the average error:",ml,Ne,Ul,De,on="Next, we’ll make a modified version of the sampling loop where, at each step, we do the following:",fl,Ee,rn="<li>Create a new version of x that has requires_grad = True</li> <li>Calculate the denoised version (x0)</li> <li>Feed the predicted x0 through our loss function</li> <li>Find the <strong>gradient</strong> of this loss function with respect to x</li> <li>Use this conditioning gradient to modify x before we step with the scheduler, hopefully pushing x in a direction that will lead to lower loss according to our guidance function</li>",gl,Fe,Mn="There are two variants here that you can explore. In the first, we set requires_grad on x <strong>after</strong> we get our noise prediction from the UNet, which is more memory efficient (since we don’t have to trace gradients back through the diffusion model) but gives a less accurate gradient. In the second we set requires_grad on x <strong>first</strong>, then feed it through the UNet and calculate the predicted x0.",Il,Oe,Jl,Qe,jn=`0 loss: 27.279136657714844
10 loss: 11.286816596984863
20 loss: 10.683112144470215
30 loss: 10.942476272583008
`,bl,qe,cn="This second option requires nearly double the GPU RAM to run, even though we only generate a batch of four images instead of eight. See if you can spot the difference, and think through why this way is more ‘accurate’:",Tl,Le,Rl,Ye,yn=`0 loss: 30.750328063964844
10 loss: 18.550724029541016
20 loss: 17.515094757080078
30 loss: 17.55681037902832
`,hl,_e,wn="In the second variant, the memory requirements are higher and the effect is less pronounced, so you may think that this is inferior. However, the outputs are arguably closer to the types of images the model was trained on, and you can always increase the guidance scale for a stronger effect. Which approach you use will ultimately come down to what works best experimentally.",Bl,$e,Hl,es,kl,ss,un="Guiding towards a color gives us a little bit of control, but what if we could just type some text describing what we want?",vl,ts,dn='<a href="https://openai.com/blog/clip/" rel="nofollow">CLIP</a> is a model created by OpenAI that allows us to compare images to text captions. This is extremely powerful, since it allows us to quantify how well an image matches a prompt. And since the process is differentiable, we can use this as a loss function to guide our diffusion model!',Cl,ls,mn="We won’t go too much into the details here. The basic approach is as follows:",Gl,as,Un="<li>Embed the text prompt to get a 512-dimensional CLIP embedding of the text</li> <li>For every step in the diffusion model process:<ul><li>Make several variants of the predicted denoised image (having multiple variations gives a cleaner loss signal)</li> <li>For each one, embed the image with CLIP and compare this embedding with the text embedding of the prompt (using a measure called ‘Great Circle Distance Squared’)</li></ul></li> <li>Calculate the gradient of this loss with respect to the current noisy x and use this gradient to modify x before updating it with the scheduler.</li>",Pl,ns,fn='For a deeper explanation of CLIP, check out <a href="https://johnowhitaker.github.io/tglcourse/clip.html" rel="nofollow">this lesson on the topic</a> or <a href="https://wandb.ai/johnowhitaker/openclip-benchmarking/reports/Exploring-OpenCLIP--VmlldzoyOTIzNzIz" rel="nofollow">this report on the OpenCLIP project</a> which we’re using to load the CLIP model. Run the next cell to load a CLIP model:',Xl,As,Zl,ps,gn="With a loss function defined, our guided sampling loop looks similar to the previous examples, replacing <code>color_loss()</code> with our new clip-based loss function:",Wl,os,Vl,is,In=`Step: 0 , Guidance loss: 7.437869548797607
Step: 25 , Guidance loss: 7.174620628356934
`,xl,rs,Jn="Those look sort of like roses! It’s not perfect, but if you play around with the settings you can get some pleasing images with this.",Kl,Ms,bn="If you examine the code above you’ll see I’m scaling the conditioning gradient by a factor of <code>alpha_bar.sqrt()</code>. There is some theory showing the ‘right’ way to scale these gradients, but in practice this is also something you can experiment with. For some types of guidance, you may want most of the effect concentrated in the early steps, for others (say, a style loss focused on textures) you may prefer that they only kick in towards the end of the generation process. Some possible schedules are shown below:",Sl,js,zl,Vs,Tn,Nl,cs,Rn="Experiment with different schedules, guidance scales and any other tricks you can think of (clipping the gradients within some range is a popular modification) to see how good you can get this! Also make sure you try swapping in other models. Perhaps the faces model we loaded at the start - can you reliably guide it to produce a male face? What if you combine CLIP guidance with the color loss we used earlier? Etc.",Dl,ys,hn='If you check out <a href="https://huggingface.co/spaces/EleutherAI/clip-guided-diffusion/blob/main/app.py" rel="nofollow">some code for CLIP-guided diffusion in practice</a>, you’ll see a more complex approach with a better class for picking random cutouts from the images and lots of additional tweaks to the loss function for better performance. Before text-conditioned diffusion models came along, this was the best text-to-image system there was! Our little toy version here has lots of room to improve, but it captures the core idea: thanks to guidance plus the amazing capabilities of CLIP, we can add text control to an unconditional diffusion model 🎨.',El,ws,Fl,us,Bn="Perhaps you’ve figured out a fun loss to guide generation with, and you now want to share both your fine-tuned model and this custom sampling strategy with the world…",Ol,ds,Hn='Enter <a href="https://gradio.app/" rel="nofollow">Gradio</a>. Gradio is a free and open-source tool that allows users to easily create and share interactive machine learning models through a simple web interface. With Gradio, users can build custom interfaces for their machine learning models, which can then be shared with others through a unique URL. It is also integrated into 🤗 Spaces which makes it easy to host demos and share them with others.',Ql,ms,kn='We’ll put our core logic in a function that takes some inputs and produces an image as the output. This can then be wrapped in a simple interface that allows the user to specify some parameters (which are passed as inputs to the main generate function). There are many <a href="https://gradio.app/docs/#components" rel="nofollow">components</a> available - for this example we’ll use a slider for the guidance scale and a color picker to define the target color.',ql,Us,Ll,fs,Yl,gs,vn="It is possible to build much more complicated interfaces, with fancy styling and a wide array of possible inputs, but for this demo we’re keeping it as simple as possible.",_l,Is,Cn="Demos on 🤗 Spaces run on CPU by default, so it’s nice to prototype your interface in Colab (as above) before migrating over. When you’re ready to share your demo, you’ll create a space, set up a <code>requirements.txt</code> file listing the libraries your code will use and then place all the code in an <code>app.py</code> file which defines the relevant functions and the interface.",$l,Js,Gn='<img src="data:image/png;base64,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" alt="Screenshot from 2022-12-11 10-28-26.png"/>',ea,bs,Pn='Lucky for you, there’s also an option to ‘Duplicate’ a space. You can visit my demo space <a href="https://huggingface.co/spaces/johnowhitaker/color-guided-wikiart-diffusion" rel="nofollow">here</a> (shown above) and click ‘Duplicate this Space’ to get a template which you can then modify to use your own model and guidance function.',sa,Ts,Xn="In the settings, you can configure your space to run on fancier hardware (which is charged per hour). Made something amazing and want to share it on better hardware but don’t have the money? Let us know via Discord and we’ll see if we can help!",ta,Rs,la,hs,Zn="We’ve covered a lot in this notebook! Let’s recap the core ideas:",aa,Bs,Wn="<li>It’s relatively easy to load in existing models and sample them with different schedulers</li> <li>Fine-tuning looks just like training from scratch, except that by starting from an existing model we hope to get better results more quickly</li> <li>To fine-tune large models on big images, we can use tricks like gradient accumulation to get around batch size limitations</li> <li>Logging sample images is important for fine-tuning, where a loss curve might not show much useful information</li> <li>Guidance allows us to take an unconditional model and steer the generation process based on some guidance/loss function, where at each step we find the gradient of the loss with respect to the noisy image x and update it according to this gradient before moving on to the next timestep</li> <li>Guiding with CLIP let’s us control unconditional models with text!</li>",na,Hs,Vn="To put this into practice, here are some specific next steps you can take:",Aa,ks,xn='<li>Fine-tune your own model and push it to the hub. This will involve picking a starting point (e.g. a model trained on <a href="https://huggingface.co/google/ddpm-celebahq-256" rel="nofollow">faces</a>, <a href="https://huggingface.co/fusing/ddpm-lsun-bedroom" rel="nofollow">bedrooms</a>, <a href="https://huggingface.co/fusing/ddpm-lsun-cat" rel="nofollow">cats</a> or the <a href="https://huggingface.co/johnowhitaker/sd-class-wikiart-from-bedrooms" rel="nofollow">wikiart example above</a>) and a dataset (perhaps these <a href="https://huggingface.co/datasets/huggan/AFHQv2" rel="nofollow">animal faces</a> or your own images) and then running either the code in this notebook or the example script (demo usage below).</li> <li>Explore guidance using your fine-tuned model, either using one of the example guidance functions (color_loss or CLIP) or inventing your own.</li> <li>Share a demo based on this using Gradio, either modifying the <a href="https://huggingface.co/spaces/johnowhitaker/color-guided-wikiart-diffusion" rel="nofollow">example space</a> to use your own model or creating your own custom version with more functionality.</li>',pa,vs,Kn="We look forward to seeing your results on Discord, Twitter, and elsewhere 🤗!",oa,Cs,ia,Ss,ra;return U=new qn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/diffusion-models-class/blob/main/unit2/01_finetuning_and_guidance.ipynb"}]}}),f=new u({props:{title:"Fine-Tuning and Guidance",local:"fine-tuning-and-guidance",headingTag:"h1"}}),J=new u({props:{title:"What You Will Learn:",local:"what-you-will-learn",headingTag:"h2"}}),h=new u({props:{title:"Setup and Imports",local:"setup-and-imports",headingTag:"h2"}}),k=new w({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xcSUyMGRpZmZ1c2VycyUyMGRhdGFzZXRzJTIwYWNjZWxlcmF0ZSUyMHdhbmRiJTIwb3Blbi1jbGlwLXRvcmNo",highlighted:'%pip install -qq diffusers datasets accelerate wandb <span class="hljs-built_in">open</span>-clip-torch',wrap:!1}}),v=new w({props:{code:"JTIzJTIwQ29kZSUyMHRvJTIwbG9nJTIwaW4lMjB0byUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTJDJTIwbmVlZGVkJTIwZm9yJTIwc2hhcmluZyUyMG1vZGVscyUwQSUyMyUyME1ha2UlMjBzdXJlJTIweW91JTIwdXNlJTIwYSUyMHRva2VuJTIwd2l0aCUyMFdSSVRFJTIwYWNjZXNzJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Code to log in to the Hugging Face Hub, needed for sharing models</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make sure you use a token with WRITE access</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),G=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubi5mdW5jdGlvbmFsJTIwYXMlMjBGJTBBaW1wb3J0JTIwdG9yY2h2aXNpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMEREUE1QaXBlbGluZSUwQWZyb20lMjBtYXRwbG90bGliJTIwaW1wb3J0JTIwcHlwbG90JTIwYXMlMjBwbHQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdG9yY2h2aXNpb24lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTBBZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F
<span class="hljs-keyword">import</span> torchvision
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, DDPMPipeline
<span class="hljs-keyword">from</span> matplotlib <span class="hljs-keyword">import</span> pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),P=new w({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIybXBzJTIyJTIwaWYlMjB0b3JjaC5iYWNrZW5kcy5tcHMuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjI=",highlighted:'device = <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>',wrap:!1}}),X=new u({props:{title:"Loading A Pre-Trained Pipeline",local:"loading-a-pre-trained-pipeline",headingTag:"h2"}}),W=new w({props:{code:"aW1hZ2VfcGlwZSUyMCUzRCUyMEREUE1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZGRwbS1jZWxlYmFocS0yNTYlMjIpJTBBaW1hZ2VfcGlwZS50byhkZXZpY2Up",highlighted:`image_pipe = DDPMPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-celebahq-256&quot;</span>)
image_pipe.to(device)`,wrap:!1}}),x=new w({props:{code:"aW1hZ2VzJTIwJTNEJTIwaW1hZ2VfcGlwZSgpLmltYWdlcyUwQWltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>images = image_pipe().images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>]`,wrap:!1}}),S=new u({props:{title:"Faster Sampling with DDIM",local:"faster-sampling-with-ddim",headingTag:"h2"}}),E=new w({props:{code:"JTIzJTIwQ3JlYXRlJTIwbmV3JTIwc2NoZWR1bGVyJTIwYW5kJTIwc2V0JTIwbnVtJTIwaW5mZXJlbmNlJTIwc3RlcHMlMEFzY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNlbGViYWhxLTI1NiUyMiklMEFzY2hlZHVsZXIuc2V0X3RpbWVzdGVwcyhudW1faW5mZXJlbmNlX3N0ZXBzJTNENDAp",highlighted:`<span class="hljs-comment"># Create new scheduler and set num inference steps</span>
scheduler = DDIMScheduler.from_pretrained(<span class="hljs-string">&quot;google/ddpm-celebahq-256&quot;</span>)
scheduler.set_timesteps(num_inference_steps=<span class="hljs-number">40</span>)`,wrap:!1}}),O=new w({props:{code:"c2NoZWR1bGVyLnRpbWVzdGVwcw==",highlighted:"scheduler.timesteps",wrap:!1}}),q=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The random starting point</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.randn(<span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>).to(device)  <span class="hljs-comment"># Batch of 4, 3-channel 256 x 256 px images</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Loop through the sampling timesteps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(scheduler.timesteps)):

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare model input</span>
<span class="hljs-meta">... </span>    model_input = scheduler.scale_model_input(x, t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Get the prediction</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = image_pipe.unet(model_input, t)[<span class="hljs-string">&quot;sample&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Calculate what the updated sample should look like with the scheduler</span>
<span class="hljs-meta">... </span>    scheduler_output = scheduler.step(noise_pred, t, x)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Update x</span>
<span class="hljs-meta">... </span>    x = scheduler_output.prev_sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Occasionally display both x and the predicted denoised images</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> i % <span class="hljs-number">10</span> == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> i == <span class="hljs-built_in">len</span>(scheduler.timesteps) - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>        fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">5</span>))

<span class="hljs-meta">... </span>        grid = torchvision.utils.make_grid(x, nrow=<span class="hljs-number">4</span>).permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>        axs[<span class="hljs-number">0</span>].imshow(grid.cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>)
<span class="hljs-meta">... </span>        axs[<span class="hljs-number">0</span>].set_title(<span class="hljs-string">f&quot;Current x (step <span class="hljs-subst">{i}</span>)&quot;</span>)

<span class="hljs-meta">... </span>        pred_x0 = scheduler_output.pred_original_sample  <span class="hljs-comment"># Not available for all schedulers</span>
<span class="hljs-meta">... </span>        grid = torchvision.utils.make_grid(pred_x0, nrow=<span class="hljs-number">4</span>).permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>        axs[<span class="hljs-number">1</span>].imshow(grid.cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>)
<span class="hljs-meta">... </span>        axs[<span class="hljs-number">1</span>].set_title(<span class="hljs-string">f&quot;Predicted denoised images (step <span class="hljs-subst">{i}</span>)&quot;</span>)
<span class="hljs-meta">... </span>        plt.show()`,wrap:!1}}),Y=new w({props:{code:"JTIzJTIwJTNGJTNGc2NoZWR1bGVyLnN0ZXA=",highlighted:'<span class="hljs-comment"># ??scheduler.step</span>',wrap:!1}}),$=new w({props:{code:"aW1hZ2VfcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBzY2hlZHVsZXIlMEFpbWFnZXMlMjAlM0QlMjBpbWFnZV9waXBlKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0MCkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>image_pipe.scheduler = scheduler
<span class="hljs-meta">&gt;&gt;&gt; </span>images = image_pipe(num_inference_steps=<span class="hljs-number">40</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>]`,wrap:!1}}),se=new u({props:{title:"Fine-Tuning",local:"fine-tuning",headingTag:"h2"}}),ne=new w({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjBsb2FkJTIwYW5kJTIwcHJlcGFyZSUyMGElMjBkYXRhc2V0JTNBJTBBJTIzJTIwTm90JTIwb24lMjBDb2xhYiUzRiUyMENvbW1lbnRzJTIwd2l0aCUyMCUyMyU0MCUyMGVuYWJsZSUyMFVJJTIwdHdlYWtzJTIwbGlrZSUyMGhlYWRpbmdzJTIwb3IlMjB1c2VyJTIwaW5wdXRzJTBBJTIzJTIwYnV0JTIwY2FuJTIwc2FmZWx5JTIwYmUlMjBpZ25vcmVkJTIwaWYlMjB5b3UncmUlMjB3b3JraW5nJTIwb24lMjBhJTIwZGlmZmVyZW50JTIwcGxhdGZvcm0uJTBBJTBBZGF0YXNldF9uYW1lJTIwJTNEJTIwJTIyaHVnZ2FuJTJGc21pdGhzb25pYW5fYnV0dGVyZmxpZXNfc3Vic2V0JTIyJTIwJTIwJTIzJTIwJTQwcGFyYW0lMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KGRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBaW1hZ2Vfc2l6ZSUyMCUzRCUyMDI1NiUyMCUyMCUyMyUyMCU0MHBhcmFtJTBBYmF0Y2hfc2l6ZSUyMCUzRCUyMDQlMjAlMjAlMjMlMjAlNDBwYXJhbSUwQXByZXByb2Nlc3MlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoKGltYWdlX3NpemUlMkMlMjBpbWFnZV9zaXplKSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1zLlJhbmRvbUhvcml6b250YWxGbGlwKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1zLlRvVGVuc29yKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFuc2Zvcm1zLk5vcm1hbGl6ZSglNUIwLjUlNUQlMkMlMjAlNUIwLjUlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQSUwQWRlZiUyMHRyYW5zZm9ybShleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJwcmVwcm9jZXNzKGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSklMjBmb3IlMjBpbWFnZSUyMGluJTIwZXhhbXBsZXMlNUIlMjJpbWFnZSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMmltYWdlcyUyMiUzQSUyMGltYWdlcyU3RCUwQSUwQSUwQWRhdGFzZXQuc2V0X3RyYW5zZm9ybSh0cmFuc2Zvcm0pJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMHRvcmNoLnV0aWxzLmRhdGEuRGF0YUxvYWRlcihkYXRhc2V0JTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBzaHVmZmxlJTNEVHJ1ZSklMEElMEFwcmludCglMjJQcmV2aWV3aW5nJTIwYmF0Y2glM0ElMjIpJTBBYmF0Y2glMjAlM0QlMjBuZXh0KGl0ZXIodHJhaW5fZGF0YWxvYWRlcikpJTBBZ3JpZCUyMCUzRCUyMHRvcmNodmlzaW9uLnV0aWxzLm1ha2VfZ3JpZChiYXRjaCU1QiUyMmltYWdlcyUyMiU1RCUyQyUyMG5yb3clM0Q0KSUwQXBsdC5pbXNob3coZ3JpZC5wZXJtdXRlKDElMkMlMjAyJTJDJTIwMCkuY3B1KCkuY2xpcCgtMSUyQyUyMDEpJTIwKiUyMDAuNSUyMCUyQiUyMDAuNSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown load and prepare a dataset:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Not on Colab? Comments with #@ enable UI tweaks like headings or user inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># but can safely be ignored if you&#x27;re working on a different platform.</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_name = <span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_size = <span class="hljs-number">256</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">4</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocess = transforms.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        transforms.Resize((image_size, image_size)),
<span class="hljs-meta">... </span>        transforms.RandomHorizontalFlip(),
<span class="hljs-meta">... </span>        transforms.ToTensor(),
<span class="hljs-meta">... </span>        transforms.Normalize([<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>]),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [preprocess(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;images&quot;</span>: images}


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transform)

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(dataset, batch_size=batch_size, shuffle=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Previewing batch:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataloader))
<span class="hljs-meta">&gt;&gt;&gt; </span>grid = torchvision.utils.make_grid(batch[<span class="hljs-string">&quot;images&quot;</span>], nrow=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(grid.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>)`,wrap:!1}}),ie=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">2</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>lr = <span class="hljs-number">1e-5</span>  <span class="hljs-comment"># 2param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>grad_accumulation_steps = <span class="hljs-number">2</span>  <span class="hljs-comment"># @param</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(image_pipe.unet.parameters(), lr=lr)

<span class="hljs-meta">&gt;&gt;&gt; </span>losses = []

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(train_dataloader), total=<span class="hljs-built_in">len</span>(train_dataloader)):
<span class="hljs-meta">... </span>        clean_images = batch[<span class="hljs-string">&quot;images&quot;</span>].to(device)
<span class="hljs-meta">... </span>        <span class="hljs-comment"># Sample noise to add to the images</span>
<span class="hljs-meta">... </span>        noise = torch.randn(clean_images.shape).to(clean_images.device)
<span class="hljs-meta">... </span>        bs = clean_images.shape[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Sample a random timestep for each image</span>
<span class="hljs-meta">... </span>        timesteps = torch.randint(
<span class="hljs-meta">... </span>            <span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>            image_pipe.scheduler.num_train_timesteps,
<span class="hljs-meta">... </span>            (bs,),
<span class="hljs-meta">... </span>            device=clean_images.device,
<span class="hljs-meta">... </span>        ).long()

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Add noise to the clean images according to the noise magnitude at each timestep</span>
<span class="hljs-meta">... </span>        <span class="hljs-comment"># (this is the forward diffusion process)</span>
<span class="hljs-meta">... </span>        noisy_images = image_pipe.scheduler.add_noise(clean_images, noise, timesteps)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get the model prediction for the noise</span>
<span class="hljs-meta">... </span>        noise_pred = image_pipe.unet(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Compare the prediction with the actual noise:</span>
<span class="hljs-meta">... </span>        loss = F.mse_loss(
<span class="hljs-meta">... </span>            noise_pred, noise
<span class="hljs-meta">... </span>        )  <span class="hljs-comment"># NB - trying to predict noise (eps) not (noisy_ims-clean_ims) or just (clean_ims)</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Store for later plotting</span>
<span class="hljs-meta">... </span>        losses.append(loss.item())

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Update the model parameters with the optimizer based on this loss</span>
<span class="hljs-meta">... </span>        loss.backward(loss)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Gradient accumulation:</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> (step + <span class="hljs-number">1</span>) % grad_accumulation_steps == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>            optimizer.step()
<span class="hljs-meta">... </span>            optimizer.zero_grad()

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span> average loss: <span class="hljs-subst">{<span class="hljs-built_in">sum</span>(losses[-<span class="hljs-built_in">len</span>(train_dataloader):])/<span class="hljs-built_in">len</span>(train_dataloader)}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot the loss curve:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot(losses)`,wrap:!1}}),ce=new w({props:{code:"JTIzJTIwRXhlcmNpc2UlM0ElMjBTZWUlMjBpZiUyMHlvdSUyMGNhbiUyMGFkZCUyMGdyYWRpZW50JTIwYWNjdW11bGF0aW9uJTIwdG8lMjB0aGUlMjB0cmFpbmluZyUyMGxvb3AlMjBpbiUyMFVuaXQlMjAxLiUwQSUyMyUyMEhvdyUyMGRvZXMlMjBpdCUyMHBlcmZvcm0lM0YlMjBUaGluayUyMGhvdyUyMHlvdSUyMG1pZ2h0JTIwYWRqdXN0JTIwdGhlJTIwbGVhcm5pbmclMjByYXRlJTIwYmFzZWQlMjBvbiUyMHRoZSUwQSUyMyUyMG51bWJlciUyMG9mJTIwZ3JhZGllbnQlMjBhY2N1bXVsYXRpb24lMjBzdGVwcyUyMC0lMjBzaG91bGQlMjBpdCUyMHN0YXklMjB0aGUlMjBzYW1lJTIwYXMlMjBiZWZvcmUlM0Y=",highlighted:`<span class="hljs-comment"># Exercise: See if you can add gradient accumulation to the training loop in Unit 1.</span>
<span class="hljs-comment"># How does it perform? Think how you might adjust the learning rate based on the</span>
<span class="hljs-comment"># number of gradient accumulation steps - should it stay the same as before?</span>`,wrap:!1}}),de=new w({props:{code:"JTI1d2FuZGIlMjBqb2hub3doaXRha2VyJTJGZG1fZmluZXR1bmUlMkYydXBhYTM0MSUyMCUyMyUyMFlvdSdsbCUyMG5lZWQlMjBhJTIwVyUyNkIlMjBhY2NvdW50JTIwZm9yJTIwdGhpcyUyMHRvJTIwd29yayUyMC0lMjBza2lwJTIwaWYlMjB5b3UlMjBkb24ndCUyMHdhbnQlMjB0byUyMGxvZyUyMGlu",highlighted:'%wandb johnowhitaker/dm_finetune/2upaa341 <span class="hljs-comment"># You&#x27;ll need a W&amp;B account for this to work - skip if you don&#x27;t want to log in</span>',wrap:!1}}),Ue=new w({props:{code:"JTIzJTIwRXhlcmNpc2UlM0ElMjBzZWUlMjBpZiUyMHlvdSUyMGNhbiUyMG1vZGlmeSUyMHRoZSUyMG9mZmljaWFsJTIwZXhhbXBsZSUyMHRyYWluaW5nJTIwc2NyaXB0JTIwd2UlMjBzYXclMEElMjMlMjBpbiUyMFVuaXQlMjAxJTIwdG8lMjBiZWdpbiUyMHdpdGglMjBhJTIwcHJlLXRyYWluZWQlMjBtb2RlbCUyMHJhdGhlciUyMHRoYW4lMjB0cmFpbmluZyUyMGZyb20lMjBzY3JhdGNoLiUwQSUyMyUyMENvbXBhcmUlMjBpdCUyMHRvJTIwdGhlJTIwbWluaW1hbCUyMHNjcmlwdCUyMGxpbmtlZCUyMGFib3ZlJTIwLSUyMHdoYXQlMjBleHRyYSUyMGZlYXR1cmVzJTIwaXMlMjB0aGUlMjBtaW5pbWFsJTIwc2NyaXB0JTIwbWlzc2luZyUzRg==",highlighted:`<span class="hljs-comment"># Exercise: see if you can modify the official example training script we saw</span>
<span class="hljs-comment"># in Unit 1 to begin with a pre-trained model rather than training from scratch.</span>
<span class="hljs-comment"># Compare it to the minimal script linked above - what extra features is the minimal script missing?</span>`,wrap:!1}}),ge=new w({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjBHZW5lcmF0ZSUyMGFuZCUyMHBsb3QlMjBzb21lJTIwaW1hZ2VzJTNBJTBBeCUyMCUzRCUyMHRvcmNoLnJhbmRuKDglMkMlMjAzJTJDJTIwMjU2JTJDJTIwMjU2KS50byhkZXZpY2UpJTIwJTIwJTIzJTIwQmF0Y2glMjBvZiUyMDglMEFmb3IlMjBpJTJDJTIwdCUyMGluJTIwdHFkbShlbnVtZXJhdGUoc2NoZWR1bGVyLnRpbWVzdGVwcykpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWxfaW5wdXQlMjAlM0QlMjBzY2hlZHVsZXIuc2NhbGVfbW9kZWxfaW5wdXQoeCUyQyUyMHQpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5vaXNlX3ByZWQlMjAlM0QlMjBpbWFnZV9waXBlLnVuZXQobW9kZWxfaW5wdXQlMkMlMjB0KSU1QiUyMnNhbXBsZSUyMiU1RCUwQSUyMCUyMCUyMCUyMHglMjAlM0QlMjBzY2hlZHVsZXIuc3RlcChub2lzZV9wcmVkJTJDJTIwdCUyQyUyMHgpLnByZXZfc2FtcGxlJTBBZ3JpZCUyMCUzRCUyMHRvcmNodmlzaW9uLnV0aWxzLm1ha2VfZ3JpZCh4JTJDJTIwbnJvdyUzRDQpJTBBcGx0Lmltc2hvdyhncmlkLnBlcm11dGUoMSUyQyUyMDIlMkMlMjAwKS5jcHUoKS5jbGlwKC0xJTJDJTIwMSklMjAqJTIwMC41JTIwJTJCJTIwMC41KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown Generate and plot some images:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.randn(<span class="hljs-number">8</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>).to(device)  <span class="hljs-comment"># Batch of 8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(scheduler.timesteps)):
<span class="hljs-meta">... </span>    model_input = scheduler.scale_model_input(x, t)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = image_pipe.unet(model_input, t)[<span class="hljs-string">&quot;sample&quot;</span>]
<span class="hljs-meta">... </span>    x = scheduler.step(noise_pred, t, x).prev_sample
<span class="hljs-meta">&gt;&gt;&gt; </span>grid = torchvision.utils.make_grid(x, nrow=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(grid.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>)`,wrap:!1}}),Je=new u({props:{title:"Code for fine-tuning a model using the minimal example script we used on the WikiArt demo model",local:"code-for-fine-tuning-a-model-using-the-minimal-example-script-we-used-on-the-wikiart-demo-model",headingTag:"h3"}}),Te=new w({props:{code:"JTIzJTIzJTIwVG8lMjBkb3dubG9hZCUyMHRoZSUyMGZpbmUtdHVuaW5nJTIwc2NyaXB0JTNBJTBBJTIzJTIwIXdnZXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2lvbi1tb2RlbHMtY2xhc3MlMkZyYXclMkZtYWluJTJGdW5pdDIlMkZmaW5ldHVuZV9tb2RlbC5weQ==",highlighted:`<span class="hljs-comment">## To download the fine-tuning script:</span>
<span class="hljs-comment"># !wget https://github.com/huggingface/diffusion-models-class/raw/main/unit2/finetune_model.py</span>`,wrap:!1}}),Re=new w({props:{code:"JTIzJTIzJTIwVG8lMjBydW4lMjB0aGUlMjBzY3JpcHQlMkMlMjB0cmFpbmluZyUyMHRoZSUyMGZhY2UlMjBtb2RlbCUyMG9uJTIwc29tZSUyMHZpbnRhZ2UlMjBmYWNlcyUwQSUyMyUyMyUyMChpZGVhbGx5JTIwcnVuJTIwdGhpcyUyMGluJTIwYSUyMHRlcm1pbmFsKSUzQSUwQSUyMyUyMCFweXRob24lMjBmaW5ldHVuZV9tb2RlbC5weSUyMC0taW1hZ2Vfc2l6ZSUyMDEyOCUyMC0tYmF0Y2hfc2l6ZSUyMDglMjAtLW51bV9lcG9jaHMlMjAxNiU1QyUwQSUyMyUyMCUyMCUyMCUyMCUyMC0tZ3JhZF9hY2N1bXVsYXRpb25fc3RlcHMlMjAyJTIwLS1zdGFydF9tb2RlbCUyMCUyMmdvb2dsZSUyRmRkcG0tY2VsZWJhaHEtMjU2JTIyJTVDJTBBJTIzJTIwJTIwJTIwJTIwJTIwLS1kYXRhc2V0X25hbWUlMjAlMjJOb3JvZDc4JTJGVmludGFnZS1GYWNlcy1GRkhRQWxpZ25lZCUyMiUyMC0td2FuZGJfcHJvamVjdCUyMCdkbS1maW5ldHVuZSclNUMlMEElMjMlMjAlMjAlMjAlMjAlMjAtLWxvZ19zYW1wbGVzX2V2ZXJ5JTIwMTAwJTIwLS1zYXZlX21vZGVsX2V2ZXJ5JTIwMTAwMCUyMC0tbW9kZWxfc2F2ZV9uYW1lJTIwJ3ZpbnRhZ2VmYWNlJw==",highlighted:`<span class="hljs-comment">## To run the script, training the face model on some vintage faces</span>
<span class="hljs-comment">## (ideally run this in a terminal):</span>
<span class="hljs-comment"># !python finetune_model.py --image_size 128 --batch_size 8 --num_epochs 16\\</span>
<span class="hljs-comment">#     --grad_accumulation_steps 2 --start_model &quot;google/ddpm-celebahq-256&quot;\\</span>
<span class="hljs-comment">#     --dataset_name &quot;Norod78/Vintage-Faces-FFHQAligned&quot; --wandb_project &#x27;dm-finetune&#x27;\\</span>
<span class="hljs-comment">#     --log_samples_every 100 --save_model_every 1000 --model_save_name &#x27;vintageface&#x27;</span>`,wrap:!1}}),he=new u({props:{title:"Saving and Loading Fine-Tuned Pipelines",local:"saving-and-loading-fine-tuned-pipelines",headingTag:"h3"}}),He=new w({props:{code:"aW1hZ2VfcGlwZS5zYXZlX3ByZXRyYWluZWQoJTIybXktZmluZXR1bmVkLW1vZGVsJTIyKQ==",highlighted:'image_pipe.save_pretrained(<span class="hljs-string">&quot;my-finetuned-model&quot;</span>)',wrap:!1}}),ve=new w({props:{code:"IWxzJTIwJTdCJTIybXktZmluZXR1bmVkLW1vZGVsJTIyJTdE",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>!ls {<span class="hljs-string">&quot;my-finetuned-model&quot;</span>}',wrap:!1}}),Pe=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># @title Upload a locally saved pipeline to the hub</span>

<span class="hljs-comment"># Code to upload a pipeline saved locally to the hub</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfApi, ModelCard, create_repo, get_full_repo_name

<span class="hljs-comment"># Set up repo and upload files</span>
model_name = <span class="hljs-string">&quot;ddpm-celebahq-finetuned-butterflies-2epochs&quot;</span>  <span class="hljs-comment"># @param What you want it called on the hub</span>
local_folder_name = (
    <span class="hljs-string">&quot;my-finetuned-model&quot;</span>  <span class="hljs-comment"># @param Created by the script or one you created via image_pipe.save_pretrained(&#x27;save_name&#x27;)</span>
)
description = <span class="hljs-string">&quot;Describe your model here&quot;</span>  <span class="hljs-comment"># @param</span>
hub_model_id = get_full_repo_name(model_name)
create_repo(hub_model_id)
api = HfApi()
api.upload_folder(folder_path=<span class="hljs-string">f&quot;<span class="hljs-subst">{local_folder_name}</span>/scheduler&quot;</span>, path_in_repo=<span class="hljs-string">&quot;&quot;</span>, repo_id=hub_model_id)
api.upload_folder(folder_path=<span class="hljs-string">f&quot;<span class="hljs-subst">{local_folder_name}</span>/unet&quot;</span>, path_in_repo=<span class="hljs-string">&quot;&quot;</span>, repo_id=hub_model_id)
api.upload_file(
    path_or_fileobj=<span class="hljs-string">f&quot;<span class="hljs-subst">{local_folder_name}</span>/model_index.json&quot;</span>,
    path_in_repo=<span class="hljs-string">&quot;model_index.json&quot;</span>,
    repo_id=hub_model_id,
)

<span class="hljs-comment"># Add a model card (optional but nice!)</span>
content = <span class="hljs-string">f&quot;&quot;&quot;
---
license: mit
tags:
- pytorch
- diffusers
- unconditional-image-generation
- diffusion-models-class
---

# Example Fine-Tuned Model for Unit 2 of the [Diffusion Models Class 🧨](https://github.com/huggingface/diffusion-models-class)

<span class="hljs-subst">{description}</span>

## Usage

\`\`\`python
from diffusers import DDPMPipeline

pipeline = DDPMPipeline.from_pretrained(&#x27;<span class="hljs-subst">{hub_model_id}</span>&#x27;)
image = pipeline().images[0]
image</span>`,wrap:!1}}),We=new w({props:{code:"JTBBJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMHByZXRyYWluZWQlMjBwaXBlbGluZSUwQXBpcGVsaW5lX25hbWUlMjAlM0QlMjAlMjJqb2hub3doaXRha2VyJTJGc2QtY2xhc3Mtd2lraWFydC1mcm9tLWJlZHJvb21zJTIyJTBBaW1hZ2VfcGlwZSUyMCUzRCUyMEREUE1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocGlwZWxpbmVfbmFtZSkudG8oZGV2aWNlKSUwQSUwQSUyMyUyMFNhbXBsZSUyMHNvbWUlMjBpbWFnZXMlMjB3aXRoJTIwYSUyMERESU0lMjBTY2hlZHVsZXIlMjBvdmVyJTIwNDAlMjBzdGVwcyUwQXNjaGVkdWxlciUyMCUzRCUyMERESU1TY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVsaW5lX25hbWUpJTBBc2NoZWR1bGVyLnNldF90aW1lc3RlcHMobnVtX2luZmVyZW5jZV9zdGVwcyUzRDQwKSUwQSUwQSUyMyUyMFJhbmRvbSUyMHN0YXJ0aW5nJTIwcG9pbnQlMjAoYmF0Y2glMjBvZiUyMDglMjBpbWFnZXMpJTBBeCUyMCUzRCUyMHRvcmNoLnJhbmRuKDglMkMlMjAzJTJDJTIwMjU2JTJDJTIwMjU2KS50byhkZXZpY2UpJTBBJTBBJTIzJTIwTWluaW1hbCUyMHNhbXBsaW5nJTIwbG9vcCUwQWZvciUyMGklMkMlMjB0JTIwaW4lMjB0cWRtKGVudW1lcmF0ZShzY2hlZHVsZXIudGltZXN0ZXBzKSklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMHNjaGVkdWxlci5zY2FsZV9tb2RlbF9pbnB1dCh4JTJDJTIwdCklMEElMjAlMjAlMjAlMjB3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9pc2VfcHJlZCUyMCUzRCUyMGltYWdlX3BpcGUudW5ldChtb2RlbF9pbnB1dCUyQyUyMHQpJTVCJTIyc2FtcGxlJTIyJTVEJTBBJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXNlX3ByZWQlMkMlMjB0JTJDJTIweCkucHJldl9zYW1wbGUlMEElMEElMjMlMjBWaWV3JTIwdGhlJTIwcmVzdWx0cyUwQWdyaWQlMjAlM0QlMjB0b3JjaHZpc2lvbi51dGlscy5tYWtlX2dyaWQoeCUyQyUyMG5yb3clM0Q0KSUwQXBsdC5pbXNob3coZ3JpZC5wZXJtdXRlKDElMkMlMjAyJTJDJTIwMCkuY3B1KCkuY2xpcCgtMSUyQyUyMDEpJTIwKiUyMDAuNSUyMCUyQiUyMDAuNSk=",highlighted:`
Congratulations, you&#x27;ve now fine-tuned your first diffusion model!

For the rest of this notebook we&#x27;ll use a [model](https://huggingface.co/johnowhitaker/sd-class-wikiart-from-bedrooms) I fine-tuned from [this model trained on LSUN bedrooms](https://huggingface.co/google/ddpm-bedroom-256) approximately one epoch on the [WikiArt dataset](https://huggingface.co/datasets/huggan/wikiart). If you&#x27;d prefer, you can skip this cell and use the faces/butterflies pipeline we fine-tuned in the previous section or load one from the Hub instead:

\`\`\`python
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># Load the pretrained pipeline</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pipeline_name = <span class="hljs-string">&quot;johnowhitaker/sd-class-wikiart-from-bedrooms&quot;</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">image_pipe = DDPMPipeline.from_pretrained(pipeline_name).to(device)</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># Sample some images with a DDIM Scheduler over 40 steps</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">scheduler = DDIMScheduler.from_pretrained(pipeline_name)</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">scheduler.set_timesteps(num_inference_steps=<span class="hljs-number">40</span>)</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># Random starting point (batch of 8 images)</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">x = torch.randn(<span class="hljs-number">8</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>).to(device)</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># Minimal sampling loop</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(scheduler.timesteps)):</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    model_input = scheduler.scale_model_input(x, t)</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    <span class="hljs-keyword">with</span> torch.no_grad():</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">        noise_pred = image_pipe.unet(model_input, t)[<span class="hljs-string">&quot;sample&quot;</span>]</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    x = scheduler.step(noise_pred, t, x).prev_sample</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># View the results</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">grid = torchvision.utils.make_grid(x, nrow=<span class="hljs-number">4</span>)</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">plt.imshow(grid.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>)</span>`,wrap:!1}}),Ke=new u({props:{title:"Guidance",local:"guidance",headingTag:"h2"}}),Ne=new w({props:{code:"ZGVmJTIwY29sb3JfbG9zcyhpbWFnZXMlMkMlMjB0YXJnZXRfY29sb3IlM0QoMC4xJTJDJTIwMC45JTJDJTIwMC41KSklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJHaXZlbiUyMGElMjB0YXJnZXQlMjBjb2xvciUyMChSJTJDJTIwRyUyQyUyMEIpJTIwcmV0dXJuJTIwYSUyMGxvc3MlMjBmb3IlMjBob3clMjBmYXIlMjBhd2F5JTIwb24lMjBhdmVyYWdlJTBBJTIwJTIwJTIwJTIwdGhlJTIwaW1hZ2VzJyUyMHBpeGVscyUyMGFyZSUyMGZyb20lMjB0aGF0JTIwY29sb3IuJTIwRGVmYXVsdHMlMjB0byUyMGElMjBsaWdodCUyMHRlYWwlM0ElMjAoMC4xJTJDJTIwMC45JTJDJTIwMC41KSUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHRhcmdldCUyMCUzRCUyMHRvcmNoLnRlbnNvcih0YXJnZXRfY29sb3IpLnRvKGltYWdlcy5kZXZpY2UpJTIwKiUyMDIlMjAtJTIwMSUyMCUyMCUyMyUyME1hcCUyMHRhcmdldCUyMGNvbG9yJTIwdG8lMjAoLTElMkMlMjAxKSUwQSUyMCUyMCUyMCUyMHRhcmdldCUyMCUzRCUyMHRhcmdldCU1Qk5vbmUlMkMlMjAlM0ElMkMlMjBOb25lJTJDJTIwTm9uZSU1RCUyMCUyMCUyMyUyMEdldCUyMHNoYXBlJTIwcmlnaHQlMjB0byUyMHdvcmslMjB3aXRoJTIwdGhlJTIwaW1hZ2VzJTIwKGIlMkMlMjBjJTJDJTIwaCUyQyUyMHcpJTBBJTIwJTIwJTIwJTIwZXJyb3IlMjAlM0QlMjB0b3JjaC5hYnMoaW1hZ2VzJTIwLSUyMHRhcmdldCkubWVhbigpJTIwJTIwJTIzJTIwTWVhbiUyMGFic29sdXRlJTIwZGlmZmVyZW5jZSUyMGJldHdlZW4lMjB0aGUlMjBpbWFnZSUyMHBpeGVscyUyMGFuZCUyMHRoZSUyMHRhcmdldCUyMGNvbG9yJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXJyb3I=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">color_loss</span>(<span class="hljs-params">images, target_color=(<span class="hljs-params"><span class="hljs-number">0.1</span>, <span class="hljs-number">0.9</span>, <span class="hljs-number">0.5</span></span>)</span>):
    <span class="hljs-string">&quot;&quot;&quot;Given a target color (R, G, B) return a loss for how far away on average
    the images&#x27; pixels are from that color. Defaults to a light teal: (0.1, 0.9, 0.5)&quot;&quot;&quot;</span>
    target = torch.tensor(target_color).to(images.device) * <span class="hljs-number">2</span> - <span class="hljs-number">1</span>  <span class="hljs-comment"># Map target color to (-1, 1)</span>
    target = target[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]  <span class="hljs-comment"># Get shape right to work with the images (b, c, h, w)</span>
    error = torch.<span class="hljs-built_in">abs</span>(images - target).mean()  <span class="hljs-comment"># Mean absolute difference between the image pixels and the target color</span>
    <span class="hljs-keyword">return</span> error`,wrap:!1}}),Oe=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Variant 1: shortcut method</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The guidance scale determines the strength of the effect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_loss_scale = <span class="hljs-number">40</span>  <span class="hljs-comment"># Explore changing this to 5, or 100</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.randn(<span class="hljs-number">8</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(scheduler.timesteps)):

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare the model input</span>
<span class="hljs-meta">... </span>    model_input = scheduler.scale_model_input(x, t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># predict the noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = image_pipe.unet(model_input, t)[<span class="hljs-string">&quot;sample&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Set x.requires_grad to True</span>
<span class="hljs-meta">... </span>    x = x.detach().requires_grad_()

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Get the predicted x0</span>
<span class="hljs-meta">... </span>    x0 = scheduler.step(noise_pred, t, x).pred_original_sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Calculate loss</span>
<span class="hljs-meta">... </span>    loss = color_loss(x0) * guidance_loss_scale
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> i % <span class="hljs-number">10</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(i, <span class="hljs-string">&quot;loss:&quot;</span>, loss.item())

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Get gradient</span>
<span class="hljs-meta">... </span>    cond_grad = -torch.autograd.grad(loss, x)[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Modify x based on this gradient</span>
<span class="hljs-meta">... </span>    x = x.detach() + cond_grad

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Now step with scheduler</span>
<span class="hljs-meta">... </span>    x = scheduler.step(noise_pred, t, x).prev_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>grid = torchvision.utils.make_grid(x, nrow=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>im = grid.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(np.array(im * <span class="hljs-number">255</span>).astype(np.uint8))`,wrap:!1}}),Le=new w({props:{code:"JTIzJTIwVmFyaWFudCUyMDIlM0ElMjBzZXR0aW5nJTIweC5yZXF1aXJlc19ncmFkJTIwYmVmb3JlJTIwY2FsY3VsYXRpbmclMjB0aGUlMjBtb2RlbCUyMHByZWRpY3Rpb25zJTBBJTBBZ3VpZGFuY2VfbG9zc19zY2FsZSUyMCUzRCUyMDQwJTBBeCUyMCUzRCUyMHRvcmNoLnJhbmRuKDQlMkMlMjAzJTJDJTIwMjU2JTJDJTIwMjU2KS50byhkZXZpY2UpJTBBJTBBZm9yJTIwaSUyQyUyMHQlMjBpbiUyMHRxZG0oZW51bWVyYXRlKHNjaGVkdWxlci50aW1lc3RlcHMpKSUzQSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNldCUyMHJlcXVpcmVzX2dyYWQlMjBiZWZvcmUlMjB0aGUlMjBtb2RlbCUyMGZvcndhcmQlMjBwYXNzJTBBJTIwJTIwJTIwJTIweCUyMCUzRCUyMHguZGV0YWNoKCkucmVxdWlyZXNfZ3JhZF8oKSUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0JTIwJTNEJTIwc2NoZWR1bGVyLnNjYWxlX21vZGVsX2lucHV0KHglMkMlMjB0KSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMHByZWRpY3QlMjAod2l0aCUyMGdyYWQlMjB0aGlzJTIwdGltZSklMEElMjAlMjAlMjAlMjBub2lzZV9wcmVkJTIwJTNEJTIwaW1hZ2VfcGlwZS51bmV0KG1vZGVsX2lucHV0JTJDJTIwdCklNUIlMjJzYW1wbGUlMjIlNUQlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjB0aGUlMjBwcmVkaWN0ZWQlMjB4MCUzQSUwQSUyMCUyMCUyMCUyMHgwJTIwJTNEJTIwc2NoZWR1bGVyLnN0ZXAobm9pc2VfcHJlZCUyQyUyMHQlMkMlMjB4KS5wcmVkX29yaWdpbmFsX3NhbXBsZSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENhbGN1bGF0ZSUyMGxvc3MlMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwY29sb3JfbG9zcyh4MCklMjAqJTIwZ3VpZGFuY2VfbG9zc19zY2FsZSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUyNSUyMDEwJTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGklMkMlMjAlMjJsb3NzJTNBJTIyJTJDJTIwbG9zcy5pdGVtKCkpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwR2V0JTIwZ3JhZGllbnQlMEElMjAlMjAlMjAlMjBjb25kX2dyYWQlMjAlM0QlMjAtdG9yY2guYXV0b2dyYWQuZ3JhZChsb3NzJTJDJTIweCklNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTW9kaWZ5JTIweCUyMGJhc2VkJTIwb24lMjB0aGlzJTIwZ3JhZGllbnQlMEElMjAlMjAlMjAlMjB4JTIwJTNEJTIweC5kZXRhY2goKSUyMCUyQiUyMGNvbmRfZ3JhZCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyME5vdyUyMHN0ZXAlMjB3aXRoJTIwc2NoZWR1bGVyJTBBJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNjaGVkdWxlci5zdGVwKG5vaXNlX3ByZWQlMkMlMjB0JTJDJTIweCkucHJldl9zYW1wbGUlMEElMEElMEFncmlkJTIwJTNEJTIwdG9yY2h2aXNpb24udXRpbHMubWFrZV9ncmlkKHglMkMlMjBucm93JTNENCklMEFpbSUyMCUzRCUyMGdyaWQucGVybXV0ZSgxJTJDJTIwMiUyQyUyMDApLmNwdSgpLmNsaXAoLTElMkMlMjAxKSUyMColMjAwLjUlMjAlMkIlMjAwLjUlMEFJbWFnZS5mcm9tYXJyYXkobnAuYXJyYXkoaW0lMjAqJTIwMjU1KS5hc3R5cGUobnAudWludDgpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Variant 2: setting x.requires_grad before calculating the model predictions</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_loss_scale = <span class="hljs-number">40</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.randn(<span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(scheduler.timesteps)):

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Set requires_grad before the model forward pass</span>
<span class="hljs-meta">... </span>    x = x.detach().requires_grad_()
<span class="hljs-meta">... </span>    model_input = scheduler.scale_model_input(x, t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># predict (with grad this time)</span>
<span class="hljs-meta">... </span>    noise_pred = image_pipe.unet(model_input, t)[<span class="hljs-string">&quot;sample&quot;</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Get the predicted x0:</span>
<span class="hljs-meta">... </span>    x0 = scheduler.step(noise_pred, t, x).pred_original_sample

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Calculate loss</span>
<span class="hljs-meta">... </span>    loss = color_loss(x0) * guidance_loss_scale
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> i % <span class="hljs-number">10</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(i, <span class="hljs-string">&quot;loss:&quot;</span>, loss.item())

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Get gradient</span>
<span class="hljs-meta">... </span>    cond_grad = -torch.autograd.grad(loss, x)[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Modify x based on this gradient</span>
<span class="hljs-meta">... </span>    x = x.detach() + cond_grad

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Now step with scheduler</span>
<span class="hljs-meta">... </span>    x = scheduler.step(noise_pred, t, x).prev_sample


<span class="hljs-meta">&gt;&gt;&gt; </span>grid = torchvision.utils.make_grid(x, nrow=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>im = grid.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(np.array(im * <span class="hljs-number">255</span>).astype(np.uint8))`,wrap:!1}}),$e=new w({props:{code:"JTIzJTIwRXhlcmNpc2UlM0ElMjBwaWNrJTIweW91ciUyMGZhdm91cml0ZSUyMGNvbG91ciUyMGFuZCUyMGxvb2slMjB1cCUyMGl0J3MlMjB2YWx1ZXMlMjBpbiUyMFJHQiUyMHNwYWNlLiUwQSUyMyUyMEVkaXQlMjB0aGUlMjAlNjBjb2xvcl9sb3NzKCklNjAlMjBsaW5lJTIwaW4lMjB0aGUlMjBjZWxsJTIwYWJvdmUlMjB0byUyMHJlY2VpdmUlMjB0aGVzZSUyMG5ldyUyMFJHQiUyMHZhbHVlcyUyMGFuZCUyMGV4YW1pbmUlMjB0aGUlMjBvdXRwdXRzJTIwLSUyMGRvJTIwdGhleSUyMG1hdGNoJTIwd2hhdCUyMHlvdSUyMGV4cGVjdCUzRg==",highlighted:'<span class="hljs-comment"># Exercise: pick your favourite colour and look up it&#x27;s values in RGB space.</span>\n<span class="hljs-comment"># Edit the `color_loss()` line in the cell above to receive these new RGB values and examine the outputs - do they match what you expect?</span>',wrap:!1}}),es=new u({props:{title:"CLIP Guidance",local:"clip-guidance",headingTag:"h2"}}),As=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># @markdown load a CLIP model and define the loss function</span>
<span class="hljs-keyword">import</span> open_clip

clip_model, _, preprocess = open_clip.create_model_and_transforms(<span class="hljs-string">&quot;ViT-B-32&quot;</span>, pretrained=<span class="hljs-string">&quot;openai&quot;</span>)
clip_model.to(device)

<span class="hljs-comment"># Transforms to resize and augment an image + normalize to match CLIP&#x27;s training data</span>
tfms = torchvision.transforms.Compose(
    [
        torchvision.transforms.RandomResizedCrop(<span class="hljs-number">224</span>),  <span class="hljs-comment"># Random CROP each time</span>
        torchvision.transforms.RandomAffine(<span class="hljs-number">5</span>),  <span class="hljs-comment"># One possible random augmentation: skews the image</span>
        torchvision.transforms.RandomHorizontalFlip(),  <span class="hljs-comment"># You can add additional augmentations if you like</span>
        torchvision.transforms.Normalize(
            mean=(<span class="hljs-number">0.48145466</span>, <span class="hljs-number">0.4578275</span>, <span class="hljs-number">0.40821073</span>),
            std=(<span class="hljs-number">0.26862954</span>, <span class="hljs-number">0.26130258</span>, <span class="hljs-number">0.27577711</span>),
        ),
    ]
)


<span class="hljs-comment"># And define a loss function that takes an image, embeds it and compares with</span>
<span class="hljs-comment"># the text features of the prompt</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">clip_loss</span>(<span class="hljs-params">image, text_features</span>):
    image_features = clip_model.encode_image(tfms(image))  <span class="hljs-comment"># Note: applies the above transforms</span>
    input_normed = torch.nn.functional.normalize(image_features.unsqueeze(<span class="hljs-number">1</span>), dim=<span class="hljs-number">2</span>)
    embed_normed = torch.nn.functional.normalize(text_features.unsqueeze(<span class="hljs-number">0</span>), dim=<span class="hljs-number">2</span>)
    dists = input_normed.sub(embed_normed).norm(dim=<span class="hljs-number">2</span>).div(<span class="hljs-number">2</span>).arcsin().<span class="hljs-built_in">pow</span>(<span class="hljs-number">2</span>).mul(<span class="hljs-number">2</span>)  <span class="hljs-comment"># Squared Great Circle Distance</span>
    <span class="hljs-keyword">return</span> dists.mean()`,wrap:!1}}),os=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown applying guidance using CLIP</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Red Rose (still life), red flower painting&quot;</span>  <span class="hljs-comment"># @param</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Explore changing this</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>guidance_scale = <span class="hljs-number">8</span>  <span class="hljs-comment"># @param</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>n_cuts = <span class="hljs-number">4</span>  <span class="hljs-comment"># @param</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># More steps -&gt; more time for the guidance to have an effect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler.set_timesteps(<span class="hljs-number">50</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We embed a prompt with CLIP as our target</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = open_clip.tokenize([prompt]).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad(), torch.cuda.amp.autocast():
<span class="hljs-meta">... </span>    text_features = clip_model.encode_text(text)


<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.randn(<span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>).to(device)  <span class="hljs-comment"># RAM usage is high, you may want only 1 image at a time</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(scheduler.timesteps)):

<span class="hljs-meta">... </span>    model_input = scheduler.scale_model_input(x, t)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># predict the noise residual</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        noise_pred = image_pipe.unet(model_input, t)[<span class="hljs-string">&quot;sample&quot;</span>]

<span class="hljs-meta">... </span>    cond_grad = <span class="hljs-number">0</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> cut <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_cuts):

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Set requires grad on x</span>
<span class="hljs-meta">... </span>        x = x.detach().requires_grad_()

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get the predicted x0:</span>
<span class="hljs-meta">... </span>        x0 = scheduler.step(noise_pred, t, x).pred_original_sample

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Calculate loss</span>
<span class="hljs-meta">... </span>        loss = clip_loss(x0, text_features) * guidance_scale

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get gradient (scale by n_cuts since we want the average)</span>
<span class="hljs-meta">... </span>        cond_grad -= torch.autograd.grad(loss, x)[<span class="hljs-number">0</span>] / n_cuts

<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> i % <span class="hljs-number">25</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Step:&quot;</span>, i, <span class="hljs-string">&quot;, Guidance loss:&quot;</span>, loss.item())

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Modify x based on this gradient</span>
<span class="hljs-meta">... </span>    alpha_bar = scheduler.alphas_cumprod[i]
<span class="hljs-meta">... </span>    x = x.detach() + cond_grad * alpha_bar.sqrt()  <span class="hljs-comment"># Note the additional scaling factor here!</span>

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Now step with scheduler</span>
<span class="hljs-meta">... </span>    x = scheduler.step(noise_pred, t, x).prev_sample


<span class="hljs-meta">&gt;&gt;&gt; </span>grid = torchvision.utils.make_grid(x.detach(), nrow=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>im = grid.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(np.array(im * <span class="hljs-number">255</span>).astype(np.uint8))`,wrap:!1}}),js=new w({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjBQbG90dGluZyUyMHNvbWUlMjBwb3NzaWJsZSUyMHNjaGVkdWxlcyUzQSUwQXBsdC5wbG90KCU1QjElMjBmb3IlMjBhJTIwaW4lMjBzY2hlZHVsZXIuYWxwaGFzX2N1bXByb2QlNUQlMkMlMjBsYWJlbCUzRCUyMm5vJTIwc2NhbGluZyUyMiklMEFwbHQucGxvdCglNUJhJTIwZm9yJTIwYSUyMGluJTIwc2NoZWR1bGVyLmFscGhhc19jdW1wcm9kJTVEJTJDJTIwbGFiZWwlM0QlMjJhbHBoYV9iYXIlMjIpJTBBcGx0LnBsb3QoJTVCYS5zcXJ0KCklMjBmb3IlMjBhJTIwaW4lMjBzY2hlZHVsZXIuYWxwaGFzX2N1bXByb2QlNUQlMkMlMjBsYWJlbCUzRCUyMmFscGhhX2Jhci5zcXJ0KCklMjIpJTBBcGx0LnBsb3QoJTVCKDElMjAtJTIwYSkuc3FydCgpJTIwZm9yJTIwYSUyMGluJTIwc2NoZWR1bGVyLmFscGhhc19jdW1wcm9kJTVEJTJDJTIwbGFiZWwlM0QlMjIoMS1hbHBoYV9iYXIpLnNxcnQoKSUyMiklMEFwbHQubGVnZW5kKCklMEFwbHQudGl0bGUoJTIyUG9zc2libGUlMjBndWlkYW5jZSUyMHNjYWxpbmclMjBzY2hlZHVsZXMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown Plotting some possible schedules:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot([<span class="hljs-number">1</span> <span class="hljs-keyword">for</span> a <span class="hljs-keyword">in</span> scheduler.alphas_cumprod], label=<span class="hljs-string">&quot;no scaling&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot([a <span class="hljs-keyword">for</span> a <span class="hljs-keyword">in</span> scheduler.alphas_cumprod], label=<span class="hljs-string">&quot;alpha_bar&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot([a.sqrt() <span class="hljs-keyword">for</span> a <span class="hljs-keyword">in</span> scheduler.alphas_cumprod], label=<span class="hljs-string">&quot;alpha_bar.sqrt()&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot([(<span class="hljs-number">1</span> - a).sqrt() <span class="hljs-keyword">for</span> a <span class="hljs-keyword">in</span> scheduler.alphas_cumprod], label=<span class="hljs-string">&quot;(1-alpha_bar).sqrt()&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.legend()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.title(<span class="hljs-string">&quot;Possible guidance scaling schedules&quot;</span>)`,wrap:!1}}),ws=new u({props:{title:"Sharing A Custom Sampling Loop as a Gradio Demo",local:"sharing-a-custom-sampling-loop-as-a-gradio-demo",headingTag:"h2"}}),Us=new w({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwZ3JhZGlvJTIwJTIzJTIwSW5zdGFsbCUyMHRoZSUyMGxpYnJhcnk=",highlighted:'%pip install -q gradio <span class="hljs-comment"># Install the library</span>',wrap:!1}}),fs=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image, ImageColor


<span class="hljs-comment"># The function that does the hard work</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate</span>(<span class="hljs-params">color, guidance_loss_scale</span>):
    target_color = ImageColor.getcolor(color, <span class="hljs-string">&quot;RGB&quot;</span>)  <span class="hljs-comment"># Target color as RGB</span>
    target_color = [a / <span class="hljs-number">255</span> <span class="hljs-keyword">for</span> a <span class="hljs-keyword">in</span> target_color]  <span class="hljs-comment"># Rescale from (0, 255) to (0, 1)</span>
    x = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>).to(device)
    <span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(scheduler.timesteps)):
        model_input = scheduler.scale_model_input(x, t)
        <span class="hljs-keyword">with</span> torch.no_grad():
            noise_pred = image_pipe.unet(model_input, t)[<span class="hljs-string">&quot;sample&quot;</span>]
        x = x.detach().requires_grad_()
        x0 = scheduler.step(noise_pred, t, x).pred_original_sample
        loss = color_loss(x0, target_color) * guidance_loss_scale
        cond_grad = -torch.autograd.grad(loss, x)[<span class="hljs-number">0</span>]
        x = x.detach() + cond_grad
        x = scheduler.step(noise_pred, t, x).prev_sample
    grid = torchvision.utils.make_grid(x, nrow=<span class="hljs-number">4</span>)
    im = grid.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) * <span class="hljs-number">0.5</span> + <span class="hljs-number">0.5</span>
    im = Image.fromarray(np.array(im * <span class="hljs-number">255</span>).astype(np.uint8))
    im.save(<span class="hljs-string">&quot;test.jpeg&quot;</span>)
    <span class="hljs-keyword">return</span> im


<span class="hljs-comment"># See the gradio docs for the types of inputs and outputs available</span>
inputs = [
    gr.ColorPicker(label=<span class="hljs-string">&quot;color&quot;</span>, value=<span class="hljs-string">&quot;55FFAA&quot;</span>),  <span class="hljs-comment"># Add any inputs you need here</span>
    gr.Slider(label=<span class="hljs-string">&quot;guidance_scale&quot;</span>, minimum=<span class="hljs-number">0</span>, maximum=<span class="hljs-number">30</span>, value=<span class="hljs-number">3</span>),
]
outputs = gr.Image(label=<span class="hljs-string">&quot;result&quot;</span>)

<span class="hljs-comment"># And the minimal interface</span>
demo = gr.Interface(
    fn=generate,
    inputs=inputs,
    outputs=outputs,
    examples=[
        [<span class="hljs-string">&quot;#BB2266&quot;</span>, <span class="hljs-number">3</span>],
        [<span class="hljs-string">&quot;#44CCAA&quot;</span>, <span class="hljs-number">5</span>],  <span class="hljs-comment"># You can provide some example inputs to get people started</span>
    ],
)
demo.launch(debug=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># debug=True allows you to see errors and output in Colab</span>`,wrap:!1}}),Rs=new u({props:{title:"Summary and Next Steps",local:"summary-and-next-steps",headingTag:"h2"}}),Cs=new Ln({props:{source:"https://github.com/huggingface/diffusion-models-class/blob/main/unit2/01_finetuning_and_guidance.md"}}),{c(){d=A("meta"),zs=a(),Ks=A("p"),Ns=a(),i(U.$$.fragment),Ds=a(),i(f.$$.fragment),Es=a(),g=A("p"),g.textContent=ja,Fs=a(),I=A("ul"),I.innerHTML=ca,Os=a(),i(J.$$.fragment),Qs=a(),b=A("p"),b.textContent=ya,qs=a(),T=A("ul"),T.innerHTML=wa,Ls=a(),R=A("p"),R.innerHTML=ua,Ys=a(),i(h.$$.fragment),_s=a(),B=A("p"),B.innerHTML=da,$s=a(),H=A("p"),H.textContent=ma,et=a(),i(k.$$.fragment),st=a(),i(v.$$.fragment),tt=a(),C=A("pre"),C.textContent=Ua,lt=a(),i(G.$$.fragment),at=a(),i(P.$$.fragment),nt=a(),i(X.$$.fragment),At=a(),Z=A("p"),Z.textContent=fa,pt=a(),i(W.$$.fragment),ot=a(),V=A("p"),V.innerHTML=ga,it=a(),i(x.$$.fragment),rt=a(),Gs=A("img"),Mt=a(),K=A("p"),K.textContent=Ja,jt=a(),i(S.$$.fragment),ct=a(),z=A("p"),z.textContent=ba,yt=a(),N=A("p"),N.innerHTML=Ta,wt=a(),D=A("p"),D.innerHTML=Ra,ut=a(),i(E.$$.fragment),dt=a(),F=A("p"),F.textContent=ha,mt=a(),i(O.$$.fragment),Ut=a(),Q=A("p"),Q.textContent=Ba,ft=a(),i(q.$$.fragment),gt=a(),Ps=A("img"),It=a(),L=A("p"),L.innerHTML=ka,Jt=a(),i(Y.$$.fragment),bt=a(),_=A("p"),_.textContent=va,Tt=a(),i($.$$.fragment),Rt=a(),Xs=A("img"),ht=a(),ee=A("p"),ee.textContent=Ga,Bt=a(),i(se.$$.fragment),Ht=a(),te=A("p"),te.textContent=Pa,kt=a(),le=A("p"),le.innerHTML=Xa,vt=a(),ae=A("p"),ae.innerHTML=Za,Ct=a(),i(ne.$$.fragment),Gt=a(),Ae=A("pre"),Ae.textContent=Wa,Pt=a(),pe=A("p"),pe.innerHTML=Va,Xt=a(),oe=A("p"),oe.innerHTML=xa,Zt=a(),i(ie.$$.fragment),Wt=a(),re=A("pre"),re.textContent=Ka,Vt=a(),Me=A("p"),Me.innerHTML=Sa,xt=a(),je=A("p"),je.innerHTML=za,Kt=a(),i(ce.$$.fragment),St=a(),ye=A("p"),ye.innerHTML=Na,zt=a(),we=A("ul"),we.innerHTML=Da,Nt=a(),ue=A("p"),ue.innerHTML=Ea,Dt=a(),i(de.$$.fragment),Et=a(),me=A("p"),me.textContent=Fa,Ft=a(),i(Ue.$$.fragment),Ot=a(),fe=A("p"),fe.textContent=Oa,Qt=a(),i(ge.$$.fragment),qt=a(),Zs=A("img"),Lt=a(),Ie=A("p"),Ie.innerHTML=qa,Yt=a(),i(Je.$$.fragment),_t=a(),be=A("p"),be.innerHTML=La,$t=a(),i(Te.$$.fragment),el=a(),i(Re.$$.fragment),sl=a(),i(he.$$.fragment),tl=a(),Be=A("p"),Be.textContent=Ya,ll=a(),i(He.$$.fragment),al=a(),ke=A("p"),ke.textContent=_a,nl=a(),i(ve.$$.fragment),Al=a(),Ce=A("pre"),Ce.textContent=$a,pl=a(),Ge=A("p"),Ge.innerHTML=en,ol=a(),i(Pe.$$.fragment),il=a(),Xe=A("p"),Xe.textContent=sn,rl=a(),Ze=A("p"),Ze.textContent=tn,Ml=a(),i(We.$$.fragment),jl=a(),Ws=A("img"),cl=a(),Ve=A("p"),Ve.innerHTML=an,yl=a(),xe=A("p"),xe.textContent=nn,wl=a(),i(Ke.$$.fragment),ul=a(),Se=A("p"),Se.innerHTML=An,dl=a(),ze=A("p"),ze.textContent=pn,ml=a(),i(Ne.$$.fragment),Ul=a(),De=A("p"),De.textContent=on,fl=a(),Ee=A("ul"),Ee.innerHTML=rn,gl=a(),Fe=A("p"),Fe.innerHTML=Mn,Il=a(),i(Oe.$$.fragment),Jl=a(),Qe=A("pre"),Qe.textContent=jn,bl=a(),qe=A("p"),qe.textContent=cn,Tl=a(),i(Le.$$.fragment),Rl=a(),Ye=A("pre"),Ye.textContent=yn,hl=a(),_e=A("p"),_e.textContent=wn,Bl=a(),i($e.$$.fragment),Hl=a(),i(es.$$.fragment),kl=a(),ss=A("p"),ss.textContent=un,vl=a(),ts=A("p"),ts.innerHTML=dn,Cl=a(),ls=A("p"),ls.textContent=mn,Gl=a(),as=A("ul"),as.innerHTML=Un,Pl=a(),ns=A("p"),ns.innerHTML=fn,Xl=a(),i(As.$$.fragment),Zl=a(),ps=A("p"),ps.innerHTML=gn,Wl=a(),i(os.$$.fragment),Vl=a(),is=A("pre"),is.textContent=In,xl=a(),rs=A("p"),rs.textContent=Jn,Kl=a(),Ms=A("p"),Ms.innerHTML=bn,Sl=a(),i(js.$$.fragment),zl=a(),Vs=A("img"),Nl=a(),cs=A("p"),cs.textContent=Rn,Dl=a(),ys=A("p"),ys.innerHTML=hn,El=a(),i(ws.$$.fragment),Fl=a(),us=A("p"),us.textContent=Bn,Ol=a(),ds=A("p"),ds.innerHTML=Hn,Ql=a(),ms=A("p"),ms.innerHTML=kn,ql=a(),i(Us.$$.fragment),Ll=a(),i(fs.$$.fragment),Yl=a(),gs=A("p"),gs.textContent=vn,_l=a(),Is=A("p"),Is.innerHTML=Cn,$l=a(),Js=A("p"),Js.innerHTML=Gn,ea=a(),bs=A("p"),bs.innerHTML=Pn,sa=a(),Ts=A("p"),Ts.textContent=Xn,ta=a(),i(Rs.$$.fragment),la=a(),hs=A("p"),hs.textContent=Zn,aa=a(),Bs=A("ul"),Bs.innerHTML=Wn,na=a(),Hs=A("p"),Hs.textContent=Vn,Aa=a(),ks=A("ul"),ks.innerHTML=xn,pa=a(),vs=A("p"),vs.textContent=Kn,oa=a(),i(Cs.$$.fragment),ia=a(),Ss=A("p"),this.h()},l(e){const s=On("svelte-u9bgzb",document.head);d=p(s,"META",{name:!0,content:!0}),s.forEach(t),zs=n(e),Ks=p(e,"P",{}),Sn(Ks).forEach(t),Ns=n(e),r(U.$$.fragment,e),Ds=n(e),r(f.$$.fragment,e),Es=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-rqo9tc"&&(g.textContent=ja),Fs=n(e),I=p(e,"UL",{"data-svelte-h":!0}),o(I)!=="svelte-13fudn0"&&(I.innerHTML=ca),Os=n(e),r(J.$$.fragment,e),Qs=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-zrb19s"&&(b.textContent=ya),qs=n(e),T=p(e,"UL",{"data-svelte-h":!0}),o(T)!=="svelte-3ogxkl"&&(T.innerHTML=wa),Ls=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1hvsyk8"&&(R.innerHTML=ua),Ys=n(e),r(h.$$.fragment,e),_s=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1lx02oa"&&(B.innerHTML=da),$s=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-f9b21z"&&(H.textContent=ma),et=n(e),r(k.$$.fragment,e),st=n(e),r(v.$$.fragment,e),tt=n(e),C=p(e,"PRE",{"data-svelte-h":!0}),o(C)!=="svelte-djzc0v"&&(C.textContent=Ua),lt=n(e),r(G.$$.fragment,e),at=n(e),r(P.$$.fragment,e),nt=n(e),r(X.$$.fragment,e),At=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-yu4xe4"&&(Z.textContent=fa),pt=n(e),r(W.$$.fragment,e),ot=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1b913zv"&&(V.innerHTML=ga),it=n(e),r(x.$$.fragment,e),rt=n(e),Gs=p(e,"IMG",{src:!0}),Mt=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-198zocx"&&(K.textContent=Ja),jt=n(e),r(S.$$.fragment,e),ct=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-b4vpyb"&&(z.textContent=ba),yt=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-mrzt0p"&&(N.innerHTML=Ta),wt=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-8wm9hd"&&(D.innerHTML=Ra),ut=n(e),r(E.$$.fragment,e),dt=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1fzelv9"&&(F.textContent=ha),mt=n(e),r(O.$$.fragment,e),Ut=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-25kjgp"&&(Q.textContent=Ba),ft=n(e),r(q.$$.fragment,e),gt=n(e),Ps=p(e,"IMG",{src:!0}),It=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-nwf1ky"&&(L.innerHTML=ka),Jt=n(e),r(Y.$$.fragment,e),bt=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-17wo0ii"&&(_.textContent=va),Tt=n(e),r($.$$.fragment,e),Rt=n(e),Xs=p(e,"IMG",{src:!0}),ht=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-pzsrjl"&&(ee.textContent=Ga),Bt=n(e),r(se.$$.fragment,e),Ht=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-8rdev9"&&(te.textContent=Pa),kt=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-ltxpxf"&&(le.innerHTML=Xa),vt=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-k57cg7"&&(ae.innerHTML=Za),Ct=n(e),r(ne.$$.fragment,e),Gt=n(e),Ae=p(e,"PRE",{"data-svelte-h":!0}),o(Ae)!=="svelte-6xoywo"&&(Ae.textContent=Wa),Pt=n(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1xmb7ou"&&(pe.innerHTML=Va),Xt=n(e),oe=p(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1khx755"&&(oe.innerHTML=xa),Zt=n(e),r(ie.$$.fragment,e),Wt=n(e),re=p(e,"PRE",{"data-svelte-h":!0}),o(re)!=="svelte-fla544"&&(re.textContent=Ka),Vt=n(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-18dweg8"&&(Me.innerHTML=Sa),xt=n(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-4bgkmx"&&(je.innerHTML=za),Kt=n(e),r(ce.$$.fragment,e),St=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-lqh8ec"&&(ye.innerHTML=Na),zt=n(e),we=p(e,"UL",{"data-svelte-h":!0}),o(we)!=="svelte-16hxcy8"&&(we.innerHTML=Da),Nt=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1ov68o7"&&(ue.innerHTML=Ea),Dt=n(e),r(de.$$.fragment,e),Et=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-vvsond"&&(me.textContent=Fa),Ft=n(e),r(Ue.$$.fragment,e),Ot=n(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-14n09vw"&&(fe.textContent=Oa),Qt=n(e),r(ge.$$.fragment,e),qt=n(e),Zs=p(e,"IMG",{src:!0}),Lt=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1ym7b5x"&&(Ie.innerHTML=qa),Yt=n(e),r(Je.$$.fragment,e),_t=n(e),be=p(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-v6f2"&&(be.innerHTML=La),$t=n(e),r(Te.$$.fragment,e),el=n(e),r(Re.$$.fragment,e),sl=n(e),r(he.$$.fragment,e),tl=n(e),Be=p(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-1ln888x"&&(Be.textContent=Ya),ll=n(e),r(He.$$.fragment,e),al=n(e),ke=p(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-du7asl"&&(ke.textContent=_a),nl=n(e),r(ve.$$.fragment,e),Al=n(e),Ce=p(e,"PRE",{"data-svelte-h":!0}),o(Ce)!=="svelte-1a2j1bv"&&(Ce.textContent=$a),pl=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-q8167x"&&(Ge.innerHTML=en),ol=n(e),r(Pe.$$.fragment,e),il=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-m1z6vm"&&(Xe.textContent=sn),rl=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-mu78ou"&&(Ze.textContent=tn),Ml=n(e),r(We.$$.fragment,e),jl=n(e),Ws=p(e,"IMG",{src:!0}),cl=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1fjvhwc"&&(Ve.innerHTML=an),yl=n(e),xe=p(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-1t72sjo"&&(xe.textContent=nn),wl=n(e),r(Ke.$$.fragment,e),ul=n(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-12pfvi9"&&(Se.innerHTML=An),dl=n(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-zp66zy"&&(ze.textContent=pn),ml=n(e),r(Ne.$$.fragment,e),Ul=n(e),De=p(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-18cclzv"&&(De.textContent=on),fl=n(e),Ee=p(e,"UL",{"data-svelte-h":!0}),o(Ee)!=="svelte-10dkp2g"&&(Ee.innerHTML=rn),gl=n(e),Fe=p(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-kz6atn"&&(Fe.innerHTML=Mn),Il=n(e),r(Oe.$$.fragment,e),Jl=n(e),Qe=p(e,"PRE",{"data-svelte-h":!0}),o(Qe)!=="svelte-ph1bo8"&&(Qe.textContent=jn),bl=n(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1imz0t0"&&(qe.textContent=cn),Tl=n(e),r(Le.$$.fragment,e),Rl=n(e),Ye=p(e,"PRE",{"data-svelte-h":!0}),o(Ye)!=="svelte-114xh3v"&&(Ye.textContent=yn),hl=n(e),_e=p(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1n6m85d"&&(_e.textContent=wn),Bl=n(e),r($e.$$.fragment,e),Hl=n(e),r(es.$$.fragment,e),kl=n(e),ss=p(e,"P",{"data-svelte-h":!0}),o(ss)!=="svelte-1bsa45q"&&(ss.textContent=un),vl=n(e),ts=p(e,"P",{"data-svelte-h":!0}),o(ts)!=="svelte-dgvmr3"&&(ts.innerHTML=dn),Cl=n(e),ls=p(e,"P",{"data-svelte-h":!0}),o(ls)!=="svelte-14y0fiq"&&(ls.textContent=mn),Gl=n(e),as=p(e,"UL",{"data-svelte-h":!0}),o(as)!=="svelte-9hltdt"&&(as.innerHTML=Un),Pl=n(e),ns=p(e,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-4w2jm8"&&(ns.innerHTML=fn),Xl=n(e),r(As.$$.fragment,e),Zl=n(e),ps=p(e,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-tef87y"&&(ps.innerHTML=gn),Wl=n(e),r(os.$$.fragment,e),Vl=n(e),is=p(e,"PRE",{"data-svelte-h":!0}),o(is)!=="svelte-1j5zcnv"&&(is.textContent=In),xl=n(e),rs=p(e,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-1hx04wi"&&(rs.textContent=Jn),Kl=n(e),Ms=p(e,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-75kyuh"&&(Ms.innerHTML=bn),Sl=n(e),r(js.$$.fragment,e),zl=n(e),Vs=p(e,"IMG",{src:!0}),Nl=n(e),cs=p(e,"P",{"data-svelte-h":!0}),o(cs)!=="svelte-c8uajk"&&(cs.textContent=Rn),Dl=n(e),ys=p(e,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-1xb7qcg"&&(ys.innerHTML=hn),El=n(e),r(ws.$$.fragment,e),Fl=n(e),us=p(e,"P",{"data-svelte-h":!0}),o(us)!=="svelte-1themub"&&(us.textContent=Bn),Ol=n(e),ds=p(e,"P",{"data-svelte-h":!0}),o(ds)!=="svelte-uymir9"&&(ds.innerHTML=Hn),Ql=n(e),ms=p(e,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-1wgwcwu"&&(ms.innerHTML=kn),ql=n(e),r(Us.$$.fragment,e),Ll=n(e),r(fs.$$.fragment,e),Yl=n(e),gs=p(e,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-dvmpiu"&&(gs.textContent=vn),_l=n(e),Is=p(e,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-16hrp9q"&&(Is.innerHTML=Cn),$l=n(e),Js=p(e,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-m9p2rn"&&(Js.innerHTML=Gn),ea=n(e),bs=p(e,"P",{"data-svelte-h":!0}),o(bs)!=="svelte-1snpl91"&&(bs.innerHTML=Pn),sa=n(e),Ts=p(e,"P",{"data-svelte-h":!0}),o(Ts)!=="svelte-1ea64ap"&&(Ts.textContent=Xn),ta=n(e),r(Rs.$$.fragment,e),la=n(e),hs=p(e,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-1hccnnv"&&(hs.textContent=Zn),aa=n(e),Bs=p(e,"UL",{"data-svelte-h":!0}),o(Bs)!=="svelte-h43tvb"&&(Bs.innerHTML=Wn),na=n(e),Hs=p(e,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-gu4dbz"&&(Hs.textContent=Vn),Aa=n(e),ks=p(e,"UL",{"data-svelte-h":!0}),o(ks)!=="svelte-u3vmmy"&&(ks.innerHTML=xn),pa=n(e),vs=p(e,"P",{"data-svelte-h":!0}),o(vs)!=="svelte-xircjg"&&(vs.textContent=Kn),oa=n(e),r(Cs.$$.fragment,e),ia=n(e),Ss=p(e,"P",{}),Sn(Ss).forEach(t),this.h()},h(){m(d,"name","hf:doc:metadata"),m(d,"content",_n),xs(Gs.src,Ia="data:image/jpeg;base64,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")||m(Gs,"src",Ia),xs(Ps.src,Ha="data:image/jpeg;base64,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")||m(Ps,"src",Ha),xs(Xs.src,Ca="data:image/jpeg;base64,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")||m(Xs,"src",Ca),xs(Zs.src,Qa="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAEpAikDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD3+iiigAoorI8T6y+gaBcX8UInnDRxQxM20PJI6xoCew3MM+2aANeiub0fV9WXxFPoWtiykuPsi3kE9mjIjJuKMpVmYgqcc55DdBirF54z8L6fdSWt54i0q3uIm2yRS3kauh9CCcigDcornf8AhPvB3/Q1aJ/4Hxf/ABVH/CfeDv8AoatE/wDA+L/4qgDoqK53/hPvB3/Q1aJ/4Hxf/FUf8J94O/6GrRP/AAPi/wDiqAOiornf+E+8Hf8AQ1aJ/wCB8X/xVH/CfeDv+hq0T/wPi/8AiqAOiornf+E+8Hf9DVon/gfF/wDFUf8ACfeDv+hq0T/wPi/+KoA6Kiud/wCE+8Hf9DVon/gfF/8AFUf8J94O/wChq0T/AMD4v/iqAOiornf+E+8Hf9DVon/gfF/8VR/wn3g7/oatE/8AA+L/AOKoA6Kiud/4T7wd/wBDVon/AIHxf/FUf8J94O/6GrRP/A+L/wCKoA6Kiud/4T7wd/0NWif+B8X/AMVR/wAJ94O/6GrRP/A+L/4qgDoqK53/AIT7wd/0NWif+B8X/wAVR/wn3g7/AKGrRP8AwPi/+KoA6Kiud/4T7wd/0NWif+B8X/xVH/CfeDv+hq0T/wAD4v8A4qgDoqK53/hPvB3/AENWif8AgfF/8VR/wn3g7/oatE/8D4v/AIqgDoqK53/hPvB3/Q1aJ/4Hxf8AxVH/AAn3g7/oatE/8D4v/iqAOiornf8AhPvB3/Q1aJ/4Hxf/ABVH/CfeDv8AoatE/wDA+L/4qgDoqK53/hPvB3/Q1aJ/4Hxf/FUf8J94O/6GrRP/AAPi/wDiqAOiornf+E+8Hf8AQ1aJ/wCB8X/xVH/CfeDv+hq0T/wPi/8AiqAOiornf+E+8Hf9DVon/gfF/wDFUf8ACfeDv+hq0T/wPi/+KoA6Kiud/wCE+8Hf9DVon/gfF/8AFUf8J94O/wChq0T/AMD4v/iqAOiornf+E+8Hf9DVon/gfF/8VR/wn3g7/oatE/8AA+L/AOKoA6Kiud/4T7wd/wBDVon/AIHxf/FUf8J94O/6GrRP/A+L/wCKoA6Kiud/4T7wd/0NWif+B8X/AMVR/wAJ94O/6GrRP/A+L/4qgDoqK53/AIT7wd/0NWif+B8X/wAVR/wn3g7/AKGrRP8AwPi/+KoA6Kiud/4T7wd/0NWif+B8X/xVH/CfeDv+hq0T/wAD4v8A4qgDoqK53/hPvB3/AENWif8AgfF/8VR/wn3g7/oatE/8D4v/AIqgDoqK53/hPvB3/Q1aJ/4Hxf8AxVH/AAn3g7/oatE/8D4v/iqAOiornf8AhPvB3/Q1aJ/4Hxf/ABVH/CfeDv8AoatE/wDA+L/4qgDoqK53/hPvB3/Q1aJ/4Hxf/FUf8J94O/6GrRP/AAPi/wDiqAOiornf+E+8Hf8AQ1aJ/wCB8X/xVH/CfeDv+hq0T/wPi/8AiqAOiornf+E+8Hf9DVon/gfF/wDFUf8ACfeDv+hq0T/wPi/+KoA6Kiud/wCE+8Hf9DVon/gfF/8AFUf8J94O/wChq0T/AMD4v/iqAOiornf+E+8Hf9DVon/gfF/8VR/wn3g7/oatE/8AA+L/AOKoA6Kiud/4T7wd/wBDVon/AIHxf/FVJB438KXNxHbweJtHlmlcJHHHexszsTgAAHkk0Ab1FFFABRRRQAVkeJ9GfX9AuLCKYQTlo5YZWXISSN1kQkdxuUZ9s1r0UAc3o+kas/iKfXdbNlHcfZFs4ILN2dFTcXZizKpJY7eMcBepqv8AEVV/4RPJUf8AIQsO3/T3FXWVx3xPmFv4GmmY4Ed5ZOT9LqI0DW54R4/1V9R8QyQK+baBtiKOme5rmdoEqucbfTHSnSyyz33mYU75CSWPrVt9Pkdmk3W4b+HL5rgqT1uz1YQ7IVLuLGEG4+1WVuLm2UNLA/lHpkZFQxf2sgAjSBsrn5BnFS2xvPP33EwV0+6NoHP0rHQ2Sb2/IuQ3djOADEwb19KeWhDYUyf8BkNT2+t7HEN9BGM8CULwf8Kr6nBtuleBt0b8jb2rNb2egPYtxsAPlZm9mO6nmIyHLkKO6rWjb+GZ3sY7qO5URsM7XGCKj+xpEwBuoSR/D0NZNvoUuUWwiXk+U5UcDaK0t7FhlKqG4ICx/aIl/wBkGnQvG8wi+1wNJ2RpMZ/SsWmzS6L0F8N3lttPbmqV3Z+VIzCPEfXOOBVoaDeyEzh43fsF4UCorhLmJNr28pPQmMgiu3C4uVF6anJiMPGqrMoII3+6VP0q/aWys4LAbRzVD7La53lGR+4U7T+lXorpGxEoYbR6Z/M16LzOM1azRxLK5QfNe5rxqiDoM96yb/LXbAYwOgxVlZMfxVSuG33Z54wOaVOd2Y4iNolfyxu6CmyIucACpWYKD61VeUZ5IrY4WBCjsPyqOR9o6CmPMn94fnULurfxcfSk2FmVN5s9QS8iADg5JHevStPvItSso54HVZRyCvY15vOybTsPPvVjRdVm0y5/dcqxy0fr7j3pb6lRutGe6aPdR6jYiUookRjHIuOjDr/j+NW3jQfwj8q5vwHqEV9Z6jchtsbz713DGVCqCfpkH8q5/wATfE2FZ3sdGUuc7Wu2HyL67R3ppNltpbnS6zrNnpoKNteYjiNev/1q4DVvEDXG7cAo/uiqovY5keUziaQ8s5OSTWBqkiSEeW3I+9zUa31BvTQe+rbmIwAKVb2LALyLn2rAkLbvUVNBEG5PPtWmiMbNms92r5EbfpSQx3UxVoFEhX7w9qrhH8s7WWMD0FJJJd28SSws27+8o5H1FLn7D5O51WhYTUYGbG0HnPatnVfE9vblorVFllHBP8I/xrj9P1M3ETxshiudhyPX3FK0OKuFR2OmnBJD7rUbm9Y+fKWH9wDCj8KrERgcJmlKj0pMdqL3NSFwFP3RXPapcqztGgyRxn0roLlhFDI7H7qk1y9lC19eiIHqcknsPWmhlnT9FRlFzfSokR5WMMNzf4Cr8sunRnEFtEuOwFWm0/T7aLL7pGx64zWHNEBJwCqk9PSkxp2LMlwsnRI1/Cqj3KK2CRgegqwsQgj3uCc8DA6VmT5aQ7RxRETuTPLHPwCqt2J4zUZDRn5h16HtVbayn5lbH0p8cxxtOeOcVZJZju5raRJY3aNwcqynBFew+A/iBHqnl6ZqrILvGIpsYEnsff8AnXibsW5Pf0p0ErwyKyMQVOQQelUnYTVz6w8tD/CPyrnfGehRa34YvLYxgyqhkiIHIdeRj+X41kfD/wAaprNqmnXso+3RjCsf+Wg/xruHHFbboxaszwq+tpdZ8LoXGbqONJOR944//XXnMw2kqR05Ne4amEj8QzxhNquzqMdOOcV5P4qsBZ6q+wFVf5h6e4rjqx6mEJ++4nOsfQU6OZ4ZVdCVIOQe4p0cZ+82NvPU9akhtJbpiscZOOc+grJGt0tz1vwF4xGpqtheEfaFHySEfe9j7138N7byTGL5dwOM9ia8O8IaReNerdR/u4E6yH+L2FeqjDRKwrrhHmjqcVWXJL3TqQqf3R+VOGwfwj8q5j+1bm2IViHXsWp6a9KGBkjBTvt6il7GRPtonQyJDKCuEJ9CK56+txDOSvHqp/pWkZILyASK3To6HBFZ811FLG8NxcRsB92TOGB9xWkIu5nUkmjF1yxF7p5KqC8fzriuu0/TrO1tI1ht40G0Hhea5Ti6ZbdZWXc4UkDIYHiu4jUKoAGABgUV48tkFCXMmKsSAfdH5U8Rp/dH5U5RxTqxSNbla5gEkLqFGSCOlc/qtsLeDQ02gEazYjOP+m6V1PWsHxL10X/sM2P/AKPSm9i6Xxo9ZooorM9EKKKKACiiigArjPionm+AbmMjIa7s1/O5irs65T4iKH8JBCMhtQsB/wCTcVDGtz5aRJYyxKfKrkEn1rUSW8mj2wWcT4HWu2+JGnaRaXVpFZCBJBnzo41AIJ5yfeqVr4eiXSI76UoIScFgDkfr7151VK56tOTto7HHXV1qukxrI9lCFfoRzzVCXxDeyD99bRrnsVPNeteHYbCeWaE2UIMQBWX72/8AE1w/j+8h/wCEm8tWidIogmBj5TzU0+WT+EVSc19oxbO+W4GCrIe4HKmteCTCYByPSufhu4IwFjI9zWpA+cFGq5xFCTPT9G14SaNEkiCOVBtBIOGx36VC/wBku5SLn7PKzHPOCan0BRHo9uGXkrn86h1a2t7l1Ei4OOGHBFc75Yo1+JkMvh7Sp+kZU/7EhX+tZOpeDVlG63vZldeVEvzD8+tTTQanp67opfPt8ZG4ZIFVovELhtrgqfY8UJyWqE43KFrrus6Fdra3ymWPOA2ecex7/jXevbm+08TozLIQCB0zXKXM8WoxlJFVgf0rf0e6uJ9HktncedBwHx94diaxrwTXNFWZdObT5WcveyTwTk8hgcMO2auWN6VYO/AIw1TnTLtp5vtQBjY547n+lUGVoGaN1BUdu9JST9Tosa4k3fXNVLuXyjub6UkEqmJVB/Os/VJG81Yy3RM4rvws+aTTPJx9Plgmu5Bc3+4kDOKoyXpPAf8AMUyXO0kHFVMMFz3967OXmPL5uUurdxvhZI1/3lpJGRSAjbT6g1mSK27Oc8/hUCR3BlIXdjuaORLZj5m+htGQYxIQD6joaaqOHBHA7EdKrEFBwCCBk1MjuqhlJ98U4omRvr4l1IQQwwTeUIRgFOCc9c/WsKZXkmeRjgsxY7feiSVnQEABh1rMnv5EYryK0jKxnJXNJZFtoywds1VN1GSN+efes+W+kddpPFRLJkHcaJajjobMwjVA0chZc4IpYZEjILZ256jtWMjnd96tWDZ5XBPPXNZtWWpond6FifUwv/HuoP8AtMKqeZdlGuBIyc4yP4j6VMkfmMURNoH3n61KykNtBwi8AVK5Yj1ZpaJcreEs4Czqp3j+97itSVeOlZOihUutoA+6Tn0rWnGc1cTansUmODQo5yRx6UpXmlDqg55NUaGZr7RrbkIh3twBnNY2kxtEzS9GbgVLqd0bm8YqcpH8o9zUcLkY4yqjH1plFueUbtoJYnvSLbiONpJBuwCee1RKbp71YrW2DYG4M3rWpLYrDCpv7kHPWKPjJ/nSYI58XDmZkdvlc5x1GapyqfOPzKOfWtDU3jY+XFEI1HpUugeG5NXvAqqfJXDSSHqPana4hsV5eLah35toiMAAAE/Ws251CW6uWlZI959EFdh4sMNjYpp9soVR1461xkSbX54BoKZE5kZsnvSpJgEFQRUj9xmq7AhsrTTIaN7w5PJbatBLCzBlbdgdfwr6SspmudOtpnGGkiVj9SK+cPCElt/wkNmJ2xGzY57MRgfrX0lbxLBaRQr91ECj8BW9PYyqHnWurs1aSU/w3JP4EkVy3jHRvtNpJMOHjywxXV+Iw76g8aRl8yOx2qST8x4/Sm30AlTacHzE6VLV9GeZOXLNtdzwiKNpJAijJJwBXo1j4eS209YJSQzL8xHvVbT/AAlcW3iHzp4v9GRiyn19K625CheAM+tZ0Ya6hiKt7WGWwhtrGG2hBCRLgZ71etboCPY/4VkI+48GrA4Gc13KmkrHE6jk7svXUqNGQT9KrxzB1AH5VVlYvwvOKkt4yo6HcauMVYiUm2aEEskBLRPtJ6jsaqX0bErfDZudyCoXp+dSMGRSe44qyZ9tj5RiSUSk4B7Hjp78VcfddyZe9GxN4dthcXBnkXPl42+mfpXWeZg4rM0uAQWqwqm3A3FvU1fNcFd89VnZQShTSJYptzuPQ4qwDVKFQrsfU5NXFPFTYtO47FYXiYf8gX/sM2P/AKPStzeB1NYnibpov/Yasf8A0elJ7GtH40erUUUVkekFFFc/4y1HWNI8NX2qaR9h32VvLcyC7R3DKiFsAKRycY60AdBRXMalruqPeaNpWkraLf6hbvdSTXKM8cMaBMnYrAsS0igfMO9Z0fjHU7qysbG3trSPXbjUZtOk37mgjaEMzyAAhmUqoIXIOWAzxQB3Fcf8Tt//AAhEvlsVf7bZbSOx+1RYrT8N6xeag+p2GpxwLqGmXIgma3BEcgZFkR1BJIyrjgk4IPNcj8WvEmjP4N1DSoNYsW1Vbm2AtEuEMwYTxkjZnOQBnpSew47nkM/lvpKySyGS5cksWySW9Sa6Tw5qlqnhG90+83PLJIpiXG7DdPwrio5tzCMHODkg1v6UoR/nXEbfu2+nY/gcV5c5uKPYjBSLHiGyQaOJtOjMVwz7UaNsEjOOxrzu+8PX0cRuLiaFGZj8kkoDn3wa9ZWE3GnTqjbrmAMAcdCDuH58V5L4jDtq8kjfx4YH608JN/CRioK3MzKW2kMu0AjHfNbNjcXNq20qZh2AFQW7YCAqegyTXV6BLFAd5RMtwMiumpPTY56dO2qZsWXjq1hhjgmtZotqhfWr0niTSbnY7XUYHfJ5FJ4jn0218My3FzaxTzMNkIIwdx6HI54615xYw+fOrDOUO5kPoOaw9lFq5qpyvZHpseoWTpsivom4ySr/ANKydSigmRpYypYckqa5h54wCMANnk+lQLeSJJIYkZgOMjkVmoPobtpbnRafMgYrJIi46Etit+BpDbzPazKJAmflIIbHOK80bUGUnG5cmi1vrmB/NgldGzw39Kp0W9TH2qPZYZ2ubFJpON6/eFc3fzMSVfBxxu7j0NJ4S8WWuoWA0+6ZYruMYAPRx7e9O1tkaLzUIbHDH29DXJyOM3Fo64TTjzIow3DeaFPc4NLqEZl2yKcjb278msiaTyDGwb5WHyt7f4it4ET2MLnG0qcYrtwsbTb8jhzB3pr1McROG4Un2qQWYK5MYHr6f/XrTjts4GBg9B/jVWa+t0cwRuryDrjotdbk9keXGK6lSS0+bOEwB3qukZVirDA7N6VK2oCSTrwD9496RZTK3lrud846dfwoVxtoryhIwZGZti/eIqAX8QACg8cAmrtziK1kRoiS3BBqLw74Zm1q9/e+ZDZJzJMF4HoOe9XF6amco66F0W0k1oJY43Ic5HGR+dYd7Ap3Z4cfw16P4X8Q6dfXVrpNroyeWIiokmm3MMAktgDFdDq2i6VqNjJC9pCJQDt+UBh9CKcNXYJLQ8A+YgkDpU0SeYB1wOuKtalprWM0qAkqrFSD1FVwDbyIBnpg59a0ZmK0ewryefUVo28b7AByPUd6aI0lBIPI6j0rR01WjZdy5QnrispS0LSL2nxqtoyqR5hPTv8AX3pslm+4ZjfA6/Ka0hDHxJERkHpU8bnlTHg+4zXNzu90a20sU9OtCt2CsTg7COe9XJycAYxVtJvs/wC/YKRGCxA44p9zaL5gZWDIRuGPQ100ruFy4WWhiPu7An6Cs6ed5QyR8cH5vStG5na4lNvCTsBwQo61WktyowEIHfitHoaHHPO0ZCFMEE5PetC0XcFBGFOOam1LTwczKAG7gd6qWMywybLkuE5wcZxTTBmqTd+cxt7oRkrgKSAMfWqYe6iuG+0IHJU/MTux+VXYvs8lyrRzo6AjjPP5Gu10DwbF4i1eOYyLHZBMZH8bd/wFVJBHc4/RfDN74hucRrthB+aQrkD6epr0hrLT/CeiC2h+aUjn1Y+pra8SWvh/SzBDdSR21naQlppIn2SyN0VBtwcnk15Jdz6Pf6lLPHJcQ2p4SIzF2x7saVirmfrl19uu2ZhjHTisN1AHHNbN9Hp5dY7PzdxPLGQ9KrXOkKnzK7c+pzU7BdsyWPY85qJvv7ccdKsPbyiXyyvPYjpWo2lJb2hDIXcjkg5xTWom7GJZ3BtLuGVDgxuGHvg19V2Vyt5pttcp92aJXH4jNfKUiYZl7ivoX4b63FrHg+1iAYTWaiCQH26EfhW1J9DGoihqeW1spj/lo5zk8cn/ABplycTLjPA71oGw+161cyF8eVI5x65P/wBasLUb+O2uHJzhTjk5xWiseNXvzteZLcXMa8s2OOaqf6PdqQsoBPtWHNdtdSbmP7vPHvUluDHJhF5z2NcrxUYysjSOGbjqaQ0qRTlZI2+jY/nRNE0Iww59zU0O1k+fI+tU7iKPzMgn861eMXRELCPqxFmhgKvJOhLcBRV+1nhuQSoBYDkdCPwrJAJfC4yPmwRnpWjpF3A2tW8t3GqR/MjN22kcfriksYk1cbwja0NBIGMDSCNvLU9SOPzqtalv7SjVukf3fc1p61FJaLJFvbyWOY9p4wTVTR4vNuC7DO0Z/Guv2t43RyeztKzOmtU2Bye5qxyabEmxApqUYrm9Tp20BRiplNMxThxQMqampe2ZVJDdRg45rAvL17qDR4pW3SRa1YDd/eBnTBrppV3jFYOuWsUEuktGeTrNgCP+3hTTduSxdG/tUz2Kiiiuc9UKwPGVhq2reGL/AEvSI7Jpb63ltpGu53jWNXQruG1GyRnpx9a36KAONbRfEnmaRqyRaVHq2nxS2r2/2mRoZoHCf8tPLDKwaNT90jqKij8Hana2VjfW9zaSa7b6lNqMm/csEjTBleMEAsqhWADYJyoOOa7eigDC8N6Peae+p3+pyQNqGp3InmW3JMcYVFjRFJAJwqDkgZJPFUPiJD5vhMIpCs+oWChsdM3cQzXWVy/xAO3wxG3pqVgf/JuKk9hrc+bmsnivJY2wHV2U4HGQa6Gycmz+Yj5etSeJdOFl4mu0Rso7eYCeAM1QLpAj4mEjAZ2oOM/1rx6mrse3S0jcfol3e3XiNJIWYCR8uB02j1qTxjLay6W+m2VspuGcEBUGTz1GKz9Fu7/TWlkgAKSLtct2+lFrcPc66boMoES/Lv4GcU7P2nMug2lKNn1OVW1Z9sUiNBN0y4+U/wCFamlQ3YuIw8ZMYON6nI4r1xtIsP7LSa6SS5VYwwR+QeK4B/Cuo3cYvtJuEED5kSAPgoDzitaWIVRe9ocs6XJ8OpBrzNqGp2GmKmRF+9kBPGMf4A1nxDyhNPEm1VxyvYcf4itu7vLC28KvNw2sXbeTKx+8qjgj2GMfnXPJdhIbi1Q7g6AHHscn9acnzbGtK0dWUzB9umUZ285Kjjj1rcuTBbWaRxqirtweP881naZYyyB2Xc2SFGByQKuHw7rOp3QjitZGLcKMYAHqTUzs3ZuyQrtK6Wpz13ao0kLJKTJLkhFQnvgfnUo0fUU1CPTfL23UjqFjZSDz04NeoWGhab4ItYLq+RLzWJRthhXnDe2fT17VseGNOh1CabxTevBPeykhFiO5YQOMfWiOI5vhWnfuZKlrq9TwnUtPvdI1NoLlGhnRuo/mDWjY61NJmO5lPPG49x711fxJu7a9kjTyJBOh+V9vBFcVZaVezHP2bMR6liFrdSjOF5EqM6c7Q1N1biJoxGQrAHghsD/Cuis0X7BbqoIULwD9TWVbeGIJLUOqyZ/vI2cVbu3fRtF6ncse1cjHJJqaMouTURYyMlTTkupmeIdYZnaytpCgHEjDqfYVjxyPtEYIAC7Sq9SM55NUQzMSSc5OTnuasx7wcAryOR0NdqVkeS3ctgEEB84I+Q1qW12YywEWXKYZgf1qnC6xgZwRjOBx+ddF4c0yXXtQNsreRFjLMi5/D3pPYpb2JLHQrnUkSHGJZQHbcOFHYn8Oa9ci8JC18ES6XaxB5JI8Hd8u4nqfyq3oHhMaasTTSl9oHBHLYGBk/wBK6hyFQsegGalJspnjHhnwpNDPrF3BD5F7aWskSDHO5uB+OA1VNE8RnVIPslyQLpejdN2P616H4R3XKalfuCgu7jKg+gH/ANc1g6t8LftV7Je6ZfpDJJIZCGTgE+hHSrp7XJqI8/8AFenq4+3KucELOo7j1rlJLVT5ksLCQJwy9x/tD1Fey3vhC8Fr9juri1kuniJbBPzryPT9a8kmsr/S1juGtpYlz8jleGFVJmaRkRu0Um5c5rptKi+2oRD8r9Sp6/hWSYQ0gcKoDHt0z6e1bFjG1tJ50IKyRffUnt7VnU28xxeprCKSOFvtBI2kDcB0+tS7J1sAykHeeCOpH0q19si1GyAk2ktjJHXjnkVIkduXMs1yuR0QYGABXIm+pqZt0WWxuSVO4wsOnfGKu38VxBYwWyfKTEqu/fGKisGXWbr+z4XzJIp2k8CtrWUJU7lwU4x7jtXfRT9nqVTscrGslmCYG2HoT3NQSl3bdKxYnnk5qzKpbqeBwKquoDFhkjGDmmbDMKwwQCPpWfdRkbgACp7YFaaoZULxjcAcHb2NZ14hUF/mABGcjrVWJuYFyqs+UCiiHVby0zFFdTJATzGHIB/CpZUAYhTxkkfSmLZy6ldJBAu6VztUY6mkPUjvtQlvHUFmcYzknNQKz7ScsorSuNDutNdobqIpMMHHqPaqkuQSAeM9+aE7jaa3JtPG+6XLtu+vWunubYCzQlSGxnFYOhQ+dqKDjgEntXa3cIKjsfSlMcDn7izUoH3YC+vUGoDFcTGNMNk52t69a1JU3RHjqCcVLDbl47WaGM/u2DmMc5U9qjmtqacl3Y5DUIFdd0n7qVSUyRwfTNd58F7yRb3UrItmNo1lx6MDj+tcl4thSVfOjkDKjbQP73ofqOlTfDPWLfRvFCyXUrJHJGYz6ZOMVpSldpmNWNro9mZhC95JkLmR9zewJrgdbeG6uRDaOvlry8jHl2PX8K7LWDnTrjymJeaVxjsBk15ta2zlmznhsHd2+lTiJv4UeXGK55Sfc0YrJyF+YbRWjb2UaEO2WP4mm2sAwAzYrRPyr8uSPpXPGBbmIAgwBGfwAqZNOa5Q/uyoP8TEYq3pNg17LlyVjUZY1sXRt1QwRjaFwM1pGnfch1DkZdOghtDJK4Ej52Ln5j6YqGOCK1sRNfruL8xwjr9SfSrWpiS+vYlghUrD0dj+fA+lZ2sSvIoAAZgMHt+ArkrRcnZnXSatoWo9Sn1a0MDqgKMChDdV9CK6HRNOmjLuyMAW+UEY4FcFYRRpOgu2kt5h0fPymvQ9LkvvORRIJExyfatsJVmoSi9kZYmjGUlJC6xqLacyuEDxp/rgDkp6HFTWepW13gwzI2RkYNZfiW+0iOR4yJJbg8OY2+79a4m8mTS0t5bKWQNnO1wQRW8cQt2ZvDPoesg0xnAOK5nQvF1pfwRxsr/aTgN/dralulzjIrpTTV0ckrp2ZO8pQE9RXLajqBu9W0tB90atYn8riP8Axra+1RhgshIQ9x2rB1GwNlr2l/OHV9UsmVgMZBuY6pNcrTHTv7WNtrnvFFFFcx7AUUUUAFFFFABXKfEVgnhHcxAA1CwJJ/6+4q6uuO+KB2+BZye15ZH/AMmoqBrc8m8SzC58QzzRJuDYVWxjPGO9YB+RmVhgnoK0by4Zp3lbqATWR5qiYSOQcc81483eTZ7NP4Ui7eyx2lnHEo/eEZ+lUoYM6dMmMOQS3rVe61N4bhZUMbuGyFddw/GtOC6GogzNlLojGzACt9PSoacY3NE05WPTYANR8Gx28bEGa08sEHn7uKxtKsr3RNNitdTVWiQbUmU5wOwPpWZofiCPTrYWdyTHtbgMOn0NdJq2pwXPhm+dHVh5DEHPfHFc0ZSi+W2jYpRW55Zq2p6dHql4EjLvIWCDaCBjuPxrn7KW1aU+dKYtykZA6Gsq5lfzt+SGByPan2EYnuAjcg9RXrqkoxbOJ1nKSj2PZvhr4fE1q2oXOHj5EZ9eetddrmoWukWbzlwjRjfx/dHX/D8a5PwX4ljstDNhJk+SMR4HX2rlfFuvR3F/Fb3jSPDIwe4WJsEoDwoPavNcJVqjT2On4I3Oe1TVNQ8VarJMFkluZTiGJOdi+grrPBdn4n8NNNNJYXBgdOYty4J7cHp3rU8CaTZ6baSai4WOSUkjceY07Ctu7vbvVt0VkTFaDhpm4LfSt6uIt7kFoiYUPtSepy2qajqF/fo8ujlG64Ybh79q5TUbl729ZiX2bsADOK3NesZFlkaGV8RDruPzetKNKNxpm+FdxQBsD0qYygkpWN+WTfLc5xopyxiWV1GeAGOK1vENvJaeGNPhkdXJbllOc9+v41nFH83K/eB6Vf8AE7vJo2lhtoBDN15yMCuui3zHBjEvZ3OUJw+5QAfapoy7Y9famIu5wMHPtV21dLedGlj34OQucV3nkF2KaM28UBxGwJLO/OfQfpXrXwnsog81wqcLjLEdT2A/X8q8aRHlnwgyzthVA9a+hvANj/Z+k2tuUVJCPMkAPU4xSlZJIIXbbO6AqO6jaW0mjQ4d0ZQfQkVIDxQTTKPnnXNc1gX0ujXJl0rTYpRDcyRKXwRk5JGMg11PgEanDLeSaDqa3+lQyBDHcKymQkZJXP3TXpsumWT+dutYW89t0u5Ad5xjn16VVttMsNJjlNjaxW4flhGuATU8ttiua5z+uMJb211Jbh7eScfZUjdeA/zHn8z+VVfEllps/wAMJXkMc5gt1EcuMHeMD+fatfXtFbW/C72sUhiukk8+CQfwyA5H+H415Tf+K5JfCkvh++ieG+S7ZpTt+VuSf59qbuJWMmGwtZRbyuVChAzLg/N3rZtLFb1rqaQC3t1Plo4GM44/GsfTLW2aa23zSsjkYVFH3ga2ZbiVNRKoyBEORGR39frXJO97JjTRfh0iCztWnguRLJkJgKVznjHP50+3s4rC3nknCAPHgK38fvVSSaWZreYsH2nn69yafcar5zG3DOiFjgL/ABD1z6VhaXVjVjR0FLIa1aC2hjVt4+YLz06Va18x/aLoL0WbB7DOM9fqai8PRL/alm6gKqyAHjluK0ZlEv2mbAZJpWfGOME/4V6eGd6ZcThblWiG6QBF7FuKx5rj7VN5NriRgM/LU/ix4LaVre2uonRgSYd3MZ+o/kareFdW062tpLeQj7TyxbAG72yTVW1NXsaVjItrZi3RCHZsux9az9QPmQyJGpZm9O341tzzGe48tII45GX5XmIPTngDrXFanqmp22ohJSgMbFWCJgHjrQ5roJRfUieH5Nw5I7V1/wANNPkl1drtlxGgwMjrXLeaHAdFJ3Dknpmu68IapBp7sjNkvgjA49KzqN8ptSiuY6HXNHi1J23qFZSdj46e1eZ+IvDs1jcGZCrRsfur/Ca9Rk1IzSeSsRZSclvSp4bS2u/3k1ujgH5dwyKxjJxZ0zhGSPItBtJhdbzDKEwQGVTyfrXVRwS/Zh5vUdvT61198yICwRVVRwAMAVgzOJreRv4jyBVTq3VjONJRdzmt2ElcniPIJq1oN+ktlwy+cG4GODg8Vi39y0Nrco3DOQfbmqGj6ikFlcxM2zepO8dUPYirUOaNiOflkQ+Lr5Z9ekMcYQ7FEijoW9ai8JQQ3niC1tZ1ciVwgK9VPY1lXFw87vLI29pDye9XvDWorputW14wDLHIpI74FaQVmjnm7ts90uIt8JiBIAd+Se2TXMa1pksM8RgDjzRyoB4+prrdLkj1OxW8QErKS657AnNaqBkZEK/MOSKU4c0m2eTKVps5DTNJlEal8lz2AOK2o9Hd8byEX1NbNzcRW8Jd2wB2rn7nUprjKx/uo/U9f/rVrGi5KyMZ1VHcu3N9b6ZaiGDBbOOvU+9YF1eyYZS3JHBQ9z3/AC/nU9vpsd9L0zGv3pM/oKsCws/tDKqlI1XJKtya0dJLTsQql9SnaWs1rbNNM5DynaAOoB6n8qw9Sukg1AqSu0/d9zW9dXSrEojk3KeMnsPesfU4LG+kMJG7EfWvKqQd22epSkrJIjgK3MJO1HUHALc81t6lqFzpWho9gVCyDBAXLL64rlY7HU9LtytrGJ7Vssp2gsmetFvrl3HKIWiMluSAY3HUnuPSppS5ZPqdE43SK1paxXtwpudQa2VzyT1B9xSeMXu7GzS1mVJ0UqY7kLtJHpWykdjqMha3cxXHdT1/LvWdrdtf3VhJZz/NHGMqSM4/rihSTlqwkrLRHOaVqTI0d1b5SSJwGU8gH/A16Jaax/aVt5jIY5RwyHsfavJ7S5ksXaIojxuMNzziugs9VMUuYI/9YB83Uk98V00puD8jir01P1O4a5Y5Gas3UhnXw+/dNVs0b1/4+I8f1rm7bUxIB5hH+8O9aENx5t9pKhuP7Vsjj/t4jrqclJaHLRjKNVXPoaiiisj1goorD12TX4PMuNNudIt7OGAySNfRyMSwyTyrKEXAHzfN344oA3KK4xPFWq6vF4et9Itra1vtVsDqEpvVaRLeIBONqlSxLSKByOAT7VHH4x1O9stOsrW2tItcur+4sJfN3PBC0G4ySAAhmBCjAyPvjJ4oA7euM+KvPgC6x/z92f8A6UxVreGtYu9SGo2epRwJqGm3RtpzBkRyZRXR1BJIBVxwScEHk1zHxN8Q6JP4cuNHTWLBtS+22am0W4Qygi5jJGzOeBk9KT2Gtzya/RjDIy9cf1rLmEdtYT3UqBvLACZ/vGuhuYeWX1GDXNeKZlXT7S0jXbvYu/uRwP615coNySPXpztFsx7eWS+vTOwVST91RgAfSuiigX5eQDnPFY+nW5SFWA5PNakeVBUnr0qastbI0pwstS488c0fk3Y3KBgSDqPf3q3rNp9n0KZbIoyun3g5HHfiseSQ+X0POVqCK0uLxlW5vJSrceWvGcVmord9BybvZHLaiqIgVcmTODkdMU2yl8qMsoG48Cui1nSbeO1Pl/Lt5J6k1jW9ifN6OI1XO5lxz2rujUjKBxzpyjUOj8Pmea7jVFBjVfmyePqarX1g8HiaAXTIVc+aGU5GO38qu6a/9nae08xAeX04+XPQfWs03T6hrYlYgFuijqvsKwi25trY6JK0UnudrZSSagV82QpbKfuj+X1rTu9XwotbVVVVGCB/D9feuYa5ESLBC+GAwW/u/SnxTLEu2Pn1Y9zXJNX0N4vUl1S6AtZe+FzmsyfVbzQrW2ms7yGWOVcPbOPmX0I9vpSajcb18tR2wfesGeZ4YmtLqMSoo/dueq/SuilT0SZlVna9jShvBfyNPHFsY9V9DXT+IdLSf4fWV4UWK5t5sbTwSrAf/WNY3hyUSQRltrskyYdzkqmPb+tei+JNBfxFBKkc2x1fIU8KSUWuqjFKTZw4uV4JM8R5j+ZWxiprc7m3tV/VfDuoaRM0d3bsuDw2Mg/Q1L4c0C81+/W1gjZY8jzJCOEHrXZdNHlWZoeD1sDrglv7hYli+ZFYcM319q9Y0vxLYx+I7KztblJVfcj7TkDIyOfrVjSfBuj6baJClqk7j5mklUEmruo+H7S7sQLeCOC4i+eCSNQCrDp+FRZc3MWtFY7BWzTiaxdA1T+0tODuNk8ZMc0Z6q46itYtxWpIMR1J4rC1zWrWytiPNVpWYAIDzjPJqh4u8SxaZB9ljfNxIOFU8gevtXAwtufeSSxOTmiwnKx6rpV5He2YkiOUyQDXlPxZ0OOz1KHVoRhLj5Jh2Ddm/ED9K7jQbprDw/LMfn2MWA9q4T4g+IX1S2W1jAMcjAtjnGOn65oasCdzm9NhMiRRO/B+ZGU1v2+mXKAiONSCeO5xXL6PcPHKVdMKOA5GAK66LWBHCiwDzZScFfQdzXHV572RorWMpt4mYGHZtHzAZ5q9vijt1la3Xco6jkdelWJogbhAuRv+8McL3INQ+W0kJjjRWUk4ycc9v1rJtSKtYry6rLY3UuqorgQxkhWOFyBjgVwV14v1m+RLI37pAPlIVtuR7mu48T2skHhi8eXAcxkYHPcd68iDkOflHIrrw79yxrB6GtcyqkfkpICyyFjtGR/31nms/eyzgsMkHOPU06GORgH2kgnGPWn3ULREB9oOM4Vg38q2uUdV4c1ae62WEc8UJUAr53zHcP7v+FS6vZXP9oiK6WORSp2zIhG7Hbr1riopJIJBIrFHU5DDgj6V6jpQHii0tbe2IEwhaRsH7jKMAH6mhLXQafc4yyRxK8IXIXOR/I11fha2jmulExxsUfzNc5crJBqHm7NkisUkQ9/UfUVv6A9xJfO8QXOOM8DFTJOzNKbXMj0+OK3aJVAQr7d6k3xxIFHQDoKwbT7dkb1hwOuHPNWZi6ggDGffNcx1lbVpjPtiiHLnH4ViXjSW6nYeQOnrW6iRw5YjLetYd643sW/CnHciZw2pzxu21z1z+fesP5ULqWBU8H3rQ16Jl1IhRhduRj3rKwp3FmKgDgY6mulaI45asZPGscm2Jw4zwQaS3iDMCAfQ05GhCOJUY5HyFTjB9/atzwv4ZuPET3S2syRywoGUOfvHPT/69UtWSz3bwTbpb+C7GSUZbZhVPUmtJUYuzkjcxyaqaLE0OmRwE58slPbg9qvM6xjLGtEePV+NmZqsLMFbICfxHvVePSoigeTPP8P+NaBHnyB5Puj7q0E7ycdK1UmlZHO4pu7KFwwhi8uMBQOgArNeO4aOQpIgZgR908Vo3AAPNVW3N0GPSplNJWBQbdzj7oXEMr71IbPI7YrHkv5La4yX+UHLLmu21KIblVxyR6VhS+Emv7gP5ojhkALBuDn0FcOIqRUOaWx30INysiz4X8QrJeyadcgKzHMZPQmtbVNKjN3HPHEAC4LMOxBzzTJfAdilin2WZ1uYxnzMnr6GmWQ1a0hPmr9sgU7XCk71rznOEneOh6UYSirMzZ9MjM5YLyGzkcHiqWp3N7DYSosmSRjLDJA6da7H/iVXg/0e7Cyd0lGCD+NVbvww2oINjtgn5iV+THsaI819Ru1jxme2kKtLwpQdPWnQTS2zo4GQegzivSvEGhxWdtG9tCsjRZ3N2xXn8tsBkrnLc9e9dKnc5ZKxpW53RiRDtX7rLnkfUV0OjBzeaS+4FDqll9c/aI65LTpx56o+Tng5613dlGsU+jqFAzqtkcjv/pEddFK7MbWmj6JooorU6grkfFukeIdZ1G0htYdNudDjXzLi0ubuSBriUHgPtifMY4O3jJ68DB66igDl9R0nW5NR0vXbGPTk1S2t5ba4tZZ38l45CjELIE3Aq0akHZzk9KoR+DtTsrLTr21ubSXXLa/uL+XzdyQTGfcJIwQCygBhg4P3Bkc129FAGF4a0e700ajealJA+oaldG5nEGTHHhFREUkAkBUHJAySeBWX8T1H/CDzHAz9tsucf9PUVdjXHfFH/kRJ8f8AP5Zf+lMVDBHmF3GrOwJA+lcV4ltt1/b9lII/Wu2kQliTyazNS0d7/ZJGBvjBOD3rlnH3dDspVPfSZiRxiO146kdPaqLzMD6Vp/ZZFJWTKkcYPWs66j2EjHQ964IrXU9KT00F0+TKyq7fMehrXhZXKOoHzL+tYoihMPnQErIOSM8VfsbtBGFcYwc4HUUqkb7E05W0YawIgm2UnB649KyfOFwFhj+VCckn09as6vMJwXRs7QPlPXFc5cXJXcillLfewa1pU3y2JqVeVl7UtQF5MIYuIIRjPrimafuDvOD+8PAPt3rNOfKyBhT6961LQIsaKGHTnmt3FQjZHMpOc7s1YwF2vIXKk9h1q4ZeNyxsRjgAcCoVuVSBcEEg9K1GmEsYIwK45vyOyCMyNWZmd16Akg1Uu7Xz54ldQQq5YfUVuQabc6o7W1iikoN7sxwMehPvVKLfLeS9uTuPYAcVorpcxLs3yj/CGnD+0jgkRIS7KfyFe02Vs87TurADzBwR/srXi9pNJb6hHs3NuOGK+le5aBiS1lYdDJ/7KtddB8yZwYxWSQr2BmhMVxAkkTdeAc/gaS1tLbTo/JsLHyx6BMD8TWyFp+0eldCPPM6OKUEMzYbvgVbhUk4br7d6m2j0pyqAelNAZMsR03WUu4l/c3OI5wB/F/C39PxHpUPi7xTB4a0nzmIa4lOyCP8AvN6/QVsX6SGxmMMQllCEpGTjc3bntXzj4p1i/wBW19v7QuPMkth5YVRhUP8AEB+PH4Vd7IhmmdQm1K7e5uZC8ztljWvbOSVAPJ61y+nTbWAxye9dPZkZWpuQdbHeLB4ZvN5wuxhn6ivPrRFY/vvmSQ/J3xXReIJZbfw5GIxxcTiM59MZrntISWa5+zOvyqSwb+79azqT0NIokm8N3ZlZw6eURlFJIAz07Vq6dpYtUUu24LyFUcE/1q614kSRwSSb5DwFAyRTTPPZakxlRZgfkIY/KoB6Y7nvXG5zktDTlSYXso0/S3ZipnuGwB6D2+n8zURsImgshDcM0i7HcdjuycY/AVNq+m6fLPLqrX6T262rEQCUK6TdAAvp3/OtOKzs9KsY5yrSPMQELPnt/QCpjeKT6lWuYHiqA3elXVspA3pj9a8ovtFNjKiTyqrNzgDOBXtd/DFIxY/cbrk9B1ryy8gl8QeJjFarvDHYoxwAO5ruw69wuOxgNarEFZnfY3G4AHn6Zqm23PBIPqe9e023gfQodOkW4i+0TCM5cuRg47AV4zdwLHK20Ntz8ueOO1bO3QtppakR5HOSPWvX/h1bwaH4MvtZeZd8xIyOSgUcD65/pXkigg7AQwYA8V0nhH7VqGopo8VwY4Lpx5qYypK5OcfhVQdmRJXRNeaffmyj1KXcyXM7AOx6v1z/AD/Kux8KwwYX7TjywuMHjmug8T6LG3g17GFBm3QMmPVf8muJ0rU/LtUjcfKcc46UprTQulLVXO006J45pI5OfQ+1XJ8KeD2rJtNRUBD5gbAwKqX2upHJtJ5IzXJytuyO3mRdubiOFC8hAUVyl7e/2jd7YjsiB5cnrVK+1KfULjyhkqzAIo7mta78Na1ptzAsukXBQKHHybwW9TjsPStYw5dTGc76EFzo9lcwvGsvmuMZkB5HHb2zXAX9s9neSQueQevrXsUtoZII7e7j82SNNzuvysmegB61z1x4P/t2Q2sLol2HYK0pxn5QQM/nWvQwZ5m/3QDwa9I+EcsIvL6NyBOUGz1K55/pXD6toeo6Nctb6jaSQSg8bxww9Qe4rZ8FzC11e0aKTFx56jHYx4O6qhpIh7HulrP5Vs4AyfNf/wBCNAy5LueaihDeVIQucSv1PuajllbG3PWtUjxqz99k/m732L07mpsYXFU7NTy5PJOBVyrasYJ3Kc0W4k4wfWqrRMJVY8D61amlJbAwPrVKaTH3mziuWpI6IIimjE0gTO45yc1JHGYboS/eZehb+lV/PVCccknk0faC0eM8nmvNxU7e6enhad/eL7XsiHI46gj1FZcN1Mt2Gt2+bOM9mH901JNIRb8ggjrVJNsU6/OQzNXFT0dzvlsdZBa2moRR3EtpFIGAIfHI+taJVFj2KoCAYArD8PzmCIwSHoTgegNbMp7jpXbFJnFJtOxjahZ+eGTaWVhivKdV0mTT76aGWNihyV9q9mfjOax9X0yDUIhvjBkUfK/cGqirGcnc8gisRBNucsD1APJrs7IEXWkZJOdVsjn/ALeI6w7m0aPVjG0TKfQiusNv5P8AYZ451Wx6D/p4jrqpK1zG95o96ooorU6gooooAKKKKACuO+KH/Iiz/wDX5Zf+lUVdjXG/FMkeArkjqLuzx/4ExUnohpXdjz8xgmnxxfNxXMaprl/aXcUVusbhxzlc81u6bJfPbB7t0R25CoOg965fbQPR/s+t2Ll1pkN2mSMSgcP3rgdThktrua3mQhgc/Ueor0OElpFEkz7e+3Gf5VfuvC1hqSI1w0sgHKnIBH4gVm4wqax3LUK1HSex4+kRyNsbD0NWVsWZN8eQ68kYr1EeCNLXGPO4/wBuph4P08KQGlAIxwwH9Kh0ZdyvaLseTah4Z1C4jFxbIJARlgp+Yfh9K5iXSdQSZg9nNuB6FDXu93oM9mrzWUoZsfdfjOK4LVfEFzBMUnhgLjj7vI59RUxlWg+V2a+f+Rfso1VzL9DH0Lw1JIv2m8tjkcIjg4+tWZPDFwZSV2KPYVeTW9RkRQq25yOAuT/Wuj8PwQ6xaStd7kmifawVsKfSoUMROTaa/EclTpxV4v8AA42fw7c2yiUyIyryVHWpbO3udRnS1tkLyufoFHvXoy6PYYEfnPj03D/CtSw8OWcDGaCWRZG6sNpP54rWGHqN/vGjGVeCXuJnM3lqvhvw4bGzzLqN3+7Urwzuep+gGa8+sp5Q7QeSQwOGJr2m48LWl1cm5mnuGl8oxBtwGFPXHHH161VtvBGlWXEAlH+8Q38xW1SlzKyMKVSUXdnAaPp11c6ivkws2DyQOMe5r2PQIjFbTxnqs2P/AB1ay00hIZN8c8qsPRU/+JqOGe9hmuUjvJFHm8/KnJwParpRVOOrM8S3UOwC07Fcp9t1H/n/AJf++E/+Jo+3aiP+X+X/AL4T/wCJrT2kTk9lI6wLT1WuP/tHUh/y/wAn/fCf/E1HPrV9bRNLLqbIijJZkQAf+O0e0iHspHcha8T+Ivw8udPubrW9MQy2bsZZowMtGSck+4zVnUPipLbsUs7ye5cdxGgX89tdDonim/1vTlmN5NFIRh4mjTj/AMd5FHtYsHQkeK2dyFZSxI5zXb+Hbe71iYR2dtJJzy2MKB6k9BXVN4f09rprk28JlY7ifIj6/TbitqG4vYYhHFePGg6KkUYA/wDHaOdC9ix9/wCFLS50CKwuSzNG/mCRTjDe3tXON4SjjL+VeSxljyVAromuL9hhr+Uj/cT/AOJrOvZ3t4zJJeS/98rk/kKmTixqnI5mfwPMcmLUWJPZsjP1xVk+E9ZvriaOOe2EW/eHZjkZ6jGK0o5ryT52mkRD91CFLH68VMuoSadG8s+pGFT1yE/qKScR+ykUdQ8Gabp2jWlrdztLcm580zeWQNpwGXIB+oGakuJvCthJaRNLdSwgEssm87eOn51j6p8UEtspa3M9ww/iKoF/9BrHX4i+ILtCd1t5THG1oVY4/KpnVgtWb0sPUm7ROu1a/wBD13RUsdJmjt3Z8yIU/eEe2a5PUmtPCtqLezQLPKp+c/ePvWrpmpXWqX1paTLAoJ4aOJVI49cUup6Fa395uvVaSSPKA7iOPwrSlNV6L5DSvRng6yjWXmc5pl7qUdhdXnmKYo42LB84riNY0i4sjbz3GFjuoxJGdwOV9cdvpXrE+mWf9gywSl/I6+WHwG5zz3rBh8P6TdOC1nlV4GHbn261dOhKnHV3Mp4lVHqjzGL5G80bSEb7p6n8K9M+Fvg+a8mOvXRkhiUEW+xsFm6E/TtWtB4J0FjHHHZl7knJG8lUHvmu7sbC5ggSFLoxRqMKkcaAD9KFUjF6ia00INShuI4mUKJgVPAOCfwryXbCl9Nb7WhUOQFYcrjtXtv9nSOQXvZicY6J/wDE1nXvgLSb+4N3O07TkAFgwXOPoKPrEGJJo82gaJSfMIVIwST6gc1zc95Nq14kFnAWlJwoQZLfhXf634TNlcmKMoYCML5m7P0yDVzwroZ8PRXN9cLDYhRjzFUM20e7ZIpe1i3dF62Ivh74Du31mG/1azkgitzvCSjG9+34DrXs9wjSQsInCS4+ViMgH3HpXh938UNcN04024CWinAkuI0JP5AVd07x74gvJFJ1a0lGfmiRERyPbPf8KtyuZt3ZPqOmXlzql09zNsmLYOFGN2cY/WjTfDmupNPfLbRXsEgKbUcBiRx3x6Vf1GOTXNOluIbtpZGwHVlVSGU5wdoBByKwrTxhrOiMLG4leGEE4Plg4J7kkHNCkug3I37PyNekbw14o0uRJCpe1efG5gOoDD+IfqK5UfCa+0HxhZXVoxutM88MW6PGBzyP6itLUNZk1eSBrq63vC4khdVVWU+oIANaQ8U6xji+/wDIaf4VSmhXNMAr56ekz/8AoRpDb5XJFcpPr+oR3EmJgSWLE7ByTyaZ/wAJFqbdZl/74FV7eKOOeX1ZtyVtTsEQKAKmxxXE/wBv6gAWMy8f7IqG08Y3MsYeSTO4kgLtBA7dRTeJgSsrrXtodTewSBjIg+tY81ySQDjOeRSxeI4plw086n3VP8KqXV7FcZKNvf14H8hXNOtCfwnRDLa8d7DbiVVCnPU4PNILlQxP+RVL97KgREwUyxyC3Hc8UisjAgr168muStS9o7pnZSoTpqzNJ7sPaOc8k/nSM6RxFyQZQBx/d/8Ar1SUIoAA4+tQ3bLa2F1cJGWdVL43dSPWsvqzXU05ZG/Z3e3Y+eQMGuoguBLGpByrDINeU6Jr6agoinAjm7KmcH6V2FhP5KBPtbRIMnBAOf8ACt407bswlh5y1R00gqAxlzheT2rm7TUtTuLqdGuUMSE7SqDJGTj9BTP7Z1FGdPOHBI+4KtRIeFqF7U9PRrkS+WA2ME+hqteoY/7EQ9Rq9iP/ACYSqp1C7YcyAj/dFRSXs0+oaRHI+QNVsj0H/PxHXTGUdjBYOrF87tY9+oooqjQKKK5zxVqt7o8SXUes6HplrgjdqiMfMfk7VIkXHA9GPtQB0dFcNaeKPEevvBb6TY2VjdR6bDfXiagrtteXdsiAUqR9xiWOcZHy9afb+L9R8QLosGgw2lvc31g1/O96rSJAoKpsCqVLMXJGcgAKTz0oA7auN+KSh/AdwpGQbyzBH/bzFW14Y1mTXdES7uIVguo5Zbe4iRsqssTtG+D6ZUkexFcr8SvEWiS+H5tIj1ewfUhfWam0W4Qy5FzESNmc8AE9KT2Kh8SPLNXs/L1exMa7U3YwOK6iGP5RzVTXLFpraO4QEvAwfA7jvVywkSe3R0OQRXky3Prr3hcc8JI44NXNK1N7WcQXBJRuAT2p8YFOezhnHPB9RTho7o56jTVpHRAcUvSsmxnns8Qzv5sPRX7r7Gsvxj4sj0K1EcBD3coyg7AeprrvdHmyhZ2Dxh4lj0izaCAh7x14HZB6mvFNQmLEyuWbcTuY9zVm/wBYkeVpp5DLNIcuxrPupjLEEIxubeF9B2rNXbuzWTjGPKnqNTVZkICHaozgVal1jU2XLXMkcbdFVsZqzoXhybUEe7lxFbJ1d+AazdRkiW4dImMuG4bt+VNOLlaJnLn5LzegG+m6mVyT0+Yg1u6P4s1LSIHmj1B8Lj9xLkhvoe1cqFc5Ynn6UrLvXLY2jrg1oYJ+R7Z4Z+KNjqhSDUALaVujk/L9DXfo6yKGQhlIyCO9fKttaTT3MUdvG0rOcKsYyT/9evV/h14teC9TQr2QtE5K27v1Vv7pq7kHqbCsdf8Aj6uv+uv/ALKK22HFYZdEubsuyqBL1J/2RUy2JkSU01m3niTSLIkS3sZYfwp8x/SsK6+IWmxA+TBPL74CisXJE8rOrkkWNGdyAoGST2rh9XgvfFNwYldrewQ8f7fvikbx3Z3qCKW2mjVjzjDZrZtb61liVkbYD0DjFTzIqzRmWfhbTrBRlPNYd3rRSX7Lf28qHbhtre6nqKkurhI4WfcuB71gNrmnCbM9ynHRcE/Xmk2wSuegwTJOgdCCCM1YArj9N8U6BbZijvkVXOcNng/Uiuptr22u4le3njlUjgqwNap3RDRLI+xc96yL10hzcXLrx90E8LVjVNRi022eeQ5IGQteReIvEd3fzOrMwB6Adh7UXBI6TWvHsFmGish503Teeg/CvP8AUtbv9SmL3M7Nn+HPA/CqTbmbd+pNMWOR2yD8vrTuFiRGHBY5rc06MmRHVy7LyFUYx9TWfbWILjK5GfvdjXQQl5NtvBAFB+84OMCuSvLSyPTwEPe5m9jovCc5bxFZtIQBvwBnqeldlrsItr7zzxG4zn3HWvO/D0Rk8W2MENyskqtkKPuryD19a9j1LT4NStHtrhdyMOo6j3FduBXJTOXOK3tsRfsrHlt7qi3cIjiyEBx9aksHeOIvGu5mO2JB6+tY89udP1K5s5GAMLld3bHrWhD4s0PSNj7nuZUXAVRhQa9DESUY2R5FBNu76HeaPY/YbYKx3zN80j46mtmMnGXYKK8Y1T4r6jP+6023jtwTgMw3NWBqviPXbiC2W71CdvO+chXwuM4AwK89wb3OvmR9I20kcwzE6uB1KnNW1OBzXL+CbVdM8OW1qzBpSPMkOf4jzXT7uKi1guUr4gKWCru9TXnni272x+TO7OWH3Q2AB9PWu71OYIhrznWrWe+knuwpMaDbECPvH1px3Ktpc5iS4s4oljERzjjkcCkthZ3KyJJtgl25jkdjjI+g9Kz1trhr3yXjczluFx1rqLPwPrFzIsskQiTH8Z56elb3S3MtX0Kuj67faDd+Zlbi3f8A1gD53D19jXcC60rxBal4vLkyPmjcYZa5ifwZqduh27ZBjnpnH51lNY3emTB1EsRH8WCvNCcW9GFmtzfn0ZLckQ52Z+43IH0qDyZUOAWH45qCPxBdBQsyiQf3hwasRarDKecA+laqLJuiOWPJBOd2OagZivarMsgLMw6HpVRmGST0rml8TPTp/AivqV0YNOkZBmRhtRfUmqumwRR2kMcjCG827jFJwWHY1XuLkT3ZnxuhtwSM9DVzTrOC/thql/DmXcSnznoOg+lZz2saQve5bYKwYhSjr1AGakgTeNwPzDkbT1+tVPtj2txveRQOqHHI9vcVvWl7Yarkl1tr0Dh0+5J9RWNjouhkPyOjr26/1FMeFTI2BgZqyY8SsVX5S5xx2puzfJJt6DpVRkKcLorNsU8j9aoaz82j3Kx7h8vJzzjPNW5yVcDafwqORlaBwWwmMMfb0q02mYNaGPpGn2djdW9z/pLO4LRrgEEEdfUfSugurgtbP5cchfGANprCuHNtqkSMxVE7A9AR0reNyiQjGDnpWm5EdC1b3CadY7gpkmkOcHjAHFV45C4LMPnPXFRAPN80hyBwuOMCpFAUetAweTauTVa3l8zWdKH/AFE7L/0pjp0xB69KhsmU61pQA/5idl/6Ux04fEiK3wM+kqKKK6TzQrF1tNdlk8rTrHSLq1ePDC+mdCrc5+VUYMMY4yO9bVFAHBaZ4Q17wusD6HdWF1M+nx2dz9tLxqGjZykibQ3A8xl2HHAXkVPb+ENR8Pros+gy2lxc2Ng1hOl6zRpOpKvvDKrFWDgnGCCGI46121FAGP4Y0aTQtES0uJlnupJZbm4lRcK0srtI+B6ZYgewFY/xNVf+EKlOBn7bZc4/6eoq7CuQ+Jv/ACJMv/X7Zf8ApVFSexUPiRyWFKYI4NV9P01LMyAFijNkA9qtpwtSg+leXNpH08W0rDkhQHpVuOBOuBVdGB471bVgqZPbrSpu7MKt7FDWtQt9G0ua9nICRrwP7x7AV4ZqmrT6pdS3M8xLynO3HC+gHtXTePfEQ1y9FnauTZ25OGHSR+5/DpXHLASANuW7E10vTQ5NXqVpomhb98CH6gHtWnoOmNfLPcStiGIDd8u4kk8ACqknyg+aVI64Jzk1s6Bqkmn6bfNa2zO7hYw/8MZYkfn2H40puTjaO4qfKp3lsXwl9rEv2OElsttVMbY0HqR3NTX/AICj02MPd6jGhIyQq12b6Z/wjWi2DpGJLpv3krY+85wMfTmuR1aSe8mlnuXMsgPPpn0Fc7lJO0XY7FCMtWrnK3lpawsEgLyDoGbv+FWdO8JX+rSIkSAGThQep/Cu48N/D3UdYRLo24SJuQ8vyj8PWvV/D/hC20MLIziacdCBgL9K6acZy22OOrKlC99+x5onwnvvDmk22s6fOZdYtT5sltjKMAc4X3x+dc9qmk3XiW5l8TeHbdN8MivcW0ZxLE4AJbb35z09K+jGGRXls+nzeFfiXFdJIBZasxVuMAE/w/nj866XGxwxnd6nTaXetq+h2t9AF8ySMM8ZPIPcexryPxZawprt5DcXaJIMuRI7DhiSMY69a9gktY7a+a6tYxHLndIFGBIvfI9fevJPiIPM8T3kywEr8h8z0+XgVjUdo3Zo09kcfc26iQtG4ZPUMR/Oo5JIvJjWMSPIud4wMfnUctzIyFRIMgE89T7U2zvJIt4X5RjkHBrn1auNdh4nC9VIHoe1dTYa4726xXAwAAA/+IrlRqD3BAmETEcA7AD+nWmC8ZpNpyoz1pWZWh2F0vmR/MSFPRkOVNY0lph8qQ3tVmwldI12NuQjlT0/CrbRK2SsZ59Kl+Q0mc9fWwCRlE29c8VZ0rU5rKPCysMH5RnuauzqsivG+dxXjI61n29oZGbrhV59uauMtAcdTZ1vW5bqySDe0gH3pH6sR/SuVmLyszcZ9BU907iRkyWK8Yb0quSZGBK547CnqS0loRpCSfU9hWxYae0vzzAqq9gOaqQKuNzD5zwMVtWVpdXvl2tqjGVz0Wh3YipPDKjgryAcBRya6HTPBGq6nibUY5YoCMrGrhC31z0/Ku38NeEYNHjWe5VZbw9+oT6e/vXS4xVwppasiVV7I5DSvCFvo+s2F3brHEEbaygszMT7nt+Fd83Ssmb/AF1t/wBdlrUY11QWhzSep4D8RWe28ZX8Qc+W+18fVRXFsQSea6n4jTtL401AseFcKBnsABXIF/1qpO7uTHREu7AAVsHBzmuqsNG/tRNPsiR+7HmSP/dU8muZsLQXcjJ827qD2A969C0QSafY+S0LIcDB6mQnvn0HpWUmaxR6FpFwkGxIySoGOtdXFLuQHNeaWd8I5Bg/N3ArrtP1i3SEieVVwM5JrGzKsGsxy3VzHBGeP4vYH/P606W1jt7QIqjAGFHqaYdZ08SGRpiSechCf6UxNTS6m8xIpNigiPchGffmkX0GaVoUVlM99JHG92/8RHCj0FXTeOx2q29h18tcAfiaYZpboLHtMadxnn8ashEhj2gACpeoXKUskygllGPr0rmtWmaQtGVR0PHXNbep6la26MrzorY6FgK4++eC4BlhkKknOUaqincL6GQs9g2om3eR44923cRW9N4SMsHm2d0koxkAjGfxrjr6Mvctk7jn7wrR0LVrzS51KzM0OfmjJ4xXam0ro5Ha9maE5+yRiOTKlAFIPXNYV3eNLlASFP8AdNaviC5W4u5JFYbX+b8657cu7gVzTerPUp/Ah6qzjyYztEhCspHLCtudvItAiYVF5x2rMsEaS6ErJiNAdp9T0qTWrjydOkOOTwKxauzoi7K5i3V0ZGMruxBztQHt6060uQw4YjHbuKxUmO85HHpWhb4ONgJP0rS1jHmbdzstH14xsLa8fKE4WQ9vY10qKFYsp4615g0pV9jHtxn+VdFpuuyRWyW7thgwALenpUSib06lnZnQXjRFm8sbsHr2PtVO7gkn05zCNhjG8KOjY5OamjvhIql4QoPTjrVO88UafpDrFLHvL5BUf3e+ayhO8rI6KtJKLlcw57r7RG1xJGVkB3DA+U+vNbWmOkkCuCrMe5PT8KwrrxPpT2E1tDazMAAId7cKe/8AT8qXQrljCJVYEfxL3FdNrHApJs60K3UsDRUEF5FMow3PpUrPwTTKKV67D5R+NQ6Xk67pZPA/tKy/9KYqllcFuamsUT+0tKdev9qWQ/8AJmOiHxIzrfAz6PooorqPNCiiigAooooAK5H4mf8AIlSf9f1l/wClUVddXIfEz/kSZP8Ar+sv/SqKlLYqHxI5ZcY4qYJkcGqyuRUyMSvpXjVHc+mQ4ZD0zV59mjTgQvNI6FViTOXJ7cVLtjjRpHbhRnFdDoekvHEb+9jCSEfuoz/yzX1PvVUIuctNjDEVFCN2fNV7dfbJQ/lrFGo2pEOAgqFWZx8g4FX9fKXvifUF0+2KQNcOUQHd361RkidGVIRtKjc79vpxXS7XMI3cbgNPaYhyDkdscYrrPh5HaXrCxmhjklF1vIbuAMDj8WrmINcjtwEurdmx/Eh4P8qm8I65DpfiyO7/ANXA7/MD2B//AF0481ncmbhdcr1Pc/EBRHt0Zc/MAv5Gp9D8JWOoXr3tzbK1vGAkano57n8OlYmra7aXVnb3bTwwYcgM8gKgdMkjNeh6HrWkahYp/Z9/azIgCkRSA4NZ0aCqVOd7BiK8qVLkjuzTVFjQIihVUYAA4AppoaeAHBmjB/3hUUl3axjL3ESj1LivS0PI1HNXHfEbTpL7wnPLbj/SbRhcRMOo2nnH4ZrqhfWb/cuoG+kgpJkSaJkYB0YEEdQQaTV1YqLadzy3RfiNFc6cbnUIS199zyYFPOO5J6ZrlPE9015b3d84WJ5dhMA5A9Oap+PfDzeGtVF5Y70jZyJAucKe35g/zqhr2ql2tfJkYrJErlc/LnGM/nmuCtCb0ex6MnTVNSjv/wAOYe2NIiQpyRyT3qsZBuGWAB9qmnMksfmOePc96psFAGMsffpUxXcwb7ADGGJzmpIYxJyXH0qGOB3YMRlfrxV7ZFGoIB3ei81UtNhx13LunXTW8hRxlevX+Vb0N/bMAQ2PrXOQRGVBJ8u3HPPTmtWziMbAnaR781jM2grmhOitFuTDHHGasw2IFtlVUHaN31rOWdWcLAV8zvg5H41vxQNHYhHKncQSSvJrNtpGiSucXrVq0MvmhenB9CKpW0bTR7kU4B54roPEdtIsPmoTsHVRxms3wzIk1zLZu3lmRTt7jOeldFPWJzVdJGlpOhzX06pDEXkY4A7D3J9K9Z8P6DBotmqAK1ww/eSY5J9B7UaDpsWn2SRRoA2MscdTWyBWsVY5pyuFNNOxQRxVkFWcfvbb/rstaRNZtycSW/8A12WtAtxW9PYiR87/ABMtls/Gt6kSbFfbIB6kqCT+ea45H3SYYV7R8WvDE2oW8etWgBa3TZOuOSueD+GTXiZVs7cGhrUSZ0vheKV52lR1SMHaxIzuB7V6jZ2scsYMkxZjjCjnHtivPfB0KuCu4KMg5Pb/AOvXpFgRyVDCMfxDqfpXPVaR0UloRS6ZJFnynYL3XH88VYtbC6kQMY9iDozdKff6xZW8flW6/aboghYc5SP3bHU1xupazqIkii+1u9yeMIfu57ccCpgnIqTSO+8lLVd13eiMDtnb+nWrVuUkG6HckZ6yODlvoOprnfDOk75ZLq/yxtwPvHgsRkk/QY/OqHijWdQuNZtNIsn+zQ3LBTMp+YjOD9B/Omld2Qmzq9Q8U6XoqCJpC87cCKP5pGPv2H41xes+L9Svgyb/ALDD/djO6Rh7t2/Cuo03w14YwYodl1KAQ7mTLE/nU2v6VpmnWFr5NnGro3Axn1PP44pqyeot9jzJrO9v13QWcrL3YqSWPua0bWxGm6ZLeXO8XEgKRr0C9jXXWF1Jcxu+0BUXauO1cdrlxJJcOpPyk9MYFb01zOxlN8iuZ6y5J3c5qyjIeFB/GqESlmxWhGu3FdLikc8W2UtdEyPEQAUkVVTD85x6VLa6BqG0POgiTuZG/pWzqehjV9FiEOBdLtKsTxjuKxTZazp1nJJcQPPawNtALHdj29q4al+Y9ejblTZpy/6LH87IEUdT8tc3eah/aDFRjyc/IM859aZe6ja3FpLEli4mcDDO+dnrVC23D5f5Vmo9TVz6IJLcjIAz9KWIvGM4YEVMWImAOQeuKs3DC2WJl6uCTnvTv0Fa+pBNkrkH6VqaFCbozLOpOyLcj+hBFUo9twqlcAd8DoakN41kkjo+0qNqle5qd9CuW2ptX+qx6OkcDsJJCCShHQe/pXnk08t5ePI7k7mJ5OcV0TWcmrzoiAi7lXcS33WHXOf6VhtbNBPLHj5l4PHfNXTjGLfciq5ySvsI0ZjzlckcGt7wuzfaHTOVYdKy7or1PUoAceoqSxmNtLHIhI2jmtL3iZpcszuLKPbcP7dK02PyAVT0RhcWTXLHJc4H4VewCMVmbmbfMVh+XqaTRJmfVtLRu2p2R/8AJmOnamvAx0qPRIyNZ0pyMA6lZD/yZipw+IyrfAz6fooorqPNCiisvXdWbS7SNbaIT6hdP5Nnbk48yQjOT6KoBZj2APfAoA1KK4LS/F2ua3p+gW1kmnR6rqNrNd3EssTtDDHG4ThA4Yks6gfNxzU0fjHU72y06ytba0i1y6v7iwl83c8ELQbjJIACGYEKMDI++MnigDt65H4l/wDIlyf9f1j/AOlUVaPhrWLvUhqNnqUcCahpt0bacwZEcmUV0dQSSAVccEnBB5Nc18SvEmht4fm0tdYsG1Fb+zBtFuEMoIuYiRszngAnpSlsyofEjI27Tx0prOEBYngVTfVbbOBKKytV1mJItolXHUnPavEcWz6a52Xg6E6vqU91MQbe3wI4yPvN6n6V1HibUrTStBu5ru5WAGJlUk8liOMDua8I0/4l32i/aU0uOMmQAeZKCduO4H+NZm/xF441LZLPJczkE/O2FQfyFdtJqnDlPOrUnVq819DGuLwwRuLViHlY7m7kVmGSeKBlEhw2M/8A1q1NL0qS41o2lxMtu2D8z8Ywf516M/wz04WSSJI874DE7sb/AGHpWdSrCk7S6msYSqK6djxtVkkYl8sMd+MVbh0+4TEiLltpcgDoMZrrPEnha3srE3dlcKYfNIktWGHi47569K0dIsre602LT5YSrTpt3IQJMHvn09quWIjGKl0Chg3OTi+iOPGvyyW8ltJBCIpECEAEY/2uvWu88A+N9E8IaJNDcxXEl1K+5tiAjGOBkmuF1vw3caQJpC6SRJJsJz8w9Mj3qi9tLb3SWzOkpKqQY23DkZxx9a1hKLXNDY5qinflqbm3d6o2sah5+SM9v8+9YmpySyXbASOQOMZ9KWdZ7UNFIrxk4OCMVUSRxMArZb3FCTb5hyaUeUYk0sbAh2GD619KfCbWrPVPCEVqjKL22ysynqwJJDfTtXzbdxhcEbv9rI71oeGfEuo+GNVjv7GTDrwVP3XXuCPStIO2phUV/dZ9K+LfDsWs6bdoVUu8DJ8w4z1VvwP868nk0mG0jS0YghINpdh0YjOM+xP6V6/4S8U2PjHRlvbfCyD5J4CeY29Pp6GvHPiuVsfEjQQ/ImM4B+naitG6uiITaXKzgbgbJpI84561HHCZOoOKvRWTSbDIWj3DPzLU8lnsYLDPn32jFc3MloaKDeo7TgkLAFihByCeh9q3RHBcWxAXcD8uV7VnWejXnmhpWV4yOPlFaMGnTW5JRhjPzc4rGo4vqbwT7GXqv7uRVtrYpsABwMZ9SajtmnZGV4lVcYA9a37qBrmRYwoCqPmx3qG5s5xHuSMKEGOfSkprRMbg9WjPs7J1kZoHVD12k/eretLm8eIPJh4lHIH8s1lRBS/zH5V6sK3bHS2d0CXTGOTsTwaJ9wgjJv8AVEnjmt8bo9vA9KxtNtJLS+iu0RV8sgYYd89a6690FLdtisFkUcNjhv8A69QQiGMXZugTIQACe5+lXCSStEicW9Wej+GtQXUtJSfPzHhvrWxXB+BLopPPak/KV3genNd5WyehxTWoo60pFNNLvAHNMgpXeRNb/wDXVT/OrrNxVO5zLLb4GP3owPzqdm4rppfCZzK17IvkOrgFSMEHvXhXjHw8lleNd2Sj7JI+GA/5Zt6fSvWPE2qCztvLU/vH6Vyiqt7pc9rNg+aMk5yR6cdq6PZXhcxU7SscJ4Y1CK0vPs8+Fjc/ePr7+1emzwvJYPLa3Lws4CkBuCP6cV5PqWnTabe7ZeQfusO4r03w7az3lnplhM6eTPCZHwfmQA8j8QcfnXFVhbU7aMr6FWx07UL+yxpFuqWqsd91MD+8PoO5rW0Xwl5V2J7hvOuRySVCqp+nrXbQwJawrFCNsMYxGg4Cj2qtECl9Km7g/Nx71j7R9DTk6sqy2qJcwafED5TsZp29cY+X8Tj8BWBqQt/D/iGw1y409ruORWhVBjiXdkH64zXaOI4VjJUZzgH3NZmu2lpe6HZ2VzL5TS3g8qQDO1sk1UGS1c4PxHaNc6g2taNBd2c4JkktpUKnPUshHB9xWnNr8Wt6dZzNJ+/8vbNGP4WyOfxrtL3QoJ9FNlOoYIvysoxg+oryXSLGRdb1K0WUtDb7sFup54rSMuZak2s9DodKvxDZyw8btxwCK5rWH33zKNvHpWrJMttbF+hC4z71hzvmTfnluTXVSjrc5qstLC28YxmpzxUMU7OdgA+WpS2K1a1M4vQ6Ozci0i/3RVxJTt2k8VSs+bKE/wCyKsVwz+Jns0vgXocX4t0i3tZluIXaLzjjYq5GfrmuaRijANye2K7rxhZvd6XGyAHy5ATn0PFcXFH5TBsKWTpUXL5dS5JF907GMiqDu7KfT3+lUblpGmTzTkdAB6VMsztcBHbHrzWi8UFxdp+74ROTmoTs9TRw5loRwpBFEIwxGRkjHf0rPvvmZUUfLnoKvSM00u2Fcc8epqrfRtaYR+ZTz9KFuNr3RLH7TaJJOhZk429yBzyPxqlPO1xPJMykOeG+tbujWjfZpBJKqtwdueV7j86oPplxGpu3wY5TuPPKnPSnFp3YpxaUUtijcITpkbLzmTk/hUljbPLLChyNxA/M1Ymt8W0KR8jk8D+lbehaLdGSO4u08tUbIB6tjpVp3WhnyWlqdbFBHb26xRKFVRgAU3HNOyelLg0xlC/XEYJHSjTJFbUtJUdRqdl/6Ux1NfoTFUWnR7dS0lu/9p2Q/wDJmOiHxIzrfAz6TooorpPNCsbWPDGn63eW95cyX0Vxbo0cclpey27BWILDMbDOdo/KtmigDzvQ/Aur+GLLR7nTLi2uNTs4p4LiK7upWhljkZWwjkMUwY1IAXHLeuaux+DtTsrLTr21ubSXXLa/uL+XzdyQTGfcJIwQCygBhg4P3Bkc129FAGF4a0e700ajealJA+oaldG5nEGTHHhFREUkAkBUHJAySeBWP8Vgq/D+7bAyLqzOcf8ATzFXa1xXxXOPh7dn/p6s+v8A18xUpbMqHxI8dnvYlHLrxXJ6vqxuX8qI4TPPvV7XL8sDErjHfb1rBs7R7y5SNRyzY5rzqcUlzM9yrUbfLEvaTpU+oTR21qheeVgFUDNe+aB4at/CPh+RwFNyygySN6n+lY3wr0Syga6vEPmSRKIwfTPJ/lXT+OUl/wCEbmdHKqHBbjqKrVxcjKUrVFS9DmxHY6zqsLyxQTLCjASgcls54I9Bj8625bSLyNsU0sLKv8JGD+leb+HLtR48eGGbzII4ygK8BjgDOPqK9Gd95IyPSvPqPksn2OuMebVHl3j63uLrVrCzjk3PN8hI6nJA5Peuw0/wPD4dRLi1uHmYR4dXwe3O2s7VLBW1n+1N+DabXUAZBA5rpZtbijjjM0u1XIUfjT9op0uQv2Uo1eZHIa34f/4SC9RFPkrtPmvjrjoCPWuYbw7P4Y1tJJJkKxIZInAxnt09q9CmWSy1MvbqXt9o83nJye4FUvE9oNT0pGAJmVv3W31x0PsamjUnSShL4WaVaUKj547nnE1pqGuXE19DZSywIcyS7cL789Ky5dN8yclfkxk8mumfxHfXFnDpzP5MMR2mJBt3Nnv9KqX6RxysVIDFc8dj3rv55RdjiVGM4uTZkhy8UkE4DhRgZ7Cq9xYWttGkkconcHLKv8I9DxTp5SDu27XbqSOtXUtisEWoIqmOUGN0/wBvH9RV7K5k0pOzRY8G+L7jwx4jS9iBNu+FnhHAZP8AEdq6Tx2LbU/Hcl3E+9Joo2ic/dAK5Brz2GEm5jYYAL7fpXSeMp5tH8RQWsTANDBF8+OTgdPpWsruNkcjcU1Jk66efNBmlVl9u4pLq0K3MQCHb1Zu30q9p9xZ6nCsqgh0+8m7IB+npV5LbcvPKk+lefzNOzOtJNXRNasEgCkdutIwVmyBUoUbSKaE9OtZmhLbxbeWXkcgU9od7DbjBPIanJnbg/nQ4PY1PUpaIpTwRhmS3UoEGSB/FWdDJfNKZUfbt7KM1rrIUmAdRycZIq/JBbqqqNqswyV9a057aGbjfUpWtxcswS+Us/sBjFJqmkNcLHLaJmQSAEDptP8AhSzZjmUNyVxg1s21wUkVUC/vcA7qcdJJkTWjRL4e0qW1vUkIwmzBbGOa6/pVG0U4ye1XM12I86TuP6imnA61E0mNxBxisq9uZZy0XKActjv7UOVhRjcty3sDX1rAjbnMoPy9Birl5iFmYnC43ZPasyzsxA1rIyAStKv1xV7W7iFICkvcYrqoX5dTKra+h5v4g1GK71BnQFlHyqT0rO0+QwzNOxBOCAP72etNvDGb5kDbYwxwByaazhiABhVGAPQV6DaUbHCl71w1eCHUYGXZgKvyZ6g1oeAWNpcyl5d5dAMHsQao78o0ZPDDj61U0S+aDVGj+6dx/GuOvG8dDsw8rS1PYPtIYgdjVGW6itb3zJHC8L1PbPNVbafdEjE8GsHxkHmtYZ4zjyjtfns3H8682KuzvasdzevHJAE3AMWUr+dQ61Nf2OkxtZmBZEkUEyJu4Pp6HpXFeGfEX9qW1vY3kgSbKhHJ++ARkfWuh8VXEhNlKJcQDzDt9SOB/OtbW3M1qQ3fi2eKwlS52C5VSBxjPpXC+H7gQ3WoTzsFklwec5bOa1DZy6hOUeXav3mLDO2smzkjiTUZjieHesa446HrWtKKIqysR6zcZkjVSDG67+Py/pWSzcZBzU17N505byyiqoAHpVXdmvThGyR5lSV5Nk8T/PkGrhfcM1QEZQ5HSrKvxjNTJDizrrAA6dB/uCphUOnc6fB/uCrJArz5/Ez3qX8OPoUdXl8nRrp/SM15wqs7qpOCwOK9K1C2W8spbdydrjBI61gweHLaJyTLKXH3MrwD7+tQzRbnM3dlJEEdj26/0qVJy0EjBcsV5P41q6yj2FuI54g6uTtZG6/WsaRnt7PhFAbqazV+po+X7JvaNbA2k1y2wyAfKGOAB3JrDuPNE813JtmIPy7Tx7VtaRqUNvpkiyModkIKn0NZmpeU0CS2W4vGMOQPlYdalX5nct/CrFbTtYtYLebzVEss33sj7nvW9pVmmqRyWjnIUMYz6Vwl3GizmSP5QeoHrXVeA7hm1mCFnPznGM9iCK3UEtUc3tW/dZsafp0dlfiOSRWIGEbHXP8AKugKYrkpJY7a9kjkBaSFyrI/seRXUWNwlzAHSJ0XH8QIpJWKvfclC81JtBAxTTTdxU1Qgni8xCKoWULxa3pQJOP7TsuP+3mKtENk9c0pQDUNIbHP9q2X/pRHRD4jOsvcZ9A0UUV0nmhRRRQAUUUUAFcL8YSV+GOpMoJImtSAO/8ApEdd1XH/ABPYJ4GmZhlRe2RI9vtUVJ7FR+JHzEjC6R2ZHG0/h+NbnhHTGvtYVQAyxruZQ2Mj61va1feH9RtpoGtJbe5cj5kTGWHTPaovDlpB4eu55bm9ihmGFUScfp09K8/mvF6HtKFpJ3PWPCV5CpurNLXyHiOG2pgMOxz3NXvGFzGvha+Dx+ZuTbt9cmsTwjq9ne3E7JcW7SkciJuG98Uvi+WK5kt7HcyggyOUPIHQfrTu1DQycFKtqeOaFrCweOVKRrFE58nA9un617E+BDuHJA3ADqa8J8R2EnhzxVcRhnbypBJE7dSDyCa9i8P65aaxpUNzBKrEqNy55RvQ1w46FrVFsdeFqXvB73M/xFOYtJnntcEOFYHHYkVrXTWut6Gl08aoXUE7SPlesfX0ZNNvNgDQqpYD6HdU/hnS5Lmyu7fzg9tNCsm4LtZH428fn+VPDxUab9TWvL30/IXTXktrOIXXBVBk5yfStCBIZUBUcLzgdDXmuveL5Tqf2FImijgfY+7qxB/Su28N6jHcx7VOVI3If5issTSlGHOy6VaM21HocNqVlBp3ie6ln6M+6NfrWNeXCSXgiHzb8c11XxGiL3NvIMdMfWuCjdvtkTjk5/PFdeG/eU1N9jCtL2cuVI09ZscRq8YYxoMEk9D6CqT34trD7NGBtfBYnnkZ5HpU8t4txZyrKztLjjnoM1lPAVydrBVPGR1ropJ2tI5cRJXvDqLpdt515GoYKxOQWbAz171vfEST7V4nW4B4e2iP/jtc/HGZMbch/Qd6t6uZHhsfMHIgHP8AwJu9bX1ucc0uSxX02/ksblJImOR1HY+1eiWWpQ3duhU4Yjke/wBa80tozJMqLwcEg/hXoOj25hsYgxydufpXNXity8PJ7Gup74qVAc9OaiQgVYjYZxXGzsWoqrjg07HNSL+lDnKAiouWUdRurexvbZpZlAPVD3B74rL1DUo7hGMD5QuTE2ecVBrtisl00sucuBtY9uOlYqZS1WNc5jJx710QimrmFSTWh09vqCTGO2kJNwiK24/xcVp3dy1jp8OoqpdIJF8xe+08Z/CuIM5XVFnUkY25/LFeoeFLW3vbOdbqBJYiq4WQZHeny2kjJz91mzpl/bX9st3ayK6SAZK/yPvWorZFYlt4O02O0jeyM9jOV5eCQjP1B4NTQ6XrVqcJqMNyo7TRbWP4j/Cug42aTheT3qlFZF7tpHGEyCOevtVmP7Rt/wBIiVHH91sg1IpPfiqsnYV2ilrmow6RYi/nVmigdWYKOSPauD1vxn/b/wAun2skaDrJIwH6V13jKEXXhq4iLbQ5Az6c15xaWNtZQkHMhPqcfyrtpW5TnqJ3K5ilWVi/Jzy2epqRWx1qe5gMSxyPwZBuC98djVcMK6G7nOlYkZ8DArLR/I1XeeAx3A4q87ALx0qlOFkwWYAA9fSpaurGkXyu56FptwJYNvfGRWX4lu8W32ZusjqT9Bn/ABqj4e1EMgUuCYzx7ipvE2LgiVOQNiAj1JrzOTlqWZ6fNzQujV0DwdDd+FLSSWXYzZJJByNzA5B+grFg1vUNTlNnC8Jt9PDJHI5H705wCd2K7vWLn+wvArEECSKHauR/ERgfzrzTw5ptpf6ZcQ3SshfG2df+WTc4+tVG7TkzJuzSRamtfFElvLD9ikjEvDuq8ke1LZ6Td2fhy8gmtZUKurA7cjA9629K8Qy2zxeH9amNrKuFjvA3yzJ2wexq54i+02IiiLGVWJZJVP3x3Bx3x+dbQdjKSvuee3CFtzLxkdPWqA69a19Vt2jfzoWLIeR6rWYIjKjngsBnjqfwr0ITTRwVIO4+KQg4z+dTbDuBHH8qzg5VvSrazy4+9kU5R7ExfRncWDEafACMHYKlySaq6c+bCAnqUH8qtHAPNebP4mfQUl+7j6CkjHNVXvI1fYg3t6CmXkpZSi52/wARXr9Km0qCOeYRiMJGoy394/U1m2bJGbqsEV3aF7k7ijAxqvY+/tXNXiCbESj5mboK9ba2sfI8preMRkc8YqCGx0602vbaYjsOFYrnH51Fm2UpKx57Y+D55YBqOpApaIBhM43fU1ehla9tTp1vFFHbfNgAcgV0fiC21DULZvN+WNBlQWwo/CuZj064t4XeJxuwRhTzUVJHRQh1scxPoCTW7NFMizIeA3AYf41l6ddTaRrFvcDK+W4yK3jeKoZJVXcMgnpWXLGl6ECgCQtjr1FXCb6nLVpRTvE9WUaZfudQtYoy0x3O+M/N3xRJjpVTTIfsenQW442IBirLcmtWShh4qKQ8ZqRjUT9DSGUU1JEuPKPQng1phw97o5H/AEFbL/0ojrn9Qj3cgYI6Yq3o88r3ukxyj5l1Sy59f9Jjpw+IzrfAz6WooorpPMCiiuL8WeJ9T0bX7ezgntbOwazaeW7uNNnuwrhwAp8p12DGTk8cUAdpRXHya9repal/Z3h+XSZnttPhu7i7mR2imaXdsWMK/wAoOxjuJbAI4NQ2/i/UfEC6LBoMNpb3N9YNfzveq0iQKCqbAqlSzFyRnIACk89KAO2rh/i9cNafDXULlApeKe1kUN0JFxGea6DwxrMmu6Il3cQrBdRyy29xEjZVZYnaN8H0ypI9iK4f4x+INFuPAeraNFq9g+p+dbp9jW4Qy5E8ZI2ZzwOelJ7DW54ZceJtQ1Zgbi0tm9CIsGnpqc9sd0+mRMT/ABSqT/M0uipJp10pubdgpTCllx19M1oeIEW6VZM9B6da5Hyp2senHna5r6lvQdV8y8ldrmzssRb1UxfK/wDs/Wuol1+3XTGvrhh5hZY2UkllQ9CPUdaxPhjp1trXjO3Se0jkgt7dmdWXcpwMAnPuRWr8UvA9/a3I1KwdnsD8pijj4gGR1x2oVO7uhyxCS5ZbnIeJJo9d1G4vfv8AmN+6P+wvAP44Ncza313od6Hhd4JFOVZTw3sfWt+38tlCRNlkGBmrdxpFvqkBjlXa/UMOqmhWXuvYhpy96O52Wk63a+I/DEpwvnCMrMg5w2P5GtXwbHdaewhll3Q+SQEI+6dw/OvEbHULvwnrzKCSoO117Ote3+E7+31SIXUMoeIqAOeR3IPvXm16ToX5fhZ3Uq0a8bS+JHnnxN0lrTXRqKxMILg4dwON3/6qg8Ia4NNutpBeFuI2P8JP8New6ppNlrNjLaXJDxuMcYOD6/WvAfEGlX/hzVZtMd3MKtuifHDL2IrpoSjXp+ze6OeTlQn7RbHV/EHUleexiUqzMpkJXkY7f1rjtNjE+qW6NkoAWO3r0zS3V62ptbPI7GZIyHOP89q0PDELTXkzqPmGyNAO2WH9M1pSp+ypchU6vtat+hlSPtLrzz61HI8rhAHb5a7Hxd4OudPke/tI2ktWO5wBkp7/AErC0S2glvVa5B8heXYDOBWr0VzGzk7Gc0kqfvCCCOme1bN59luvD0ErlUuVjBUevzNVrVbGO71cQ20iPb7sh05ABral8Ex6rp1obaYI0XyMQMhl68e4JNRzKUb7CqwcUcXoVi13ecY2gfjz/wDqrv44fLQDsBik0zw8mjwtHsbfuPzsPvDtVp0wPpWFSfM9BUo8qIR97FPWZFkC556fjSAZOaivYFgtIh/G8oLH/PtWVkbptF/cSOtOibDbSOtZgvreVmi83DDt0IqSzvJEmMU645+Vj0NRyMtSRb1HT1miTcN22sm2sIUjdHjUEOcHvXQrcq7rG+BnofWqd5EpmYnG3HpRC60HNJ6nJSWEguXTH3W5r0zwJl7edRyFIBrldXigtUFy7YyQOvU+ldz8MrHy9Hlmcg/aH3gei9q2g23dnJWtGNkdIoGwDHamODjIJB7EVZkhMUmzHHamhSpJ25FbSlY4ygreYCD98cEVGVINWLqPyJUnTGGO0r6U18MMiqhK6BnO+L2YaBMV6jHHrzXnNs374PcIzKpyV6Z9q9avI1kMCsAQZVBBrlfGGnxWpjuVUKp+VsDFdlGWljCoupyd1JJdTSXEpyzH8AO2Pas9jlhngVpttOFVsjHU96ryxqoJA5/lXQpGLiUJN6MO3FRSFGG4jHqOx+lXv3Yt9uG3g59sfT1qlKud2wjHdapMVirG72k4dWYHpjHaugs78zXdnAwyrTIxPrgg/wBK56SVtoR3fb1APOKls7+S0njlUqSpzg1FWnzK63NaVXl0ex0njXxHc6lc/wBnKB5EbZwo5Y10/gzQV/4RtxdqRJcSeZ/tLxgVi6DBE2n3esyIGmmcpHnnb64/lXpGmWPk6Tbow2ybMn8ea5ZLlp8qNk7z5jn7zw/Dc232S+gW5g7Ooww98dj9K4DWbPVvDdwsVvNdT6fzsEi7lUf0r2N0YcFcj1Ws+6gjLBuQVzxWUJOLNZLmR5fa6vaOFaYguvYjj/69Rahc6XJZhlj23KtlTGMbh713NxptlJu320Zz/sismXw7pRcsbb8AxxXVGavc53F2seZyyEylsdalhl7Z/CvT4bLTLWPbHZQ/igNYV3oMWo+IYHijWOORgrqgxx3P5V0wrp6M55UbaomsD/xL7f3jHH4VPI7heAM/WrWpraafdSRFXhhVisbbfk47ZqluVwGR1dT0KmvOnK8me7RX7uPoRjI61Y+1Cys5po5TGVG44UHNQMDjPasO+1OOKQb3IiIKkjt71m2aq3U6CDxlYW9tLczhppAQI48dfc54FZzeNNVv5pkWYW8eAyJEB0+prCtrCDUm/d3DG3UlmaRdo/PPP4Vcv9Pe3hgvYFiaMHysxtndxn86mTurFwg07lWTxBqf9phJ7iSdGIG124NaJ8RRxKxkiyAxA2nrWDOplkLRks4wwPt0xVWaUeWqFee5/wAKnkUjVVpQTVx2tXUdxcGaCExBxkgnr71Z8HWn2vWTLIMrAm7Hv2qhM8k6Rh8MEG0EDtXWeD9Oe0t7i4dceaQFz6D/APXW8FZWOWbcpXOnzg0vPUU0nFIGz0NUxETnDZNNLA0koyc5qJD1zSGRzqG6im6eANX0rH/QTsv/AEpjqWX7pI/WodPDf21pRI4Op2X/AKUx04fEjOt/DZ9K0UUV0nlhWPq7+IxPt0e30qSBo8F7yeRGR8nnaqMGGMcZXvzWxRQBwWm+Dtb8KrAfD9zYXLtp0Vlc/bi8Y3xlysq7Q3/PRhs44A5qe38Iaj4fXRZ9BltLi5sbBrCdL1mjSdSVfeGVWKsHBOMEEMRx1rtqKAMfwxo0mhaIlpcTLPdSSy3NxKi4VpZXaR8D0yxA9gKwfitJFB8P7qaQoqpdWbMzYAAFzGTya7asvX9KfWdOitUkWMpeW1wSwyCIp0kI/EIR+NA07O54rqPinw7rHh1oLnU7BboR4QGVDhh0PXiuPm1iCG0Nut1ptzxw32lBj8zX1ZsT+6v5UbE/ur+VYewidP1ua7HiXw517wb4Y0uWe+1/T11K7IMoWTPlqOi5/nXZP8S/A8iMj+IbBkYYIL5BFd3sT+6v5UbE/ur+VaqKWxhKbk7s+XvFUXhlNWa40LXbKaGUlwFmVGiPpzjIqC21Sx8tfN1GyWQdxcpg/rX1RsT+6v5UbE/ur+VS6UWXGvKOx8ha9Fp2ptHcR6jYidOCBcp8w/Oq2jarqfh27Eun6jYlc8obuPaw9xur7G2J/dX8qNif3V/Kh0ouPK9UL20ubmWjPA9J+I+m3USjUWtbObuyXUbKffg5rL8Z654d13SmWK9tJbxDmJhOgx68k9K+kNif3V/KjYn91fyrGODpxlzI2eMqNWdj4x02whkumS51Owt4mBy7XSH8OCauy29rpOowXel6vYzhWDlDcoMEHocnnp+tfYOxP7q/lWZr+kHWNOito2SNkvLa4LMuciKdJCPxCEfjW7ppu5iqzStY8ktPG3hyW0j+06rZRs6YeNplOMjkcHBrn7R/CsEsgTWtD8oyFkaZiWUHscDmvo7Yn91fyo2J/dX8ql0ovc0jipx2PDrCbwFHMJLvxlZFDy8NsgiDe2eTiprnxZ4SjvbhbLVrBLXcPKCygADaB0/A17XsT+6v5UbE/ur+VDow5eVIiVepN3k7nhU3ivw5Ku06zYn/ALbLWPc67om791q9k4P/AE3X/Gvo3Yn91fyo2J/dX8qzeFgNV5I+af7c0oAkanZZ/wCvhP8AGkvdW0m8ijxrVjG6nP8Ar1P9a+l9if3V/KjYn91fypfVIFfWpnyXdNZFwYNYsCSfmY3Kj+tattrViqBZ9SsCR1YXCc/rX0/sT+6v5UbE/ur+VU8NBoSxE0fNUmr6Q8R2azZKw+ZMzrkH86bN4h06SDJ1GyLYHyi4TP8AOvpfYn91fyrM1/SDrGnRW0bJGyXltcFmXORFOkhH4hCPxqVhIIr63M+W9avzqM0Uh1XT2jVeIluUG36knmvVvBHjPwnonhm2tbvXrFLkZMgMgOCe2RXsOxP7q/lRsT+6v5Vf1eJlKrKW559L8R/BMq4PiGx9jv6VCvxD8GA4bxFZFfaTmvR9if3V/KjYn91fyoeHg9yOZnl934+8HTYA8QWLY6N5mCKpHx34Wx/yHbHPqJRXruxP7q/lRsT+6v5URw8Y7Bzs8bk8b+GGkhI1yywsgY/vR0rJ8WeLNC1Ky8qz1ewkO7JBmUcfia962J/dX8qNif3V/KtYwUdiZanytDqNjGRnUbLb6G5Tj9ambU9MKkDUbL/wIT/GvqPYn91fyo2J/dX8qp6kqKR8ove6eWB+3WRweP8ASU/xqtc3No7iSK/sVcDn/SY+fr81fW+xP7q/lWZr+kHWNOito2SNkvLa4LMuciKdJCPxCEfjTTDlR8rXc9pNEqx3dnvzkk3Ufp/vVJp9rpc+77ZrdjbYI2/vkfPPPRq+uNif3V/KjYn91fyp8zDkW580aLqel6Lq0UEuu6dd6S8oZws4BT3wa9Gf4g+ET93X7H/v5XqOxP7q/lRsT+6v5VnKKluWnY8nbx54TLZGvWQPr5opZvG/g6eEq+v2O4Dj95zmvV9if3V/KjYn91fyqfZRHzM8IuPFXh4k7NbsWH/XYCqcnifQyONWsj/23X/GvoPYn91fyo2J/dX8qpRSFc+c38RaOemq2X/gQv8AjS2XiHRo7+GSTVbIIpyT56/419F7E/ur+VGxP7q/lTsI8O/4SvwvNDIk2r2DBnY4aVSCCa5+7bwo0pm07xFZ2cndfNDI34V9I7E/ur+VZmv6QdY06K2jZI2S8trgsy5yIp0kI/EIR+NS6aZrGtKOx86nWLFH8uTVNNkH/PSK5XB/A4NY+tNpd2glgv7JpAfmQXKDePrnivrXYn91fyo2J/dX8qn2UTT61PyPkiyjtbpx52taVZKBgB7oNj24zXZIvgyPwy9jL4ssZ73JkjlVtqo2MAepBr6F2J/dX8qNif3V/KhUoobxlV2Pj6SWFJFMd5Yle4+1R9jn1q5qCaTcL5keo2KuORGLlMZ/OvrXYn91fyo2J/dX8qSoRSsVLG1JO9kfIOliyhuEee+sV2cj/SYyM/nXZafqugfJDJrdhbxL/E0wJP4CvozYn91fyo2J/dX8qpU0iHipvojwK81zwoiqsGr2M3q/ngGs99e0Icx6nZ5xjm4X/Gvo3Yn91fyo2J/dX8qfs0H1qfZHzZ/bmkEnOq2Q/wC3hP8AGon1jSMcapZf+BCf419MbE/ur+VZmv6QdY06K2jZI2S8trgsy5yIp0kI/EIR+NL2aH9bn2R86f21pu7/AJCNlj/r5T/GrNhqenT6xpEcN9ayStqlnhI5lYn/AEiMngH2r6V2J/dX8qNif3V/KmqaTuTPESkrMdRRRVnOFFFFABRRRQAVzPiG91GXxBpGg6bemwa8jnuJ7pI1d1ji2DaocFclpF5IPANdNWJruhT6leWGo2F8LHUbEyCKV4fNRkcAOjJuUkHap4IIKigCLwjqd5qFhewahIs13p99LZSTqgQTbSCr7RwCVZcgcZziugrK8P6INC054GuWurieeS5ubhlCmWVzljtHAHQAdgBWrQAUUUUAFFFFABRRRQAUUUUAcd4zm1jR7C81i08QPEybVstN+yxuk8pACxEkF2LtkfKRjPtTr261vWfFF5pGnaodKTT7GGeR0hSVpJpS+1TvBGxRHzjBO7qMU7UvDGt3fiv+27fXLEJFGEs7a701phbZGHZSsyAs3PzEZA4HGc2dT8N6hPqrappWsrp95Para3TG181JFUsVZV3DawLvgkkc8g4oAw9O8R6v4tOhWlpe/wBkyXOmNf3k0ESSNvDrGEQOCAu7cSSCcADjrXR+ENVutX0HzL8o17b3E9nO8a7Vd4pWjLAds7c47ZqifBbWEektoGo/YLnTbQ2SyTwees0J2kh13L825QwII5J6g1saBo0egaPFp8czzsrPJLNIAGlkdi7ucerMTjtQBp0UUUAFFFFABRRRQAUUUUAcn4112/tLC7stElEepRWcl5LOUDi2iRSQSDwWYrtUH/aPO3BoW2oa94jv1sLHWDp32TSrW6mmS3jkaaeYPgEMCAgEZJC4J3dRitrxH4K0LxLBdG90yye+mt2hS8lt1keLIIUgnngnPWs6HwLLpC258N6nFpUgslsrjbZh0lClmDqu4bX3O5zkj5uQaAKOneI9X8WnQrS0vf7JkudMa/vJoIkkbeHWMIgcEBd24kkE4AHHWuj8IardavoPmX5Rr23uJ7Od412q7xStGWA7Z25x2zVE+C2sI9JbQNR+wXOm2hslkng89ZoTtJDruX5tyhgQRyT1BrY0DRo9A0eLT45nnZWeSWaQANLI7F3c49WYnHagDTooooAKKKKACiiigAooooA8517xZqD+KdX061m1W2s9Hjia4k02zimbLpvLOZcjaFIwqAscMfStSfUNT8QeIW03Rtb+w2ttpsN4bqKCORp3mLhOHBATEZJxgnd1GKs6p4Tu7jU9RvNL1gaeuqQpDfI1sJS21SodDuGxtpxkhhwOKSfwhPa3NtceHtVGmSRWCae/mW4nV4Uz5ZxuXDrlsHkc8g0AZGneI9Y8Vf2BZW14NLmudPlvb2eCJJG3RusWxA4IALFjkgnAA75ro/COq3eq6LIb9ke9tLueynkjXasjRSMm8DtkAHHbNUf+ELNhBo50LUfsN3pls1os08PnrNE20sHXcuTuUNkEc57HFbPh/RY9B0hLJZ3uJDJJNNPIAGlldi7sQOmWY8dulAGnRRRQAUUUUAFFFFABRRRQB5r4w8U6lpmt6tAurXFitpZxzWUVtZLcJMxDZ89ireUu4AcmMYyd3XGvJe67rmvf2VZ6oulfZdMgu55beJJvMmlLgKN4I2DyyeME5HIqzqXhPUJtR1W40zW1sotWRVu45LQTHKp5e6Ntw2naAOQw4zikm8H3FpPaz+H9W/s6WGwj05zNbi4EkUedhxuXDrlsHkc8g0AZOneI9Y8Vf2BZW14NLmudPlvb2eCJJG3RusWxA4IALFjkgnAA75ro/COq3eq6LIb9ke9tLueynkjXasjRSMm8DtkAHHbNUf8AhCzYQaOdC1H7Dd6ZbNaLNPD56zRNtLB13Lk7lDZBHOexxWz4f0WPQdISyWd7iQySTTTyABpZXYu7EDplmPHbpQBp0UUUAFFFFABRRRQAVBeRTz2csVtcm2nZcJMED7D64PB/Gp6hu0uJLSVLSaOG4ZSI5JI/MVW7ErkZHtkUAcJb+I9ZtfA19NJei71RdZk0q3uZolUZN15COyoAOAc474pdR8R6v4RbXbW8vf7Wa20oahaTTRJG2/cUKOEABXdsIIAOCRz1qzZ+BdRGi6lpepa7DcQ3dy97HJbWJhkguGm84OCZHBAfoMfjVweDGv01Z/EGojULjUbMWLPDB5CxQjccIu5vm3MWJJPIHAxQBSk1bWPCmrJb6vqZ1aC4025u9zQJE0csAQsq7APkYPxnJG3qc0zS9T1+yu/DNxqmqLeQ68Cktv5CIttIYWmXyyo3FQEKncSTkHitOy8KXT6h9s1/VRqrpZvZQqtsIVWN8eYWG5tzttUEjA44AzUek+D7qyvdLe/1lr610dGTT4fs4jZcpsDSNuO9ghKggL1JwTQB1lFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAf/Z")||m(Zs,"src",Qa),xs(Ws.src,ln="data:image/jpeg;base64,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")||m(Ws,"src",ln),xs(Vs.src,Tn="data:image/jpeg;base64,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")||m(Vs,"src",Tn)},m(e,s){Qn(document.head,d),l(e,zs,s),l(e,Ks,s),l(e,Ns,s),M(U,e,s),l(e,Ds,s),M(f,e,s),l(e,Es,s),l(e,g,s),l(e,Fs,s),l(e,I,s),l(e,Os,s),M(J,e,s),l(e,Qs,s),l(e,b,s),l(e,qs,s),l(e,T,s),l(e,Ls,s),l(e,R,s),l(e,Ys,s),M(h,e,s),l(e,_s,s),l(e,B,s),l(e,$s,s),l(e,H,s),l(e,et,s),M(k,e,s),l(e,st,s),M(v,e,s),l(e,tt,s),l(e,C,s),l(e,lt,s),M(G,e,s),l(e,at,s),M(P,e,s),l(e,nt,s),M(X,e,s),l(e,At,s),l(e,Z,s),l(e,pt,s),M(W,e,s),l(e,ot,s),l(e,V,s),l(e,it,s),M(x,e,s),l(e,rt,s),l(e,Gs,s),l(e,Mt,s),l(e,K,s),l(e,jt,s),M(S,e,s),l(e,ct,s),l(e,z,s),l(e,yt,s),l(e,N,s),l(e,wt,s),l(e,D,s),l(e,ut,s),M(E,e,s),l(e,dt,s),l(e,F,s),l(e,mt,s),M(O,e,s),l(e,Ut,s),l(e,Q,s),l(e,ft,s),M(q,e,s),l(e,gt,s),l(e,Ps,s),l(e,It,s),l(e,L,s),l(e,Jt,s),M(Y,e,s),l(e,bt,s),l(e,_,s),l(e,Tt,s),M($,e,s),l(e,Rt,s),l(e,Xs,s),l(e,ht,s),l(e,ee,s),l(e,Bt,s),M(se,e,s),l(e,Ht,s),l(e,te,s),l(e,kt,s),l(e,le,s),l(e,vt,s),l(e,ae,s),l(e,Ct,s),M(ne,e,s),l(e,Gt,s),l(e,Ae,s),l(e,Pt,s),l(e,pe,s),l(e,Xt,s),l(e,oe,s),l(e,Zt,s),M(ie,e,s),l(e,Wt,s),l(e,re,s),l(e,Vt,s),l(e,Me,s),l(e,xt,s),l(e,je,s),l(e,Kt,s),M(ce,e,s),l(e,St,s),l(e,ye,s),l(e,zt,s),l(e,we,s),l(e,Nt,s),l(e,ue,s),l(e,Dt,s),M(de,e,s),l(e,Et,s),l(e,me,s),l(e,Ft,s),M(Ue,e,s),l(e,Ot,s),l(e,fe,s),l(e,Qt,s),M(ge,e,s),l(e,qt,s),l(e,Zs,s),l(e,Lt,s),l(e,Ie,s),l(e,Yt,s),M(Je,e,s),l(e,_t,s),l(e,be,s),l(e,$t,s),M(Te,e,s),l(e,el,s),M(Re,e,s),l(e,sl,s),M(he,e,s),l(e,tl,s),l(e,Be,s),l(e,ll,s),M(He,e,s),l(e,al,s),l(e,ke,s),l(e,nl,s),M(ve,e,s),l(e,Al,s),l(e,Ce,s),l(e,pl,s),l(e,Ge,s),l(e,ol,s),M(Pe,e,s),l(e,il,s),l(e,Xe,s),l(e,rl,s),l(e,Ze,s),l(e,Ml,s),M(We,e,s),l(e,jl,s),l(e,Ws,s),l(e,cl,s),l(e,Ve,s),l(e,yl,s),l(e,xe,s),l(e,wl,s),M(Ke,e,s),l(e,ul,s),l(e,Se,s),l(e,dl,s),l(e,ze,s),l(e,ml,s),M(Ne,e,s),l(e,Ul,s),l(e,De,s),l(e,fl,s),l(e,Ee,s),l(e,gl,s),l(e,Fe,s),l(e,Il,s),M(Oe,e,s),l(e,Jl,s),l(e,Qe,s),l(e,bl,s),l(e,qe,s),l(e,Tl,s),M(Le,e,s),l(e,Rl,s),l(e,Ye,s),l(e,hl,s),l(e,_e,s),l(e,Bl,s),M($e,e,s),l(e,Hl,s),M(es,e,s),l(e,kl,s),l(e,ss,s),l(e,vl,s),l(e,ts,s),l(e,Cl,s),l(e,ls,s),l(e,Gl,s),l(e,as,s),l(e,Pl,s),l(e,ns,s),l(e,Xl,s),M(As,e,s),l(e,Zl,s),l(e,ps,s),l(e,Wl,s),M(os,e,s),l(e,Vl,s),l(e,is,s),l(e,xl,s),l(e,rs,s),l(e,Kl,s),l(e,Ms,s),l(e,Sl,s),M(js,e,s),l(e,zl,s),l(e,Vs,s),l(e,Nl,s),l(e,cs,s),l(e,Dl,s),l(e,ys,s),l(e,El,s),M(ws,e,s),l(e,Fl,s),l(e,us,s),l(e,Ol,s),l(e,ds,s),l(e,Ql,s),l(e,ms,s),l(e,ql,s),M(Us,e,s),l(e,Ll,s),M(fs,e,s),l(e,Yl,s),l(e,gs,s),l(e,_l,s),l(e,Is,s),l(e,$l,s),l(e,Js,s),l(e,ea,s),l(e,bs,s),l(e,sa,s),l(e,Ts,s),l(e,ta,s),M(Rs,e,s),l(e,la,s),l(e,hs,s),l(e,aa,s),l(e,Bs,s),l(e,na,s),l(e,Hs,s),l(e,Aa,s),l(e,ks,s),l(e,pa,s),l(e,vs,s),l(e,oa,s),M(Cs,e,s),l(e,ia,s),l(e,Ss,s),ra=!0},p:Nn,i(e){ra||(j(U.$$.fragment,e),j(f.$$.fragment,e),j(J.$$.fragment,e),j(h.$$.fragment,e),j(k.$$.fragment,e),j(v.$$.fragment,e),j(G.$$.fragment,e),j(P.$$.fragment,e),j(X.$$.fragment,e),j(W.$$.fragment,e),j(x.$$.fragment,e),j(S.$$.fragment,e),j(E.$$.fragment,e),j(O.$$.fragment,e),j(q.$$.fragment,e),j(Y.$$.fragment,e),j($.$$.fragment,e),j(se.$$.fragment,e),j(ne.$$.fragment,e),j(ie.$$.fragment,e),j(ce.$$.fragment,e),j(de.$$.fragment,e),j(Ue.$$.fragment,e),j(ge.$$.fragment,e),j(Je.$$.fragment,e),j(Te.$$.fragment,e),j(Re.$$.fragment,e),j(he.$$.fragment,e),j(He.$$.fragment,e),j(ve.$$.fragment,e),j(Pe.$$.fragment,e),j(We.$$.fragment,e),j(Ke.$$.fragment,e),j(Ne.$$.fragment,e),j(Oe.$$.fragment,e),j(Le.$$.fragment,e),j($e.$$.fragment,e),j(es.$$.fragment,e),j(As.$$.fragment,e),j(os.$$.fragment,e),j(js.$$.fragment,e),j(ws.$$.fragment,e),j(Us.$$.fragment,e),j(fs.$$.fragment,e),j(Rs.$$.fragment,e),j(Cs.$$.fragment,e),ra=!0)},o(e){c(U.$$.fragment,e),c(f.$$.fragment,e),c(J.$$.fragment,e),c(h.$$.fragment,e),c(k.$$.fragment,e),c(v.$$.fragment,e),c(G.$$.fragment,e),c(P.$$.fragment,e),c(X.$$.fragment,e),c(W.$$.fragment,e),c(x.$$.fragment,e),c(S.$$.fragment,e),c(E.$$.fragment,e),c(O.$$.fragment,e),c(q.$$.fragment,e),c(Y.$$.fragment,e),c($.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(ce.$$.fragment,e),c(de.$$.fragment,e),c(Ue.$$.fragment,e),c(ge.$$.fragment,e),c(Je.$$.fragment,e),c(Te.$$.fragment,e),c(Re.$$.fragment,e),c(he.$$.fragment,e),c(He.$$.fragment,e),c(ve.$$.fragment,e),c(Pe.$$.fragment,e),c(We.$$.fragment,e),c(Ke.$$.fragment,e),c(Ne.$$.fragment,e),c(Oe.$$.fragment,e),c(Le.$$.fragment,e),c($e.$$.fragment,e),c(es.$$.fragment,e),c(As.$$.fragment,e),c(os.$$.fragment,e),c(js.$$.fragment,e),c(ws.$$.fragment,e),c(Us.$$.fragment,e),c(fs.$$.fragment,e),c(Rs.$$.fragment,e),c(Cs.$$.fragment,e),ra=!1},d(e){e&&(t(zs),t(Ks),t(Ns),t(Ds),t(Es),t(g),t(Fs),t(I),t(Os),t(Qs),t(b),t(qs),t(T),t(Ls),t(R),t(Ys),t(_s),t(B),t($s),t(H),t(et),t(st),t(tt),t(C),t(lt),t(at),t(nt),t(At),t(Z),t(pt),t(ot),t(V),t(it),t(rt),t(Gs),t(Mt),t(K),t(jt),t(ct),t(z),t(yt),t(N),t(wt),t(D),t(ut),t(dt),t(F),t(mt),t(Ut),t(Q),t(ft),t(gt),t(Ps),t(It),t(L),t(Jt),t(bt),t(_),t(Tt),t(Rt),t(Xs),t(ht),t(ee),t(Bt),t(Ht),t(te),t(kt),t(le),t(vt),t(ae),t(Ct),t(Gt),t(Ae),t(Pt),t(pe),t(Xt),t(oe),t(Zt),t(Wt),t(re),t(Vt),t(Me),t(xt),t(je),t(Kt),t(St),t(ye),t(zt),t(we),t(Nt),t(ue),t(Dt),t(Et),t(me),t(Ft),t(Ot),t(fe),t(Qt),t(qt),t(Zs),t(Lt),t(Ie),t(Yt),t(_t),t(be),t($t),t(el),t(sl),t(tl),t(Be),t(ll),t(al),t(ke),t(nl),t(Al),t(Ce),t(pl),t(Ge),t(ol),t(il),t(Xe),t(rl),t(Ze),t(Ml),t(jl),t(Ws),t(cl),t(Ve),t(yl),t(xe),t(wl),t(ul),t(Se),t(dl),t(ze),t(ml),t(Ul),t(De),t(fl),t(Ee),t(gl),t(Fe),t(Il),t(Jl),t(Qe),t(bl),t(qe),t(Tl),t(Rl),t(Ye),t(hl),t(_e),t(Bl),t(Hl),t(kl),t(ss),t(vl),t(ts),t(Cl),t(ls),t(Gl),t(as),t(Pl),t(ns),t(Xl),t(Zl),t(ps),t(Wl),t(Vl),t(is),t(xl),t(rs),t(Kl),t(Ms),t(Sl),t(zl),t(Vs),t(Nl),t(cs),t(Dl),t(ys),t(El),t(Fl),t(us),t(Ol),t(ds),t(Ql),t(ms),t(ql),t(Ll),t(Yl),t(gs),t(_l),t(Is),t($l),t(Js),t(ea),t(bs),t(sa),t(Ts),t(ta),t(la),t(hs),t(aa),t(Bs),t(na),t(Hs),t(Aa),t(ks),t(pa),t(vs),t(oa),t(ia),t(Ss)),t(d),y(U,e),y(f,e),y(J,e),y(h,e),y(k,e),y(v,e),y(G,e),y(P,e),y(X,e),y(W,e),y(x,e),y(S,e),y(E,e),y(O,e),y(q,e),y(Y,e),y($,e),y(se,e),y(ne,e),y(ie,e),y(ce,e),y(de,e),y(Ue,e),y(ge,e),y(Je,e),y(Te,e),y(Re,e),y(he,e),y(He,e),y(ve,e),y(Pe,e),y(We,e),y(Ke,e),y(Ne,e),y(Oe,e),y(Le,e),y($e,e),y(es,e),y(As,e),y(os,e),y(js,e),y(ws,e),y(Us,e),y(fs,e),y(Rs,e),y(Cs,e)}}}const _n='{"title":"Fine-Tuning and Guidance","local":"fine-tuning-and-guidance","sections":[{"title":"What You Will Learn:","local":"what-you-will-learn","sections":[],"depth":2},{"title":"Setup and Imports","local":"setup-and-imports","sections":[],"depth":2},{"title":"Loading A Pre-Trained Pipeline","local":"loading-a-pre-trained-pipeline","sections":[],"depth":2},{"title":"Faster Sampling with DDIM","local":"faster-sampling-with-ddim","sections":[],"depth":2},{"title":"Fine-Tuning","local":"fine-tuning","sections":[{"title":"Code for fine-tuning a model using the minimal example script we used on the WikiArt demo model","local":"code-for-fine-tuning-a-model-using-the-minimal-example-script-we-used-on-the-wikiart-demo-model","sections":[],"depth":3},{"title":"Saving and Loading Fine-Tuned Pipelines","local":"saving-and-loading-fine-tuned-pipelines","sections":[],"depth":3}],"depth":2},{"title":"Guidance","local":"guidance","sections":[],"depth":2},{"title":"CLIP Guidance","local":"clip-guidance","sections":[],"depth":2},{"title":"Sharing A Custom Sampling Loop as a Gradio Demo","local":"sharing-a-custom-sampling-loop-as-a-gradio-demo","sections":[],"depth":2},{"title":"Summary and Next Steps","local":"summary-and-next-steps","sections":[],"depth":2}],"depth":1}';function $n(Ma){return Dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nA extends En{constructor(d){super(),Fn(this,d,$n,Yn,zn,{})}}export{nA as component};
