import{s as Ct,n as Wt,o as Gt}from"../chunks/scheduler.85c25b89.js";import{S as Bt,i as Nt,g as p,s as a,r as m,A as vt,h as i,f as l,c as n,j as Zt,u as o,x as M,k as xt,y as kt,a as e,v as c,d as r,t as h,w as g}from"../chunks/index.c9837788.js";import{C as _}from"../chunks/CodeBlock.e573519b.js";import{H as z,E as Et}from"../chunks/getInferenceSnippets.a0ed60cb.js";function Qt(Jt){let J,H,R,Y,j,A,d,jt='<strong>Xception</strong> is a convolutional neural network architecture that relies solely on <a href="https://paperswithcode.com/method/depthwise-separable-convolution" rel="nofollow">depthwise separable convolution</a> layers.',S,u,dt='The weights from this model were ported from <a href="https://cv.gluon.ai/model_zoo/classification.html" rel="nofollow">Gluon</a>.',F,w,L,y,ut="To load a pretrained model:",D,T,P,f,wt="To load and preprocess the image:",q,b,K,U,yt="To get the model predictions:",O,$,tt,I,Tt="To get the top-5 predictions class names:",st,Z,lt,x,ft="Replace the model name with the variant you want to use, e.g. <code>gluon_xception65</code>. You can find the IDs in the model summaries at the top of this page.",et,C,bt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',at,W,nt,G,Ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",pt,B,it,N,$t=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,mt,v,ot,k,It='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',ct,E,rt,Q,ht,X,gt,V,Mt;return j=new z({props:{title:"(Gluon) Xception",local:"gluon-xception",headingTag:"h1"}}),w=new z({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new _({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2dsdW9uX3hjZXB0aW9uNjUnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_xception65&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new _({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),$=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),Z=new _({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new z({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new _({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZ2x1b25feGNlcHRpb242NSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;gluon_xception65&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),v=new z({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new z({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new _({props:{code:"JTQwbWlzYyU3QmNob2xsZXQyMDE3eGNlcHRpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB0aXRsZSUzRCU3QlhjZXB0aW9uJTNBJTIwRGVlcCUyMExlYXJuaW5nJTIwd2l0aCUyMERlcHRod2lzZSUyMFNlcGFyYWJsZSUyMENvbnZvbHV0aW9ucyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QkZyYW4lQzMlQTdvaXMlMjBDaG9sbGV0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxNjEwLjAyMzU3JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{chollet2017xception,
      title={Xception: Deep Learning with Depthwise Separable Convolutions}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{François Chollet}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2017}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1610.02357}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),X=new Et({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/gloun-xception.mdx"}}),{c(){J=p("meta"),H=a(),R=p("p"),Y=a(),m(j.$$.fragment),A=a(),d=p("p"),d.innerHTML=jt,S=a(),u=p("p"),u.innerHTML=dt,F=a(),m(w.$$.fragment),L=a(),y=p("p"),y.textContent=ut,D=a(),m(T.$$.fragment),P=a(),f=p("p"),f.textContent=wt,q=a(),m(b.$$.fragment),K=a(),U=p("p"),U.textContent=yt,O=a(),m($.$$.fragment),tt=a(),I=p("p"),I.textContent=Tt,st=a(),m(Z.$$.fragment),lt=a(),x=p("p"),x.innerHTML=ft,et=a(),C=p("p"),C.innerHTML=bt,at=a(),m(W.$$.fragment),nt=a(),G=p("p"),G.textContent=Ut,pt=a(),m(B.$$.fragment),it=a(),N=p("p"),N.innerHTML=$t,mt=a(),m(v.$$.fragment),ot=a(),k=p("p"),k.innerHTML=It,ct=a(),m(E.$$.fragment),rt=a(),m(Q.$$.fragment),ht=a(),m(X.$$.fragment),gt=a(),V=p("p"),this.h()},l(t){const s=vt("svelte-u9bgzb",document.head);J=i(s,"META",{name:!0,content:!0}),s.forEach(l),H=n(t),R=i(t,"P",{}),Zt(R).forEach(l),Y=n(t),o(j.$$.fragment,t),A=n(t),d=i(t,"P",{"data-svelte-h":!0}),M(d)!=="svelte-2dpud"&&(d.innerHTML=jt),S=n(t),u=i(t,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1vag5uc"&&(u.innerHTML=dt),F=n(t),o(w.$$.fragment,t),L=n(t),y=i(t,"P",{"data-svelte-h":!0}),M(y)!=="svelte-18ywhxh"&&(y.textContent=ut),D=n(t),o(T.$$.fragment,t),P=n(t),f=i(t,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1c2ipa8"&&(f.textContent=wt),q=n(t),o(b.$$.fragment,t),K=n(t),U=i(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1n9qsq1"&&(U.textContent=yt),O=n(t),o($.$$.fragment,t),tt=n(t),I=i(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=Tt),st=n(t),o(Z.$$.fragment,t),lt=n(t),x=i(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-zau0t5"&&(x.innerHTML=ft),et=n(t),C=i(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1wmi3ea"&&(C.innerHTML=bt),at=n(t),o(W.$$.fragment,t),nt=n(t),G=i(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-9sr7nh"&&(G.textContent=Ut),pt=n(t),o(B.$$.fragment,t),it=n(t),N=i(t,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1kguc51"&&(N.innerHTML=$t),mt=n(t),o(v.$$.fragment,t),ot=n(t),k=i(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-xtxxu6"&&(k.innerHTML=It),ct=n(t),o(E.$$.fragment,t),rt=n(t),o(Q.$$.fragment,t),ht=n(t),o(X.$$.fragment,t),gt=n(t),V=i(t,"P",{}),Zt(V).forEach(l),this.h()},h(){xt(J,"name","hf:doc:metadata"),xt(J,"content",Xt)},m(t,s){kt(document.head,J),e(t,H,s),e(t,R,s),e(t,Y,s),c(j,t,s),e(t,A,s),e(t,d,s),e(t,S,s),e(t,u,s),e(t,F,s),c(w,t,s),e(t,L,s),e(t,y,s),e(t,D,s),c(T,t,s),e(t,P,s),e(t,f,s),e(t,q,s),c(b,t,s),e(t,K,s),e(t,U,s),e(t,O,s),c($,t,s),e(t,tt,s),e(t,I,s),e(t,st,s),c(Z,t,s),e(t,lt,s),e(t,x,s),e(t,et,s),e(t,C,s),e(t,at,s),c(W,t,s),e(t,nt,s),e(t,G,s),e(t,pt,s),c(B,t,s),e(t,it,s),e(t,N,s),e(t,mt,s),c(v,t,s),e(t,ot,s),e(t,k,s),e(t,ct,s),c(E,t,s),e(t,rt,s),c(Q,t,s),e(t,ht,s),c(X,t,s),e(t,gt,s),e(t,V,s),Mt=!0},p:Wt,i(t){Mt||(r(j.$$.fragment,t),r(w.$$.fragment,t),r(T.$$.fragment,t),r(b.$$.fragment,t),r($.$$.fragment,t),r(Z.$$.fragment,t),r(W.$$.fragment,t),r(B.$$.fragment,t),r(v.$$.fragment,t),r(E.$$.fragment,t),r(Q.$$.fragment,t),r(X.$$.fragment,t),Mt=!0)},o(t){h(j.$$.fragment,t),h(w.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h($.$$.fragment,t),h(Z.$$.fragment,t),h(W.$$.fragment,t),h(B.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),h(Q.$$.fragment,t),h(X.$$.fragment,t),Mt=!1},d(t){t&&(l(H),l(R),l(Y),l(A),l(d),l(S),l(u),l(F),l(L),l(y),l(D),l(P),l(f),l(q),l(K),l(U),l(O),l(tt),l(I),l(st),l(lt),l(x),l(et),l(C),l(at),l(nt),l(G),l(pt),l(it),l(N),l(mt),l(ot),l(k),l(ct),l(rt),l(ht),l(gt),l(V)),l(J),g(j,t),g(w,t),g(T,t),g(b,t),g($,t),g(Z,t),g(W,t),g(B,t),g(v,t),g(E,t),g(Q,t),g(X,t)}}}const Xt='{"title":"(Gluon) Xception","local":"gluon-xception","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function _t(Jt){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends Bt{constructor(J){super(),Nt(this,J,_t,Qt,Ct,{})}}export{Yt as component};
